/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.alwayz;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.QuestListDto;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.data.alwayz.ShopAlwayzQuestionContext;
import java.io.IOException;
import java.net.URLEncoder;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ShopAlwayzQuestionSearch
extends ShopAlwayzQuestionContext {
    @Override
    public List<QuestListDto> excute(List<QuestListDto> questListDto) throws Exception {
        ArrayList<QuestListDto> dtoArray = new ArrayList<QuestListDto>();
        try {
            String listtp = questListDto.get(0).getBtnstats().equals("\uc804\uccb4") ? "00" : (questListDto.get(0).getBtnstats().equals("\ubb38\uc758") ? "01" : "02");
            Map<String, String> loginInfo = IShopCommonLogin.loginAlwayzInfo(questListDto.get(0).getShopid(), questListDto.get(0).getShopPw(), "shop9984");
            String json = "";
            Iterator<QuestListDto> iterator = questListDto.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                if (listtp.equals("00")) {
                    json = "{\"type\":\"ITEM_QUESTION\"}";
                    this.Allinquiry(loginInfo, questListDto, json, dtoArray);
                    json = "{\"type\":\"QUESTION_FROM_ADMIN\"}";
                    this.Allinquiry(loginInfo, questListDto, json, dtoArray);
                    continue;
                }
                if (listtp.equals("01")) {
                    json = "{\"type\":\"ITEM_QUESTION\"}";
                    this.Allinquiry(loginInfo, questListDto, json, dtoArray);
                    continue;
                }
                if (!listtp.equals("02")) continue;
                json = "{\"type\":\"QUESTION_FROM_ADMIN\"}";
                this.Allinquiry(loginInfo, questListDto, json, dtoArray);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dtoArray;
    }

    private List<QuestListDto> Allinquiry(Map<String, String> loginInfo, List<QuestListDto> questListDto, String json, List<QuestListDto> dtoArray) throws IOException {
        try {
            String url = "https://alwayz-seller-back.ilevit.com/sellers/questions-by-condition?condition=" + URLEncoder.encode(json, "UTF-8") + "&limit=-1&skip=0";
            Connection.Response rs = Jsoup.connect((String)url).header("Connection", "keep-alive").header("x-access-token", loginInfo.get("token")).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            String body = rs.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            int status2 = jsonObject.get("status").getAsInt();
            if (status2 == 200) {
                JsonArray dataArray = (JsonArray)jsonObject.get("data");
                if (dataArray.size() == 0) {
                    return dtoArray;
                }
                this.setNewOrdersData(dataArray, questListDto, dtoArray);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dtoArray;
    }

    private List<QuestListDto> setNewOrdersData(JsonArray dataArray, List<QuestListDto> questListDto, List<QuestListDto> dtoArray) throws Exception {
        try {
            int i = 0;
            while (i < dataArray.size()) {
                QuestListDto dto = new QuestListDto();
                JsonObject object = (JsonObject)dataArray.get(i);
                JsonObject questionInfo = (JsonObject)object.get("questionInfo");
                dto.setQuests(questionInfo.get("text").getAsString());
                dto.setStat(questionInfo.get("type").getAsString().equals("item") ? "\uc0c1\ud488\ubb38\uc758" : (questionInfo.get("type").getAsString().equals("order") ? "\uc8fc\ubb38\ubb38\uc758" : ""));
                dto.setInsnm(questionInfo.get("userName").getAsString());
                dto.setQnaseq(questionInfo.get("questionId").getAsString());
                dto.setMprodid(object.get("itemId").getAsString());
                dto.setQgubun(questionInfo.get("type").getAsString().equals("order") ? questionInfo.get("mainReason").getAsString() : "\uc0c1\ud488 \ubb38\uc758");
                dto.setInsdm(this.dateFormat(questionInfo.get("createdAt").getAsString()));
                dto.setRegdm(YDMATimeUtil.getCurrentTime());
                dto.setShopid(questListDto.get(0).getShopid());
                dto.setShopnm(questListDto.get(0).getShopnm());
                dto.setProdnm(questionInfo.get("itemTitle").getAsString());
                dto.setSubject(questionInfo.has("title") ? questionInfo.get("title").getAsString() : "\ubb38\uc758");
                dto.setOrdid(questionInfo.has("orderId") ? questionInfo.get("orderId").getAsString() : "");
                if (object.has("answerInfo")) {
                    JsonObject answerInfo = (JsonObject)object.get("answerInfo");
                    dto.setQnastat("103");
                    dto.setAnsws(answerInfo.get("text").getAsString());
                    dto.setSenddt(this.dateFormat(answerInfo.get("createdAt").getAsString()));
                } else {
                    dto.setQnastat("100");
                }
                dtoArray.add(dto);
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc62c\uc6e8\uc774\uc988 \uace0\uac1d\ubb38\uc758 \uc218\uc9d1 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtoArray;
    }

    private String dateFormat(String inputDate) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(inputDate, inputFormatter);
        String formattedDate = zonedDateTime.format(outputFormatter);
        return formattedDate;
    }
}

