/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.jcef;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.cef.callback.CefCookieVisitor;
import org.cef.misc.BoolRef;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager;

public class CookieMapModel
implements CefCookieVisitor {
    private final CefCookieManager manager;
    private ActionListener action = null;
    private Map<String, String> ret_cookies = new ConcurrentHashMap<String, String>();

    public String getCookieString() {
        return this.ret_cookies.entrySet().stream().map(k -> ((String)k.getKey()).concat("=").concat((String)k.getValue()).concat("; ")).collect(Collectors.joining());
    }

    public CookieMapModel(CefCookieManager cookieManager, ActionListener action) {
        this.manager = cookieManager;
        this.action = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visit(CefCookie cookie, int count, int total, BoolRef delete) {
        String name = cookie.name.equals("_maldive_oauth_webapp_session_key") ? "SESSION" : cookie.name;
        this.ret_cookies.put(name, cookie.value);
        Map<String, String> map = this.ret_cookies;
        synchronized (map) {
            if (this.ret_cookies.size() == total) {
                this.action.actionPerformed(new ActionEvent(this, 1, this.getCookieString()));
            }
        }
        return true;
    }

    public void removeCookies() {
        int cnt = this.ret_cookies.size();
        if (cnt > 0) {
            this.ret_cookies.clear();
            this.manager.deleteCookies("", "");
        }
    }
}

