/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.alwayz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopWorkDao;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class AlwayzProductModifyService
extends IProductModifyStatusApi {
    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        boolean flag = true;
        this.getMultithreadCount();
        try {
            shopProductSendDto.getWorkMngDto().getWorkcd();
            switch (status2) {
                case "0": {
                    String forbiddenKeywords = shoppingMallDetailDto.getForbiddenKeywords();
                    ArrayList forbiddenKeywordList = forbiddenKeywords != null && !forbiddenKeywords.isEmpty() ? Arrays.asList(forbiddenKeywords.split(",")) : new ArrayList();
                    String productName = shopProductDto.getGoods_nm();
                    for (String keyword : forbiddenKeywordList) {
                        if (!productName.contains(keyword)) continue;
                        throw new Exception("\uc0c1\ud488\uba85\uc5d0 \uae08\uc9c0\ub41c \ud0a4\uc6cc\ub4dc\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4: " + keyword);
                    }
                    break;
                }
                case "6": 
                case "7": {
                    flag = this.DeleteProduct(status2, shopProductDto, shoppingMallDetailDto);
                    if (!flag) {
                        return flag;
                    }
                    shopProductDto.setShopprodno("");
                    Thread.sleep(1000L);
                }
                default: {
                    break;
                }
                case "8": 
                case "9": {
                    return true;
                }
            }
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean DeleteProduct(String status2, ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        block24: {
            try {
                Object input;
                Map<String, String> loginInfo = IShopCommonLogin.loginAlwayzInfo(shoppingMallDetailDto.getSHOPPINGID(), shoppingMallDetailDto.getPASSWORD(), shoppingMallDetailDto.getSHOPCD());
                String targetUrl = "https://alwayz-seller-back.ilevit.com/sellers/items";
                String itemId = dto.getShopprodno();
                String jsonInputString = "{ \"itemId\": \"" + itemId + "\" }";
                URL url = new URL(targetUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("DELETE");
                connection.setRequestProperty("x-access-token", loginInfo.get("token"));
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36");
                connection.setDoOutput(true);
                Throwable throwable = null;
                Object var11_14 = null;
                try (OutputStream os = connection.getOutputStream();){
                    input = jsonInputString.getBytes("utf-8");
                    os.write((byte[])input, 0, ((byte[])input).length);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    new URL("https://alwayz-seller-back.ilevit.com/sellers/items");
                    HttpURLConnection connection2 = (HttpURLConnection)url.openConnection();
                    connection2.setRequestMethod("DELETE");
                    connection2.setRequestProperty("x-access-token", loginInfo.get("token"));
                    connection2.setRequestProperty("Content-Type", "application/json");
                    connection2.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36");
                    connection2.setDoOutput(true);
                    String jsonInputString2 = "{ \"itemId\": \"" + dto.getShopprodno() + "\",\"deletedReason\": \"seller removed item\"}";
                    input = null;
                    Object var14_20 = null;
                    try (OutputStream os = connection2.getOutputStream();){
                        byte[] input2 = jsonInputString2.getBytes("utf-8");
                        os.write(input2, 0, input2.length);
                    }
                    catch (Throwable throwable3) {
                        if (input == null) {
                            input = throwable3;
                        } else if (input != throwable3) {
                            ((Throwable)input).addSuppressed(throwable3);
                        }
                        throw input;
                    }
                    int responseCode2 = connection2.getResponseCode();
                    if (responseCode2 == 200) {
                        return true;
                    }
                    break block24;
                }
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> loginCookie) throws Exception {
        try {
            Map<String, String> loginInfo = IShopCommonLogin.loginAlwayzInfo(shoppingMallDetailDto.getSHOPPINGID(), shoppingMallDetailDto.getPASSWORD(), shoppingMallDetailDto.getSHOPCD());
            Info info = new Info();
            info.condition.type = "item";
            info.condition.itemCondition.id.$in.add(dto.getShopprodno());
            info.condition.itemSortCondition.createdAt = -1;
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString((Object)info);
            Connection.Response rs = Jsoup.connect((String)"https://alwayz-seller-back.ilevit.com/sellers/items/v2/count-request").header("Connection", "keep-alive").header("x-access-token", loginInfo.get("token")).header("Content-Type", "application/json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.POST).requestBody(json).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(rs.body());
            if (jsonObject.get("data").getAsInt() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getMultithreadCount() {
        int cnt;
        try {
            cnt = ShopWorkDao.get().getMultiThreadCnt();
            int cores = Runtime.getRuntime().availableProcessors();
            if (cnt != 1 && cnt > cores / 2) {
                cnt = cores / 2;
            }
        }
        catch (Exception exception) {
            return 1;
        }
        return cnt;
    }

    private class Info {
        @JsonProperty(value="condition")
        private Condition condition = new Condition();

        private class Condition {
            @JsonProperty(value="type")
            private String type;
            @JsonProperty(value="itemCondition")
            private ItemCondition itemCondition;
            @JsonProperty(value="itemSortCondition")
            private ItemSortCondition itemSortCondition;

            private Condition() {
                this.itemCondition = new ItemCondition();
                this.itemSortCondition = new ItemSortCondition();
            }
        }

        private class IdCondition {
            @JsonProperty(value="$in")
            private List<String> $in = new ArrayList<String>();

            private IdCondition() {
            }
        }

        private class ItemCondition {
            @JsonProperty(value="_id")
            private IdCondition id;

            private ItemCondition() {
                this.id = new IdCondition();
            }
        }

        private class ItemSortCondition {
            @JsonProperty(value="createdAt")
            private int createdAt;

            private ItemSortCondition() {
            }
        }
    }
}

