/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.lotteon;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.data.lotteon.IShopLotteOnOrderCommand;
import com.kdjsystem.mlink.yellim.shop.data.lotteon.LotteOnOrderDto;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class LotteOnOrderConfirmCommand
extends IShopLotteOnOrderCommand {
    private static IShopOrderCommand instance = new LotteOnOrderConfirmCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private LotteOnOrderConfirmCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        try {
            for (ShopOrderMstDto dto : param) {
                String json = "{\"deliveryProgressStateList\":[" + this.setRequestParams(dto) + "]}";
                JsonParser jsonParser = new JsonParser();
                Connection.Response response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/delivery/v1/SellerDeliveryProgressStateInform").header("Authorization", "Bearer " + param.get(0).getApikey()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                String body = response.body();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
                if (jsonObject.get("returnCode").toString().equals("0000")) {
                    dto.setResult_code("1");
                    dto.setOrder_status("100");
                } else {
                    dto.setResult_code("-1");
                }
                retList.add(dto);
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ub86f\ub370\uc628 \uc8fc\ubb38\ud655\uc778 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
        }
        return retList;
    }

    private String setRequestParams(ShopOrderMstDto dto) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            LotteOnOrderDto.DeliveryProgressStateList ic = new LotteOnOrderDto.DeliveryProgressStateList();
            ic.dvRtrvDvsCd = "DV";
            ic.odNo = dto.getOrder_id();
            ic.odSeq = dto.getMall_exp_cd();
            ic.procSeq = "1";
            ic.odPrgsStepCd = "12";
            ic.dvTrcStatDttm = YDMATimeUtil.getCurrentTime();
            ic.spdNo = dto.getMall_product_id();
            ic.sitmNo = dto.getSku_id();
            ic.slQty = dto.getSale_cnt();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)ic);
        }
        catch (Exception e) {
            throw new Exception("\uc8fc\ubb38\ud655\uc778 \ub370\uc774\ud130 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
        }
        return json;
    }
}

