/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.domesin;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCateDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinShopDao;
import com.kdjsystem.mlink.yellim.shop.domesin.MapperShopCateDto;
import com.kdjsystem.mlink.yellim.shop.mlink.MLinkShopDao;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class DomesinProductGetDao {
    static int categoryIdx = 0;
    String shopcd = "";
    public static DomesinProductGetDao instance = new DomesinProductGetDao();

    private DomesinProductGetDao() {
    }

    public static DomesinProductGetDao get() {
        return instance;
    }

    public boolean getIsModefiyShopCate(ProductItemDto item, List<MapperShopCateDto> shopCidInfoList) {
        for (MapperShopCateDto mapperShopCateDto : shopCidInfoList) {
            if (mapperShopCateDto == null) continue;
            String cid = mapperShopCateDto.getCid() == null ? "" : mapperShopCateDto.getCid();
            switch (mapperShopCateDto.getShopcd()) {
                case "shop0075": {
                    String coupang;
                    String string = coupang = item.getEs_coupang() == null ? "" : item.getEs_coupang();
                    if (coupang.equals(cid)) break;
                    return true;
                }
                case "shop0004": {
                    String interpark;
                    String string = interpark = item.getEs_interpark() == null ? "" : item.getEs_interpark();
                    if (interpark.equals(cid)) break;
                    return true;
                }
                case "shop0068": 
                case "shop00681": {
                    String gmar;
                    String esmgmarket;
                    String gmarket = mapperShopCateDto.getEsm_gmarket() == null ? "" : mapperShopCateDto.getEsm_gmarket();
                    String string = esmgmarket = item.getEsm_gmarket() == null ? "" : item.getEsm_gmarket();
                    if (!esmgmarket.equals(gmarket)) {
                        return true;
                    }
                    String string2 = gmar = item.getEs_gmarket() == null ? "" : item.getEs_gmarket();
                    if (gmar.equals(cid)) break;
                    return true;
                }
                case "shop0067": 
                case "shop00671": {
                    String auc;
                    String esmauction;
                    String auction = mapperShopCateDto.getEsm_auction() == null ? "" : mapperShopCateDto.getEsm_auction();
                    String string = esmauction = item.getEsm_auction() == null ? "" : item.getEsm_auction();
                    if (!esmauction.equals(auction)) {
                        return true;
                    }
                    String string3 = auc = item.getEs_auction() == null ? "" : item.getEs_auction();
                    if (auc.equals(cid)) break;
                    return true;
                }
                case "shop0055": {
                    String store;
                    String string = store = item.getEs_storefarm() == null ? "" : item.getEs_storefarm();
                    if (store.equals(cid)) break;
                    return true;
                }
                case "shop0003": 
                case "shop00031": {
                    String st11;
                    String string = st11 = item.getEs_11st() == null ? "" : item.getEs_11st();
                    if (st11.equals(cid)) break;
                    return true;
                }
                case "shop0287": {
                    String wemarket;
                    String string = wemarket = item.getEs_wemarket() == null ? "" : item.getEs_wemarket();
                    if (wemarket.equals(cid)) break;
                    return true;
                }
                case "shop0411": {
                    String ssg;
                    String string = ssg = item.getEs_ssg() == null ? "" : item.getEs_ssg();
                    if (ssg.equals(cid)) break;
                    return true;
                }
                case "shop0273": {
                    String kakao;
                    String string = kakao = item.getEs_kakao() == null ? "" : item.getEs_kakao();
                    if (kakao.equals(cid)) break;
                    return true;
                }
                case "shop0076": {
                    String tmon;
                    String string = tmon = item.getEs_tmon() == null ? "" : item.getEs_tmon();
                    if (tmon.equals(cid)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public List<ProductItemDto> getModifyProduct(List<ProductItemDto> productItems, String query, int workload) throws Exception {
        IProgressMonitor monitor;
        List<ProductItemDto> items;
        block4: {
            try {
                items = this.getIF_ModifyProduct(productItems, query);
                monitor = null;
                if (items.size() != 0) break block4;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        if (!this.shopcd.equals(items.get(0).getSearch())) {
            this.shopcd = items.get(0).getSearch();
            categoryIdx = 0;
        }
        DomesinShopDao.get();
        DomesinShopDao.saveShopProdInfo(items, monitor, workload);
        DomesinShopDao.get();
        DomesinShopDao.saveShopOptProdInfo(items, monitor, workload);
        String query2 = items.stream().map(p -> String.format("SELECT '%s' AS ICODE  \r\n", p.getIcode())).collect(Collectors.joining(" UNION ALL ", "WITH CTE_PRODLIST AS( ", ")"));
        List<ProductDTO> item2 = this.setIF_ModifyProductIn(query2);
        DomesinShopDao.get().setShopProductInUpdate(item2);
        DomesinShopDao.get();
        DomesinShopDao.saveShopOptProdIn(items);
        ++categoryIdx;
        return items;
    }

    public static void updateCategoryShopApiSetting(List<ProductItemDto> contents, IProgressMonitor monitor, int workload) throws Exception {
        if (categoryIdx == 0) {
            DomesinProductGetDao.getCategoryMapSetting(monitor, workload);
            try {
                if (monitor != null) {
                    monitor.subTask("[\uce74\ud14c\uace0\ub9ac\uc815\ubcf4 \uc218\uc9d1 \ucc98\ub9ac\uc911..] of " + workload + "...");
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        monitor.done();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            String shopcate_json = "";
            for (ProductItemDto list : contents) {
                if (list.getEs() == null || list.getEs().equals("")) {
                    DomesinShopDao.get();
                    shopcate_json = DomesinShopDao.getCateJson(list);
                } else {
                    MLinkShopDao.get();
                    ShopCateDto cateDto = MLinkShopDao.getNewCategorys(list.getEs());
                    String domeJson = "";
                    String shopJson = "";
                    if (cateDto.getId() != null && !cateDto.getId().equals("")) {
                        list.setEs(cateDto.getId());
                        domeJson = cateDto.getDomecatg();
                        shopJson = cateDto.getShopcate();
                    }
                    if (shopJson == null || shopJson.equals("")) {
                        DomesinShopDao.get();
                        shopcate_json = DomesinShopDao.getCateJson(list);
                    } else {
                        shopcate_json = ShopCommonDao.get().getCategoryShopApiSetting(shopJson, list);
                    }
                    String domecate_json = "";
                    domecate_json = domeJson == null || domeJson.equals("") ? ShopCommonDao.get().getCateDomeJson(list) : ShopCommonDao.get().getCategoryDomeSetting(domeJson, list.getSearch(), list.getCid());
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode actualObjShop1 = mapper.readTree(shopcate_json);
                    JsonNode actualObjShop2 = mapper.readTree(shopJson);
                    JsonNode actualObjdome1 = mapper.readTree(domecate_json);
                    JsonNode actualObjdome2 = mapper.readTree(domeJson);
                    if (!actualObjShop1.equals((Object)actualObjShop2) || !actualObjdome1.equals((Object)actualObjdome2)) {
                        ShopCommonDao.get().setNewCategoryMapUpdate(list.getEs(), shopcate_json, domecate_json);
                        ShopCommonDao.get().setCategoryMapUpdateApi(list.getEs(), shopcate_json, domecate_json);
                    }
                    list.setCid(cateDto.getId() == null ? "" : list.getEs());
                }
                try {
                    if (monitor == null) continue;
                    monitor.subTask("[\uce74\ud14c\uace0\ub9ac\uc815\ubcf4 \uc218\uc9d1 \ucc98\ub9ac\uc911..] of " + workload + "...");
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    monitor.done();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected static void getCategoryMapSetting(IProgressMonitor monitor, int workload) {
        block9: {
            try {
                HashMap<Integer, ShopCateDto> response = new HashMap<Integer, ShopCateDto>();
                ShopCateDto dto = ShopCommonDao.get().getCategoryMapAPI(0);
                if (Integer.parseInt(dto.getTotal_count()) <= 0) break block9;
                response.put(0, dto);
                if (Integer.parseInt(dto.getTotal_page()) > 1) {
                    int i = 1;
                    while (i <= Integer.parseInt(dto.getTotal_page())) {
                        ShopCateDto item = ShopCommonDao.get().getCategoryMapAPI(i);
                        response.put(i, item);
                        try {
                            if (monitor != null) {
                                monitor.subTask("[\uce74\ud14c\uace0\ub9ac\uc815\ubcf4 \ub2e4\uc6b4\ub85c\ub4dc \ucc98\ub9ac\uc911..] of " + workload + "..." + i);
                                monitor.worked(1);
                                if (monitor.isCanceled()) {
                                    monitor.done();
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        ++i;
                    }
                }
                ArrayList<ShopCateDto.CategoryMapList> catlist = new ArrayList<ShopCateDto.CategoryMapList>();
                Iterator iterator = response.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    ShopCateDto resDto = (ShopCateDto)response.get(key);
                    catlist.addAll(resDto.getCategoryMapList());
                }
                ShopCommonDao.get().setCategoryMapInsertNUpdate(catlist);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<ProductItemDto> getIF_ModifyProduct(List<ProductItemDto> productItems, String query) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductItemDto> list = new ArrayList<ProductItemDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                PreferencesMallDTO mallDto = ShopCommonDao.get().getSystemConf();
                String prodcpyyn = mallDto.getPRODSEARCHYN() == null ? "N" : mallDto.getPRODSEARCHYN();
                sql.append(query);
                sql.append("\r\n");
                sql.append("SELECT  \r\n");
                sql.append("IFNULL(PRODSEQ,'')  AS PRODSEQ , \r\n");
                sql.append("IFNULL(COMPNO,'')  AS COMPNO , \r\n");
                sql.append("IFNULL(COMPAYNY_GOODS_CD,'')  AS COMPAYNY_GOODS_CD , \r\n");
                sql.append("IFNULL(GOODS_NM,'')  AS GOODS_NM , \r\n");
                sql.append("IFNULL(CLASS_CD3,'')  AS CLASS_CD3 , \r\n");
                sql.append("IFNULL(SHOP_CID_INFO,'')  AS SHOP_CID_INFO , \r\n");
                sql.append("IFNULL(ORIGIN,'')  AS ORIGIN , \r\n");
                sql.append("IFNULL(MAKER,'')  AS MAKER , \r\n");
                sql.append("IFNULL(BRAND_NM,'')  AS BRAND_NM , \r\n");
                sql.append("IFNULL(TAX_YN,'')  AS TAX_YN , \r\n");
                sql.append("IFNULL(DELV_TYPE,'')  AS DELV_TYPE , \r\n");
                sql.append("IFNULL(DELV_COST,'')  AS DELV_COST , \r\n");
                sql.append("IFNULL(RETURN_DELV_COST,'0')  AS RETURN_DELV_COST , \r\n");
                sql.append("IFNULL(GOODS_SEARCH,'')  AS GOODS_SEARCH , \r\n");
                sql.append("IFNULL(GOODS_PRICE,'')  AS GOODS_PRICE , \r\n");
                sql.append("IFNULL(GOODS_CONSUMER_PRICE,'')  AS GOODS_CONSUMER_PRICE , \r\n");
                sql.append("IFNULL(GOODS_REMARKS,'')  AS GOODS_REMARKS , \r\n");
                sql.append("IFNULL(IMG_PATH,'')  AS IMG_PATH , \r\n");
                sql.append("IFNULL(IMG_PATH1,'')  AS IMG_PATH1 , \r\n");
                sql.append("IFNULL(IMG_PATH2,'') AS IMG_PATH2 , \r\n");
                sql.append("IFNULL(IMG_PATH3,'') AS IMG_PATH3 , \r\n");
                sql.append("IFNULL(IMG_PATH4,'') AS IMG_PATH4 , \r\n");
                sql.append("IFNULL(IMG_PATH5,'') AS IMG_PATH5 , \r\n");
                sql.append("IFNULL(IMG_PATH6,'')  AS IMG_PATH6 , \r\n");
                sql.append("IFNULL(IMG_PATH7,'')  AS IMG_PATH7 , \r\n");
                sql.append("IFNULL(IMG_PATH8,'')  AS IMG_PATH8 , \r\n");
                sql.append("IFNULL(IMG_PATH9,'')  AS IMG_PATH9 , \r\n");
                sql.append("IFNULL(SELECT_OPTION,'')  AS SELECT_OPTION , \r\n");
                sql.append("IFNULL(STATUS,'')  AS STATUS , \r\n");
                sql.append("IFNULL(PROP1_CD,'')  AS PROP1_CD , \r\n");
                sql.append("IFNULL(PROP_VAL1,'')  AS PROP_VAL1 , \r\n");
                sql.append("IFNULL(PROP_VAL2,'')  AS PROP_VAL2 , \r\n");
                sql.append("IFNULL(PROP_VAL3,'')  AS PROP_VAL3 , \r\n");
                sql.append("IFNULL(PROP_VAL4,'')  AS PROP_VAL4 , \r\n");
                sql.append("IFNULL(PROP_VAL5,'')  AS PROP_VAL5 , \r\n");
                sql.append("IFNULL(PROP_VAL6,'')  AS PROP_VAL6 , \r\n");
                sql.append("IFNULL(PROP_VAL7,'')  AS PROP_VAL7 , \r\n");
                sql.append("IFNULL(PROP_VAL8,'')  AS PROP_VAL8 , \r\n");
                sql.append("IFNULL(PROP_VAL9,'')  AS PROP_VAL9 , \r\n");
                sql.append("IFNULL(PROP_VAL10,'')  AS PROP_VAL10 , \r\n");
                sql.append("IFNULL(PROP_VAL11,'')  AS PROP_VAL11 , \r\n");
                sql.append("IFNULL(PROP_VAL12,'')  AS PROP_VAL12 , \r\n");
                sql.append("IFNULL(PROP_VAL13,'')  AS PROP_VAL13 , \r\n");
                sql.append("IFNULL(PROP_VAL14,'')  AS PROP_VAL14 , \r\n");
                sql.append("IFNULL(PROP_VAL15,'')  AS PROP_VAL15 , \r\n");
                sql.append("IFNULL(PROP_VAL16,'')  AS PROP_VAL16 , \r\n");
                sql.append("IFNULL(PROP_VAL17,'')  AS PROP_VAL17 , \r\n");
                sql.append("IFNULL(PROP_VAL18,'')  AS PROP_VAL18 , \r\n");
                sql.append("IFNULL(PROP_VAL19,'')  AS PROP_VAL19 , \r\n");
                sql.append("IFNULL(PROP_VAL20,'')  AS PROP_VAL20 , \r\n");
                sql.append("IFNULL(PROP_VAL21,'')  AS PROP_VAL21 , \r\n");
                sql.append("IFNULL(PROP_VAL22,'')  AS PROP_VAL22 , \r\n");
                sql.append("IFNULL(ShopSendStatus,'')  AS ShopSendStatus , \r\n");
                sql.append("IFNULL(ShopModifyContent,'')  AS ShopModifyContent , \r\n");
                sql.append("IFNULL(SELFMOD_NO,'')  AS SELFMOD_NO  \r\n");
                sql.append("  FROM  shopprodinfo AS A  \r\n");
                sql.append("   INNER JOIN  CTE_PRODLIST AS B  \r\n");
                sql.append("  ON A.COMPAYNY_GOODS_CD = B.ICODE AND A.MODIFYID < B.MODIFYID\r\n");
                sql.append("  WHERE COMPNO=? ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                YDMAStringUtil.Print("[getIF_ModifyProduct]" + pstmt.toString());
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String company_goods_cd = rs.getString("COMPAYNY_GOODS_CD");
                    ProductItemDto item = productItems.stream().filter(p -> p.getIcode().equals(company_goods_cd)).findAny().orElse(null);
                    if (item == null) continue;
                    String SHOP_CID_INFO = rs.getString("SHOP_CID_INFO");
                    List shopCidInfoList = (List)mapper.readValue(SHOP_CID_INFO, (TypeReference)new TypeReference<List<MapperShopCateDto>>(){});
                    boolean isModeShopCate = this.getIsModefiyShopCate(item, shopCidInfoList);
                    if (isModeShopCate) {
                        item.setCategoryModify(true);
                        item.setBaseInfoModify(true);
                    }
                    String jsonStr = rs.getString("ShopModifyContent");
                    try {
                        if (!item.getIname().equals(rs.getString("GOODS_NM"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc0c1\ud488\uba85", rs.getString("GOODS_NM"), item.getIname());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getCid().equals(rs.getString("CLASS_CD3"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uce74\ud14c\uace0\ub9ac", rs.getString("CLASS_CD3"), item.getCid());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getIcountry().equals(rs.getString("ORIGIN"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc6d0\uc0b0\uc9c0", rs.getString("ORIGIN"), item.getIcountry());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getMaker().equals(rs.getString("MAKER"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uba54\uc774\ucee4", rs.getString("MAKER"), item.getMaker());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getBrand().equals(rs.getString("BRAND_NM"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\ube0c\ub79c\ub4dc", rs.getString("BRAND_NM"), item.getBrand());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getTax().equals(rs.getString("TAX_YN"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uacfc\uc138\uc5ec\ubd80", rs.getString("TAX_YN"), item.getTax());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getDelivery_type().equals(rs.getString("DELV_TYPE"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\ubc30\uc1a1\ud0c0\uc785", rs.getString("DELV_TYPE"), item.getDelivery_type());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getDelivery_amount().equals(String.valueOf(rs.getString("DELV_COST")))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\ubc30\uc1a1\uae08\uc561", String.valueOf(rs.getString("DELV_COST")), item.getDelivery_amount());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getR_delivery_amount().equals(String.valueOf(rs.getString("RETURN_DELV_COST")))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\ubc18\ud488\ubc30\uc1a1\uae08\uc561", String.valueOf(rs.getString("RETURN_DELV_COST")), item.getR_delivery_amount());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getKeyword().equals(rs.getString("GOODS_SEARCH"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\ud0a4\uc6cc\ub4dc", rs.getString("GOODS_SEARCH"), item.getKeyword());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getPrice().equals(String.valueOf(rs.getString("GOODS_PRICE")))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\ud310\ub9e4\uac00", String.valueOf(rs.getString("GOODS_PRICE")), item.getPrice());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        String price_consumer;
                        String string = price_consumer = String.valueOf(item.getPrice_consumer()).equals("") ? "0" : String.valueOf(item.getPrice_consumer());
                        if (!price_consumer.equals(String.valueOf(String.valueOf(rs.getString("GOODS_CONSUMER_PRICE"))))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc18c\ube44\uc790\uac00", String.valueOf(rs.getString("GOODS_CONSUMER_PRICE")), item.getPrice_consumer());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        String match = "[^\uac00-\ud7a3xfe0-9a-zA-Z\\s]";
                        String content = item.getContent().replaceAll(match, "");
                        String goods_remarks = rs.getString("GOODS_REMARKS").replaceAll(match, "");
                        if (!content.equals(goods_remarks)) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc0c1\uc138\uc124\uba85", rs.getString("GOODS_REMARKS"), item.getContent());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    String[] img = item.getImg();
                    int length = img.length;
                    try {
                        if (length >= 1 && !rs.getString("IMG_PATH").equals(item.getImg()[0])) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\ub300\ud45c\uc774\ubbf8\uc9c0", rs.getString("IMG_PATH"), item.getImg()[0]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (length >= 2 && !rs.getString("IMG_PATH1").equals(item.getImg()[1])) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc774\ubbf8\uc9c01", rs.getString("IMG_PATH1"), item.getImg()[1]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (length >= 3 && !rs.getString("IMG_PATH2").equals(item.getImg()[2])) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc774\ubbf8\uc9c02", rs.getString("IMG_PATH2"), item.getImg()[2]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (length >= 4 && !rs.getString("IMG_PATH3").equals(item.getImg()[3])) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc774\ubbf8\uc9c03", rs.getString("IMG_PATH3"), item.getImg()[3]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (length >= 5 && !rs.getString("IMG_PATH4").equals(item.getImg()[4])) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc774\ubbf8\uc9c04", rs.getString("IMG_PATH4"), item.getImg()[4]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (length >= 6 && !rs.getString("IMG_PATH5").equals(item.getImg()[5])) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc774\ubbf8\uc9c05", rs.getString("IMG_PATH5"), item.getImg()[5]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (length >= 7 && !rs.getString("IMG_PATH6").equals(item.getImg()[6])) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc774\ubbf8\uc9c06", rs.getString("IMG_PATH6"), item.getImg()[6]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (length >= 8 && !rs.getString("IMG_PATH7").equals(item.getImg()[7])) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc774\ubbf8\uc9c07", rs.getString("IMG_PATH7"), item.getImg()[7]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (length >= 9 && !rs.getString("IMG_PATH8").equals(item.getImg()[8])) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc774\ubbf8\uc9c08", rs.getString("IMG_PATH8"), item.getImg()[8]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (length >= 10 && !rs.getString("IMG_PATH9").equals(item.getImg()[9])) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc774\ubbf8\uc9c09", rs.getString("IMG_PATH9"), item.getImg()[9]);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getSelect_option().equals(rs.getString("SELECT_OPTION"))) {
                            item.setOptionModify(true);
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc635\uc158", rs.getString("SELECT_OPTION"), item.getSelect_option());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (!item.getStatus().equals(rs.getString("STATUS"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uc0c1\ud0dc\uac12", rs.getString("STATUS"), item.getStatus());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi1() != null && !item.getGosi1().equals(rs.getString("PROP_VAL1"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 1", rs.getString("PROP_VAL1"), item.getGosi1());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi2() != null && !item.getGosi2().equals(rs.getString("PROP_VAL2"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 2", rs.getString("PROP_VAL2"), item.getGosi2());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi3() != null && !item.getGosi3().equals(rs.getString("PROP_VAL3"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 3", rs.getString("PROP_VAL3"), item.getGosi3());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi4() != null && !item.getGosi4().equals(rs.getString("PROP_VAL4"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 4", rs.getString("PROP_VAL4"), item.getGosi4());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi5() != null && !item.getGosi5().equals(rs.getString("PROP_VAL5"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 5", rs.getString("PROP_VAL5"), item.getGosi5());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi6() != null && !item.getGosi6().equals(rs.getString("PROP_VAL6"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 6", rs.getString("PROP_VAL6"), item.getGosi6());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi7() != null && !item.getGosi7().equals(rs.getString("PROP_VAL7"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 7", rs.getString("PROP_VAL7"), item.getGosi7());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi8() != null && !item.getGosi8().equals(rs.getString("PROP_VAL8"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 8", rs.getString("PROP_VAL8"), item.getGosi8());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi9() != null && !item.getGosi9().equals(rs.getString("PROP_VAL9"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 9", rs.getString("PROP_VAL9"), item.getGosi9());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi10() != null && !item.getGosi10().equals(rs.getString("PROP_VAL10"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 10", rs.getString("PROP_VAL10"), item.getGosi10());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi11() != null && !item.getGosi11().equals(rs.getString("PROP_VAL11"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 11", rs.getString("PROP_VAL11"), item.getGosi11());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi12() != null && !item.getGosi12().equals(rs.getString("PROP_VAL12"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 12", rs.getString("PROP_VAL12"), item.getGosi12());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi13() != null && !item.getGosi13().equals(rs.getString("PROP_VAL13"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 13", rs.getString("PROP_VAL13"), item.getGosi13());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi14() != null && !item.getGosi14().equals(rs.getString("PROP_VAL14"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 14", rs.getString("PROP_VAL14"), item.getGosi14());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi15() != null && !item.getGosi15().equals(rs.getString("PROP_VAL15"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 15", rs.getString("PROP_VAL15"), item.getGosi15());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi16() != null && !item.getGosi16().equals(rs.getString("PROP_VAL16"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 16", rs.getString("PROP_VAL16"), item.getGosi16());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi17() != null && !item.getGosi17().equals(rs.getString("PROP_VAL17"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 17", rs.getString("PROP_VAL17"), item.getGosi17());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi18() != null && !item.getGosi18().equals(rs.getString("PROP_VAL18"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 18", rs.getString("PROP_VAL18"), item.getGosi18());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi19() != null && !item.getGosi19().equals(rs.getString("PROP_VAL19"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 19", rs.getString("PROP_VAL19"), item.getGosi19());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi20() != null && !item.getGosi20().equals(rs.getString("PROP_VAL20"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 20", rs.getString("PROP_VAL20"), item.getGosi20());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi21() != null && !item.getGosi21().equals(rs.getString("PROP_VAL21"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 21", rs.getString("PROP_VAL21"), item.getGosi21());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (item.getGosi22() != null && !item.getGosi22().equals(rs.getString("PROP_VAL22"))) {
                            item.setBaseInfoModify(true);
                            jsonStr = this.getDomesinProductChange(jsonStr, "\uace0\uc2dc\uc815\ubcf4 22", rs.getString("PROP_VAL22"), item.getGosi22());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (jsonStr == null || jsonStr.length() == 0 || !item.isBaseInfoModify()) continue;
                    item.setModifyMode(true);
                    item.setChange_list(jsonStr);
                    list.add(item);
                    if (!prodcpyyn.equals("Y")) continue;
                    List<Object> addData = new ArrayList();
                    addData = mallDto.getPRODCPY_LOC().equals("left") ? ShopProductDao.get().getShopProductInfoList("", "", "", "COMPAYNY_GOODS_CD", "_" + item.getIcode(), "", "", 0, 0, "", "", "", 0) : ShopProductDao.get().getShopProductInfoList("", "", "", "COMPAYNY_GOODS_CD", String.valueOf(item.getIcode()) + "_", "", "", 0, 0, "", "", "", 0);
                    if (addData.size() <= 0) continue;
                    ProductItemDto clone_dto = item.clone();
                    for (ProductDTO productDTO : addData) {
                        clone_dto.setIcode(productDTO.getCompayny_goods_cd());
                        list.add(clone_dto);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    private String getDomesinProductChange(String modcontents, String itemName, String before, String after) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        DomesinProductChange change = null;
        String jsonStr = "";
        try {
            int idx;
            ArrayList<DomesinProductChange> changes = new ArrayList<DomesinProductChange>();
            change = DomesinProductChange.setDomesinProductChange(itemName, before, after);
            if (modcontents != null && !modcontents.equals("")) {
                TypeReference<List<DomesinProductChange>> typeReference = new TypeReference<List<DomesinProductChange>>(){};
                List list = (List)mapper.readValue(modcontents, (TypeReference)typeReference);
                changes.addAll(list);
            }
            if ((idx = IntStream.range(0, changes.size()).filter(i -> Objects.nonNull(changes.get(i))).filter(i -> itemName.equals(((DomesinProductChange)changes.get(i)).item)).findFirst().orElse(-1)) == -1) {
                changes.add(change);
            } else {
                changes.set(idx, change);
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            jsonStr = mapper.writeValueAsString(changes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonStr;
    }

    public List<ProductDTO> setIF_ModifyProductIn(String query) throws Exception {
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> dtolist = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(query);
                sql.append("\r\n");
                sql.append("SELECT  \r\n");
                sql.append("PRODSEQ  AS PRODSEQ , \r\n");
                sql.append("COMPNO  AS COMPNO , \r\n");
                sql.append("COMPAYNY_GOODS_CD  AS COMPAYNY_GOODS_CD , \r\n");
                sql.append("GOODS_NM  AS GOODS_NM , \r\n");
                sql.append("CLASS_CD1  AS CLASS_CD1 , \r\n");
                sql.append("CLASS_CD2  AS CLASS_CD2 , \r\n");
                sql.append("CLASS_CD3  AS CLASS_CD3 , \r\n");
                sql.append("SHOP_CID_INFO AS SHOP_CID_INFO ,\r\n");
                sql.append("ORIGIN  AS ORIGIN , \r\n");
                sql.append("MAKER  AS MAKER , \r\n");
                sql.append("BRAND_NM  AS BRAND_NM , \r\n");
                sql.append("MODEL_NM  AS MODEL_NM , \r\n");
                sql.append("TAX_YN  AS TAX_YN , \r\n");
                sql.append("DELV_TYPE  AS DELV_TYPE , \r\n");
                sql.append("DELV_COST  AS DELV_COST , \r\n");
                sql.append("RETURN_DELV_COST  AS RETURN_DELV_COST , \r\n");
                sql.append("GOODS_SEARCH  AS GOODS_SEARCH , \r\n");
                sql.append("GOODS_PRICE  AS GOODS_PRICE , \r\n");
                sql.append("GOODS_CONSUMER_PRICE  AS GOODS_CONSUMER_PRICE , \r\n");
                sql.append("GOODS_REMARKS  AS GOODS_REMARKS , \r\n");
                sql.append("IMG_PATH  AS IMG_PATH , \r\n");
                sql.append("IMG_PATH1  AS IMG_PATH1 , \r\n");
                sql.append("IMG_PATH2 AS IMG_PATH2 , \r\n");
                sql.append("IMG_PATH3 AS IMG_PATH3 , \r\n");
                sql.append("IMG_PATH4 AS IMG_PATH4 , \r\n");
                sql.append("IMG_PATH5 AS IMG_PATH5 , \r\n");
                sql.append("IMG_PATH6  AS IMG_PATH6 , \r\n");
                sql.append("IMG_PATH7  AS IMG_PATH7 , \r\n");
                sql.append("IMG_PATH8  AS IMG_PATH8 , \r\n");
                sql.append("IMG_PATH9  AS IMG_PATH9 , \r\n");
                sql.append("SELECT_OPTION  AS SELECT_OPTION , \r\n");
                sql.append("TEXT_OPTION  AS TEXT_OPTION , \r\n");
                sql.append("GOODS_COST  AS GOODS_COST , \r\n");
                sql.append("ISLIMIT  AS ISLIMIT , \r\n");
                sql.append("LIMIT_PRICE  AS LIMIT_PRICE , \r\n");
                sql.append("IS_OVERSEAS  AS IS_OVERSEAS , \r\n");
                sql.append("ADULT  AS ADULT , \r\n");
                sql.append("ISRETURN  AS ISRETURN , \r\n");
                sql.append("ITYPE  AS ITYPE , \r\n");
                sql.append("CHAR_1_NM  AS CHAR_1_NM , \r\n");
                sql.append("CHAR_2_NM  AS CHAR_2_NM , \r\n");
                sql.append("CHAR_2_VAL  AS CHAR_2_VAL , \r\n");
                sql.append("CERT_TYPE  AS CERT_TYPE , \r\n");
                sql.append("CERT  AS CERT , \r\n");
                sql.append("CERTNO  AS CERTNO , \r\n");
                sql.append("STOCK_USE_YN  AS STOCK_USE_YN , \r\n");
                sql.append("OPT_TYPE  AS OPT_TYPE , \r\n");
                sql.append("PROP_EDIT_YN  AS PROP_EDIT_YN , \r\n");
                sql.append("STATUS  AS STATUS , \r\n");
                sql.append("PROP1_CD  AS PROP1_CD , \r\n");
                sql.append("PROP_VAL1  AS PROP_VAL1 , \r\n");
                sql.append("PROP_VAL2  AS PROP_VAL2 , \r\n");
                sql.append("PROP_VAL3  AS PROP_VAL3 , \r\n");
                sql.append("PROP_VAL4  AS PROP_VAL4 , \r\n");
                sql.append("PROP_VAL5  AS PROP_VAL5 , \r\n");
                sql.append("PROP_VAL6  AS PROP_VAL6 , \r\n");
                sql.append("PROP_VAL7  AS PROP_VAL7 , \r\n");
                sql.append("PROP_VAL8  AS PROP_VAL8 , \r\n");
                sql.append("PROP_VAL9  AS PROP_VAL9 , \r\n");
                sql.append("PROP_VAL10  AS PROP_VAL10 , \r\n");
                sql.append("PROP_VAL11  AS PROP_VAL11 , \r\n");
                sql.append("PROP_VAL12  AS PROP_VAL12 , \r\n");
                sql.append("PROP_VAL13  AS PROP_VAL13 , \r\n");
                sql.append("PROP_VAL14  AS PROP_VAL14 , \r\n");
                sql.append("PROP_VAL15  AS PROP_VAL15 , \r\n");
                sql.append("PROP_VAL16  AS PROP_VAL16 , \r\n");
                sql.append("PROP_VAL17  AS PROP_VAL17 , \r\n");
                sql.append("PROP_VAL18  AS PROP_VAL18 , \r\n");
                sql.append("PROP_VAL19  AS PROP_VAL19 , \r\n");
                sql.append("PROP_VAL20  AS PROP_VAL20 , \r\n");
                sql.append("PROP_VAL21  AS PROP_VAL21 , \r\n");
                sql.append("PROP_VAL22  AS PROP_VAL22 , \r\n");
                sql.append("ShopSendStatus  AS ShopSendStatus , \r\n");
                sql.append("ShopModifyContent  AS ShopModifyContent , \r\n");
                sql.append("SELFMOD_NO  AS SELFMOD_NO  \r\n");
                sql.append("  FROM  shopprodinfo AS A  \r\n");
                sql.append("   INNER JOIN  CTE_PRODLIST AS B  \r\n");
                sql.append("  ON A.COMPAYNY_GOODS_CD = B.ICODE \r\n");
                sql.append("  WHERE COMPNO=? ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, compno);
                YDMAStringUtil.Print("[getShopProductInList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setShop_cid_info(rs.getString("SHOP_CID_INFO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setSelect_option(rs.getString("SELECT_OPTION"));
                    dto.setText_option(rs.getString("TEXT_OPTION"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setIslimit(rs.getString("ISLIMIT"));
                    dto.setLimit_price(rs.getString("LIMIT_PRICE"));
                    dto.setIs_overseas(rs.getString("IS_OVERSEAS"));
                    dto.setAdult(rs.getString("ADULT"));
                    dto.setIsreturn(rs.getString("ISRETURN"));
                    dto.setItype(rs.getString("ITYPE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCert(rs.getString("CERT"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelv_r_cost(rs.getString("RETURN_DELV_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setShopmodifycontent(rs.getString("SHOPMODIFYCONTENT"));
                    dto.setSendstats(rs.getString("SHOPSENDSTATUS"));
                    dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                    dtolist.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dtolist;
    }

    private static class DomesinProductChange {
        private String item;
        private String before;
        private String after;

        private DomesinProductChange() {
        }

        public static DomesinProductChange setDomesinProductChange(String item, String before, String after) {
            DomesinProductChange retDto = new DomesinProductChange();
            retDto.item = item;
            retDto.before = before;
            retDto.after = after;
            return retDto;
        }
    }
}

