/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductFolderDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOperatingOptionDTO;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class ProductOperatingDAO {
    private static ProductOperatingDAO instance = new ProductOperatingDAO();

    public static ProductOperatingDAO get() {
        return instance;
    }

    public List<ProductDTO> getOperatingProducts(ProductOperatingOptionDTO dto) throws Exception {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        Connection connection = DBCPInit.getInstance().getConnection();
        try {
            String compno = YDMASessonUtil.getCompnoInfo().getCompno();
            StringBuilder query = new StringBuilder();
            query.append("WITH CTE_PRODLIST AS (  \r\n");
            query.append("\tSELECT \r\n");
            query.append("\t\t  IFNULL(PRODSEQ,'')           AS PRODSEQ  \r\n");
            query.append("\t\t, IFNULL(COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD  \r\n");
            query.append("\t\t, IFNULL(COMPNO,'') \t\t   AS COMPNO  \r\n");
            query.append("\t  FROM SHOPPRODINFO USE INDEX (INSERTDT_DESC)  \r\n");
            query.append("\t WHERE COMPNO = " + compno + "  \r\n");
            query.append("\t   AND INSERTDT <> ''  \r\n");
            if (!dto.getDomemall().equals("")) {
                query.append("\t   AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
            }
            if (dto.getFolder().equals("")) {
                query.append("\t   AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM SHOPPRODFOLDERS  \r\n");
                query.append("\t   \t\t\t\t\t\t\t\t  WHERE COMPNO = " + compno + "  \r\n");
                query.append("\t   \t\t\t\t\t\t\t\t    AND FOLDER LIKE 'NOT_%')  \r\n");
            } else {
                query.append("\t   AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM SHOPPRODFOLDERS  \r\n");
                query.append("\t   \t\t\t\t\t\t\t\t  WHERE COMPNO = " + compno + "  \r\n");
                query.append("\t   \t\t\t\t\t\t\t\t    AND FOLDER = " + dto.getFolder() + ")  \r\n");
            }
            if (!dto.getCategory().equals("")) {
                query.append("\t   AND CLASS_CD3 LIKE '%" + dto.getCategory() + "%'  \r\n");
            }
            if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                query.append("\t   AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                query.append("\t    OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
            }
            query.append("\t ORDER BY INSERTDT DESC LIMIT " + dto.getSearchBlock() * (dto.getSearchPage() - 1) + ", " + dto.getSearchBlock() + "  \r\n");
            query.append(") \r\n");
            query.append("SELECT  \r\n");
            query.append("      INFO.*   \r\n");
            query.append("    , (CASE   \r\n");
            query.append("         WHEN STATUS = '0' THEN '\uacf5\uae09\uc911'  \r\n");
            query.append("         WHEN STATUS = '1' THEN '\ud488\uc808'  \r\n");
            query.append("         WHEN STATUS = '2' THEN '\ub2e8\uc885'  \r\n");
            query.append("         WHEN STATUS = '3' THEN '\uc885\ub8cc'  \r\n");
            query.append("        END) AS STATUS_NM  \r\n");
            query.append("    , (CASE   \r\n");
            query.append("         WHEN DELV_TYPE = '1' THEN '\ubb34\ub8cc'  \r\n");
            query.append("         WHEN DELV_TYPE = '2' THEN '\ucc29\ubd88'  \r\n");
            query.append("         WHEN DELV_TYPE = '3' THEN '\uc120\uacb0\uc81c'  \r\n");
            query.append("         WHEN DELV_TYPE = '4' THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'  \r\n");
            query.append("         ELSE ''  \r\n");
            query.append("        END) AS DELV_TYPE_NM   \r\n");
            query.append("  FROM (SELECT  \r\n");
            query.append("  \t\t\tIFNULL(A.PRODSEQ, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS PRODSEQ  \r\n");
            query.append("  \t\t  , IFNULL(A.COMPAYNY_GOODS_CD, '')   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPAYNY_GOODS_CD  \r\n");
            query.append("  \t\t  , IFNULL(A.COMPNO, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPNO  \r\n");
            query.append("  \t\t  , CONCAT(IFNULL(CLASS_CD1, ''), IFNULL(CLASS_CD2, ''), IFNULL(CLASS_CD3, ''), IFNULL(CLASS_CD4, '')) AS CODE  \r\n");
            query.append("  \t\t  , '0' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOPCD  \r\n");
            query.append("  \t\t  , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_USERID  \r\n");
            query.append("  \t\t  , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS IMG  \r\n");
            query.append("  \t\t  , IFNULL(GOODS_KEYWORD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_KEYWORD  \r\n");
            query.append("  \t\t  , IFNULL(GOODS_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_NM  \r\n");
            query.append("  \t\t  , IFNULL(MODEL_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS MODEL_NM  \r\n");
            query.append("  \t\t  , IFNULL(BRAND_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS BRAND_NM  \r\n");
            query.append("  \t\t  , IFNULL(GOODS_SEARCH, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_SEARCH  \r\n");
            query.append("  \t\t  , IFNULL(GOODS_GUBUN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_GUBUN  \r\n");
            query.append("  \t\t  , IFNULL(SHOP_CID_INFO, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_CID_INFO  \r\n");
            query.append("  \t\t  , IFNULL(CLASS_CD1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD1  \r\n");
            query.append("  \t\t  , IFNULL(CLASS_CD2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD2  \r\n");
            query.append("  \t\t  , IFNULL(CLASS_CD3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD3  \r\n");
            query.append("  \t\t  , IFNULL(CLASS_CD4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CLASS_CD4  \r\n");
            query.append("  \t\t  , IFNULL(PARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PARTNER_ID  \r\n");
            query.append("  \t\t  , IFNULL(DPARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DPARTNER_ID  \r\n");
            query.append("  \t\t  , IFNULL(MAKER, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS MAKER  \r\n");
            query.append("  \t\t  , IFNULL(ORIGIN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ORIGIN  \r\n");
            query.append("  \t\t  , IFNULL(MAKE_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MAKE_DM  \r\n");
            query.append("  \t\t  , IFNULL(SEX, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEX  \r\n");
            query.append("  \t\t  , IFNULL(STATUS, '') \t\t \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS STATUS  \r\n");
            query.append("  \t\t  , IFNULL(DELIV_ABLE_REGION, '')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELIV_ABLE_REGION  \r\n");
            query.append("  \t\t  , IFNULL(TAX_YN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS TAX_YN  \r\n");
            query.append("  \t\t  , IFNULL(CERT, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT  \r\n");
            query.append("  \t\t  , IFNULL(ISLIMIT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISLIMIT  \r\n");
            query.append("  \t\t  , IFNULL(LIMIT_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS LIMIT_PRICE  \r\n");
            query.append("  \t\t  , IFNULL(IS_OVERSEAS, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IS_OVERSEAS  \r\n");
            query.append("  \t\t  , IFNULL(ITYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ITYPE  \r\n");
            query.append("  \t\t  , IFNULL(ADULT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ADULT  \r\n");
            query.append("  \t\t  , IFNULL(ISRETURN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISRETURN  \r\n");
            query.append("  \t\t  , IFNULL(TEXT_OPTION, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS TEXT_OPTION  \r\n");
            query.append("  \t\t  , IFNULL(DELV_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_TYPE  \r\n");
            query.append("  \t\t  , IFNULL(DELV_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DELV_COST  \r\n");
            query.append("  \t\t  , IFNULL(RETURN_DELV_COST, '0')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS RETURN_DELV_COST  \r\n");
            query.append("  \t\t  , IFNULL(BANPUM_AREA, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS BANPUM_AREA  \r\n");
            query.append("  \t\t  , IFNULL(GOODS_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_COST  \r\n");
            query.append("  \t\t  , IFNULL(GOODS_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_PRICE  \r\n");
            query.append("  \t\t  , IFNULL(GOODS_CONSUMER_PRICE, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_CONSUMER_PRICE  \r\n");
            query.append("  \t\t  , IFNULL(CHAR_1_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_NM  \r\n");
            query.append("  \t\t  , IFNULL(CHAR_1_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_VAL  \r\n");
            query.append("  \t\t  , IFNULL(CHAR_2_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_NM  \r\n");
            query.append("  \t\t  , IFNULL(CHAR_2_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_VAL  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMG_PATH  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH1  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH2  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH3  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH4  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH5  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH6  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH7  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH8  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH9, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH9  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH10, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH10  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH11, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH11  \r\n");
            query.append("  \t\t  , IFNULL(IMG_PATH12, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH12  \r\n");
            query.append("  \t\t  , IFNULL(GOODS_REMARKS, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_REMARKS  \r\n");
            query.append("  \t\t  , IFNULL(CERT_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERT_TYPE  \r\n");
            query.append("  \t\t  , IFNULL(CERTNO, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTNO  \r\n");
            query.append("  \t\t  , IFNULL(AVLST_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLST_DM  \r\n");
            query.append("  \t\t  , IFNULL(AVLED_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLED_DM  \r\n");
            query.append("  \t\t  , IFNULL(ISSUEDATE, '') \t       \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ISSUEDATE  \r\n");
            query.append("  \t\t  , IFNULL(CERTDATE, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTDATE  \r\n");
            query.append("  \t\t  , IFNULL(CERT_AGENCY, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT_AGENCY  \r\n");
            query.append("  \t\t  , IFNULL(CERTFIELD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTFIELD  \r\n");
            query.append("  \t\t  , IFNULL(CERTMODEL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTMODEL  \r\n");
            query.append("  \t\t  , IFNULL(CERTNAME, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTNAME  \r\n");
            query.append("  \t\t  , IFNULL(EXEMPTIONTYPE, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXEMPTIONTYPE  \r\n");
            query.append("  \t\t  , IFNULL(MATERIAL, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MATERIAL  \r\n");
            query.append("  \t\t  , IFNULL(STOCK_USE_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS STOCK_USE_YN  \r\n");
            query.append("  \t\t  , IFNULL(OPT_TYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS OPT_TYPE  \r\n");
            query.append("  \t\t  , IFNULL(PROP_EDIT_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP_EDIT_YN  \r\n");
            query.append("  \t\t  , IFNULL(PROP1_CD, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP1_CD  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL1  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL2  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL3  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL4  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL5  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL6  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL7  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL8  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL9, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL9  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL10, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL10  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL11, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL11  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL12, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL12  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL13, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL13  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL14, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL14  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL15, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL15  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL16, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL16  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL17, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL17  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL18, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL18  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL19, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL19  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL20, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL20  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL21, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL21  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL22, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL22  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL23, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL23  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL24, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL24  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL25, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL25  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL26, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL26  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL27, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL27  \r\n");
            query.append("  \t\t  , IFNULL(PROP_VAL28, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL28  \r\n");
            query.append("  \t\t  , IFNULL(PACK_CODE_STR, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PACK_CODE_STR  \r\n");
            query.append("  \t\t  , IFNULL(IMPORTNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMPORTNO  \r\n");
            query.append("  \t\t  , IFNULL(GOODS_COST2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_COST2  \r\n");
            query.append("  \t\t  , IFNULL(ORIGIN2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ORIGIN2  \r\n");
            query.append("  \t\t  , IFNULL(EXPIRE_DM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXPIRE_DM  \r\n");
            query.append("  \t\t  , IFNULL(SUPPLY_SAVE_YN, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SUPPLY_SAVE_YN  \r\n");
            query.append("  \t\t  , IFNULL(DESCRITION, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DESCRITION  \r\n");
            query.append("  \t\t  , IFNULL(SHOPPRODNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPPRODNO  \r\n");
            query.append("  \t\t  , IFNULL(INSERTDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTDT  \r\n");
            query.append("  \t\t  , IFNULL(INSERTID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTID  \r\n");
            query.append("  \t\t  , IFNULL(MODIFYDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYDT  \r\n");
            query.append("  \t\t  , IFNULL(MODIFYID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYID  \r\n");
            query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SEQ  \r\n");
            query.append("  \t\t  , IFNULL(SHOPSENDSTATUS, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSTATS  \r\n");
            query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPSEQ  \r\n");
            query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SALEENDDT  \r\n");
            query.append("  \t\t  , IFNULL(DELV_QTY, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_QTY  \r\n");
            query.append("  \t\t  , IFNULL(GMCATEGNM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GMCATEGNM  \r\n");
            query.append("  \t\t  , IFNULL(SHOPMODIFYCONTENT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPMODIFYCONTENT  \r\n");
            query.append("  \t\t  , IFNULL(SELFMOD_NO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SELFMOD_NO  \r\n");
            query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSEQ  \r\n");
            query.append("  \t\tFROM SHOPPRODINFO AS A  \r\n");
            query.append("  \tINNER JOIN (SELECT * FROM CTE_PRODLIST) AS B ON A.PRODSEQ = B.PRODSEQ AND A.COMPNO = B.COMPNO) AS INFO  \r\n");
            YDMAStringUtil.Print(query.toString());
            result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Object getOperatingProductAllCount(ProductOperatingOptionDTO dto) throws Exception {
        Object result = 0;
        QueryRunner run = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        try (Connection connection = DBCPInit.getInstance().getConnection();){
            try {
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT COUNT(*) AS CNT  \r\n");
                query.append("  FROM SHOPPRODINFO  \r\n");
                query.append(" WHERE COMPNO = " + compno + "  \r\n");
                if (!dto.getDomemall().equals("")) {
                    query.append("\t AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("\t AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM SHOPPRODFOLDERS  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\tWHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t  AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("\t AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM SHOPPRODFOLDERS  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\tWHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t  AND FOLDER = " + dto.getFolder() + ")  \r\n");
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t AND CLASS_CD3 LIKE '%" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t  OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                result = run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return result;
    }

    public List<ProductFolderDTO> getProductFolders() throws Exception {
        List result = null;
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductFolderDTO.class);
        try (Connection connection = DBCPInit.getInstance().getConnection();){
            try {
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("\t\tCOMPNO  \r\n");
                query.append("\t  , FOLDER  \r\n");
                query.append("\t  , COMPAYNY_GOODS_CD  \r\n");
                query.append("  FROM shopprodfolders  \r\n");
                query.append(" WHERE COMPNO = " + compno + "  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return result;
    }

    public int updateProductInStatus(int status2, List<ProductDTO> dtos) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN  \r\n");
        query.append("   SET SHOPSENDSTATUS = ?  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SENDSEQ IN (?)  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{status2, Integer.parseInt(compno), dtos.stream().map(p -> p.getSENDSEQ()).collect(Collectors.joining(","))};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

