/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.common;

import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.shop.common.ChromePath;
import com.kdjsystem.mlink.yellim.shop.common.DriverPool;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

public class ChromeExtention {
    private Path downloadPath;
    private ChromeDriver driver;
    private String tempProfileDir;
    int checkVer = ChromePath.getChromePath();
    Map<Integer, DriverPool> driverPools = new HashMap<Integer, DriverPool>();
    public static ChromeExtention instance = new ChromeExtention();

    private ChromeExtention() {
    }

    public static ChromeExtention getInstace() {
        return instance;
    }

    public ChromeExtention setHeadlessMode(boolean headless_mode) {
        return this;
    }

    public ChromeExtention setFileDown(boolean isFileDown) {
        return this;
    }

    public ChromeDriver getDriver() {
        return this.getDriver(true);
    }

    public ChromeDriver getDriverForAuctionGmarket() {
        return this.getDriverForAuctionGmarket(true);
    }

    private void setupChromeDriver() {
        if (this.checkVer > 114) {
            ChromePath.downloadDriver(this.checkVer);
        } else {
            this.downgradeCheck();
            WebDriverManager.chromedriver().setup();
        }
    }

    private void downgradeCheck() {
        File fileToDelete = new File(String.valueOf(ChromePath.directoryCheck()) + "\\chromedriver.exe");
        if (fileToDelete.exists()) {
            fileToDelete.delete();
        }
    }

    private ChromeOptions setupChromeOptions(boolean isHeadless, boolean isEsm) {
        ChromeOptions options = new ChromeOptions();
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--disable-extensions"});
        options.setExperimentalOption("excludeSwitches", Arrays.asList("enable-automation"));
        if (isEsm) {
            String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36";
            options.addArguments(new String[]{"--user-agent=" + userAgent});
            options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
        }
        if (isHeadless) {
            options.addArguments(new String[]{"--headless=new"});
        } else {
            options.addArguments(new String[]{"--lang=ko_KR"});
            options.addArguments(new String[]{"--start-maximized"});
        }
        return options;
    }

    public ChromeDriver getDriver(boolean isHeadless) {
        this.setupChromeDriver();
        this.driver = new ChromeDriver(this.setupChromeOptions(isHeadless, false));
        return this.driver;
    }

    public ChromeDriver getDriverForAuctionGmarket(boolean isHeadless) {
        this.setupChromeDriver();
        this.driver = new ChromeDriver(this.setupChromeOptions(isHeadless, true));
        return this.driver;
    }

    public Path getDownloadPath() {
        return this.downloadPath;
    }

    public File getLastModifiedFile() {
        String strPath = this.getDownloadPath().toAbsolutePath().toString();
        File[] files = new File(strPath).listFiles();
        File lastFile = Arrays.stream(files).reduce((a, b) -> Long.valueOf(a.lastModified()).compareTo(b.lastModified()) > 0 ? a : b).get();
        return lastFile;
    }

    public String getLastFileAbsolutePath() {
        String strPath = this.downloadPath.toAbsolutePath().toString();
        return strPath.concat("\\").concat(this.getLastModifiedFile().getName());
    }

    public ChromeDriver getDriverUseTemp(boolean isHeadless) {
        this.setupChromeDriver();
        this.tempProfileDir = this.createTempProfileDirectory();
        this.setupChromeOptionsUsetemp(this.tempProfileDir, isHeadless, false);
        this.addShutdownHook(this.tempProfileDir, this.driver);
        return this.driver;
    }

    private String createTempProfileDirectory() {
        String tempProfileDir = String.valueOf(System.getProperty("java.io.tmpdir")) + "yellimchrome\\chrome-profile-" + UUID.randomUUID().toString();
        try {
            Files.createDirectories(Paths.get(tempProfileDir, new String[0]), new FileAttribute[0]);
            YDMAStringUtil.Print("\uc784\uc2dc chrome profile \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131\ub428: " + tempProfileDir);
        }
        catch (IOException e) {
            YDMAStringUtil.Print("\uc784\uc2dc \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 \uc2e4\ud328: " + e.getMessage());
            e.printStackTrace();
        }
        return tempProfileDir;
    }

    private ChromeOptions setupChromeOptionsUsetemp(String tempProfileDir, boolean isHeadless, boolean isEsm) {
        ChromeOptions options = new ChromeOptions();
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--disable-extensions"});
        options.addArguments(new String[]{"--user-data-dir=" + tempProfileDir});
        String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36";
        options.addArguments(new String[]{"User-Agent=" + userAgent});
        if (isEsm) {
            options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
        }
        if (isHeadless) {
            options.addArguments(new String[]{"--headless=new"});
            this.driver = new ChromeDriver(options);
        } else {
            options.addArguments(new String[]{"--lang=ko_KR"});
            this.driver = new ChromeDriver(options);
            this.driver.manage().window().maximize();
        }
        return options;
    }

    public void addShutdownHook(String chromeProfiledeleteFolder, ChromeDriver driver) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            YDMAStringUtil.Print("\uc560\ud50c\ub9ac\ucf00\uc774\uc158 \uc885\ub8cc, chrome profile \ub514\ub809\ud1a0\ub9ac \uc815\ub9ac \uc911: " + chromeProfiledeleteFolder);
            try {
                if (driver != null) {
                    driver.quit();
                    System.gc();
                    YDMAStringUtil.Print("ChromeDriver \uc815\uc0c1 \uc885\ub8cc\ub428.");
                }
            }
            catch (Exception e) {
                YDMAStringUtil.Print("ChromeDriver \uc885\ub8cc \uc911 \uc624\ub958: " + e.getMessage());
            }
            try {
                ChromeExtention.deleteDirectoryRecursively(Paths.get(chromeProfiledeleteFolder, new String[0]));
            }
            catch (IOException e) {
                YDMAStringUtil.Print("\ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
            }
        }));
    }

    private static void deleteDirectoryRecursively(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            YDMAStringUtil.Print("\uc784\uc2dc chrome profile \ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c\ub428: " + path.toString());
        }
    }
}

