/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim;

import com.kdjsystem.mlink.yellim.Activator;
import com.kdjsystem.mlink.yellim.StatusLineContribution;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMAHttpUtil;
import com.kdjsystem.mlink.yellim.common.YDMAPluginUtils;
import com.kdjsystem.mlink.yellim.common.YDMAProperties;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.controls.ComboItem;
import com.kdjsystem.mlink.yellim.controls.CustomCombo;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ShoppingmallDAO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.helper.LoginHelper;
import com.kdjsystem.mlink.yellim.shop.mlink.YellimHelpArticleManager;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction newWindowAction;
    private ActionFactory.IWorkbenchAction preferencesAction;
    private ActionFactory.IWorkbenchAction introAction;
    public static final String M_TOOLS = "tools";
    public static String host;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        this.preferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.preferencesAction);
        this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
        this.register((IAction)this.newWindowAction);
        this.introAction = ActionFactory.INTRO.create(window);
        this.register((IAction)this.introAction);
        this.introAction.setImageDescriptor(Activator.getImageDescriptor("/icons/N\ud6482.png"));
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager toolsMenu = new MenuManager("&Tools", M_TOOLS);
        menuBar.add((IContributionItem)toolsMenu);
        toolsMenu.add((IAction)this.preferencesAction);
        toolsMenu.add((IContributionItem)new Separator());
        toolsMenu.add((IContributionItem)new GroupMarker("additions"));
        toolsMenu.add((IContributionItem)new Separator());
        toolsMenu.add((IContributionItem)new GroupMarker("additions"));
        toolsMenu.add((IContributionItem)new Separator());
        toolsMenu.add((IAction)this.introAction);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolbar_left = new ToolBarManager(0x804000);
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar_left, "left"));
        toolbar_left.add((IAction)this.introAction);
        ControlContribution comboCI = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Combo cb_shop = new Combo(parent, 8);
                final CustomCombo ccb_shop = new CustomCombo(cb_shop);
                ccb_shop.setDataSource1(ApplicationActionBarAdvisor.this.getShopDatas());
                cb_shop.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String sel = ccb_shop.getSelectionValue();
                        ccb_shop.getSelectionItem().getName();
                        if (!sel.isEmpty()) {
                            String[] selData = sel.split(",");
                            ShoppingmallDTO shopInfo = new ShoppingmallDTO();
                            shopInfo.setSHOPURL(selData[0]);
                            shopInfo.setSHOPPINGID(selData[1]);
                            shopInfo.setPASSWORD(selData[2]);
                            shopInfo.setSHOPCD(selData[3]);
                            shopInfo.setAUTHKEY1(selData.length > 4 ? selData[4] : "");
                            shopInfo.setAPIKEY(selData.length > 5 ? selData[5] : "");
                            String chanelNo = "";
                            try {
                                LoginHelper.login(shopInfo, chanelNo, "", false);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });
                return cb_shop;
            }
        };
        toolbar_left.add((IContributionItem)comboCI);
        ControlContribution comboCIDome = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Combo cb_dome = new Combo(parent, 8);
                final CustomCombo ccb_dome = new CustomCombo(cb_dome);
                ccb_dome.setDataSourceDome(ApplicationActionBarAdvisor.this.getDomeDatas());
                cb_dome.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String sel = ccb_dome.getSelectionValue();
                        if (!sel.isEmpty()) {
                            String[] selData = sel.split(",");
                            ShoppingmallDTO shopInfo = new ShoppingmallDTO();
                            shopInfo.setSHOPURL(selData[0]);
                            shopInfo.setSHOPPINGID(selData[1]);
                            shopInfo.setPASSWORD(selData[2]);
                            shopInfo.setSHOPCD(selData[3]);
                            shopInfo.setAUTHKEY1(selData.length > 4 ? selData[4] : "");
                            shopInfo.setAPIKEY(selData.length > 5 ? selData[5] : "");
                            String chanelNo = "";
                            try {
                                LoginHelper.login(shopInfo, chanelNo, "", false);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });
                return cb_dome;
            }
        };
        toolbar_left.add((IContributionItem)comboCIDome);
        ControlContribution btn_guide_item = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Button btn_guide = new Button(parent, 0);
                btn_guide.setBounds(10, 10, 326, 112);
                btn_guide.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.yellim", "icons/N\ubbf8\ub9ac\ubcf4\uae30.png"));
                btn_guide.setText("\uc0ac\uc6a9\uc790 \uac00\uc774\ub4dc \ubcf4\uae30");
                btn_guide.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            ApplicationActionBarAdvisor.this.open_guide();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                return btn_guide;
            }
        };
        toolbar_left.add((IContributionItem)btn_guide_item);
        ControlContribution btn_qna = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Button btn_qna = new Button(parent, 0);
                btn_qna.setBounds(10, 10, 326, 112);
                btn_qna.setText("\uc610\ub9bc \ubb38\uc758\ud558\uae30");
                btn_qna.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.yellim", "icons/N\uc77c\uad04\ub2f5\ubcc0.png"));
                btn_qna.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String url = YellimHelpArticleManager.getUrl("ApplicationActionBarAdvisor", "Home");
                        if (url != null) {
                            YDMAHttpUtil.browser(url);
                        }
                    }
                });
                return btn_qna;
            }
        };
        toolbar_left.add((IContributionItem)btn_qna);
        ControlContribution btn_pay = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Button btn_pay = new Button(parent, 0);
                btn_pay.setBounds(10, 10, 326, 112);
                btn_pay.setText("\uc720\ub8cc \uae30\ub2a5 \uacb0\uc81c\ud558\uae30");
                btn_pay.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.yellim", "icons/\ubd80\uac00\uc11c\ube44\uc2a4.png"));
                btn_pay.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        YDMAHttpUtil.browser("https://smartstore.naver.com/hah100");
                    }
                });
                return btn_pay;
            }
        };
        toolbar_left.add((IContributionItem)btn_pay);
        ControlContribution lbl_notiDate = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Composite container = new Composite(parent, 0);
                GridLayout layout = new GridLayout(1, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                container.setLayout((Layout)layout);
                GridData containerData = new GridData(4, 4, true, false);
                containerData.heightHint = 112;
                container.setLayoutData((Object)containerData);
                Label lbl_notiDate = new Label(container, 0);
                lbl_notiDate.setText("  \uc720\ub8cc \uae30\ub2a5 \uc0ac\uc6a9 \uae30\uac04 :  ");
                lbl_notiDate.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 9, 1));
                GridData labelData = new GridData(4, 0x1000000, true, true);
                lbl_notiDate.setLayoutData((Object)labelData);
                return container;
            }
        };
        toolbar_left.add((IContributionItem)lbl_notiDate);
        ControlContribution lbl_enduse = new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Composite container = new Composite(parent, 0);
                GridLayout layout = new GridLayout(1, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                container.setLayout((Layout)layout);
                GridData containerData = new GridData(4, 4, true, false);
                containerData.heightHint = 112;
                container.setLayoutData((Object)containerData);
                Label lbl_enduse = new Label(container, 0);
                lbl_enduse.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 9, 1));
                GridData labelData = new GridData(4, 0x1000000, true, true);
                lbl_enduse.setLayoutData((Object)labelData);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date enduse = null;
                try {
                    String enduseStr = YDMASessonUtil.getUserInfo().getEnduse();
                    if (enduseStr != null) {
                        enduse = formatter.parse(enduseStr);
                    }
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
                Date today = new Date();
                String pricetype = YDMASessonUtil.getUserInfo().getPricetype();
                if (enduse != null && pricetype != null && today.before(enduse) && ApplicationActionBarAdvisor.this.isPriceType(pricetype)) {
                    lbl_enduse.setText(YDMASessonUtil.getUserInfo().getEnduse());
                } else {
                    lbl_enduse.setText("-");
                }
                return container;
            }
        };
        toolbar_left.add((IContributionItem)lbl_enduse);
    }

    protected void open_guide() throws Exception {
        String templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("yellim.guidePath"));
        String templateFile = YDMAProperties.getInstance().getAppProperty("yellim.guideFile");
        String templateFullpath = String.valueOf(templatePath) + File.separator + templateFile;
        try {
            File pdfFile = new File(templateFullpath);
            if (pdfFile.exists()) {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().browse(pdfFile.toURI());
                } else {
                    MessageDialog.openInformation(null, (String)"\uc0ac\uc6a9\uc790 \uac00\uc774\ub4dc \ubcf4\uae30", (String)"Desktop is not supported.");
                }
            } else {
                MessageDialog.openInformation(null, (String)"\uc0ac\uc6a9\uc790 \uac00\uc774\ub4dc \ubcf4\uae30", (String)"\ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private List<ComboItem> getShopDatas() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        try {
            List<ShoppingmallDTO> datas = ShoppingmallDAO.get().selectShoppingmallInfos();
            for (String shopCode : MallCode.getTradeShopList()) {
                List shopInfos = datas.stream().filter(p -> p.getSHOPCD().equals(shopCode)).sorted(Comparator.comparing(ShoppingmallDTO::getSHOPPINGID)).collect(Collectors.toList());
                if (shopInfos == null || shopInfos.size() == 0) continue;
                for (ShoppingmallDTO info : shopInfos) {
                    String code = String.format("%s,%s,%s,%s,%s,%s", info.getSHOPURL(), info.getSHOPPINGID(), info.getPASSWORD(), info.getSHOPCD(), info.getAUTHKEY1(), info.getAPIKEY());
                    items.add(new ComboItem(code, String.valueOf(info.getSHOPNM()) + "-" + info.getNICKNM1() + "(" + info.getSHOPPINGID() + ")"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return items;
    }

    private List<ComboItem> getDomeDatas() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        try {
            List<DomemallDTO> datas = DomemallDAO.get().selectDomemallInfos();
            for (String shopCode : MallCode.getTradeDomeList()) {
                List shopInfos = datas.stream().filter(p -> p.getSHOPCD().equals(shopCode)).sorted(Comparator.comparing(DomemallDTO::getSHOPPINGID)).collect(Collectors.toList());
                if (shopInfos == null || shopInfos.size() == 0) continue;
                for (DomemallDTO info : shopInfos) {
                    String code = String.format("%s,%s,%s,%s,%s,%s", info.getSHOPURL(), info.getSHOPPINGID(), info.getPASSWORD(), info.getSHOPCD(), info.getAUTHKEY1(), info.getAPIKEY());
                    items.add(new ComboItem(code, String.valueOf(info.getSHOPNM()) + "-" + info.getNICKNM1() + "(" + info.getSHOPPINGID() + ")"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return items;
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        StatusLineContribution statusItem = new StatusLineContribution("1", 70);
        try {
            String type = "REAL";
            statusItem.setText("[" + type + "] " + ", Company : (" + ")" + ", ImageFolder : (" + YDMASessonUtil.getImageFolderName() + ")");
            statusLine.add((IContributionItem)statusItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)YDMAPluginUtils.getShell(), (String)"\ub85c\uadf8\uc778", (String)e.getMessage());
        }
    }

    private boolean isPriceType(String priceType) {
        return priceType.equals("1") || priceType.equals("2") || priceType.equals("3") || priceType.equals("4") || priceType.equals("5") || priceType.equals("6");
    }

    private boolean isYPriceType(String priceType) {
        return priceType.equals("1") || priceType.equals("2") || priceType.equals("3");
    }
}

