/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.lotteon;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.data.lotteon.IShopLotteOnOrderCommand;
import com.kdjsystem.mlink.yellim.shop.data.lotteon.LotteOnOrderDto;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LotteOnChangeOrderExpressCommand
extends IShopLotteOnOrderCommand {
    private static final String Host = "https://openapi.lotteon.com";
    OkHttpClient client = new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }).build();
    private static LotteOnChangeOrderExpressCommand instance = new LotteOnChangeOrderExpressCommand();

    public static LotteOnChangeOrderExpressCommand getInstance() {
        return instance;
    }

    private LotteOnChangeOrderExpressCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        String startDate = param.get(0).getStartDt().substring(0, 10).replace("-", "");
        String endDate = param.get(0).getEndDt().substring(0, 10).replace("-", "");
        try {
            for (ShopOrderMstDto dto : param) {
                String json = "[" + this.setRequestParams(dto, startDate, endDate) + "]";
                MediaType mediaType = MediaType.parse((String)"");
                RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
                Request request2 = new Request.Builder().url(Host.concat("/v1/openapi/delivery/v1/SellerInvoiceNoModifyInform")).method("POST", body).addHeader("Authorization", "Bearer " + param.get(0).getApikey()).addHeader("Accept", "application/json").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("X-Timezone", "GMT+09:00").addHeader("Content-Type", "application/json").build();
                try {
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try (Response response = this.client.newCall(request2).execute();){
                        JsonParser parser = new JsonParser();
                        JsonObject result = (JsonObject)parser.parse(response.body().string());
                        if (result.get("returnCode").getAsString().equals("0000")) {
                            dto.setResult_code("1");
                            dto.setOrder_status("403");
                        } else {
                            dto.setResult_code("-1");
                        }
                        retList.add(dto);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    throw new Exception("\ub86f\ub370\uc628 \uc1a1\uc7a5\uc218\uc815 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retList;
    }

    public String getInvcNo(ShopOrderMstDto dto, String startDate, String endDate) throws Exception {
        String invcno = "";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date sdate = formatter.parse(startDate);
        Date edate = formatter.parse(endDate);
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        int i = 0;
        while (i < (int)range) {
            try {
                String json = "{\"srchStrtDt\":\"" + startDate + "000000\", \"srchEndDt\":\"" + startDate + "235959\",\"odNo\":\"" + dto.getOrder_id() + "\"}";
                MediaType mediaType = MediaType.parse((String)"");
                RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
                Request request2 = new Request.Builder().url(Host.concat("/v1/openapi/delivery/v1/SellerDeliveryProgressStateSearch")).method("POST", body).addHeader("Authorization", "Bearer " + dto.getApikey()).addHeader("Accept", "application/json").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("X-Timezone", "GMT+09:00").addHeader("Content-Type", "application/json").build();
                try {
                    Throwable throwable = null;
                    Object var18_19 = null;
                    try (Response response = this.client.newCall(request2).execute();){
                        JsonParser parser = new JsonParser();
                        JsonObject result = (JsonObject)parser.parse(response.body().string());
                        JsonObject data2 = result.get("data").getAsJsonObject();
                        JsonArray deliveryArr = data2.get("deliveryProgressStateList").getAsJsonArray();
                        if (deliveryArr.size() > 0) {
                            data2 = deliveryArr.get(0).getAsJsonObject();
                            invcno = data2.get("invcNo").getAsString();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    throw new Exception("\ub86f\ub370\uc628 \uc1a1\uc7a5\uc218\uc815 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            if (invcno.length() > 0) break;
            cal1.add(5, 1);
            startDate = formatter.format(cal1.getTime());
            ++i;
        }
        return invcno;
    }

    private String setRequestParams(ShopOrderMstDto dto, String startDate, String endDate) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            LotteOnOrderDto.InvoceNmModify inm = new LotteOnOrderDto.InvoceNmModify();
            inm.odNo = dto.getOrder_id();
            inm.odSeq = dto.getMall_exp_cd();
            inm.procSeq = "1";
            inm.orglProcSeq = "";
            inm.clmNo = "";
            inm.invcNo = this.getInvcNo(dto, startDate, endDate);
            inm.modDvCoCd = dto.getDelivery_id();
            inm.modInvcNo = dto.getInvoice_no();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)inm);
        }
        catch (Exception e) {
            throw new Exception("\uc6b4\uc1a1\uc7a5 \ub370\uc774\ud130 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
        }
        return json;
    }
}

