/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.godomall;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.FtpUtil;
import com.kdjsystem.mlink.yellim.common.YDMAProperties;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.ShopAddProdInfoDto;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.common.ChromeScript;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCatInfDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.data.godomall.GodomallMarshal;
import com.kdjsystem.mlink.yellim.shop.data.godomall.GodomallMarshalModify;
import com.kdjsystem.mlink.yellim.shop.data.godomall.GodomallProductDto;
import com.kdjsystem.mlink.yellim.shop.data.godomall.GodomallProductRegService;
import com.kdjsystem.mlink.yellim.shop.data.godomall.ShopGodomallAdditionalDto;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import org.openqa.selenium.chrome.ChromeDriver;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class GodomallProductModifyService
extends IProductModifyStatusApi {
    private static final String Host = "https://openhub.godo.co.kr";
    List<ShopOptionDto> shopOptionDtos;
    List<ShopAddProdInfoDto> addProdList;
    private final OkHttpClient client = new OkHttpClient().newBuilder().build();

    private boolean iSExistsProdNo(ProductDTO dto, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        if (dto.getShopprodno() == null || dto.getShopprodno().isEmpty()) {
            return false;
        }
        return false;
    }

    private void setProductStop(String status2, ShoppingmallDTO shoppingMallDetailDto, ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShopProductSendDto shopProductSendDto, String templatefilename) throws Exception {
        String goodsno = "";
        String xmlfile = "";
        xmlfile = "http://itsm.kdjsystem.com/xmldir/" + templatefilename;
        String response = "";
        String params = "?partner_key=" + shoppingMallDetailDto.getAUTHKEY1() + "&key=" + shoppingMallDetailDto.getAPIKEY() + "&goodsNo=" + shopProductDto.getShopprodno() + "&data_url" + xmlfile;
        try {
            String line;
            URL obj = new URL("https://openhub.godo.co.kr/godomall5/goods/Goods_Delete.php" + params);
            HttpsURLConnection conn = (HttpsURLConnection)obj.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = br.readLine()) != null) {
                response = String.valueOf(response) + line;
            }
            br.close();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GodomallProductStop.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            GodomallProductStop gdDel = (GodomallProductStop)unmarshaller.unmarshal((Reader)new StringReader(response));
            goodsno = Integer.toString(gdDel.return2.goods_data.get((int)0).goodsNo);
            if (gdDel.header.code == 0 && shopProductDto.getShopprodno().equals(goodsno)) {
                shopProductDto.setResult_code("1");
            } else {
                shopProductDto.setResult_code("-1");
                shopProductDto.setResult_text(gdDel.toString());
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\ubc88\ud638\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String setProductDelete(ProductDTO dto) throws Exception {
        String theXML = "";
        try {
            GodomallMarshalDelete godomallMarshalDelete = new GodomallMarshalDelete();
            GodomallMarshalDelete.Goods_data gd = new GodomallMarshalDelete.Goods_data();
            ArrayList<GodomallMarshalDelete.Goods_data> gdList = new ArrayList<GodomallMarshalDelete.Goods_data>();
            godomallMarshalDelete.goods_data = gdList;
            gdList.add(gd);
            gd.goodsNo = Integer.parseInt(dto.getShopprodno());
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GodomallMarshalDelete.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)godomallMarshalDelete, (Writer)writer);
            marshaller.marshal((Object)godomallMarshalDelete, (OutputStream)System.out);
            theXML = writer.toString().replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return theXML;
    }

    private String setProductReg(ProductDTO dto, ShopGodomallAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookie, List<String> strImages) throws Exception {
        String theXML = "";
        try {
            GodomallMarshalModify godomallMarshalModify = new GodomallMarshalModify();
            GodomallMarshalModify.Goods_data2 gd = new GodomallMarshalModify.Goods_data2();
            ArrayList<GodomallMarshalModify.Goods_data2> gdList = new ArrayList<GodomallMarshalModify.Goods_data2>();
            GodomallMarshalModify.goods_data = gdList;
            this.getCategory(dto, dtllist, shoppingMallDetailDto, gd);
            this.Basic(dto, dtllist, gd);
            this.Option(dto, dtllist, gd);
            this.Image(dto, dtllist, gd, strImages);
            this.DetailRemark(dto, gd, dtllist);
            this.ItemBasic(dtllist, gd, dto, shoppingMallDetailDto);
            gdList.add(gd);
            gd.goodsNo = Integer.parseInt(dto.getShopprodno());
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GodomallMarshalModify.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)godomallMarshalModify, (Writer)writer);
            marshaller.marshal((Object)godomallMarshalModify, (OutputStream)System.out);
            theXML = writer.toString().replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return theXML;
    }

    private void Image(ProductDTO dto, ShopGodomallAdditionalDto dtllist, GodomallMarshalModify.Goods_data2 gd, List<String> strImages) {
        String img = strImages.get(0);
        GodomallMarshalModify.Goods_data2.MagnifyImageData magImg = new GodomallMarshalModify.Goods_data2.MagnifyImageData();
        magImg.idx = 1;
        magImg.text = img;
        gd.magnifyImageData.add(magImg);
        GodomallMarshalModify.Goods_data2.ListImageData listImg = new GodomallMarshalModify.Goods_data2.ListImageData();
        listImg.idx = 1;
        listImg.text = img;
        gd.listImageData.add(listImg);
        GodomallMarshalModify.Goods_data2.DetailImageData dtlImg = new GodomallMarshalModify.Goods_data2.DetailImageData();
        dtlImg.idx = 1;
        dtlImg.text = img;
        gd.detailImageData.add(dtlImg);
        GodomallMarshalModify.Goods_data2.MainImageData mainImg = new GodomallMarshalModify.Goods_data2.MainImageData();
        mainImg.idx = 1;
        mainImg.text = img;
        gd.mainImageData.add(mainImg);
    }

    private synchronized void productUpdateSend(ProductDTO shopProductDto, ShoppingmallDTO shoppingMallDetailDto, String templatefilename) throws Exception {
        String xmlfile = "";
        xmlfile = "http://itsm.kdjsystem.com/xmldir/" + templatefilename;
        String params = "?partner_key=" + shoppingMallDetailDto.getAUTHKEY1() + "&key=" + shoppingMallDetailDto.getAPIKEY() + "&data_url=" + xmlfile;
        new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        GodomallProductUpdate gdModi = null;
        try {
            String line;
            URL obj = new URL("https://openhub.godo.co.kr/godomall5/goods/Goods_Update.php" + params);
            HttpsURLConnection conn = (HttpsURLConnection)obj.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String xmlResponse = "";
            while ((line = br.readLine()) != null) {
                xmlResponse = String.valueOf(xmlResponse) + line;
            }
            br.close();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GodomallProductUpdate.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            gdModi = (GodomallProductUpdate)unmarshaller.unmarshal((Reader)new StringReader(xmlResponse));
            int goodsno = gdModi.return1.goods_data.get((int)0).data.get((int)0).goodsno;
            if (gdModi.header.code == 0 && Integer.parseInt(shopProductDto.getShopprodno()) == goodsno) {
                shopProductDto.setResult_code("1");
            } else {
                shopProductDto.setResult_code("-1");
                shopProductDto.setResult_text(gdModi.header.msg);
            }
        }
        catch (Exception exception) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(gdModi.header.msg);
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc5d0\ub7ec \ub0b4\uc6a9 : " + gdModi.header.msg);
        }
    }

    private void Notice(GodomallMarshal.Goods_data2 gd, ShopGodomallAdditionalDto dtllist, ProductDTO dto, Map<String, String> cookie) throws Exception {
    }

    private void ItemBasic(ShopGodomallAdditionalDto dtllist, GodomallMarshalModify.Goods_data2 gd, ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        try {
            gd.goodsColor = dtllist.getGoodsColor();
            gd.optionDisplayFl = dtllist.getOptionDisplayFl();
            gd.goodsDisplayFl = "y";
            gd.goodsDisplayMobileFl = dtllist.getGoodsDisplayMobileFl();
            gd.goodsSellFl = "y";
            gd.goodsSellMobileFl = dtllist.getGoodsSellMobileFl();
            gd.scmNo = dtllist.getScmNo();
            gd.payLimitFl = dtllist.getPayLimitFl();
            gd.payLimit = dtllist.getPayLimit();
            gd.goodsState = dtllist.getGoodsState();
            gd.goodsPermission = dtllist.getGoodsPermission();
            gd.taxFreeFl = "t";
            gd.onlyAdultFl = dtllist.getOnlyAdultFl();
            gd.goodsPriceString = dtllist.getGoodsPriceString();
            gd.imageStorage = dtllist.getImageStorage();
            gd.stockFl = dtllist.getStockFl();
            gd.soldOutFl = "n";
            gd.relationFl = "n";
            gd.maxOrderCnt = dtllist.getMaxOrderCnt();
            gd.restockFl = dtllist.getRestockFl();
            gd.mileageFl = "c";
            gd.goodsDiscountFl = "n";
            gd.payLimitFl = "n";
            gd.imgDetailViewFl = dtllist.getImgDetailViewFl();
            gd.externalVideoFl = "n";
            gd.deliverySno = dtllist.getDeliverySno();
            gd.detailInfoDelivery = dtllist.getDetailInfoDelivery();
            gd.detailInfoAS = dtllist.getDetailInfoAS();
            gd.detailInfoRefund = dtllist.getDetailInfoRefund();
            gd.detailInfoExchange = dtllist.getDetailInfoExchange();
            gd.naverFl = dtllist.getNaverFl();
            gd.naverImportFlag = dtllist.getNaverImportFlag();
            gd.naverProductFlag = dtllist.getNaverProductFlag();
            gd.naverAgeGroup = dtllist.getNaverAgeGroup();
            gd.naverGender = dtllist.getNaverGender();
            gd.naverTag = dtllist.getNaverTag();
            gd.naverAttribute = dtllist.getNaverAttribute();
            gd.naverCategory = dtllist.getNaverCategory();
            gd.naverProductId = dtllist.getNaverProductId();
            gd.goodsCd = dto.getCompayny_goods_cd();
            gd.makerNm = dto.getMaker();
            gd.originNm = "\uc0c1\ud488\uc0c1\uc138 \ucc38\uc870";
            gd.salesEndYmd = dtllist.getSalesEndYmd().toString();
            gd.minOrderCnt = dtllist.getMinOrderCnt();
            gd.maxOrderCnt = dtllist.getMaxOrderCnt();
            gd.addGoodsFl = "n";
            gd.taxPercent = "10.0";
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130 \uc785\ub825 \uc2e4\ud328 : \uae30\ubcf8 \ubd80\uac00\uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    public int setBrandSearch(ShoppingMallDetailDto shoppingMallDetailDto, ProductDTO dto, GodomallProductDto.Return.Goods_data gd) throws Exception {
        String line;
        GodomallProductDto.Header hd = new GodomallProductDto.Header();
        int brandcd = 0;
        String params = "?partner_key=" + shoppingMallDetailDto.getAuthkey1() + "&key=" + shoppingMallDetailDto.getApikey() + "&brandCd=" + gd.cateCd;
        new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        MediaType mediaType = MediaType.parse((String)"");
        RequestBody.create((MediaType)mediaType, (String)params);
        URL obj = new URL("https://openhub.godo.co.kr/godomall5/goods/Brand_Search.php" + params);
        HttpsURLConnection conn = (HttpsURLConnection)obj.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        String xml = "";
        while ((line = br.readLine()) != null) {
            xml = String.valueOf(xml) + line;
        }
        br.close();
        try {
            if (hd.code == 0) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GodomallProductDto.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                GodomallProductDto gddto = (GodomallProductDto)unmarshaller.unmarshal((Reader)new StringReader(xml));
                GodomallProductDto.Return cfr_ignored_0 = gddto.return1;
                brandcd = Integer.parseInt(GodomallProductDto.Return.brand_data.get((int)0).cateCd);
                return brandcd;
            }
            return brandcd;
        }
        catch (Exception exception) {
            throw new Exception("\uace0\ub3c4\ubab0 \ube0c\ub79c\ub4dc \uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void DetailRemark(ProductDTO dto, GodomallMarshalModify.Goods_data2 gd, ShopGodomallAdditionalDto dtllist) throws Exception {
        ArrayList<GodomallMarshalModify.Goods_data2> gdList = new ArrayList<GodomallMarshalModify.Goods_data2>();
        try {
            if (dtllist.getShortDescription().equals("")) {
                String addDetailPlus = "";
                if (dtllist.getDetailkeywordb().equals("Y")) {
                    addDetailPlus = String.valueOf(dtllist.getDetailKeywordL()) + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
                }
                if (dtllist.getDetailproductcodeb().equals("Y")) {
                    addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
                }
                if (dtllist.getDetailproductnameb().equals("Y")) {
                    addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
                }
                gd.goodsDescription = String.valueOf(addDetailPlus) + dtllist.getPdDtlFrtDec() + dto.getGoods_remarks() + dtllist.getPdDtlBackDec();
            } else {
                gd.goodsDescription = dtllist.getShortDescription();
            }
            gdList.add(gd);
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130 \uc785\ub825 \uc2e4\ud328 : \uc0c1\uc138 \uc124\uba85\uc744 \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void textOption(ProductDTO dto, GodomallMarshal.Goods_data2 gd) throws Exception {
    }

    private void Option(ProductDTO dto, ShopGodomallAdditionalDto dtllist, GodomallMarshalModify.Goods_data2 gd) throws Exception {
        this.shopOptionDtos = this.getProductOptions(dto);
        new ArrayList();
        Long salePrice = this.salePrice(dto, dtllist);
        try {
            if (this.shopOptionDtos.size() > 0) {
                gd.optionFl = "y";
                gd.optionTextFl = "n";
                if (dtllist.getAddoptionlb().equals("Y")) {
                    dtllist.getAddOptionL();
                }
                if (dtllist.getAddoptionrb().equals("Y")) {
                    dtllist.getAddOptionR();
                }
                for (ShopOptionDto option2 : this.shopOptionDtos) {
                    GodomallMarshalModify.Goods_data2.Optiondata op;
                    String joinOptionName;
                    YDMAStringUtil.convertToInt(option2.getAmt());
                    salePrice = salePrice + YDMAStringUtil.convertToLong(option2.getAmt());
                    int limit_price = YDMAStringUtil.convertToInt(option2.getLimit_price());
                    ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                    if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                        optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                    }
                    Integer.parseInt(optionprice.getConsumer_if_sale_price());
                    gd.fixedPrice = gd.goodsPrice = dto.getMarket_price();
                    CharSequence[] optionTypes = option2.getName().split(":");
                    gd.optionName = joinOptionName = String.join((CharSequence)"^|^", optionTypes);
                    String[] optionValues = option2.getOptspecdes().split(":");
                    if (optionTypes.length == 1) {
                        int j = 0;
                        while (j < optionTypes.length) {
                            op = new GodomallMarshalModify.Goods_data2.Optiondata();
                            op.idx = j + 1;
                            op.optionViewFl = "y";
                            op.optionSellFl = "y";
                            op.optionNo = Integer.parseInt(option2.getSkuseq());
                            op.optionValue1 = optionValues[j];
                            op.optionPrice = option2.getAmt();
                            gd.optiondataList.add(op);
                            op.stockCnt = 999;
                            ++j;
                        }
                    }
                    if (optionTypes.length != 2) continue;
                    int k = 0;
                    while (k < option2.getSkuseq().length()) {
                        op = new GodomallMarshalModify.Goods_data2.Optiondata();
                        op.idx = k + 1;
                        op.optionViewFl = "y";
                        op.optionSellFl = "y";
                        op.optionNo = Integer.parseInt(option2.getSkuseq());
                        op.optionValue1 = optionValues[0];
                        op.optionValue2 = optionValues[1];
                        op.optionPrice = option2.getAmt();
                        gd.optiondataList.add(op);
                        op.stockCnt = 999;
                        ++k;
                    }
                }
            } else {
                gd.optionFl = "n";
                gd.optionTextFl = "n";
                gd.fixedPrice = gd.goodsPrice = dto.getGoods_price();
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc635\uc158\uc744 \ub4f1\ub85d\ud558\ub294 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private Long salePrice(ProductDTO dto, ShopGodomallAdditionalDto dtllist) throws Exception {
        Long salePrice;
        try {
            salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            ResultMarketPrice resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00\ub97c \uacc4\uc0b0\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return salePrice;
    }

    private void setItmLst(ProductDTO dto, ShopGodomallAdditionalDto dtllist, List<String> strImages, List<GodomallMarshal.Goods_data2> gdList, List<String> ctName1, List<String> ctName2, ShopOptionDto shopOptionDto, int sortseq, int amt) {
    }

    private void Basic(ProductDTO dto, ShopGodomallAdditionalDto dtllist, GodomallMarshalModify.Goods_data2 gd) throws Exception {
        gd.goodsNmFl = "d";
        gd.goodsModelNo = dto.getModel_no();
        try {
            String value = "";
            switch (dtllist.getPdPrtWay()) {
                case "1": {
                    value = dto.getGoods_nm();
                    break;
                }
                case "2": {
                    value = dto.getModel_nm().equals("") || dto.getModel_nm().equals(null) ? dto.getGoods_nm() : dto.getModel_nm();
                    break;
                }
                case "3": {
                    value = dto.getModel_nm().equals("") || dto.getModel_nm().equals(null) ? dto.getGoods_nm() : dto.getGoods_nm().concat("(").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "4": {
                    value = dto.getModel_nm().equals("") || dto.getModel_nm().equals(null) ? dto.getGoods_nm() : dto.getModel_nm().concat("(").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "5": {
                    value = dto.getModel_nm().equals("") || dto.getModel_nm().equals(null) ? dto.getGoods_nm() : dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "6": {
                    value = dto.getModel_nm().equals("") || dto.getModel_nm().equals(null) ? dto.getGoods_nm() : dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    value = dto.getGoods_nm();
                }
            }
            if (!dtllist.getPdNmAddFrtTxt().equals("")) {
                value = dtllist.getPdNmAddFrtTxt().concat(value);
            }
            if (!dtllist.getPdNmAddBackTxt().equals("")) {
                value = value.concat(dtllist.getPdNmAddBackTxt());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 100);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            gd.goodsNm = YDMAStringUtil.length(value) > 100 ? YDMAStringUtil.Char_substring(value, 100) : value;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc0c1\ud488\uba85\uc744 \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    public String getCategorySize(ProductDTO dto) {
        List<String> ret = Arrays.asList(dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4());
        String strCategs = "";
        if (YDMASessonUtil.getLoginType() == 2) {
            List result = ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
            strCategs = (String)result.get(result.size() - 1);
        } else {
            strCategs = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining());
        }
        return strCategs;
    }

    private void getCategory(ProductDTO dto, ShopGodomallAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto, GodomallMarshalModify.Goods_data2 gd) throws Exception {
        try {
            int code;
            String strCategs = this.getCategorySize(dto);
            ShopCatInfDto cateDto = ShopCommonDao.get().getShopCateInfName(dto.getClass_nm1(), dto.getShopcd());
            String sendcatno = "";
            ObjectMapper mapper = new ObjectMapper();
            List<String> class_nm = Arrays.asList(dto.getClass_nm1().split(">"));
            String catecd = "1";
            if (cateDto.getShoplagcatcd() == null || cateDto.getShoplagcatcd().equals("")) {
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 0);
            } else {
                sendcatno = cateDto.getShoplagcatcd();
                code = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (code != 0) {
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 0);
                }
            }
            if (cateDto.getShopmidcatcd() == null || cateDto.getShopmidcatcd().equals("")) {
                catecd = cateDto.getShoplagcatcd();
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 1);
            } else {
                sendcatno = cateDto.getShopmidcatcd();
                code = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (code != 0) {
                    catecd = cateDto.getShoplagcatcd();
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 1);
                }
            }
            if (cateDto.getShopsmlcatcd() == null || cateDto.getShopsmlcatcd().equals("")) {
                catecd = cateDto.getShopmidcatcd();
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 2);
            } else {
                sendcatno = cateDto.getShopsmlcatcd();
                code = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (code != 0) {
                    catecd = cateDto.getShopmidcatcd();
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 2);
                }
            }
            if (cateDto.getShopdetcatcd() == null || cateDto.getShopdetcatcd().equals("")) {
                catecd = cateDto.getShopsmlcatcd();
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 3);
            } else {
                sendcatno = cateDto.getShopdetcatcd();
                code = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (code != 0) {
                    catecd = cateDto.getShopsmlcatcd();
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 3);
                }
            }
            cateDto.setShopcatno(strCategs);
            cateDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
            cateDto.setShopcd(shoppingMallDetailDto.getSHOPCD());
            cateDto.setShopcatnm(String.valueOf(shoppingMallDetailDto.getSHOPCD()) + "_" + class_nm.get(class_nm.size() - 1));
            cateDto.setShopcatsitenm(dto.getClass_nm1());
            gd.cateCd = catecd;
            gd.allCateCd = catecd;
            ShopProductDao.get().Category(cateDto, dto, class_nm, dto.getGoods_keyword());
        }
        catch (Exception exception) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    public List<String> getProductCategory(ShopCatInfDto dto) {
        List<String> ret = Arrays.asList(dto.getShoplagcatcd(), dto.getShopmidcatcd(), dto.getShopsmlcatcd(), dto.getShopdetcatcd());
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    private int ShopCategSearch(ShoppingmallDTO shoppingMallDetailDto, String sendcatno) throws IOException {
        int code = 0;
        if (sendcatno.length() == 3) {
            sendcatno = "";
        } else if (sendcatno.length() == 6) {
            sendcatno = sendcatno.substring(0, 3);
        } else if (sendcatno.length() == 9) {
            sendcatno = sendcatno.substring(0, 6);
        }
        String params = "?partner_key=" + shoppingMallDetailDto.getAUTHKEY1() + "&key=" + shoppingMallDetailDto.getAPIKEY() + "&cateCd=" + sendcatno;
        new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        MediaType mediaType = MediaType.parse((String)"");
        RequestBody.create((MediaType)mediaType, (String)params);
        try {
            String line;
            URL obj = new URL("https://openhub.godo.co.kr/godomall5/goods/Category_Search.php" + params);
            HttpsURLConnection conn = (HttpsURLConnection)obj.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String xml = "";
            while ((line = br.readLine()) != null) {
                xml = String.valueOf(xml) + line;
            }
            br.close();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GodomallProductDto.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            GodomallProductDto gddto = (GodomallProductDto)unmarshaller.unmarshal((Reader)new StringReader(xml));
            code = gddto.header.code;
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
        return code;
    }

    private String ShopCategoryCreate(ShoppingmallDTO shoppingMallDetailDto, ShopCatInfDto cateDto, ObjectMapper mapper, String catecd, List<String> class_nm, int size) throws JsonProcessingException, IOException, Exception {
        GodomallProductDto.Return.Category_data cd = new GodomallProductDto.Return.Category_data();
        new GodomallProductDto.Return.Goods_data();
        String params = "?partner_key=" + shoppingMallDetailDto.getAUTHKEY1() + "&key=" + shoppingMallDetailDto.getAPIKEY() + "&cateCd=" + catecd;
        new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        MediaType mediaType = MediaType.parse((String)"");
        RequestBody.create((MediaType)mediaType, (String)params);
        try {
            String line;
            URL obj = new URL("https://openhub.godo.co.kr/godomall5/goods/Category_Search.php" + params);
            HttpsURLConnection conn = (HttpsURLConnection)obj.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String xml = "";
            while ((line = br.readLine()) != null) {
                xml = String.valueOf(xml) + line;
            }
            br.close();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GodomallProductDto.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            GodomallProductDto cfr_ignored_0 = (GodomallProductDto)unmarshaller.unmarshal((Reader)new StringReader(xml.toString()));
            String[] strList = new String[3];
            if (catecd.length() == 3) {
                strList = new String[]{catecd.substring(0, 3)};
            } else if (catecd.length() == 6) {
                strList = new String[]{catecd.substring(0, 3), catecd.substring(0, 6)};
            } else if (catecd.length() == 9) {
                strList = new String[]{catecd.substring(0, 3), catecd.substring(0, 6), catecd.substring(0, 9)};
            } else if (catecd.length() == 12) {
                strList = new String[]{catecd.substring(0, 3), catecd.substring(0, 6), catecd.substring(0, 9), catecd.substring(0, 12)};
            }
            int i = size;
            while (i < class_nm.size()) {
                cd.cateCd = catecd;
                cd.cateNm = class_nm.get(i);
                if (i == 0) {
                    catecd = strList[i];
                    cateDto.setShoplagcatcd(catecd);
                } else if (i == 1) {
                    catecd = strList[i];
                    cateDto.setShopmidcatcd(catecd);
                } else if (i == 2) {
                    catecd = strList[i];
                    cateDto.setShopsmlcatcd(catecd);
                } else if (i == 3) {
                    catecd = strList[i];
                    cateDto.setShopdetcatcd(catecd);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ucf54\ub4dc\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return catecd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        int cnt = this.getMultithreadCount();
        try {
            int slp = 0;
            shopProductSendDto.getWorkMngDto().getWorkcd();
            int anum = 0;
            HashMap<String, String> cookie = new HashMap<String, String>();
            ShopGodomallAdditionalDto godomallDtlList = null;
            List<Object> strImages = new ArrayList();
            String xml = "";
            String templatefilename = "";
            switch (status2) {
                case "7": 
                case "8": {
                    godomallDtlList = (ShopGodomallAdditionalDto)shopProductSendDto.getProductAdditionDto();
                    strImages = new ArrayList();
                    strImages = godomallDtlList.getChangesize().equals("Y") ? this.getProductImages(shopProductDto, godomallDtlList.getChangeSizeX(), godomallDtlList.getChangeSizeY(), godomallDtlList.getChangeSizeW(), godomallDtlList.getChangeSizeH()) : this.getProductImages(shopProductDto);
                    xml = this.setProductDelete(shopProductDto);
                    templatefilename = this.setXmlFile(xml, ++anum);
                    this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto, templatefilename);
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    shopProductDto.setShopprodno("");
                    slp = 2000 * cnt;
                    Thread.sleep(slp);
                    return true;
                }
                case "0": {
                    Thread.sleep(1000L);
                    godomallDtlList = (ShopGodomallAdditionalDto)shopProductSendDto.getProductAdditionDto();
                    strImages = new ArrayList();
                    strImages = godomallDtlList.getChangesize().equals("Y") ? this.getProductImages(shopProductDto, godomallDtlList.getChangeSizeX(), godomallDtlList.getChangeSizeY(), godomallDtlList.getChangeSizeW(), godomallDtlList.getChangeSizeH()) : this.getProductImages(shopProductDto);
                    xml = this.setProductReg(shopProductDto, godomallDtlList, shoppingMallDetailDto, cookie, strImages);
                    templatefilename = this.setXmlFile(xml, ++anum);
                    this.productUpdateSend(shopProductDto, shoppingMallDetailDto, templatefilename);
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    slp = 5000 * cnt;
                    Thread.sleep(slp);
                    return true;
                }
                case "6": {
                    godomallDtlList = (ShopGodomallAdditionalDto)shopProductSendDto.getProductAdditionDto();
                    strImages = new ArrayList();
                    strImages = godomallDtlList.getChangesize().equals("Y") ? this.getProductImages(shopProductDto, godomallDtlList.getChangeSizeX(), godomallDtlList.getChangeSizeY(), godomallDtlList.getChangeSizeW(), godomallDtlList.getChangeSizeH()) : this.getProductImages(shopProductDto);
                    xml = this.setProductDelete(shopProductDto);
                    templatefilename = this.setXmlFile(xml, ++anum);
                    this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto, templatefilename);
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    shopProductDto.setShopprodno("");
                    slp = 2000 * cnt;
                    Thread.sleep(slp);
                }
                default: {
                    return true;
                }
                case "9": 
            }
            return true;
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            return false;
        }
    }

    private String SendGodomallProduct(ShoppingMallDetailDto shoppingMallDetailDto, String templatefilename) throws Exception {
        String goodsno = "";
        String xmlfile = "";
        xmlfile = "http://itsm.kdjsystem.com/xmldir/" + templatefilename;
        String response = "";
        String params = "?partner_key=" + shoppingMallDetailDto.getAuthkey1() + "&key=" + shoppingMallDetailDto.getApikey() + "&data_url=" + xmlfile;
        try {
            String line;
            URL obj = new URL("https://openhub.godo.co.kr/godomall5/goods/Goods_Insert.php" + params);
            HttpsURLConnection conn = (HttpsURLConnection)obj.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = br.readLine()) != null) {
                response = String.valueOf(response) + line;
            }
            br.close();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GodomallProductRegService.GodomallProductReg.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            GodomallProductRegService.GodomallProductReg gdReg = (GodomallProductRegService.GodomallProductReg)unmarshaller.unmarshal((Reader)new StringReader(response));
            goodsno = gdReg.header.code == 0 ? Integer.toString(gdReg.return1.goods_data.get((int)0).data.get((int)0).goodsno) : "";
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\ubc88\ud638\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        String remoteDir = "";
        remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
        FtpUtil.deletefile(remoteDir, templatefilename);
        File deleteFile = new File(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\" + templatefilename);
        if (deleteFile.exists()) {
            deleteFile.delete();
        }
        return goodsno;
    }

    private String setXmlFile(String xml, int anum) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("indent", "yes");
        DOMSource DOMsource = new DOMSource(doc);
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        anum = random.nextInt();
        String localfile = String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\SendProductGodomall" + YDMASessonUtil.getCompnoInfo().getCompno() + YDMASessonUtil.getUserInfo().getUserId() + Integer.toString(anum) + ".xml";
        StreamResult result = new StreamResult(new File(localfile));
        transformer.transform(DOMsource, result);
        String remoteDir = "";
        remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
        String templatefilename = FtpUtil.upload(remoteDir, localfile);
        return templatefilename;
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private String setErrorMessage(String error) {
        String errorMessage = "";
        errorMessage = error.contains("\uc0c1\ud488\uba85\uc5d0 \uc0ac\uc6a9 \uc81c\ud55c\ub41c \ub2e8\uc5b4") || error.contains("\uc0c1\ud488\uba85\uc5d0 \uc785\ub825\uc774 \ubd88\uac00\ub2a5\ud55c \ubb38\uc790") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488\uba85 \ud574\ub2f9 \ubb38\uc790 \uc785\ub825\ubd88\uac00] " + error : (error.contains("\uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \uac12\uc774 \uc5c6\uc74c") || error.contains("\uce74\ud14c\uace0\ub9ac\ub97c \ubaa8\ub450 \uc120\ud0dd") || error.contains("\uad8c\ud55c\uc774 \ud544\uc694\ud55c \uce74\ud14c\uace0\ub9ac") || error.contains("\uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \ucf54\ub4dc\uac00 \uc5c6\uc74c") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488 \uce74\ud14c\uace0\ub9ac \uac12 \ubd88\uc77c\uce58 \ubc0f \uc5c6\uc74c] " + error : (error.contains("\uae08\uc9c0\ub41c \ud0a4\uc6cc\ub4dc") || error.contains("\ub4f1\ub85d \ubd88\uac00 \ud0a4\uc6cc\ub4dc") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\ud574\ub2f9 \ud0a4\uc6cc\ub4dc \uc785\ub825\ubd88\uac00] " + error : "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : " + error));
        return errorMessage;
    }

    private int getMultithreadCount() {
        int cnt;
        try {
            cnt = ShopWorkDao.get().getMultiThreadCnt();
            int cores = Runtime.getRuntime().availableProcessors();
            if (cnt != 1 && cnt > cores / 2) {
                cnt = cores / 2;
            }
        }
        catch (Exception exception) {
            return 1;
        }
        return cnt;
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    private void setBasicInfo() {
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> loginCookie) throws Exception {
        String params = "?partner_key=" + shoppingMallDetailDto.getAUTHKEY1() + "&key=" + shoppingMallDetailDto.getAPIKEY() + "&goodsCd=" + dto.getShopprodno();
        new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        MediaType mediaType = MediaType.parse((String)"");
        RequestBody.create((MediaType)mediaType, (String)params);
        try {
            String line;
            URL obj = new URL("https://openhub.godo.co.kr/godomall5/goods/Goods_Search.php" + params);
            HttpsURLConnection conn = (HttpsURLConnection)obj.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String xml = "";
            while ((line = br.readLine()) != null) {
                xml = String.valueOf(xml) + line;
            }
            br.close();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GodomallProductDto.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            GodomallProductDto gddto = (GodomallProductDto)unmarshaller.unmarshal((Reader)new StringReader(xml));
            return gddto.header.total.equals("0");
        }
        catch (Exception exception) {
            return false;
        }
    }

    @XmlRootElement(name="data")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static final class GodomallMarshalDelete {
        @XmlElement(name="goods_data")
        public List<Goods_data> goods_data = new ArrayList<Goods_data>();

        private GodomallMarshalDelete() {
        }

        @XmlRootElement(name="goods_data")
        public static class Goods_data {
            @XmlElement(name="goodsNo")
            int goodsNo;
        }
    }

    @XmlRootElement(name="data")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class GodomallProductStop {
        @XmlElement(name="header")
        public Header header;
        @XmlElement(name="return")
        public Return return2;

        @XmlRootElement(name="header")
        public static class Header {
            @XmlElement(name="code")
            int code;
            @XmlElement(name="msg")
            String msg;
        }

        @XmlRootElement(name="return")
        public static class Return {
            @XmlElement(name="goods_data")
            public List<Goods_data> goods_data = new ArrayList<Goods_data>();

            @XmlRootElement(name="goods_data")
            public static class Goods_data {
                @XmlElement(name="goodsNo")
                int goodsNo;
                @XmlElement(name="goodsCd")
                String goodsCd;
            }
        }
    }

    @XmlRootElement(name="data")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class GodomallProductUpdate {
        @XmlElement(name="header")
        public Header header;
        @XmlElement(name="return")
        public Return return1;

        @XmlRootElement(name="header")
        public static class Header {
            @XmlElement(name="code")
            int code;
            @XmlElement(name="msg")
            String msg;
        }

        @XmlRootElement(name="return")
        public static class Return {
            @XmlElement(name="goods_data")
            public List<Goods_data> goods_data = new ArrayList<Goods_data>();

            @XmlRootElement(name="goods_data")
            public static class Goods_data {
                @XmlElement(name="code")
                int code;
                @XmlElement(name="idx")
                String idx;
                @XmlElement(name="msg")
                String msg;
                @XmlElement(name="data")
                List<Data> data;

                public static class Data {
                    @XmlElement(name="goodsno")
                    int goodsno;
                    @XmlElement(name="goodscd")
                    String goodscd;
                }
            }
        }
    }

    private static final class ProductStatusCategory {
        ChromeDriver driver;
        private static ProductStatusCategory instance = new ProductStatusCategory();

        private ProductStatusCategory() {
        }

        public static ProductStatusCategory get(ChromeDriver driver) {
            ProductStatusCategory.instance.driver = driver;
            return instance;
        }

        public void setSalesMethod(ShopProductAdditionDto dtllist) throws Exception {
            try {
                String script = String.format("$('input[name=\"is_display[1]\"]:eq(%s)').click();", "0");
                ChromeScript.get().addScript(script).executeScripter(this.driver);
                script = String.format("$('input[name=\"selling_status[1]\"]:eq(%s)').click();", "0");
                ChromeScript.get().addScript(script).executeScripter(this.driver);
            }
            catch (Exception exception) {
                throw new Exception("C0011");
            }
        }

        public void setSelectCateGory(ShopCatInfDto categoryDto) throws Exception {
            try {
                if (!categoryDto.getShoplagcatcd().isEmpty()) {
                    this.driver.executeScript(String.format("$('.eExposureCategory:eq(0) li')[%s].click()", categoryDto.getShoplagcatcd()), new Object[]{""});
                }
                Thread.sleep(1000L);
                if (!categoryDto.getShopmidcatcd().isEmpty()) {
                    this.driver.executeScript(String.format("$('.eExposureCategory:eq(1) li')[%s].click()", categoryDto.getShopmidcatcd()), new Object[]{""});
                }
                Thread.sleep(1000L);
                if (!categoryDto.getShopsmlcatcd().isEmpty()) {
                    this.driver.executeScript(String.format("$('.eExposureCategory:eq(2) li')[%s].click()", categoryDto.getShopsmlcatcd()), new Object[]{""});
                }
                Thread.sleep(1000L);
                if (!categoryDto.getShopdetcatcd().isEmpty()) {
                    this.driver.executeScript(String.format("$('.eExposureCategory:eq(3) li')[%s].click()", categoryDto.getShopdetcatcd()), new Object[]{""});
                }
            }
            catch (Exception exception) {
                throw new Exception("C0002");
            }
        }
    }
}

