/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.Melchi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.shop.common.ChromeExtention;
import com.kdjsystem.mlink.yellim.shop.common.ChromeScript;
import com.kdjsystem.mlink.yellim.shop.common.CodeItem;
import com.kdjsystem.mlink.yellim.shop.common.IShopCategoryCommand;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.common.IShopListener;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCategoryDto;
import com.kdjsystem.mlink.yellim.shop.data.Melchi.IShopCategoryMelchiCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

class MelchiCategoryLevel4Command
extends IShopCategoryMelchiCommand
implements IShopListener,
IShopCommonLogin {
    private static IShopCategoryCommand instance = new MelchiCategoryLevel4Command();
    IShopListener listener = null;

    public static IShopCategoryCommand getInstance() {
        return instance;
    }

    private MelchiCategoryLevel4Command() {
    }

    @Override
    public void Login(String loginID, String loginPw, String shopcd, String authkey) throws Exception {
        super.setFileDown(false);
        super.setHeadlessMode(true);
        super.Login(loginID, loginPw, shopcd, authkey);
    }

    @Override
    public int Search(String URL2, String loginID, String loginPw) throws Exception {
        return super.Search(URL2, loginID, loginPw);
    }

    @Override
    public List<ShopCategoryDto> Completed(List<ShopCategoryDto> param) throws Exception {
        ArrayList<ShopCategoryDto> dtolist = new ArrayList<ShopCategoryDto>();
        Map<String, String> loginCookie = null;
        loginCookie = this.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopcd(), true, "", "", "");
        Thread.sleep(1000L);
        Connection.Response response = Jsoup.connect((String)("https://scm.smelchi.com/product/categories/subCategoryLoad.json?refCateCd=" + param.get(0).getCatsmacd())).cookies(loginCookie).userAgent("User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36").referrer("https://spc-om.tmon.co.kr/").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
        String body = response.body();
        new ObjectMapper();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
        JsonArray catelist4 = (JsonArray)jsonObject.get("productCategory");
        int i = 0;
        while (i < catelist4.size()) {
            ShopCategoryDto shopCateDto = new ShopCategoryDto();
            JsonObject catedata = catelist4.get(i).getAsJsonObject();
            shopCateDto.setCatdtlcd(catedata.get("cateCd").toString());
            shopCateDto.setCatdtlnm(catedata.get("categoryName").toString().replace("\"", ""));
            dtolist.add(shopCateDto);
            ++i;
        }
        return dtolist;
    }

    public List<ShopCategoryDto> getHTMLParseManager(List<ShopCategoryDto> param) throws Exception {
        this.driver = ChromeExtention.getInstace().getDriver();
        String categ = param.get(0).getCatsmacd();
        WebElement select = this.driver.findElement(By.id((String)"cat-selector-2"));
        Select dropDown = new Select(select);
        List Options2 = dropDown.getOptions();
        for (WebElement option2 : Options2) {
            if (!option2.getAttribute("value").equals(categ)) continue;
            option2.click();
            break;
        }
        Thread.sleep(1000L);
        try {
            String script = "let items = document.querySelectorAll('#cat-selector-3 > option');     let ret_items =[]; \r\n\t\t\t \r\n\t\t\t for(let i=0;i<items.length;i++){\r\n\t\t\t    ret_items.push({\"code\":items[i].value, \"name\": items[i].innerText });\r\n\t\t\t }\r\n\t\t\t return JSON.stringify(ret_items);";
            String ret = ChromeScript.get().returnCallbackScripter(script, ChromeExtention.getInstace().getDriver());
            ObjectMapper mapper = new ObjectMapper();
            CodeItem[] dtoArray = (CodeItem[])mapper.readValue(ret, CodeItem[].class);
            ArrayList<ShopCategoryDto> dtolist = new ArrayList<ShopCategoryDto>();
            CodeItem[] codeItemArray = dtoArray;
            int n = dtoArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeItem dto = codeItemArray[n2];
                ShopCategoryDto dto2 = new ShopCategoryDto();
                dto2.setCatdtlcd(dto.getCode());
                dto2.setCatdtlnm(dto.getName());
                dtolist.add(dto2);
                ++n2;
            }
            String comm = ChromeScript.get().returnCallbackScripter("return  $(\"#service-fee-result\").text();", ChromeExtention.getInstace().getDriver());
            if (!comm.equals("null") && !comm.isEmpty()) {
                comm = comm.replaceAll("[^0-9]", "");
                this.onEvent(comm);
            } else {
                this.onEvent("");
            }
            return dtolist;
        }
        catch (Exception exception) {
            throw new Exception("\uc778\ud130\ud30c\ud06c \uc2e0\uaddc \uac00\uc838\uc624\uae30 \uce74\ud14c\uace0\ub9ac \ub9cc\ub4dc\ub294 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    @Override
    public void addEventListner(IShopListener listener) {
        this.listener = listener;
    }

    @Override
    public void onEvent(String val) {
        this.listener.onEvent(val);
    }

    @Override
    public List<ShopCategoryDto> excute(List<ShopCategoryDto> param) throws Exception {
        return null;
    }
}

