/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.FtpUtil;
import com.kdjsystem.mlink.yellim.common.YDMAHttpUtil;
import com.kdjsystem.mlink.yellim.common.YDMAProperties;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.data.xml.YDWMXmlManager;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.protocol.ElevenstProductOption;
import com.kdjsystem.mlink.yellim.protocol.ElevenstProductOptionExt;
import com.kdjsystem.mlink.yellim.protocol.ElevenstProductOptionResponse;
import com.kdjsystem.mlink.yellim.protocol.ElevenstUpdateOptionRequest;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProduct11stAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ElevenstProductModifyService
implements IProductModifyProcess {
    List<ShopOptionDto> shopOptionDtos = null;

    public boolean isNotNullEmpty(String val) {
        if (val == null) {
            return false;
        }
        return !val.trim().isEmpty();
    }

    private ResultClientMessage setStartOrStopApi(String status2, ProductDTO shopProductDto, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("8", String.format("http://api.11st.co.kr/rest/prodstatservice/stat/stopdisplay/%s", shopProductDto.getShopprodno()));
        map.put("9", String.format("http://api.11st.co.kr/rest/prodstatservice/stat/restartdisplay/%s", shopProductDto.getShopprodno()));
        ResultClientMessage result = new ResultClientMessage();
        try {
            String url = (String)map.get(status2);
            Hashtable<String, String> htRequestProperty = new Hashtable<String, String>();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", shoppingMallDetailDto.getAPIKEY());
            String response = YDMAHttpUtil.put(url, "", htRequestProperty);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ResultClientMessage.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(response.toString());
            result = (ResultClientMessage)jaxbUnmarshaller.unmarshal((Reader)reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return result;
    }

    private ResultClientMessage setModifyApi(String xml, String apikey, String prodNo) throws Exception {
        PutMethod put = new PutMethod(String.format("http://api.11st.co.kr/rest/prodservices/product/%s", prodNo));
        put.setRequestHeader("openapikey", apikey);
        YDMAStringUtil.Print(xml);
        HttpClient httpclient = new HttpClient();
        try {
            ResultClientMessage result;
            StringRequestEntity entity = new StringRequestEntity(xml, "text/xml", "EUC-KR");
            put.setRequestEntity((RequestEntity)entity);
            httpclient.executeMethod((HttpMethod)put);
            YDMAStringUtil.Print("[MSG] StatusCode : " + put.getStatusCode());
            YDMAStringUtil.Print("[MSG] Result -Xml : " + put.getResponseBodyAsString());
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ResultClientMessage.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(put.getResponseBodyAsString());
            ResultClientMessage resultClientMessage = result = (ResultClientMessage)jaxbUnmarshaller.unmarshal((Reader)reader);
            return resultClientMessage;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            put.releaseConnection();
        }
    }

    private ResultClientMessage setSoldoutApi(String xml, String apikey, String shopprodno) throws Exception {
        PutMethod put = new PutMethod(String.format("http://api.11st.co.kr/rest/prodstatservice/stat/stopdisplay/%s", shopprodno));
        put.setRequestHeader("openapikey", apikey);
        HttpClient httpclient = new HttpClient();
        try {
            ResultClientMessage result;
            StringRequestEntity entity = new StringRequestEntity(xml, "text/xml", "EUC-KR");
            put.setRequestEntity((RequestEntity)entity);
            httpclient.executeMethod((HttpMethod)put);
            YDMAStringUtil.Print("[MSG] StatusCode : " + put.getStatusCode());
            YDMAStringUtil.Print("[MSG] Result -Xml : " + put.getResponseBodyAsString());
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ResultClientMessage.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(put.getResponseBodyAsString());
            ResultClientMessage resultClientMessage = result = (ResultClientMessage)jaxbUnmarshaller.unmarshal((Reader)reader);
            return resultClientMessage;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            put.releaseConnection();
        }
    }

    private String get11stXml(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        ShopProduct11stAdditionDto dtllist11st = (ShopProduct11stAdditionDto)dtllist;
        YDWMXmlManager.updateSendProductList11stTemplate(shopProductDto, dtllist11st, shoppingMallDetailDto);
        FtpUtil.uploadXmlFileToWeb('T');
        String fileName = YDMAProperties.getInstance().getAppProperty("11st.productListTempateFile");
        String cfr_ignored_0 = "http://itsm.kdjsystem.com/xmldir/" + fileName;
        StringBuffer fileData = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\03.SabangNet\\template\\SendProductList11st.xml"), "EUC-KR"));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            fileData.append(buf, 0, numRead);
        }
        reader.close();
        String xml_string_to_send = fileData.toString();
        return xml_string_to_send;
    }

    public String get11stCalcDate(String dateCode) {
        String result = "";
        String startDate = YDMATimeUtil.getCurrentDateScheduler();
        String[] calcValue = dateCode.split(":");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = simpleDateFormat.parse(startDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, Integer.parseInt(calcValue[0]));
            result = simpleDateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto) throws Exception {
        ResultClientMessage result = null;
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 3000: 
                case 4000: {
                    result = this.setStartOrStopApi("8", dto.getPRODUCT(), dto.getSHOPINFO());
                    if (result.resultCode.equals("200") || result.resultCode.equals("201")) {
                        this.setDelete(dto.getCOOKIES(), dto.getPRODUCT().getShopprodno(), dto.getPRODUCT());
                        return new ResultProcessDTO(0, result.message, dto.getPRODUCT().getSENDSEQ());
                    }
                    return new ResultProcessDTO(-1, result.message, dto.getPRODUCT().getSENDSEQ());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new ResultProcessDTO(-1, ex.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
        return new ResultProcessDTO();
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        PostMethod post = new PostMethod(MallCode.getElevenstOptionModifyURL(dto.getPRODUCT().getShopprodno()));
        post.setRequestHeader("openapikey", dto.getSHOPINFO().getAPIKEY());
        try {
            ArrayList<ElevenstProductOption> requestOptions = new ArrayList<ElevenstProductOption>();
            List<ProductOptionDTO> options = dto.getPRODUCT().getOPTIONS();
            List<ProductOptionDTO> oldOptions = ProductDAO.get().selectOptProductIn(dto.getPRODUCT().getSENDSEQ());
            for (ProductOptionDTO oldOption : oldOptions) {
                ProductOptionDTO filter = options.stream().filter(p -> p.getSENDSEQ() == oldOption.getSENDSEQ() && p.getSKUSEQ() == oldOption.getSKUSEQ()).findFirst().orElse(null);
                ElevenstProductOption requestOption = new ElevenstProductOption();
                if (filter == null) {
                    requestOption.useYn = "Y";
                    requestOption.colOptPrice = String.valueOf(oldOption.getOPTADDAMT());
                    requestOption.colCount = String.valueOf(oldOption.getOPTVERTSTOCK());
                    requestOption.colSellerStockCd = oldOption.getOPTPRODCD();
                    requestOption.optionMappingKey = String.valueOf(oldOption.getOPTPRODNM()) + ":" + oldOption.getOPTSPECDES();
                } else {
                    requestOption.useYn = "N";
                    requestOption.colOptPrice = "0";
                    requestOption.colCount = "0";
                    requestOption.colSellerStockCd = oldOption.getOPTPRODCD();
                    requestOption.optionMappingKey = String.valueOf(oldOption.getOPTPRODNM()) + ":" + oldOption.getOPTSPECDES();
                }
                requestOptions.add(requestOption);
            }
            ElevenstProductOptionExt requestOptionExt = new ElevenstProductOptionExt();
            requestOptionExt.productOption = requestOptions;
            ElevenstUpdateOptionRequest request2 = new ElevenstUpdateOptionRequest();
            request2.optSelectYn = "Y";
            request2.txtColCnt = "1";
            request2.optMixYn = "N";
            request2.productOptionExt = requestOptionExt;
            JAXBContext jaxbReqContext = JAXBContext.newInstance((Class[])new Class[]{ElevenstUpdateOptionRequest.class});
            Marshaller marshaller = jaxbReqContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"euc-kr");
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)request2, (Writer)writer);
            String xml = writer.toString().replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            StringRequestEntity entity = new StringRequestEntity(xml, "text/xml", "EUC-KR");
            post.setRequestEntity((RequestEntity)entity);
            new HttpClient().executeMethod((HttpMethod)post);
            YDMAStringUtil.Print("[MSG] Result -Xml : " + post.getResponseBodyAsString());
            JAXBContext jaxbRespContext = JAXBContext.newInstance((Class[])new Class[]{ElevenstProductOptionResponse.class});
            Unmarshaller jaxbUnmarshaller = jaxbRespContext.createUnmarshaller();
            StringReader reader = new StringReader(post.getResponseBodyAsString());
            ElevenstProductOptionResponse result = (ElevenstProductOptionResponse)jaxbUnmarshaller.unmarshal((Reader)reader);
            if (result.resultCode.equals("200")) {
                ResultProcessDTO resultProcessDTO = new ResultProcessDTO(0, result.message, dto.getPRODUCT().getCompayny_goods_cd());
                return resultProcessDTO;
            }
            ResultProcessDTO resultProcessDTO = new ResultProcessDTO(-1, result.message, dto.getPRODUCT().getCompayny_goods_cd());
            return resultProcessDTO;
        }
        catch (Exception e) {
            e.printStackTrace();
            ResultProcessDTO resultProcessDTO = new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getCompayny_goods_cd());
            return resultProcessDTO;
        }
        finally {
            post.releaseConnection();
        }
    }

    private boolean setDelete(Map<String, String> cookie, String shopProdNo, ProductDTO productDto) throws Exception {
        boolean flag = false;
        String url = "https://soffice.11st.co.kr/product/SellProductAjaxAction.tmall?method=updateProductHideListJSON&hideYN=Y";
        try {
            Connection.Response response = Jsoup.connect((String)url).cookies(cookie).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("http://soffice.11st.co.kr/product/SellProductAction.tmall?method=getSellProductList").data("chkPrdNoList", shopProdNo).data("chkPrdNoCount", "1").ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).method(Connection.Method.POST).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = (JsonObject)parser.parse(body);
            flag = object.get("success").getAsBoolean();
            if (flag) {
                productDto.setResult_text("\uc815\uc0c1\uc801\uc73c\ub85c \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            } else {
                productDto.setResult_text(object.get("data").getAsJsonObject().get("responseMsg").getAsString());
            }
        }
        catch (Exception e) {
            throw new Exception("\uc0c1\ud488\uc744 \uc601\uad6c\uc0ad\uc81c\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + e.getMessage());
        }
        return flag;
    }

    static final class AdaptorCDATA
    extends XmlAdapter<String, String> {
        AdaptorCDATA() {
        }

        public String marshal(String v) throws Exception {
            return "<![CDATA[" + v + "]]>";
        }

        public String unmarshal(String v) throws Exception {
            return v;
        }
    }

    @XmlRootElement(name="ClientMessage")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static final class ResultClientMessage {
        @XmlElement(name="message")
        String message;
        @XmlElement(name="preSelPrc")
        String preSelPrc;
        @XmlElement(name="productNo")
        String productNo;
        @XmlElement(name="resultCode")
        String resultCode;

        ResultClientMessage() {
        }
    }
}

