/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.mlink;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMAHttpUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.helper.LoginHelper;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.data.cafe24.Cafe24AcessToken;
import com.kdjsystem.mlink.yellim.shop.data.lotteon.LotteOnProductQnaDto;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MLinkShopStateUpdate {
    static MLinkShopStateUpdate instance = new MLinkShopStateUpdate();

    public static MLinkShopStateUpdate get() {
        return instance;
    }

    public ShoppingmallDTO mallStatusUpdate(boolean execFlag, ShoppingmallDTO shopinfo) throws Exception {
        String shopcd = shopinfo.getSHOPCD();
        String date = YDMATimeUtil.getCurrentDateHanjin();
        switch (shopcd) {
            case "shop0067": 
            case "shop0068": 
            case "shop00671": 
            case "shop00681": {
                this.getESMStatus(shopinfo, LoginHelper.loginCookie(shopinfo));
                break;
            }
            case "shop0004": {
                this.getInterparkStatus(shopinfo, LoginHelper.loginCookie(shopinfo));
                break;
            }
            case "shop0055": {
                this.getSmartStoreStatus(shopinfo, LoginHelper.loginCookie(shopinfo));
                break;
            }
            case "shop0057": {
                this.getNaverPayStatus(shopinfo, LoginHelper.loginCookie(shopinfo));
                break;
            }
            case "shop0003": 
            case "shop00031": {
                PreferencesMallDTO conf = ShopCommonDao.get().getSystemConf();
                if (conf.getSecondAuth11styn().equals("Y")) {
                    this.get11stStatus(shopinfo, date, LoginHelper.loginCookie(shopinfo));
                    break;
                }
                this.get11stStatus(shopinfo, date);
                break;
            }
            case "shop0110": {
                this.getCafe24Status(shopinfo, LoginHelper.loginCookie(shopinfo));
                break;
            }
            case "shop0076": {
                this.getTmonStatus(shopinfo, LoginHelper.loginCookie(shopinfo));
                break;
            }
            case "shop0273": {
                this.getKakaoStoreStatus(shopinfo, date);
                break;
            }
            case "shop0075": {
                this.getCoupangStatus(shopinfo, LoginHelper.loginCookie(shopinfo));
                break;
            }
            case "shop0287": {
                this.getWemakepriceStatus(shopinfo);
                break;
            }
            case "shop0411": {
                if (!execFlag) break;
                this.getSsgStatus(shopinfo);
                break;
            }
            case "shop0372": {
                this.getLotteOnStatus(shopinfo, date);
                break;
            }
            case "shop0106": {
                this.getMelchiStatus(shopinfo, LoginHelper.loginCookie(shopinfo));
                break;
            }
            case "shop0233": {
                this.get72timeStatus(shopinfo, LoginHelper.loginCookie(shopinfo), YDMATimeUtil.getCurrentDateScheduler());
                break;
            }
            case "shop9982": {
                this.getTossShoppingStatus(shopinfo, date);
                break;
            }
            case "shop9984": {
                this.getAlwayzStatus(shopinfo);
            }
        }
        return shopinfo;
    }

    public ShoppingmallDTO get11stStatus(ShoppingmallDTO shopinfo, String date) throws InterruptedException {
        shopinfo.setCOOKIES("success");
        try {
            String apikey = shopinfo.getAPIKEY();
            String startdt = YDMATimeUtil.getNetworkDayToSubtract(date, -6);
            String enddt = date;
            String startdt_tm = String.valueOf(startdt) + "0000";
            LocalDateTime now = LocalDateTime.now();
            String enddt_tm = String.valueOf(date) + String.format("%02d", now.getHour()) + String.format("%02d", now.getMinute());
            Hashtable<String, String> htRequestProperty = new Hashtable<String, String>();
            String url = String.format("https://api.11st.co.kr/rest/alimi/getalimilist/%s/%s/01", startdt, enddt);
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            String response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int emernotice = response.length() - response.replace("<emerNtceSeq>", "").length();
            shopinfo.setSHOPNOTICE(emernotice / 13);
            url = String.format("http://api.11st.co.kr/rest/prodqnaservices/prodqnalist/%s/%s/02", startdt, enddt);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int question = response.length() - response.replace("<brdInfoClfNo>", "").length();
            shopinfo.setCUSTOMERQNA(question / 14);
            url = String.format("http://api.11st.co.kr/rest/claimservice/cancelorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int cancelReq = response.length() - response.replace("<ordCnDtlsRsn>", "").length();
            url = String.format("http://api.11st.co.kr/rest/claimservice/returnorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int returnReq = response.length() - response.replace("<clmReqCont>", "").length();
            url = String.format("http://api.11st.co.kr/rest/claimservice/exchangeorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int exchangeReq = response.length() - response.replace("<clmReqCont>", "").length();
            shopinfo.setCANCELLATIONORDER(cancelReq / 14 + returnReq / 12 + exchangeReq / 12);
            url = String.format("https://api.11st.co.kr/rest/ordservices/complete/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int neword = response.length() - response.replace("<bndlDlvSeq>", "").length();
            shopinfo.setNEWORDER(neword / 12);
            url = String.format("https://api.11st.co.kr/rest/ordservices/packaging/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int shippedbefore = response.length() - response.replace("<bndlDlvSeq>", "").length();
            shopinfo.setSHIPPEDBEFORE(shippedbefore / 12);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("11\ubc88\uac00 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO get11stStatus(ShoppingmallDTO shopinfo, String date, Map<String, String> cookie) throws InterruptedException {
        shopinfo.setCOOKIES("success");
        try {
            PreferencesMallDTO dto = ShopCommonDao.get().getSystemConf();
            String apikey = shopinfo.getAPIKEY();
            String startdt = YDMATimeUtil.getNetworkDayToSubtract(date, -6);
            String enddt = date;
            String startdt_tm = String.valueOf(startdt) + "0000";
            LocalDateTime now = LocalDateTime.now();
            String enddt_tm = String.valueOf(date) + String.format("%02d", now.getHour()) + String.format("%02d", now.getMinute());
            Hashtable<String, String> htRequestProperty = new Hashtable<String, String>();
            String url = String.format("https://api.11st.co.kr/rest/alimi/getalimilist/%s/%s/01", startdt, enddt);
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            String response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int emernotice = response.length() - response.replace("<emerNtceSeq>", "").length();
            shopinfo.setSHOPNOTICE(emernotice / 13);
            url = String.format("http://api.11st.co.kr/rest/prodqnaservices/prodqnalist/%s/%s/02", startdt, enddt);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int question = response.length() - response.replace("<brdInfoClfNo>", "").length();
            shopinfo.setCUSTOMERQNA(question / 14);
            url = String.format("http://api.11st.co.kr/rest/claimservice/cancelorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int cancelReq = response.length() - response.replace("<ordCnDtlsRsn>", "").length();
            url = String.format("http://api.11st.co.kr/rest/claimservice/returnorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int returnReq = response.length() - response.replace("<clmReqCont>", "").length();
            url = String.format("http://api.11st.co.kr/rest/claimservice/exchangeorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int exchangeReq = response.length() - response.replace("<clmReqCont>", "").length();
            shopinfo.setCANCELLATIONORDER(cancelReq / 14 + returnReq / 12 + exchangeReq / 12);
            url = String.format("https://api.11st.co.kr/rest/ordservices/complete/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int neword = response.length() - response.replace("<bndlDlvSeq>", "").length();
            shopinfo.setNEWORDER(neword / 12);
            url = String.format("https://api.11st.co.kr/rest/ordservices/packaging/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int shippedbefore = response.length() - response.replace("<bndlDlvSeq>", "").length();
            shopinfo.setSHIPPEDBEFORE(shippedbefore / 12);
            shopinfo.setCOOKIES(cookie.toString());
            if (dto.getSecondAuth11styn().equals("Y")) {
                Connection.Response prodResponse = Jsoup.connect((String)"https://apis.11st.co.kr/product/bruce/selleroffice/v1/main/product-current-count").cookies(cookie).userAgent("User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
                String prodBody = prodResponse.body();
                JsonParser parser = new JsonParser();
                JsonObject prodObject = parser.parse(prodBody).getAsJsonObject();
                int saleProduct = prodObject.get("selling").getAsInt();
                int endScheduleProduct = prodObject.get("sellingDueDaySoon").getAsInt();
                shopinfo.setONSALEPRODUCT(saleProduct);
                shopinfo.setCLOSESALE(endScheduleProduct);
                shopinfo.setREGISTERPRODUCT(saleProduct + endScheduleProduct);
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("11\ubc88\uac00 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getInterparkStatus(ShoppingmallDTO shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCOOKIES(cookie.toString());
            Document response_order = Jsoup.connect((String)"https://seller.buyzle.co.kr/main/sales").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).get();
            Elements sales = response_order.select("div.statusBox > dl > a > dd");
            int neworder = Integer.parseInt(((Element)sales.get(1)).text());
            int confirmorder = Integer.parseInt(((Element)sales.get(2)).text());
            int claim = Integer.parseInt(((Element)sales.get(12)).text()) + Integer.parseInt(((Element)sales.get(13)).text()) + Integer.parseInt(((Element)sales.get(14)).text());
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            shopinfo.setCANCELLATIONORDER(claim);
            Document response_qna = Jsoup.connect((String)"https://seller.buyzle.co.kr/main/customer").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).get();
            Elements inquiry = response_qna.select("span.tText");
            int notice = Integer.parseInt(((Element)inquiry.get(1)).text().replaceAll("[^0-9]", ""));
            int qna = Integer.parseInt(((Element)inquiry.get(0)).text().replaceAll("[^0-9]", ""));
            shopinfo.setSHOPNOTICE(notice);
            shopinfo.setCUSTOMERQNA(qna);
            Document response_prd = Jsoup.connect((String)"https://seller.buyzle.co.kr/main/sales-status").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).get();
            Elements prd = response_prd.select("div.statusBox > dl > dd");
            int onsale = ((Element)prd.get(0)).text().equals("") ? 0 : Integer.parseInt(((Element)prd.get(0)).text().replaceAll("[^0-9]", ""));
            int sellingDueDaySoon = ((Element)prd.get(1)).text().equals("") ? 0 : Integer.parseInt(((Element)prd.get(1)).text().replaceAll("[^0-9]", ""));
            shopinfo.setONSALEPRODUCT(onsale);
            shopinfo.setREGISTERPRODUCT(-1);
            shopinfo.setCLOSESALE(sellingDueDaySoon);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uc778\ud130\ud30c\ud06c \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd" + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto ex_getInterparkStatus(ShoppingMallDetailDto shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCookies(cookie.toString());
            Connection.Response response_order = Jsoup.connect((String)"http://ipss.interpark.com/ipss/ipssmainscr.do?_method=getOrderAndClaimCount&_style=ipssPro&orderDays=30&claimDays=30&searchTp=NOTSETT").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = response_order.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            int neworder = jsonObject.get("newOrder").getAsInt() + jsonObject.get("newOrderGlobal").getAsInt();
            int confirmorder = jsonObject.get("deliveryReq").getAsInt() + jsonObject.get("deliveryReqGlobal").getAsInt();
            int claim = jsonObject.get("recExchangeCnt").getAsInt() + jsonObject.get("recReturnCnt").getAsInt() + jsonObject.get("requestCancelCount").getAsInt();
            int qna = jsonObject.get("qnaNUrgentCount").getAsInt();
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            shopinfo.setCancellationorder(claim);
            shopinfo.setCustomerqna(qna);
            Connection.Response response_prd = Jsoup.connect((String)"http://ipss.interpark.com/product/SellerLightProductSearch.do?_method=conditionSimple&_style=ipssPro").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body2 = response_prd.body();
            JsonObject jsonObject2 = (JsonObject)jsonParser.parse(body2);
            int sellingDueDaySoon = jsonObject2.get("pcondition3").getAsInt();
            shopinfo.setClosesale(sellingDueDaySoon);
            shopinfo.setShopnotice(0);
            shopinfo.setOnsaleproduct(-1);
            shopinfo.setRegisterproduct(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uc778\ud130\ud30c\ud06c \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getSmartStoreStatus(ShoppingmallDTO shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCOOKIES(cookie.toString());
            Connection.Response response_order = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/dashboards/pay/sale-stats").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body = response_order.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            int neworder = jsonObject.get("newOrderCases").getAsInt();
            int confirmorder = jsonObject.get("deliveryPreparingCases").getAsInt();
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            Connection.Response response_claim = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/dashboards/pay/claim").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body2 = response_claim.body();
            JsonObject jsonObject2 = (JsonObject)jsonParser.parse(body2);
            int claim = jsonObject2.get("cancelClaimCases").getAsInt() + jsonObject2.get("exchangeClaimCases").getAsInt() + jsonObject2.get("returnClaimCases").getAsInt();
            shopinfo.setCANCELLATIONORDER(claim);
            Connection.Response response_prd = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/dashboards/channel/products").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body3 = response_prd.body();
            JsonObject jsonObject3 = (JsonObject)jsonParser.parse(body3);
            int onsale = Integer.parseInt(jsonObject3.get("onSaleProductCount").getAsString().replace(",", ""));
            shopinfo.setCLOSESALE(-1);
            shopinfo.setSHOPNOTICE(-1);
            shopinfo.setREGISTERPRODUCT(-1);
            shopinfo.setONSALEPRODUCT(onsale);
            Connection.Response response_inquiry = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/dashboards/inquiries?isRefresh=false&page=0&size=4").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body4 = response_inquiry.body();
            JsonObject jsonObject4 = (JsonObject)jsonParser.parse(body4);
            int inquiry = jsonObject4.get("customerInquiryCount").getAsInt() + jsonObject4.get("productInquiryCount").getAsInt() + jsonObject4.get("talktalkInquiryCount").getAsInt();
            shopinfo.setCUSTOMERQNA(inquiry);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getNaverPayStatus(ShoppingmallDTO shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCOOKIES(cookie.toString());
            Connection.Response rs = Jsoup.connect((String)"https://admin.pay.naver.com/").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            Document body = Jsoup.parseBodyFragment((String)rs.body());
            String newOrder = body.select("#container > div.aside > div.orderinfo > ul > li:nth-child(1) > em > a").text();
            shopinfo.setNEWORDER(Integer.parseInt(newOrder));
            String confirmorder = body.select("#container > div.aside > div.orderinfo > ul > li:nth-child(2) > em > a").text();
            shopinfo.setSHIPPEDBEFORE(Integer.parseInt(confirmorder));
            String cancel = body.select("#cancelClaimCases > strong").text();
            String exchange = body.select("#exchangeClaimCases > strong").text();
            String returnOrd = body.select("#returnClaimCases > strong").text();
            shopinfo.setCANCELLATIONORDER(Integer.parseInt(cancel) + Integer.parseInt(exchange) + Integer.parseInt(returnOrd));
            String Question = body.select("#container > div.aside > div.orderinfo > ul > li.last > em > a").text();
            shopinfo.setCUSTOMERQNA(Integer.parseInt(Question));
        }
        catch (Exception e) {
            shopinfo.setCOOKIES("");
            YDMAStringUtil.Print("\ub124\uc774\ubc84 \ud398\uc774\ub97c \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. " + e);
        }
        return shopinfo;
    }

    public ShoppingmallDTO getESMStatus(ShoppingmallDTO shopinfo, Map<String, String> cookie) {
        try {
            String shopcd = shopinfo.getSHOPCD();
            JsonParser jsonParser = new JsonParser();
            shopinfo.setCOOKIES(cookie.toString());
            Connection.Response response_order = Jsoup.connect((String)"https://www.esmplus.com/SellNote/Info/HomeSellNoteData?isUseCache=1").referrer("https://www.esmplus.com/Home/Home").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject orderObject = (JsonObject)jsonParser.parse(response_order.body());
            orderObject = shopcd.equals("shop0067") || shopcd.equals("shop00671") ? orderObject.get("IACSellNoteData").getAsJsonObject() : (shopcd.equals("shop0068") || shopcd.equals("shop00681") ? orderObject.get("GMKTSellNoteData").getAsJsonObject() : orderObject.get("TotalSellNoteData").getAsJsonObject());
            int neworder = orderObject.get("NewOrder").getAsInt();
            int confirmorder = orderObject.get("DeliveryRequest").getAsInt();
            int claim = orderObject.get("ExchangeRequest").getAsInt() + orderObject.get("CancelRequest").getAsInt() + orderObject.get("ReturnRequest").getAsInt();
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            shopinfo.setCANCELLATIONORDER(claim);
            Connection.Response response_stock = Jsoup.connect((String)"https://www.esmplus.com/Home/MainGoodsData").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject stockObject = (JsonObject)jsonParser.parse(response_stock.body());
            stockObject = shopcd.equals("shop0067") || shopcd.equals("shop00671") ? (JsonObject)stockObject.get("IACMainGoodsDat") : (shopcd.equals("shop0068") || shopcd.equals("shop00681") ? (JsonObject)stockObject.get("GMKTMainGoodsDat") : (JsonObject)stockObject.get("TotalMainGoodsDat"));
            int stock = stockObject.get("SellStopLe7Cnt").getAsInt();
            shopinfo.setCLOSESALE(stock);
            String body = "";
            if (shopcd.equals("shop0067") || shopcd.equals("shop00671")) {
                Connection.Response inquiry_auction = Jsoup.connect((String)"https://www.esmplus.com/Home/HomeDetailQna?type=1").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
                body = inquiry_auction.body();
            } else if (shopcd.equals("shop0068") || shopcd.equals("shop00681")) {
                Connection.Response inquiry_gmarket = Jsoup.connect((String)"https://www.esmplus.com/Home/HomeDetailQna?type=2").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
                body = inquiry_gmarket.body();
            }
            JsonObject inquiryObject = (JsonObject)jsonParser.parse(body);
            int notice = inquiryObject.get("EmergencyQnACount").getAsInt();
            int inquiry = inquiryObject.get("ItemQnACount").getAsInt() + inquiryObject.get("NoteCount").getAsInt();
            String site = "";
            if (shopcd.equals("shop0067") || shopcd.equals("shop00671")) {
                site = "1";
            } else if (shopcd.equals("shop0068") || shopcd.equals("shop00681")) {
                site = "2";
            }
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append("{").append("\"Keyword\":\"\",").append("\"SiteId\":\"").append(site).append("\",").append("\"CategorySiteId\":-1,").append("\"CategoryCode\":\"\",").append("\"CategoryLevel\":\"\",").append("\"TransPolicyNo\":0,").append("\"StatusCode\":\"11\",").append("\"SearchDateType\":0,").append("\"SearchStartDate\":\"\",").append("\"SearchEndDate\":\"\",").append("\"SellerId\":\"").append(shopinfo.getSHOPPINGID()).append("\",").append("\"SellerSiteId\":\"").append(site).append("\",").append("\"StockQty\":-1,").append("\"SellPeriod\":0,").append("\"DiscountUseIs\":-1,").append("\"DeliveryFeeApplyType\":0,").append("\"OptAddDeliveryType\":0,").append("\"OptSelUseIs\":-1,").append("\"PremiumEnd\":0,").append("\"PremiumPlusEnd\":0,").append("\"FocusEnd\":0,").append("\"FocusPlusEnd\":0,").append("\"GoodsIdType\":\"S\",").append("\"GoodsIds\":\"\",").append("\"ShopCateReg\":-1,").append("\"IsTPLUse\":\"\",").append("\"SellMinPrice\":0,").append("\"SellMaxPrice\":0,").append("\"OrderByType\":11,").append("\"GroupOrderByType\":1,").append("\"IsGroupUse\":\"\",").append("\"IsApplyEpin\":\"\",").append("\"IsConvertSingleGoods\":\"\",").append("\"DisplayLimityn\":\"\"").append("}");
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Sell/SingleGoodsMng/GetSingleGoodsList?_dc=1617695796702").cookies(cookie).header("Host", "www.esmplus.com").header("Origin", "http://www.esmplus.com").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").data("paramsData", jsonBuilder.toString()).data("page", "1").data("start", "0").data("limit", "30").referrer("http://www.esmplus.com/Sell/SingleGoodsMng?menuCode=TDM396").method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            JsonObject jsonobject = (JsonObject)jsonParser.parse(rs.body());
            int prodCount = jsonobject.get("total").getAsInt();
            shopinfo.setSHOPNOTICE(notice);
            shopinfo.setCUSTOMERQNA(inquiry);
            shopinfo.setREGISTERPRODUCT(-1);
            shopinfo.setONSALEPRODUCT(prodCount);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("ESM \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getCoupangStatus(ShoppingmallDTO shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCOOKIES(cookie.toString());
            Connection.Response response_prd = Jsoup.connect((String)"https://wing.coupang.com/home-cards/ProductManagement/data?platform=DESKTOP").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body = response_prd.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("data");
            jsonObject = (JsonObject)jsonObject.get("valid");
            int onsale = jsonObject.get("count").getAsInt();
            shopinfo.setONSALEPRODUCT(onsale);
            Connection.Response response_order = Jsoup.connect((String)"https://wing.coupang.com/home-cards/SalesDelivery/data?platform=DESKTOP").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body2 = response_order.body();
            JsonObject jsonObject2 = (JsonObject)jsonParser.parse(body2);
            jsonObject2 = (JsonObject)jsonObject2.get("data");
            jsonObject2 = (JsonObject)jsonObject2.get("statuses");
            JsonObject accept = (JsonObject)jsonObject2.get("accept");
            JsonObject instruct = (JsonObject)jsonObject2.get("instruct");
            int neworder = accept.get("count").getAsInt();
            int confirmorder = instruct.get("count").getAsInt();
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            Connection.Response response_claim = Jsoup.connect((String)"https://wing.coupang.com/home-cards/CancelReturnExchange/data?platform=DESKTOP").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body3 = response_claim.body();
            JsonObject jsonObject3 = (JsonObject)jsonParser.parse(body3);
            jsonObject3 = (JsonObject)jsonObject3.get("data");
            JsonObject exchange = (JsonObject)jsonObject3.get("exchange");
            JsonObject releaseStop = (JsonObject)jsonObject3.get("releaseStop");
            JsonObject unConfirm = (JsonObject)jsonObject3.get("unConfirm");
            int claim = exchange.get("count").getAsInt() + releaseStop.get("count").getAsInt() + unConfirm.get("count").getAsInt();
            shopinfo.setCANCELLATIONORDER(claim);
            Connection.Response response_inquiry = Jsoup.connect((String)"https://wing.coupang.com/home-cards/UnansweredInquiry/data?platform=DESKTOP").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body4 = response_inquiry.body();
            JsonObject jsonObject4 = (JsonObject)jsonParser.parse(body4);
            jsonObject4 = (JsonObject)jsonObject4.get("data");
            JsonObject csUnansweredInquiry = (JsonObject)jsonObject4.get("csUnansweredInquiry");
            JsonObject productUnansweredInquiry = (JsonObject)jsonObject4.get("productUnansweredInquiry");
            int inquiry = csUnansweredInquiry.get("count").getAsInt() + productUnansweredInquiry.get("count").getAsInt();
            shopinfo.setCUSTOMERQNA(inquiry);
            shopinfo.setSHOPNOTICE(-1);
            shopinfo.setREGISTERPRODUCT(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ucfe0\ud321 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getTmonStatus(ShoppingmallDTO shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCOOKIES(cookie.toString());
            Connection.Response response_prd = Jsoup.connect((String)"https://spc-www.tmon.co.kr/api/SELL/JSON").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body = response_prd.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("data");
            JsonArray arr = (JsonArray)jsonObject.get("result");
            JsonObject onsale = (JsonObject)arr.get(0);
            JsonObject closesoon = (JsonObject)arr.get(1);
            int sales = Integer.parseInt(onsale.get("text1").getAsString().replace(",", "").replace("\uac74", "").trim());
            int closed = Integer.parseInt(closesoon.get("text1").getAsString().replace(",", "").replace("\uac74", "").trim());
            shopinfo.setONSALEPRODUCT(sales);
            shopinfo.setCLOSESALE(closed);
            Connection.Response response_order = Jsoup.connect((String)"https://spc-www.tmon.co.kr/api/ORDER/JSON").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body2 = response_order.body();
            JsonObject jsonObject2 = (JsonObject)jsonParser.parse(body2);
            jsonObject2 = (JsonObject)jsonObject2.get("data");
            JsonArray arr2 = (JsonArray)jsonObject2.get("result");
            JsonObject neword = (JsonObject)arr2.get(0);
            JsonObject confirm = (JsonObject)arr2.get(1);
            int neworder = Integer.parseInt(neword.get("text1").getAsString().replace(" \uac74", ""));
            int confirmorder = Integer.parseInt(confirm.get("text1").getAsString().replace(" \uac74", ""));
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            Connection.Response response_claim = Jsoup.connect((String)"https://spc-www.tmon.co.kr/api/CANCEL/JSON").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body3 = response_claim.body();
            JsonObject jsonObject3 = (JsonObject)jsonParser.parse(body3);
            jsonObject3 = (JsonObject)jsonObject3.get("data");
            JsonArray arr3 = (JsonArray)jsonObject3.get("result");
            JsonObject cancelreq = (JsonObject)arr3.get(0);
            JsonObject refundreq = (JsonObject)arr3.get(1);
            JsonObject exchangereq = (JsonObject)arr3.get(3);
            int cancel = Integer.parseInt(cancelreq.get("text1").getAsString().replace(" \uac74", ""));
            int returnreq = Integer.parseInt(refundreq.get("text1").getAsString().replace(" \uac74", ""));
            int exchange = Integer.parseInt(exchangereq.get("text1").getAsString().replace(" \uac74", ""));
            shopinfo.setCANCELLATIONORDER(cancel + returnreq + exchange);
            Connection.Response response_inquiry = Jsoup.connect((String)"https://spc-www.tmon.co.kr/api/QUESTION/JSON").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body4 = response_inquiry.body();
            JsonObject jsonObject4 = (JsonObject)jsonParser.parse(body4);
            jsonObject4 = (JsonObject)jsonObject4.get("data");
            JsonArray arr4 = (JsonArray)jsonObject4.get("result");
            JsonObject inquiry1 = (JsonObject)arr4.get(0);
            JsonObject inquiry2 = (JsonObject)arr4.get(1);
            int customerinquiry = Integer.parseInt(inquiry1.get("text2").getAsString().replace("\ubbf8\ub2f5\ubcc0", "").replace("\uac74", "").trim());
            int centerinquiry = Integer.parseInt(inquiry2.get("text2").getAsString().replace("\ubbf8\ub2f5\ubcc0", "").replace("\uac74", "").trim());
            shopinfo.setCUSTOMERQNA(customerinquiry + centerinquiry);
            shopinfo.setSHOPNOTICE(-1);
            shopinfo.setREGISTERPRODUCT(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ucfe0\ud321 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getMelchiStatus(ShoppingmallDTO shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCOOKIES(cookie.toString());
            Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/member/seller").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            Document body = Jsoup.parseBodyFragment((String)response.body());
            String t = body.select("dd.point[onclick='javascript:goOrderList('02')']").text();
            shopinfo.setNEWORDER(Integer.parseInt(t));
            t = body.select("dd.point[onclick='javascript:goOrderList('03')']").text();
            shopinfo.setSHIPPEDBEFORE(Integer.parseInt(t));
            int claim = Integer.parseInt(body.select("dd#msg11 > a > span").text().length() > 0 ? body.select("dd#msg11 > a > span").text() : "0") + Integer.parseInt(body.select("dd#msg31 > a > span").text().length() > 0 ? body.select("dd#msg31 > a > span").text() : "0") + Integer.parseInt(body.select("dd#msg21 > a > span").text().length() > 0 ? body.select("dd#msg21 > a > span").text() : "0");
            shopinfo.setCANCELLATIONORDER(claim);
            int inquiry = Integer.parseInt(body.select("td#qnaCntStatus2 > a > span").text().length() > 0 ? body.select("td#qnaCntStatus2 > a > span").text() : "0") + Integer.parseInt(body.select("td#buyerQnaCntStatus2 > a > span").text().length() > 0 ? body.select("td#buyerQnaCntStatus2 > a > span").text() : "0");
            shopinfo.setCUSTOMERQNA(inquiry);
            int onsale = Integer.parseInt(body.select("#table_style01 > tbody > tr:nth-child(2) > td > span").text().length() > 0 ? body.select("#table_style01 > tbody > tr:nth-child(2) > td > span").text().replace(",", "") : "0");
            int stopsale = Integer.parseInt(body.select("#table_style01 > tbody > tr:nth-child(3) > td > span").text().length() > 0 ? body.select("#table_style01 > tbody > tr:nth-child(3) > td > span").text().replace(",", "") : "0");
            shopinfo.setONSALEPRODUCT(onsale);
            shopinfo.setREGISTERPRODUCT(onsale + stopsale);
            shopinfo.setSHOPNOTICE(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uba78\uce58\uc1fc\ud551 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO get72timeStatus(ShoppingmallDTO shopinfo, Map<String, String> cookie, String date) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date parse_date = formatter.parse(date);
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(parse_date);
        cal1.add(5, -7);
        String sdate = formatter.format(cal1.getTime());
        try {
            shopinfo.setCOOKIES(cookie.toString());
            String cookies = cookie.toString().replace("{", "").replace("}", "").replaceAll(",", ";");
            URL url = new URL("http://seller.72time.kr/mallinmall");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(1000);
            con.setRequestProperty("Cookie", cookies);
            con.connect();
            String result = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), "euc-kr"));
            String inputLine = null;
            while ((inputLine = reader.readLine()) != null) {
                result = String.valueOf(result) + inputLine + "\r\n";
            }
            reader.close();
            Document body = Jsoup.parse((String)result);
            String neworder = body.select("td:contains(\uc2e0\uaddc\uc8fc\ubb38)").next().text().replaceAll("[^0-9]", "");
            shopinfo.setNEWORDER(0);
            shopinfo.setSHIPPEDBEFORE(Integer.parseInt(neworder));
            int claim = Integer.parseInt(body.select("div:contains(\ud658\ubd88\uc2e0\uccad) > a").text().replaceAll("[^0-9]", "")) + Integer.parseInt(body.select("div:contains(\ubd80\ubd84\ud658\ubd88\uc2e0\uccad) > a").text().replaceAll("[^0-9]", ""));
            int inquiry = Integer.parseInt(body.select("td:contains(\uc0c1\ud488\ubb38\uc758)").next().text().replaceAll("[^0-9]", "")) + Integer.parseInt(body.select("td:contains(1:1 \ubb38\uc758)").next().text().replaceAll("[^0-9]", ""));
            shopinfo.setCUSTOMERQNA(inquiry);
            url = new URL("http://seller.72time.kr/mallinmall/goods/goods_list.asp");
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(1000);
            con.setRequestProperty("Cookie", cookies);
            con.connect();
            reader = new BufferedReader(new InputStreamReader(con.getInputStream(), "euc-kr"));
            inputLine = null;
            result = "";
            while ((inputLine = reader.readLine()) != null) {
                result = String.valueOf(result) + inputLine + "\r\n";
            }
            reader.close();
            body = Jsoup.parse((String)result);
            int onsale = Integer.parseInt(body.select("b:contains(\uc0c1\ud488\ubaa9\ub85d)").next().text().replaceAll("[^0-9]", ""));
            shopinfo.setONSALEPRODUCT(onsale);
            shopinfo.setREGISTERPRODUCT(-1);
            shopinfo.setCLOSESALE(-1);
            shopinfo.setSHOPNOTICE(-1);
            HashMap<String, String> data2 = new HashMap<String, String>();
            data2.put("menu", "confirm");
            data2.put("mode", "");
            data2.put("uid", "");
            data2.put("suid", "");
            data2.put("page", "1");
            data2.put("listsize", "10");
            data2.put("order", "");
            data2.put("cancel_requestor", "");
            data2.put("view_type", "all");
            data2.put("sstate", "102");
            data2.put("sordstate", "102");
            data2.put("ssdate", sdate);
            data2.put("sedate", date);
            data2.put("skey", "ordname");
            data2.put("sword", "");
            data2.put("slistsize", "10");
            String URL2 = "http://seller.72time.kr/mallinmall/order/order_list.excel.etc.asp";
            body = Jsoup.connect((String)URL2).header("Content-Type", "application/x-www-form-urlencoded").cookies(cookie).data(data2).ignoreContentType(true).post();
            Elements odInfo = body.select("tr[bgcolor=#FFFFFF]");
            for (Element order : odInfo) {
                if (!order.select("tr > td:nth-child(28)").text().contains("\ucde8\uc18c\uc2e0\uccad")) continue;
                ++claim;
            }
            shopinfo.setCANCELLATIONORDER(claim);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("72\ud0c0\uc784 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getCafe24Status(ShoppingmallDTO shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCOOKIES(cookie.toString());
            Connection.Response response_order = Jsoup.connect((String)String.format("https://%s.cafe24api.com/api/v2/admin/dashboard", shopinfo.getSHOPPINGID())).header("Authorization", "Bearer " + Cafe24AcessToken.get().getAccessToken(shopinfo)).header("Content-Type", "application/json").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body = response_order.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("dashboard");
            JsonArray dailysales = jsonObject.get("daily_sales_stats").getAsJsonArray();
            int neworder = 0;
            int confirmorder = 0;
            int cancelreq = 0;
            int returnreq = 0;
            int exchangereq = 0;
            for (JsonElement ele : dailysales) {
                JsonObject today = ele.getAsJsonObject();
                neworder += today.get("prepare_count").getAsInt();
                confirmorder += today.get("standby_count").getAsInt();
                cancelreq += today.get("canceled_count").getAsInt();
                returnreq += today.get("returned_count").getAsInt();
                exchangereq += today.get("exchanged_count").getAsInt();
            }
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            shopinfo.setCANCELLATIONORDER(cancelreq + returnreq + exchangereq);
            shopinfo.setONSALEPRODUCT(-1);
            shopinfo.setCUSTOMERQNA(-1);
            shopinfo.setSHOPNOTICE(-1);
            shopinfo.setCLOSESALE(-1);
            shopinfo.setONSALEPRODUCT(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uce74\ud39824 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getKakaoStoreStatus(ShoppingmallDTO shopinfo, String date) {
        try {
            JsonParser jsonParser = new JsonParser();
            int neworder = 0;
            int confirmorder = 0;
            int claim = 0;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(date);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(sdate);
            int i = 0;
            while (i < 7) {
                Connection.Response response_order = Jsoup.connect((String)("https://kapi.kakao.com/v1/shopping/orders?order_modified_at_start=" + date + "000000&order_modified_at_end=" + date + "235959")).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shopinfo.getAPIKEY()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
                String body = response_order.body();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
                JsonArray arr = (JsonArray)jsonObject.get("content");
                for (JsonElement ele : arr) {
                    switch (ele.getAsJsonObject().get("orderStatus").getAsString()) {
                        case "ShippingRequest": {
                            ++neworder;
                            break;
                        }
                        case "ShippingWaiting": {
                            ++confirmorder;
                            break;
                        }
                        case "ReturnRequest": 
                        case "ExchangeRequest": 
                        case "ShippingCancelRequestBuyer": 
                        case "ShippingCancelRequestSeller": {
                            ++claim;
                        }
                    }
                }
                cal1.add(5, -1);
                date = formatter.format(cal1.getTime());
                ++i;
            }
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            shopinfo.setCANCELLATIONORDER(claim);
            Connection.Response response_prd = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/products?page=1&size=100&productOrder=CREATED_AT&pageOrder=ASC").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shopinfo.getAPIKEY()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body3 = response_prd.body();
            JsonObject jsonObject3 = (JsonObject)jsonParser.parse(body3);
            int totalcnt = jsonObject3.get("totalCount").getAsInt();
            shopinfo.setREGISTERPRODUCT(totalcnt);
            shopinfo.setONSALEPRODUCT(-1);
            Connection.Response response_inquiry = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/qna/unansweredCount").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shopinfo.getAPIKEY()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body4 = response_inquiry.body();
            JsonObject jsonObject4 = (JsonObject)jsonParser.parse(body4);
            int inquiry = jsonObject4.get("answer").getAsInt();
            shopinfo.setCUSTOMERQNA(inquiry);
            shopinfo.setSHOPNOTICE(-1);
            shopinfo.setCLOSESALE(-1);
            shopinfo.setCOOKIES("success");
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getWemakepriceStatus(ShoppingmallDTO shopinfo) {
        String date = YDMATimeUtil.getCurrentDateScheduler();
        JsonParser jsonParser = new JsonParser();
        int neworder = 0;
        int confirmorder = 0;
        int claim = 0;
        int inquiry = 0;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date sdate = formatter.parse(date);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(sdate);
            shopinfo.setCOOKIES("success");
            int i = 0;
            while (i < 7) {
                Connection.Response response_inquiry;
                String body4;
                String json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"type\": \"NEW\" }";
                Connection.Response response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getOrderList").header("apiKey", shopinfo.getAPIKEY()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                String body = response.body();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
                jsonObject = (JsonObject)jsonObject.get("data");
                JsonArray arr = (JsonArray)jsonObject.get("bundle");
                neworder += arr.size();
                json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"type\": \"CONFIRM\" }";
                response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getOrderList").header("apiKey", shopinfo.getAPIKEY()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                if (body.contains("\"error\":null")) {
                    jsonObject = (JsonObject)jsonParser.parse(body);
                    jsonObject = (JsonObject)jsonObject.get("data");
                    arr = (JsonArray)jsonObject.get("bundle");
                    confirmorder += arr.size();
                }
                json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\"," + " \"claimType\": \"CANCEL\", \"claimStatus\": \"REQUEST\" }";
                response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", shopinfo.getAPIKEY()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                if (body.contains("\"error\":null")) {
                    jsonObject = (JsonObject)jsonParser.parse(body);
                    jsonObject = (JsonObject)jsonObject.get("data");
                    arr = (JsonArray)jsonObject.get("claim");
                    claim += arr.size();
                }
                json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\"," + " \"claimType\": \"EXCHANGE\", \"claimStatus\": \"REQUEST\" }";
                response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", shopinfo.getAPIKEY()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                if (body.contains("\"error\":null")) {
                    jsonObject = (JsonObject)jsonParser.parse(body);
                    jsonObject = (JsonObject)jsonObject.get("data");
                    arr = (JsonArray)jsonObject.get("claim");
                    claim += arr.size();
                }
                json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\"," + " \"claimType\": \"RETURN\", \"claimStatus\": \"REQUEST\" }";
                response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", shopinfo.getAPIKEY()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                if (body.contains("\"error\":null")) {
                    jsonObject = (JsonObject)jsonParser.parse(body);
                    jsonObject = (JsonObject)jsonObject.get("data");
                    arr = (JsonArray)jsonObject.get("claim");
                    claim += arr.size();
                }
                if ((body4 = (response_inquiry = Jsoup.connect((String)("http://api.kdjsystem.com:8082/wemarket/api/v2/getQnaAPI?basicDate=" + date)).header("apiKey", shopinfo.getAPIKEY()).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.GET).execute()).body()).contains("qnaSeq")) {
                    try {
                        JsonObject jsonObject4 = (JsonObject)jsonParser.parse(body4);
                        int stridx = jsonObject4.get("message").getAsString().indexOf("{");
                        int endidx = jsonObject4.get("message").getAsString().lastIndexOf("}");
                        String result = jsonObject4.get("message").getAsString().substring(stridx, endidx + 1);
                        JsonObject jsonObject5 = (JsonObject)jsonParser.parse(result);
                        arr = (JsonArray)jsonObject5.get("data");
                        inquiry += arr.size();
                    }
                    catch (Exception exception) {}
                }
                cal1.add(5, -1);
                date = formatter.format(cal1.getTime());
                ++i;
            }
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            shopinfo.setCANCELLATIONORDER(claim);
            shopinfo.setCUSTOMERQNA(inquiry);
            shopinfo.setREGISTERPRODUCT(-1);
            shopinfo.setONSALEPRODUCT(-1);
            shopinfo.setCLOSESALE(-1);
            shopinfo.setSHOPNOTICE(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uc704\uba54\ud504 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getLotteOnStatus(ShoppingmallDTO shopinfo, String date) {
        JsonParser jsonParser = new JsonParser();
        int neworder = 0;
        int confirmorder = 0;
        int claim = 0;
        int inquiry = 0;
        int shopnotice = 0;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(date);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(sdate);
            shopinfo.setCOOKIES("success");
            int i = 0;
            while (i < 7) {
                String json = "{\"srchStrtDt\":\"" + date + "000000\",\"srchEndDt\":\"" + date + "235959\",\"odPrgsStepCd\":\"11\"}";
                Connection.Response response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/delivery/v1/SellerDeliveryProgressStateSearch").header("Authorization", "Bearer " + shopinfo.getAPIKEY()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                String body = response.body();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
                neworder += jsonObject.get("dataCount").getAsInt();
                json = "{\"srchStrtDt\":\"" + date + "000000\",\"srchEndDt\":\"" + date + "235959\",\"odPrgsStepCd\":\"12\"}";
                response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/delivery/v1/SellerDeliveryProgressStateSearch").header("Authorization", "Bearer " + shopinfo.getAPIKEY()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                jsonObject = (JsonObject)jsonParser.parse(body);
                confirmorder += jsonObject.get("dataCount").getAsInt();
                json = "{\"srchStrtDttm\":\"" + date + "000000\",\"srchEndDttm\":\"" + date + "235959\",\"odPrgsStepCd\":\"02\"}";
                response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/claim/v1/cancellationOpenApi/getCancellationRequestAndComplateList").header("Authorization", "Bearer " + shopinfo.getAPIKEY()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                jsonObject = (JsonObject)jsonParser.parse(body);
                claim += jsonObject.get("dataCount").isJsonNull() ? 0 : jsonObject.get("dataCount").getAsInt();
                json = "{\"srchStrtDttm\":\"" + date + "000000\",\"srchEndDttm\":\"" + date + "235959\", \"odPrgsStepCd\":\"02\"}";
                response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/claim/v1/returningOpenApi/returnRequestSearch").header("Authorization", "Bearer " + shopinfo.getAPIKEY()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                jsonObject = (JsonObject)jsonParser.parse(body);
                claim += jsonObject.get("dataCount").isJsonNull() ? 0 : jsonObject.get("dataCount").getAsInt();
                json = "{\"srchStrtDttm\":\"" + date + "000000\",\"srchEndDttm\":\"" + date + "235959\", \"odIfPrgsStepCd\":\"00\"}";
                response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/claim/v1/exchangeOpenApi/exchangeSearch").header("Authorization", "Bearer " + shopinfo.getAPIKEY()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                jsonObject = (JsonObject)jsonParser.parse(body);
                claim += jsonObject.get("dataCount").isJsonNull() ? 0 : jsonObject.get("dataCount").getAsInt();
                json = "{\"scStrtDt\":\"" + date + "\",\"scEndDt\":\"" + date + "\", \"ctctCfmYn\" : \"N\"}";
                response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/customer/v1/getSellerContactList").header("Authorization", "Bearer " + shopinfo.getAPIKEY()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                jsonObject = (JsonObject)jsonParser.parse(body);
                shopnotice += jsonObject.get("rsltList").isJsonNull() ? 0 : jsonObject.get("rsltList").getAsJsonArray().size();
                ObjectMapper mapper = new ObjectMapper();
                LotteOnProductQnaDto.RequestParameter requestParmeter = new LotteOnProductQnaDto.RequestParameter();
                requestParmeter.trGrpCd = "SR";
                requestParmeter.trNo = shopinfo.getAUTHKEY1();
                requestParmeter.regEndDttm = String.valueOf(date) + "235959";
                requestParmeter.regStrDttm = String.valueOf(date) + "000000";
                requestParmeter.qnaStatCd = "NPROC";
                mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
                json = mapper.writeValueAsString((Object)requestParmeter);
                response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/product/v1/product/qna/list").header("Authorization", "Bearer " + shopinfo.getAPIKEY()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                jsonObject = (JsonObject)jsonParser.parse(body);
                inquiry += jsonObject.get("dataCount").getAsInt();
                json = "{\"scStrtDt\": \"" + date + "\", \"scEndDt\": \"" + date + "\", \"slrInqProcStatCd\": \"UNANS\"}";
                response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/customer/v1/getSellerInquiryList").header("Authorization", "Bearer " + shopinfo.getAPIKEY()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                jsonObject = jsonParser.parse(body).getAsJsonObject();
                inquiry += jsonObject.get("rsltList").isJsonNull() ? 0 : jsonObject.get("rsltList").getAsJsonArray().size();
                cal1.add(5, -1);
                date = formatter.format(cal1.getTime());
                ++i;
            }
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            shopinfo.setCANCELLATIONORDER(claim);
            shopinfo.setCUSTOMERQNA(inquiry);
            shopinfo.setSHOPNOTICE(shopnotice);
            shopinfo.setREGISTERPRODUCT(-1);
            shopinfo.setONSALEPRODUCT(-1);
            shopinfo.setCLOSESALE(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ub86f\ub370\uc628 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getSsgStatus(ShoppingmallDTO shopinfo) {
        try {
            JsonElement obj;
            String date = YDMATimeUtil.getCurrentDateScheduler();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date sdate = formatter.parse(date);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(sdate);
            cal1.add(5, -6);
            String startdate = formatter.format(cal1.getTime());
            shopinfo.setCOOKIES("success");
            String json = "{\"requestShppDirection\":{\"perdType\":\"02\",\"perdStrDts\":\"" + startdate + "\",\"perdEndDts\":\"" + date + "\",\"commType\":null,\"commValue\":null,\"shppDivDtlCd\":null,\"shppStatCd\":\"10\",\"rsvtItemYn\":null,\"frgShppYn\":null,\"reOrderYns\":null,\"itemNm\":null,\"itemDiv\":null,\"itemId\":null,\"splVenItemId\":null,\"rcptpeNm\":null,\"ordpeNm\":null,\"mbrId\":null,\"mallTypeCd\":null}}";
            Connection.Response response_order = Jsoup.connect((String)"https://eapi.ssgadm.com/api/pd/1/listShppDirection.ssg").header("Authorization", shopinfo.getAPIKEY()).header("accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = response_order.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("result");
            JsonArray arr = (JsonArray)jsonObject.get("shppDirections");
            int neworder = 0;
            if (!arr.get(0).toString().equals("\"\"")) {
                jsonObject = arr.get(0).getAsJsonObject();
                JsonElement obj2 = jsonObject.get("shppDirection");
                if (obj2 instanceof JsonObject) {
                    neworder = 1;
                } else if (obj2 instanceof JsonArray) {
                    jsonObject = arr.get(0).getAsJsonObject();
                    arr = (JsonArray)jsonObject.get("shppDirection");
                    neworder = arr.size();
                }
            }
            json = "{\"requestWarehouseOut\":{\"perdType\":\"02\",\"perdStrDts\":\"" + startdate + "\",\"perdEndDts\":\"" + date + "\"}}";
            response_order = Jsoup.connect((String)"https://eapi.ssgadm.com/api/pd/1/listWarehouseOut.ssg").header("Authorization", shopinfo.getAPIKEY()).header("accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            body = response_order.body();
            jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("result");
            arr = (JsonArray)jsonObject.get("warehouseOuts");
            int confirmorder = 0;
            if (!arr.get(0).toString().equals("\"\"")) {
                jsonObject = arr.get(0).getAsJsonObject();
                JsonElement obj3 = jsonObject.get("warehouseOut");
                if (obj3 instanceof JsonObject) {
                    ++confirmorder;
                } else if (obj3 instanceof JsonArray) {
                    jsonObject = arr.get(0).getAsJsonObject();
                    arr = (JsonArray)jsonObject.get("warehouseOut");
                    confirmorder = arr.size();
                }
            }
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            startdate = startdate.replace("-", "");
            date = date.replace("-", "");
            response_order = Jsoup.connect((String)"https://eapi.ssgadm.com/api/claim/v2/cancel/requests").header("Authorization", shopinfo.getAPIKEY()).header("accept", "application/json").header("Content-Type", "application/json").data("perdStrDts", startdate).data("perdEndDts", date).requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            body = response_order.body();
            jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("result");
            int cancelreq = 0;
            if (jsonObject.has("resultData")) {
                obj = jsonObject.get("resultData");
                if (obj instanceof JsonObject) {
                    ++cancelreq;
                } else if (obj instanceof JsonArray) {
                    jsonObject = arr.get(0).getAsJsonObject();
                    arr = (JsonArray)jsonObject.get("resultData");
                    cancelreq = arr.size();
                }
            }
            json = "{\"requestExchangeTarget\":{\"perdType\":\"01\",\"perdStrDts\":\"" + startdate + "\",\"perdEndDts\":\"" + date + "\"}}";
            response_order = Jsoup.connect((String)"https://eapi.ssgadm.com/api/pd/1/listExchangeTarget.ssg").header("Authorization", shopinfo.getAPIKEY()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            body = response_order.body();
            jsonObject = (JsonObject)jsonParser.parse(body);
            arr = (JsonArray)(jsonObject = (JsonObject)jsonObject.get("result")).get("exchangeTargets");
            if (!arr.get(0).toString().equals("\"\"")) {
                jsonObject = arr.get(0).getAsJsonObject();
                obj = jsonObject.get("exchangeTarget");
                if (obj instanceof JsonObject) {
                    ++cancelreq;
                } else if (obj instanceof JsonArray) {
                    jsonObject = arr.get(0).getAsJsonObject();
                    arr = (JsonArray)jsonObject.get("exchangeTarget");
                    cancelreq = arr.size();
                }
            }
            shopinfo.setCANCELLATIONORDER(cancelreq);
            json = "{\"postngReq\":{\"qnaStartDt\":\"" + startdate + "0000\",\"qnaEndDt\":\"" + date + "0000\"}}";
            response_order = Jsoup.connect((String)"https://eapi.ssgadm.com/api/postng/qnaList.ssg").header("Authorization", shopinfo.getAPIKEY()).header("accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            body = response_order.body();
            jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("result");
            int inquiry = 0;
            shopinfo.setCUSTOMERQNA(inquiry += jsonObject.get("totalCount").getAsInt());
            shopinfo.setCLOSESALE(-1);
            shopinfo.setSHOPNOTICE(-1);
            shopinfo.setONSALEPRODUCT(-1);
            shopinfo.setREGISTERPRODUCT(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("SSG \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    public ShoppingmallDTO getTossShoppingStatus(ShoppingmallDTO shopinfo, String date) throws Exception {
        String apikey = shopinfo.getAPIKEY();
        String startdt = YDMATimeUtil.getNetworkDayToSubtract(date, -6);
        String enddt = date;
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startdt = outputFormat.format(inputFormat.parse(startdt));
            enddt = outputFormat.format(inputFormat.parse(enddt));
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ub0a0\uc9dc \ubcc0\ud658 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd: " + e.getMessage());
            shopinfo.setCOOKIES("");
            return shopinfo;
        }
        int neworder = 0;
        int confirmorder = 0;
        int claim = 0;
        int shopnotice = -1;
        int question = 0;
        try {
            Connection.Response productResponse;
            JsonObject productResponseBody;
            Map<String, String> cookie = LoginHelper.getTossCookies(shopinfo.getSHOPPINGID(), shopinfo.getPASSWORD());
            shopinfo.setCOOKIES(cookie.toString());
            JsonParser parser = new JsonParser();
            JsonObject body = new JsonObject();
            JsonObject successOrderObject = new JsonObject();
            JsonObject pagingObject = new JsonObject();
            String strParam = "";
            String[] orderStatus = new String[]{"\uacb0\uc81c\uc644\ub8cc", "\uc0c1\ud488\uc900\ube44\uc911", "\ubc1c\uc1a1\uc9c0\uc5f0"};
            int i = 0;
            while (i < 3) {
                strParam = this.getTossNewOrderStringParam(apikey, startdt, enddt, orderStatus[i]);
                Connection.Response response = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/order/histories/paging").cookies(cookie).header("content-type", "application/json").requestBody(strParam).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
                body = parser.parse(response.body()).getAsJsonObject();
                successOrderObject = body.getAsJsonObject("success");
                pagingObject = successOrderObject.getAsJsonObject("paging");
                if (i == 0) {
                    neworder += pagingObject.get("totalCount").getAsInt();
                } else {
                    confirmorder += pagingObject.get("totalCount").getAsInt();
                }
                ++i;
            }
            String[] claimTypes = new String[]{"CANCEL", "EXCHANGE", "RETURN"};
            int i2 = 0;
            while (i2 < 3) {
                strParam = this.getTossOrderClaimSyncStringParam(claimTypes[i2], startdt, enddt);
                Connection.Response response = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/orders/claims").cookies(cookie).header("content-type", "application/json").header("X-Merchant-id", apikey).requestBody(strParam).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
                body = parser.parse(response.body()).getAsJsonObject();
                successOrderObject = body.getAsJsonObject("success");
                pagingObject = successOrderObject.getAsJsonObject("paging");
                claim += pagingObject.get("totalCount").getAsInt();
                ++i2;
            }
            shopinfo.setNEWORDER(neworder);
            shopinfo.setSHIPPEDBEFORE(confirmorder);
            shopinfo.setCANCELLATIONORDER(claim);
            JsonObject inquiryRequestBody = new JsonObject();
            inquiryRequestBody.addProperty("page", (Number)1);
            inquiryRequestBody.addProperty("pageSize", (Number)50);
            JsonArray statuses = new JsonArray();
            statuses.add("READY");
            inquiryRequestBody.add("statuses", (JsonElement)statuses);
            JsonArray types = new JsonArray();
            inquiryRequestBody.add("types", (JsonElement)types);
            inquiryRequestBody.addProperty("merchantId", apikey);
            Connection.Response inquiryResponse = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/product/inquiry/all").header("Content-Type", "application/json").requestBody(inquiryRequestBody.toString()).cookies(cookie).method(Connection.Method.POST).ignoreContentType(true).execute();
            JsonObject inquiryResponseBody = parser.parse(inquiryResponse.body()).getAsJsonObject();
            if (inquiryResponseBody.has("success")) {
                JsonObject successObject = inquiryResponseBody.getAsJsonObject("success");
                question = successObject.get("totalCount").getAsInt();
            }
            shopinfo.setSHOPNOTICE(shopnotice);
            shopinfo.setCUSTOMERQNA(question);
            int merchantUserId = 0;
            int totalCount = 0;
            int onsaleTotalCount = 0;
            Connection.Response rs = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/my-info").cookies(cookie).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(rs.body());
            String resultType = jsonObject.get("resultType").getAsString();
            if (resultType.equals("SUCCESS")) {
                JsonObject success = (JsonObject)jsonObject.get("success");
                JsonObject merchantUser = success.getAsJsonObject("merchantUser");
                merchantUserId = merchantUser.get("id").getAsInt();
            }
            if ((productResponseBody = jsonParser.parse((productResponse = Jsoup.connect((String)"https://api-public.toss.im/api-public/v2/shopping-internal/products/by-merchant").data("page", "0").data("pageSize", "1").data("merchantId", apikey).data("merchantUserId", String.valueOf(merchantUserId)).timeout(100000).cookies(cookie).method(Connection.Method.GET).ignoreContentType(true).execute()).body()).getAsJsonObject()).has("success")) {
                JsonObject successObject = productResponseBody.getAsJsonObject("success");
                JsonObject paging = successObject.getAsJsonObject("paging");
                totalCount = paging.get("totalCount").getAsInt();
            }
            shopinfo.setREGISTERPRODUCT(totalCount);
            Connection.Response onsaleResponse = Jsoup.connect((String)("https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/" + apikey + "/v1/products")).data("page", "0").data("size", "50").data("reviewStatuses", "").data("displayStatuses", "\ub178\ucd9c\uc911").cookies(cookie).method(Connection.Method.GET).ignoreContentType(true).execute();
            JsonObject onsaleResponseBody = jsonParser.parse(onsaleResponse.body()).getAsJsonObject();
            if (onsaleResponseBody.has("success")) {
                JsonObject successObject = onsaleResponseBody.getAsJsonObject("success");
                JsonObject paging = successObject.getAsJsonObject("paging");
                onsaleTotalCount = paging.get("totalCount").getAsInt();
            }
            shopinfo.setONSALEPRODUCT(onsaleTotalCount);
            shopinfo.setCLOSESALE(-1);
        }
        catch (IOException e) {
            YDMAStringUtil.Print("Home \ud654\uba74\uc5d0\uc11c \ud1a0\uc2a4\uc1fc\ud551\uc744 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
            shopinfo.setCOOKIES("");
        }
        return shopinfo;
    }

    private String getTossNewOrderStringParam(String merchantId, String startDate, String endDate, String orderStatus) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("merchantId", merchantId);
        json.addProperty("queryType", "ORDER_ID");
        json.addProperty("query", "");
        json.addProperty("startDate", startDate);
        json.addProperty("endDate", endDate);
        json.addProperty("orderProductStatus", orderStatus);
        json.addProperty("masking", Boolean.valueOf(true));
        json.add("stockIds", (JsonElement)new JsonArray());
        json.addProperty("page", (Number)1);
        json.addProperty("pageSize", (Number)200);
        json.addProperty("sortDirection", "DESC");
        return json.toString();
    }

    private String getTossOrderClaimSyncStringParam(String type, String startDate, String endDate) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("type", type);
        json.addProperty("page", (Number)1);
        json.addProperty("fromRequestDate", startDate);
        json.addProperty("toRequestDate", endDate);
        JsonArray statuses = new JsonArray();
        statuses.add("REQUESTED");
        json.add("statuses", (JsonElement)statuses);
        json.addProperty("pageSize", (Number)50);
        return json.toString();
    }

    public int nullcheck(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            return 0;
        }
        return jsonElement.getAsInt();
    }

    public ShoppingmallDTO getAlwayzStatus(ShoppingmallDTO shopinfo) {
        int neworder = 0;
        int confirmorder = 0;
        int inquiry = 0;
        int shopnotice = 0;
        int saleProduct = 0;
        if (!shopinfo.getAPIKEY().equals("")) {
            try {
                String inputLine;
                shopinfo.setCOOKIES("success");
                String json = "{\"condition\":{\"type\":\"item\",\"itemCondition\":{\"soldOut\":false,\"$or\":[{\"outOfStock\":false},{\"outOfStock\":null}]}}}";
                Connection.Response rs2 = Jsoup.connect((String)"https://alwayz-seller-back.ilevit.com/sellers/items/v2/count-request").header("Connection", "keep-alive").header("Content-Type", "application/json").header("x-access-token", shopinfo.getAPIKEY()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.POST).requestBody(json).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                String body2 = rs2.body();
                JsonParser jsonParser2 = new JsonParser();
                JsonObject jsonObject2 = (JsonObject)jsonParser2.parse(body2);
                int status2 = jsonObject2.get("status").getAsInt();
                int data2 = jsonObject2.get("data").getAsInt();
                if (status2 == 200) {
                    saleProduct = data2;
                }
                shopinfo.setONSALEPRODUCT(saleProduct);
                int cancelCount = 0;
                int refundCount = 0;
                URL url = new URL("https://alwayz-seller-back.ilevit.com/sellers/orders/status");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setRequestProperty("x-access-token", shopinfo.getAPIKEY());
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                String body1 = response.toString();
                JsonParser jsonParser1 = new JsonParser();
                JsonObject jsonObject1 = (JsonObject)jsonParser1.parse(body1);
                int status3 = jsonObject1.get("status").getAsInt();
                if (status3 == 200) {
                    JsonArray dataArray1 = (JsonArray)jsonObject1.get("data");
                    int i = 0;
                    while (i < dataArray1.size()) {
                        JsonObject object1 = (JsonObject)dataArray1.get(i);
                        String dataStatus1 = object1.get("status").getAsString();
                        int dataCount = Integer.parseInt(object1.get("totalOrderNum").toString());
                        if (dataStatus1.equals("canceling-pre-shipping-post-excel") && dataCount > 0) {
                            cancelCount = dataCount;
                        } else if ((dataStatus1.equals("refunding") || dataStatus1.equals("canceling-shipping")) && dataCount > 0) {
                            refundCount = dataCount;
                        } else if (dataStatus1.equals("pre-shipping-post-excel") && dataCount > 0) {
                            confirmorder = dataCount;
                        } else if (dataStatus1.equals("pre-shipping-pre-excel") && dataCount > 0) {
                            neworder = dataCount;
                        }
                        ++i;
                    }
                }
                shopinfo.setNEWORDER(neworder);
                shopinfo.setSHIPPEDBEFORE(confirmorder);
                shopinfo.setCANCELLATIONORDER(cancelCount + refundCount);
                String json1 = "{\"type\":\"ITEM_QUESTION\"}";
                inquiry = this.getQnA(json1, shopinfo);
                shopinfo.setCUSTOMERQNA(inquiry);
                String json2 = "{\"type\":\"QUESTION_FROM_ADMIN\"}";
                shopnotice = this.getQnA(json2, shopinfo);
                shopinfo.setSHOPNOTICE(shopnotice);
                shopinfo.setREGISTERPRODUCT(-1);
                shopinfo.setCLOSESALE(-1);
            }
            catch (Exception e) {
                YDMAStringUtil.Print("Home \ud654\uba74\uc5d0\uc11c \uc62c\uc6e8\uc774\uc988\ub97c \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + e);
                shopinfo.setCOOKIES("");
            }
        }
        return shopinfo;
    }

    public int getQnA(String json, ShoppingmallDTO shopinfo) {
        int count = 0;
        try {
            String url = "https://alwayz-seller-back.ilevit.com/sellers/questions-by-condition?condition=" + URLEncoder.encode(json, "UTF-8") + "&limit=-1&skip=0";
            Connection.Response rs3 = Jsoup.connect((String)url).header("Connection", "keep-alive").header("x-access-token", shopinfo.getAPIKEY()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            String body = rs3.body();
            JsonParser jsonParser3 = new JsonParser();
            JsonObject jsonObject3 = (JsonObject)jsonParser3.parse(body);
            int status3 = jsonObject3.get("status").getAsInt();
            JsonArray dataArray = (JsonArray)jsonObject3.get("data");
            if (status3 == 200 && dataArray.size() > 0) {
                int i = 0;
                while (i < dataArray.size()) {
                    JsonObject object = (JsonObject)dataArray.get(i);
                    if (!object.has("answerInfo")) {
                        ++count;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }
}

