/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.ApplicationWorkbenchAdvisor;
import com.kdjsystem.mlink.yellim.common.FtpUtil;
import com.kdjsystem.mlink.yellim.common.YDMAProperties;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dao.DBControlDAO;
import com.kdjsystem.mlink.yellim.data.dao.UserDao;
import com.kdjsystem.mlink.yellim.data.dao.UserDto;
import com.kdjsystem.mlink.yellim.shop.common.ChromeExtention;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.mlink.MLinkAPI;
import com.kdjsystem.mlink.yellim.shop.mlink.MLinkSessonUtil;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.LoginDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAutoDiscontinueSelectDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Application
implements IApplication {
    private static final String LAST_COMPNO = "last-compno";
    private static final String LAST_USER = "last-user";
    private static final String PASSWORD = "password";
    private static final String SAVED_ID = "saved-id";
    private static final String SAVED = "saved-connections";
    public boolean autoFlag = false;
    public boolean autoStart = false;
    public String setName = "";

    public Object start(IApplicationContext context) throws Exception {
        Display display = PlatformUI.createDisplay();
        try {
            context.applicationRunning();
            ExecutionEvent event = null;
            if (!this.openLoginDialog(event)) {
                Integer n = IApplication.EXIT_OK;
                return n;
            }
            if (this.autoFlag) {
                ProductAutoDiscontinueSelectDialog dialog = new ProductAutoDiscontinueSelectDialog(this.getShell(event), this.autoStart, this.setName);
                dialog.open();
                CommonProgressDialog.get().startBack("\ub3c4\ub9e4\ubab0 \uc218\uc815\uc0ac\ud56d \uc801\uc6a9 \ubc0f \uc1fc\ud551\ubab0 \ud488\ub2e8\uc885(\ub3c4\ub9e4\ubab0-\uc5e0\ub9c1\ud06c-\uc1fc\ud551\ubab0)\ucc98\ub9ac", 0, 100, true);
                while (true) {
                    // Infinite loop
                }
            }
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            Boolean bl = false;
            return bl;
        }
        finally {
            display.dispose();
        }
    }

    private boolean openInitDialog(ExecutionEvent event) throws Exception {
        try {
            this.initCheromDrive();
            this.readAutoLogin();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void initCheromDrive() {
        if (System.getProperty("os.name").contains("Windows")) {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec("taskkill /F /IM chromedriver.exe /T");
                if (process != null) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            process.destroy();
        }
    }

    private void updateDBupdate() throws Exception {
        int Check = 0;
        JFrame frame = new JFrame("\ub370\uc774\ud130\ubca0\uc774\uc2a4\ub97c \ud29c\ub2dd\ud558\ub294 \uc911\uc785\ub2c8\ub2e4. \uc7a0\uc2dc\ub9cc \uae30\ub2e4\ub824\uc8fc\uc138\uc694");
        frame.setDefaultCloseOperation(0);
        URL imageIconS = null;
        imageIconS = this.getClass().getResource("/icons/MLink32_red.png");
        ImageIcon imgicon = new ImageIcon(imageIconS);
        frame.setIconImage(imgicon.getImage());
        JProgressBar bar = new JProgressBar();
        Container container = frame.getContentPane();
        container.add((Component)bar, "Center");
        frame.setSize(570, 80);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        frame.setLocation(screen.width / 2 - 285, screen.height / 2 - 40);
        try {
            try {
                String remoteDir = "";
                String filename = "db_update.txt";
                remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
                String[] file = FtpUtil.downSFtpFileWithSplit(remoteDir, filename);
                int i = 0;
                while (i < file.length) {
                    String text = file[i].replace("\n", "").replace("\r", "");
                    DBControlDAO.get().setUpdateTable(text);
                    if (file.length >= Check) {
                        bar.setMaximum(file.length);
                        bar.setValue(Check);
                        bar.setStringPainted(true);
                        frame.setVisible(true);
                    }
                    ++Check;
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                frame.setVisible(false);
            }
        }
        finally {
            frame.setVisible(false);
        }
    }

    private void updateDBOptimization() throws Exception {
        try {
            String remoteDir = "";
            String filename = "dump_procedure_test_01.sql";
            remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
            String[] file = FtpUtil.downSFtpFileWithSplitPlus(remoteDir, filename);
            int i = 0;
            while (i < file.length) {
                String text = file[i];
                DBControlDAO.get().setUpdateTable(text);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Shell getShell(ExecutionEvent event) {
        return null;
    }

    private void readAutoLogin() throws Exception {
        block7: {
            String compno = "";
            String id = "";
            String pw = "";
            ExecutionEvent event = null;
            if (!SecurePreferencesFactory.getDefault().nodeExists(SAVED) && !this.openLoginDialog(event)) {
                throw new Exception("\uae30\ubcf8\uc811\uc18d \uc2e4\ud328!!");
            }
            try {
                ISecurePreferences root = SecurePreferencesFactory.getDefault();
                ISecurePreferences conn = root.node(SAVED);
                compno = conn.get(LAST_COMPNO, "");
                id = conn.get(LAST_USER, "");
                pw = conn.get(PASSWORD, "");
                conn.get(SAVED_ID, "");
                if (compno == null || compno.isEmpty()) {
                    compno = "";
                }
                if (id == null || id.isEmpty()) {
                    id = "";
                }
                if (pw == null || pw.isEmpty()) {
                    pw = "";
                }
                if (!(compno.equals("") || id.equals("") || pw.equals("") || this.setDefaultValue(compno, id, pw) || this.openLoginDialog(event))) {
                    throw new Exception("\uae30\ubcf8\uc811\uc18d \uc2e4\ud328!!");
                }
            }
            catch (Exception exception) {
                if (this.openLoginDialog(event)) break block7;
                throw new Exception("\uae30\ubcf8\uc811\uc18d \uc2e4\ud328!!");
            }
        }
    }

    private boolean setDefaultValue(String compno, String id, String pw) {
        UserDto dto;
        UserDao dao;
        block6: {
            dao = new UserDao();
            dto = null;
            dto = this.getUserPermitAPI(compno, id, pw);
            if (dto != null) break block6;
            return false;
        }
        try {
            YDMASessonUtil.setConnectip(dto);
            this.DosinCountCheck(dto.getCompno(), dto.getUserId(), dto.getUserpwd(), YDMATimeUtil.getCurrentTime());
            dao.getUserInfoLogin(dto.getCompno(), dto.getUserId(), dto.getUserpwd());
            YDMASessonUtil.setUserInfo(dto);
            YDMASessonUtil.setCompnoInfo(dto);
            YDMASessonUtil.setUserpwd(dto);
            YDMASessonUtil.setCommoncodelist(ShopCommonDao.get().getCommonCode());
            List<ShoppingMallDetailDto> shopDtoList = ShopCommonDao.get().getShopCookies();
            List shopList = shopDtoList.stream().filter(d -> !d.getCookies().equals("")).collect(Collectors.toList());
            ObjectMapper mapper = new ObjectMapper();
            for (ShoppingMallDetailDto shopDto : shopList) {
                Map mapCookies = (Map)mapper.readValue(shopDto.getCookies(), Map.class);
                IShopCommonLogin.cokieManager.put(shopDto.getCookiekey(), mapCookies);
            }
            try {
                YDMASessonUtil.setLoginType(dto.getLtype());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void DosinCountCheck(String compno, String id, String pw, String date) {
        try {
            String ipadd = IShopCommonLogin.getLocalMacAddress().replace("-", "");
            pw = this.encodeValue(pw);
            String path = "http://api.kdjsystem.com:8080/api/v1/dosincount?compno=" + compno + "&id=" + id + "&pw=" + pw + "&date=" + date.concat("-").concat(ipadd);
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request2 = new Request.Builder().url(path).method("GET", null).build();
            client.newCall(request2).execute();
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
    }

    private String encodeValue(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
    }

    private boolean isCheckUsePermit(UserDto dto) {
        boolean ret = true;
        String curDate = YDMATimeUtil.getCurrentTimeByYDFormat();
        if (curDate.compareTo(dto.getEnduse()) == 1) {
            ret = false;
        }
        return ret;
    }

    private UserDto getUserPermitAPI(String compno, String id, String pw) {
        UserDto dto = null;
        try {
            dto = MLinkAPI.get().Login(compno, id, pw);
            if (!this.isCheckUsePermit(dto)) {
                dto = null;
                throw new Exception(MLinkSessonUtil.get().ResultLoginText);
            }
        }
        catch (Exception exception) {
            dto = null;
        }
        return dto;
    }

    private boolean openLoginDialog(ExecutionEvent event) throws Exception {
        LoginDialog dialog;
        block3: {
            try {
                dialog = new LoginDialog(this.getShell(event), this);
                if (!dialog.performAutoLogin()) break block3;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        dialog.open();
        return true;
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    ChromeExtention.getInstace().getDriver().quit();
                    workbench.close();
                }
            }
        });
    }
}

