/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.data.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.data.dao.PickupDto;
import com.kdjsystem.mlink.yellim.data.dao.SummeryDto;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class PickupDao {
    public List<List<String>> getRackPickupList(String dateStr, String seq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        CallableStatement cStmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> pstmtlist = new ArrayList<PreparedStatement>();
        ArrayList<List<String>> sheetContents = new ArrayList<List<String>>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                cStmt = connection.prepareCall("{call YWM_EXCEL_MAP(?, ?, ?)}");
                cStmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                cStmt.setString(2, dateStr);
                cStmt.setString(3, seq);
                pstmtlist.add(cStmt);
                cStmt.execute();
                String sql = "SELECT * FROM excelmst  WHERE orddt = ?  and ordseq = ? and compno = ? ORDER BY neccd1, neccd2 DESC ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dateStr);
                pstmt.setString(2, seq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmtlist.add(pstmt);
                YDMAStringUtil.Print("[getRackPickupList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                while (rs.next()) {
                    ArrayList<String> rowContent = new ArrayList<String>();
                    rowContent.add(rs.getString(1));
                    rowContent.add(rs.getString(2));
                    rowContent.add(rs.getString(3));
                    rowContent.add(rs.getString(4));
                    int offset = 3;
                    StringBuffer buff = new StringBuffer();
                    int i = 5;
                    while (i <= columnCount) {
                        String val = rs.getString(i);
                        if (val == null) {
                            val = "";
                        }
                        if (offset % 3 == 0) {
                            rowContent.add(val);
                        } else if (offset % 3 == 1) {
                            buff.append("(");
                            buff.append(val);
                        } else if (offset % 3 == 2) {
                            buff.append(", ");
                            buff.append(val);
                            buff.append(")");
                            rowContent.add(buff.toString());
                            buff = new StringBuffer();
                        }
                        ++offset;
                        ++i;
                    }
                    sheetContents.add(rowContent);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmtlist, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmtlist, rs);
        return sheetContents;
    }

    public List<List<String>> getRackProductList(String printOptionOA, String printOptionDir, String orderStr) throws Exception {
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "CALL YWM_RACKPICUP_LIST_VER2(?, ?, ?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, printOptionOA);
                pstmt.setString(2, printOptionDir);
                pstmt.setString(3, orderStr);
                YDMAStringUtil.Print("[getRackProductList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    content.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return content;
    }

    public List<List<String>> getRackProductList1(String orderStr) throws Exception {
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "CALL YWM_RACKPICUP_ASGN_LIST(?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orderStr);
                YDMAStringUtil.Print("[getRackProductList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    content.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return content;
    }

    public List<List<String>> getExpPickupList(int brandcd, String dateStr, String seq, String eseq) throws Exception {
        Connection connection = null;
        CallableStatement cStmt = null;
        ResultSet rs = null;
        ArrayList<List<String>> sheetContents = new ArrayList<List<String>>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                cStmt = connection.prepareCall("{call YWM_EXCEL_EXPPICUP(?, ?, ?, ?, ?)}");
                cStmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                cStmt.setInt(2, brandcd);
                cStmt.setString(3, dateStr);
                cStmt.setString(4, seq);
                cStmt.setString(5, eseq);
                YDMAStringUtil.Print("[getExpPickupList]" + cStmt.toString());
                rs = cStmt.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                while (rs.next()) {
                    ArrayList<String> rowContent = new ArrayList<String>();
                    int i = 1;
                    while (i <= columnCount) {
                        rowContent.add(rs.getString(i));
                        ++i;
                    }
                    sheetContents.add(rowContent);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, cStmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, cStmt, rs);
        return sheetContents;
    }

    public List<List<String>> getExpPickupList(String strOrder) throws Exception {
        Connection connection = null;
        CallableStatement cStmt = null;
        ResultSet rs = null;
        ArrayList<List<String>> sheetContents = new ArrayList<List<String>>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                cStmt = connection.prepareCall("{call YWM_EXCEL_EXPPICUP_VER2(?)}");
                cStmt.setString(1, strOrder);
                YDMAStringUtil.Print("[getExpPickupList]" + cStmt.toString());
                rs = cStmt.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                while (rs.next()) {
                    ArrayList<String> rowContent = new ArrayList<String>();
                    int i = 1;
                    while (i <= columnCount) {
                        rowContent.add(rs.getString(i));
                        ++i;
                    }
                    sheetContents.add(rowContent);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, cStmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, cStmt, rs);
        return sheetContents;
    }

    public void setPickupExp(int brandcd, String dateAsign, String seq, List<List<String>> contents) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt_prodmst = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql_pickupexp = "insert into pickupexp (compno, brandcd, orddt, ordseq, seq, rorddt, rcvnam, pstno, addr, clpno, telno, qty, shpfee, credit, expprodnm, messge, PKGCLSS, SHIPCLS, SABORDNO,  SHOPID, ORDNM, ETCMSG, MALLCD, ORDAMT, PRODCD,OPTDESC, EXPBUNDNM, BOXCNT,  EXPFILE, EXPCD,FLAGSET,PRODCDM,EXPINVQTY,PRODNM,SPECDES,QTY2, RACKNM, OPTPRODCD,EXPINNER,EXPCOSTNM,NECCD1, NECCD2, NECCD3";
                if (seq.equals("3")) {
                    sql_pickupexp = String.valueOf(sql_pickupexp) + ",EXPNM , INVNO";
                }
                sql_pickupexp = String.valueOf(sql_pickupexp) + ") values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ? ,?, ? ";
                if (seq.equals("3")) {
                    sql_pickupexp = String.valueOf(sql_pickupexp) + ",? ,?";
                }
                sql_pickupexp = String.valueOf(sql_pickupexp) + ") ";
                sql_pickupexp = sql_pickupexp.toUpperCase();
                pstmt_prodmst = connection.prepareStatement(sql_pickupexp);
                statementlist.add(pstmt_prodmst);
                for (List<String> list : contents) {
                    int idx = 0;
                    int i = 0;
                    pstmt_prodmst.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_prodmst.setInt(++i, brandcd);
                    pstmt_prodmst.setString(++i, dateAsign);
                    pstmt_prodmst.setString(++i, seq);
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(idx++));
                    pstmt_prodmst.setString(++i, list.get(42));
                    pstmt_prodmst.setString(++i, list.get(43));
                    pstmt_prodmst.setString(++i, list.get(44));
                    if (seq.equals("3")) {
                        pstmt_prodmst.setString(++i, "\uae30\ud0c0_999");
                        pstmt_prodmst.setString(++i, "1234567890");
                    }
                    pstmt_prodmst.addBatch();
                    pstmt_prodmst.clearParameters();
                }
                pstmt_prodmst.executeBatch();
                pstmt_prodmst.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void clearSupplyPickupexp(int brandcd, String suppdt, String suppseq) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "update pickupexp set SUPPDT = null, SUPPSEQ = null, SUPPHSEQ = null where compno = ?   and brandcd = ?  and SUPPDT = ?   and SUPPSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(++i, brandcd);
                pstmt.setString(++i, suppdt);
                pstmt.setString(++i, suppseq);
                YDMAStringUtil.Print("[clearSupplyPickupexp]" + pstmt.toString());
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void clearAsignOrddtl(int brandcd, String dateAsign, String aseq) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "update orddtl set ASIGNDT = null, ASIGNSEQ = null, ASIGNHSEQ = null where compno = ?   and brandcd = ?  and ASIGNDT = ?   and ASIGNSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(++i, brandcd);
                pstmt.setString(++i, dateAsign);
                pstmt.setString(++i, aseq);
                YDMAStringUtil.Print("[clearAsignOrddtl]" + pstmt.toString());
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setAsignOrddtl(int brandcd, String dateStr, String seq, String eseq, String dateAsign, String aseq, List<List<String>> contents) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "update orddtl set ASIGNDT = ?, ASIGNSEQ = ?, ASIGNHSEQ = ?  where compno  = ?    and brandcd = ?   and orddt   = ?    and ordseq  = ?    and seq     = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (List<String> list : contents) {
                    String strTempDate = list.get(39);
                    if (!(strTempDate = strTempDate.replace("-", "")).equals(dateStr)) continue;
                    int i = 0;
                    pstmt.setString(++i, dateAsign);
                    pstmt.setString(++i, aseq);
                    pstmt.setString(++i, list.get(0));
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(++i, brandcd);
                    pstmt.setString(++i, dateStr);
                    String strTemp = list.get(0);
                    if (strTemp.length() == 9) {
                        strTemp = strTemp.substring(2);
                    } else if (strTemp.length() == 8) {
                        strTemp = strTemp.substring(1);
                    }
                    int sumseq = Integer.parseInt(strTemp);
                    int ordseq = Math.floorDiv(sumseq, 1000000);
                    int modseq = Math.floorMod(sumseq, 1000000);
                    pstmt.setInt(++i, ordseq);
                    pstmt.setInt(++i, modseq);
                    YDMAStringUtil.Print(pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void resetSuppwareList(int brandcd, String suppdt, String suppseq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " delete from suppware   where suppdt  = ?     and suppseq = ?     and compno = ?     and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, suppdt);
                pstmt.setString(2, suppseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                statementlist.add(pstmt);
                YDMAStringUtil.Print("[resetSuppwareList]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void resetSupplyList(int brandcd, String suppdt, String suppseq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " delete from suppdtl   where suppdt  = ?     and suppseq = ?     and compno = ?     and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, suppdt);
                pstmt.setString(2, suppseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                statementlist.add(pstmt);
                YDMAStringUtil.Print("[resetSupplyList]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void ExpPickUpListReset(int brandcd, String dateStr, String seq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " delete from pickupexp   where orddt  = ?     and ordseq = ?     and compno = ?     and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dateStr);
                pstmt.setString(2, seq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                statementlist.add(pstmt);
                YDMAStringUtil.Print("[ExpPickUpListReset]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<List<String>> getExpPickupListView(int brandcd, String dateStr, String seq) throws Exception {
        ArrayList<List<String>> sheetContents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(ORDDT,''), ifnull(ORDSEQ,'0'), ifnull(SEQ,'0'), ifnull(RORDDT,''), ifnull(RCVNAM,''), ifnull(PSTNO,''), ifnull(ADDR,''), ifnull(CLPNO,''), ifnull(TELNO,''), ifnull(QTY,'0'), ifnull(SHPFEE,'0'), ifnull(CREDIT,''), ifnull(EXPPRODNM,''), ifnull(MESSGE,''), ifnull(PKGCLSS,''), ifnull(SHIPCLS,''), ifnull(SABORDNO,''), ifnull(SHOPID,''), ifnull(ORDNM,''), ifnull(ETCMSG,''), ifnull(MALLCD,''), ifnull(ORDAMT,'0'), ifnull(PRODCD,''), ifnull(OPTDESC,''), ifnull(EXPBUNDNM,''), ifnull(BOXCNT,'0'), ifnull(EXPFILE,''), ifnull(EXPCD,''), ifnull(FLAGSET,''), ifnull(PRODCDM,''), ifnull(EXPINVQTY,'0'),ifnull(PRODNM,''), ifnull(SPECDES,''), ifnull(QTY2,'0'), ifnull(RACKNM,''), ifnull(OPTPRODCD,''), ifnull(EXPINNER,''), ifnull(EXPCOSTNM,''), ifnull(EXPNM,''), ifnull(INVNO,''), ifnull(expsenddt,''), ifnull(exprecvdt,''), ifnull(NECCD1,''), ifnull(NECCD2,''), ifnull(NECCD3,''), ifnull(FLAG,''), ifnull(SUPPDT,''), (SELECT PICQTY FROM suppdtl AS B WHERE B.compno = A.compno AND B.brandcd = A.brandcd AND B.suppdt = A.suppdt AND B.suppseq = A.suppseq AND B.seq = A.SUPPHSEQ) AS PICQTY  from pickupexp AS A  where ORDDT = ? and ordseq = ? and compno = ? and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dateStr);
                pstmt.setString(2, seq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                YDMAStringUtil.Print("[getExpPickupListView]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add("");
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    sheetContents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return sheetContents;
    }

    public List<PickupDto> getExpPickupListView2(int brandcd, String dateStr, String seq) throws Exception {
        ArrayList<PickupDto> sheetContents = new ArrayList();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(PickupDto.class);
        Connection connection = DBCPInit.getInstance().getConnection();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(ORDDT,'') AS ORDDT, ifnull(ORDSEQ,'0') AS ORDSEQ, ifnull(SEQ,'0') AS SEQ, ifnull(RORDDT,'') AS RORDDT, ifnull(RCVNAM,'') AS RCVNAM, ifnull(PSTNO,'') AS PSTNO, ifnull(ADDR,'') AS ADDR, ifnull(CLPNO,'') AS CLPNO, ifnull(TELNO,'') AS TELNO, ifnull(QTY,'0') AS QTY, ifnull(SHPFEE,'0') AS SHPFEE, ifnull(CREDIT,'') AS CREDIT, ifnull(EXPPRODNM,'') AS EXPPRODNM, ifnull(MESSGE,'') AS MESSGE, ifnull(PKGCLSS,'') AS PKGCLSS, ifnull(SHIPCLS,'') AS SHIPCLS, ifnull(SABORDNO,'') AS SABORDNO, ifnull(SHOPID,'') AS SHOPID, ifnull(ORDNM,'') AS ORDNM, ifnull(ETCMSG,'') AS ETCMSG, ifnull(MALLCD,'') AS MALLCD, ifnull(ORDAMT,'0') AS ORDAMT, ifnull(PRODCD,'') AS PRODCD, ifnull(OPTDESC,'') AS OPTDESC, ifnull(EXPBUNDNM,'') AS EXPBUNDNM, ifnull(BOXCNT,'0') AS BOXCNT, ifnull(EXPFILE,'') AS EXPFILE, ifnull(EXPCD,'') AS EXPCD, ifnull(FLAGSET,'') AS FLAGSET, ifnull(PRODCDM,'') AS PRODCDM, ifnull(EXPINVQTY,'0') AS EXPINVQTY,ifnull(PRODNM,'') AS PRODNM, ifnull(SPECDES,'') AS SPECDES, ifnull(QTY2,'0') AS QTY2, ifnull(RACKNM,'') AS RACKNM, ifnull(OPTPRODCD,'') AS OPTPRODCD, ifnull(EXPINNER,'') AS EXPINNER, ifnull(EXPCOSTNM,'') AS EXPCOSTNM, ifnull(EXPNM,'') AS EXPNM, ifnull(INVNO,'') AS INVNO, ifnull(expsenddt,'') AS EXPSENDDT, ifnull(exprecvdt,'') AS EXPRECVDT, ifnull(NECCD1,'') AS NECCD1, ifnull(NECCD2,'') AS NECCD2, ifnull(NECCD3,'') AS NECCD3, ifnull(FLAG,'') AS FLAG, ifnull(SUPPDT,'') AS SUPPDT, (SELECT PICQTY FROM suppdtl AS B WHERE B.compno = A.compno AND B.brandcd = A.brandcd AND B.suppdt = A.suppdt AND B.suppseq = A.suppseq AND B.seq = A.SUPPHSEQ) AS PICQTY  from pickupexp AS A  where ORDDT = ? and ordseq = ? and compno = ? and brandcd = ? ";
                sql = sql.toUpperCase();
                Object[] params = new Object[]{dateStr, seq, YDMASessonUtil.getCompnoInfo().getCompno(), brandcd};
                YDMAStringUtil.Print("[getExpPickupListView]" + params.toString());
                sheetContents = (List)run.query(connection, sql, (ResultSetHandler)handler, new Object[]{dateStr, seq, YDMASessonUtil.getCompnoInfo().getCompno(), brandcd});
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DbUtils.closeQuietly((Connection)connection);
        }
        return sheetContents;
    }

    public void ExpCodeNExpnmUpdate(String seq, String ordseq, String rcvnam, String prodcd, String prodnm, String invno, String expnm, String orddt, String addr, String tel, String qty, String shpfee, String credit, String message, String sabordno, String ordnm, String ordamt, String expcd, String etcmsg, String zipcode, int brandcd) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "update pickupexp set expnm=?, invno=?, pstno = ?, addr = ?, clpno = ?, qty = ?, shpfee =?, credit = ?, MESSGE = ?, SABORDNO = ? , ORDNM=?, ORDAMT=?, EXPCD=?, ETCMSG=?, EXPPRODNM = ?, RCVNAM = ?, prodcd = ? where seq = ? and ordseq = ? and orddt = ? and compno = ? and BRANDCD = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, expnm);
                pstmt.setString(++i, invno);
                pstmt.setString(++i, zipcode);
                pstmt.setString(++i, addr);
                pstmt.setString(++i, tel);
                pstmt.setString(++i, qty);
                pstmt.setString(++i, shpfee);
                pstmt.setString(++i, credit);
                pstmt.setString(++i, message);
                pstmt.setString(++i, sabordno);
                pstmt.setString(++i, ordnm);
                pstmt.setString(++i, ordamt);
                pstmt.setString(++i, expcd);
                pstmt.setString(++i, etcmsg);
                pstmt.setString(++i, prodnm);
                pstmt.setString(++i, rcvnam);
                pstmt.setString(++i, prodcd);
                pstmt.setString(++i, seq);
                pstmt.setString(++i, ordseq);
                pstmt.setString(++i, orddt);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(++i, brandcd);
                YDMAStringUtil.Print("[updateProduct]" + pstmt.toString());
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public boolean isExistExpress(int brandcd, String dateStr, String aseq) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ORDDT,ORDSEQ from pickupexp  where ORDDT = ? and ORDSEQ = ? and compno = ? and brandcd= ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dateStr);
                pstmt.setString(2, aseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                YDMAStringUtil.Print("[isExistExpress]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isCanExpPickUpListReset(int brandcd, String dateAsign, String aseq) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select 1 from pickupexp  where ORDDT = ? and ORDSEQ = ? and compno = ? and brandcd= ?    and suppdt is not null";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dateAsign);
                pstmt.setString(2, aseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                YDMAStringUtil.Print("[isCanExpPickUpListReset]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public void pickupExpressUpdate(String data2, String seq, String bizno) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "update pickupexp set invno=? where seq = ? and orddt = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, bizno);
                pstmt.setString(++i, seq);
                pstmt.setString(++i, data2);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[updateProduct]" + pstmt.toString());
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int getSumExpress(String dateStr, String seq, String revnam) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT sum(qty*shpfee) FROM pickupexp WHERE ORDDT = ? and ORDSEQ = ? and rcvnam = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dateStr);
                pstmt.setString(2, seq);
                pstmt.setString(3, revnam);
                pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                result = rs.next() ? rs.getInt(1) : 0;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int PickupListInsert(String orddt, String seq, String ordseq, String rorddt, String rcvnam, String prodcd, String prodnm, String zipcode, String addr, String tel, String qty, String shpfee, String credit, String message, String ordnm, String ordamt, String expfile, String expcd, String etcmsg, String invno, String expnm, String expkindnm, String shipcls, int brandcd) throws Exception {
        int result;
        block5: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            result = 0;
            String sql = "insert into pickupexp(COMPNO, ORDDT, seq, ORDSEQ,rorddt, RCVNAM,prodcd, EXPPRODNM, prodnm, PSTNO, ADDR, CLPNO,  QTY, SHPFEE, CREDIT, ORDNM, ORDAMT,  EXPFILE,  EXPCD, ETCMSG, MESSGE, EXPNM, INVNO,SHIPCLS,BRANDCD)  values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?,? , ? ) ";
            sql = sql.toUpperCase();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    pstmt = connection.prepareStatement(sql);
                    int i = 0;
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++i, orddt);
                    pstmt.setString(++i, seq);
                    pstmt.setString(++i, ordseq);
                    pstmt.setString(++i, rorddt);
                    pstmt.setString(++i, rcvnam);
                    pstmt.setString(++i, prodcd);
                    pstmt.setString(++i, String.valueOf(expkindnm) + "\u25c6" + prodnm);
                    pstmt.setString(++i, prodnm);
                    pstmt.setString(++i, zipcode);
                    pstmt.setString(++i, addr);
                    pstmt.setString(++i, tel);
                    pstmt.setString(++i, qty);
                    pstmt.setString(++i, shpfee);
                    pstmt.setString(++i, credit);
                    pstmt.setString(++i, ordnm);
                    pstmt.setString(++i, ordamt);
                    pstmt.setString(++i, expfile);
                    pstmt.setString(++i, expcd);
                    pstmt.setString(++i, etcmsg);
                    pstmt.setString(++i, message);
                    pstmt.setString(++i, expnm);
                    pstmt.setString(++i, invno);
                    pstmt.setString(++i, shipcls);
                    pstmt.setInt(++i, brandcd);
                    YDMAStringUtil.Print("[insertProdIFM]" + pstmt.toString());
                    result = pstmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
        return result;
    }

    public List<String> ExpFileList(String prodcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(expfile,''), ifnull(expcd,''), ifnull(expkindnm,'') FROM expprodmst WHERE compno = ? and prodcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, prodcd);
                YDMAStringUtil.Print("[ExpFileList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString(1));
                    list.add(rs.getString(2));
                    list.add(rs.getString(3));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void setExpress(List<List<String>> hapDongDeasin) {
    }

    public List<PickupDto> getExpSupplyList(int brandcd, String asigndt, String asignseq, String suppdt, String suppseq) throws Exception {
        ArrayList<PickupDto> list = new ArrayList<PickupDto>();
        Connection connection = null;
        CallableStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareCall("{call YWM_SUPPLYAUTO_PROC(?, ?, ?, ?, ?, ? )}");
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, asigndt);
                pstmt.setString(4, asignseq);
                pstmt.setString(5, suppdt);
                pstmt.setString(6, suppseq);
                YDMAStringUtil.Print("[getExpSupplyList]" + pstmt.toString());
                rs = pstmt.executeQuery();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<PickupDto> getSupplyDtl(int brandcd, String dateStr, String ordseq, int check, String searchText, int supplyYN) throws Exception {
        ArrayList<PickupDto> list = new ArrayList<PickupDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(BRANDCD,''), ifnull(SUPPDT,''), ifnull(SUPPSEQ,''), ifnull(SEQ,''), ifnull(EXPNM,''), ifnull(INVNO,''),ifnull(PRODCD,''),ifnull(QTY,''), ifnull(PICQTY,'') FROM suppdtl where COMPNO = ? and BRANDCD = ? and SUPPDT = ? and SUPPSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, dateStr);
                pstmt.setString(4, ordseq);
                YDMAStringUtil.Print("[getSupplyDtl]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    PickupDto dto = new PickupDto();
                    int rowno = 0;
                    dto.setBrandcd(rs.getString(++rowno));
                    dto.setOrddt(rs.getString(++rowno));
                    dto.setOrdseq(rs.getString(++rowno));
                    dto.setSeq(rs.getString(++rowno));
                    dto.setExpnm(rs.getString(++rowno));
                    dto.setInvono(rs.getString(++rowno));
                    dto.setProdcd(rs.getString(++rowno));
                    dto.setQty(rs.getString(++rowno));
                    dto.setPicqty(rs.getString(++rowno));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<PickupDto> getSuppDtlList(int brandcd, String suppdt, String suppseq, String express, String invono) throws Exception {
        ArrayList<PickupDto> list = new ArrayList<PickupDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(BRANDCD,''),ifnull(SUPPDT,''),ifnull(SUPPSEQ,''), ifnull(SEQ,''), ifnull(EXPNM,''), ifnull(INVNO,''), ifnull(ORDDT,''), ifnull(ORDSEQ,''), ifnull(ORDHSEQ,''), ifnull(RCVNAM,''), ifnull(PSTNO,''), ifnull(ADDR,''), ifnull(PRODCD,''), ifnull(EXPPRODNM,''), ifnull(QTY,'') , ifnull(PICQTY,'')  FROM suppdtl  where COMPNO = ? and BRANDCD = ? and SUPPDT = ? and suppseq = ? ";
                if (!express.equals("")) {
                    sql = String.valueOf(sql) + "   and EXPNM LIKE '%" + express + "%' ";
                }
                if (!invono.equals("")) {
                    sql = String.valueOf(sql) + "   and INVNO LIKE '%" + invono + "%' ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, suppdt);
                pstmt.setString(4, suppseq);
                YDMAStringUtil.Print("[getExpSupplyList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    PickupDto dto = new PickupDto();
                    int rowno = 0;
                    dto.setBrandcd(rs.getString(++rowno));
                    dto.setSuppdt(rs.getString(++rowno));
                    dto.setSuppseq(rs.getString(++rowno));
                    dto.setSeq(rs.getString(++rowno));
                    dto.setExpnm(rs.getString(++rowno));
                    dto.setInvono(rs.getString(++rowno));
                    dto.setOrddt(rs.getString(++rowno));
                    dto.setOrdseq(rs.getString(++rowno));
                    dto.setOrdhseq(rs.getString(++rowno));
                    dto.setRcvnam(rs.getString(++rowno));
                    dto.setPstno(rs.getString(++rowno));
                    dto.setAddr(rs.getString(++rowno));
                    dto.setProdcd(rs.getString(++rowno));
                    dto.setExpprodnm(rs.getString(++rowno));
                    dto.setQty(rs.getString(++rowno));
                    dto.setPicqty(rs.getString(++rowno));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public boolean isPickupExp(int brandcd, String asigndt, String asignseq) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ORDDT,ORDSEQ from pickupexp  where ORDDT = ? and ORDSEQ = ? and compno = ? and brandcd= ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, asigndt);
                pstmt.setString(2, asignseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                YDMAStringUtil.Print("[isExistExpress]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isSuppDtl(int brandcd, String suppdt, String suppseq) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select SUPPDT,SUPPSEQ from suppdtl  where SUPPDT = ? and SUPPSEQ = ? and compno = ? and brandcd= ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, suppdt);
                pstmt.setString(2, suppseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                YDMAStringUtil.Print("[isExistExpress]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public List<PickupDto> getSupplyWare(PickupDto dto, int brandcd) throws Exception {
        ArrayList<PickupDto> list = new ArrayList<PickupDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(BRANDCD,''),ifnull(SUPPDT,''),ifnull(SUPPSEQ,''), ifnull(SEQ,''),  ifnull(NECSEQ,''),ifnull(ADDSEQ,''), ifnull(PRODCDM,''), ifnull(PRODCD,''), ifnull(SETLEVEL,''), ifnull(WARECD,''), ifnull(NECCD1,''), ifnull(NECCD2,''), ifnull(NECCD3,''),  ifnull(QTY,''),  (SELECT PRODNM FROM prodmst AS P WHERE P.PRODCD = S.PRODCD AND P.COMPNO = S.COMPNO AND P.BRANDCD = S.BRANDCD) AS PRODNM   FROM suppware AS S where COMPNO = ? and BRANDCD = ? and SUPPDT = ?   and suppseq = ? and SEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, dto.getSuppdt());
                pstmt.setString(4, dto.getSuppseq());
                pstmt.setString(5, dto.getSeq());
                YDMAStringUtil.Print("[getExpSupplyList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    PickupDto dtoware = new PickupDto();
                    int rowno = 0;
                    dtoware.setBrandcd(rs.getString(++rowno));
                    dtoware.setSuppdt(rs.getString(++rowno));
                    dtoware.setSuppseq(rs.getString(++rowno));
                    dtoware.setSeq(rs.getString(++rowno));
                    dtoware.setNecseq(rs.getString(++rowno));
                    dtoware.setAddseq(rs.getString(++rowno));
                    dtoware.setProdcdm(rs.getString(++rowno));
                    dtoware.setProdcd(rs.getString(++rowno));
                    dtoware.setSetlevel(rs.getInt(++rowno));
                    dtoware.setWarecd(rs.getString(++rowno));
                    dtoware.setNeccd1(rs.getString(++rowno));
                    dtoware.setNeccd2(rs.getString(++rowno));
                    dtoware.setNeccd3(rs.getString(++rowno));
                    dtoware.setQty(rs.getString(++rowno));
                    dtoware.setProdnm(rs.getString(++rowno));
                    list.add(dtoware);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<SummeryDto> getSum_warehouseqty(int brandcd, String prodcd) throws Exception {
        ArrayList<SummeryDto> list = new ArrayList<SummeryDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(BRANDCD,''),ifnull(PRODCD,''), \t\t (select prodnm from prodmst as C where B.compno=C.compno and B.brandcd=C.brandcd and B.prodcd=C.prodcd) as prodnm, \n\t\t ifnull(WARECD,''), \n \t\t (select warenm from warehouse as C where B.compno=C.compno and B.brandcd=C.brandcd and B.WARECD=C.warecd) as warenm, \n \t\t ifnull(NECCD1,''), ifnull(NECCD2,''), ifnull(NECCD3,''), ifnull(BASEQTY,''), ifnull(BEF_RECEIVEQTY,''), \n \t\t ifnull(RECEIVEQTY,''), ifnull(SALEQTY,''), ifnull(WAREQTY,'') \n  FROM sum_warehouseqty as B \n where COMPNO = ? \n   and BRANDCD = ? \n   and PRODCD = ? \n   and ifnull(WAREQTY,0) <> 0 \n";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, prodcd);
                YDMAStringUtil.Print("[getSum_warehouseqty]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    SummeryDto dtoware = new SummeryDto();
                    int rowno = 0;
                    dtoware.setBrandcd(rs.getString(++rowno));
                    dtoware.setProdcd(rs.getString(++rowno));
                    dtoware.setProdnm(rs.getString(++rowno));
                    dtoware.setWarecd(rs.getString(++rowno));
                    dtoware.setWarenm(rs.getString(++rowno));
                    dtoware.setNeccd1(rs.getString(++rowno));
                    dtoware.setNeccd2(rs.getString(++rowno));
                    dtoware.setNeccd3(rs.getString(++rowno));
                    dtoware.setBaseqty(rs.getString(++rowno));
                    dtoware.setBef_receiveqty(rs.getString(++rowno));
                    dtoware.setReceiveqty(rs.getString(++rowno));
                    dtoware.setSaleqty(rs.getString(++rowno));
                    dtoware.setWareqty(rs.getString(++rowno));
                    list.add(dtoware);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<SummeryDto> getSum_warehouseqtyPeriod(int brandcd, String prodcd, String sDate, String eDate) throws Exception {
        ArrayList<SummeryDto> list = new ArrayList<SummeryDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(BRANDCD,''),IFNULL(PRODCD,''),IFNULL(WARECD,''),  (select warenm from warehouse as C where S.compno=C.compno and S.brandcd=C.brandcd and S.WARECD=C.warecd) as warenm,  IFNULL(NECCD1,''), IFNULL(NECCD2,''), IFNULL(NECCD3,''), IFNULL(BASEQTY,''), IFNULL(BEF_RECEIVEQTY,''),  (SELECT ifnull(SUM(R.AFTQTY),0) FROM recvware AS R WHERE R.NECCD1 = S.NECCD1 AND R.NECCD2 = S.NECCD2 AND R.NECCD3 = S.NECCD3 " + String.format(" AND R.COMPNO = '%s' AND R.BRANDCD = %s AND PRODCD = '%s'  AND recvdt BETWEEN \"%s\" AND \"%s\") AS RECEIVEQTY, ", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd, prodcd, sDate, eDate) + " (SELECT ifnull(SUM(W.QTY),0) FROM suppware AS W WHERE W.NECCD1 = S.NECCD1 AND W.NECCD2 = S.NECCD2 AND W.NECCD3 = S.NECCD3 " + String.format(" AND W.COMPNO = '%s' AND W.BRANDCD = %s AND PRODCD = '%s'  AND suppdt BETWEEN \"%s\" AND \"%s\") AS SALEQTY, ", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd, prodcd, sDate, eDate) + " IFNULL(WAREQTY,'')  " + "FROM SUM_WAREHOUSEQTY AS S WHERE COMPNO = ? AND BRANDCD = ? AND PRODCD = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, prodcd);
                YDMAStringUtil.Print("[getExpSupplyList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    SummeryDto dtoware = new SummeryDto();
                    int rowno = 0;
                    dtoware.setBrandcd(rs.getString(++rowno));
                    dtoware.setProdcd(rs.getString(++rowno));
                    dtoware.setWarecd(rs.getString(++rowno));
                    dtoware.setWarenm(rs.getString(++rowno));
                    dtoware.setNeccd1(rs.getString(++rowno));
                    dtoware.setNeccd2(rs.getString(++rowno));
                    dtoware.setNeccd3(rs.getString(++rowno));
                    dtoware.setBaseqty(rs.getString(++rowno));
                    dtoware.setBef_receiveqty(rs.getString(++rowno));
                    dtoware.setReceiveqty(rs.getString(++rowno));
                    dtoware.setSaleqty(rs.getString(++rowno));
                    dtoware.setWareqty(rs.getString(++rowno));
                    list.add(dtoware);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int setSuppwareDelete(PickupDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " delete from suppware where COMPNO =? and BRANDCD = ? and SUPPDT = ? and SUPPSEQ = ? and SEQ = ? and NECSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dto.getBrandcd());
                pstmt.setString(3, dto.getSuppdt());
                pstmt.setString(4, dto.getSuppseq());
                pstmt.setString(5, dto.getSeq());
                pstmt.setString(6, dto.getNecseq());
                statementlist.add(pstmt);
                YDMAStringUtil.Print("[ExpPickUpListReset]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public void setSuppwareInsert(List<PickupDto> wareList) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " insert into suppware (COMPNO, BRANDCD, SUPPDT,  SUPPSEQ, SEQ,NECSEQ, ADDSEQ, PRODCDM, PRODCD, SETLEVEL, WARECD, NECCD1, NECCD2, NECCD3,  QTY ) VALUES(? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ) ";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (PickupDto dto : wareList) {
                    int idx = 0;
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++idx, dto.getBrandcd());
                    pstmt.setString(++idx, dto.getSuppdt());
                    pstmt.setString(++idx, dto.getSuppseq());
                    pstmt.setString(++idx, dto.getSeq());
                    pstmt.setString(++idx, dto.getNecseq());
                    pstmt.setString(++idx, dto.getAddseq());
                    pstmt.setString(++idx, dto.getProdcdm());
                    pstmt.setString(++idx, dto.getProdcd());
                    pstmt.setInt(++idx, dto.getSetlevel());
                    pstmt.setString(++idx, dto.getWarecd());
                    pstmt.setString(++idx, dto.getNeccd1());
                    pstmt.setString(++idx, dto.getNeccd2());
                    pstmt.setString(++idx, dto.getNeccd3());
                    pstmt.setString(++idx, dto.getQty().equals("") ? "0" : dto.getQty());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }
}

