/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.common;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CaffeineCategoryCache {
    private final LoadingCache<String, String> cache;
    private final LoadingCache<String, Optional<String>> fullNameCache;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final CaffeineCategoryCache INSTANCE = new CaffeineCategoryCache();
    private static final String CATEGORY_PREFIX = "CATEGORY::";

    public static CaffeineCategoryCache getInstance() {
        return INSTANCE;
    }

    private CaffeineCategoryCache() {
        YDMAStringUtil.Print("\ufffd\uc41f CaffeineCategoryCache \u73e5\ub347\ub9b0\ufffd\uc195 \ufffd\ub586\ufffd\uc609");
        this.cache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(12L, TimeUnit.HOURS).build(this::loadFromDb);
        this.fullNameCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(12L, TimeUnit.HOURS).build(this::loadFullNameFromDbOptional);
        this.scheduleInvalidateTask();
    }

    private String loadFromDb(String key) throws Exception {
        try {
            String[] parts = key.split("::", 2);
            String shopcd = parts[0];
            String code = parts[1];
            YDMAStringUtil.Print("\ufffd\uc716\ufffd shopcategorys \uf9e6\uba2f\ub586 \u8a98\uba84\ub4aa \ufffd\ub102 DB \u8b70\uace0\uc276: " + key);
            return ShopCommonDao.get().getCategoryMatchCode(shopcd, code);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ufffd\uc4ec loadFromDb \ufffd\ub58e\ufffd\ub663: " + key + " \ufffd\ub102 " + e.getMessage());
            throw e;
        }
    }

    private Optional<String> loadFullNameFromDbOptional(String key) throws Exception {
        try {
            String id = key.replaceFirst(CATEGORY_PREFIX, "");
            YDMAStringUtil.Print("\ufffd\uc716\ufffd category \uf9e6\uba2f\ub586 \u8a98\uba84\ub4aa \ufffd\ub102 DB \u8b70\uace0\uc276: " + key);
            ShopProductDao.get();
            String fullName = ShopProductDao.getFullCategoryName(id);
            if (fullName == null || fullName.trim().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(fullName);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ufffd\uc4ec loadFullNameFromDb \ufffd\ub58e\ufffd\ub663: " + key + " \ufffd\ub102 " + e.getMessage());
            throw e;
        }
    }

    public String getCategoryName(String shopcd, String code) throws Exception {
        String key = String.valueOf(shopcd) + "::" + code;
        String cached = (String)this.cache.getIfPresent((Object)key);
        if (cached != null) {
            YDMAStringUtil.Print("\ufffd\uc70b\ucadfhopcategorys \uf9e6\uba2f\ub586 HIT: " + key);
            return cached;
        }
        return (String)this.cache.get((Object)key);
    }

    public String getFullCategoryName(String id) throws Exception {
        String key = CATEGORY_PREFIX + id;
        Optional result = (Optional)this.fullNameCache.getIfPresent((Object)key);
        if (result != null) {
            if (result.isPresent()) {
                YDMAStringUtil.Print("\ufffd\uc70b\ucac8ategory \uf9e6\uba2f\ub586 HIT: " + key);
                return (String)result.get();
            }
            YDMAStringUtil.Print("\ufffd\uc70b\ucac8ategory \uf9e6\uba2f\ub586 HIT (but empty): " + key);
            return "";
        }
        result = (Optional)this.fullNameCache.get((Object)key);
        return result.orElse("");
    }

    public void invalidate(String shopcd, String code) {
        String key = String.valueOf(shopcd) + "::" + code;
        this.cache.invalidate((Object)key);
    }

    public void invalidateCategory(String id) {
        String key = CATEGORY_PREFIX + id;
        this.fullNameCache.invalidate((Object)key);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
        this.fullNameCache.invalidateAll();
        YDMAStringUtil.Print("\ufffd\uc70d\ufffd \uf9e6\uba2f\ub586 \ufffd\uc7fe\uf9e3\ufffd \u73e5\ub347\ub9b0\ufffd\uc195\ufffd\ub9d6");
    }

    private void scheduleInvalidateTask() {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        this.scheduler.scheduleAtFixedRate(() -> {
            YDMAStringUtil.Print("\ufffd\uc70e\ufffd \uf9e6\uba2f\ub586 \ufffd\uc604\ufffd\ub8de \u73e5\ub347\ub9b0\ufffd\uc195 \ufffd\ub58e\ufffd\ubefe");
            this.invalidateAll();
        }, 6L, 6L, TimeUnit.HOURS);
    }

    public void shutdownScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
            YDMAStringUtil.Print(" Caffeine \ufffd\ub4aa\u8033\ufffd\u4ee5\uafa8\uc72d \u91ab\ub085\uc9ba\ufffd\ub9d6");
        }
    }
}

