/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.domesin;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.shop.common.CaffeineCategoryCache;
import com.kdjsystem.mlink.yellim.shop.common.ChromeExtention;
import com.kdjsystem.mlink.yellim.shop.common.ChromeScript;
import com.kdjsystem.mlink.yellim.shop.common.HttpClientEx;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.yellim.shop.dao.ProductResultDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.domesin.CateDao;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinOption;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinOptionList;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinSessonUtil;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class DomesinCommon {
    public static DomesinCommon instance = new DomesinCommon();
    static final String LOGIN_HOST = "http://www.domesin.com";
    public static final String DATA_HOST = "http://data.domesin.com";
    public static String UserId = "";
    public static String UserPassword = "";
    public static String UserApiKey = "";
    public static String FailReason = "";
    public static List<CategoryItemDomesin> category;
    Map<String, String> cookie;
    ChromeDriver driver;

    private DomesinCommon() {
    }

    public static DomesinCommon get() {
        return instance;
    }

    public boolean LoadCategory() throws Exception {
        HashMap<String, String> postPara = null;
        String response = "";
        String path = "/API/COUPANG4/category.php";
        YDMAStringUtil.Print("[DoMeSin] load category start...");
        postPara = new HashMap<String, String>();
        postPara.put("id", UserId);
        postPara.put("api_key", UserApiKey);
        String postForm = this.ConvertDictionaryToParameter(postPara);
        response = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").Post(DATA_HOST.concat(path), postForm);
        if (response == null) {
            return false;
        }
        ObjectMapper mapper = new ObjectMapper();
        CategoryDomesin Category2 = null;
        Category2 = (CategoryDomesin)mapper.readValue(response, CategoryDomesin.class);
        if (Category2.code.equals("0000")) {
            int maxDebug = Category2.data.length > 5 ? 5 : Category2.data.length;
            YDMAStringUtil.Print("    debug counts: " + maxDebug);
            int idx = 0;
            while (idx < maxDebug) {
                YDMAStringUtil.Print("    [" + idx + "]");
                YDMAStringUtil.Print("      cid: " + Category2.data[idx].cid);
                YDMAStringUtil.Print("      name: " + Category2.data[idx].name);
                YDMAStringUtil.Print("      deep: " + Category2.data[idx].deep);
                YDMAStringUtil.Print("      parent_cid: " + Category2.data[idx].parent_cid);
                YDMAStringUtil.Print("      ca_qty: " + Category2.data[idx].ca_qty);
                YDMAStringUtil.Print("      fullcat: " + Category2.data[idx].fullcat);
                YDMAStringUtil.Print("      ec: " + Category2.data[idx].ec);
                ++idx;
            }
        } else {
            FailReason = "\uce74\ud14c\uace0\ub9ac\uc5d0 \uc815\uc758\ub418\uc9c0 \uc54a\uc740 \uc5d0\ub7ec\uac00 \uc788\uc2b5\ub2c8\ub2e4...";
            YDMAStringUtil.Print("    Error: " + FailReason);
        }
        category = Arrays.asList(Category2.data);
        YDMAStringUtil.Print("[DoMeSin] load category finish...");
        return true;
    }

    public String getParentClassCd(String cid) {
        return category.stream().filter(p -> p.cid.equals(cid)).map(p -> p.parent_cid).findAny().orElse("");
    }

    public String getCateName(String cid) {
        return category.stream().filter(p -> p.cid.equals(cid)).map(p -> p.name).findAny().orElse("");
    }

    public String getFullCateName(String cid) {
        return category.stream().filter(p -> p.cid.equals(cid)).map(p -> p.fullcat).findAny().orElse("");
    }

    public void setCategoryDao() throws Exception {
        List firstLevel = category.stream().filter(p -> p.deep.equals("1")).collect(Collectors.toList());
        for (CategoryItemDomesin item : firstLevel) {
            YDMAStringUtil.Print(item.toString());
            CateDao.get().categoryLargeInsert(item.cid, item.name, "0", "1", "\ub3c4\ub9e4\uc758\uc2e0", "", "shop0283");
        }
        YDMAStringUtil.Print();
        List secondLevel = category.stream().filter(p -> p.deep.equals("2")).collect(Collectors.toList());
        for (CategoryItemDomesin item : secondLevel) {
            YDMAStringUtil.Print(item.toString());
            CateDao.get().categoryMidiumInsert(item.parent_cid, item.parent_cid.concat(item.cid), item.name, "0", "1", "\ub3c4\ub9e4\uc758\uc2e0", "", "shop0283");
        }
        YDMAStringUtil.Print();
        List thirdLevel = category.stream().filter(p -> p.deep.equals("3")).collect(Collectors.toList());
        for (CategoryItemDomesin item : thirdLevel) {
            YDMAStringUtil.Print(item.toString());
            CategoryItemDomesin parentItem = secondLevel.stream().filter(p -> p.cid.equals(categoryItemDomesin.parent_cid)).findAny().get();
            String midcode = String.format("%s%s", parentItem.parent_cid, parentItem.cid);
            CateDao.get().categorySmallInsert(midcode, midcode.concat(item.cid), item.name, "0", "1", "\ub3c4\ub9e4\uc758\uc2e0", "", item.ec, "shop0283");
        }
        YDMAStringUtil.Print();
    }

    public Map<String, String> GetProductQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("date_type", "0");
        parameters.put("start_date", "2020-03-01");
        parameters.put("end_date", "2020-03-09");
        parameters.put("cid_type", "1");
        parameters.put("min_amount", "0");
        parameters.put("max_amount", "0");
        parameters.put("vender_m_code_type", "0");
        parameters.put("vender_m_code", "");
        parameters.put("icode_type", "0");
        parameters.put("icode_arr", "");
        parameters.put("q", "");
        parameters.put("is_overseas", "");
        parameters.put("is_tax", "");
        parameters.put("isreturn", "");
        parameters.put("islimit", "");
        parameters.put("delivery_type", "");
        parameters.put("list_option_use", "");
        parameters.put("adult", "");
        parameters.put("status", "1");
        return parameters;
    }

    public DomesinOptionList getOptionList(String option2) {
        DomesinOptionList optionList = new DomesinOptionList();
        ArrayList<DomesinOption> ret_options = new ArrayList<DomesinOption>();
        List lines = Arrays.stream(option2.split("\\r|\\n")).collect(Collectors.toList());
        String title = (String)lines.get(0);
        lines.remove(0);
        title = title.replace("[", "");
        title = title.replace("]", "");
        int dan = title.split("=").length;
        optionList.setDan(dan);
        if (dan == 3) {
            optionList.setChar_1_nm(title.split("=")[0]);
            optionList.setChar_2_nm(title.split("=")[1]);
            optionList.setChar_3_nm(title.split("=")[2]);
        } else if (dan == 2) {
            String[] charnms = title.split("=");
            if (charnms[0].indexOf("\uc0c9\uc0c1") > 0) {
                optionList.setChar_1_nm("\uce7c\ub77c");
            } else {
                optionList.setChar_1_nm(charnms[0]);
            }
            optionList.setChar_2_nm(charnms.length > 1 ? charnms[1] : "");
        } else if (dan == 1) {
            String char_1_nm = title.indexOf("\uc0c9\uc0c1") > 0 ? "\uce7c\ub77c" : title;
            optionList.setChar_1_nm(char_1_nm);
        }
        String optionType = "";
        if (dan == 3) {
            optionType = optionList.getChar_1_nm().concat(":").concat(optionList.getChar_2_nm()).concat(":").concat(optionList.getChar_3_nm());
        } else if (dan == 2) {
            optionType = optionList.getChar_1_nm().concat(":").concat(optionList.getChar_2_nm());
        } else if (dan == 1) {
            optionType = optionList.getChar_1_nm();
        }
        for (String line : lines) {
            DomesinOption dto = new DomesinOption();
            List<String> lst_option = Arrays.asList(line.split("="));
            dto.setOptionType(optionType);
            if (lst_option.size() < 6) continue;
            if (dan == 2) {
                dto.setOptionName1(lst_option.get(5).equals("1") ? lst_option.get(0).concat("(\ud488\uc808)") : lst_option.get(0));
                dto.setOptionName2(lst_option.get(5).equals("1") ? lst_option.get(1).concat("(\ud488\uc808)") : lst_option.get(1));
            } else if (dan == 1) {
                if (lst_option.get(0).equals("\uc0c1\ud488\uc120\ud0dd")) {
                    dto.setOptionName1(lst_option.get(5).equals("1") ? lst_option.get(0).concat("(\ud488\uc808)") : lst_option.get(1));
                } else {
                    dto.setOptionName1(lst_option.get(5).equals("1") ? lst_option.get(0).concat("(\ud488\uc808)") : lst_option.get(0));
                }
            }
            dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
            dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
            dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
            dto.setSoldOut(YDMAStringUtil.convertToInt(lst_option.get(5)));
            ret_options.add(dto);
        }
        if (ret_options.size() > 0 && dan == 2) {
            String char_2_val = ret_options.stream().map(p -> p.getOptionName2()).collect(Collectors.joining(","));
            optionList.setChar_2_val(char_2_val);
        }
        optionList.setOptions(ret_options);
        return optionList;
    }

    public DomesinOptionList getOrderOptionList(String option2) throws Exception {
        DomesinOptionList optionList = new DomesinOptionList();
        ArrayList<DomesinOption> ret_options = new ArrayList<DomesinOption>();
        List lines = Arrays.stream(option2.split("\\r|\\n")).collect(Collectors.toList());
        String title = (String)lines.get(0);
        lines.remove(0);
        title = title.replace("[", "");
        title = title.replace("]", "");
        int dan = title.split("=").length;
        optionList.setDan(dan);
        if (dan == 2) {
            String[] charnms = title.split("=");
            if (charnms[0].indexOf("\uc0c9\uc0c1") > 0) {
                optionList.setChar_1_nm("\uce7c\ub77c");
            } else {
                optionList.setChar_1_nm(charnms[0]);
            }
            optionList.setChar_2_nm(charnms.length > 1 ? charnms[1] : "");
        } else if (dan == 1) {
            String char_1_nm = title.indexOf("\uc0c9\uc0c1") > 0 ? "\uce7c\ub77c" : title;
            optionList.setChar_1_nm(char_1_nm);
        }
        String optionType = "";
        if (dan == 2) {
            optionType = optionList.getChar_1_nm().concat(":").concat(optionList.getChar_2_nm());
        } else if (dan == 1) {
            optionType = optionList.getChar_1_nm();
        }
        for (String line : lines) {
            DomesinOption dto = new DomesinOption();
            List<String> lst_option = Arrays.asList(line.split("="));
            dto.setOptionType(optionType);
            if (dan == 2) {
                dto.setOptionName1(lst_option.get(5).equals("1") ? lst_option.get(0).concat("(\ud488\uc808)") : lst_option.get(0));
                dto.setOptionName2(lst_option.get(5).equals("1") ? lst_option.get(1).concat("(\ud488\uc808)") : lst_option.get(1));
            } else if (dan == 1) {
                dto.setOptionName1(lst_option.get(5).equals("1") ? lst_option.get(0).concat("(\ud488\uc808)") : lst_option.get(0));
            }
            dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
            dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
            dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
            dto.setSoldOut(YDMAStringUtil.convertToInt(lst_option.get(5)));
            ret_options.add(dto);
        }
        if (ret_options.size() > 0 && dan == 2) {
            String char_2_val = ret_options.stream().map(p -> p.getOptionName2()).collect(Collectors.joining(","));
            optionList.setChar_2_val(char_2_val);
        }
        optionList.setOptions(ret_options);
        return optionList;
    }

    public Map<String, ProductResultDto> getProductQuery(Map<String, String> parameters) throws Exception {
        ProductResultDto productDomesin;
        int page = 0;
        HashMap<String, ProductResultDto> resultProdList = new HashMap<String, ProductResultDto>();
        do {
            String path = "/API/COUPANG4/item_list.php";
            String response = null;
            parameters.put("page", String.valueOf(++page));
            parameters.put("m_id", UserId);
            parameters.put("api_key", UserApiKey);
            String postForm = this.ConvertDictionaryToParameter(parameters);
            YDMAStringUtil.Print(postForm);
            response = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").Post(DATA_HOST.concat(path), postForm);
            productDomesin = this.getProductMapping(response);
            if (productDomesin.total_count.equals("0")) break;
            if (productDomesin.code.equals("0000")) {
                resultProdList.put(productDomesin.current_page, productDomesin);
            }
            if (productDomesin.current_page.equals("1")) {
                CommonProgressDialog.get().start("\ub3c4\ub9e4\uc758\uc2e0 \uc0c1\ud488\uc815\ubcf4 \uc218\uc9d1", YDMAStringUtil.convertToInt(productDomesin.total_page), 100, true);
            }
            String message = String.format("Total Page: {%s} \ud604\uc7ac\ud398\uc774\uc9c0 {%s}  \uac00\uc838\uc624\uae30\uc644\ub8cc ", productDomesin.total_page, productDomesin.current_page);
            CommonProgressDialog.get().setValue(String.valueOf(message) + " ID \uc8fc\ubb38 \uc815\ubcf4 \uc218\uc9d1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", YDMAStringUtil.convertToInt(productDomesin.current_page));
        } while (!productDomesin.current_page.equals(productDomesin.total_page));
        return resultProdList;
    }

    public ProductResultDto getProductMapping(String response) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ProductResultDto productDomesin = null;
        productDomesin = (ProductResultDto)mapper.readValue(response, ProductResultDto.class);
        if (productDomesin.items.size() > 0) {
            for (ProductItemDto dto : productDomesin.items) {
                dto.setSearch("shop0283");
            }
        }
        return productDomesin;
    }

    public boolean saveWebCrawling_NaverCate(ProductItemDto dto) throws Exception {
        String name = dto.getIname();
        dto.setStatus("1");
        try {
            this.cookie = IShopCommonLogin.shopSearchCookie();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            Connection.Response rs = Jsoup.connect((String)"https://search.shopping.naver.com/search/all").cookies(this.cookie).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36").header("Host", "search.shopping.naver.com").header("Connection", "keep-alive").header("Accept", "text/html, */*; q=0.01").header("X-Requested-With", "XMLHttpRequest").header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").header("Origin", "http://surffing.net").header("AJAX_REQUEST_HEADER", "AJAX_REQUEST_HEADER").header("Accept-Encoding", "gzip, deflate").header("Accept-Language", "ko-KR,ko;q=0.9,en-US;q=0.8,en;q=0.7").data("query", name).referrer("https://shopping.naver.com/home").method(Connection.Method.GET).ignoreHttpErrors(true).execute();
            Document body = Jsoup.parseBodyFragment((String)rs.body());
            body.select("div.product_depth__I4SqY");
            Elements dataprice = body.select("span.price_num__S2p_v");
            if (rs.body().contains("\uac80\uc0c9 \uacb0\uacfc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.")) {
                YDMAStringUtil.Print("Not Found Web naver Name(\uacb0\uacfc) : " + name);
            } else if (rs.body().contains("\ub85c\uadf8\uc778 \ud6c4 \uc774\uc6a9\ud574\uc8fc\uc138\uc694")) {
                YDMAStringUtil.Print("Need Login Web naver  Name(\uc131\uc778) : " + name);
            } else if (dataprice.size() == 0) {
                YDMAStringUtil.Print("Not Found Web naver  Name(\uacb0\uacfc) : " + name);
            } else {
                String myprice = dto.getPrice();
                int naverprice = Integer.parseInt(((Element)dataprice.get(0)).text().replace("\uc6d0", "").replace(",", ""));
                if ((double)naverprice >= (double)Integer.parseInt(myprice) * 1.25) {
                    dto.setStatus("0");
                }
                YDMAStringUtil.Print("Code: " + dto.getIcode() + " ,Name: " + dto.getIname() + " ,Myprice: " + myprice + " ,Naverprice: " + ((Element)dataprice.get(0)).text().replace("\uc6d0", "").replace(",", ""));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dto.getStatus().equals("0");
    }

    public ProductResultDto getProductUploadMapping(Map<Integer, HashMap<String, String>> sheetContents) throws Exception {
        ProductResultDto productResult = new ProductResultDto();
        ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
        for (Integer key : sheetContents.keySet()) {
            HashMap<String, String> data2;
            String prodcd;
            if (key == 0 || (prodcd = (data2 = sheetContents.get(key)).get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc")).length() == 0) continue;
            ProductItemDto dto = new ProductItemDto();
            ShopOrderMstDto dto1 = new ShopOrderMstDto();
            new ProductDTO();
            dto.setIcode(data2.get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc"));
            dto.setVender_code(data2.get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc"));
            dto.setFolder(data2.get("\ud3f4\ub354\uba85"));
            dto.setCid(data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*"));
            dto.setIname(data2.get("\uc0c1\ud488\uba85*"));
            dto.setPrice(data2.get("\ud310\ub9e4\uac00*"));
            dto.setQty(data2.get("\uc218\ub7c9*"));
            dto.setLimitQty(data2.get("\ucd5c\ub300\uad6c\ub9e4\uc218\ub7c9"));
            dto.setLowLimitQty(data2.get("\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9"));
            dto.setIcountry(data2.get("\uc6d0\uc0b0\uc9c0*"));
            dto.setOrigin(data2.get("G\ub9c8\ucf13,\uc625\uc158 \uc6d0\uc0b0\uc9c0 \uc720\ud615"));
            dto.setMaker(data2.get("\uc218\uc785\uc0ac"));
            String[] imgList = (String[])Arrays.asList(data2.get("\ubaa9\ub85d \uc774\ubbf8\uc9c0*"), data2.get("\uc774\ubbf8\uc9c01(\ub300\ud45c/\uae30\ubcf8\uc774\ubbf8\uc9c0)*"), data2.get("\uc774\ubbf8\uc9c02"), data2.get("\uc774\ubbf8\uc9c03"), data2.get("\uc774\ubbf8\uc9c04"), data2.get("\uc774\ubbf8\uc9c05")).toArray();
            dto.setImg(imgList);
            dto.setContent(data2.get("\uc0c1\uc138\uc124\uba85*"));
            dto.setEsm_auction(data2.get("ESM \ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc124\uba85"));
            dto.setEsm_auction(data2.get("ESM \uad11\uace0\ud64d\ubcf4 \uc0c1\uc138\uc124\uba85"));
            dto.setSelect_option(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc635\uc158\uba85"));
            dto.setSelect_option_name(data2.get("\uc120\ud0dd\uc0ac\ud56d \ud0c0\uc785"));
            dto.setSelect_option_config(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc0c1\uc138\uc815\ubcf4"));
            dto.setSelect_option_use(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc7ac\uace0 \uc0ac\uc6a9\uc5ec\ubd80"));
            dto.setText_option(data2.get("\uc791\uc131\ud615 \uc120\ud0dd\uc0ac\ud56d"));
            dto.setText_option_name(data2.get("\ucd94\uac00\uad6c\uc131 \uc635\uc158\uba85"));
            dto.setText_option_config(data2.get("\ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc815\ubcf4"));
            dto.setBrand(data2.get("\ube0c\ub79c\ub4dc"));
            dto.setModel(data2.get("\ubaa8\ub378\uba85"));
            dto.setMaker(data2.get("\uc81c\uc870\uc0ac"));
            dto.setTax(data2.get("\uacfc\uc138\uc5ec\ubd80"));
            dto.setAdult(data2.get("\ub098\uc774\uc81c\ud55c"));
            dto.setMake_datetime(data2.get("\uc81c\uc870\uc77c\uc790"));
            dto.setUse_datetime(data2.get("\uc720\ud6a8\uc77c\uc790"));
            dto.setHongbo(data2.get("\ud64d\ubcf4\ubb38\uad6c"));
            dto.setItype(data2.get("\uc0c1\ud488\uc0c1\ud0dc"));
            dto.setCost(data2.get("\uc6d0\uac00"));
            dto.setPrice_consumer(data2.get("\uacf5\uae09\uac00"));
            dto.setLimit_price(data2.get("\ub3c4\uc11c\uc815\uac00"));
            dto.setIsbn(data2.get("ISBN"));
            dto.setMoonhwa(data2.get("\ubb38\ud654\ube44 \uc18c\ub4dd\uacf5\uc81c"));
            dto.setKeyword(data2.get("\uac80\uc0c9\uc5b4(\ud0dc\uadf8)"));
            dto.setCert(data2.get("\uc778\uc99d\uc815\ubcf4"));
            dto.setGosi_code(data2.get("\uc694\uc57d\uc815\ubcf4 \uc0c1\ud488\uad70 \ucf54\ub4dc*"));
            dto.setGosi1(data2.get("\uac121"));
            dto.setGosi2(data2.get("\uac122"));
            dto.setGosi3(data2.get("\uac123"));
            dto.setGosi4(data2.get("\uac124"));
            dto.setGosi5(data2.get("\uac125"));
            dto.setGosi6(data2.get("\uac126"));
            dto.setGosi7(data2.get("\uac127"));
            dto.setGosi8(data2.get("\uac128"));
            dto.setGosi9(data2.get("\uac129"));
            dto.setGosi10(data2.get("\uac1210"));
            dto.setGosi11(data2.get("\uac1211"));
            dto.setGosi12(data2.get("\uac1212"));
            dto.setGosi13(data2.get("\uac1213"));
            dto.setGosi14(data2.get("\uac1214"));
            dto.setGosi15(data2.get("\uac1215"));
            dto.setGosi16(data2.get("\uac1216"));
            dto.setGosi17(data2.get("\uac1217"));
            dto.setGosi18(data2.get("\uac1218"));
            dto.setGosi19(data2.get("\uac1219"));
            dto.setGosi20(data2.get("\uac1220"));
            dto.setGosi21(data2.get("\uac1221"));
            dto.setGosi22(data2.get("\uac1222"));
            dto.setGosi23(data2.get("\uac1223"));
            dto.setGosi24(data2.get("\uac1224"));
            dto.setGosi25(data2.get("\uac1225"));
            dto.setGosi26(data2.get("\uac1226"));
            dto.setGosi27(data2.get("\uac1227"));
            dto.setGosi28(data2.get("\uac1228"));
            dto.setGosi29(data2.get("\uac1229"));
            dto.setErr_message(data2.get("\uae30\ubcf8\uc815\ubcf4 \uc624\ub958\uba54\uc2dc\uc9c0"));
            if (dto1.getDelv_cost() == null) {
                dto.setDelivery_amount("0");
            } else {
                dto.setDelivery_amount(data2.get("\ubc30\uc1a1\ube44"));
            }
            dto.setCert_type(data2.get("\uc0c1\ud488 \uc778\uc99d \uc885\ub958"));
            dto.setStatus("0");
            String id = data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*");
            ShopProductDao.get();
            String cate_list = ShopProductDao.getCategoryInfo(id);
            dto.setCategoryInfo(cate_list);
            dto.setCateg_nm(CaffeineCategoryCache.getInstance().getFullCategoryName(data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*")));
            dto.setSearch("shop0283");
            items.add(dto);
        }
        productResult.items = items;
        return productResult;
    }

    public List<ProductItemDto> getExistNotProductList(List<ProductItemDto> items) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ProductItemDto> retItems = new ArrayList<ProductItemDto>();
        try {
            connection = DBCPInit.getInstance().getConnection();
            String sql = "SELECT 1  FROM shopprodinfo where compno = ? and compayny_goods_cd=? ";
            sql = sql.toUpperCase();
            pstmt = connection.prepareStatement(sql);
            for (ProductItemDto list : items) {
                int count = 0;
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, list.getIcode());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                if (count != 0) continue;
                retItems.add(list);
            }
            ArrayList<ProductItemDto> arrayList = retItems;
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            return arrayList;
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
        }
    }

    public int[] sendProductListToMlinkShop(List<ProductItemDto> items) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int[] result = new int[2];
        ArrayList<ProductItemDto> contents_in = new ArrayList<ProductItemDto>();
        ArrayList contents_up = new ArrayList();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT 1  FROM shopprodinfo where compno = ? and compayny_goods_cd=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                for (ProductItemDto list : items) {
                    int count = 0;
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.getIcode());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                    if (count != 0) continue;
                    contents_in.add(list);
                }
                if (contents_in.size() > 0) {
                    result[0] = this.sendProductListToInMlinkShop(contents_in);
                    if (result[0] > 0) {
                        this.sendOptProdListToInMlinkShop(contents_in);
                    }
                }
                contents_up.size();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public void sendOptProdListToInMlinkShop(List<ProductItemDto> contents) throws Exception {
        Connection connection2 = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist2 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection2 = DBCPInit.getInstance().getConnection();
                connection2.setAutoCommit(false);
                String sql2 = " insert into shop_optprodinfo (PRODSEQ,SKUSEQ,COMPNO,PRODCD,OPTPRODCD,OPTPRODNM,OPTSPECDES,OPTEA,OPTSALE, OPTSALEOUT,OPTNOTUSE,OPTSAFESTOCK,OPTVERTSTOCK,OPTADDAMT,OPTDELYN,BARCODE, INSERTDT,INSERTID,MODIFYDT,MODIFYID ) VALUES (?,?,?,?,?,?,?,?,?,  ?,?,?,?,?,?,?,  ?,?,?,?  )";
                sql2 = sql2.toUpperCase();
                pstmt2 = connection2.prepareStatement(sql2);
                statementlist2.add(pstmt2);
                String sql = "SELECT prodseq  FROM shopprodinfo where compno = ? and compayny_goods_cd=? ";
                sql = sql.toUpperCase();
                pstmt = connection2.prepareStatement(sql);
                for (ProductItemDto list : contents) {
                    String optionString = list.getSelect_option();
                    int prodseq = 0;
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.getIcode());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        prodseq = rs.getInt(1);
                    }
                    if (optionString.isEmpty()) continue;
                    String[] lines = optionString.split("\\r\\n|\\r|\\n ");
                    int i = 0;
                    String[] stringArray = lines;
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if (line.indexOf("]") <= 0) {
                            List<String> list_opt = Arrays.asList(line.split("="));
                            int rowIdx2 = 0;
                            pstmt2.setInt(++rowIdx2, prodseq);
                            pstmt2.setInt(++rowIdx2, i);
                            pstmt2.setString(++rowIdx2, YDMASessonUtil.getCompnoInfo().getCompno());
                            pstmt2.setString(++rowIdx2, list.getIcode());
                            pstmt2.setString(++rowIdx2, list_opt.get(1));
                            pstmt2.setString(++rowIdx2, list_opt.get(2));
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.setString(++rowIdx2, "");
                            pstmt2.addBatch();
                            pstmt2.clearParameters();
                            ++i;
                        }
                        ++n2;
                    }
                }
                pstmt2.executeBatch();
                pstmt2.clearParameters();
                connection2.commit();
            }
            catch (Exception ex) {
                connection2.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection2, statementlist2, rs);
        }
    }

    public int sendProductListToInMlinkShop(List<ProductItemDto> contents) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = " insert into shopprodinfo (COMPNO,GOODS_NM,MODEL_NM,BRAND_NM,COMPAYNY_GOODS_CD,GOODS_SEARCH, GOODS_GUBUN,MAKER,ORIGIN,CLASS_CD1,CLASS_CD2,CLASS_CD3,CLASS_CD4, GOODS_SEASON,SEX,STATUS,DELIV_ABLE_REGION,TAX_YN,DELV_TYPE,DELV_COST, GOODS_PRICE,GOODS_CONSUMER_PRICE,CHAR_1_NM,CHAR_2_NM,char_1_val,CHAR_2_VAL,IMG_PATH,IMG_PATH6, IMG_PATH7,GOODS_REMARKS,STOCK_USE_YN,OPT_TYPE,PROP_EDIT_YN,PROP1_CD,PROP_VAL1, PROP_VAL2,PROP_VAL3,PROP_VAL4,PROP_VAL5,PROP_VAL6,PROP_VAL7,PROP_VAL8, PROP_VAL9,PROP_VAL10,PROP_VAL11,PROP_VAL12,PROP_VAL13,PROP_VAL14,PROP_VAL15, PROP_VAL16,PROP_VAL17,PROP_VAL18,PROP_VAL19,PROP_VAL20,PROP_VAL21,PROP_VAL22, PROP_VAL23,PROP_VAL24,PROP_VAL25,PROP_VAL26,PROP_VAL27,PROP_VAL28, INSERTDT,INSERTID ) VALUES (?,?,?,?,?,?, ?,?,?,?,?,?,?, ?,?,?,?,?,?,?, ?,?,?,?,?,?,?,?, ?,?,?,?,?,?,?, ?,?,?,?,?,?,?, ?,?,?,?,?,?,?, ?,?,?,?,?,?,?, ?,?,?,?,?,?, ?,?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductItemDto list : contents) {
                    int rowIdx = 0;
                    pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                    if (list.getIname().getBytes().length > 100) {
                        byte[] strByte = list.getIname().getBytes();
                        new String(strByte, 0, 100);
                        pstmt.setString(++rowIdx, list.getIname());
                    } else {
                        pstmt.setString(++rowIdx, list.getIname());
                    }
                    pstmt.setString(++rowIdx, list.getIcode());
                    pstmt.setString(++rowIdx, list.getBrand());
                    pstmt.setString(++rowIdx, list.getIcode());
                    pstmt.setString(++rowIdx, list.getKeyword());
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, list.getMaker());
                    pstmt.setString(++rowIdx, list.getIcountry());
                    pstmt.setString(++rowIdx, list.getClass_cd1());
                    pstmt.setString(++rowIdx, list.getClass_cd2());
                    pstmt.setString(++rowIdx, list.getClass_cd3());
                    pstmt.setString(++rowIdx, list.getClass_cd4());
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, list.getStatus());
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, list.getTax().equals("0") ? "Y" : "N");
                    pstmt.setString(++rowIdx, "");
                    pstmt.setInt(++rowIdx, 0);
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice_consumer()));
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, "");
                    String char_2_val = "";
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, char_2_val);
                    ArrayList<String> imgs = new ArrayList<String>();
                    int i = 0;
                    while (i < 3) {
                        if (i > list.getImg().length - 1) {
                            imgs.add("");
                        } else {
                            imgs.add(list.getImg()[i]);
                        }
                        ++i;
                    }
                    for (String img : imgs) {
                        pstmt.setString(++rowIdx, img);
                    }
                    YDMAStringUtil.Print("----------------goodsmark ----------------");
                    YDMAStringUtil.Print(list.getContent().length());
                    YDMAStringUtil.Print(list.getContent().replaceAll("\"", "'"));
                    YDMAStringUtil.Print("----------------goodsmark ----------------");
                    String content = list.getContent().replaceAll("\"", "'");
                    content = content.replaceAll("\\\\", "");
                    YDMAStringUtil.Print(content);
                    pstmt.setString(++rowIdx, content);
                    pstmt.setString(++rowIdx, "N");
                    pstmt.setString(++rowIdx, "9");
                    pstmt.setString(++rowIdx, "Y");
                    pstmt.setString(++rowIdx, list.getGosi_code());
                    pstmt.setString(++rowIdx, list.getGosi1());
                    pstmt.setString(++rowIdx, list.getGosi2());
                    pstmt.setString(++rowIdx, list.getGosi3());
                    pstmt.setString(++rowIdx, list.getGosi4());
                    pstmt.setString(++rowIdx, list.getGosi5());
                    pstmt.setString(++rowIdx, list.getGosi6());
                    pstmt.setString(++rowIdx, list.getGosi7());
                    pstmt.setString(++rowIdx, list.getGosi8());
                    pstmt.setString(++rowIdx, list.getGosi9());
                    pstmt.setString(++rowIdx, list.getGosi10());
                    pstmt.setString(++rowIdx, list.getGosi11());
                    pstmt.setString(++rowIdx, list.getGosi12());
                    pstmt.setString(++rowIdx, list.getGosi13());
                    pstmt.setString(++rowIdx, list.getGosi14());
                    pstmt.setString(++rowIdx, list.getGosi15());
                    pstmt.setString(++rowIdx, list.getGosi16());
                    pstmt.setString(++rowIdx, list.getGosi17());
                    pstmt.setString(++rowIdx, list.getGosi18());
                    pstmt.setString(++rowIdx, list.getGosi19());
                    pstmt.setString(++rowIdx, list.getGosi20());
                    pstmt.setString(++rowIdx, list.getGosi21());
                    pstmt.setString(++rowIdx, list.getGosi22());
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                    ++result;
                    YDMAStringUtil.Print("[insert shopprodinfo]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public String ConvertDictionaryToParameter(Map<String, String> parameters) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            list.add(String.valueOf(key) + "=" + value);
        }
        return list.stream().collect(Collectors.joining("&"));
    }

    public boolean Login(String id, String password) throws Exception {
        boolean retVal;
        block25: {
            block26: {
                retVal = false;
                password = "1q2w3e!@";
                id = "hosikan";
                String path = "/API/COUPANG4/login.php";
                String formParams = String.format("id=%s&pw=%s", id, password);
                String response = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").Post(DATA_HOST.concat(path), formParams);
                if (response == null || response.length() <= 0) break block26;
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    LoginResponse userInfo = (LoginResponse)mapper.readValue(response, LoginResponse.class);
                    if (userInfo.code.equals("0000")) {
                        UserId = userInfo.m_id;
                        UserPassword = password;
                        UserApiKey = userInfo.api_key;
                        retVal = true;
                        this.LoadCategory();
                        YDMAStringUtil.Print(userInfo.toString());
                        break block25;
                    }
                    switch (userInfo.code) {
                        case "1001": {
                            FailReason = "\ub85c\uadf8\uc778\ud558\uc2e4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uace0\uac1d\uc13c\ud130\uc5d0 \ubb38\uc758\ud574 \uc8fc\uc2ed\uc2dc\uc624(\ucc28\ub2e8\uc544\uc774\ub514)";
                            break;
                        }
                        case "1002": {
                            FailReason = "\uc2b9\uc778\ub300\uae30\uc911 \uc774\uc2ed\ub2c8\ub2e4. \uc2b9\uc778\ud6c4 \uc774\uc6a9\ud558\uc2e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
                            break;
                        }
                        case "1003": {
                            FailReason = "\uacf5\uae09\uc0ac\ud68c\uc6d0\uc740 \uc774\uc6a9\ud558\uc2e4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc140\ub7ec\ud68c\uc6d0 \uc2e0\uccad\ud6c4 \uc774\uc6a9\ud558\uc2e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
                            break;
                        }
                        case "1004": {
                            FailReason = "\uae30\ud0c0\uc624\ub958(\uc778\uc99d\uacfc\uc815\uc5d0 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uace0\uac1d\uc13c\ud130\ub85c \ubb38\uc758\ud574 \uc8fc\uc138\uc694)";
                            break;
                        }
                        case "1005": {
                            FailReason = "\ud310\ub9e4\ud68c\uc6d0 \uc778\uc99d\ud0a4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \uad00\ub9ac\uc790 \uc2b9\uc778\ud6c4 \uc774\uc6a9\ud558\uc2e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uace0\uac1d\uc13c\ud130\ub85c \uc694\uccad\ud574 \uc8fc\uc138\uc694";
                            break;
                        }
                        case "1006": {
                            FailReason = "\ud68c\uc6d0\uc544\uc774\ub514 \ub610\ub294 \ube44\ubc00\ubc88\ud638\ub97c \ud655\uc778\ud574 \uc8fc\uc138\uc694";
                            break;
                        }
                        default: {
                            FailReason = "\uc815\uc758\ub418\uc5b4 \uc788\uc9c0 \uc54a\ub294 \uc5d0\ub7ec\uc785\ub2c8\ub2e4. \uc5d0\ub7ec\ubc88\ud638: [" + userInfo.code + "], \uace0\uac1d\uc13c\ud130\ub85c \ubb38\uc758\ud574 \uc8fc\uc138\uc694";
                        }
                    }
                    UserApiKey = null;
                    UserId = null;
                    retVal = false;
                }
                catch (Exception e) {
                    retVal = false;
                    FailReason = e.getMessage();
                }
                break block25;
            }
            retVal = false;
            FailReason = "\ub85c\uadf8\uc778 \uc11c\ubc84\ub85c\ubd80\ud130 \uc751\ub2f5\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
        }
        return retVal;
    }

    public Map<String, ProductResultDto> getProductEditQuery(Map<String, String> parameters) throws Exception {
        ProductResultDto productDomesin;
        int page = 0;
        HashMap<String, ProductResultDto> resultProdList = new HashMap<String, ProductResultDto>();
        do {
            String path = "/API/COUPANG/item_change_list.php";
            String response = null;
            parameters.put("page", String.valueOf(++page));
            parameters.put("m_id", UserId);
            parameters.put("api_key", UserApiKey);
            String postForm = this.ConvertDictionaryToParameter(parameters);
            response = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").Post(DATA_HOST.concat(path), postForm);
            productDomesin = this.getProductMapping(response);
            if (productDomesin.code.equals("0000")) {
                resultProdList.put(productDomesin.current_page, productDomesin);
            }
            if (productDomesin.current_page.equals("1")) {
                CommonProgressDialog.get().start("\ub3c4\ub9e4\uc758\uc2e0 \uc0c1\ud488\uc815\ubcf4 \uc218\uc9d1", YDMAStringUtil.convertToInt(productDomesin.total_page), 100, true);
            }
            String message = String.format("Total Page: {%s} \ud604\uc7ac\ud398\uc774\uc9c0 {%s}  \uac00\uc838\uc624\uae30\uc644\ub8cc ", productDomesin.total_page, productDomesin.current_page);
            CommonProgressDialog.get().setValue(String.valueOf(message) + " ID \uc8fc\ubb38 \uc815\ubcf4 \uc218\uc9d1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", YDMAStringUtil.convertToInt(productDomesin.current_page));
        } while (!productDomesin.current_page.equals(productDomesin.total_page));
        return resultProdList;
    }

    private boolean alertPresent(ChromeDriver driver) {
        try {
            driver.switchTo().alert();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void OrderListComplate(List<ShopOrderMstDto> list) throws Exception {
        int page = 0;
        int order = 0;
        Map<String, List<ShopOrderMstDto>> mapList = list.stream().collect(Collectors.groupingBy(ShopOrderMstDto::getReceive_addr));
        ArrayList<OrderDomesin> datas = new ArrayList<OrderDomesin>();
        for (String key : mapList.keySet()) {
            List<ShopOrderMstDto> orderList = mapList.get(key);
            OrderDomesin data2 = new OrderDomesin();
            data2.api_key = DomesinSessonUtil.get().getApiKey();
            data2.m_id = DomesinSessonUtil.get().getUserId();
            data2.req_type = "ez2";
            data2.c_name = orderList.get(0).getReceive_name();
            String phone = orderList.get(0).getReceive_cel().equals("") ? orderList.get(0).getReceive_tel() : orderList.get(0).getReceive_cel();
            String phone2 = orderList.get(0).getReceive_tel().equals("") ? orderList.get(0).getReceive_cel() : orderList.get(0).getReceive_tel();
            data2.c_hp = phone;
            data2.c_tel = phone2;
            data2.c_zip = orderList.get(0).getReceive_zipcode() == null ? "" : orderList.get(0).getReceive_zipcode();
            data2.c_addr = orderList.get(0).getReceive_addr();
            data2.c_addr_detail = orderList.get(0).getReceive_detail() == null ? "." : orderList.get(0).getReceive_detail();
            data2.c_ship_memo = orderList.get(0).getDelv_msg() == null ? "" : orderList.get(0).getDelv_msg();
            data2.c_memo = orderList.get(0).getOrder_id() == null ? "" : orderList.get(0).getOrder_id();
            data2.c_memo2 = "";
            for (ShopOrderMstDto dto : orderList) {
                OrderDomesinItem item = new OrderDomesinItem();
                item.icode = dto.getCompayny_goods_cd();
                if (dto.getP_sku_value2() == null) {
                    dto.setP_sku_value2("");
                }
                if (dto.getP_sku_value2().contains(":")) {
                    item.option1 = dto.getP_sku_value2().split(":")[0];
                    item.option2 = dto.getP_sku_value2().split(":")[1];
                } else {
                    item.option1 = dto.getP_sku_value2().substring(dto.getP_sku_value2().indexOf(":") + 1, dto.getP_sku_value2().length());
                    item.option2 = "";
                }
                item.qty = Long.parseLong(dto.getSale_cnt());
                data2.items.add(item);
            }
            datas.add(data2);
        }
        for (OrderDomesin data3 : datas) {
            String path = "/API/v11/order.php";
            String response = null;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String json = mapper.writeValueAsString((Object)data3);
            response = this.getApiList(LOGIN_HOST.concat(path), json);
            JsonParser jsonparser = new JsonParser();
            JsonObject object = (JsonObject)jsonparser.parse(response);
            List choice = list.stream().filter(d -> d.getReceive_addr().equals(data3.getC_addr()) && d.getReceive_name().equals(data3.getC_name())).collect(Collectors.toList());
            if (object.get("code").getAsString().equals("0000")) {
                object.get("delivery_amount").getAsInt();
                for (ShopOrderMstDto dto : choice) {
                    dto.setDosinOrder_code(object.get("order_code").getAsString());
                    dto.setOrder_status("500");
                    JsonArray cfr_ignored_0 = (JsonArray)object.get("order_list_detail");
                    dto.setDs_order_status("\ub3c4\uc2e0\uc2e0\uaddc");
                    dto.setResult_code("1");
                    ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
                    retList.add(dto);
                    ShopOrderDao.get().SaveOrUpdate(retList);
                    ++order;
                    CommonProgressDialog.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc8fc\ubb38\ubc88\ud638 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getReceive_name(), dto.getDosinOrder_code(), dto.getCompayny_goods_cd(), dto.getSale_cnt(), object.get("message").getAsString()), ++page);
                }
                continue;
            }
            for (ShopOrderMstDto dto : choice) {
                CommonProgressDialog.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getReceive_name(), dto.getCompayny_goods_cd(), dto.getSale_cnt(), object.get("message").getAsString()), page);
                dto.setResult_code("-1");
            }
        }
        CommonProgressDialog.get().setValue("---------------------------------------------------------------------------------------", page);
        CommonProgressDialog.get().setValue(String.format("[\uc804\uccb4\uacb0\uacfc] \uc8fc\ubb38 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4. \uc8fc\ubb38\uac74\uc774 \ub2e4\ub97c \uacbd\uc6b0 \ubb38\uc758\ubc14\ub78d\ub2c8\ub2e4.", order), page);
    }

    public List<ShopOrderMstDto> OrderListComplateCallBack(List<ShopOrderMstDto> list) throws Exception {
        int page = 0;
        int order = 0;
        for (ShopOrderMstDto dto : list) {
            if (!dto.getCompayny_goods_cd().substring(0, 2).equals("TS")) {
                throw new Exception("\ub3c4\ub9e4\uc758\uc2e0 \uc0c1\ud488\uc774 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud488\ucf54\ub4dc\ub97c \ud655\uc778\ud558\uc2ed\uc2dc\uc624. " + dto.getCompayny_goods_cd());
            }
            List<ShopDeliveryDto> datasource = ShopCommonDao.get().getExpress(dto.getShopid());
            String path = "/API/v11/order_status.php";
            OrderDomesinCallback data2 = new OrderDomesinCallback();
            data2.api_key = DomesinSessonUtil.get().getApiKey();
            data2.m_id = DomesinSessonUtil.get().getUserId();
            data2.order_code = dto.getDosinOrder_code();
            String response = null;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String json = mapper.writeValueAsString((Object)data2);
            response = this.getApiList(LOGIN_HOST.concat(path), json);
            JsonParser jsonparser = new JsonParser();
            JsonObject object = (JsonObject)jsonparser.parse(response);
            if (object.get("code").getAsString().equals("0000")) {
                JsonArray jsonarray = new JsonArray();
                jsonarray = (JsonArray)object.get("order_list_detail");
                int i = 0;
                while (i < jsonarray.size()) {
                    JsonObject obj = (JsonObject)jsonarray.get(i);
                    if (obj.get("icode").getAsString().equals(dto.getCompayny_goods_cd())) {
                        String status2 = obj.get("status").getAsString();
                        String claim_status = obj.get("claim_status").getAsString();
                        dto.setDs_order_status(claim_status);
                        String delv = obj.get("del_corp").isJsonNull() ? "" : obj.get("del_corp").getAsString().replaceAll(" ", "");
                        ShopDeliveryDto delvname = null;
                        if (status2.equals("\ubc30\uc1a1\uc900\ube44\uc911")) {
                            dto.setOrder_status("501");
                            if (claim_status.length() == 0) {
                                dto.setDs_order_status("\ub3c4\uc2e0\uc900\ube44");
                            }
                        } else if (status2.equals("\uc2e0\uaddc\uc8fc\ubb38")) {
                            dto.setDs_order_status("\ub3c4\uc2e0\uc2e0\uaddc");
                        }
                        try {
                            if (!delv.equals("")) {
                                delvname = dto.getShopid().equals("shop0003") && delv.equals("\ud3b8\uc758\uc810\ud0dd\ubc30") || dto.getShopid().equals("shop0003") && delv.equals("CU\ud3b8\uc758\uc810\ud0dd\ubc30") ? datasource.stream().filter(d -> d.getDs_code().equals(delv)).findAny().get() : (dto.getShopid().equals("shop0075") && delv.equals("CJ\ub300\ud55c\ud1b5\uc6b4") ? datasource.stream().filter(d -> d.getDs_code().replaceAll(" ", "").contains(delv)).findAny().get() : datasource.stream().filter(d -> d.getDs_code().replace(" ", "").contains(delv)).findAny().get());
                                if (dto.getDomeOrderId().equals(obj.get("order_list_code").getAsString())) {
                                    dto.setDelivery_id(delvname.getDlvID());
                                    dto.setInvoice_no(obj.get("del_no") == null ? "" : obj.get("del_no").getAsString());
                                } else {
                                    dto.setDelivery_id(delvname.getDlvID());
                                    dto.setInvoice_no(obj.get("del_no") == null ? "" : obj.get("del_no").getAsString());
                                }
                                if (claim_status.equals("")) {
                                    dto.setOrder_status("402");
                                    dto.setDs_order_status(status2);
                                }
                            } else {
                                dto.setDelivery_id("");
                                dto.setInvoice_no(obj.get("del_no") == null ? "" : obj.get("del_no").getAsString());
                            }
                        }
                        catch (Exception exception) {
                            throw new Exception("\ud0dd\ubc30\uc0ac \ucf54\ub4dc\uac00 \ub2e4\ub974\uac70\ub098 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.\uad00\ub9ac\uc790\uc5d0\uac8c \ubb38\uc758 \ubc14\ub78d\ub2c8\ub2e4.");
                        }
                        dto.setResult_code("1");
                    }
                    ++i;
                }
                ++order;
                CommonProgressDialog.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc8fc\ubb38\ubc88\ud638 : %s, \ud0dd\ubc30\uc5c5\uccb4 : %s, \uc1a1\uc7a5\ubc88\ud638 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getReceive_name(), dto.getDosinOrder_code(), dto.getDelivery_id(), dto.getInvoice_no(), object.get("message").getAsString()), ++page);
                continue;
            }
            CommonProgressDialog.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getReceive_name(), object.get("message").getAsString()), ++page);
        }
        CommonProgressDialog.get().setValue("---------------------------------------------------------------------------------------", page);
        CommonProgressDialog.get().setValue(String.format("[\uc804\uccb4\uacb0\uacfc] \ub3d9\uae30\ud654 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4. \ub3d9\uae30\ud654\uac74\uc774 \ub2e4\ub97c \uacbd\uc6b0 \ubb38\uc758\ubc14\ub78d\ub2c8\ub2e4.", order), page);
        return list;
    }

    public void OrderListComplate2(List<ShopOrderMstDto> list) throws Exception {
        list = list.stream().filter(d -> d.getDosinstatus() != null && !d.getDosinstatus().equals("\ud488\uc808")).collect(Collectors.toList());
        CommonProgressDialog.get().setValue("\ud488\uc808\uc0c1\ud488 \ubc0f \ub3d9\uc77c\ubc30\uc1a1\uc9c0 \uc81c\uc678 " + list.size() + "\uac74\uc758 \uc8fc\ubb38\uc815\ubcf4 \uc804\uc1a1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4", 0);
        ShoppingMallDetailDto dto1 = ShopCommonDao.get().getShopDtlOneIdWithDome("shop0284");
        ChromeDriver driver = IShopCommonLogin.loginDomesin2(dto1.getShoppingid(), dto1.getPassword(), true);
        Map<String, String> cookies = ChromeScript.get().getCookies(driver);
        new ArrayList();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\03.SabangNet\\template\\DomesinOrder.xls");
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)in);
            FileOutputStream out = new FileOutputStream(new File(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\03.SabangNet\\template\\DomesinOrder1.xls"));
            HSSFSheet sheet = workbook.getSheetAt(0);
            int i = 4;
            for (ShopOrderMstDto dto : list) {
                HSSFRow row = sheet.getRow(i);
                row.getCell(0).setCellValue(dto.getCompayny_goods_cd().replaceAll("\ub3c4\ub9e4\uc758\uc2e0", ""));
                row.getCell(1).setCellValue(dto.getSale_cnt());
                row.getCell(2).setCellValue(dto.getP_sku_value());
                row.getCell(3).setCellValue(dto.getP_sku_value2());
                row.getCell(4).setCellValue(dto.getReceive_name());
                row.getCell(5).setCellValue(dto.getReceive_cel());
                row.getCell(6).setCellValue(dto.getReceive_tel());
                row.getCell(7).setCellValue(dto.getReceive_zipcode());
                row.getCell(8).setCellValue(dto.getReceive_addr());
                row.getCell(9).setCellValue(dto.getDelv_msg());
                row.getCell(10).setCellValue(ShopCommon.getShoppingMallName(dto.getShopid()));
                row.getCell(11).setCellValue(dto.getOrder_id());
                row.getCell(12).setCellValue(String.valueOf(dto.getP_sku_value()) + "/" + dto.getP_sku_value2());
                row.getCell(13).setCellValue("");
                ++i;
            }
            workbook.write((OutputStream)out);
            out.close();
            File excel_file = new File(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\03.SabangNet\\template\\DomesinOrder1.xls");
            FileInputStream file = new FileInputStream(excel_file);
            ((InputStream)file).close();
            ((InputStream)in).close();
            driver.get("https://www.domesin.com/index.html?p=my/order_ex.html");
            driver.findElement(By.xpath((String)"/html/body/table[3]/tbody/tr/td[2]/table[2]/tbody/tr[3]/td[2]/input")).sendKeys(new CharSequence[]{excel_file.getPath()});
            driver.findElement(By.xpath((String)"/html/body/table[3]/tbody/tr/td[2]/table[2]/tbody/tr[3]/td[3]/input")).click();
            String total = driver.findElement(By.xpath((String)"/html/body/table[3]/tbody/tr/td[2]/div[2]/form/table/tbody/tr[2]/td[2]")).getText().replaceAll("\uc6d0", "").replaceAll(",", "");
            String reserves = driver.findElement(By.xpath((String)"/html/body/table[3]/tbody/tr/td[2]/div[2]/form/table/tbody/tr[1]/td[2]")).getText().replaceAll("\uc6d0", "").replaceAll(",", "");
            if (Integer.parseInt(total) > Integer.parseInt(reserves)) {
                CommonProgressDialog.get().setValue("\uc801\ub9bd\uae08\uc774 \ubd80\uc871\ud569\ub2c8\ub2e4.\ucda9\uc804 \ud6c4\uc5d0 \ub2e4\uc2dc \uc804\uc1a1\ubd80\ud0c1\ub4dc\ub9bd\ub2c8\ub2e4.", 0);
                throw new Exception("\uc801\ub9bd\uae08\uc774 \ubd80\uc871\ud569\ub2c8\ub2e4.\ucda9\uc804 \ud6c4\uc5d0 \ub2e4\uc2dc \uc804\uc1a1\ubd80\ud0c1\ub4dc\ub9bd\ub2c8\ub2e4.");
            }
            Thread.sleep(1000L);
            driver.findElement(By.xpath((String)"/html/body/table[3]/tbody/tr/td[2]/div[2]/form/table/tbody/tr[4]/td[2]/input[2]")).click();
            Thread.sleep(1000L);
            driver.findElement(By.xpath((String)"/html/body/table[3]/tbody/tr/td[2]/div[2]/form/div/input")).click();
            if (excel_file.exists()) {
                if (excel_file.delete()) {
                    YDMAStringUtil.Print("\ud30c\uc77c\uc0ad\uc81c \uc131\uacf5");
                } else {
                    YDMAStringUtil.Print("\ud30c\uc77c \uc0ad\uc81c \uc2e4\ud328");
                }
            }
            this.getOrderId(cookies, list);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void getOrderId(Map<String, String> cookies, List<ShopOrderMstDto> list) throws Exception {
        try {
            int page = 0;
            Connection.Response rs = Jsoup.connect((String)("https://www.domesin.com/my/order_list_excel_down.html?start_date=" + list.get(0).getStartDt() + "&end_date=" + list.get(0).getEndDt() + "&q_type=&q=&date=&os2=1")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36").header("Content-Type", "text/html; charset=utf-8").referrer("https://www.domesin.com/index.html?p=my/order_list.html").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            Document doc = Jsoup.parseBodyFragment((String)rs.body());
            Elements rows = doc.select("tbody > tr");
            for (ShopOrderMstDto dto : list) {
                int i = 1;
                while (i < rows.size()) {
                    Element ordinfo = (Element)rows.get(i);
                    String orderno = ((Node)ordinfo.childNodes().get(1)).toString().replaceAll("[^0-9]", "");
                    String orderno2 = ((Node)ordinfo.childNodes().get(3)).toString().replaceAll("<(/)?([a-zA-Z]*)(\\\\s[a-zA-Z]*=[^>]*)?(\\\\s)*(/)?>", "");
                    String name = ((Node)ordinfo.childNodes().get(5)).toString().replaceAll("<(/)?([a-zA-Z]*)(\\\\s[a-zA-Z]*=[^>]*)?(\\\\s)*(/)?>", "");
                    String cellnum = ((Node)ordinfo.childNodes().get(9)).toString().replaceAll("<(/)?([a-zA-Z]*)(\\\\s[a-zA-Z]*=[^>]*)?(\\\\s)*(/)?>", "");
                    String option2 = ((Node)ordinfo.childNodes().get(21)).toString().replaceAll("<(/)?([a-zA-Z]*)(\\\\s[a-zA-Z]*=[^>]*)?(\\\\s)*(/)?>", "");
                    String neword = ((Node)ordinfo.childNodes().get(41)).toString().replaceAll("<(/)?([a-zA-Z]*)(\\\\s[a-zA-Z]*=[^>]*)?(\\\\s)*(/)?>", "");
                    if (neword.equals("\uc2e0\uaddc\uc8fc\ubb38") && name.equals(dto.getReceive_name()) && cellnum.equals(dto.getReceive_cel())) {
                        if (option2.equals("")) {
                            dto.setOrder_etc_2(orderno2);
                        } else if (option2.equals(dto.getP_sku_value2())) {
                            dto.setOrder_etc_2(orderno2);
                        }
                        dto.setDosinOrder_code(orderno);
                        dto.setDs_order_status("\ub3c4\ub9e4\uc2e0\uaddc");
                        dto.setOrder_status("500");
                        dto.setResult_code("1");
                        ArrayList<ShopOrderMstDto> result = new ArrayList<ShopOrderMstDto>();
                        result.add(dto);
                        ShopOrderDao.get().SaveOrUpdate(result);
                        CommonProgressDialog.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc8fc\ubb38\ubc88\ud638 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s \uc8fc\ubb38\uc774 \uc131\uacf5\ud588\uc2b5\ub2c8\ub2e4.", dto.getReceive_name(), dto.getDosinOrder_code(), dto.getCompayny_goods_cd(), dto.getSale_cnt()), ++page);
                    }
                    ++i;
                }
            }
            CommonProgressDialog.get().setValue("---------------------------------------------------------------------------------------", page);
            CommonProgressDialog.get().setValue(String.format("[\uc804\uccb4\uacb0\uacfc] \uc8fc\ubb38 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4. \uc8fc\ubb38\uac74\uc774 \ub2e4\ub97c \uacbd\uc6b0 \ubb38\uc758\ubc14\ub78d\ub2c8\ub2e4.", page), page);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public Boolean domesin2_order_correct(JsonObject obj, ShopOrderMstDto dto) {
        if (obj.get("selfcode").getAsString().equals(dto.getCompayny_goods_cd()) && dto.getP_sku_value().contains(obj.get("opt1_name").getAsString()) && dto.getOrder_etc_14().contains(obj.get("opt2_name").getAsString())) {
            return true;
        }
        return false;
    }

    public List<ShopOrderMstDto> OrderListComplateCallBack2(List<ShopOrderMstDto> list, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        int page = 0;
        try {
            for (ShopOrderMstDto dto : list) {
                if (!dto.getCompayny_goods_cd().substring(0, 2).equals("TS")) {
                    throw new Exception("\ub3c4\ub9e4\uc758\uc2e0 \uc0c1\ud488\uc774 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud488\ucf54\ub4dc\ub97c \ud655\uc778\ud558\uc2ed\uc2dc\uc624. " + dto.getCompayny_goods_cd());
                }
                List<ShopDeliveryDto> datasource = ShopCommonDao.get().getExpress(dto.getShopid());
                Connection.Response response = Jsoup.connect((String)("https://www.domesin.com/my/order_list_excel_down.html?start_date=" + list.get(0).getStartDt() + "&end_date=" + list.get(0).getEndDt() + "&q_type=&q=&date=&os1=1")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36").header("Content-Type", "text/html; charset=utf-8").referrer("https://www.domesin.com/index.html?p=my/order_list.html").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                Document body = Jsoup.parseBodyFragment((String)response.body());
                Elements eles = body.select("tbody > tr");
                int i = 1;
                while (i < eles.size()) {
                    Element datas = (Element)eles.get(i);
                    String ordstatus = ((Node)datas.childNodes().get(41)).toString().replaceAll("<(/)?([a-zA-Z]*)(\\\\s[a-zA-Z]*=[^>]*)?(\\\\s)*(/)?>", "");
                    if (datas.childNodeSize() > 0) {
                        dto.setOrder_status(this.getStatus(ordstatus));
                        dto.setDs_order_status(this.getDsstatus(ordstatus));
                        if (dto.getOrder_status().equals("501")) {
                            dto.setDelivery_id("");
                            dto.setInvoice_no("");
                        } else if (dto.getOrder_status().equals("402") && datas.childNodeSize() > 1) {
                            String delv = ordstatus;
                            ShopDeliveryDto delvname = null;
                            delvname = dto.getShopid().equals("shop0003") && delv.equals("\ud3b8\uc758\uc810\ud0dd\ubc30") || dto.getShopid().equals("shop0003") && delv.equals("CU\ud3b8\uc758\uc810\ud0dd\ubc30") ? datasource.stream().filter(d -> d.getDs_code().equals(delv.trim())).findAny().get() : datasource.stream().filter(d -> d.getDs_code().contains(delv.trim())).findAny().get();
                            dto.setDelivery_id(delvname.getDlvID());
                            String invoiceno = ((Node)datas.childNodes().get(47)).toString().replaceAll("[^0-9]", "");
                            dto.setInvoice_no(invoiceno);
                        }
                        CommonProgressDialog.get().setValue(String.format("\uc8fc\ubb38\ucf54\ub4dc : %s \uc218\ucde8\uc778\uba85 : %s \ub3c4\ub9e4\ubab0\uc0c1\ud0dc :%s ", dto.getDosinOrder_code(), dto.getReceive_name(), ordstatus), ++page);
                        dto.setResult_code("1");
                    }
                    ++i;
                }
                ret.add(dto);
            }
            CommonProgressDialog.get().setValue("---------------------------------------------------------------------------------------", page);
            CommonProgressDialog.get().setValue(String.format("[\uc804\uccb4\uacb0\uacfc] \ub3d9\uae30\ud654 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4. \ub3d9\uae30\ud654\uac74\uc774 \ub2e4\ub97c \uacbd\uc6b0 \ubb38\uc758\ubc14\ub78d\ub2c8\ub2e4.", page), page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private String getDsstatus(String text) {
        String value = "";
        switch (text) {
            case "\ubc1c\uc1a1\uc644\ub8cc": {
                value = "\ub3c4\uc2e02\ubc1c\uc1a1";
                break;
            }
            case "\ucde8\uc18c\uc644\ub8cc": {
                value = "\ub3c4\uc2e02\ucde8\uc18c";
                break;
            }
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                value = "\ub3c4\uc2e02\uc2e0\uaddc";
                break;
            }
            case "\ubc30\uc1a1\uc900\ube44\uc911": {
                value = "\ub3c4\uc2e02\uc900\ube44";
                break;
            }
        }
        return value;
    }

    private String getStatus(String status2) {
        String value = "";
        switch (status2) {
            case "\ubc1c\uc1a1\uc644\ub8cc": {
                value = "402";
                break;
            }
            case "\ucde8\uc18c\uc644\ub8cc": {
                value = "C02";
                break;
            }
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                value = "500";
                break;
            }
            case "\ubc30\uc1a1\uc900\ube44\uc911": {
                value = "501";
                break;
            }
        }
        return value;
    }

    public List<ShopOrderMstDto> ProductList(List<ShopOrderMstDto> list) throws Exception {
        int page = 1;
        for (ShopOrderMstDto dto : list) {
            String path = "/API/v11/order.php";
            YDMAStringUtil.Print();
            OrderDomesinCallbackIcode data2 = new OrderDomesinCallbackIcode();
            data2.api_key = DomesinSessonUtil.get().getApiKey();
            data2.m_id = DomesinSessonUtil.get().getUserId();
            data2.icode = dto.getCompayny_goods_cd();
            String response = null;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String json = mapper.writeValueAsString((Object)data2);
            response = this.getApiList(LOGIN_HOST.concat(path), json);
            JsonParser jsonparser = new JsonParser();
            JsonObject object = (JsonObject)jsonparser.parse(response);
            if (object.get("code").getAsString().equals("0000")) {
                dto.setDosinOrder_code(object.get("order_code").getAsString());
                dto.setOrder_status("500");
                dto.setResult_code("1");
                CommonProgressDialog.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc8fc\ubb38\ubc88\ud638 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getReceive_name(), dto.getDosinOrder_code(), dto.getCompayny_goods_cd(), dto.getSale_cnt(), object.get("message").getAsString()), page);
            } else {
                CommonProgressDialog.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getReceive_name(), dto.getCompayny_goods_cd(), dto.getSale_cnt(), object.get("message").getAsString()), page);
                dto.setResult_code("-1");
            }
            ++page;
        }
        return list;
    }

    private String getApiList(String host, String json) throws Exception {
        String result = null;
        new ArrayList();
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            URIBuilder uriBuilder = new URIBuilder().setPath(host);
            StringEntity params = new StringEntity(json, "UTF-8");
            client = HttpClients.createDefault();
            HttpPost requestPatch = new HttpPost(uriBuilder.build().toString());
            requestPatch.addHeader("content-type", "application/json");
            requestPatch.setEntity((HttpEntity)params);
            response = client.execute((HttpUriRequest)requestPatch);
            int status2 = response.getStatusLine().getStatusCode();
            response.getStatusLine().getReasonPhrase();
            if (status2 == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                result = resObject.toString();
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return result;
    }

    public ShopOrderMstDto InvoiceSearch(List<ShopOrderMstDto> list) {
        new ArrayList();
        ShopOrderMstDto dto = new ShopOrderMstDto();
        CommonProgressDialog.get().start("\uc1a1\uc815\ubc88\ud638\uc870\ud68c\uc911", 100, 10, true);
        CommonProgressDialog.get().setValue("\uc1a1\uc7a5\uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", 100);
        this.driver = ChromeExtention.getInstace().getDriver();
        String URL2 = "https://search.naver.com/search.naver?sm=top_hty&fbm=1&ie=utf8&query=%EC%86%A1%EC%9E%A5%EB%B2%88%ED%98%B8%EC%A1%B0%ED%9A%8C";
        this.driver.get(URL2);
        Map<String, String> cookies = ChromeScript.get().getCookies(this.driver);
        try {
            try {
                Connection.Response rs = Jsoup.connect((String)"https://m.search.naver.com/p/csearch/ocontent/util/headerjson.nhn?_callback=window.__jindo2_callback._306&callapi=parceltracking&t_code=04&t_invoice=111111111111111&passportKey=QlqbAzK6P6uUT%2FL8neG%2Fr%2FyP1sO5S33Gvcf8ZeNoLqY%3D").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").data("_callback", "window.__jindo2_callback._306").data("callapi", "parceltracking").data("t_code", list.get(0).getNaverexpcode()).data("t_invoice", list.get(0).getInvoice_no()).data("passportKey", "QlqbAzK6P6uUT/L8neG/r/yP1sO5S33Gvcf8ZeNoLqY=").referrer(" https://search.naver.com/search.naver?sm=tab_hty.top&where=nexearch&query=%EC%86%A1%EC%9E%A5%EB%B2%88%ED%98%B8%EC%A1%B0%ED%9A%8C&oquery=%EC%86%A1%EC%9E%A5%EB%B2%88%ED%98%B8%EC%A1%B0%ED%9A%8C&tqi=" + cookies.get("page_uid")).method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
                String body = rs.body();
                body = body.substring(body.indexOf("{"), body.lastIndexOf(")"));
                JsonParser jsonparser = new JsonParser();
                JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
                if (jsonobject.get("message") != null) {
                    JsonObject message = (JsonObject)jsonobject.get("message");
                    String error = message.get("error") == null ? "" : message.get("error").getAsString();
                    CommonProgressDialog.get().setValue(String.format("\uace0\uac1d\uba85 : %s, \ud0dd\ubc30\uc5c5\uccb4 : %s, \uc1a1\uc7a5\ubc88\ud638 : %s, \ub0b4\uc6a9 : %s", list.get(0).getReceive_name(), list.get(0).getDelvnm(), list.get(0).getInvoice_no(), error), 100);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.driver.close();
                this.driver.quit();
            }
        }
        finally {
            this.driver.close();
            this.driver.quit();
        }
        return dto;
    }

    public Map<String, ProductResultDto> OrderOneItemSalesNSoldCheck(List<ShopOrderMstDto> list) throws Exception {
        int page = 1;
        HashMap<String, String> parameters = new HashMap<String, String>();
        HashMap<String, ProductResultDto> resultProdList = new HashMap<String, ProductResultDto>();
        parameters.put("m_id", DomesinSessonUtil.get().getUserId());
        parameters.put("api_key", DomesinSessonUtil.get().getApiKey());
        String response = null;
        for (ShopOrderMstDto dto : list) {
            if (!dto.getCompayny_goods_cd().substring(0, 2).equals("TS")) {
                throw new Exception("\ub3c4\ub9e4\uc758\uc2e0 \uc0c1\ud488\uc774 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud488\ucf54\ub4dc\ub97c \ud655\uc778\ud558\uc2ed\uc2dc\uc624. " + dto.getCompayny_goods_cd());
            }
            String path = "/API/COUPANG3/item_info.php";
            parameters.put("icode", dto.getCompayny_goods_cd());
            String postForm = this.ConvertDictionaryToParameter(parameters);
            response = HttpClientEx.get().addParam("Content-Type", "application/x-www-form-urlencoded").Post(DATA_HOST.concat(path), postForm);
            ProductResultDto productDomesin = this.getProductMapping(response);
            if (productDomesin.code.equals("0000")) {
                resultProdList.put(String.valueOf(page), productDomesin);
            }
            ++page;
        }
        return resultProdList;
    }

    public List<ShopOrderMstDto> getProductInfo(List<ShopOrderMstDto> list, ShoppingMallDetailDto shopDto) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        ChromeDriver driver = IShopCommonLogin.loginDomesin(shopDto.getShoppingid(), shopDto.getPassword(), true);
        Map<String, String> cookies = ChromeScript.get().getCookies(driver);
        try {
            for (ShopOrderMstDto dto : list) {
                if (!dto.getCompayny_goods_cd().substring(0, 2).equals("TS")) {
                    throw new Exception("\ub3c4\ub9e4\uc758\uc2e0 \uc0c1\ud488\uc774 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud488\ucf54\ub4dc\ub97c \ud655\uc778\ud558\uc2ed\uc2dc\uc624. " + dto.getCompayny_goods_cd());
                }
                String path = LOGIN_HOST;
                String prdCode = dto.getCompayny_goods_cd().replace("TS1", "");
                String URL2 = String.valueOf(path) + "/shop.html?p=view.html&iid=" + prdCode;
                Document body = Jsoup.connect((String)URL2).cookies(cookies).get();
                if (body.toString().contains("alert('\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \uc0c1\ud488\ucf54\ub4dc \uc785\ub2c8\ub2e4.')")) {
                    dto.setDosinstatus("\ud488\uc808");
                    dto.setOrdimg("");
                    dto.setDsGoods_cost("0");
                    dto.setDsdelv_type("0");
                    dto.setDsdelv_cost("0");
                    dto.setDosinoption("");
                    continue;
                }
                String img = String.valueOf(path) + body.select("#mainimg").attr("src");
                String price2 = body.select("body > table:nth-child(6) > tbody > tr > td > table > tbody > tr > td:nth-child(2) > table > tbody > tr:nth-child(2) > td:nth-child(2) > b").text().replaceAll("[^0-9]", "");
                String deliv_cost = body.select("body > table:nth-child(6) > tbody > tr > td > table > tbody > tr > td:nth-child(2) > table > tbody > tr:nth-child(4) > td > table > tbody > tr:nth-child(1) > td:nth-child(2)").text();
                String[] deliv = deliv_cost.split("\\(");
                deliv_cost = deliv[0].replaceAll("[^0-9]", "");
                if (price2.equals("")) {
                    price2 = "0";
                }
                Elements options = body.select("td[style='color:blue;font-weight:bold;']");
                String option2 = "";
                String sku_value = "";
                if (options.size() != 0) {
                    Elements first_options = body.select("select[name='op1'] > option");
                    String[] optionValue = new String[first_options.size() - 1];
                    String[] optionCost = new String[first_options.size() - 1];
                    int i = 1;
                    while (i < first_options.size()) {
                        if (((Element)first_options.get(i)).text().contains("(")) {
                            String[] optionInfo = ((Element)first_options.get(i)).text().split("\\(");
                            optionValue[i - 1] = optionInfo[0].trim();
                            optionCost[i - 1] = optionInfo[1].replaceAll("[^0-9]", "");
                        } else {
                            optionValue[i - 1] = ((Element)first_options.get(i)).text().trim();
                            optionCost[i - 1] = "0";
                        }
                        ++i;
                    }
                    if (options.size() > 1) {
                        option2 = "[" + ((Element)options.get(0)).text() + "=" + ((Element)options.get(1)).text() + "]\n";
                        option2 = this.second_option_set(option2, optionValue, driver, prdCode, price2);
                    } else {
                        option2 = "[" + ((Element)options.get(0)).text() + "]\n";
                        i = 0;
                        while (i < optionValue.length) {
                            int cost = Integer.parseInt(price2) + Integer.parseInt(optionCost[i]);
                            option2 = String.valueOf(option2) + optionValue[i] + "==" + String.valueOf(cost) + "=0=0=0\n";
                            ++i;
                        }
                    }
                    sku_value = option2;
                } else {
                    sku_value = "\ub2e8\ud488";
                }
                if (!price2.equals("0")) {
                    dto.setDosinstatus("\ud310\ub9e4\uc911");
                } else {
                    dto.setDosinstatus("\ud488\uc808");
                }
                dto.setOrdimg(img);
                dto.setDsGoods_cost(price2);
                dto.setDsdelv_type("0");
                dto.setDsdelv_cost(deliv_cost);
                dto.setDosinoption(option2);
                dto.setSku_value(sku_value);
                ret.add(dto);
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("Error : " + e.getMessage());
        }
        return ret;
    }

    protected String second_option_set(String option2, String[] optionValue, ChromeDriver driver, String prdcode, String price2) {
        try {
            String URL2 = String.format("http://www.domesin.com/shop.html?p=view.html&iid=%s", prdcode);
            WebDriverWait webDriverWait = new WebDriverWait((WebDriver)driver, 10L);
            ChromeScript.get().get(driver, URL2);
            webDriverWait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.name((String)"op1")));
            Select opt1 = new Select(driver.findElement(By.name((String)"op1")));
            int i = 0;
            while (i < optionValue.length) {
                opt1.selectByVisibleText(optionValue[i]);
                webDriverWait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.name((String)"op2")));
                List opt2 = driver.findElementsByCssSelector("select[name='op2'] > option");
                int j = 1;
                while (j < opt2.size()) {
                    String optNm = ((WebElement)opt2.get(j)).getText();
                    int cost = Integer.parseInt(price2) + Integer.parseInt(((WebElement)opt2.get(j)).getAttribute("data-price"));
                    option2 = String.valueOf(option2) + optionValue[i] + ":" + optNm + "==" + String.valueOf(cost) + "=0=0=0\n";
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return option2;
    }

    public ShopOrderMstDto getImagePath(ShopOrderMstDto listDto, String compayny_goods_cd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(IMG_PATH,'') from shopprodinfo where COMPAYNY_GOODS_CD = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, compayny_goods_cd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    listDto.setOrdimg(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return listDto;
    }

    private static final class CategoryDomesin {
        @JsonProperty(value="code")
        public String code;
        @JsonProperty(value="data")
        public CategoryItemDomesin[] data;

        private CategoryDomesin() {
        }
    }

    private static final class CategoryItemDomesin {
        public String cid;
        public String name;
        public String deep;
        public String parent_cid;
        public String ca_qty;
        public String fullcat;
        public String ec;

        private CategoryItemDomesin() {
        }

        public String toString() {
            return "CategoryItemDomesin [cid=" + this.cid + ", name=" + this.name + ", deep=" + this.deep + ", parent_cid=" + this.parent_cid + ", ca_qty=" + this.ca_qty + ", fullcat=" + this.fullcat + ", ec=" + this.ec + "]";
        }
    }

    private static class Domesin2OrderTemp {
        private String orderNo;
        private String name;

        public Domesin2OrderTemp(String orderNo, String name) {
            this.orderNo = orderNo;
            this.name = name;
        }

        public String getOrderNo() {
            return this.orderNo;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "Domesin2OrderTemp [orderNo=" + this.orderNo + ", name=" + this.name + "]";
        }
    }

    private static class LoginResponse {
        @JsonProperty(value="code")
        public String code;
        @JsonProperty(value="m_id")
        public String m_id;
        @JsonProperty(value="api_key")
        public String api_key;
        @JsonProperty(value="notice_url")
        public String notice_url;

        private LoginResponse() {
        }

        public String toString() {
            return "LoginResponse [code=" + this.code + ", m_id=" + this.m_id + ", api_key=" + this.api_key + ", notice_url=" + this.notice_url + "]";
        }
    }

    private static final class OptionDomesin {
        private OptionDomesin() {
        }
    }

    private static class OrderDomesin {
        String api_key;
        String m_id;
        String c_name;
        String c_hp;
        String c_tel;
        String c_zip;
        String c_addr;
        String c_addr_detail;
        String c_ship_memo;
        String c_memo;
        String c_memo2;
        String req_type;
        List<OrderDomesinItem> items = new ArrayList<OrderDomesinItem>();

        private OrderDomesin() {
        }

        public String getApi_key() {
            return this.api_key;
        }

        public void setApi_key(String api_key) {
            this.api_key = api_key;
        }

        public String getM_id() {
            return this.m_id;
        }

        public void setM_id(String m_id) {
            this.m_id = m_id;
        }

        public String getC_name() {
            return this.c_name;
        }

        public void setC_name(String c_name) {
            this.c_name = c_name;
        }

        public String getC_hp() {
            return this.c_hp;
        }

        public void setC_hp(String c_hp) {
            this.c_hp = c_hp;
        }

        public String getC_tel() {
            return this.c_tel;
        }

        public void setC_tel(String c_tel) {
            this.c_tel = c_tel;
        }

        public String getC_zip() {
            return this.c_zip;
        }

        public void setC_zip(String c_zip) {
            this.c_zip = c_zip;
        }

        public String getC_addr() {
            return this.c_addr;
        }

        public void setC_addr(String c_addr) {
            this.c_addr = c_addr;
        }

        public String getC_addr_detail() {
            return this.c_addr_detail;
        }

        public void setC_addr_detail(String c_addr_detail) {
            this.c_addr_detail = c_addr_detail;
        }

        public String getC_ship_memo() {
            return this.c_ship_memo;
        }

        public void setC_ship_memo(String c_ship_memo) {
            this.c_ship_memo = c_ship_memo;
        }

        public String getC_memo() {
            return this.c_memo;
        }

        public void setC_memo(String c_memo) {
            this.c_memo = c_memo;
        }

        public String getC_memo2() {
            return this.c_memo2;
        }

        public void setC_memo2(String c_memo2) {
            this.c_memo2 = c_memo2;
        }

        public List<OrderDomesinItem> getItems() {
            return this.items;
        }

        public void setItems(List<OrderDomesinItem> items) {
            this.items = items;
        }

        public String getReq_type() {
            return this.req_type;
        }

        public void setReq_type(String req_type) {
            this.req_type = req_type;
        }
    }

    private static class OrderDomesinCallback {
        String api_key;
        String m_id;
        String order_code;

        private OrderDomesinCallback() {
        }

        public String getApi_key() {
            return this.api_key;
        }

        public void setApi_key(String api_key) {
            this.api_key = api_key;
        }

        public String getM_id() {
            return this.m_id;
        }

        public void setM_id(String m_id) {
            this.m_id = m_id;
        }

        public String getOrder_code() {
            return this.order_code;
        }

        public void setOrder_code(String order_code) {
            this.order_code = order_code;
        }
    }

    private static class OrderDomesinCallbackIcode {
        String api_key;
        String m_id;
        String icode;

        private OrderDomesinCallbackIcode() {
        }

        public String getApi_key() {
            return this.api_key;
        }

        public void setApi_key(String api_key) {
            this.api_key = api_key;
        }

        public String getM_id() {
            return this.m_id;
        }

        public void setM_id(String m_id) {
            this.m_id = m_id;
        }

        public String getIcode() {
            return this.icode;
        }

        public void setIcode(String icode) {
            this.icode = icode;
        }
    }

    private static class OrderDomesinItem {
        String icode;
        String option1;
        String option2;
        Long qty;

        private OrderDomesinItem() {
        }

        public String getIcode() {
            return this.icode;
        }

        public void setIcode(String icode) {
            this.icode = icode;
        }

        public String getOption1() {
            return this.option1;
        }

        public void setOption1(String option1) {
            this.option1 = option1;
        }

        public String getOption2() {
            return this.option2;
        }

        public void setOption2(String option2) {
            this.option2 = option2;
        }

        public Long getQty() {
            return this.qty;
        }

        public void setQty(Long qty) {
            this.qty = qty;
        }
    }
}

