/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.dao;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.data.dao.ProductIforDto;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductFolderDTO;
import com.kdjsystem.mlink.yellim.shop.common.CommonCodeDto;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCatInfDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCateDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCategoryDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopErrCodeDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinSessonUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class ShopCommonDao {
    private static ShopCommonDao daoInstance = new ShopCommonDao();
    Map<String, ShopProductAdditionDto> MapProductAddition = new HashMap<String, ShopProductAdditionDto>();

    private ShopCommonDao() {
    }

    public static ShopCommonDao get() {
        return daoInstance;
    }

    public String getAttrName(String attrcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String ret = "";
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = String.format(" SELECT attrnm as attrnm from prodattr where attrcd = '%s' limit 1 ", attrcd);
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getSeasonItems]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ret = rs.getString("attrnm");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return ret;
    }

    public List<ShopErrCodeDto> getErrorCode() throws Exception {
        ArrayList<ShopErrCodeDto> contents = new ArrayList<ShopErrCodeDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(code,''), ifnull(content,''), ifnull(treatcontent,''), ifnull(use_yn,'') from shoperrcode ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getErrorCode]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int j = 0;
                    ShopErrCodeDto dto = new ShopErrCodeDto();
                    dto.setCode(rs.getString(++j));
                    dto.setContent(rs.getString(++j));
                    dto.setTreatcontent(rs.getString(++j));
                    dto.setUse_yn(rs.getString(++j));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public boolean isCrawling() {
        boolean result;
        block12: {
            result = false;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT EXISTS(\r\n\tSELECT 1 FROM shopdtl\r\n\tWHERE COMPNO= ?\r\n\tAND  DEALTREAD ='\uc0ac\uc6a9\uc911'\r\n)AS ISCHK";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        boolean bl = result = rs.getInt("ISCHK") > 0;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public int UpdateInvoiceOrder(int ordSeq, int wonCost, int mallWonCost, String deliveryCode, String invoNo) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE shopordmst \r\n");
                sql.append("SET WON_COST=? \r\n");
                sql.append(",MALL_WON_COST=? \r\n");
                sql.append(",ORDER_STATUS =? \r\n");
                sql.append(",DELIVERY_ID=? \r\n");
                sql.append(",INVOICE_NO=? \r\n");
                sql.append("WHERE ORDSEQ=?");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int rowIdx = 0;
                pstmt.setInt(++rowIdx, wonCost);
                pstmt.setInt(++rowIdx, mallWonCost);
                pstmt.setString(++rowIdx, "401");
                pstmt.setString(++rowIdx, deliveryCode);
                pstmt.setString(++rowIdx, invoNo);
                pstmt.setInt(++rowIdx, ordSeq);
                YDMAStringUtil.Print("[INVOIC UPDATE]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int UpdateInvoiceOrder1(int ordSeq, String deliveryCode, String invoNo) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE shopordmst SET \r\n");
                sql.append("ORDER_STATUS =?, \r\n");
                sql.append("DELIVERY_ID=?, \r\n");
                sql.append("INVOICE_NO=? \r\n");
                sql.append("WHERE ORDSEQ=?");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int rowIdx = 0;
                pstmt.setString(++rowIdx, "402");
                pstmt.setString(++rowIdx, deliveryCode);
                pstmt.setString(++rowIdx, invoNo);
                pstmt.setInt(++rowIdx, ordSeq);
                YDMAStringUtil.Print("[INVOIC UPDATE]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShopDeliveryDto> getExpress(String shopcode) throws Exception {
        ArrayList<ShopDeliveryDto> contents = new ArrayList<ShopDeliveryDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SHOPCD,'') as  SHOPCD,ifnull(DLVID,'') as DLVID,ifnull(DLVNM,'') as DLVNM , ifnull(EXPRESS_URL_ID,'') as URL,ifnull(DOSIN_CODE,'') as DOSIN_CODE  from shopdeliverys where shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcode);
                YDMAStringUtil.Print("[getExpress]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopDeliveryDto dto = new ShopDeliveryDto();
                    dto.setShopCd(rs.getString("SHOPCD"));
                    dto.setDlvID(rs.getString("DLVID"));
                    dto.setDivNM(rs.getString("DLVNM"));
                    dto.setUrlcode(rs.getString("URL"));
                    dto.setDs_code(rs.getString("DOSIN_CODE"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopDeliveryDto> getExpressAll() throws Exception {
        ArrayList<ShopDeliveryDto> contents = new ArrayList<ShopDeliveryDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SHOPCD,'') as  SHOPCD,ifnull(DLVID,'') as DLVID ,ifnull(DLVNM,'')  as DLVNM from shopdeliverys order by SHOPCD,DLVID  ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getExpressAll]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopDeliveryDto dto = new ShopDeliveryDto();
                    dto.setShopCd(rs.getString("SHOPCD"));
                    dto.setDlvID(rs.getString("DLVID"));
                    dto.setDivNM(rs.getString("DLVNM"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShoppingMallDetailDto> ShoppingMallDetailList() throws Exception {
        ArrayList<ShoppingMallDetailDto> list = new ArrayList<ShoppingMallDetailDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(m.COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(m.SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(b.SHOPNM,'')  AS SHOPNM, \r\n");
                sql.append("IFNULL(b.SHOPURL,'')  AS SHOPURL, \r\n");
                sql.append("IFNULL(d.SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(D.NICKNM1,D.NICKNM2) AS NICKNM, \r\n");
                sql.append("IFNULL(D.APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(D.DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(d.PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(d.AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(d.AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(d.EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(d.EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(D.NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(D.SHOPSEQ, '') AS SHOPSEQ,      \r\n");
                sql.append("IFNULL(D.SUPPSTDITEM, '') AS SUPPSTDITEM  ,    \r\n");
                sql.append("IFNULL(D.SUPPSTDRATI, '') AS SUPPSTDRATI      \r\n");
                sql.append(" FROM shopmst AS m");
                sql.append(" LEFT JOIN shopdtl AS d");
                sql.append(" ON m.COMPNO = d.COMPNO AND m.SHOPCD = d.SHOPCD join shopinfo b on m.shopcd = b.shopcd ");
                sql.append(" WHERE m.COMPNO =?  AND D.DEALTREAD = '\uc0ac\uc6a9\uc911' \r\n");
                sql.append(" ORDER BY m.SHOPCD, d.SHOPSEQ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setNicknm1(rs.getString("NICKNM"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShopUrl(rs.getString("SHOPURL"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                    dto.setSuppstditem(rs.getString("SUPPSTDITEM"));
                    dto.setSuppstdrati(rs.getString("SUPPSTDRATI"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShoppingMallDetailDto> DomeMallDetailList() throws Exception {
        ArrayList<ShoppingMallDetailDto> list = new ArrayList<ShoppingMallDetailDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(m.COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(m.SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(b.SHOPNM,'')  AS SHOPNM, \r\n");
                sql.append("IFNULL(b.SHOPURL,'')  AS SHOPURL, \r\n");
                sql.append("IFNULL(d.SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(D.NICKNM1,D.NICKNM2) AS NICKNM, \r\n");
                sql.append("IFNULL(D.APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(D.DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(d.PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(d.AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(d.AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(d.EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(d.EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(D.NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(D.SHOPSEQ, '') AS SHOPSEQ,      \r\n");
                sql.append("IFNULL(D.SUPPSTDITEM, '') AS SUPPSTDITEM  ,    \r\n");
                sql.append("IFNULL(D.SUPPSTDRATI, '') AS SUPPSTDRATI      \r\n");
                sql.append(" FROM shopmstdome AS m");
                sql.append(" LEFT JOIN shopdtldome AS d");
                sql.append(" ON m.COMPNO = d.COMPNO AND m.SHOPCD = d.SHOPCD join shopinfodome b on m.shopcd = b.shopcd ");
                sql.append(" WHERE m.COMPNO =?  AND D.DEALTREAD = '\uc0ac\uc6a9\uc911' \r\n");
                sql.append(" ORDER BY m.SHOPCD, d.SHOPSEQ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setNicknm1(rs.getString("NICKNM"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShopUrl(rs.getString("SHOPURL"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                    dto.setSuppstditem(rs.getString("SUPPSTDITEM"));
                    dto.setSuppstdrati(rs.getString("SUPPSTDRATI"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void setShopCategoryInsertNUpdate(List<ShopCateDto> list) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into categlarge (SHOPCD,CODE,NAME, PARENT_CODE, LEVEL, SORT_IDX,COMMENT,USE_YN )  \r\n values (?, ?, ?, ?, ?, ? , ?, ?) ON  DUPLICATE KEY  UPDATE NAME = ? , PARENT_CODE = ? , LEVEL = ? , SORT_IDX = ? , COMMENT = ?, USE_YN = ?  ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopCateDto dto : list) {
                    int idx = 0;
                    pstmt.setString(++idx, dto.getShopcd());
                    pstmt.setString(++idx, dto.getCode());
                    pstmt.setString(++idx, dto.getName());
                    pstmt.setString(++idx, dto.getParent_code());
                    pstmt.setInt(++idx, dto.getLevel());
                    pstmt.setInt(++idx, dto.getSort_idx());
                    pstmt.setString(++idx, dto.getComment());
                    pstmt.setString(++idx, dto.getUse_yn());
                    pstmt.setString(++idx, dto.getName());
                    pstmt.setString(++idx, dto.getParent_code());
                    pstmt.setInt(++idx, dto.getLevel());
                    pstmt.setInt(++idx, dto.getSort_idx());
                    pstmt.setString(++idx, dto.getComment());
                    pstmt.setString(++idx, dto.getUse_yn());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setShopProdInfoUpdate(List<ProductDTO> list) {
    }

    public boolean isCompno() {
        boolean result;
        block12: {
            result = false;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT count(*) as cnt from systemconf WHERE COMPNO= ? ";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        boolean bl = result = rs.getInt("cnt") > 0;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public int systemConfInsert(PreferencesMallDTO dto) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into systemconf(COMPNO, SUGGPROCNT, ORDPERIOD, ORDSTATUS, ORDIMPTPER, PRODMNG, PRODLINK, PRODFAIL, EXCEPKEYWDYN, EXCEPKEYWD, PRODNM_LENMNGYN, STSCPERIOD, ENDDATE, DELIVERYNM, PRODSEARCHYN ,PRODSEARCHYN2 ,PRODDUP1,PRODDUP2,DELIVERYCOST,PRODCPYYN,autostat,URL_PRODRECV, SECONDAUTH11STYN, DISPLAYHOME, PRODCPY_LOC)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(++rowIdx, dto.getSUGGPROCNT());
                pstmt.setInt(++rowIdx, dto.getORDPERIOD());
                pstmt.setString(++rowIdx, dto.getORDSTATUS());
                pstmt.setInt(++rowIdx, dto.getORDIMPTPER());
                pstmt.setInt(++rowIdx, dto.getPRODMNG());
                pstmt.setInt(++rowIdx, dto.getPRODLINK());
                pstmt.setInt(++rowIdx, dto.getPRODFAIL());
                pstmt.setString(++rowIdx, dto.getEXCEPKEYWDYN());
                pstmt.setString(++rowIdx, dto.getEXCEPKEYWD() == null ? "" : dto.getEXCEPKEYWD());
                pstmt.setString(++rowIdx, dto.getPRODNM_LENMNGYN());
                pstmt.setInt(++rowIdx, dto.getSTSCPERIOD());
                pstmt.setInt(++rowIdx, dto.getENDDATE());
                pstmt.setString(++rowIdx, dto.getDELIVERYNM());
                pstmt.setString(++rowIdx, dto.getPRODSEARCHYN());
                pstmt.setString(++rowIdx, dto.getPRODSEARCHYN2());
                pstmt.setString(++rowIdx, dto.getPRODDUP1());
                pstmt.setString(++rowIdx, dto.getPRODDUP2());
                pstmt.setInt(++rowIdx, dto.getDELIVERYCOST());
                pstmt.setString(++rowIdx, dto.getPRODCPYYN());
                pstmt.setInt(++rowIdx, dto.getAUTOSTAT());
                pstmt.setString(++rowIdx, dto.getURL_PRODRECV());
                pstmt.setString(++rowIdx, dto.getSecondAuth11styn());
                pstmt.setString(++rowIdx, dto.getDisplayHome());
                pstmt.setString(++rowIdx, dto.getPRODCPY_LOC());
                YDMAStringUtil.Print("[systemConfInsert]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int systemConfUpdate(PreferencesMallDTO dto) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " update systemconf     set SUGGPROCNT = ?, ORDPERIOD = ?, ORDSTATUS = ?, ORDIMPTPER = ?, PRODMNG = ?, \t\t   EXCEPKEYWDYN = ?, EXCEPKEYWD = ?, PRODNM_LENMNGYN = ?,  \t   STSCPERIOD = ? ,ENDDATE=?,DELIVERYNM=?,PRODSEARCHYN=?, PRODSEARCHYN2=?,        PRODDUP1 = ? , PRODDUP2 = ? , DELIVERYCOST = ?, PRODCPYYN = ?, autostat = ? , URL_PRODRECV = ?, \t\t   SECONDAUTH11STYN = ?, DISPLAYHOME = ?, PRODCPY_LOC = ?  where compno = ? ";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                int rowIdx = 0;
                pstmt.setInt(++rowIdx, dto.getSUGGPROCNT());
                pstmt.setInt(++rowIdx, dto.getORDPERIOD());
                pstmt.setString(++rowIdx, dto.getORDSTATUS());
                pstmt.setInt(++rowIdx, dto.getORDIMPTPER());
                pstmt.setInt(++rowIdx, dto.getPRODMNG());
                pstmt.setString(++rowIdx, dto.getEXCEPKEYWDYN());
                pstmt.setString(++rowIdx, dto.getEXCEPKEYWD() == null ? "" : dto.getEXCEPKEYWD());
                pstmt.setString(++rowIdx, dto.getPRODNM_LENMNGYN());
                pstmt.setInt(++rowIdx, dto.getSTSCPERIOD());
                pstmt.setInt(++rowIdx, dto.getENDDATE());
                pstmt.setString(++rowIdx, dto.getDELIVERYNM());
                pstmt.setString(++rowIdx, dto.getPRODSEARCHYN());
                pstmt.setString(++rowIdx, dto.getPRODSEARCHYN2());
                pstmt.setString(++rowIdx, dto.getPRODDUP1());
                pstmt.setString(++rowIdx, dto.getPRODDUP2());
                pstmt.setInt(++rowIdx, dto.getDELIVERYCOST());
                pstmt.setString(++rowIdx, dto.getPRODCPYYN());
                pstmt.setInt(++rowIdx, dto.getAUTOSTAT());
                pstmt.setString(++rowIdx, dto.getURL_PRODRECV());
                pstmt.setString(++rowIdx, dto.getSecondAuth11styn());
                pstmt.setString(++rowIdx, dto.getDisplayHome());
                pstmt.setString(++rowIdx, dto.getPRODCPY_LOC());
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[systemConfUpdate]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public PreferencesMallDTO getSystemConf() throws Exception {
        PreferencesMallDTO dto = new PreferencesMallDTO();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(COMPNO,''), ifnull(SUGGPROCNT,''), ifnull(ORDPERIOD,''), ifnull(ORDSTATUS,''), ifnull(ORDIMPTPER,''), ifnull(PRODMNG,''), ifnull(PRODLINK,''), ifnull(PRODFAIL,''), ifnull(EXCEPKEYWDYN,''), ifnull(EXCEPKEYWD,''), ifnull(PRODNM_LENMNGYN,''), ifnull(STSCPERIOD,''),ifnull(ENDDATE,''),ifnull(DELIVERYNM,''),ifnull(PRODSEARCHYN,'N'),ifnull(PRODSEARCHYN2,'N'),ifnull(PROCCNT,1),ifnull(PRODDUP1,''),ifnull(PRODDUP2,''),ifnull(DELIVERYCOST,'0'), ifnull(PRODCPYYN,'N'), ifnull(AUTOSTAT,0),ifnull(URL_PRODRECV,''), ifnull(SECONDAUTH11STYN,'N'), ifnull(DISPLAYHOME,'N'), ifnull(PRODCPY_LOC,''), ifnull(SAVEPRODUCTLOGYN,'N'), ifnull(SLACKYN,'N'), ifnull(SLACKKEY,''), ifnull(SLACKURL,''), ifnull(SLACKID,''), ifnull(Y_STARTMENU,''),ifnull(SELFCHANGEYN,''), ifnull(SELFMOD_NO,'')from systemconf where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getSystemConf]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int j = 0;
                    dto.setCOMPNO(rs.getInt(++j));
                    dto.setSUGGPROCNT(rs.getInt(++j));
                    dto.setORDPERIOD(rs.getInt(++j));
                    dto.setORDSTATUS(rs.getString(++j));
                    dto.setORDIMPTPER(rs.getInt(++j));
                    dto.setPRODMNG(rs.getInt(++j));
                    dto.setPRODLINK(rs.getInt(++j));
                    dto.setPRODFAIL(rs.getInt(++j));
                    dto.setEXCEPKEYWDYN(rs.getString(++j));
                    dto.setEXCEPKEYWD(rs.getString(++j));
                    dto.setPRODNM_LENMNGYN(rs.getString(++j));
                    dto.setSTSCPERIOD(rs.getInt(++j));
                    dto.setENDDATE(rs.getInt(++j));
                    dto.setDELIVERYNM(rs.getString(++j));
                    dto.setPRODSEARCHYN(rs.getString(++j));
                    dto.setPRODSEARCHYN2(rs.getString(++j));
                    dto.setPROCCNT(rs.getInt(++j));
                    dto.setPRODDUP1(rs.getString(++j));
                    dto.setPRODDUP2(rs.getString(++j));
                    dto.setDELIVERYCOST(rs.getInt(++j));
                    dto.setPRODCPYYN(rs.getString(++j));
                    dto.setAUTOSTAT(rs.getInt(++j));
                    dto.setURL_PRODRECV(rs.getString(++j));
                    dto.setSecondAuth11styn(rs.getString(++j));
                    dto.setDisplayHome(rs.getString(++j));
                    dto.setPRODCPY_LOC(rs.getString(++j));
                    dto.setSaveproductlogyn(rs.getString(++j));
                    dto.setSlackyn(rs.getString(++j));
                    dto.setSlackkey(rs.getString(++j));
                    dto.setSlackurl(rs.getString(++j));
                    dto.setSlackid(rs.getString(++j));
                    dto.setY_STARTMENU(rs.getString(++j));
                    dto.setSelfchangeyn(rs.getString(++j));
                    dto.setSelfmod_no(rs.getString(++j));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public boolean isJobScheduler() {
        boolean result;
        block12: {
            result = false;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT EXISTS(\r\n\tSELECT 1 FROM scheduinfo\r\n\tWHERE COMPNO= ?\r\n\tAND  JOBSTAT ='Y'\r\n)AS ISCHK";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        boolean bl = result = rs.getInt("ISCHK") > 0;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public ShopOrderMstDto ShoppingMallDetailOneChoice(ShopOrderMstDto dtoItem) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SUPPSTDITEM,'') AS SUPPSTDITEM, ifnull(SUPPSTDRATI,'0') AS SUPPSTDRATI from shopdtl where compno = ? and shopcd = ? and shoppingid = ? ";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dtoItem.getShopid());
                pstmt.setString(3, dtoItem.getShop_userid());
                YDMAStringUtil.Print("[ShoppingMallDetailOneChoice]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dtoItem.setSuppstditem(rs.getString("SUPPSTDITEM"));
                    dtoItem.setSuppstdrati(rs.getString("SUPPSTDRATI"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dtoItem;
    }

    public String getDeliveryName(String shopid, String delivery_id) throws Exception {
        String delvnm = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select dlvnm from shopdeliverys where shopcd = ? and dlvid = ? ";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                pstmt.setString(1, shopid);
                pstmt.setString(2, delivery_id);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    delvnm = rs.getString(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return delvnm;
    }

    public List<CommonCodeDto> getCommonCode() throws Exception {
        ArrayList<CommonCodeDto> contents = new ArrayList<CommonCodeDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT \r\nB.code_mng AS mngcode ,\r\nA.name     AS mngname ,\r\nB.code     AS code    ,\r\nB.name     AS NAME   , \r\nb.use_yn  AS use_yn      \r\nFROM com_code_master AS A\r\nINNER JOIN com_code_detail AS B \r\nON A.code = B.code_mng  \tWHERE B.USE_YN ='Y' ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[CommonCodeDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    CommonCodeDto dto = new CommonCodeDto();
                    dto.setMngCode(rs.getString("MNGCODE"));
                    dto.setMngName(rs.getString("MNGNAME"));
                    dto.setCode(rs.getString("CODE"));
                    dto.setName(rs.getString("NAME"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ProductIforDto> getAttrCode() throws Exception {
        ArrayList<ProductIforDto> contents = new ArrayList<ProductIforDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(attrcd,'') AS ATTRCD , ifnull(attrnm,'') AS ATTRNM from prodattr";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getAttrCode]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductIforDto dto = new ProductIforDto();
                    dto.setAttrcd(rs.getString("ATTRCD"));
                    dto.setAttrnm(rs.getString("ATTRNM"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ProductDTO> getProductInCountNotCond(String dome, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        ArrayList<ProductDTO> contents = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT SHOPCD,SHOPID,SHOPSEQ,COUNTS  FROM SUM_PRODINCOUNTS WHERE compno = ? ";
                if (!dome.equals("")) {
                    sql = String.valueOf(sql) + "  AND GOODS_KEYWORD = ? \r\n";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                }
                YDMAStringUtil.Print("[getProductInCountNotCond]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setSHOP_USERID(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setCOUNTS(rs.getInt("COUNTS"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ProductDTO> getProductInCount(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        ArrayList<ProductDTO> contents = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT distinct SHOPCD AS SHOPCD, SHOP_USERID AS SHOPID,   \t SHOPSEQ AS SHOPSEQ, count(*) AS COUNTS      from shopprodin USE INDEX (SHOPSENDSTATUS)   WHERE compno = ?      AND SHOPSENDSTATUS <> 9000 ";
                if (!dome.equals("")) {
                    sql = String.valueOf(sql) + "  AND GOODS_KEYWORD = ? \r\n";
                }
                sql = folder.equals("") ? String.valueOf(sql) + String.format(" AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%") : String.valueOf(sql) + String.format(" AND COMPAYNY_GOODS_CD IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder);
                if (!categ.equals("")) {
                    sql = String.valueOf(sql) + String.format(" AND CLASS_CD3 like '%s", categ) + "%'";
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql = String.valueOf(sql) + " AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n";
                    sql = String.valueOf(sql) + " OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n";
                }
                if (!searchtxt.equals("")) {
                    sql = searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION") || searchgubun.equals("DELV_COST") || searchgubun.equals("RETURN_DELV_COST") ? String.valueOf(sql) + YDMAStringUtil.buildNumericCondition(searchgubun, searchtxt) : (searchgubun.equals("GOODS_SEARCH_CNT") ? String.valueOf(sql) + " AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n" : String.valueOf(sql) + YDMAStringUtil.buildLikeClause(searchgubun, searchtxt));
                }
                sql = String.valueOf(sql) + "  group by 1,2,3";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(3, prodFrom);
                        pstmt.setString(4, prodTo);
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                    }
                } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                }
                YDMAStringUtil.Print("[getProductInCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setSHOP_USERID(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setCOUNTS(rs.getInt("COUNTS"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopCateDto.CategoryMapLevelList> getProductInCountWithCateg(String dome, String shopCd, String shopSeq, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        ArrayList<ShopCateDto.CategoryMapLevelList> contents = new ArrayList<ShopCateDto.CategoryMapLevelList>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT a.ID, a.NAME, a.PARENT_CODE, a.LEVEL, ifnull(b.COUNTS,0) as COUNTS \r\n  FROM category AS a \r\n  LEFT JOIN ( \r\n";
                sql = String.valueOf(sql) + "SELECT distinct CLASS_CD3 AS ID, count(*) AS COUNTS \r\n" + "    from shopprodin USE INDEX (SHOPSENDSTATUS) \r\n" + "   WHERE compno = ? \r\n" + "     AND SHOPSENDSTATUS <> 9000 \r\n";
                if (!dome.equals("")) {
                    sql = String.valueOf(sql) + "  AND GOODS_KEYWORD = ? \r\n";
                }
                if (!shopCd.equals("")) {
                    sql = String.valueOf(sql) + String.format(" AND SHOPCD = '%s' \r\n", shopCd);
                }
                if (!shopSeq.equals("")) {
                    sql = String.valueOf(sql) + String.format(" AND SHOPSEQ = %s \r\n", shopSeq);
                }
                sql = folder.equals("") ? String.valueOf(sql) + String.format(" AND NOT EXISTS (SELECT 1 FROM shopprodfolders AS F WHERE COMPNO=%s AND shopprodin.COMPAYNY_GOODS_CD=F.COMPAYNY_GOODS_CD AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%") : String.valueOf(sql) + String.format(" AND EXISTS (SELECT 1 FROM shopprodfolders AS F WHERE COMPNO=%s AND shopprodin.COMPAYNY_GOODS_CD=F.COMPAYNY_GOODS_CD AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder);
                if (!categ.equals("")) {
                    sql = String.valueOf(sql) + String.format(" AND CLASS_CD3 like '%s", categ) + "%' \r\n";
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql = String.valueOf(sql) + " AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n";
                    sql = String.valueOf(sql) + " OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n";
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION") || searchgubun.equals("DELV_COST") || searchgubun.equals("RETURN_DELV_COST")) {
                        sql = String.valueOf(sql) + YDMAStringUtil.buildNumericCondition(searchgubun, searchtxt);
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql = String.valueOf(sql) + " AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n";
                    } else if (!searchgubun.equals("EXISTS_SHOPPING")) {
                        sql = String.valueOf(sql) + YDMAStringUtil.buildLikeClause(searchgubun, searchtxt);
                    }
                }
                sql = String.valueOf(sql) + "  group by 1) AS b ON a.ID = b.ID ";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(3, prodFrom);
                        pstmt.setString(4, prodTo);
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                    }
                } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                }
                YDMAStringUtil.Print("[getProductInCountWithCateg]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto.CategoryMapLevelList dto = new ShopCateDto.CategoryMapLevelList();
                    dto.setId(rs.getString("ID"));
                    dto.setName(rs.getString("NAME"));
                    dto.setPid(rs.getString("PARENT_CODE"));
                    dto.setLevel(rs.getString("LEVEL"));
                    dto.setCount(rs.getInt("COUNTS"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopCateDto.CategoryMapLevelList> getProductInfoCountWithCateg(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        ArrayList<ShopCateDto.CategoryMapLevelList> contents = new ArrayList<ShopCateDto.CategoryMapLevelList>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT a.ID, a.NAME, a.PARENT_CODE, a.LEVEL, ifnull(b.COUNTS,0) as COUNTS \r\n  FROM category AS a \r\n  LEFT JOIN ( \r\n";
                sql = String.valueOf(sql) + "SELECT distinct CLASS_CD3 AS ID, count(*) AS COUNTS \r\n" + "    from shopprodinfo \r\n" + "   WHERE compno = ? \r\n";
                if (!dome.equals("")) {
                    sql = String.valueOf(sql) + "  AND GOODS_KEYWORD = ? \r\n";
                }
                sql = folder.equals("") ? String.valueOf(sql) + String.format(" AND NOT EXISTS (SELECT 1 FROM shopprodfolders AS F WHERE COMPNO=%s AND shopprodinfo.COMPAYNY_GOODS_CD=F.COMPAYNY_GOODS_CD AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%") : String.valueOf(sql) + String.format(" AND EXISTS (SELECT 1 FROM shopprodfolders AS F WHERE COMPNO=%s AND shopprodinfo.COMPAYNY_GOODS_CD=F.COMPAYNY_GOODS_CD AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder);
                if (!categ.equals("")) {
                    sql = String.valueOf(sql) + String.format(" AND CLASS_CD3 like '%s", categ) + "%' \r\n";
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql = String.valueOf(sql) + " AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n";
                    sql = String.valueOf(sql) + " OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n";
                }
                if (!searchtxt.equals("")) {
                    sql = searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION") || searchgubun.equals("DELV_COST") || searchgubun.equals("RETURN_DELV_COST") ? String.valueOf(sql) + YDMAStringUtil.buildNumericCondition(searchgubun, searchtxt) : (searchgubun.equals("GOODS_SEARCH_CNT") ? String.valueOf(sql) + " AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n" : String.valueOf(sql) + YDMAStringUtil.buildLikeClause(searchgubun, searchtxt));
                }
                sql = String.valueOf(sql) + "  group by 1) AS b ON a.ID = b.ID ";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(3, prodFrom);
                        pstmt.setString(4, prodTo);
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                    }
                } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                }
                YDMAStringUtil.Print("[getProductInfoCountWithCateg]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto.CategoryMapLevelList dto = new ShopCateDto.CategoryMapLevelList();
                    dto.setId(rs.getString("ID"));
                    dto.setName(rs.getString("NAME"));
                    dto.setPid(rs.getString("PARENT_CODE"));
                    dto.setLevel(rs.getString("LEVEL"));
                    dto.setCount(rs.getInt("COUNTS"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ProductDTO> getProductInCountSum(String dome) throws Exception {
        ArrayList<ProductDTO> contents = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT distinct SHOPCD,SHOPID,SHOPSEQ,sum(COUNTS) AS COUNTS    from sum_prodincounts WHERE compno = ?    AND SHOPSENDSTATUS <> 9000 ";
                if (!dome.equals("")) {
                    sql = String.valueOf(sql) + "  AND GOODS_KEYWORD = ? \r\n";
                }
                sql = String.valueOf(sql) + "   group by 1,2,3";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                }
                YDMAStringUtil.Print("[getProductInCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setSHOP_USERID(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setCOUNTS(rs.getInt("COUNTS"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public ShopCatInfDto getShopCateInfName(String catsitenm, String shopcd) throws Exception {
        ShopCatInfDto dto = new ShopCatInfDto();
        List<String> find_class_nm = Arrays.asList(catsitenm.replace(" ", "").split(">"));
        List<Object> get_class_cd = new ArrayList();
        new ArrayList();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SHOPLAGCATCD,'') AS SHOPLAGCATCD, \t\t  ifnull(SHOPMIDCATCD,'') AS SHOPMIDCATCD, \t\t  ifnull(SHOPSMLCATCD,'') AS SHOPSMLCATCD,\t\t  ifnull(SHOPDETCATCD,'') AS SHOPDETCATCD, \t\t  ifnull(SHOPCATSITENM,'') AS SHOPCATSITENM   from shopcatinf  WHERE compno = ?    and shopcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[ProductIforDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    List<String> ret = Arrays.asList(rs.getString("SHOPLAGCATCD"), rs.getString("SHOPMIDCATCD"), rs.getString("SHOPSMLCATCD"), rs.getString("SHOPDETCATCD"));
                    if (catsitenm.replace(" ", "").equals(rs.getString("SHOPCATSITENM").replace(" ", ""))) {
                        get_class_cd = ret;
                        break;
                    }
                    ArrayList<String> part_class_cd = new ArrayList<String>();
                    List<String> target_class_nm = Arrays.asList(rs.getString("SHOPCATSITENM").replace(" ", "").split(">"));
                    int match = 0;
                    if (target_class_nm.size() < find_class_nm.size()) continue;
                    int i = 0;
                    while (i < find_class_nm.size()) {
                        if (!find_class_nm.get(i).equals(target_class_nm.get(i))) break;
                        ++match;
                        part_class_cd.add(ret.get(i));
                        ++i;
                    }
                    if (match <= get_class_cd.size()) continue;
                    get_class_cd = part_class_cd;
                }
                int i = 0;
                while (i < get_class_cd.size()) {
                    if (i == 0) {
                        dto.setShoplagcatcd((String)get_class_cd.get(0));
                    }
                    if (i == 1) {
                        dto.setShopmidcatcd((String)get_class_cd.get(1));
                    }
                    if (i == 2) {
                        dto.setShopsmlcatcd((String)get_class_cd.get(2));
                    }
                    if (i == 3) {
                        dto.setShopdetcatcd((String)get_class_cd.get(3));
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopCatInfDto getShopCateInf(String catno, String shopcd) throws Exception {
        ShopCatInfDto dto = new ShopCatInfDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SHOPLAGCATCD,'') AS SHOPLAGCATCD, \t\t  ifnull(SHOPMIDCATCD,'') AS SHOPMIDCATCD, \t\t  ifnull(SHOPSMLCATCD,'') AS SHOPSMLCATCD,\t\t  ifnull(SHOPDETCATCD,'') AS SHOPDETCATCD, \t\t  ifnull(SHOPCATSITENM,'') AS SHOPCATSITENM   from shopcatinf  WHERE compno = ?    and shopcatno = ?    and shopcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, catno);
                pstmt.setString(3, shopcd);
                YDMAStringUtil.Print("[ProductIforDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setShoplagcatcd(rs.getString("SHOPLAGCATCD"));
                    dto.setShopmidcatcd(rs.getString("SHOPMIDCATCD"));
                    dto.setShopsmlcatcd(rs.getString("SHOPSMLCATCD"));
                    dto.setShopdetcatcd(rs.getString("SHOPDETCATCD"));
                    dto.setShopcatsitenm(rs.getString("SHOPCATSITENM"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ShoppingMallDetailDto> getShoppingMallDetail(String shopcd, String shopseq) throws Exception {
        ArrayList<ShoppingMallDetailDto> list = new ArrayList<ShoppingMallDetailDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("(SELECT shopnm FROM shopinfo AS b WHERE shopdtl.shopcd=b.shopcd) AS shopnam, \r\n");
                sql.append("IFNULL(SHOPSEQ, '') AS SHOPSEQ      \r\n");
                sql.append(" FROM shopdtl ");
                sql.append(" WHERE COMPNO =?  AND SHOPCD= ? AND SHOPSEQ = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, shopseq);
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopnm(rs.getString("SHOPNAM"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int setProductStatusIn(ProductDTO dto, int status2) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodin set SHOPSENDSTATUS = ?  where compno = ?    and SENDSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setInt(++i, status2);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getSENDSEQ());
                result = pstmt.executeUpdate();
                YDMAStringUtil.Print("[setShopOrderMstChange]" + pstmt.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setProductStatusInfo(ProductDTO dto, int status2) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodinfo set SHOPSENDSTATUS = ?  where compno = ?    and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setInt(++i, status2);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getPRODSEQ());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getOrderExcel1(ProductDTO dto) throws Exception {
        String domain = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ORDEREXCEL1 AS ORDEREXCEL1 FROM shopdtl where COMPNO = ? and SHOPCD = ? and SHOPSEQ = ? ";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dto.getShopcd());
                pstmt.setString(3, dto.getShopseq());
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    domain = rs.getString("ORDEREXCEL1");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return domain;
    }

    public ShoppingMallDetailDto getShopDtlOneId(String shopcd) throws Exception {
        ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(SHOPSEQ, '') AS SHOPSEQ      \r\n");
                sql.append(" FROM shopdtl  ");
                sql.append(" WHERE COMPNO =?  AND SHOPCD= ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShoppingMallDetailDto getShopDtlOneIdWithDome(String shopcd) throws Exception {
        ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(a.COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(a.SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(a.SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(b.SHOPNM,'')  AS SHOPNM, \r\n");
                sql.append("IFNULL(a.APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(a.DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(a.PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(a.AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(a.AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(a.EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(a.EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(a.NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(a.SHOPSEQ, '') AS SHOPSEQ      \r\n");
                sql.append(" FROM shopdtldome AS a ");
                sql.append(" join shopinfodome AS b on a.shopcd = b.shopcd ");
                sql.append(" WHERE COMPNO =?  AND a.SHOPCD= ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShoppingMallDetailDto getShopDtlIdWithDome(String shopcd, String shopseq) throws Exception {
        ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(a.COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(a.SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(a.SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(b.SHOPNM,'')  AS SHOPNM, \r\n");
                sql.append("IFNULL(a.APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(a.DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(a.PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(a.AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(a.AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(a.EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(a.EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(a.NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(a.SHOPSEQ, '') AS SHOPSEQ      \r\n");
                sql.append(" FROM shopdtldome AS a ");
                sql.append(" join shopinfodome AS b on a.shopcd = b.shopcd ");
                sql.append(" WHERE COMPNO =?  AND a.SHOPCD= ? and \tshopseq = ?  \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, shopseq);
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShoppingMallDetailDto getShopDtlRegCount(String shopcd, String shopseq) throws Exception {
        ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(REGCNT, '0') AS REGCNT, \r\n");
                sql.append("IFNULL(EXCESSYN,'N')  AS EXCESSYN, \r\n");
                sql.append("IFNULL(EXCESSCNT,'0') AS EXCESSCNT \r\n ");
                sql.append(" FROM shopdtl  ");
                sql.append(" WHERE COMPNO =?  AND SHOPCD= ? AND SHOPSEQ = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, shopseq);
                YDMAStringUtil.Print("[getShopDtlRegCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setRegcnt(rs.getString("REGCNT"));
                    dto.setExcessyn(rs.getString("EXCESSYN"));
                    dto.setExcesscnt(rs.getString("EXCESSCNT"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public String getCategorySetting(String json, String shopcd, String categoryJson) throws Exception {
        String retJson;
        block5: {
            retJson = "";
            if (!json.equals("")) break block5;
            return null;
        }
        try {
            ShopProductDao.ShopCateItem[] shopcateItem;
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(json, ShopProductDao.ShopCateItem[].class);
            int n = shopcateItem.length;
            int n2 = 0;
            while (n2 < n) {
                ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
                if (item.getShopcd().equals(shopcd)) {
                    item.setCid(categoryJson);
                }
                ++n2;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public String getCategoryShopSetting(String json, String shopcd, String cid) throws Exception {
        String retJson;
        block5: {
            retJson = "";
            if (!json.equals("")) break block5;
            return null;
        }
        try {
            ShopProductDao.ShopCateItem[] shopcateItem;
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(json, ShopProductDao.ShopCateItem[].class);
            int n = shopcateItem.length;
            int n2 = 0;
            while (n2 < n) {
                ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
                if (item.getShopcd().equals(shopcd)) {
                    item.setCid(cid);
                }
                ++n2;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public String getCategoryDomeSetting(String json, String shopcd, String cid) throws Exception {
        String retJson;
        block5: {
            retJson = "";
            if (!json.equals("")) break block5;
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.DomeCateItem[] shopcateItem = (ShopProductDao.DomeCateItem[])mapper.readValue(json, ShopProductDao.DomeCateItem[].class);
            ShopProductDao.DomeCateItem cateitem = Arrays.asList(shopcateItem).stream().filter(d -> d.getShopcd().equals(shopcd)).findAny().orElse(null);
            ArrayList<ShopProductDao.DomeCateItem> shopcateItems = new ArrayList<ShopProductDao.DomeCateItem>(Arrays.asList(shopcateItem));
            if (cateitem == null) {
                cateitem = new ShopProductDao.DomeCateItem();
                cateitem.setShopcd(shopcd);
                cateitem.setCid(new ArrayList<String>());
                shopcateItems.add(cateitem);
            }
            for (ShopProductDao.DomeCateItem item : shopcateItems) {
                String categ;
                if (!item.getShopcd().equals(shopcd) || (categ = (String)item.getCid().stream().filter(d -> d.equals(cid)).findAny().orElse(null)) != null) continue;
                item.getCid().add(cid);
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public String getEsmCategorySetting(String json, String shopcd, String categoryJson, String EsmCate) throws Exception {
        String retJson;
        block10: {
            retJson = "";
            if (!json.equals("")) break block10;
            return null;
        }
        try {
            ShopProductDao.ShopCateItem[] shopcateItem;
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(json, ShopProductDao.ShopCateItem[].class);
            int n = shopcateItem.length;
            int n2 = 0;
            while (n2 < n) {
                ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
                if (item.getShopcd().equals("shop0068") && shopcd.equals("shop00681")) {
                    item.setCid(categoryJson);
                }
                if (item.getShopcd().equals(shopcd)) {
                    if (shopcd.equals("shop00671")) {
                        item.setEsm_auction(EsmCate);
                        item.setCid(categoryJson);
                    } else if (shopcd.equals("shop00681")) {
                        item.setEsm_gmarket(EsmCate);
                        item.setCid(categoryJson);
                    } else {
                        item.setCid(categoryJson);
                    }
                }
                ++n2;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public void setDomeCategInsertDelete(List<ShopCategoryDto> resultList) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "DELETE FROM domecateg WHERE SHOPCD=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, resultList.get(0).getShopcd());
                pstmt.executeUpdate();
                String sql1 = "INSERT INTO domecateg (SHOPCD, LEVEL, CODE, UPCODE, NAME, FULLCAT)\tVALUES (?, ?, ?, ?, ?, ?)";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopCategoryDto dto : resultList) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getShopcd());
                    pstmt1.setString(++idx, dto.getLevel());
                    pstmt1.setString(++idx, dto.getCode());
                    pstmt1.setString(++idx, dto.getUpcode());
                    pstmt1.setString(++idx, dto.getName());
                    pstmt1.setString(++idx, dto.getFullcat());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setDomeCategInsertDelete]" + pstmt.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<String> getCategoryMapList(String es) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(DOMECATG, '') AS DOMECATG, \r\n");
                sql.append("IFNULL(SHOPCATE,'')  AS SHOPCATE \r\n");
                sql.append(" FROM category  ");
                sql.append(" WHERE ID =? ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, es);
                YDMAStringUtil.Print("[getShopDtlRegCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString("DOMECATG"));
                    list.add(rs.getString("SHOPCATE"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopCateDto.CategoryMapLevelList> getCategoryMapLevelList() throws Exception {
        ArrayList<ShopCateDto.CategoryMapLevelList> list;
        block6: {
            list = new ArrayList<ShopCateDto.CategoryMapLevelList>();
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT ID, NAME, PARENT_CODE FROM category \r\n");
                    pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                    YDMAStringUtil.Print("[getCategoryMapLevelList]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ShopCateDto.CategoryMapLevelList dto = new ShopCateDto.CategoryMapLevelList();
                        dto.setId(rs.getString("ID"));
                        dto.setName(rs.getString("NAME"));
                        dto.setPid(rs.getString("PARENT_CODE"));
                        list.add(dto);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
        return list;
    }

    public void setNewCategoryMapUpdate(String es, String shopcate_json, String domecate_json) throws Exception {
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "UPDATE category set DOMECATG = ?, SHOPCATE = ? where ID = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, domecate_json);
                pstmt.setString(++i, shopcate_json);
                pstmt.setString(++i, es);
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public List<String> getShopGroup(ProductDTO dto) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT SHOPSEQ FROM shopdtl where compno = ? and SHOPCD = ? and SHOPGRP = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dto.getShopcd());
                pstmt.setString(3, dto.getShopgrp());
                YDMAStringUtil.Print("[getShopGroup]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<String> getShopGroupWithShopseq(String shopcd, String shopseq) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT shopseq \r\n  FROM shopdtl \r\n WHERE compno=? \r\n   AND SHOPCD=? \r\n   AND shopgrp=(SELECT ifnull(shopgrp,'') FROM shopdtl WHERE compno=? AND SHOPCD=? AND SHOPSEQ = ?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(4, shopcd);
                pstmt.setString(5, shopseq);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public ShopCateDto getCategoryAPI(String es) throws IOException {
        String url = String.format("http://api.kdjsystem.com:8080/api/v1/getCategoryMap?esCid=%s", es);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(url).method("GET", null).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ShopCateDto category = (ShopCateDto)mapper.readValue(data2, ShopCateDto.class);
        return category;
    }

    public String getCategoryShopApiSetting(String shopJson, ProductItemDto dto) throws Exception {
        String retJson;
        block70: {
            retJson = "";
            if (shopJson != null && !shopJson.equals("")) break block70;
            return null;
        }
        try {
            ShopProductDao.ShopCateItem[] shopcateItem;
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(shopJson, ShopProductDao.ShopCateItem[].class);
            int n = shopcateItem.length;
            int n2 = 0;
            while (n2 < n) {
                ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
                switch (item.getShopcd()) {
                    case "shop0067": 
                    case "shop00671": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_auction());
                        } else {
                            dto.setEs_auction(item.getCid());
                        }
                        if (item.getEsm_auction().equals("")) {
                            item.setEsm_auction(dto.getEsm_auction());
                            break;
                        }
                        dto.setEsm_auction(item.getEsm_auction());
                        break;
                    }
                    case "shop0068": 
                    case "shop00681": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_gmarket());
                        } else {
                            dto.setEs_gmarket(item.getCid());
                        }
                        if (item.getEsm_gmarket().equals("")) {
                            item.setEsm_gmarket(dto.getEsm_gmarket());
                            break;
                        }
                        dto.setEsm_gmarket(item.getEsm_gmarket());
                        break;
                    }
                    case "shop0004": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_interpark());
                            break;
                        }
                        dto.setEs_interpark(item.getCid());
                        break;
                    }
                    case "shop0055": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_storefarm());
                            break;
                        }
                        dto.setEs_storefarm(item.getCid());
                        break;
                    }
                    case "shop0003": 
                    case "shop00031": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_11st());
                            break;
                        }
                        dto.setEs_11st(item.getCid());
                        break;
                    }
                    case "shop0075": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_coupang());
                            break;
                        }
                        dto.setEs_coupang(item.getCid());
                        break;
                    }
                    case "shop0411": {
                        if (item.getCid().equals("")) {
                            item.setCid(String.valueOf(dto.getEs_ssg()));
                            break;
                        }
                        dto.setEs_ssg(String.valueOf(item.getCid()));
                        break;
                    }
                    case "shop0287": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_wemarket());
                            break;
                        }
                        dto.setEs_wemarket(item.getCid());
                        break;
                    }
                    case "shop0076": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_tmon());
                            break;
                        }
                        dto.setEs_tmon(item.getCid());
                        break;
                    }
                    case "shop0273": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_kakao());
                            break;
                        }
                        dto.setEs_kakao(item.getCid());
                        break;
                    }
                    case "shop0372": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_lotteon());
                            break;
                        }
                        dto.setEs_lotteon(item.getCid());
                        break;
                    }
                    case "shop0106": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_melchi());
                            break;
                        }
                        dto.setEs_melchi(item.getCid());
                        break;
                    }
                    case "shop0211": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_godomall());
                            break;
                        }
                        dto.setEs_godomall(item.getCid());
                    }
                }
                ++n2;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public int setCategoryMapUpdateApi(String es, String shopcate_json, String domecate_json) throws IOException {
        String url = String.format("http://api.kdjsystem.com:8080/api/v1/updateCategoryMap", new Object[0]);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", es);
        jsonObject.addProperty("domecatg", domecate_json);
        jsonObject.addProperty("shopcate", shopcate_json);
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)jsonObject.toString());
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(url).method("POST", body).addHeader("Content-Type", "application/json").build();
        String data2 = "";
        Throwable throwable = null;
        Object var12_13 = null;
        try (Response response = client.newCall(request2).execute();){
            data2 = response.body().string();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        JsonParser parser = new JsonParser();
        JsonObject obj = (JsonObject)parser.parse(data2);
        return obj.get("returnCode").getAsInt();
    }

    public ShopCateDto getCategoryMapAPI(int idx) throws IOException {
        String url = String.format("http://api.kdjsystem.com:8080/api/v1/searchCategoryMap?page=%s", idx);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(url).method("GET", null).addHeader("Content-Type", "application/json").build();
        String data2 = "";
        Throwable throwable = null;
        Object var7_8 = null;
        try (Response response = client.newCall(request2).execute();){
            data2 = response.body().string();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ShopCateDto category = (ShopCateDto)mapper.readValue(data2, ShopCateDto.class);
        return category;
    }

    public void setShopCategorysInsertNUpdate(List<ShopCateDto.MallCategoryList> list, String shopcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO shopcategorys (SHOPCD, CODE, SHOPCATENM, ESMCODE, ESMSHOPCATENM) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE SHOPCATENM = ?, ESMCODE = ?, ESMSHOPCATENM = ?";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopCateDto.MallCategoryList dto : list) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getShopcd());
                    pstmt1.setString(++idx, dto.getCode());
                    pstmt1.setString(++idx, dto.getShopcatenm());
                    pstmt1.setString(++idx, dto.getEsmcode());
                    pstmt1.setString(++idx, dto.getEsmshopcatenm());
                    pstmt1.setString(++idx, dto.getShopcatenm());
                    pstmt1.setString(++idx, dto.getEsmcode());
                    pstmt1.setString(++idx, dto.getEsmshopcatenm());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setShopCategorysInsertNUpdate]" + pstmt1.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setCategoryMapInsertNUpdate(List<ShopCateDto.CategoryMapList> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO category\r\n\t(ID, NAME, PARENT_CODE, FULL_NAME, `LEVEL`, SHOPCATE, DOMECATG)\r\n\tVALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE \r\nNAME=?, PARENT_CODE=?, FULL_NAME=?, LEVEL=?, SHOPCATE=?, DOMECATG=?";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopCateDto.CategoryMapList dto : list) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getId());
                    pstmt1.setString(++idx, dto.getName());
                    pstmt1.setString(++idx, dto.getParent_code());
                    pstmt1.setString(++idx, dto.getFull_name());
                    pstmt1.setString(++idx, dto.getLevel());
                    pstmt1.setString(++idx, dto.getShopcate());
                    pstmt1.setString(++idx, dto.getDomecatg());
                    pstmt1.setString(++idx, dto.getName());
                    pstmt1.setString(++idx, dto.getParent_code());
                    pstmt1.setString(++idx, dto.getFull_name());
                    pstmt1.setString(++idx, dto.getLevel());
                    pstmt1.setString(++idx, dto.getShopcate());
                    pstmt1.setString(++idx, dto.getDomecatg());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setCategoryMapInsertNUpdate]" + pstmt1.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setProdAttrInsertNUpdate(List<ShopProdAttrnmDto.ProdAttrList> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO prodattr\r\n\t(ATTRCD, ATTRNM, FLAGDEFT, LOTTECD, NAVERCD, DOSINCD, TMONCD, KAKAOCD, MELCHICD)\r\n\tVALUES (?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE \r\nATTRNM=?, FLAGDEFT=?, LOTTECD=?, NAVERCD=?, DOSINCD=?, TMONCD=?, KAKAOCD=?, MELCHICD=? ";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopProdAttrnmDto.ProdAttrList dto : list) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getAttrcd());
                    pstmt1.setString(++idx, dto.getAttrnm());
                    pstmt1.setString(++idx, dto.getFlagdeft());
                    pstmt1.setString(++idx, dto.getLottecd());
                    pstmt1.setString(++idx, dto.getNavercd());
                    pstmt1.setString(++idx, dto.getDosincd());
                    pstmt1.setString(++idx, dto.getTmoncd());
                    pstmt1.setString(++idx, dto.getKakaocd());
                    pstmt1.setString(++idx, dto.getMelchicd());
                    pstmt1.setString(++idx, dto.getAttrnm());
                    pstmt1.setString(++idx, dto.getFlagdeft());
                    pstmt1.setString(++idx, dto.getLottecd());
                    pstmt1.setString(++idx, dto.getNavercd());
                    pstmt1.setString(++idx, dto.getDosincd());
                    pstmt1.setString(++idx, dto.getTmoncd());
                    pstmt1.setString(++idx, dto.getKakaocd());
                    pstmt1.setString(++idx, dto.getMelchicd());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setProdAttrInsertNUpdate]" + pstmt1.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setProdAttrNMInsertNUpdate(List<ShopProdAttrnmDto.ProdAttrNMList> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO prodattrnm\r\n\t(ATTRCD, COLSEQ, ATTRNM, FUNNSEQ, WTRADINGSEQ, TOBIZONSEQ, DOMEGGOOKSEQ, OWNERCLANSEQ, HUBSELLSEQ, DOSINSEQ, NOTICETYPE, ITEMCODE, INTERCODE, \t INTERAPICODE, INTERAPITYPE)\r\n\tVALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE \r\nATTRNM=?, FUNNSEQ=?, WTRADINGSEQ=?, TOBIZONSEQ=?, DOMEGGOOKSEQ=?, OWNERCLANSEQ=?, HUBSELLSEQ=?, DOSINSEQ=?, NOTICETYPE=?, ITEMCODE=?, INTERCODE=?, INTERAPICODE=?, INTERAPITYPE=?";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopProdAttrnmDto.ProdAttrNMList dto : list) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getAttrcd());
                    pstmt1.setString(++idx, dto.getColseq());
                    pstmt1.setString(++idx, dto.getAttrnm());
                    pstmt1.setString(++idx, dto.getFunnseq());
                    pstmt1.setString(++idx, dto.getWtradingseq());
                    pstmt1.setString(++idx, dto.getTobizonseq());
                    pstmt1.setString(++idx, dto.getDomeggookseq());
                    pstmt1.setString(++idx, dto.getOwnerclanseq());
                    pstmt1.setString(++idx, dto.getHubsellseq());
                    pstmt1.setString(++idx, dto.getDosinseq());
                    pstmt1.setString(++idx, dto.getNoticetype());
                    pstmt1.setString(++idx, dto.getItemcode());
                    pstmt1.setString(++idx, dto.getIntercode());
                    pstmt1.setString(++idx, dto.getInterapicode());
                    pstmt1.setString(++idx, dto.getInterapitype());
                    pstmt1.setString(++idx, dto.getAttrnm());
                    pstmt1.setString(++idx, dto.getFunnseq());
                    pstmt1.setString(++idx, dto.getWtradingseq());
                    pstmt1.setString(++idx, dto.getTobizonseq());
                    pstmt1.setString(++idx, dto.getDomeggookseq());
                    pstmt1.setString(++idx, dto.getOwnerclanseq());
                    pstmt1.setString(++idx, dto.getHubsellseq());
                    pstmt1.setString(++idx, dto.getDosinseq());
                    pstmt1.setString(++idx, dto.getNoticetype());
                    pstmt1.setString(++idx, dto.getItemcode());
                    pstmt1.setString(++idx, dto.getIntercode());
                    pstmt1.setString(++idx, dto.getInterapicode());
                    pstmt1.setString(++idx, dto.getInterapitype());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setProdAttrNMInsertNUpdate]" + pstmt1.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setShopAttrInfoInsertNUpdate(List<ShopProdAttrnmDto.ShopAttrInfoInf> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO shopattrinfo (SHOPCD, GOSICODE, GOSINUM, GOSIVAL)\r\n\tVALUES (?,?,?,?) ON DUPLICATE KEY UPDATE GOSIVAL=?";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopProdAttrnmDto.ShopAttrInfoInf dto : list) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getShopcd());
                    pstmt1.setString(++idx, dto.getGosicode());
                    pstmt1.setString(++idx, dto.getGosinum());
                    pstmt1.setString(++idx, dto.getGosival());
                    pstmt1.setString(++idx, dto.getGosival());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setShopAttrInfoInsertNUpdate]" + pstmt1.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public String getCateDomeJson(ProductItemDto item) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        List<String> shopList = DomesinSessonUtil.ManagerDome;
        ArrayList<ShopProductDao.DomeCateItem> cate_list = new ArrayList<ShopProductDao.DomeCateItem>();
        for (String shopcd : shopList) {
            ShopProductDao.DomeCateItem cateItem = new ShopProductDao.DomeCateItem();
            cateItem.shopcd = shopcd;
            cateItem.cid = new ArrayList<String>();
            cate_list.add(cateItem);
        }
        String json = mapper.writeValueAsString(cate_list);
        return json;
    }

    public String getEsCode(String class_cd3) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT `GET_COUPANG_ESCODE`(?);";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, class_cd3);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getEsCodeNaver(String class_cd3) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT `GET_NAVER_ESCODE`(?);";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, class_cd3);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getEsCodeAllShop(String shopcd, String val, String json) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT `GET_ALL_ESCODE`(?,?,?);";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, val);
                pstmt.setString(3, json);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public void saveCat_imsi_tot(String id, String shopcode, String code) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into cat_imsi_tot values(?,?,?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, id);
                pstmt.setString(2, shopcode);
                pstmt.setString(3, code);
                pstmt.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void getSyncCategory(ProductItemDto newInfoDto, ProductDTO sync) throws Exception {
        ShopProductDao.ShopCateItem[] shopcateItem;
        ObjectMapper mapper = new ObjectMapper();
        ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(sync.getShop_cid_info(), ShopProductDao.ShopCateItem[].class);
        int n = shopcateItem.length;
        int n2 = 0;
        while (n2 < n) {
            ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
            switch (item.getShopcd()) {
                case "shop0067": 
                case "shop00671": {
                    newInfoDto.setEs_auction(String.valueOf(item.getCid()));
                    newInfoDto.setEsm_auction(String.valueOf(item.getEsm_auction()));
                    break;
                }
                case "shop0068": 
                case "shop00681": {
                    newInfoDto.setEs_gmarket(String.valueOf(item.getCid()));
                    newInfoDto.setEsm_gmarket(String.valueOf(item.getEsm_gmarket()));
                    break;
                }
                case "shop0004": {
                    newInfoDto.setEs_interpark(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0055": {
                    newInfoDto.setEs_storefarm(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0003": 
                case "shop00031": {
                    newInfoDto.setEs_11st(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0075": {
                    newInfoDto.setEs_coupang(String.valueOf(sync.getCid()));
                    break;
                }
                case "shop0110": {
                    item.setCid("");
                    break;
                }
                case "shop0287": {
                    newInfoDto.setEs_wemarket(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0076": {
                    newInfoDto.setEs_tmon(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0273": {
                    newInfoDto.setEs_kakao(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0411": {
                    newInfoDto.setEs_ssg(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0372": {
                    newInfoDto.setEs_lotteon(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0106": {
                    newInfoDto.setEs_melchi(String.valueOf(item.getCid()));
                }
            }
            ++n2;
        }
    }

    public void setCategorySave(List<ShopCategoryDto> dtolist) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO shopcategorys (SHOPCD, CODE, SHOPCATENM) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE SHOPCATENM = ? ";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopCategoryDto dto : dtolist) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getShopcd());
                    pstmt1.setString(++idx, dto.getCatlrgcd());
                    pstmt1.setString(++idx, dto.getCatlrgnm());
                    pstmt1.setString(++idx, dto.getCatlrgnm());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public String getCategoryMatch(String class_nm1, String shopcd) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(CODE,'') FROM shopcategorys WHERE shopcd = ? and MATCH(SHOPCATENM) AGAINST(? IN boolean MODE) LIMIT 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, class_nm1);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getCategoryMatchCode(String shopcd, String num) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SHOPCATENM,'') FROM shopcategorys WHERE shopcd = ? and code = ? LIMIT 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, num);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getCategoryMatchName(String class_nm1, String shopcd) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SHOPCATENM,'') FROM shopcategorys WHERE shopcd = ? and MATCH(SHOPCATENM) AGAINST(? IN boolean MODE) LIMIT 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, class_nm1);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setInfoDelvCost(List<ProductDTO> dto1) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodinfo set DELV_COST = ?,RETURN_DELV_COST = ?   where compno = ?  and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductDTO dto : dto1) {
                    int i = 0;
                    pstmt.setString(++i, dto.getDelv_cost());
                    pstmt.setString(++i, dto.getDelv_r_cost());
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++i, dto.getPRODSEQ());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setInfoCategoryCD(ProductDTO dto) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodinfo set class_cd3 = ?, shop_cid_info = ?, status = ?, goods_price = ?, goods_search = ?     where compno = ?  and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, dto.getClass_cd3());
                pstmt.setString(++i, dto.getShop_cid_info());
                pstmt.setString(++i, dto.getStatus());
                pstmt.setString(++i, dto.getGoods_price());
                pstmt.setString(++i, dto.getGoods_search());
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getPRODSEQ());
                pstmt.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setGoods_Name(ProductDTO dto) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodinfo set GOODS_NM = ? ,STATUS = ?  where compno = ?  and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, dto.getGoods_nm());
                pstmt.setString(++i, dto.getStatus());
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getPRODSEQ());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setGoods_NameIn(ProductDTO dto) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodin set GOODS_NM = ? ,STATUS = ?  where compno = ?  and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, dto.getGoods_nm());
                pstmt.setString(++i, dto.getStatus());
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getPRODSEQ());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setShopCookiesUpdate(String shopcd, String shopid, String key, String cookie, String authkey) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "UPDATE shopdtl AS a \r\n";
                sql = shopcd.equals("shop0273") ? String.valueOf(sql) + " INNER JOIN (SELECT MIN(SHOPSEQ) AS shopseq FROM shopdtl WHERE compno= ? AND SHOPCD= ? AND SHOPPINGID= ?  AND AUTHKEY1= ? ) AS b\r\n" : (shopcd.equals("shop0055") ? String.valueOf(sql) + " INNER JOIN (SELECT MIN(SHOPSEQ) AS shopseq FROM shopdtl WHERE compno= ? AND SHOPCD= ? AND SHOPPINGID= ?  AND APIKEY LIKE ? ) AS b\r\n" : String.valueOf(sql) + " INNER JOIN (SELECT MIN(SHOPSEQ) AS shopseq FROM shopdtl WHERE compno= ? AND SHOPCD= ? AND SHOPPINGID= ?  ) AS b\r\n");
                sql = String.valueOf(sql) + " \t\t ON a.SHOPSEQ=b.SHOPSEQ \r\n\tSET a.COOKIEKEY= ? , a.COOKIES= ? \r\n WHERE compno= ?  \r\n   AND SHOPCD= ? \r\n\tAND SHOPPINGID= ? ";
                if (shopcd.equals("shop0273")) {
                    sql = String.valueOf(sql) + "   AND AUTHKEY1= ? ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, shopcd);
                pstmt.setString(++i, shopid);
                if (shopcd.equals("shop0273")) {
                    pstmt.setString(++i, authkey);
                } else if (shopcd.equals("shop0055")) {
                    pstmt.setString(++i, String.valueOf(authkey) + "%");
                }
                pstmt.setString(++i, key);
                pstmt.setString(++i, cookie);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, shopcd);
                pstmt.setString(++i, shopid);
                if (shopcd.equals("shop0273")) {
                    pstmt.setString(++i, authkey);
                }
                YDMAStringUtil.Print("[setShopCookiesUpdate]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setDomeCookiesUpdate(String shopcd, String shopid, String key, String cookie) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "UPDATE shopdtldome AS a \r\n INNER JOIN (SELECT MIN(SHOPSEQ) AS shopseq FROM shopdtldome WHERE compno= ? AND SHOPCD= ? AND SHOPPINGID= ? ) AS b\r\n \t\t ON a.SHOPSEQ=b.SHOPSEQ \r\n\tSET a.COOKIEKEY= ? , a.COOKIES= ? \r\n WHERE compno= ?  \r\n   AND SHOPCD= ? \r\n\tAND SHOPPINGID= ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, shopcd);
                pstmt.setString(++i, shopid);
                pstmt.setString(++i, key);
                pstmt.setString(++i, cookie);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, shopcd);
                pstmt.setString(++i, shopid);
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShoppingMallDetailDto> getShopCookies() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ShoppingMallDetailDto> list = new ArrayList<ShoppingMallDetailDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT DISTINCT SHOPCD,SHOPPINGID,ifnull(COOKIEKEY,'') AS COOKIEKEY,ifnull(COOKIES,'') AS COOKIES\r\n  FROM shopdtl \r\n WHERE compno= ? \r\n   AND COOKIEKEY IS not null\r\n UNION ALL\r\nSELECT DISTINCT SHOPCD,SHOPPINGID,ifnull(COOKIEKEY,'') AS COOKIEKEY,ifnull(COOKIES,'') AS COOKIES\r\n  FROM shopdtldome \r\n WHERE compno= ? \r\n   AND COOKIEKEY IS not null";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
                    dto.setCookiekey(rs.getString("COOKIEKEY"));
                    dto.setCookies(rs.getString("COOKIES"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public String getCategoryMatch(String class_nm1) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(id,'') FROM category WHERE MATCH(FULL_NAME) AGAINST(? IN boolean MODE) LIMIT 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, class_nm1);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ProductFolderDTO> getShopProdFolders() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ProductFolderDTO> result = new ArrayList<ProductFolderDTO>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COMPNO, FOLDER, COMPAYNY_GOODS_CD\r\n\tFROM shopprodfolders\r\n where compno=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    ProductFolderDTO dto = new ProductFolderDTO();
                    dto.setCOMPNO(rs.getString(++columnIndex));
                    dto.setFOLDER(rs.getString(++columnIndex));
                    dto.setCOMPAYNY_GOODS_CD(rs.getString(++columnIndex));
                    result.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public void updateShopdtlAPIKEY(String shopcd, String shopid, String token, String sellerId) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE shopdtl AS a \r\n").append(" INNER JOIN (SELECT MIN(SHOPSEQ) AS SHOPSEQ FROM shopdtl \r\n").append("              WHERE COMPNO = ? \r\n").append("                AND SHOPCD = ? \r\n").append("                AND SHOPPINGID = ?) AS b \r\n").append("    ON a.SHOPSEQ = b.SHOPSEQ \r\n").append("   SET a.APIKEY = ?, \r\n").append("       a.AUTHKEY1 = ? \r\n").append(" WHERE COMPNO = ? \r\n").append("   AND SHOPCD = ? \r\n").append("   AND SHOPPINGID = ? \r\n");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{YDMASessonUtil.getCompnoInfo().getCompno(), shopcd, shopid, token, sellerId, YDMASessonUtil.getCompnoInfo().getCompno(), shopcd, shopid};
                YDMAStringUtil.Print("[\uc62c\uc6e8\uc774\uc988 \uacc4\uc815 \ud1a0\ud070 \uc5c5\ub370\uc774\ud2b8]" + sql.toString());
                runner.update(connection, sql.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ShopDeliveryDto getShippingInfo(ShopOrderMstDto dto) throws Exception {
        ShopDeliveryDto result = null;
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ShopDeliveryDto.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("\t\tSHOPCD  \r\n");
                query.append("\t  , DLVID  \r\n");
                query.append("\t  , DLVNM AS divNM \r\n");
                query.append("\t  , DOSIN_CODE AS ds_code \r\n");
                query.append("  FROM shopdeliverys  \r\n");
                query.append(" WHERE SHOPCD = ?  \r\n");
                query.append("   AND DLVID = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{dto.getShopid(), dto.getDelivery_id()};
                result = (ShopDeliveryDto)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getCompanyGoodsCd(String itemId, String shopId) throws Exception {
        String companyGoodsCd = null;
        QueryRunner run = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("\t\tIFNULL(COMPAYNY_GOODS_CD, '') AS compayny_goods_cd  \r\n");
                query.append("  FROM shopprodin  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                query.append("   AND SHOPPRODNO = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{YDMASessonUtil.getCompnoInfo().getCompno(), shopId, itemId};
                companyGoodsCd = (String)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return companyGoodsCd != null ? companyGoodsCd : "";
    }

    private static class CommonCode {
        int MultiThreadCnt = 1;
        final List<String> ShopList = ShopCommon.getCommonCodeList("PRODUCT_SHOP").stream().map(p -> p.getCode()).collect(Collectors.toList());
        private static CommonCode instance = new CommonCode();
        Map<String, Map<String, List<ShoppingMallDetailDto>>> mapShopUserList;
        List<ShoppingMallDetailDto> shoppingMallDetailDtos;
        private String shopcd = "";
        private String shopuserid = "";

        private CommonCode() {
        }

        public Map<String, Map<String, List<ShoppingMallDetailDto>>> getMapShopUserList() {
            return this.mapShopUserList;
        }

        public Map<String, List<ShoppingMallDetailDto>> filterMapShopUserList(String shopcd) {
            if (this.shopuserid.isEmpty()) {
                return this.mapShopUserList.get(shopcd);
            }
            HashMap<String, List<ShoppingMallDetailDto>> ret = new HashMap<String, List<ShoppingMallDetailDto>>();
            ret.put(this.shopuserid, this.mapShopUserList.get(shopcd).get(this.shopuserid));
            return ret;
        }

        public void setMapShopUserList(Map<String, Map<String, List<ShoppingMallDetailDto>>> mapShopUserList) {
            this.mapShopUserList = mapShopUserList;
        }

        public List<ShoppingMallDetailDto> getShoppingMallDetailDtos() {
            return this.shoppingMallDetailDtos;
        }

        public void setShoppingMallDetailDtos(List<ShoppingMallDetailDto> shoppingMallDetailDtos) {
            this.shoppingMallDetailDtos = shoppingMallDetailDtos;
        }

        public void init() throws Exception {
            this.MultiThreadCnt = ShopWorkDao.get().getMultiThreadCnt();
            this.shoppingMallDetailDtos = ShopCommonDao.get().ShoppingMallDetailList();
            this.mapShopUserList = this.shoppingMallDetailDtos.stream().collect(Collectors.groupingBy(ShoppingMallDetailDto::getShopcd, Collectors.groupingBy(ShoppingMallDetailDto::getShoppingid)));
        }

        private static CommonCode get() {
            return instance;
        }

        public String getShopcd() {
            return this.shopcd;
        }

        public void setShopcd(String shopcd) {
            this.shopcd = shopcd;
        }

        public String getShopuserid() {
            return this.shopuserid;
        }

        public void setShopuserid(String shopuserid) {
            this.shopuserid = shopuserid;
        }

        public List<String> getAllShopCode() {
            return this.ShopList;
        }

        public List<String> getShopCode() {
            if (!this.shopcd.isEmpty()) {
                return Arrays.asList(this.shopcd);
            }
            return this.ShopList;
        }
    }
}

