/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.Melchi;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.CategoryDao;
import com.kdjsystem.mlink.yellim.data.dao.ShoppingMallCategoryDto;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.common.IProduct;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopMelchiAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.yellim.shop.data.Melchi.MelchiExitsProductCd;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MelchiProductRegService
implements IProduct {
    ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
    List<ShopOptionDto> shopOptionDtos;

    @Override
    public ShopProductSendDto excute(ShopProductSendDto sendProdList) throws Exception {
        ShopMelchiAdditionalDto dtllist = new ShopMelchiAdditionalDto();
        ShoppingmallDTO shoppingMallDetailDto = sendProdList.getShoppingmallDTO();
        List<ProductDTO> prodList = sendProdList.getShopProductDto();
        WorkMngDto workMngDto = sendProdList.getWorkMngDto();
        String uuid = sendProdList.getWorkgrp();
        if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
            workMngDto.setWork_status("W02");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            return sendProdList;
        }
        dtllist = (ShopMelchiAdditionalDto)sendProdList.getProductAdditionDto();
        int progress = workMngDto.getProgress_rate();
        List<WorkMngDetailDto> workMngDetailDtos = workMngDto.getWork_detail();
        Map<Object, Object> cookies = new HashMap();
        try {
            String loginID = shoppingMallDetailDto.getSHOPPINGID();
            String password = shoppingMallDetailDto.getPASSWORD();
            String shopCd = shoppingMallDetailDto.getSHOPCD();
            IShopCommonLogin i = new IShopCommonLogin(){};
            cookies = i.loginCookie(loginID, password, shopCd, true, shoppingMallDetailDto.getAUTHKEY1());
            if (cookies.size() == 0) {
                throw new Exception("\ub85c\uadf8\uc778\uc744 \uc2e4\ud328\ud558\uc168\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            workMngDto.setWork_status("-1");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            WorkMngDetailDto workMngDetailDto = workMngDetailDtos.get(0);
            workMngDetailDto.setStatus("-1");
            workMngDetailDto.setMessage(e.getMessage());
            WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
            return sendProdList;
        }
        try {
            PreferencesMallDTO dto1 = ShopCommonDao.get().getSystemConf();
            int mod = dto1.getPROCCNT() / prodList.size();
            workMngDto.setWork_status("W06");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            for (ProductDTO dto : prodList) {
                workMngDto.setProgress_rate(progress += mod);
                workMngDto.setWork_status("W08");
                ShopWorkDataQueue.get().notifyObservers();
                WorkMngDetailDto workMngDetailDto = workMngDetailDtos.stream().filter(p -> p.getProdseq().equals(dto.getCompayny_goods_cd())).findAny().orElse(null);
                if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
                    workMngDetailDto.setStatus("W02");
                    workMngDetailDto.setMessage("\ucde8\uc18c \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                if (workMngDetailDto.getStatus().equals("W06")) continue;
                if (workMngDto.getWork_status().equals("W02")) {
                    ShopProductSendDto shopProductSendDto = sendProdList;
                    return shopProductSendDto;
                }
                try {
                    String companyGoodsCd = dto.getCompayny_goods_cd();
                    String prodNo = MelchiExitsProductCd.get().getisExistsProdNo(companyGoodsCd, cookies);
                    if (!prodNo.equals("")) {
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage("\uc0c1\ud488\ub4f1\ub85d\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                        dto.setResult_code("-1");
                        dto.setResult_text("\uc0c1\ud488\ub4f1\ub85d\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                        continue;
                    }
                    List<Object> strImages = new ArrayList();
                    strImages = dtllist.getChangesize().equals("Y") ? this.getProductImages(dto, dtllist.getChangeSizeX(), dtllist.getChangeSizeY(), dtllist.getChangeSizeW(), dtllist.getChangeSizeH(), dtllist.getAngle(), dtllist.getScalePercent()) : this.getProductImages(dto);
                    this.DownLoadImage(strImages);
                    try {
                        this.setProductReg(dto, cookies, workMngDto, uuid, dtllist, shoppingMallDetailDto, strImages);
                        if (!dto.getShopprodno().equals("")) {
                            dto.setResult_code("1");
                            workMngDetailDto.setStatus("W06");
                            workMngDetailDto.setMessage(String.valueOf(shoppingMallDetailDto.getSHOPNM()) + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4 [\uc0c1\ud488\ubc88\ud638 : " + dto.getShopprodno() + " ]");
                            dto.setShopprodno(dto.getShopprodno());
                            dto.setResult_text(String.valueOf(shoppingMallDetailDto.getSHOPNM()) + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4 [\uc0c1\ud488\ubc88\ud638 : " + dto.getShopprodno() + " ]");
                            sendProdList.setShopProductDto(Arrays.asList(dto));
                            WorkMngDao.get().saveProductIn(sendProdList);
                        } else {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage(dto.getResult_text());
                            dto.setResult_code("-1");
                            dto.setResult_text(dto.getResult_text());
                        }
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    catch (Exception e) {
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage(e.getMessage());
                        dto.setResult_code("-1");
                        dto.setResult_text(e.getMessage());
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                        continue;
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    workMngDto.setWork_status("-1");
                }
                break;
            }
        }
        finally {
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
        }
        return sendProdList;
    }

    private void DownLoadImage(List<String> strImages) throws Exception {
        for (String img : strImages) {
            ShopCommon.downloadImgFile(img, 720, 758);
        }
    }

    private void setProductReg(ProductDTO dto, Map<String, String> cookies, WorkMngDto workMngDto, String uuid, ShopMelchiAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto, List<String> strImages) throws Exception {
        try {
            String sellerCd = this.getSellerCd(cookies);
            File file = this.CopyExcel(dto);
            this.WriteExcelData(file, dto, dtllist, shoppingMallDetailDto, strImages);
            boolean isSuccess = this.ExcelUpload(file, cookies, sellerCd);
            if (isSuccess) {
                String prodSeq = this.GetUploadProduct(cookies, dto);
                if (prodSeq.equals("")) {
                    throw new Exception("\uc0c1\ud488 \ub4f1\ub85d \ubc18\uc601 \ub9ac\uc2a4\ud2b8\uc5d0 \uc0c1\ud488\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                }
                String strParam = this.getStringParam(prodSeq);
                this.productRegSend(cookies, strParam, dto);
            }
        }
        catch (Exception e) {
            throw new Exception("\uc0c1\ud488\ub4f1\ub85d\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private String getSellerCd(Map<String, String> cookies) throws Exception {
        String sellerCd = "";
        try {
            Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/member/seller/detailBasic?step=1").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.45 Safari/537.36").data("Host", "scm.smelchi.com").cookies(cookies).method(Connection.Method.GET).followRedirects(true).ignoreHttpErrors(true).execute();
            Document body = Jsoup.parseBodyFragment((String)response.body());
            Elements elementSellerCd = body.select("#table_style03-2 > tbody > tr:nth-child(2) > td:nth-child(4) > span");
            sellerCd = elementSellerCd.text();
        }
        catch (Exception e) {
            throw new Exception("\ud310\ub9e4\uc790\ucf54\ub4dc\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4." + e);
        }
        return sellerCd;
    }

    private File CopyExcel(ProductDTO dto) throws Exception {
        File file = new File(YDMASessonUtil.getAppPath().concat("\\YDwmsData\\03.SabangNet\\product\\MelchiProductUpload.xls"));
        File newFile = new File(YDMASessonUtil.getAppPath().concat("\\YDwmsData\\03.SabangNet\\product\\MelchiProductUpload").concat(dto.getCompayny_goods_cd()).concat(".xls"));
        try {
            FileUtils.copyFile((File)file, (File)newFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return newFile;
    }

    private void WriteExcelData(File file, ProductDTO dto, ShopMelchiAdditionalDto additionDto, ShoppingmallDTO mallInfoDto, List<String> imgList) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                fis = new FileInputStream(file);
                HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fis);
                HSSFSheet sheet = workbook.getSheetAt(0);
                sheet.getRow(1).createCell(0).setCellValue(mallInfoDto.getSHOPPINGID());
                ShoppingMallCategoryDto category = CategoryDao.get().getShopCategoryInfo2(dto.getShopcd(), dto.getShopCid());
                if (category == null) {
                    throw new Exception("\ud574\ub2f9 \uce74\ud14c\uace0\ub9ac\ub294 \ubcc0\uacbd\ub418\uc5c8\uac70\ub098 \uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \ucf54\ub4dc\uc785\ub2c8\ub2e4.");
                }
                String[] fullName = category.getShopCateNm().split(">");
                sheet.getRow(1).createCell(1).setCellValue(fullName[0]);
                sheet.getRow(1).createCell(2).setCellValue(fullName[1]);
                sheet.getRow(1).createCell(3).setCellValue(fullName[2]);
                sheet.getRow(1).createCell(4).setCellValue(fullName[3]);
                sheet.getRow(1).createCell(5).setCellValue(dto.getCompayny_goods_cd());
                sheet.getRow(1).createCell(6).setCellValue(dto.getGoods_nm());
                sheet.getRow(1).createCell(7).setCellValue(dto.getMaker().equals("") ? "\uae30\ud0c0" : dto.getMaker());
                sheet.getRow(1).createCell(8).setCellValue(dto.getBrand_nm().equals("") ? "" : dto.getBrand_nm());
                sheet.getRow(1).createCell(9).setCellValue(dto.getOrigin());
                sheet.getRow(1).createCell(10).setCellValue(dto.getAdult());
                sheet.getRow(1).createCell(11).setCellValue(additionDto.getIsTaxedYn());
                sheet.getRow(1).createCell(12).setCellValue(additionDto.getSaleDisplayTypeYn());
                sheet.getRow(1).createCell(13).setCellValue("0");
                int salePrice = this.SalePrice(dto, additionDto);
                sheet.getRow(1).createCell(14).setCellValue(Integer.toString(salePrice));
                this.shopOptionDtos = this.getProductOptions(dto);
                String optionValue = this.shopOptionDtos.stream().map(p -> p.getOptspecdes().split(":")[0]).collect(Collectors.joining(","));
                sheet.getRow(1).createCell(16).setCellValue(this.shopOptionDtos.size() > 0 ? "1" : "0");
                sheet.getRow(1).createCell(17).setCellValue(this.shopOptionDtos.size() > 0 ? dto.getChar_1_nm() : "");
                sheet.getRow(1).createCell(18).setCellValue(this.shopOptionDtos.size() > 0 ? optionValue : "");
                sheet.getRow(1).createCell(23).setCellValue(additionDto.getShippingMethodYn());
                sheet.getRow(1).createCell(24).setCellValue(additionDto.getShippingFeeType());
                if (additionDto.getShippingFeeType().equals("01")) {
                    sheet.getRow(1).createCell(25).setCellValue("01");
                } else if (additionDto.getShippingFeeType().equals("02")) {
                    sheet.getRow(1).createCell(25).setCellValue(additionDto.getShippingFeePayTypeTmp2());
                    sheet.getRow(1).createCell(26).setCellValue(additionDto.getShippingFeeTmp2());
                } else if (additionDto.getShippingFeeType().equals("03")) {
                    sheet.getRow(1).createCell(25).setCellValue("02");
                    sheet.getRow(1).createCell(26).setCellValue("3000");
                } else if (additionDto.getShippingFeeType().equals("04")) {
                    sheet.getRow(1).createCell(25).setCellValue(additionDto.getShippingFeePayTypeTmp4());
                    sheet.getRow(1).createCell(26).setCellValue(additionDto.getShippingFeeTmp4());
                    sheet.getRow(1).createCell(27).setCellValue(additionDto.getFreeShippingAmount());
                }
                sheet.getRow(1).createCell(28).setCellValue(additionDto.getAdditionalShippingFee());
                sheet.getRow(1).createCell(29).setCellValue(additionDto.getReturnShippingFee());
                sheet.getRow(1).createCell(30).setCellValue(additionDto.getChangeShippingFee());
                sheet.getRow(1).createCell(31).setCellValue(imgList.get(0));
                sheet.getRow(1).createCell(32).setCellValue(dto.getGoods_remarks());
                sheet.getRow(1).createCell(33).setCellValue("999");
                fos = new FileOutputStream(file);
                workbook.write((OutputStream)fos);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e.getMessage());
            }
        }
        finally {
            fis.close();
            fos.close();
        }
    }

    private int SalePrice(ProductDTO dto, ShopMelchiAdditionalDto dtllist) throws Exception {
        int salePrice = 0;
        try {
            int limit_price;
            ResultMarketPrice resultMarketPrice;
            salePrice = YDMAStringUtil.convertToInt(dto.getGoods_cost());
            int deliveryFee = 0;
            if (dtllist.getFreeDelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDELIVERYCOST();
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice += deliveryFee;
            }
            if ((long)salePrice > YDMAStringUtil.convertToLong((resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price()), salePrice)).getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception e) {
            throw new Exception("\uae30\ubcf8\ud310\ub9e4\uac00 \uacc4\uc0b0\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4." + e);
        }
        return Integer.parseInt(dto.getGoods_price());
    }

    private boolean ExcelUpload(File file, Map<String, String> cookies, String userCode) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/product/import/upload/procAjax").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36").header("Host", "scm.smelchi.com").header("Content-Type", "multipart/form-data;").data("userCd", userCode).data("xlsFile", file.getName(), (InputStream)fis).cookies(cookies).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = parser.parse(body).getAsJsonObject();
            String isSuccess = object.get("message").getAsString();
            return isSuccess.contains("\ucc98\ub9ac");
            {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        finally {
            fis.close();
            file.delete();
        }
    }

    private String GetUploadProduct(Map<String, String> cookies, ProductDTO dto) throws Exception {
        try {
            Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/product/import/list").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36").header("Host", "scm.smelchi.com").cookies(cookies).method(Connection.Method.GET).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            Document doc = Jsoup.parse((String)response.body());
            Elements prodTable = doc.select("#table_style04 > tbody > tr");
            for (Element prod : prodTable) {
                Elements prodDatas = prod.select("td");
                if (!((Element)prodDatas.get(3)).text().equals(dto.getCompayny_goods_cd())) continue;
                return ((Element)prodDatas.get(0)).getElementsByTag("input").attr("value");
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private String getStringParam(String prodSeq) {
        StringBuilder sb = new StringBuilder();
        sb.append("cateCd=&returnUrl=%2Fproduct%2Fimport%2Flist%3Fpage%3D1%26page%3D1%26changeCategory1%3D%26changeCategory2%3D%26changeCategory3%3D%26changeCategory4%3D%26date1%3D%26date2%3D%26cateNm1%3D%26cateNm2%3D%26cateNm3%3D%26cateNm4%3D%26enterType%3D%26searchField%3D%26searchValue%3D%26listCountType%3D01%26imageViewFlag%3DY&seq=");
        sb.append(prodSeq);
        return sb.toString();
    }

    private void productRegSend(Map<String, String> cookies, String strParam, ProductDTO dto) throws Exception {
        block4: {
            try {
                Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/product/import/add").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36").header("Host", "scm.smelchi.com").header("Connection", "keep-alive").header("Origin", "https://scm.smelchi.com").header("Content-Type", "application/x-www-form-urlencoded").header("Content-Length", Integer.toString(strParam.length())).header("Referer", "https://scm.smelchi.com/product/import/list").requestBody(strParam).cookies(cookies).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
                Document doc = Jsoup.parse((String)response.body());
                String body = ((Element)doc.select("script").get(0)).html();
                String success = body.substring(body.indexOf("\uc131\uacf5"), body.indexOf("/ \uc2e4\ud328")).replace(" ", "").split(":")[1];
                Thread.sleep(5000L);
                if (success.equals("1")) {
                    String prodNo = MelchiExitsProductCd.get().getisExistsProdNo(dto.getCompayny_goods_cd(), cookies);
                    if (!prodNo.equals("")) {
                        dto.setShopprodno(prodNo);
                        dto.setResult_code("1");
                    }
                    break block4;
                }
                dto.setResult_code("-1");
                throw new Exception("\uc0c1\ud488\uc744 \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e.getMessage());
            }
        }
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }
}

