/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.data.excel;

import com.kdjsystem.mlink.yellim.common.YDMAPluginUtils;
import com.kdjsystem.mlink.yellim.data.excel.MyExcelManager;
import com.kdjsystem.mlink.yellim.data.excel.MyExcelManagerImple;
import com.kdjsystem.mlink.yellim.data.excel.MyXLSXExcelManagerImple;
import java.io.FileNotFoundException;
import org.eclipse.swt.widgets.FileDialog;

public class MyDataManagerFactory {
    private static MyDataManagerFactory factory;

    private MyDataManagerFactory() {
        factory = this;
    }

    public static MyDataManagerFactory getInstance() {
        if (factory == null) {
            new MyDataManagerFactory();
        }
        return factory;
    }

    public static MyExcelManager createExcelManager(String fileURI) throws FileNotFoundException {
        if (fileURI.contains(".xls")) {
            return new MyExcelManagerImple(fileURI);
        }
        if (fileURI.contains(".xlsx")) {
            return new MyXLSXExcelManagerImple(fileURI);
        }
        return null;
    }

    public static FileDialog createExcelFileSaveDialog() {
        FileDialog dialog = new FileDialog(YDMAPluginUtils.getShell(), 8192);
        String[] filters = new String[]{"*.xlsx", "*.xls"};
        dialog.setFilterExtensions(filters);
        return dialog;
    }

    public static FileDialog createExcelFileSelectionDialog() {
        FileDialog dialog = new FileDialog(YDMAPluginUtils.getShell(), 4096);
        String[] filters = new String[]{"*.xlsx", "*.xls"};
        dialog.setFilterExtensions(filters);
        return dialog;
    }
}

