/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.zentrade;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.shop.common.ChromeScript;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.zentrade.ZentradeCommon;
import com.kdjsystem.mlink.yellim.shop.zentrade.ZentradeProductDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.Select;

public class ZentradeOrderCommon {
    public static ZentradeOrderCommon instance = new ZentradeOrderCommon();

    private ZentradeOrderCommon() {
    }

    public static ZentradeOrderCommon get() {
        return instance;
    }

    private String getGositype(String type) {
        String value = "";
        switch (type) {
            case "\uc758\ub958": {
                value = "01";
            }
            case "\uad6c\ub450/\uc2e0\ubc1c": {
                value = "02";
            }
            case "\uac00\ubc29": {
                value = "03";
            }
            case "\ud328\uc158\uc7a1\ud654(\ubaa8\uc790/\ubca8\ud2b8/\uc561\uc138\uc11c\ub9ac)": {
                value = "04";
            }
            case "\uce68\uad6c\ub958/\ucee4\ud2bc": {
                value = "05";
            }
            case "\uac00\uad6c(\uce68\ub300/\uc18c\ud30c/\uc2f1\ud06c\ub300/DIY\uc81c\ud488)": {
                value = "06";
            }
            case "\uc601\uc0c1\uac00\uc804(TV\ub958)": {
                value = "07";
            }
            case "\uac00\uc815\uc6a9 \uc804\uae30\uc81c\ud488(\ub0c9\uc7a5\uace0/\uc138\ud0c1\uae30/\uc2dd\uae30\uc138\ucc99\uae30/\uc804\uc790\ub808\uc778\uc9c0)": {
                value = "08";
            }
            case "\uacc4\uc808\uac00\uc804(\uc5d0\uc5b4\ucee8/\uc628\ud48d\uae30)": {
                value = "09";
            }
            case "\uc0ac\ubb34\uc6a9\uae30\uae30(\ucef4\ud4e8\ud130/\ub178\ud2b8\ubd81/\ud504\ub9b0\ud130)": {
                value = "10";
            }
            case "\uad11\ud559\uae30\uae30(\ub514\uc9c0\ud138\uce74\uba54\ub77c/\ucea0\ucf54\ub354)": {
                value = "11";
            }
            case "\uc18c\ud615\uc804\uc790(MP3/\uc804\uc790\uc0ac\uc804 \ub4f1)": {
                value = "12";
            }
            case "\ud734\ub300\ud3f0": {
                value = "13";
            }
            case "\ub0b4\ube44\uac8c\uc774\uc158": {
                value = "14";
            }
            case "\uc790\ub3d9\ucc28\uc6a9\ud488(\uc790\ub3d9\ucc28\ubd80\ud488/\uae30\ud0c0 \uc790\ub3d9\ucc28\uc6a9\ud488)": {
                value = "15";
            }
            case "\uc758\ub8cc\uae30\uae30": {
                value = "16";
            }
            case "\uc8fc\ubc29\uc6a9\ud488": {
                value = "17";
            }
            case "\ud654\uc7a5\ud488": {
                value = "18";
            }
            case "\uadc0\uae08\uc18d/\ubcf4\uc11d/\uc2dc\uacc4\ub958": {
                value = "19";
            }
            case "\uc2dd\ud488(\ub18d\uc218\uc0b0\ubb3c)": {
                value = "20";
            }
            case "\uac00\uacf5\uc2dd\ud488": {
                value = "21";
            }
            case "\uac74\uac15\uae30\ub2a5\uc2dd\ud488": {
                value = "22";
            }
            case "\uc601\uc720\uc544\uc6a9\ud488": {
                value = "23";
            }
            case "\uc545\uae30": {
                value = "24";
            }
            case "\uc2a4\ud3ec\uce20\uc6a9\ud488": {
                value = "25";
            }
            case "\uc11c\uc801": {
                value = "26";
            }
            case "\ud638\ud154/\ud39c\uc158 \uc608\uc57d": {
                value = "27";
            }
            case "\uc5ec\ud589\ud328\ud0a4\uc9c0": {
                value = "28";
            }
            case "\ud56d\uacf5\uad8c": {
                value = "29";
            }
            case "\uc790\ub3d9\ucc28 \ub300\uc5ec \uc11c\ube44\uc2a4(\ub80c\ud130\uce74)": {
                value = "30";
            }
            case "\ubb3c\ud488\ub300\uc5ec \uc11c\ube44\uc2a4(\uc815\uc218\uae30/\ube44\ub370/\uacf5\uae30\uccad\uc815\uae30 \ub4f1)": {
                value = "31";
            }
            case "\ubb3c\ud488\ub300\uc5ec \uc11c\ube44\uc2a4(\uc11c\uc801/\uc720\uc544\uc6a9\ud488/\ud589\uc0ac\uc6a9\ud488 \ub4f1)": {
                value = "32";
            }
            case "\ub514\uc9c0\ud138 \ucf58\ud150\uce20(\uc74c\uc6d0/\uac8c\uc784/\uc778\ud130\ub137 \uac15\uc758 \ub4f1)": {
                value = "33";
            }
            case "\uc0c1\ud488\uad8c/\ucfe0\ud3f0": {
                value = "34";
            }
            case "\uae30\ud0c0\uc7ac\ud654": {
                value = "35";
                break;
            }
            default: {
                value = "35";
            }
        }
        return value;
    }

    public String getProductone(String ContentType, String Authorization, String prodcd) throws IOException {
        String query = String.format("http://api.Zentrade.co.kr/seller/goods/%s", prodcd.replaceAll("ZEN", ""));
        try {
            URL url = new URL(query);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(100000);
            conn.setRequestProperty("Content-Type", ContentType);
            conn.setRequestProperty("Authorization", Authorization);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("GET");
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            String resp = "";
            Throwable throwable = null;
            Object var10_11 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));){
                resp = br.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ((InputStream)in).close();
            conn.disconnect();
            return resp;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private ZentradeProductDto getOrderProductMapping(String result) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ZentradeProductDto ZentradeProductDto2 = null;
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        ZentradeProductDto2 = (ZentradeProductDto)mapper.readValue(result, ZentradeProductDto.class);
        return ZentradeProductDto2;
    }

    public List<ProductItemDto> OrderOneItemSalesNSoldCheck(List<ShopOrderMstDto> list, ShoppingMallDetailDto shopDto) throws Exception {
        ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
        try {
            for (ShopOrderMstDto dto : list) {
                if (!dto.getCompayny_goods_cd().substring(0, 3).equals("ZEN")) {
                    throw new Exception("\uc820\ud2b8\ub808\uc774\ub4dc \uc0c1\ud488\uc774 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud488\ucf54\ub4dc\ub97c \ud655\uc778\ud558\uc2ed\uc2dc\uc624. " + dto.getCompayny_goods_cd());
                }
                String url = "https://www.zentrade.co.kr/shop/proc/product_api.php?&id=" + shopDto.getShoppingid() + "&m_skey=" + shopDto.getApikey() + "&goodsno=" + dto.getCompayny_goods_cd().replaceAll("ZEN", "");
                String result = ZentradeCommon.getXml(url);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ZentradeProductDto.ResponseOrderSearch.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                StringReader sr = new StringReader(result.toString());
                ZentradeProductDto.ResponseOrderSearch result1 = (ZentradeProductDto.ResponseOrderSearch)jaxbUnmarshaller.unmarshal((Reader)sr);
                ProductItemDto item = new ProductItemDto();
                try {
                    int i = 0;
                    while (i < Integer.parseInt(result1.product.status.pcnt)) {
                        item.setSearch("shop9995");
                        item.setIcode("ZEN" + result1.product.code.trim());
                        item.setCid(result1.product.dome_category.dome_catecode.trim());
                        item.setCateg_nm(result1.product.dome_category.dome_category.trim());
                        item.setCate_depth(String.valueOf(result1.product.dome_category.dome_category.trim().split(">").length));
                        item.setIname(result1.product.prdtname.trim());
                        item.setIcountry(result1.product.baseinfo.madein.trim());
                        item.setMaker(result1.product.baseinfo.productcom.trim());
                        String[] img = new String[]{result1.product.listimg.url1, result1.product.listimg.url2, result1.product.listimg.url3, result1.product.listimg.url4, result1.product.listimg.url5};
                        item.setImg(img);
                        item.setContent(result1.product.content.trim());
                        String oplist = result1.product.option.option.trim();
                        if (!oplist.equals("")) {
                            String[] opArr = oplist.split("<p align=center>");
                            StringBuffer sb = new StringBuffer();
                            sb.append("[" + result1.product.option.opt1nm + "]\n");
                            String[] arr = opArr[0].split("\\^");
                            sb.append(arr[0].concat("==").concat(arr[2]).concat("=0=0=").concat(result1.product.status.runout.equals("0") ? "0" : "1").concat("\n"));
                            int j = 1;
                            while (j < opArr.length - 1) {
                                opArr[j] = opArr[j].substring(opArr[j].lastIndexOf("\u2191") + 1).trim();
                                arr = opArr[j].split("\\^");
                                sb.append(arr[0].concat("==").concat(arr[2]).concat("=0=0=").concat(result1.product.status.runout.equals("0") ? "0" : "1").concat("\n"));
                                ++j;
                            }
                            item.setSelect_option(sb.toString());
                            item.setText_option("");
                        }
                        item.setBrand(result1.product.baseinfo.brand.trim());
                        item.setTax(result1.product.price.taxmode.trim().equals("N") ? "1" : "0");
                        item.setAdult("0");
                        item.setItype("0");
                        item.setPrice(result1.product.price.buyprice.trim());
                        item.setPrice_consumer(result1.product.price.consumerprice.trim());
                        item.setDelivery_amount("3000");
                        item.setKeyword(result1.product.keyword.trim());
                        item.setReg_datetime(YDMATimeUtil.getCurrentTimeByYDFormat());
                        item.setUp_datetime(YDMATimeUtil.getCurrentTimeByYDFormat());
                        item.setStatus(result1.product.status.runout.equals("0") ? "0" : "1");
                        item.setCert_type("2");
                        item.setCert_no("");
                        item.setCert("");
                        item.setVender_code("");
                        ++i;
                    }
                }
                catch (Exception ex) {
                    throw new Exception(ex);
                }
                items.add(item);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return items;
    }

    public List<ProductItemDto> getOrderdatas(List<ShopOrderMstDto> list, ShoppingMallDetailDto dto) throws Exception {
        ArrayList<ProductItemDto> datasource = new ArrayList();
        datasource = this.OrderOneItemSalesNSoldCheck(list, dto);
        return datasource;
    }

    public void OrderListComplate(List<ShopOrderMstDto> list, ShoppingMallDetailDto shopdto) throws Exception {
        ChromeDriver driver = IShopCommonLogin.loginZentrade(shopdto.getShoppingid(), shopdto.getPassword(), shopdto.getShopcd(), true);
        ChromeScript.get().getCookies(driver);
        int page = 0;
        int order = 0;
        Map<String, Map<String, List<ShopOrderMstDto>>> mapList = list.stream().filter(d -> d.getDosinstatus() != null && !d.getDosinstatus().equals("\ud488\uc808")).collect(Collectors.groupingBy(ShopOrderMstDto::getReceive_addr, Collectors.groupingBy(ShopOrderMstDto::getVendorId)));
        CommonProgressDialog.get().setValue("\ud488\uc808\uc0c1\ud488 \ubc0f \ub3d9\uc77c\ubc30\uc1a1\uc9c0 \uc81c\uc678 " + mapList.size() + "\uac74\uc758 \uc8fc\ubb38\uc815\ubcf4 \uc804\uc1a1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4", 0);
        List<Object> datas = new ArrayList();
        for (String addr : mapList.keySet()) {
            try {
                Map<String, List<ShopOrderMstDto>> map = mapList.get(addr);
                for (String vendorId : map.keySet()) {
                    datas = map.get(vendorId);
                    for (ShopOrderMstDto shopOrderMstDto : datas) {
                        String string = String.format("https://www.zentrade.co.kr/shop/goods/goods_view.php?goodsno=%s", shopOrderMstDto.getCompayny_goods_cd().replace("ZEN", ""));
                        ChromeScript.get().get(driver, string);
                        if (shopOrderMstDto.getP_sku_value2() == null || shopOrderMstDto.getP_sku_value2().equals("")) {
                            shopOrderMstDto.setP_sku_value2("");
                            driver.executeScript(String.format("document.getElementsByName(\"ea\")[0].value = \"%s\"", shopOrderMstDto.getSale_cnt()), new Object[0]);
                        } else {
                            Select elm = new Select(driver.findElement(By.name((String)"opt[]")));
                            elm.selectByValue(shopOrderMstDto.getP_sku_value2());
                            String str = String.format("document.getElementsByName(\"_multi_ea[]\")[0].value = \"%s\" ", shopOrderMstDto.getSale_cnt());
                            StringBuilder sb = new StringBuilder();
                            sb.append("(()=>{ \r\n");
                            sb.append(str);
                            sb.append("\r\n document.getElementsByName(\"_multi_ea[]\")[0].onblur();");
                            sb.append("})(); ");
                            driver.executeScript(sb.toString(), new Object[0]);
                        }
                        driver.executeScript("cartAdd(frmView,'Confirm');", new Object[]{""});
                    }
                }
                driver.executeScript("location.href='/shop/goods/goods_cart.php?&'", new Object[]{""});
                Thread.sleep(2000L);
                driver.executeScript("nsGodo_CartAction.order();", new Object[]{""});
                Thread.sleep(2000L);
                driver.findElement(By.name((String)"nameReceiver")).sendKeys(new CharSequence[]{((ShopOrderMstDto)datas.get(0)).getReceive_name()});
                driver.findElement(By.id((String)"idx_addr_type02")).sendKeys(new CharSequence[]{"value here"});
                driver.findElement(By.name((String)"zipcode_i")).sendKeys(new CharSequence[]{((ShopOrderMstDto)datas.get(0)).getReceive_zipcode()});
                String addr2 = ((ShopOrderMstDto)datas.get(0)).getReceive_detail() == null ? "" : ((ShopOrderMstDto)datas.get(0)).getReceive_detail();
                driver.findElement(By.name((String)"address_i")).sendKeys(new CharSequence[]{String.valueOf(((ShopOrderMstDto)datas.get(0)).getReceive_addr()) + " " + addr2});
                String phone = ((ShopOrderMstDto)datas.get(0)).getReceive_cel().equals("") ? ((ShopOrderMstDto)datas.get(0)).getReceive_tel() : ((ShopOrderMstDto)datas.get(0)).getReceive_cel();
                String string = ((ShopOrderMstDto)datas.get(0)).getReceive_tel().equals("") ? ((ShopOrderMstDto)datas.get(0)).getReceive_cel() : ((ShopOrderMstDto)datas.get(0)).getReceive_tel();
                driver.findElement(By.name((String)"phoneReceiver")).sendKeys(new CharSequence[]{string});
                driver.findElement(By.name((String)"mobileReceiver")).sendKeys(new CharSequence[]{phone});
                driver.findElement(By.name((String)"memo")).sendKeys(new CharSequence[]{((ShopOrderMstDto)datas.get(0)).getDelv_msg() == null ? "" : ((ShopOrderMstDto)datas.get(0)).getDelv_msg()});
                driver.findElement(By.name((String)"pordno")).sendKeys(new CharSequence[]{((ShopOrderMstDto)datas.get(0)).getOrder_id()});
                driver.executeScript("reserve_use();", new Object[]{""});
                Thread.sleep(2000L);
                driver.executeScript("document.frmOrder.submit()", new Object[]{""});
                Thread.sleep(2000L);
                driver.executeScript("submitSettleForm();", new Object[0]);
                Thread.sleep(5000L);
                String odno = driver.findElement(By.cssSelector((String)"b.blue")).getText();
                if (!odno.equals("") | odno != null) {
                    if (!odno.equals("")) {
                        for (ShopOrderMstDto shopOrderMstDto : datas) {
                            shopOrderMstDto.setDosinOrder_code(odno);
                            shopOrderMstDto.setOrder_status("500");
                            shopOrderMstDto.setResult_code("1");
                            shopOrderMstDto.setDs_order_status("\ub3c4\ub9e4\uc2e0\uaddc");
                            YDMAStringUtil.convertToInt(shopOrderMstDto.getDsGoods_cost());
                            YDMAStringUtil.convertToInt(shopOrderMstDto.getDsdelv_cost());
                            YDMAStringUtil.convertToInt(shopOrderMstDto.getSale_cnt());
                            ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
                            retList.add(shopOrderMstDto);
                            ShopOrderDao.get().SaveOrUpdate(retList);
                            ++order;
                            CommonProgressDialog.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc8fc\ubb38\ubc88\ud638 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", shopOrderMstDto.getReceive_name(), shopOrderMstDto.getDosinOrder_code(), shopOrderMstDto.getCompayny_goods_cd(), shopOrderMstDto.getSale_cnt(), "\uc8fc\ubb38\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \uc811\uc218 \ub418\uc5c8\uc2b5\ub2c8\ub2e4."), ++page);
                        }
                        continue;
                    }
                    for (ShopOrderMstDto shopOrderMstDto : datas) {
                        CommonProgressDialog.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", shopOrderMstDto.getReceive_name(), shopOrderMstDto.getCompayny_goods_cd(), shopOrderMstDto.getSale_cnt(), odno), page);
                        shopOrderMstDto.setResult_code("-1");
                    }
                    continue;
                }
                for (ShopOrderMstDto shopOrderMstDto : datas) {
                    CommonProgressDialog.get().setValue(String.format("\uc218\ucde8\uc778\uba85 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", shopOrderMstDto.getReceive_name(), shopOrderMstDto.getCompayny_goods_cd(), shopOrderMstDto.getSale_cnt(), "\uc8fc\ubb38\uc804\uc1a1\uc744 \ud558\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4."), page);
                    shopOrderMstDto.setResult_code("-1");
                }
            }
            catch (Exception e) {
                CommonProgressDialog.get().setValue("\uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. " + e.getMessage(), page);
            }
        }
        CommonProgressDialog.get().setValue("---------------------------------------------------------------------------------------", page);
        CommonProgressDialog.get().setValue(String.format("[\uc804\uccb4\uacb0\uacfc] \uc8fc\ubb38 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4. \uc8fc\ubb38\uac74\uc774 \ub2e4\ub97c \uacbd\uc6b0 \ubb38\uc758\ubc14\ub78d\ub2c8\ub2e4.", order), page);
    }

    private void deleteOrdercart(Map<String, String> cookies) throws Exception {
        try {
            Document doc = Jsoup.connect((String)"http://www.Zentrade.co.kr/mall/order/cart.php").cookies(cookies).get();
            Elements hiddens = doc.select("input[type=hidden]");
            Map<String, String> hidden = ChromeScript.get().getElementIdOrValue(hiddens);
            YDMAStringUtil.Print(hidden);
            YDMAStringUtil.Print();
        }
        catch (Exception exception) {
            throw new Exception("\uc7a5\ubc14\uad6c\ub2c8 \uc0ad\uc81c\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    public List<ShopOrderMstDto> OrderListComplateCallBack(List<ShopOrderMstDto> list, ShoppingMallDetailDto shopdto) {
        int page = 0;
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        new ArrayList();
        try {
            ChromeDriver driver = IShopCommonLogin.loginZentrade(shopdto.getShoppingid(), shopdto.getPassword(), shopdto.getShopcd(), true);
            Map<String, String> cookies = ChromeScript.get().getCookies(driver);
            for (ShopOrderMstDto dto : list) {
                List<ShopDeliveryDto> datasource = ShopCommonDao.get().getExpress(dto.getShopid());
                Connection.Response response_Search = Jsoup.connect((String)"http://www.Zentrade.co.kr/mall/mypage/indb/order.list.indb.php").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").header("Origin", "http://www.Zentrade.co.kr").data("page", "").data("search_key", "ordno").data("search_str", dto.getDosinOrder_code()).data("datetype", "date_ord").data("sdate", dto.getStartDt()).data("edate", dto.getEndDt()).data("step[]", "").referrer("http://www.Zentrade.co.kr/mall/mypage/order_list.php").method(Connection.Method.POST).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                Document body = Jsoup.parseBodyFragment((String)response_Search.body());
                Elements eles = body.select("table > tbody > tr:nth-child(2)");
                int i = 0;
                while (i < eles.size()) {
                    Elements datas = ((Element)eles.get(i)).select("td.txt-center > span");
                    if (datas.size() > 0) {
                        dto.setOrder_status(this.getStatus(((Element)datas.get(0)).text()));
                        dto.setDs_order_status(this.getDsstatus(((Element)datas.get(0)).text()));
                        if (dto.getOrder_status().equals("501")) {
                            dto.setDelivery_id("");
                            dto.setInvoice_no("");
                        } else if (dto.getOrder_status().equals("402") && datas.size() > 1) {
                            String delv = ((Element)datas.get(1)).text();
                            ShopDeliveryDto delvname = null;
                            delvname = dto.getShopid().equals("shop0003") && delv.equals("\ud3b8\uc758\uc810\ud0dd\ubc30") || dto.getShopid().equals("shop0003") && delv.equals("CU\ud3b8\uc758\uc810\ud0dd\ubc30") ? datasource.stream().filter(d -> d.getDs_code().equals(delv.trim())).findAny().get() : datasource.stream().filter(d -> d.getDs_code().contains(delv.trim())).findAny().get();
                            dto.setDelivery_id(delvname.getDlvID());
                            String invoiceno = ((Element)datas.get(1)).attr("onclick");
                            dto.setInvoice_no(invoiceno.substring(invoiceno.indexOf("(") + 1, invoiceno.lastIndexOf(")")));
                        }
                        CommonProgressDialog.get().setValue(String.format("\uc8fc\ubb38\ucf54\ub4dc : %s \uc218\ucde8\uc778\uba85 : %s \ub3c4\ub9e4\ubab0\uc0c1\ud0dc :%s ", dto.getDosinOrder_code(), dto.getReceive_name(), ((Element)datas.get(0)).text()), ++page);
                        dto.setResult_code("1");
                    }
                    ++i;
                }
                ret.add(dto);
            }
            CommonProgressDialog.get().setValue("---------------------------------------------------------------------------------------", page);
            CommonProgressDialog.get().setValue(String.format("[\uc804\uccb4\uacb0\uacfc] \ub3d9\uae30\ud654 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4. \ub3d9\uae30\ud654\uac74\uc774 \ub2e4\ub97c \uacbd\uc6b0 \ubb38\uc758\ubc14\ub78d\ub2c8\ub2e4.", page), page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private String getDsstatus(String dsstatus) {
        String value = "";
        switch (dsstatus) {
            case "\uc785\uae08\uc644\ub8cc": {
                value = "\ud22c\ube44\uc2e0\uaddc";
                break;
            }
            case "\ubc30\uc1a1\uc900\ube44": {
                value = "\ud22c\ube44\uc900\ube44";
                break;
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                value = "\ubc1c\uc1a1\uc644\ub8cc";
                break;
            }
            default: {
                value = dsstatus;
            }
        }
        return value;
    }

    private String getStatus(String status2) {
        switch (status2) {
            case "\uc785\uae08\uc644\ub8cc": {
                return "500";
            }
            case "\ubc30\uc1a1\uc900\ube44": {
                return "501";
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                return "402";
            }
            case "\ucde8\uc18c\uc694\uccad": {
                return "503";
            }
            case "\ucde8\uc18c\uc9c4\ud589": {
                return "503";
            }
            case "\ucde8\uc18c\uc644\ub8cc": {
                return "503";
            }
            case "\ubc18\ud488\uc694\uccad": {
                return "503";
            }
            case "\ubc18\ud488\uc9c4\ud589": {
                return "503";
            }
            case "\ubc18\ud488\uc644\ub8cc": {
                return "503";
            }
            case "\uad50\ud658\uc694\uccad": {
                return "503";
            }
            case "\uad50\ud658\uc9c4\ud589": {
                return "503";
            }
            case "\uad50\ud658\uc644\ub8cc": {
                return "503";
            }
        }
        return "";
    }
}

