/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.ui;

import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.controls.ComboItem;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.ui.BackJobObserver;
import com.kdjsystem.mlink.yellim.ui.BackJobObserverable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class DomeWorkDataQueue
implements BackJobObserverable {
    private static DomeWorkDataQueue instance = new DomeWorkDataQueue();
    private ArrayList<BackJobObserver> observers;
    ExecutorService executorService;
    Map<String, ComboItem> queueDome = new LinkedHashMap<String, ComboItem>();
    Map<String, Map<String, List<ShoppingMallDetailDto>>> queueShop = new LinkedHashMap<String, Map<String, List<ShoppingMallDetailDto>>>();

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void stopExecutorService() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    YDMAStringUtil.Print("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private DomeWorkDataQueue() {
        int corePoolSize = 1;
        int maximumPoolSize = 1;
        long keepAliveTime = 3L;
        TimeUnit unit = TimeUnit.SECONDS;
        this.executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
        this.observers = new ArrayList();
    }

    public static DomeWorkDataQueue get() {
        return instance;
    }

    public void add(ComboItem dome) {
        String grp = dome.getCode();
        this.queueDome.put(grp, dome);
        this.notifyObservers();
    }

    public synchronized List<ComboItem> getAllData() {
        if (this.queueDome.size() == 0) {
            return new ArrayList<ComboItem>();
        }
        return this.queueDome.entrySet().stream().map(p -> (ComboItem)p.getValue()).collect(Collectors.toList());
    }

    public synchronized List<ComboItem> getWaitData() {
        if (this.queueDome.size() == 0) {
            return null;
        }
        List<ComboItem> dome = this.queueDome.entrySet().stream().map(p -> (ComboItem)p.getValue()).collect(Collectors.toList());
        if (dome == null) {
            return null;
        }
        return dome;
    }

    @Override
    public void addObserver(BackJobObserver o) {
        this.observers.add(o);
    }

    @Override
    public void deleteObserver(BackJobObserver o) {
        int i = this.observers.indexOf(o);
        if (i >= 0) {
            this.observers.remove(i);
        }
    }

    @Override
    public void notifyObservers() {
        int i = 0;
        while (i < this.observers.size()) {
            BackJobObserver observer = this.observers.get(i);
            observer.update(this);
            ++i;
        }
    }

    private static class DataFlatMap {
        private String grp;

        public DataFlatMap(String grp) {
            this.grp = grp;
        }
    }
}

