/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dao.CategoryDAO;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.CategoryDTO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductAddProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductAddProcess;
import com.kdjsystem.mlink.yellim.helper.DateHelper;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAddDialog;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class AlwayzProductAddService
implements IProductAddProcess {
    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto) throws Exception {
        boolean flag = true;
        int page = 0;
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String beginText = String.format(String.valueOf(DateHelper.getCurrentTimeString()) + "[%s - %s]\r\n", shopInfo.getSHOPNM(), shopInfo.getNICKNM1());
        this.setValue(beginText.concat("\uc1fc\ud551\ubab0\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4."), 0);
        OkHttpClient client = new OkHttpClient();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = new JsonObject();
        try {
            AddInfo info2 = new AddInfo();
            info2.condition.type = "item";
            info2.condition.itemCondition.createdAt.greaterThan = this.dateFormat1(dto.getSTART_DATE());
            info2.condition.itemSortCondition.createdAt = -1;
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString((Object)info2);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)json);
            Request request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/v2/count-request").header("Connection", "keep-alive").header("x-access-token", shopInfo.getAPIKEY()).header("Content-Type", "application/json").header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").post(requestBody).build();
            Response response = client.newCall(request2).execute();
            String responseBody = "";
            if (!response.isSuccessful()) {
                this.setValue("\uc120\ud0dd \ud55c \ub0a0\uc9dc\uc5d0 \ub370\uc774\ud130 \uac1c\uc218\ub97c \ucc3e\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd ERROR CODE : [ " + response.code() + " ] \uc7a0\uc2dc\ud6c4\uc5d0 \uc2dc\ub3c4\ud558\uc138\uc694 ", 0);
                return new ResultProcessDTO(0, "", infoRet, inRet);
            }
            responseBody = response.body().string();
            jsonObject = (JsonObject)jsonParser.parse(responseBody);
            int dataCount = jsonObject.get("data").getAsInt();
            if (dataCount == 0) {
                this.setValue("\uc120\ud0dd \ud55c \ub0a0\uc9dc\uc5d0 \ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.. \uc885\ub8cc\ud569\ub2c8\ub2e4", 100);
                return new ResultProcessDTO(0, "", infoRet, inRet);
            }
            this.setValue("\uc120\ud0dd \ud55c \ub0a0\uc9dc\uc5d0 \ub370\uc774\ud130\uac00 " + dataCount + "\uac74 \uc774\uba70, \uc218\uc9d1 \uc2dc\uc791\ud569\ub2c8\ub2e4.", 0);
            while (flag) {
                AddInfo info = new AddInfo();
                info.condition.type = "item";
                info.condition.itemCondition.createdAt.greaterThan = this.dateFormat1(dto.getSTART_DATE());
                info.condition.itemSortCondition.createdAt = -1;
                info.page = ++page;
                info.pageLimit = 20;
                json = mapper.writeValueAsString((Object)info);
                requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)json);
                request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/v2/list-request").header("Connection", "keep-alive").header("x-access-token", shopInfo.getAPIKEY()).header("Content-Type", "application/json").header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").post(requestBody).build();
                response = client.newCall(request2).execute();
                if (response.isSuccessful()) {
                    responseBody = response.body().string();
                }
                try {
                    jsonObject = (JsonObject)jsonParser.parse(responseBody);
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    YDMAStringUtil.Print("Malformed JSON \uc751\ub2f5: " + responseBody);
                    continue;
                }
                int status2 = jsonObject.get("status").getAsInt();
                if (status2 == 2000) {
                    JsonObject data2 = (JsonObject)jsonObject.get("data");
                    JsonArray itemsInfo = (JsonArray)data2.get("itemsInfo");
                    if (itemsInfo.size() <= 0) continue;
                    ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                    int i = 0;
                    while (i < itemsInfo.size()) {
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        JsonObject product2 = (JsonObject)itemsInfo.get(i);
                        String recommendItemCode = product2.has("recommendItemCode") && !product2.get("recommendItemCode").isJsonNull() ? product2.get("recommendItemCode").getAsString() : "";
                        String str = recommendItemCode.equals("") ? product2.get("itemTitle").getAsString() : recommendItemCode;
                        this.setValue(beginText.concat(" '" + str + "' \ubd88\ub7ec\uc624\ub294 \uc911..."), 0);
                        ProductDTO responseProduct = new ProductDTO();
                        responseProduct.setShopprodno(product2.get("_id").getAsString());
                        responseProduct.setGoods_nm(product2.get("itemTitle").getAsString());
                        responseProduct.setCompayny_goods_cd(recommendItemCode);
                        responseProduct.setStatus(!product2.get("soldOut").getAsBoolean() ? "0" : "1");
                        responseProduct.setSendstats(product2.get("soldOut").getAsBoolean() ? String.valueOf(4000) : String.valueOf(8000));
                        if (!recommendItemCode.equals("")) {
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(responseProduct.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            responseProduct.setGoods_keyword(codeDivision);
                        }
                        CategoryDTO category = this.getCategory(product2, shopInfo.getAPIKEY());
                        responseProduct.setClass_cd3(category.getCODE());
                        responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                        responseProduct.setGmcategnm(category.getFULL_NAME());
                        responseProduct.setInsertdt(this.dateFormat2(product2.get("createdAt").getAsString()));
                        responseProduct.setMarket_price(product2.get("individualPurchasePrice").getAsString());
                        responseProduct.setGoods_price(product2.get("individualPurchasePrice").getAsString());
                        responseProduct.setGoods_consumer_price(product2.get("individualPurchasePrice").getAsString());
                        responseProduct.setShopcd(shopInfo.getSHOPCD());
                        responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                        responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
                        String[] code = new String[]{"W", "F", "TS", "OH", "DS", "DMM", "HS", "3MRO", "ZEN", "CH"};
                        List<String> codeCheck = Arrays.asList(code);
                        String companyGoodsCd = responseProduct.getCompayny_goods_cd();
                        if (companyGoodsCd.equals("")) {
                            responseProduct.setCompayny_goods_cd(responseProduct.getShopprodno());
                        } else {
                            boolean isValidCode = false;
                            int j = 1;
                            while (j <= 4 && j <= companyGoodsCd.length()) {
                                if (codeCheck.contains(companyGoodsCd.substring(0, j))) {
                                    isValidCode = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!isValidCode) {
                                responseProduct.setCompayny_goods_cd(responseProduct.getShopprodno());
                            }
                        }
                        JsonObject optionsInfo = (JsonObject)product2.get("optionsInfo");
                        List<ProductOptionDTO> options = this.getOption(responseProduct, optionsInfo);
                        responseProduct.setOPTIONS(options);
                        String[] optionNames = options.stream().map(p -> p.getOPTPRODNM()).findFirst().orElse("").split(":");
                        if (optionNames.length == 1) {
                            responseProduct.setChar_1_nm(optionNames[0]);
                        } else if (optionNames.length == 2) {
                            responseProduct.setChar_1_nm(optionNames[0]);
                            responseProduct.setChar_2_nm(optionNames[1]);
                        }
                        responseProducts.add(responseProduct);
                        ++i;
                    }
                    if (responseProducts.size() > 0) {
                        this.setValue(beginText.concat(String.valueOf(page) + " \ubc88\uc9f8 " + responseProducts.size() + "\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4..."), 0);
                    }
                    for (ProductDTO product3 : responseProducts) {
                        int ret;
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            ret = ProductDAO.get().insertProductInfo(product3);
                            if (ret == 1) {
                                infoRet += ret;
                            }
                        } else {
                            copyProduct.setClass_cd3(product3.getClass_cd3());
                            copyProduct.setShop_cid_info(product3.getShop_cid_info());
                            ret = ProductDAO.get().updateProductInfo(copyProduct);
                            if (ret == 1) {
                                infoRet += ret;
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product3.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret2 = ProductDAO.get().insertProductIn(product3);
                            if (ret2 == 1) {
                                inRet += ret2;
                            }
                        } else {
                            copyProductIn.setClass_cd3(product3.getClass_cd3());
                            copyProductIn.setShop_cid_info(product3.getShop_cid_info());
                            copyProductIn.setGoods_nm(product3.getGoods_nm());
                            copyProductIn.setShopprodno(product3.getShopprodno());
                            copyProductIn.setDelv_r_cost(product3.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product3.getSaleenddt());
                            copyProductIn.setMarket_price(product3.getMarket_price());
                            copyProductIn.setGoods_price(product3.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product3.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product3.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product3.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product3.getStdPrdYn());
                            copyProductIn.setStatus(product3.getStatus());
                            copyProductIn.setSendstats(product3.getSendstats());
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product3.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                            if (ret3 == 1) {
                                inRet += ret3;
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product3.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product3.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                        }
                    }
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage() != null ? e.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            this.setValue(beginText.concat(errorMessage), 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        this.setValue(beginText.concat("\ucd1d " + inRet + "\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4."), 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto, List<String> specificCodes) throws Exception {
        block30: {
            flag = true;
            infoRet = 0;
            inRet = 0;
            page = 0;
            shopInfo = dto.getSHOPINFO();
            domemallInfos = DomemallDAO.get().selectDomemallInfos();
            beginText = String.format(String.valueOf(DateHelper.getCurrentTimeString()) + "[%s - %s]\r\n", new Object[]{shopInfo.getSHOPNM(), shopInfo.getNICKNM1()});
            this.setValue(beginText.concat("\uc1fc\ud551\ubab0\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4."), 0);
            client = new OkHttpClient();
            jsonParser = new JsonParser();
            jsonObject = new JsonObject();
            mapper = new ObjectMapper();
lbl13:
            // 2 sources

            try {
                while (flag) {
                    block31: {
                        partitionedList = this.splitList(specificCodes, 20);
                        if (++page > partitionedList.size()) break block30;
                        info = new AddInfoByWord();
                        AddInfoByWord.Condition.access$1(AddInfoByWord.access$0(info), "item");
                        AddInfoByWord.CreatedAt.access$1(AddInfoByWord.ItemCondition.access$1(AddInfoByWord.Condition.access$2(AddInfoByWord.access$0(info))), this.dateFormat1(dto.getSTART_DATE()));
                        AddInfoByWord.RecommedItemCode.access$1(AddInfoByWord.ItemCondition.access$2(AddInfoByWord.Condition.access$2(AddInfoByWord.access$0(info))), partitionedList.get(page - 1));
                        AddInfoByWord.ItemSortCondition.access$1(AddInfoByWord.Condition.access$3(AddInfoByWord.access$0(info)), -1);
                        AddInfoByWord.access$1(info, 1);
                        AddInfoByWord.access$2(info, 20);
                        json = mapper.writeValueAsString((Object)info);
                        requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)json);
                        request = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/v2/list-request").header("Connection", "keep-alive").header("x-access-token", shopInfo.getAPIKEY()).header("Content-Type", "application/json").post(requestBody).build();
                        response = client.newCall(request).execute();
                        responseBody = "";
                        if (response.isSuccessful()) {
                            responseBody = response.body().string();
                        }
                        if ((status = (jsonObject = (JsonObject)jsonParser.parse(responseBody)).get("status").getAsInt()) != 2000) break block31;
                        data = (JsonObject)jsonObject.get("data");
                        itemsInfo = (JsonArray)data.get("itemsInfo");
                        if (itemsInfo.size() <= 0) continue;
                        responseProducts = new ArrayList<ProductDTO>();
                        i = 0;
                        while (i < itemsInfo.size()) {
                            if (ProductAddDialog.getIsCanceled()) {
                                return new ResultProcessDTO(0, "", infoRet, inRet);
                            }
                            product = (JsonObject)itemsInfo.get(i);
                            recommendItemCode = product.has("recommendItemCode") != false && product.get("recommendItemCode").isJsonNull() == false ? product.get("recommendItemCode").getAsString() : "";
                            str = recommendItemCode.equals("") != false ? product.get("itemTitle").getAsString() : recommendItemCode;
                            this.setValue(beginText.concat(" '" + str + "' \ubd88\ub7ec\uc624\ub294 \uc911..."), 0);
                            responseProduct = new ProductDTO();
                            responseProduct.setShopprodno(product.get("_id").getAsString());
                            responseProduct.setGoods_nm(product.get("itemTitle").getAsString());
                            responseProduct.setCompayny_goods_cd(recommendItemCode);
                            responseProduct.setStatus(product.get("soldOut").getAsBoolean() == false ? "0" : "1");
                            responseProduct.setSendstats(product.get("soldOut").getAsBoolean() != false ? String.valueOf(4000) : String.valueOf(8000));
                            if (!recommendItemCode.equals("")) {
                                codeDivision = domemallInfos.stream().filter((Predicate<DomemallDTO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$5(com.kdjsystem.mlink.yellim.dto.ProductDTO com.kdjsystem.mlink.yellim.dto.DomemallDTO ), (Lcom/kdjsystem/mlink/yellim/dto/DomemallDTO;)Z)((ProductDTO)responseProduct)).map((Function<DomemallDTO, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$6(com.kdjsystem.mlink.yellim.dto.DomemallDTO ), (Lcom/kdjsystem/mlink/yellim/dto/DomemallDTO;)Ljava/lang/String;)()).findFirst().orElse("");
                                responseProduct.setGoods_keyword(codeDivision);
                            }
                            category = this.getCategory(product, shopInfo.getAPIKEY());
                            responseProduct.setClass_cd3(category.getCODE());
                            responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                            responseProduct.setGmcategnm(category.getFULL_NAME());
                            responseProduct.setInsertdt(this.dateFormat2(product.get("createdAt").getAsString()));
                            responseProduct.setMarket_price(product.get("individualPurchasePrice").getAsString());
                            responseProduct.setGoods_price(product.get("individualPurchasePrice").getAsString());
                            responseProduct.setGoods_consumer_price(product.get("individualPurchasePrice").getAsString());
                            responseProduct.setShopcd(shopInfo.getSHOPCD());
                            responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                            responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
                            code = new String[]{"W", "F", "TS", "OH", "DS", "DMM", "HS", "3MRO", "ZEN", "CH"};
                            codeCheck = Arrays.asList(code);
                            companyGoodsCd = responseProduct.getCompayny_goods_cd();
                            if (companyGoodsCd.equals("")) {
                                responseProduct.setCompayny_goods_cd(responseProduct.getShopprodno());
                            } else {
                                isValidCode = false;
                                j = 1;
                                while (j <= 4 && j <= companyGoodsCd.length()) {
                                    if (codeCheck.contains(companyGoodsCd.substring(0, j))) {
                                        isValidCode = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!isValidCode) {
                                    responseProduct.setCompayny_goods_cd(responseProduct.getShopprodno());
                                }
                            }
                            optionsInfo = (JsonObject)product.get("optionsInfo");
                            options = this.getOption(responseProduct, optionsInfo);
                            responseProduct.setOPTIONS(options);
                            optionNames = options.stream().map((Function<ProductOptionDTO, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$7(com.kdjsystem.mlink.yellim.dto.ProductOptionDTO ), (Lcom/kdjsystem/mlink/yellim/dto/ProductOptionDTO;)Ljava/lang/String;)()).findFirst().orElse("").split(":");
                            if (optionNames.length == 1) {
                                responseProduct.setChar_1_nm(optionNames[0]);
                            } else if (optionNames.length == 2) {
                                responseProduct.setChar_1_nm(optionNames[0]);
                                responseProduct.setChar_2_nm(optionNames[1]);
                            }
                            responseProducts.add(responseProduct);
                            ++i;
                        }
                        if (responseProducts.size() > 0) {
                            this.setValue(beginText.concat(String.valueOf(page) + " \ubc88\uc9f8 " + responseProducts.size() + "\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4..."), 0);
                        }
                        for (ProductDTO product : responseProducts) {
                            if (ProductAddDialog.getIsCanceled()) {
                                return new ResultProcessDTO(0, "", infoRet, inRet);
                            }
                            copyProduct = ProductDAO.get().selectProductInfo(product.getCompayny_goods_cd());
                            if (copyProduct == null) {
                                ret = ProductDAO.get().insertProductInfo(product);
                                if (ret == 1) {
                                    infoRet += ret;
                                }
                            } else {
                                copyProduct.setClass_cd3(product.getClass_cd3());
                                copyProduct.setShop_cid_info(product.getShop_cid_info());
                                ret = ProductDAO.get().updateProductInfo(copyProduct);
                                if (ret == 1) {
                                    infoRet += ret;
                                }
                            }
                            copyProduct = ProductDAO.get().selectProductInfo(product.getCompayny_goods_cd());
                            copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                            if (copyProductIn == null) {
                                product.setPRODSEQ(copyProduct.getPRODSEQ());
                                ret = ProductDAO.get().insertProductIn(product);
                                if (ret == 1) {
                                    inRet += ret;
                                }
                            } else {
                                copyProductIn.setClass_cd3(product.getClass_cd3());
                                copyProductIn.setShop_cid_info(product.getShop_cid_info());
                                copyProductIn.setGoods_nm(product.getGoods_nm());
                                copyProductIn.setShopprodno(product.getShopprodno());
                                copyProductIn.setDelv_r_cost(product.getDelv_r_cost());
                                copyProductIn.setSaleenddt(product.getSaleenddt());
                                copyProductIn.setMarket_price(product.getMarket_price());
                                copyProductIn.setGoods_price(product.getGoods_price());
                                copyProductIn.setGoods_consumer_price(product.getGoods_consumer_price());
                                copyProductIn.setCompayny_goods_cd(product.getCompayny_goods_cd());
                                copyProductIn.setSaleStatusCd(product.getSaleStatusCd());
                                copyProductIn.setStdPrdYn(product.getStdPrdYn());
                                copyProductIn.setStatus(product.getStatus());
                                copyProductIn.setSendstats(product.getSendstats());
                                codeDivision = domemallInfos.stream().filter((Predicate<DomemallDTO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$8(com.kdjsystem.mlink.yellim.dto.ProductDTO com.kdjsystem.mlink.yellim.dto.DomemallDTO ), (Lcom/kdjsystem/mlink/yellim/dto/DomemallDTO;)Z)((ProductDTO)product)).map((Function<DomemallDTO, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$9(com.kdjsystem.mlink.yellim.dto.DomemallDTO ), (Lcom/kdjsystem/mlink/yellim/dto/DomemallDTO;)Ljava/lang/String;)()).findFirst().orElse("");
                                copyProductIn.setGoods_keyword(codeDivision);
                                ret = ProductDAO.get().updateProductIn(copyProductIn);
                                if (ret == 1) {
                                    inRet += ret;
                                }
                            }
                            copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                            if (product.getOPTIONS() == null) continue;
                            for (ProductOptionDTO option : product.getOPTIONS()) {
                                copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option.getSKUSEQ());
                                if (copyOption == null) {
                                    option.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                    option.setCOMPAYNY_GOODS_CD(product.getCompayny_goods_cd());
                                    ProductDAO.get().insertOptProductInfo(option);
                                } else {
                                    copyOption.setCOMPAYNY_GOODS_CD(product.getCompayny_goods_cd());
                                    copyOption.setOPTPRODCD(option.getOPTPRODCD());
                                    copyOption.setOPTPRODNM(option.getOPTPRODNM());
                                    copyOption.setOPTSPECDES(option.getOPTSPECDES());
                                    copyOption.setOPTEA(option.getOPTEA());
                                    copyOption.setOPTSAFESTOCK(option.getOPTSAFESTOCK());
                                    copyOption.setOPTVERTSTOCK(option.getOPTVERTSTOCK());
                                    copyOption.setOPTADDAMT(option.getOPTADDAMT());
                                    copyOption.setINSERTDT(option.getINSERTDT());
                                    copyOption.setINSERTID(option.getINSERTID());
                                    copyOption.setMODIFYDT(option.getMODIFYDT());
                                    copyOption.setSTATUS(option.getSTATUS());
                                }
                                copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option.getSKUSEQ());
                                if (copyOptionIn == null) {
                                    option.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                    option.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                    ProductDAO.get().insertOptProductIn(option);
                                    continue;
                                }
                                copyOptionIn.setSHOPPRODNO(option.getSHOPPRODNO());
                                copyOptionIn.setSHOPPRODSKU(option.getSHOPPRODSKU());
                                copyOptionIn.setSHOPPRODSKU_NM(option.getSHOPPRODSKU_NM());
                                copyOptionIn.setOPTPRODCD(option.getOPTPRODCD());
                                copyOptionIn.setOPTPRODNM(option.getOPTPRODNM());
                                copyOptionIn.setOPTSPECDES(option.getOPTSPECDES());
                                copyOptionIn.setOPTEA(option.getOPTEA());
                                copyOptionIn.setOPTSAFESTOCK(option.getOPTSAFESTOCK());
                                copyOptionIn.setOPTVERTSTOCK(option.getOPTVERTSTOCK());
                                copyOptionIn.setOPTADDAMT(option.getOPTADDAMT());
                                copyOptionIn.setINSERTDT(option.getINSERTDT());
                                copyOptionIn.setINSERTID(option.getINSERTID());
                                copyOptionIn.setMODIFYDT(option.getMODIFYDT());
                                copyOptionIn.setSTATUS(option.getSTATUS());
                            }
                        }
                        ** GOTO lbl13
                    }
                    flag = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                errorMessage = e.getMessage() != null ? e.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
                this.setValue(beginText.concat(errorMessage), 100);
                return new ResultProcessDTO(-1, "", 0, 0);
            }
        }
        this.setValue(beginText.concat("\ucd1d " + inRet + "\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4."), 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    public List<ProductOptionDTO> getOption(ProductDTO responseProduct, JsonObject optionsInfo) {
        ArrayList<ProductOptionDTO> options;
        block9: {
            JsonArray totalOptions;
            JsonArray optionPrices;
            JsonArray optionNames;
            block8: {
                String id;
                String name;
                JsonObject optionObj;
                options = new ArrayList<ProductOptionDTO>();
                optionNames = (JsonArray)optionsInfo.get("optionNames");
                optionPrices = (JsonArray)optionsInfo.get("optionPrices");
                totalOptions = (JsonArray)optionsInfo.get("totalOptions");
                if (optionNames.size() != 1) break block8;
                String optnm1 = optionNames.get(0).getAsString();
                ArrayList optionList = new ArrayList();
                JsonArray totalOptionsDetail = (JsonArray)totalOptions.get(0);
                int k = 0;
                while (k < totalOptionsDetail.size()) {
                    optionObj = (JsonObject)totalOptionsDetail.get(k);
                    name = optionObj.get("name").getAsString();
                    id = optionObj.get("_id").getAsString();
                    HashMap<String, String> optionMap = new HashMap<String, String>();
                    optionMap.put("name", name);
                    optionMap.put("id", id);
                    optionList.add(optionMap);
                    ++k;
                }
                k = 0;
                while (k < optionPrices.size()) {
                    optionObj = (JsonObject)optionPrices.get(k);
                    name = (String)((Map)optionList.get(k)).get("name");
                    id = (String)((Map)optionList.get(k)).get("id");
                    String idInPrice = optionObj.get("_id").getAsString();
                    Boolean isSale = optionObj.get("sold_out").getAsBoolean();
                    if (id.equals(idInPrice) && !isSale.booleanValue()) {
                        ProductOptionDTO option2 = new ProductOptionDTO();
                        option2.setSHOPPRODNO(responseProduct.getShopprodno());
                        option2.setSHOPPRODSKU_NM(responseProduct.getGoods_nm());
                        option2.setPRODCD(responseProduct.getCompayny_goods_cd());
                        option2.setOPTPRODNM(optnm1);
                        option2.setSKUSEQ(k + 1);
                        option2.setOPTSPECDES(name);
                        option2.setSHOPPRODSKU(id);
                        option2.setOPTPRODCD(responseProduct.getCompayny_goods_cd().concat("-" + String.valueOf(k + 1)));
                        option2.setOPTSAFESTOCK(optionObj.get("stockNumber").getAsInt());
                        option2.setOPTVERTSTOCK(optionObj.get("stockNumber").getAsInt());
                        int optAmt = optionObj.get("individualPurchasePrice").getAsInt() - Integer.parseInt(responseProduct.getGoods_price());
                        option2.setOPTADDAMT(optAmt);
                        option2.setINSERTDT(responseProduct.getInsertdt());
                        option2.setINSERTID(YDMASessonUtil.getUserInfo().getUserId());
                        option2.setSTATUS(optionObj.get("stockNumber").getAsInt() > 0 ? "0" : "1");
                        options.add(option2);
                    }
                    ++k;
                }
                break block9;
            }
            if (optionNames.size() != 2) break block9;
            String optnm1 = optionNames.get(0).getAsString();
            String optnm2 = optionNames.get(1).getAsString();
            String name = "";
            String id = "";
            ArrayList optionList = new ArrayList();
            JsonArray totalOptionsDetail1 = (JsonArray)totalOptions.get(0);
            int k = 0;
            while (k < totalOptionsDetail1.size()) {
                JsonObject optionObj1 = (JsonObject)totalOptionsDetail1.get(k);
                String name1 = optionObj1.get("name").getAsString();
                String id1 = optionObj1.get("_id").getAsString();
                JsonArray totalOptionsDetail2 = (JsonArray)totalOptions.get(1);
                int i = 0;
                while (i < totalOptionsDetail2.size()) {
                    JsonObject optionObj2 = (JsonObject)totalOptionsDetail2.get(i);
                    String name2 = optionObj2.get("name").getAsString();
                    String id2 = optionObj2.get("_id").getAsString();
                    name = name1.concat(":").concat(name2);
                    id = id1.concat("_").concat(id2);
                    HashMap<String, String> optionMap = new HashMap<String, String>();
                    optionMap.put("name", name);
                    optionMap.put("id", id);
                    optionList.add(optionMap);
                    ++i;
                }
                ++k;
            }
            int cnt = 0;
            int k2 = 0;
            while (k2 < optionPrices.size()) {
                JsonArray optionPricesArray = (JsonArray)optionPrices.get(k2);
                int i = 0;
                while (i < optionPricesArray.size()) {
                    JsonObject optionPricesArrayobj = (JsonObject)optionPricesArray.get(i);
                    name = (String)((Map)optionList.get(cnt)).get("name");
                    id = (String)((Map)optionList.get(cnt)).get("id");
                    String idInOptionPrices = optionPricesArrayobj.get("_id").getAsString();
                    Boolean isSale = optionPricesArrayobj.get("sold_out").getAsBoolean();
                    if (id.equals(idInOptionPrices) && !isSale.booleanValue()) {
                        ProductOptionDTO option3 = new ProductOptionDTO();
                        option3.setSHOPPRODNO(responseProduct.getShopprodno());
                        option3.setSHOPPRODSKU_NM(responseProduct.getGoods_nm());
                        option3.setPRODCD(responseProduct.getCompayny_goods_cd());
                        option3.setOPTPRODNM(optnm1.concat(":").concat(optnm2));
                        option3.setSKUSEQ(k2 + 1);
                        option3.setOPTSPECDES(name);
                        option3.setSHOPPRODSKU(id);
                        option3.setOPTPRODCD(responseProduct.getCompayny_goods_cd().concat("-" + String.valueOf(i + 1)));
                        option3.setOPTSAFESTOCK(optionPricesArrayobj.get("stockNumber").getAsInt());
                        option3.setOPTVERTSTOCK(optionPricesArrayobj.get("stockNumber").getAsInt());
                        int optAmt = optionPricesArrayobj.get("individualPurchasePrice").getAsInt() - Integer.parseInt(responseProduct.getGoods_price());
                        option3.setOPTADDAMT(optAmt);
                        option3.setINSERTDT(responseProduct.getInsertdt());
                        option3.setINSERTID(YDMASessonUtil.getUserInfo().getUserId());
                        option3.setSTATUS(optionPricesArrayobj.get("stockNumber").getAsInt() > 0 ? "0" : "1");
                        options.add(option3);
                    }
                    ++cnt;
                    ++i;
                }
                ++k2;
            }
        }
        return options;
    }

    private String dateFormat1(String inputDate) {
        LocalDate date = LocalDate.parse(inputDate);
        LocalDateTime dateTime = date.atStartOfDay();
        ZonedDateTime utcDateTime = dateTime.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneId.of("UTC"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        String formattedDate = utcDateTime.format(formatter);
        return formattedDate;
    }

    private String dateFormat2(String inputDate) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(inputDate, inputFormatter);
        String formattedDate = zonedDateTime.format(outputFormatter);
        return formattedDate;
    }

    public CategoryDTO getCategory(JsonObject data2, String token) {
        try {
            JsonObject info;
            JsonObject categoryInfo = (JsonObject)data2.get("categoryInfo");
            int minimumCategoryId = categoryInfo.get("minimumCategoryId").getAsInt();
            Connection.Response rs = Jsoup.connect((String)("https://alwayz-seller-back.ilevit.com/items/item-category/id?id=" + minimumCategoryId)).header("x-access-token", token).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            String responseBody = rs.body();
            if (responseBody.trim().startsWith("<html")) {
                CategoryDTO category = CategoryDAO.get().selectCategory("350119000");
                return category;
            }
            try {
                JsonReader reader = new JsonReader((Reader)new StringReader(responseBody));
                reader.setLenient(true);
                info = new JsonParser().parse(reader).getAsJsonObject();
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                responseBody = "{ \"log\" : \"" + responseBody.replace("\"", "\\\"") + "\" }";
                info = new JsonParser().parse(responseBody).getAsJsonObject();
            }
            if (info == null || info.get("status").getAsInt() != 200) {
                CategoryDTO category = CategoryDAO.get().selectCategory("350119000");
                return category;
            }
            JsonObject jsonData = (JsonObject)info.get("data");
            String name = jsonData.get("name").getAsString();
            CategoryDTO category = CategoryDAO.get().selectShoppingMallCategory(String.valueOf(minimumCategoryId), name);
            if (category == null && (category = CategoryDAO.get().selectShoppingMallCategory(String.valueOf(minimumCategoryId))) == null) {
                category = CategoryDAO.get().selectCategory("350119000");
            }
            return category;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<List<String>> splitList(List<String> list, int size) {
        ArrayList<List<String>> partitionedList = new ArrayList<List<String>>();
        int i = 0;
        while (i < list.size()) {
            int end = Math.min(i + size, list.size());
            partitionedList.add(list.subList(i, end));
            i += size;
        }
        return partitionedList;
    }

    @Override
    public ResultProcessDTO addProcess2(ProductAddProcessDTO proDto, List<String> specificCodes, IProgressMonitor monitor, ShoppingmallDTO dto) throws Exception {
        return null;
    }

    private void setValue(String message, int value) {
        CommonProgressDialog.get().setValue(message, value);
    }

    private static /* synthetic */ boolean lambda$5(ProductDTO productDTO, DomemallDTO p) {
        return p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(productDTO.getCompayny_goods_cd()));
    }

    private static /* synthetic */ String lambda$6(DomemallDTO p) {
        return p.getSHOPCD();
    }

    private static /* synthetic */ String lambda$7(ProductOptionDTO p) {
        return p.getOPTPRODNM();
    }

    private static /* synthetic */ boolean lambda$8(ProductDTO productDTO, DomemallDTO p) {
        return p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(productDTO.getCompayny_goods_cd()));
    }

    private static /* synthetic */ String lambda$9(DomemallDTO p) {
        return p.getSHOPCD();
    }

    private class AddInfo {
        @JsonProperty(value="condition")
        private Condition condition = new Condition();
        @JsonProperty(value="page")
        private int page;
        @JsonProperty(value="pageLimit")
        private int pageLimit;

        private class Condition {
            @JsonProperty(value="type")
            private String type;
            @JsonProperty(value="itemCondition")
            private ItemCondition itemCondition;
            @JsonProperty(value="itemSortCondition")
            private ItemSortCondition itemSortCondition;

            private Condition() {
                this.itemCondition = new ItemCondition();
                this.itemSortCondition = new ItemSortCondition();
            }
        }

        private class CreatedAt {
            @JsonProperty(value="$gt")
            private String greaterThan;

            private CreatedAt() {
            }
        }

        private class ItemCondition {
            @JsonProperty(value="createdAt")
            private CreatedAt createdAt;

            private ItemCondition() {
                this.createdAt = new CreatedAt();
            }
        }

        private class ItemSortCondition {
            @JsonProperty(value="createdAt")
            private int createdAt;

            private ItemSortCondition() {
            }
        }
    }

    private class AddInfoByWord {
        @JsonProperty(value="condition")
        private Condition condition = new Condition();
        @JsonProperty(value="page")
        private int page;
        @JsonProperty(value="pageLimit")
        private int pageLimit;

        static /* synthetic */ Condition access$0(AddInfoByWord addInfoByWord) {
            return addInfoByWord.condition;
        }

        static /* synthetic */ void access$1(AddInfoByWord addInfoByWord, int n) {
            addInfoByWord.page = n;
        }

        static /* synthetic */ void access$2(AddInfoByWord addInfoByWord, int n) {
            addInfoByWord.pageLimit = n;
        }

        private class Condition {
            @JsonProperty(value="type")
            private String type;
            @JsonProperty(value="itemCondition")
            private ItemCondition itemCondition;
            @JsonProperty(value="itemSortCondition")
            private ItemSortCondition itemSortCondition;

            private Condition() {
                this.itemCondition = new ItemCondition();
                this.itemSortCondition = new ItemSortCondition();
            }

            static /* synthetic */ void access$1(Condition condition, String string) {
                condition.type = string;
            }

            static /* synthetic */ ItemCondition access$2(Condition condition) {
                return condition.itemCondition;
            }

            static /* synthetic */ ItemSortCondition access$3(Condition condition) {
                return condition.itemSortCondition;
            }
        }

        private class CreatedAt {
            @JsonProperty(value="$gt")
            private String greaterThan;

            private CreatedAt() {
            }

            static /* synthetic */ void access$1(CreatedAt createdAt, String string) {
                createdAt.greaterThan = string;
            }
        }

        private class ItemCondition {
            @JsonProperty(value="createdAt")
            private CreatedAt createdAt;
            @JsonProperty(value="recommendItemCode")
            private RecommedItemCode recommendItemCode;

            private ItemCondition() {
                this.createdAt = new CreatedAt();
                this.recommendItemCode = new RecommedItemCode();
            }

            static /* synthetic */ CreatedAt access$1(ItemCondition itemCondition) {
                return itemCondition.createdAt;
            }

            static /* synthetic */ RecommedItemCode access$2(ItemCondition itemCondition) {
                return itemCondition.recommendItemCode;
            }
        }

        private class ItemSortCondition {
            @JsonProperty(value="createdAt")
            private int createdAt;

            private ItemSortCondition() {
            }

            static /* synthetic */ void access$1(ItemSortCondition itemSortCondition, int n) {
                itemSortCondition.createdAt = n;
            }
        }

        private class RecommedItemCode {
            @JsonProperty(value="$in")
            private List<String> $in = new ArrayList<String>();

            private RecommedItemCode() {
            }

            static /* synthetic */ void access$1(RecommedItemCode recommedItemCode, List list) {
                recommedItemCode.$in = list;
            }
        }
    }
}

