/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.domesin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.CategoryDao;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCateDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.domesin.CateDao;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinCommon;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinMarginDto;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinOption;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinOptionList;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinProductGetDao;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinSessonUtil;
import com.kdjsystem.mlink.yellim.shop.mlink.MLinkCateDao;
import com.kdjsystem.mlink.yellim.shop.mlink.MLinkShopDao;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class DomesinShopDao {
    public static DomesinShopDao instance = new DomesinShopDao();

    private DomesinShopDao() {
    }

    public static DomesinShopDao get() {
        return instance;
    }

    public static void saveCategory(List<ProductItemDto> list, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "INSERT INTO shopcatinf \r\n\t(COMPNO, SHOPCD, SHOPCATNO, DOME, SHOPCATNM, SHOPCATSITENM, EBAYCATCD, SHOPSMLCATCD, SERVICEPROD, USE_YN, SHOPGENERAL, SHOPID, INSERTDT) \r\n\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON  DUPLICATE KEY UPDATE  EBAYCATCD=?,  SHOPSMLCATCD=?  ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                List shopcateinfos = null;
                shopcateinfos = list.get(0).isModifyMode() ? list.stream().filter(p -> p.isCategoryModify()).map(p -> new ShopCateInfo(p.getCid(), p.getEs_auction(), p.getEs_gmarket(), p.getEs_11st(), p.getEs_interpark(), p.getEs_storefarm(), p.getEsm_auction(), p.getEsm_gmarket(), "", p.getEs_coupang(), p.getCate_depth(), p.getIcode())).distinct().collect(Collectors.toList()) : list.stream().map(p -> new ShopCateInfo(p.getCid(), p.getEs_auction(), p.getEs_gmarket(), p.getEs_11st(), p.getEs_interpark(), p.getEs_storefarm(), p.getEsm_auction(), p.getEsm_gmarket(), "", p.getEs_coupang(), p.getCate_depth(), p.getIcode())).distinct().collect(Collectors.toList());
                List<String> shopList = DomesinSessonUtil.ManagerShop;
                for (ShopCateInfo shopcateinf : shopcateinfos) {
                    String class_cd4 = "";
                    String class_cd3 = "";
                    if (shopcateinf.cate_dept.equals("4")) {
                        class_cd4 = shopcateinf.cid;
                        class_cd3 = DomesinSessonUtil.get().getParentClassCd(class_cd4);
                    } else {
                        class_cd3 = shopcateinf.cid;
                    }
                    String class_cd2 = DomesinSessonUtil.get().getParentClassCd(class_cd3);
                    String class_cd1 = DomesinSessonUtil.get().getParentClassCd(class_cd2);
                    String cateName = DomesinSessonUtil.get().getCateName(class_cd3);
                    String full_cateName = DomesinSessonUtil.get().getFullCateName(class_cd3);
                    if (class_cd2.equals("") && class_cd1.equals("") && cateName.equals("") && full_cateName.equals("")) {
                        if (class_cd3.equals("")) {
                            class_cd3 = MLinkShopDao.getParentClassCd(list.get(0).getSearch(), "4", class_cd4);
                        }
                        class_cd2 = MLinkShopDao.getParentClassCd(list.get(0).getSearch(), "3", class_cd3);
                        class_cd1 = MLinkShopDao.getParentClassCd(list.get(0).getSearch(), "2", class_cd2);
                        cateName = MLinkShopDao.getCateName(list.get(0).getSearch(), class_cd3);
                        full_cateName = MLinkShopDao.getFullCateName(list.get(0).getSearch(), class_cd3);
                        MLinkCateDao.get().categoryLargeInsert(class_cd1, MLinkShopDao.getCateName(list.get(0).getSearch(), class_cd1), "0", "1", "MLink", "", list.get(0).getSearch());
                        MLinkCateDao.get().categoryMidiumInsert(class_cd1, class_cd2, MLinkShopDao.getCateName(list.get(0).getSearch(), class_cd2), "0", "1", "MLink", "", list.get(0).getSearch());
                        MLinkCateDao.get().categorySmallInsert(class_cd2, class_cd3, MLinkShopDao.getCateName(list.get(0).getSearch(), class_cd3), "0", "1", "MLink", "", "", list.get(0).getSearch());
                        if (shopcateinf.cate_dept.equals("4")) {
                            MLinkCateDao.get().categoryDetailInsert(class_cd3, class_cd4, MLinkShopDao.getCateName(list.get(0).getSearch(), class_cd4), "0", "1", "MLink", "", list.get(0).getSearch());
                        }
                    } else {
                        CateDao.get().categoryLargeInsert(class_cd1, DomesinSessonUtil.get().getCateName(class_cd1), "0", "1", "\ub3c4\ub9e4\uc758\uc2e0", "", list.get(0).getSearch());
                        CateDao.get().categoryMidiumInsert(class_cd1, class_cd2, DomesinSessonUtil.get().getCateName(class_cd2), "0", "1", "\ub3c4\ub9e4\uc758\uc2e0", "", list.get(0).getSearch());
                        CateDao.get().categorySmallInsert(class_cd2, class_cd3, DomesinSessonUtil.get().getCateName(class_cd3), "0", "1", "\ub3c4\ub9e4\uc758\uc2e0", "", "", list.get(0).getSearch());
                        if (shopcateinf.cate_dept.equals("4")) {
                            CateDao.get().categoryDetailInsert(class_cd3, class_cd4, DomesinSessonUtil.get().getCateName(class_cd4), "0", "1", "\ub3c4\ub9e4\uc758\uc2e0", "", list.get(0).getSearch());
                        }
                    }
                    for (String shopcd : shopList) {
                        String esm_code = "";
                        String code = "";
                        switch (shopcd) {
                            case "shop0075": {
                                code = shopcateinf.es_coupang;
                                break;
                            }
                            case "shop0004": {
                                code = shopcateinf.es_interpark;
                                break;
                            }
                            case "shop0068": 
                            case "shop00681": {
                                code = shopcateinf.es_gmarket;
                                esm_code = shopcateinf.esm_gmarket;
                                break;
                            }
                            case "shop0067": 
                            case "shop00671": {
                                code = shopcateinf.es_auction;
                                esm_code = shopcateinf.esm_auction;
                                break;
                            }
                            case "shop0055": {
                                code = shopcateinf.es_storefarm;
                                break;
                            }
                            case "shop0003": 
                            case "shop00031": {
                                code = shopcateinf.es_11st;
                            }
                        }
                        if (code.isEmpty()) continue;
                        String seq = shopcateinf.cid;
                        CateDao.get().setProductMstShopCategoryUpdate(shopcateinf.cid, shopcd, String.valueOf(seq), "3", list.get(0).getSearch());
                        String catenm = shopcd.concat("_").concat(cateName);
                        int i = 0;
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setString(++i, shopcd);
                        pstmt.setString(++i, seq);
                        pstmt.setString(++i, list.get(0).getSearch());
                        pstmt.setString(++i, catenm);
                        pstmt.setString(++i, full_cateName);
                        pstmt.setString(++i, esm_code);
                        pstmt.setString(++i, code);
                        pstmt.setString(++i, "\uc77c\ubc18\ubc30\uc1a1\uc0c1\ud488");
                        pstmt.setString(++i, "Y");
                        pstmt.setString(++i, "01");
                        pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++i, esm_code);
                        pstmt.setString(++i, code);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    ++result;
                    ++row;
                    if (workload > 0) {
                        try {
                            monitor.subTask("[\uce74\ud14c\uace0\ub9ac \uc815\ubcf4 \ucc98\ub9ac\uc911..] " + result + " of " + workload + "...");
                            monitor.worked(1);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (result <= 1 || result % 1000 != 0) continue;
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                    connection.setAutoCommit(false);
                    row = 0;
                }
                if (row > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int saveOrUpdate(List<ProductItemDto> contents) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "INSERT INTO ds_shopprodinfo(icode,iname,cid,shop_cid_info,icountry, maker,brand,tax,vender_code,delivery_type, delivery_amount,delivery_qty,keyword,price,price_consumer, islimit,limit_price,content,img,select_option, text_option,notice,itype,status,adult, reg_datetime,up_datetime,isreturn,cert_type,cert, cert_no,gosi_code,gosi_info) VALUES( ?,?,?,?,?  \r\n ,?,?,?,?,? \r\n ,?,?,?,?,? \r\n ,?,?,?,?,? \r\n ,?,?,?,?,? \r\n ,?,?,?,?,? \r\n  ,?,?,?)  ON DUPLICATE KEY UPDATE iname = ?  \r\n";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductItemDto item : contents) {
                    int rowIdx = 0;
                    pstmt.setString(++rowIdx, item.getIcode());
                    pstmt.setString(++rowIdx, YDMAStringUtil.setTextStrtok(item.getIname(), 100));
                    pstmt.setString(++rowIdx, item.getCid());
                    pstmt.setString(++rowIdx, DomesinShopDao.getCateJson(item));
                    pstmt.setString(++rowIdx, item.getIcountry());
                    pstmt.setString(++rowIdx, item.getMaker());
                    pstmt.setString(++rowIdx, item.getBrand());
                    pstmt.setString(++rowIdx, item.getTax());
                    pstmt.setString(++rowIdx, item.getVender_code());
                    pstmt.setString(++rowIdx, item.getDelivery_type());
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(item.getDelivery_amount()));
                    pstmt.setString(++rowIdx, item.getDelivery_qty());
                    pstmt.setString(++rowIdx, item.getKeyword());
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(item.getPrice()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(item.getPrice_consumer()));
                    pstmt.setString(++rowIdx, item.getIslimit());
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(item.getLimit_price()));
                    String content = item.getContent().replaceAll("\"", "'");
                    content = content.replaceAll("\\\\", "");
                    pstmt.setString(++rowIdx, content);
                    String img = Arrays.asList(item.getImg()).stream().collect(Collectors.joining(","));
                    pstmt.setString(++rowIdx, img);
                    pstmt.setString(++rowIdx, this.getOptionJson(item.getSelect_option()));
                    pstmt.setString(++rowIdx, item.getText_option());
                    pstmt.setString(++rowIdx, item.getNotice());
                    pstmt.setString(++rowIdx, item.getItype());
                    pstmt.setString(++rowIdx, item.getStatus());
                    pstmt.setString(++rowIdx, item.getAdult());
                    pstmt.setString(++rowIdx, item.getReg_datetime());
                    pstmt.setString(++rowIdx, item.getUp_datetime());
                    pstmt.setString(++rowIdx, item.getIsreturn());
                    pstmt.setString(++rowIdx, item.getCert_type());
                    pstmt.setString(++rowIdx, item.getCert());
                    pstmt.setString(++rowIdx, item.getCert_no());
                    pstmt.setString(++rowIdx, item.getGosi_code());
                    pstmt.setString(++rowIdx, this.getGosiInfoJson(item));
                    pstmt.setString(++rowIdx, YDMAStringUtil.setTextStrtok(item.getIname(), 100));
                    ++result;
                    YDMAStringUtil.Print("[insert shopprodinfo]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public String getOptionJson(String optionString) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        List<DomesinOption> options = DomesinCommon.get().getOptionList((String)optionString).options;
        String json = mapper.writeValueAsString(options);
        return json;
    }

    public String getGosiInfoJson(ProductItemDto item) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ShopGosiInfo shopGosiInfo = new ShopGosiInfo();
        shopGosiInfo.setGosi1(item.getGosi1());
        shopGosiInfo.setGosi2(item.getGosi2());
        shopGosiInfo.setGosi3(item.getGosi3());
        shopGosiInfo.setGosi4(item.getGosi4());
        shopGosiInfo.setGosi5(item.getGosi5());
        shopGosiInfo.setGosi6(item.getGosi6());
        shopGosiInfo.setGosi7(item.getGosi7());
        shopGosiInfo.setGosi8(item.getGosi8());
        shopGosiInfo.setGosi9(item.getGosi9());
        shopGosiInfo.setGosi10(item.getGosi10());
        shopGosiInfo.setGosi11(item.getGosi11());
        shopGosiInfo.setGosi12(item.getGosi12());
        shopGosiInfo.setGosi13(item.getGosi13());
        shopGosiInfo.setGosi14(item.getGosi14());
        shopGosiInfo.setGosi15(item.getGosi15());
        shopGosiInfo.setGosi16(item.getGosi16());
        shopGosiInfo.setGosi17(item.getGosi17());
        shopGosiInfo.setGosi18(item.getGosi18());
        shopGosiInfo.setGosi19(item.getGosi19());
        shopGosiInfo.setGosi20(item.getGosi20());
        shopGosiInfo.setGosi21(item.getGosi21());
        shopGosiInfo.setGosi22(item.getGosi22());
        String json = mapper.writeValueAsString((Object)shopGosiInfo);
        return json;
    }

    public static String getCateJson(ProductItemDto item) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        List<String> shopList = DomesinSessonUtil.ManagerShop;
        ArrayList<ShopCateItem> cate_list = new ArrayList<ShopCateItem>();
        for (String shopcd : shopList) {
            String esm_gmarket;
            ShopCateItem cateItem = new ShopCateItem();
            String string = shopcd.equals("shop0068") ? item.getEsm_gmarket() : (esm_gmarket = shopcd.equals("shop00681") ? item.getEsm_gmarket() : "");
            String esm_auction = shopcd.equals("shop0067") ? item.getEsm_auction() : (shopcd.equals("shop00671") ? item.getEsm_auction() : "");
            cateItem.shopcd = shopcd;
            cateItem.esm_gmarket = esm_gmarket;
            cateItem.esm_auction = esm_auction;
            cateItem.cid = DomesinShopDao.getCategoryCd(shopcd, item);
            cate_list.add(cateItem);
        }
        String json = mapper.writeValueAsString(cate_list);
        return json;
    }

    public boolean excelUpdateOrdInfo(List<ProductItemDto> contents) throws Exception {
        boolean ret = false;
        try {
            excelupdateProdThread op = new excelupdateProdThread(contents);
            new ProgressMonitorDialog(new Shell()).run(true, true, (IRunnableWithProgress)op);
            ret = true;
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return ret;
    }

    public boolean saveOrdInfo(List<ProductItemDto> contents) throws Exception {
        boolean ret = false;
        try {
            saveProdThread op = new saveProdThread(contents);
            new ProgressMonitorDialog(new Shell()).run(true, true, (IRunnableWithProgress)op);
            ret = true;
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return ret;
    }

    public static String getCategoryCd(String shopcd, ProductItemDto item) {
        switch (shopcd) {
            case "shop0067": 
            case "shop00671": {
                return String.valueOf(item.getEs_auction());
            }
            case "shop0068": 
            case "shop00681": {
                return String.valueOf(item.getEs_gmarket());
            }
            case "shop0004": {
                return String.valueOf(item.getEs_interpark());
            }
            case "shop0055": {
                return String.valueOf(item.getEs_storefarm());
            }
            case "shop0003": 
            case "shop00031": {
                return String.valueOf(item.getEs_11st());
            }
            case "shop0075": {
                return String.valueOf(item.getEs_coupang());
            }
            case "shop0411": {
                return String.valueOf(item.getEs_ssg());
            }
            case "shop0287": {
                return String.valueOf(item.getEs_wemarket());
            }
            case "shop0076": {
                return String.valueOf(item.getEs_tmon());
            }
            case "shop0273": {
                return String.valueOf(item.getEs_kakao());
            }
            case "shop0372": {
                return String.valueOf(item.getEs_lotteon());
            }
            case "shop0106": {
                return String.valueOf(item.getEs_melchi());
            }
        }
        return "";
    }

    public void saveShopCategoryInfo(List<ProductItemDto> contents) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "insert into shopcatinfo (SHOPCATNO, SHOPCATNM,FULL_CATENM, ITEMS, USE_YN, INSERTDT )   values (?, ?, ?, ?, ?,? )  ON  DUPLICATE KEY UPDATE SHOPCATNM=? ,  FULL_CATENM=?, ITEMS=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                HashMap shopCategoryList = new HashMap();
                List cidList = contents.stream().map(p -> p.getCid()).distinct().collect(Collectors.toList());
                for (String cid : cidList) {
                    ProductItemDto item = contents.stream().filter(p -> p.getCid().equals(cid)).findAny().orElse(new ProductItemDto());
                    String full_cateName = DomesinSessonUtil.get().getFullCateName(cid);
                    String cateName = DomesinSessonUtil.get().getCateName(cid);
                    ObjectMapper mapper = new ObjectMapper();
                    shopCategoryList.clear();
                    List<String> shopList = Arrays.asList("shop0075", "shop0004", "shop0068", "shop0067", "shop0055", "shop0003", "shop00031", "shop00671", "shop00681", "shop0273", "shop0110");
                    ArrayList<ShopCateItem> cate_list = new ArrayList<ShopCateItem>();
                    for (String shopcd : shopList) {
                        ShopCateItem cateItem = new ShopCateItem();
                        String esm_gmarket = shopcd.equals("shop00681") ? item.getEsm_gmarket() : "";
                        String esm_auction = shopcd.equals("shop00671") ? item.getEsm_auction() : "";
                        cateItem.shopcd = shopcd;
                        cateItem.esm_gmarket = esm_gmarket;
                        cateItem.esm_auction = esm_auction;
                        cateItem.cid = DomesinShopDao.getCategoryCd(shopcd, item);
                        cate_list.add(cateItem);
                    }
                    String json = mapper.writeValueAsString(cate_list);
                    int i = 0;
                    pstmt.setString(++i, cid);
                    pstmt.setString(++i, cateName);
                    pstmt.setString(++i, full_cateName);
                    pstmt.setString(++i, json);
                    pstmt.setString(++i, "Y");
                    pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++i, cateName);
                    pstmt.setString(++i, full_cateName);
                    pstmt.setString(++i, json);
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[smlCategoryInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void saveShopCatInfo(List<ProductItemDto> contents) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "insert into shopcatinf (compno, shopcd, shopcatno, shopcatnm, shopcatsitenm, shoplagcatcd, shopmidcatcd, shopsmlcatcd, shopdetcatcd, serviceprod, use_yn, SHOPGENERAL, SHOPID, insertdt, SHOPCOMMIS )   values (?, ?, ?, ?, ? ,?, ? , ?, ?, ?, ?, ?, ?, ?, ? ) ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                HashMap<String, String> list_shopCd = new HashMap<String, String>();
                list_shopCd.put("shop0055", "\uc2a4\ud1a0\uc5b4\ud31c");
                List cidList = contents.stream().map(p -> p.getCid()).distinct().collect(Collectors.toList());
                CategoryDao dao = new CategoryDao();
                int seq = dao.getShopcatinfMaxseq("shop0055") + 1;
                Iterator iterator = cidList.iterator();
                block5: while (iterator.hasNext()) {
                    String cid;
                    String class_cd3 = cid = (String)iterator.next();
                    String class_cd2 = DomesinSessonUtil.get().getParentClassCd(class_cd3);
                    String class_cd1 = DomesinSessonUtil.get().getParentClassCd(class_cd2);
                    String full_cateName = DomesinSessonUtil.get().getFullCateName(cid);
                    String cateName = DomesinSessonUtil.get().getCateName(cid);
                    ProductItemDto item = contents.stream().filter(p -> p.getCid().equals(cid)).findAny().orElse(null);
                    CateDao.get().categoryLargeInsert(class_cd1, DomesinSessonUtil.get().getCateName(class_cd1), "0", "1", "\ub3c4\ub9e4\uc758\uc2e0\uce74\ud14c\uace0\ub9ac", "", contents.get(0).getSearch());
                    CateDao.get().categoryMidiumInsert(class_cd1, class_cd2, DomesinSessonUtil.get().getCateName(class_cd2), "0", "1", "\ub3c4\ub9e4\uc758\uc2e0\uce74\ud14c\uace0\ub9ac", "", contents.get(0).getSearch());
                    CateDao.get().categorySmallInsert(class_cd2, class_cd3, DomesinSessonUtil.get().getCateName(class_cd3), "0", "1", "\ub3c4\ub9e4\uc758\uc2e0\uce74\ud14c\uace0\ub9ac", "", "", contents.get(0).getSearch());
                    String class_code = class_cd1.concat(class_cd2).concat(class_cd3);
                    for (String shopcode : list_shopCd.keySet()) {
                        String catenm = ((String)list_shopCd.get(shopcode)).concat("_").concat(cateName);
                        int i = 0;
                        CateDao.get().setProductMstShopCategoryUpdate(class_code, shopcode, String.valueOf(++seq), "3", contents.get(0).getSearch());
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setString(++i, shopcode);
                        pstmt.setInt(++i, seq);
                        pstmt.setString(++i, catenm);
                        pstmt.setString(++i, full_cateName);
                        String code = item.getEs_storefarm();
                        if (code.isEmpty()) continue block5;
                        String lagcd = code.substring(0, 6);
                        String midcd = code.substring(0, 9);
                        String smlcd = code.length() > 10 ? code.substring(0, 12) : "";
                        String detcd = code.length() > 14 ? code.substring(0, 15) : "";
                        pstmt.setString(++i, lagcd);
                        pstmt.setString(++i, midcd);
                        pstmt.setString(++i, smlcd);
                        pstmt.setString(++i, detcd);
                        pstmt.setString(++i, "\uc77c\ubc18\ubc30\uc1a1\uc0c1\ud488");
                        pstmt.setString(++i, "Y");
                        pstmt.setString(++i, "01");
                        pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setFloat(++i, 0.0f);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                }
                YDMAStringUtil.Print("[smlCategoryInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public static void saveShopOptProdInfo(String modi, List<ProductItemDto> contents, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection2 = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist2 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection2 = DBCPInit.getInstance().getConnection();
                connection2.setAutoCommit(false);
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("PRODSEQ");
                lstInsert.add("SKUSEQ");
                lstInsert.add("COMPNO");
                lstInsert.add("PRODCD");
                lstInsert.add("OPTPRODCD");
                lstInsert.add("OPTPRODNM");
                lstInsert.add("OPTSPECDES");
                lstInsert.add("OPTSAFESTOCK");
                lstInsert.add("OPTVERTSTOCK");
                lstInsert.add("OPTADDAMT");
                lstInsert.add("LIMIT_PRICE");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("PRODCD");
                lstUpdate.add("OPTPRODCD");
                lstUpdate.add("OPTPRODNM");
                lstUpdate.add("OPTSPECDES");
                lstUpdate.add("OPTSAFESTOCK");
                lstUpdate.add("OPTVERTSTOCK");
                lstUpdate.add("OPTADDAMT");
                lstUpdate.add("LIMIT_PRICE");
                lstUpdate.add("MODIFYDT");
                lstUpdate.add("MODIFYID");
                String sql2 = DomesinShopDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "shop_optprodinfo");
                sql2 = sql2.toUpperCase();
                pstmt2 = connection2.prepareStatement(sql2);
                statementlist2.add(pstmt2);
                String sql = "SELECT prodseq  FROM shopprodinfo where compno = ? and compayny_goods_cd=? ";
                sql = sql.toUpperCase();
                pstmt = connection2.prepareStatement(sql);
                for (ProductItemDto list : contents) {
                    String[] chgitems = DomesinShopDao.isShopProductInfoExits(YDMASessonUtil.getCompnoInfo().getCompno(), list.getIcode());
                    if (!modi.equals("")) {
                        chgitems[0] = modi;
                    }
                    if (chgitems[0].contains("9") || list.isModifyMode() && !list.isOptionModify()) continue;
                    String optionString = list.getSelect_option();
                    int prodseq = 0;
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.getIcode());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        prodseq = rs.getInt(1);
                    }
                    if (optionString.isEmpty()) {
                        DomesinShopDao.deleteOptProdInfo(prodseq);
                        continue;
                    }
                    List<DomesinOption> options = DomesinCommon.get().getOptionList((String)optionString).options;
                    if (options != null && options.size() != 0) {
                        DomesinShopDao.deleteOptProdInfo(prodseq);
                    }
                    int i = 1;
                    for (DomesinOption option2 : options) {
                        int rowIdx2 = 0;
                        pstmt2.setInt(++rowIdx2, prodseq);
                        pstmt2.setInt(++rowIdx2, i);
                        pstmt2.setString(++rowIdx2, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt2.setString(++rowIdx2, list.getIcode());
                        String optrprodcd = list.getIcode().concat("-").concat(YDMAStringUtil.leftPad(String.valueOf(i), 2, "0"));
                        pstmt2.setString(++rowIdx2, optrprodcd);
                        pstmt2.setString(++rowIdx2, option2.getOptionType());
                        String optionVal = "";
                        String optionName1 = option2.getOptionName1() == null ? "" : option2.getOptionName1();
                        String optionName2 = option2.getOptionName2() == null ? "" : option2.getOptionName2();
                        String optionName3 = option2.getOptionName3() == null ? "" : option2.getOptionName3();
                        optionVal = Arrays.asList(optionName1, optionName2, optionName3).stream().filter(p -> p != "").collect(Collectors.joining(":"));
                        pstmt2.setString(++rowIdx2, optionVal);
                        int cnt = option2.getSoldOut() == 0 ? 999 : 0;
                        pstmt2.setInt(++rowIdx2, cnt);
                        pstmt2.setInt(++rowIdx2, cnt);
                        int price2 = 0;
                        if (option2.getOptionPrice() != 0) {
                            price2 = option2.getOptionPrice() - YDMAStringUtil.convertToInt(list.getPrice());
                        }
                        pstmt2.setInt(++rowIdx2, price2);
                        pstmt2.setInt(++rowIdx2, option2.getCompliancePrice());
                        pstmt2.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt2.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt2.setString(++rowIdx2, list.getIcode());
                        pstmt2.setString(++rowIdx2, optrprodcd);
                        pstmt2.setString(++rowIdx2, option2.getOptionType());
                        pstmt2.setString(++rowIdx2, optionVal);
                        pstmt2.setInt(++rowIdx2, cnt);
                        pstmt2.setInt(++rowIdx2, cnt);
                        pstmt2.setInt(++rowIdx2, price2);
                        pstmt2.setInt(++rowIdx2, option2.getCompliancePrice());
                        pstmt2.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt2.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt2.addBatch();
                        pstmt2.clearParameters();
                        ++i;
                        ++row;
                    }
                    if (++result > 1 && result % 1000 == 0) {
                        pstmt2.executeBatch();
                        connection2.setAutoCommit(true);
                        pstmt2.clearBatch();
                        connection2.setAutoCommit(false);
                        row = 0;
                    }
                    if (workload <= 0) continue;
                    try {
                        monitor.subTask("[\uc635\uc158\uc815\ubcf4 \ucc98\ub9ac\uc911..]  " + result + " of " + workload + "...");
                        monitor.worked(1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (row > 0) {
                    pstmt2.executeBatch();
                    connection2.setAutoCommit(true);
                    pstmt2.clearBatch();
                }
            }
            catch (Exception ex) {
                connection2.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection2, statementlist2, rs);
        }
    }

    public static void deleteOptProdInfo(int prodseq) throws Exception {
        block5: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "delete from shop_optprodinfo where prodseq = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setInt(1, prodseq);
                    pstmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public int updateShopProdStatus(List<ProductItemDto> contents) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "UPDATE shopprodinfo\r\nSET\r\n    ShopSendStatus =? \r\n  , ShopModifyContent =?\r\nWHERE\r\n  COMPAYNY_GOODS_CD =?\r\n  AND COMPNO = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductItemDto list : contents) {
                    int rowIdx = 0;
                    if (list.isModifyMode() && !list.isBaseInfoModify()) continue;
                    String modifyContent = list.getChange_list();
                    pstmt.setInt(++rowIdx, -2);
                    pstmt.setString(++rowIdx, modifyContent);
                    pstmt.setString(++rowIdx, list.getIcode());
                    pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                    YDMAStringUtil.Print("[insert shopprodinfo]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public static String getInsertOrUpdateQueryMapper(List<String> lstInsert, List<String> lstUpdate, String tableName) {
        StringBuilder sb_result = new StringBuilder();
        sb_result.append(String.format("INSERT INTO %s ", tableName));
        String head = lstInsert.stream().collect(Collectors.joining(",", "(", ") "));
        String bottom = lstInsert.stream().map(p -> String.valueOf("?")).collect(Collectors.joining(",", " VALUES (", ") "));
        sb_result.append(head);
        sb_result.append(bottom);
        if (lstUpdate != null) {
            sb_result.append("\r\n ON DUPLICATE KEY  UPDATE \r\n");
            String str_update = lstUpdate.stream().map(p -> p.concat(" = ?")).collect(Collectors.joining(","));
            sb_result.append(str_update);
        }
        return sb_result.toString();
    }

    protected static void getCategoryMapSetting(IProgressMonitor monitor, int workload) {
        block8: {
            try {
                HashMap<Integer, ShopCateDto> response = new HashMap<Integer, ShopCateDto>();
                ShopCateDto dto = ShopCommonDao.get().getCategoryMapAPI(0);
                if (Integer.parseInt(dto.getTotal_count()) <= 0) break block8;
                response.put(0, dto);
                if (Integer.parseInt(dto.getTotal_page()) > 1) {
                    int i = 1;
                    while (i <= Integer.parseInt(dto.getTotal_page())) {
                        ShopCateDto item = ShopCommonDao.get().getCategoryMapAPI(i);
                        response.put(i, item);
                        try {
                            monitor.subTask("[\uce74\ud14c\uace0\ub9ac\uc815\ubcf4 \ub2e4\uc6b4\ub85c\ub4dc \ucc98\ub9ac\uc911..] of " + workload + "..." + i);
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                monitor.done();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        ++i;
                    }
                }
                ArrayList<ShopCateDto.CategoryMapList> catlist = new ArrayList<ShopCateDto.CategoryMapList>();
                Iterator iterator = response.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    ShopCateDto resDto = (ShopCateDto)response.get(key);
                    catlist.addAll(resDto.getCategoryMapList());
                }
                ShopCommonDao.get().setCategoryMapInsertNUpdate(catlist);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateCategoryShopApiSetting(List<ProductItemDto> contents, IProgressMonitor monitor, int workload) throws Exception {
        try {
            try {
                monitor.subTask("[\uce74\ud14c\uace0\ub9ac\uc815\ubcf4 \uc218\uc9d1 \ucc98\ub9ac\uc911..] of " + workload + "...");
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    monitor.done();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String shopcate_json = "";
            for (ProductItemDto list : contents) {
                if (list.getEs() == null || list.getEs().equals("") || list.getSearch().equals("shop0120")) {
                    YDMAStringUtil.Print();
                }
                if (list.getEs() == null || list.getEs().equals("") || list.getSearch().equals("shop0120")) {
                    DomesinShopDao.get();
                    shopcate_json = DomesinShopDao.getCateJson(list);
                } else {
                    MLinkShopDao.get();
                    ShopCateDto cateDto = MLinkShopDao.getNewCategorys(list.getEs());
                    String domeJson = "";
                    String shopJson = "";
                    if (cateDto.getId() != null && !cateDto.getId().equals("")) {
                        list.setEs(cateDto.getId());
                        domeJson = cateDto.getDomecatg();
                        shopJson = cateDto.getShopcate();
                    }
                    if (shopJson == null || shopJson.equals("")) {
                        DomesinShopDao.get();
                        shopcate_json = DomesinShopDao.getCateJson(list);
                    } else {
                        shopcate_json = ShopCommonDao.get().getCategoryShopApiSetting(shopJson, list);
                    }
                    String domecate_json = "";
                    domecate_json = domeJson == null || domeJson.equals("") ? ShopCommonDao.get().getCateDomeJson(list) : ShopCommonDao.get().getCategoryDomeSetting(domeJson, list.getSearch(), list.getCid());
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode actualObjShop1 = mapper.readTree(shopcate_json);
                    JsonNode actualObjShop2 = mapper.readTree(shopJson);
                    JsonNode actualObjdome1 = mapper.readTree(domecate_json);
                    JsonNode actualObjdome2 = mapper.readTree(domeJson);
                    if (!actualObjShop1.equals((Object)actualObjShop2) || !actualObjdome1.equals((Object)actualObjdome2)) {
                        ShopCommonDao.get().setNewCategoryMapUpdate(list.getEs(), shopcate_json, domecate_json);
                        ShopCommonDao.get().setCategoryMapUpdateApi(list.getEs(), shopcate_json, domecate_json);
                    }
                    list.setCid(cateDto.getId() == null ? "" : list.getEs());
                }
                try {
                    monitor.subTask("[\uce74\ud14c\uace0\ub9ac\uc815\ubcf4 \uc218\uc9d1 \ucc98\ub9ac\uc911..] of " + workload + "...");
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    monitor.done();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static int saveShopProdInfo(String modi, List<ProductItemDto> contents, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String compno = YDMASessonUtil.getUserInfo().getCompno();
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                new StringBuilder();
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("COMPNO");
                lstInsert.add("GOODS_NM");
                lstInsert.add("GOODS_KEYWORD");
                lstInsert.add("MODEL_NM");
                lstInsert.add("BRAND_NM");
                lstInsert.add("COMPAYNY_GOODS_CD");
                lstInsert.add("PARTNER_ID");
                lstInsert.add("GOODS_SEARCH");
                lstInsert.add("SHOP_CID_INFO");
                lstInsert.add("SELECT_OPTION");
                lstInsert.add("TEXT_OPTION");
                lstInsert.add("CLASS_CD3");
                lstInsert.add("MAKER");
                lstInsert.add("ORIGIN");
                lstInsert.add("STATUS");
                lstInsert.add("TAX_YN");
                lstInsert.add("DELV_TYPE");
                lstInsert.add("DELV_COST");
                lstInsert.add("RETURN_DELV_COST");
                lstInsert.add("GOODS_COST");
                lstInsert.add("GOODS_PRICE");
                lstInsert.add("GOODS_CONSUMER_PRICE");
                lstInsert.add("ISLIMIT");
                lstInsert.add("LIMIT_PRICE");
                lstInsert.add("IS_OVERSEAS");
                lstInsert.add("ADULT");
                lstInsert.add("ISRETURN");
                lstInsert.add("ITYPE");
                lstInsert.add("CHAR_1_NM");
                lstInsert.add("CHAR_2_NM");
                lstInsert.add("CHAR_2_VAL");
                lstInsert.add("IMG_PATH");
                lstInsert.add("IMG_PATH1");
                lstInsert.add("IMG_PATH2");
                lstInsert.add("IMG_PATH3");
                lstInsert.add("IMG_PATH4");
                lstInsert.add("IMG_PATH5");
                lstInsert.add("IMG_PATH6");
                lstInsert.add("IMG_PATH7");
                lstInsert.add("IMG_PATH8");
                lstInsert.add("IMG_PATH9");
                lstInsert.add("GOODS_REMARKS");
                lstInsert.add("CERT_TYPE");
                lstInsert.add("CERT");
                lstInsert.add("CERTNO");
                lstInsert.add("STOCK_USE_YN");
                lstInsert.add("OPT_TYPE");
                lstInsert.add("PROP_EDIT_YN");
                lstInsert.add("PROP1_CD");
                lstInsert.add("PROP_VAL1");
                lstInsert.add("PROP_VAL2");
                lstInsert.add("PROP_VAL3");
                lstInsert.add("PROP_VAL4");
                lstInsert.add("PROP_VAL5");
                lstInsert.add("PROP_VAL6");
                lstInsert.add("PROP_VAL7");
                lstInsert.add("PROP_VAL8");
                lstInsert.add("PROP_VAL9");
                lstInsert.add("PROP_VAL10");
                lstInsert.add("PROP_VAL11");
                lstInsert.add("PROP_VAL12");
                lstInsert.add("PROP_VAL13");
                lstInsert.add("PROP_VAL14");
                lstInsert.add("PROP_VAL15");
                lstInsert.add("PROP_VAL16");
                lstInsert.add("PROP_VAL17");
                lstInsert.add("PROP_VAL18");
                lstInsert.add("PROP_VAL19");
                lstInsert.add("PROP_VAL20");
                lstInsert.add("PROP_VAL21");
                lstInsert.add("PROP_VAL22");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                lstInsert.add("MODIFYID");
                lstInsert.add("ShopSendStatus");
                lstInsert.add("ShopModifyContent");
                lstInsert.add("GMCATEGNM");
                lstInsert.add("DELV_QTY");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("GOODS_NM");
                lstUpdate.add("GOODS_KEYWORD");
                lstUpdate.add("MODEL_NM");
                lstUpdate.add("BRAND_NM");
                lstUpdate.add("COMPAYNY_GOODS_CD");
                lstUpdate.add("GOODS_SEARCH");
                lstUpdate.add("SHOP_CID_INFO");
                lstUpdate.add("SELECT_OPTION");
                lstUpdate.add("TEXT_OPTION");
                lstUpdate.add("CLASS_CD3");
                lstUpdate.add("MAKER");
                lstUpdate.add("ORIGIN");
                lstUpdate.add("STATUS");
                lstUpdate.add("TAX_YN");
                lstUpdate.add("DELV_TYPE");
                lstUpdate.add("DELV_COST");
                lstUpdate.add("RETURN_DELV_COST");
                lstUpdate.add("GOODS_COST");
                lstUpdate.add("GOODS_PRICE");
                lstUpdate.add("GOODS_CONSUMER_PRICE");
                lstUpdate.add("ISLIMIT");
                lstUpdate.add("LIMIT_PRICE");
                lstUpdate.add("IS_OVERSEAS");
                lstUpdate.add("ADULT");
                lstUpdate.add("ISRETURN");
                lstUpdate.add("ITYPE");
                lstUpdate.add("CHAR_1_NM");
                lstUpdate.add("CHAR_2_NM");
                lstUpdate.add("CHAR_2_VAL");
                lstUpdate.add("IMG_PATH");
                lstUpdate.add("IMG_PATH1");
                lstUpdate.add("IMG_PATH2");
                lstUpdate.add("IMG_PATH3");
                lstUpdate.add("IMG_PATH4");
                lstUpdate.add("IMG_PATH5");
                lstUpdate.add("IMG_PATH6");
                lstUpdate.add("IMG_PATH7");
                lstUpdate.add("IMG_PATH8");
                lstUpdate.add("IMG_PATH9");
                lstUpdate.add("GOODS_REMARKS");
                lstUpdate.add("CERT_TYPE");
                lstUpdate.add("CERT");
                lstUpdate.add("CERTNO");
                lstUpdate.add("STOCK_USE_YN");
                lstUpdate.add("OPT_TYPE");
                lstUpdate.add("PROP_EDIT_YN");
                lstUpdate.add("PROP1_CD");
                lstUpdate.add("PROP_VAL1");
                lstUpdate.add("PROP_VAL2");
                lstUpdate.add("PROP_VAL3");
                lstUpdate.add("PROP_VAL4");
                lstUpdate.add("PROP_VAL5");
                lstUpdate.add("PROP_VAL6");
                lstUpdate.add("PROP_VAL7");
                lstUpdate.add("PROP_VAL8");
                lstUpdate.add("PROP_VAL9");
                lstUpdate.add("PROP_VAL10");
                lstUpdate.add("PROP_VAL11");
                lstUpdate.add("PROP_VAL12");
                lstUpdate.add("PROP_VAL13");
                lstUpdate.add("PROP_VAL14");
                lstUpdate.add("PROP_VAL15");
                lstUpdate.add("PROP_VAL16");
                lstUpdate.add("PROP_VAL17");
                lstUpdate.add("PROP_VAL18");
                lstUpdate.add("PROP_VAL19");
                lstUpdate.add("PROP_VAL20");
                lstUpdate.add("PROP_VAL21");
                lstUpdate.add("PROP_VAL22");
                if (workload > 0) {
                    lstUpdate.add("INSERTDT");
                    lstUpdate.add("INSERTID");
                    lstUpdate.add("MODIFYID");
                } else if (workload >= 0) {
                    lstUpdate.add("MODIFYDT");
                    lstUpdate.add("MODIFYID");
                }
                lstUpdate.add("ShopSendStatus");
                lstUpdate.add("ShopModifyContent");
                lstUpdate.add("GMCATEGNM");
                lstUpdate.add("DELV_QTY");
                String sql = DomesinShopDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "shopprodinfo");
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductItemDto list : contents) {
                    DomesinOptionList options;
                    String[] parts;
                    int rowIdx = 0;
                    if (list.isModifyMode() && !list.isBaseInfoModify()) continue;
                    String shopcate_json = "";
                    DomesinShopDao.get();
                    String cate_json = shopcate_json = DomesinShopDao.getCateJson(list);
                    String select_option = list.getSelect_option();
                    String class_cd3 = "";
                    class_cd3 = list.getCid();
                    pstmt.setString(++rowIdx, compno);
                    pstmt.setString(++rowIdx, YDMAStringUtil.setTextStrtok(list.getIname(), 100));
                    pstmt.setString(++rowIdx, list.getSearch());
                    pstmt.setString(++rowIdx, list.getModel());
                    pstmt.setString(++rowIdx, list.getBrand().equals("") ? list.getMaker() : list.getBrand());
                    pstmt.setString(++rowIdx, list.getIcode());
                    pstmt.setString(++rowIdx, list.getVender_code());
                    pstmt.setString(++rowIdx, list.getKeyword());
                    pstmt.setString(++rowIdx, cate_json);
                    pstmt.setString(++rowIdx, select_option);
                    pstmt.setString(++rowIdx, list.getText_option());
                    pstmt.setString(++rowIdx, class_cd3);
                    pstmt.setString(++rowIdx, list.getMaker());
                    pstmt.setString(++rowIdx, list.getIcountry().equals("") ? list.getOrigin() : list.getIcountry());
                    pstmt.setString(++rowIdx, list.getStatus().equals("4") ? "0" : list.getStatus());
                    pstmt.setString(++rowIdx, list.getTax());
                    pstmt.setString(++rowIdx, list.getDelivery_type());
                    pstmt.setString(++rowIdx, list.getDelivery_amount());
                    pstmt.setString(++rowIdx, list.getR_delivery_amount() == null ? "0" : (list.getR_delivery_amount().equals("") ? "0" : list.getR_delivery_amount()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice_consumer()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIslimit()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getLimit_price()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIs_overseas()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getAdult()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIsreturn()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getItype()));
                    String optionName = "";
                    if (list.geteSellersExcelYN() != null && list.geteSellersExcelYN().equals("Y") && !(parts = list.getSelect_option_name().split("\n"))[0].equals("")) {
                        if (parts.length == 2) {
                            optionName = parts[0].equals("\ud544\uc218\uc120\ud0dd") ? "[" + parts[1] + "]" : "[" + parts[0] + "=" + parts[1] + "]";
                        }
                        String[] lines = list.getSelect_option_config().split("\n");
                        StringBuilder formattedOutputBuilder = new StringBuilder();
                        String[] stringArray = lines;
                        int n = lines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            String[] parts2 = line.split("\\*");
                            String optionNm1 = parts2[0];
                            String optionNm2 = parts2[1];
                            int optionPrice = Integer.parseInt(list.getPrice()) + Integer.parseInt(parts2[3]);
                            String limitPrice = list.getLimit_price().equals("") ? "0" : list.getLimit_price();
                            int priceConsumer = Integer.parseInt(list.getPrice_consumer());
                            String stock = Integer.parseInt(parts2[4]) == 0 ? "1" : "0";
                            String formattedOutputLine = String.valueOf(optionNm1) + "=" + optionNm2 + "=" + optionPrice + "=" + limitPrice + "=" + priceConsumer + "=" + stock;
                            formattedOutputBuilder.append(formattedOutputLine).append("\n");
                            ++n2;
                        }
                        list.setSelect_option(String.valueOf(optionName) + "\n" + formattedOutputBuilder.toString());
                    }
                    String option2 = (options = DomesinCommon.get().getOptionList(list.getSelect_option())).getChar_1_nm().isEmpty() ? "\ub2e8\ud488" : options.getChar_1_nm();
                    pstmt.setString(++rowIdx, option2);
                    pstmt.setString(++rowIdx, options.getChar_2_nm());
                    pstmt.setString(++rowIdx, options.getChar_2_val());
                    ArrayList<String> imgs = new ArrayList<String>();
                    int i = 0;
                    while (i < 10) {
                        if (i > list.getImg().length - 1) {
                            imgs.add("");
                        } else {
                            imgs.add(list.getImg()[i]);
                        }
                        ++i;
                    }
                    for (String img : imgs) {
                        pstmt.setString(++rowIdx, img);
                    }
                    String content = list.getContent().replaceAll("\"", "'");
                    content = content.replaceAll("\\\\", "");
                    pstmt.setString(++rowIdx, content);
                    pstmt.setString(++rowIdx, list.getCert_type());
                    if (list.getCert_type().equals("1") && list.getCert().contains("*")) {
                        String[] parts2 = list.getCert().toString().split("\\*");
                        pstmt.setString(++rowIdx, parts2[1]);
                        pstmt.setString(++rowIdx, parts2[2]);
                    } else if (list.getCert_type().equals("2") && list.getCert().contains("*")) {
                        pstmt.setString(++rowIdx, "");
                        pstmt.setString(++rowIdx, "");
                    } else {
                        pstmt.setString(++rowIdx, list.getCert());
                        pstmt.setString(++rowIdx, list.getCert_no());
                    }
                    pstmt.setString(++rowIdx, "N");
                    pstmt.setString(++rowIdx, "9");
                    pstmt.setString(++rowIdx, "Y");
                    pstmt.setString(++rowIdx, "0" + list.getGosi_code().replaceAll("[^0-9]", ""));
                    pstmt.setString(++rowIdx, list.getGosi1());
                    pstmt.setString(++rowIdx, list.getGosi2());
                    pstmt.setString(++rowIdx, list.getGosi3());
                    pstmt.setString(++rowIdx, list.getGosi4());
                    pstmt.setString(++rowIdx, list.getGosi5());
                    pstmt.setString(++rowIdx, list.getGosi6());
                    pstmt.setString(++rowIdx, list.getGosi7());
                    pstmt.setString(++rowIdx, list.getGosi8());
                    pstmt.setString(++rowIdx, list.getGosi9());
                    pstmt.setString(++rowIdx, list.getGosi10());
                    pstmt.setString(++rowIdx, list.getGosi11());
                    pstmt.setString(++rowIdx, list.getGosi12());
                    pstmt.setString(++rowIdx, list.getGosi13());
                    pstmt.setString(++rowIdx, list.getGosi14());
                    pstmt.setString(++rowIdx, list.getGosi15());
                    pstmt.setString(++rowIdx, list.getGosi16());
                    pstmt.setString(++rowIdx, list.getGosi17());
                    pstmt.setString(++rowIdx, list.getGosi18());
                    pstmt.setString(++rowIdx, list.getGosi19());
                    pstmt.setString(++rowIdx, list.getGosi20());
                    pstmt.setString(++rowIdx, list.getGosi21());
                    pstmt.setString(++rowIdx, list.getGosi22());
                    pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setInt(++rowIdx, list.getShopSendStatus());
                    String modifyContent = list.getChange_list();
                    pstmt.setString(++rowIdx, modifyContent);
                    pstmt.setString(++rowIdx, list.getPa_gmarket().equals("") ? list.getCateg_nm() : list.getPa_gmarket());
                    pstmt.setString(++rowIdx, String.valueOf(YDMAStringUtil.convertToInt(list.getDelivery_qty())));
                    String[] selfmod = DomesinShopDao.isShopProductInfoExits(compno, list.getIcode());
                    ArrayList<String> chgitems = new ArrayList<String>(Arrays.asList(selfmod));
                    if (!modi.equals("")) {
                        chgitems.set(0, modi);
                    }
                    if (((String)chgitems.get(0)).contains("2")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(5));
                    } else {
                        pstmt.setString(++rowIdx, YDMAStringUtil.setTextStrtok(list.getIname(), 100));
                    }
                    pstmt.setString(++rowIdx, list.getSearch());
                    pstmt.setString(++rowIdx, list.getModel());
                    pstmt.setString(++rowIdx, list.getBrand().equals("") ? list.getMaker() : list.getBrand());
                    pstmt.setString(++rowIdx, list.getIcode());
                    if (((String)chgitems.get(0)).contains("3")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(6));
                    } else {
                        pstmt.setString(++rowIdx, list.getKeyword());
                    }
                    if (((String)chgitems.get(0)).contains("1")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(13));
                    } else {
                        pstmt.setString(++rowIdx, cate_json);
                    }
                    if (((String)chgitems.get(0)).contains("9")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(19));
                    } else {
                        pstmt.setString(++rowIdx, select_option);
                    }
                    pstmt.setString(++rowIdx, list.getText_option());
                    pstmt.setString(++rowIdx, class_cd3);
                    pstmt.setString(++rowIdx, list.getMaker());
                    if (((String)chgitems.get(0)).contains("8")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(16));
                    } else {
                        pstmt.setString(++rowIdx, list.getIcountry().equals("") ? list.getOrigin() : list.getIcountry());
                    }
                    pstmt.setString(++rowIdx, list.getStatus().equals("4") ? "0" : list.getStatus());
                    pstmt.setString(++rowIdx, list.getTax());
                    pstmt.setString(++rowIdx, list.getDelivery_type());
                    if (((String)chgitems.get(0)).contains("7")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(15));
                    } else {
                        pstmt.setString(++rowIdx, list.getDelivery_amount());
                    }
                    if (((String)chgitems.get(0)).contains("A")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(18));
                    } else {
                        pstmt.setString(++rowIdx, list.getR_delivery_amount() == null ? "0" : (list.getR_delivery_amount().equals("") ? "0" : list.getR_delivery_amount()));
                    }
                    if (((String)chgitems.get(0)).contains("6")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(14));
                        pstmt.setString(++rowIdx, (String)chgitems.get(14));
                        pstmt.setString(++rowIdx, (String)chgitems.get(14));
                    } else {
                        pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice()));
                        pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice()));
                        pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getPrice_consumer()));
                    }
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIslimit()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getLimit_price()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIs_overseas()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getAdult()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getIsreturn()));
                    pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(list.getItype()));
                    if (((String)chgitems.get(0)).contains("9")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(17));
                    } else {
                        pstmt.setString(++rowIdx, option2);
                    }
                    pstmt.setString(++rowIdx, options.getChar_2_nm());
                    pstmt.setString(++rowIdx, options.getChar_2_val());
                    if (((String)chgitems.get(0)).contains("4")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(7));
                        pstmt.setString(++rowIdx, (String)chgitems.get(8));
                        pstmt.setString(++rowIdx, (String)chgitems.get(9));
                        pstmt.setString(++rowIdx, (String)chgitems.get(10));
                        pstmt.setString(++rowIdx, (String)chgitems.get(11));
                        pstmt.setString(++rowIdx, imgs.get(5) == null ? "" : ((String)imgs.get(5)).toString());
                        pstmt.setString(++rowIdx, imgs.get(6) == null ? "" : ((String)imgs.get(6)).toString());
                        pstmt.setString(++rowIdx, imgs.get(7) == null ? "" : ((String)imgs.get(7)).toString());
                        pstmt.setString(++rowIdx, imgs.get(8) == null ? "" : ((String)imgs.get(8)).toString());
                        pstmt.setString(++rowIdx, imgs.get(9) == null ? "" : ((String)imgs.get(9)).toString());
                    } else {
                        for (String img : imgs) {
                            pstmt.setString(++rowIdx, img);
                        }
                    }
                    if (((String)chgitems.get(0)).contains("5")) {
                        pstmt.setString(++rowIdx, (String)chgitems.get(12));
                    } else {
                        pstmt.setString(++rowIdx, content);
                    }
                    pstmt.setString(++rowIdx, list.getCert_type());
                    if (list.getCert_type().equals("1") && list.getCert().contains("*")) {
                        String[] parts3 = list.getCert().toString().split("\\*");
                        pstmt.setString(++rowIdx, parts3[1]);
                        pstmt.setString(++rowIdx, parts3[2]);
                    } else if (list.getCert_type().equals("2") && list.getCert().contains("*")) {
                        pstmt.setString(++rowIdx, "");
                        pstmt.setString(++rowIdx, "");
                    } else {
                        pstmt.setString(++rowIdx, list.getCert());
                        pstmt.setString(++rowIdx, list.getCert_no());
                    }
                    pstmt.setString(++rowIdx, "N");
                    pstmt.setString(++rowIdx, "9");
                    pstmt.setString(++rowIdx, "Y");
                    pstmt.setString(++rowIdx, "0" + list.getGosi_code().replaceAll("[^0-9]", ""));
                    pstmt.setString(++rowIdx, list.getGosi1());
                    pstmt.setString(++rowIdx, list.getGosi2());
                    pstmt.setString(++rowIdx, list.getGosi3());
                    pstmt.setString(++rowIdx, list.getGosi4());
                    pstmt.setString(++rowIdx, list.getGosi5());
                    pstmt.setString(++rowIdx, list.getGosi6());
                    pstmt.setString(++rowIdx, list.getGosi7());
                    pstmt.setString(++rowIdx, list.getGosi8());
                    pstmt.setString(++rowIdx, list.getGosi9());
                    pstmt.setString(++rowIdx, list.getGosi10());
                    pstmt.setString(++rowIdx, list.getGosi11());
                    pstmt.setString(++rowIdx, list.getGosi12());
                    pstmt.setString(++rowIdx, list.getGosi13());
                    pstmt.setString(++rowIdx, list.getGosi14());
                    pstmt.setString(++rowIdx, list.getGosi15());
                    pstmt.setString(++rowIdx, list.getGosi16());
                    pstmt.setString(++rowIdx, list.getGosi17());
                    pstmt.setString(++rowIdx, list.getGosi18());
                    pstmt.setString(++rowIdx, list.getGosi19());
                    pstmt.setString(++rowIdx, list.getGosi20());
                    pstmt.setString(++rowIdx, list.getGosi21());
                    pstmt.setString(++rowIdx, list.getGosi22());
                    if (workload > 0) {
                        pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    } else if (workload >= 0) {
                        pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++rowIdx, list.getUp_datetime());
                    }
                    pstmt.setInt(++rowIdx, list.getShopSendStatus());
                    pstmt.setString(++rowIdx, modifyContent);
                    pstmt.setString(++rowIdx, list.getPa_gmarket().equals("") ? list.getCateg_nm() : list.getPa_gmarket());
                    pstmt.setString(++rowIdx, String.valueOf(YDMAStringUtil.convertToInt(list.getDelivery_qty())));
                    ++result;
                    ++row;
                    if (workload > 0) {
                        try {
                            monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \ucc98\ub9ac\uc911..] " + list.getIcode() + " " + result + " of " + workload + "...");
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                monitor.done();
                                break;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    if (result <= 1 || result % 1000 != 0) continue;
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                    connection.setAutoCommit(false);
                    row = 0;
                }
                if (row > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    private static String getCategorySetting(ProductItemDto list) throws Exception {
        String shopcate_json = "";
        try {
            if (list.getEs() == null || list.getEs().equals("")) {
                DomesinShopDao.get();
                shopcate_json = DomesinShopDao.getCateJson(list);
            } else {
                ShopCateDto cateDto = ShopCommonDao.get().getCategoryAPI(list.getEs());
                if (cateDto.getId() != null) {
                    list.setEs(cateDto.getId());
                }
                String domeJson = cateDto.getDomecatg();
                String shopJson = cateDto.getShopcate();
                if (shopJson == null || shopJson.equals("")) {
                    DomesinShopDao.get();
                    shopcate_json = DomesinShopDao.getCateJson(list);
                } else {
                    shopcate_json = ShopCommonDao.get().getCategoryShopApiSetting(shopJson, list);
                }
                String domecate_json = "";
                domecate_json = domeJson == null || domeJson.equals("") ? ShopCommonDao.get().getCateDomeJson(list) : ShopCommonDao.get().getCategoryDomeSetting(domeJson, list.getSearch(), list.getCid());
                ObjectMapper mapper = new ObjectMapper();
                JsonNode actualObjShop1 = mapper.readTree(shopcate_json);
                JsonNode actualObjShop2 = mapper.readTree(shopJson);
                JsonNode actualObjdome1 = mapper.readTree(domecate_json);
                JsonNode actualObjdome2 = mapper.readTree(domeJson);
                if (!actualObjShop1.equals((Object)actualObjShop2) || !actualObjdome1.equals((Object)actualObjdome2)) {
                    ShopCommonDao.get().setCategoryMapUpdateApi(list.getEs(), shopcate_json, domecate_json);
                }
                list.setCid(cateDto.getId() == null ? "" : list.getEs());
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return shopcate_json;
    }

    public int MarginInsert(String title, String shopid, String testprice, String sellerdiscount, String discountrate, String cumdiscount, String marginrate, String commrate, String marketselprice, String useyn, String shopcd) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        int result = 0;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into marginmngr (compno,SHOPCD,TITLE, SHOPID, TESTPRICE, SELLERDISCOUNT,DISCOUNTRATE,CUMDISCOUNT,MARGINRATE,COMMRATE,MARKETSELPRICE,USE_YN,INSERTDT,INSERTID )   values (?, ?, ?, ?, ?, ? , ?, ?, ?, ?, ?, ?, ?, ?) ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, shopcd);
                pstmt.setString(++i, title);
                pstmt.setString(++i, shopid);
                pstmt.setString(++i, testprice);
                pstmt.setString(++i, sellerdiscount);
                pstmt.setString(++i, discountrate);
                pstmt.setString(++i, cumdiscount);
                pstmt.setString(++i, marginrate);
                pstmt.setString(++i, commrate);
                pstmt.setString(++i, marketselprice);
                pstmt.setString(++i, useyn);
                pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
                YDMAStringUtil.Print("[CategoryLargeInsert]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public List<List<String>> getMarginList(String date, String shopping, String search, String prodFrom, String prodTo, int shopcd, String useyn, List<String> shoplist) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select MARGINSEQ, ifnull(SHOPCD,''), ifnull(TITLE,''), ifnull(SHOPID,''), ifnull(TESTPRICE,'0'), ifnull(SELLERDISCOUNT,'0'), ifnull(DISCOUNTRATE,'0'),  ifnull(CUMDISCOUNT,'0'), ifnull(MARGINRATE,'0'), ifnull(COMMRATE,'0'), ifnull(MARKETSELPRICE,'0'), ifnull(USE_YN,''), ifnull(INSERTDT,''), ifnull(INSERTID,''),  ifnull(MODIFYDT,''), ifnull(MODIFYID,'') from marginmngr where compno = ? ";
                sql = String.valueOf(sql) + String.format(" and %s >= '%s' and %s <= '%s' ", date, prodFrom, date, prodTo);
                if (!useyn.equals("")) {
                    sql = String.valueOf(sql) + String.format(" and USE_YN = '%s' ", useyn);
                }
                if (!shopping.equals("")) {
                    sql = String.valueOf(sql) + String.format(" and %s like % " + search + "% ", shopping);
                }
                if (shopcd != 0) {
                    sql = String.valueOf(sql) + String.format(" and shopcd = '%s' ", shoplist.get(0));
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getCategorySearchList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int MarginUpdate(String title, String shopid, String testprice, String sellerdiscount, String discountrate, String cumdiscount, String marginrate, String commrate, String marketselprice, String useyn, List<String> uplist) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        int result = 0;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update marginmngr set TITLE = ?, SHOPID = ?, TESTPRICE = ?, SELLERDISCOUNT = ?,DISCOUNTRATE = ?,CUMDISCOUNT = ?,MARGINRATE = ?, COMMRATE = ?, MARKETSELPRICE = ?, USE_YN = ? ,MODIFYDT = ?,MODIFYID = ? where compno = ? and MARGINSEQ = ? and shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, title);
                pstmt.setString(++i, shopid);
                pstmt.setString(++i, testprice);
                pstmt.setString(++i, sellerdiscount);
                pstmt.setString(++i, discountrate);
                pstmt.setString(++i, cumdiscount);
                pstmt.setString(++i, marginrate);
                pstmt.setString(++i, commrate);
                pstmt.setString(++i, marketselprice);
                pstmt.setString(++i, useyn);
                pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, uplist.get(0));
                pstmt.setString(++i, uplist.get(1));
                YDMAStringUtil.Print("[CategoryLargeInsert]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public void MarginListDelete(List<List<String>> contents) throws Exception {
        block6: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "delete from marginmngr where compno = ? and MARGINSEQ = ? and shopcd = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (List<String> list : contents) {
                        int i = 0;
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setString(++i, list.get(0));
                        pstmt.setString(++i, list.get(1));
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[prodAttrvalInsert]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public List<DomesinMarginDto> getMarginSelectList(String shopcd) throws Exception {
        ArrayList<DomesinMarginDto> list = new ArrayList<DomesinMarginDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select MARGINSEQ, ifnull(SHOPCD,''), ifnull(TITLE,''), ifnull(SHOPID,''), ifnull(TESTPRICE,'0'), ifnull(SELLERDISCOUNT,'0'), ifnull(DISCOUNTRATE,'0'),  ifnull(CUMDISCOUNT,'0'), ifnull(MARGINRATE,'0'), ifnull(COMMRATE,'0'), ifnull(MARKETSELPRICE,'0'), ifnull(USE_YN,''), ifnull(INSERTDT,''), ifnull(INSERTID,''),  ifnull(MODIFYDT,''), ifnull(MODIFYID,'') from marginmngr where compno = ? and shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[getCategorySearchList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    DomesinMarginDto dto = new DomesinMarginDto();
                    int columnIndex = 0;
                    dto.setMarginseq(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setTestprice(rs.getString(++columnIndex));
                    dto.setSellerdiscount(rs.getString(++columnIndex));
                    dto.setDiscountrate(rs.getString(++columnIndex));
                    dto.setCumdiscount(rs.getString(++columnIndex));
                    dto.setMarginrate(rs.getString(++columnIndex));
                    dto.setCommrate(rs.getString(++columnIndex));
                    dto.setMarketselprice(rs.getString(++columnIndex));
                    dto.setUse_yn(rs.getString(++columnIndex));
                    dto.setInsertdt(rs.getString(++columnIndex));
                    dto.setInsertid(rs.getString(++columnIndex));
                    dto.setModifydt(rs.getString(++columnIndex));
                    dto.setModifyid(rs.getString(++columnIndex));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public DomesinMarginDto MarginOneSelect(String marginseq, String shopcd) throws Exception {
        DomesinMarginDto dto = new DomesinMarginDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select MARGINSEQ, ifnull(SHOPCD,''), ifnull(TITLE,''), ifnull(SHOPID,''), ifnull(TESTPRICE,'0'), ifnull(SELLERDISCOUNT,'0'), ifnull(DISCOUNTRATE,'0'),  ifnull(CUMDISCOUNT,'0'), ifnull(MARGINRATE,'0'), ifnull(COMMRATE,'0'), ifnull(MARKETSELPRICE,'0'), ifnull(USE_YN,''), ifnull(INSERTDT,''), ifnull(INSERTID,''),  ifnull(MODIFYDT,''), ifnull(MODIFYID,'') from marginmngr where compno = ? and shopcd = ? and MARGINSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, marginseq);
                YDMAStringUtil.Print("[getCategorySearchList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setMarginseq(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setTestprice(rs.getString(++columnIndex));
                    dto.setSellerdiscount(rs.getString(++columnIndex));
                    dto.setDiscountrate(rs.getString(++columnIndex));
                    dto.setCumdiscount(rs.getString(++columnIndex));
                    dto.setMarginrate(rs.getString(++columnIndex));
                    dto.setCommrate(rs.getString(++columnIndex));
                    dto.setMarketselprice(rs.getString(++columnIndex));
                    dto.setUse_yn(rs.getString(++columnIndex));
                    dto.setInsertdt(rs.getString(++columnIndex));
                    dto.setInsertid(rs.getString(++columnIndex));
                    dto.setModifydt(rs.getString(++columnIndex));
                    dto.setModifyid(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ShopOrderMstDto> getNaverDeliveryCode(List<ShopOrderMstDto> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(URL,'') from expressdeliverys where CODE = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, list.get(0).getDelvcode());
                YDMAStringUtil.Print("[getCategorySearchList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.get(0).setDelvurl(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void setShopProductInUpdate(String modi, List<ProductDTO> parentList) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                StringBuilder sql = new StringBuilder();
                sql.append(" update shopprodin set \r\n");
                sql.append("CLASS_CD1 = ? ,\r\n ");
                sql.append("CLASS_CD2 = ? ,\r\n ");
                sql.append("CLASS_CD3 = ? ,\r\n ");
                sql.append("CLASS_CD4 = ? ,\r\n ");
                sql.append("GOODS_NM = ? ,\r\n ");
                sql.append("GOODS_SEARCH = ? ,\r\n ");
                sql.append("SHOP_CID_INFO = ? ,\r\n");
                sql.append("MODEL_NM = ? ,\r\n ");
                sql.append("BRAND_NM = ? ,\r\n ");
                sql.append("SELECT_OPTION = ? ,\r\n ");
                sql.append("TEXT_OPTION = ? ,\r\n ");
                sql.append("GOODS_COST = ? ,\r\n ");
                sql.append("ISLIMIT = ? ,\r\n ");
                sql.append("LIMIT_PRICE = ? ,\r\n ");
                sql.append("IS_OVERSEAS = ? ,\r\n ");
                sql.append("ADULT = ? ,\r\n ");
                sql.append("ISRETURN = ? ,\r\n ");
                sql.append("ITYPE = ? ,\r\n ");
                sql.append("CHAR_1_NM = ? ,\r\n ");
                sql.append("CHAR_2_NM = ? ,\r\n ");
                sql.append("CHAR_2_VAL = ? ,\r\n ");
                sql.append("CERT_TYPE = ? ,\r\n ");
                sql.append("CERT = ? ,\r\n ");
                sql.append("CERTNO = ? ,\r\n ");
                sql.append("STOCK_USE_YN = ? ,\r\n ");
                sql.append("OPT_TYPE = ? ,\r\n ");
                sql.append("PROP_EDIT_YN = ? ,\r\n ");
                sql.append("MAKER = ? ,\r\n ");
                sql.append("ORIGIN = ? ,\r\n ");
                sql.append("STATUS = ? ,\r\n ");
                sql.append("TAX_YN = ? ,\r\n ");
                sql.append("DELV_TYPE = ? ,\r\n ");
                sql.append("DELV_COST = ? ,\r\n ");
                sql.append("RETURN_DELV_COST = ? ,\r\n ");
                sql.append("GOODS_PRICE = ? ,\r\n ");
                sql.append("GOODS_CONSUMER_PRICE = ? ,\r\n ");
                sql.append("IMG_PATH = ? ,\r\n ");
                sql.append("IMG_PATH1 = ? ,\r\n ");
                sql.append("IMG_PATH2 = ? ,\r\n ");
                sql.append("IMG_PATH3 = ? ,\r\n ");
                sql.append("IMG_PATH4 = ? ,\r\n ");
                sql.append("IMG_PATH5 = ? ,\r\n ");
                sql.append("IMG_PATH6 = ? ,\r\n ");
                sql.append("IMG_PATH7 = ? ,\r\n ");
                sql.append("IMG_PATH8 = ? ,\r\n ");
                sql.append("IMG_PATH9 = ? ,\r\n ");
                sql.append("GOODS_REMARKS = ? ,\r\n ");
                sql.append("PROP1_CD = ? ,\r\n ");
                sql.append("PROP_VAL1 = ? ,\r\n ");
                sql.append("PROP_VAL2 = ? ,\r\n ");
                sql.append("PROP_VAL3 = ? ,\r\n ");
                sql.append("PROP_VAL4 = ? ,\r\n ");
                sql.append("PROP_VAL5 = ? ,\r\n ");
                sql.append("PROP_VAL6 = ? ,\r\n ");
                sql.append("PROP_VAL7 = ? ,\r\n ");
                sql.append("PROP_VAL8 = ? ,\r\n ");
                sql.append("PROP_VAL9 = ? ,\r\n ");
                sql.append("PROP_VAL10 = ? ,\r\n ");
                sql.append("PROP_VAL11 = ? ,\r\n ");
                sql.append("PROP_VAL12 = ? ,\r\n ");
                sql.append("PROP_VAL13 = ? ,\r\n ");
                sql.append("PROP_VAL14 = ? ,\r\n ");
                sql.append("PROP_VAL15 = ? ,\r\n ");
                sql.append("PROP_VAL16 = ? ,\r\n ");
                sql.append("PROP_VAL17 = ? ,\r\n ");
                sql.append("PROP_VAL18 = ? ,\r\n ");
                sql.append("PROP_VAL19 = ? ,\r\n ");
                sql.append("PROP_VAL20 = ? ,\r\n ");
                sql.append("PROP_VAL21 = ? ,\r\n ");
                sql.append("PROP_VAL22 = ? ,\r\n ");
                sql.append("SHOPMODIFYCONTENT = ? ,\r\n ");
                sql.append("SHOPSENDSTATUS = ? ,\r\n ");
                sql.append("modifydt = ? ,\r\n ");
                sql.append("modifyid = ? \r\n ");
                sql.append("where sendseq = ? and compno = ? ");
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductDTO dto : parentList) {
                    List<ProductDTO> childList = this.isShopProductInExits(dto.getPRODSEQ());
                    for (ProductDTO dtoch : childList) {
                        if (!modi.equals("")) {
                            dtoch.setSelfmod_no(modi);
                        }
                        int j = 0;
                        pstmt.setString(++j, dto.getClass_cd1());
                        pstmt.setString(++j, dto.getClass_cd2());
                        pstmt.setString(++j, dto.getClass_cd3());
                        pstmt.setString(++j, dto.getClass_cd4());
                        if (dtoch.getSelfmod_no().contains("2")) {
                            pstmt.setString(++j, dtoch.getGoods_nm());
                        } else {
                            pstmt.setString(++j, dto.getGoods_nm());
                        }
                        if (dtoch.getSelfmod_no().contains("3")) {
                            pstmt.setString(++j, dtoch.getGoods_search());
                        } else {
                            pstmt.setString(++j, dto.getGoods_search());
                        }
                        if (dtoch.getSelfmod_no().contains("1")) {
                            pstmt.setString(++j, dtoch.getShop_cid_info());
                        } else {
                            pstmt.setString(++j, dto.getShop_cid_info());
                        }
                        pstmt.setString(++j, dto.getModel_nm());
                        pstmt.setString(++j, dto.getBrand_nm());
                        if (dtoch.getSelfmod_no().contains("9")) {
                            pstmt.setString(++j, dtoch.getSelect_option());
                        } else {
                            pstmt.setString(++j, dto.getSelect_option());
                        }
                        pstmt.setString(++j, dto.getText_option());
                        if (dtoch.getSelfmod_no().contains("6")) {
                            pstmt.setString(++j, dtoch.getGoods_cost());
                        } else {
                            pstmt.setString(++j, dto.getGoods_cost());
                        }
                        pstmt.setString(++j, dto.getIslimit());
                        pstmt.setString(++j, dto.getLimit_price());
                        pstmt.setString(++j, dto.getIs_overseas());
                        pstmt.setString(++j, dto.getAdult());
                        pstmt.setString(++j, dto.getIsreturn());
                        pstmt.setString(++j, dto.getItype());
                        pstmt.setString(++j, dto.getChar_1_nm());
                        pstmt.setString(++j, dto.getChar_2_nm());
                        pstmt.setString(++j, dto.getChar_2_val());
                        pstmt.setString(++j, dto.getCert_type());
                        pstmt.setString(++j, dto.getCert());
                        pstmt.setString(++j, dto.getCertno());
                        pstmt.setString(++j, dto.getStock_use_yn());
                        pstmt.setString(++j, dto.getOpt_type());
                        pstmt.setString(++j, dto.getProp_edit_yn());
                        pstmt.setString(++j, dto.getMaker());
                        if (dtoch.getSelfmod_no().contains("8")) {
                            pstmt.setString(++j, dtoch.getOrigin());
                        } else {
                            pstmt.setString(++j, dto.getOrigin());
                        }
                        pstmt.setString(++j, dto.getStatus().equals("4") ? "0" : dto.getStatus());
                        pstmt.setString(++j, dto.getTax_yn());
                        pstmt.setString(++j, dto.getDelv_type());
                        if (dtoch.getSelfmod_no().contains("7")) {
                            pstmt.setString(++j, dtoch.getDelv_cost());
                        } else {
                            pstmt.setString(++j, dto.getDelv_cost());
                        }
                        if (dtoch.getSelfmod_no().contains("A")) {
                            pstmt.setString(++j, dtoch.getDelv_r_cost());
                        } else {
                            pstmt.setString(++j, dto.getDelv_r_cost());
                        }
                        pstmt.setString(++j, dto.getGoods_price());
                        pstmt.setString(++j, dto.getGoods_consumer_price());
                        if (dtoch.getSelfmod_no().contains("4")) {
                            pstmt.setString(++j, dtoch.getImg_path());
                            pstmt.setString(++j, dtoch.getImg_path1());
                            pstmt.setString(++j, dtoch.getImg_path2());
                            pstmt.setString(++j, dtoch.getImg_path3());
                            pstmt.setString(++j, dtoch.getImg_path4());
                        } else {
                            pstmt.setString(++j, dto.getImg_path());
                            pstmt.setString(++j, dto.getImg_path1());
                            pstmt.setString(++j, dto.getImg_path2());
                            pstmt.setString(++j, dto.getImg_path3());
                            pstmt.setString(++j, dto.getImg_path4());
                        }
                        pstmt.setString(++j, dto.getImg_path5());
                        pstmt.setString(++j, dto.getImg_path6());
                        pstmt.setString(++j, dto.getImg_path7());
                        pstmt.setString(++j, dto.getImg_path8());
                        pstmt.setString(++j, dto.getImg_path9());
                        if (dtoch.getSelfmod_no().contains("5")) {
                            pstmt.setString(++j, dtoch.getGoods_remarks());
                        } else {
                            pstmt.setString(++j, dto.getGoods_remarks());
                        }
                        pstmt.setString(++j, dto.getProp1_cd());
                        pstmt.setString(++j, dto.getProp_val1());
                        pstmt.setString(++j, dto.getProp_val2());
                        pstmt.setString(++j, dto.getProp_val3());
                        pstmt.setString(++j, dto.getProp_val4());
                        pstmt.setString(++j, dto.getProp_val5());
                        pstmt.setString(++j, dto.getProp_val6());
                        pstmt.setString(++j, dto.getProp_val7());
                        pstmt.setString(++j, dto.getProp_val8());
                        pstmt.setString(++j, dto.getProp_val9());
                        pstmt.setString(++j, dto.getProp_val10());
                        pstmt.setString(++j, dto.getProp_val11());
                        pstmt.setString(++j, dto.getProp_val12());
                        pstmt.setString(++j, dto.getProp_val13());
                        pstmt.setString(++j, dto.getProp_val14());
                        pstmt.setString(++j, dto.getProp_val15());
                        pstmt.setString(++j, dto.getProp_val16());
                        pstmt.setString(++j, dto.getProp_val17());
                        pstmt.setString(++j, dto.getProp_val18());
                        pstmt.setString(++j, dto.getProp_val19());
                        pstmt.setString(++j, dto.getProp_val20());
                        pstmt.setString(++j, dto.getProp_val21());
                        pstmt.setString(++j, dto.getProp_val22());
                        pstmt.setString(++j, dto.getShopmodifycontent());
                        if (dtoch.getSendstats().equals(String.valueOf(9000))) {
                            pstmt.setInt(++j, 9000);
                        } else if (dtoch.getSendstats().equals(String.valueOf(6000))) {
                            pstmt.setInt(++j, 6000);
                        } else if (dtoch.getSendstats().equals(String.valueOf(8000)) && dtoch.getSelfmod_no().length() > 0) {
                            pstmt.setInt(++j, 6000);
                        } else {
                            pstmt.setInt(++j, 7000);
                        }
                        pstmt.setString(++j, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++j, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt.setString(++j, dtoch.getSENDSEQ());
                        pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
                        YDMAStringUtil.Print("[setShopProductInUpdate]" + pstmt.toString());
                        ++result;
                        ++row;
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    if (result <= true || result % 1000 != 0) continue;
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                    connection.setAutoCommit(false);
                    row = 0;
                }
                if (row > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    private List<ProductDTO> isShopProductInExits(String prodseq) {
        ArrayList<ProductDTO> dtolist;
        block12: {
            dtolist = new ArrayList<ProductDTO>();
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT sendseq AS SENDSEQ, \t\tifnull(SHOPSENDSTATUS,9000) as SHOPSENDSTATUS, \t\tifnull(SELFMOD_NO,'') as SELFMOD_NO, \t\tifnull(CLASS_CD1,'') as CLASS_CD1, \t\tifnull(CLASS_CD2,'') as CLASS_CD2, \t\tifnull(CLASS_CD3,'') as CLASS_CD3, \t\tifnull(CLASS_CD4,'') as CLASS_CD4, \t\tifnull(GOODS_NM,'') as GOODS_NM, \t\tifnull(GOODS_SEARCH,'') as GOODS_SEARCH, \t\tifnull(IMG_PATH,'') as IMG_PATH,ifnull(IMG_PATH1,'') as IMG_PATH1,\t\tifnull(IMG_PATH2,'') as IMG_PATH2,ifnull(IMG_PATH3,'') as IMG_PATH3,\t\tifnull(IMG_PATH4,'') as IMG_PATH4,\t\tifnull(GOODS_REMARKS,'') as GOODS_REMARKS,\t\tifnull(SHOP_CID_INFO,'') as SHOP_CID_INFO,\t\tifnull(GOODS_COST,'0') as GOODS_COST,\t\tifnull(DELV_COST,'0') as DELV_COST,\t\tifnull(ORIGIN,'') as ORIGIN,\t\tifnull(CHAR_1_NM,'') as CHAR_1_NM,\t\tifnull(RETURN_DELV_COST,'0') as RETURN_DELV_COST,\t\tifnull(SELECT_OPTION,'') as SELECT_OPTION  FROM shopprodin  WHERE compno = ? and PRODSEQ=? and SHOPSENDSTATUS NOT IN('4000','3000','2000')";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_orddtl.setString(2, prodseq);
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        ProductDTO dto = new ProductDTO();
                        dto.setSENDSEQ(rs.getString("SENDSEQ"));
                        dto.setSendstats(rs.getString("SHOPSENDSTATUS"));
                        dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                        dto.setClass_cd1(rs.getString("CLASS_CD1"));
                        dto.setClass_cd2(rs.getString("CLASS_CD2"));
                        dto.setClass_cd3(rs.getString("CLASS_CD3"));
                        dto.setClass_cd4(rs.getString("CLASS_CD4"));
                        dto.setGoods_nm(rs.getString("GOODS_NM"));
                        dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                        dto.setImg_path(rs.getString("IMG_PATH"));
                        dto.setImg_path1(rs.getString("IMG_PATH1"));
                        dto.setImg_path2(rs.getString("IMG_PATH2"));
                        dto.setImg_path3(rs.getString("IMG_PATH3"));
                        dto.setImg_path4(rs.getString("IMG_PATH4"));
                        dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                        dto.setShop_cid_info(rs.getString("SHOP_CID_INFO"));
                        dto.setGoods_cost(rs.getString("GOODS_COST"));
                        dto.setDelv_cost(rs.getString("DELV_COST"));
                        dto.setOrigin(rs.getString("ORIGIN"));
                        dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                        dto.setDelv_r_cost(rs.getString("RETURN_DELV_COST"));
                        dto.setSelect_option(rs.getString("SELECT_OPTION"));
                        dtolist.add(dto);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dtolist;
    }

    public static String[] isShopProductInfoExits(String compno, String company_goods_cd) {
        String[] result;
        block13: {
            new ArrayList();
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            result = new String[20];
            int i = 0;
            while (i < 20) {
                result[i] = "";
                ++i;
            }
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT ifnull(SELFMOD_NO,'') as SELFMOD_NO,\t\tifnull(CLASS_CD1,'') as CLASS_CD1,\t\tifnull(CLASS_CD2,'') as CLASS_CD2,\t\tifnull(CLASS_CD3,'') as CLASS_CD3,\t\tifnull(CLASS_CD4,'') as CLASS_CD4,\t\tifnull(GOODS_NM,'') as GOODS_NM,\t\tifnull(GOODS_SEARCH,'') as GOODS_SEARCH,\t\tifnull(IMG_PATH,'') as IMG_PATH,ifnull(IMG_PATH1,'') as IMG_PATH1,\t\tifnull(IMG_PATH2,'') as IMG_PATH2,ifnull(IMG_PATH3,'') as IMG_PATH3,\t\tifnull(IMG_PATH4,'') as IMG_PATH4,\t\tifnull(GOODS_REMARKS,'') as GOODS_REMARKS,\t\tifnull(SHOP_CID_INFO,'') as SHOP_CID_INFO,\t\tifnull(GOODS_COST,'0') as GOODS_COST,\t\tifnull(DELV_COST,'0') as DELV_COST,\t\tifnull(ORIGIN,'') as ORIGIN,\t\tifnull(CHAR_1_NM,'') as CHAR_1_NM,\t\tifnull(RETURN_DELV_COST,'0') as RETURN_DELV_COST,\t\tifnull(SELECT_OPTION,'') as SELECT_OPTION  FROM shopprodinfo  WHERE compno=?    and COMPAYNY_GOODS_CD=?";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, compno);
                    pstmt_orddtl.setString(2, company_goods_cd);
                    YDMAStringUtil.Print("[isShopProductInfoExits \uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        int idx = 0;
                        result[idx++] = rs.getString("SELFMOD_NO");
                        result[idx++] = rs.getString("CLASS_CD1");
                        result[idx++] = rs.getString("CLASS_CD2");
                        result[idx++] = rs.getString("CLASS_CD3");
                        result[idx++] = rs.getString("CLASS_CD4");
                        result[idx++] = rs.getString("GOODS_NM");
                        result[idx++] = rs.getString("GOODS_SEARCH");
                        result[idx++] = rs.getString("IMG_PATH");
                        result[idx++] = rs.getString("IMG_PATH1");
                        result[idx++] = rs.getString("IMG_PATH2");
                        result[idx++] = rs.getString("IMG_PATH3");
                        result[idx++] = rs.getString("IMG_PATH4");
                        result[idx++] = rs.getString("GOODS_REMARKS");
                        result[idx++] = rs.getString("SHOP_CID_INFO");
                        result[idx++] = rs.getString("GOODS_COST");
                        result[idx++] = rs.getString("DELV_COST");
                        result[idx++] = rs.getString("ORIGIN");
                        result[idx++] = rs.getString("CHAR_1_NM");
                        result[idx++] = rs.getString("RETURN_DELV_COST");
                        result[idx++] = rs.getString("SELECT_OPTION");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String[] isShopProductInfoEditExits(String compno, String company_goods_cd, String prodseq) {
        String[] result;
        block13: {
            new ArrayList();
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            result = new String[20];
            int i = 0;
            while (i < 20) {
                result[i] = "";
                ++i;
            }
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT ifnull(SELFMOD_NO,'') as SELFMOD_NO,\t\tifnull(CLASS_CD1,'') as CLASS_CD1,\t\tifnull(CLASS_CD2,'') as CLASS_CD2,\t\tifnull(CLASS_CD3,'') as CLASS_CD3,\t\tifnull(CLASS_CD4,'') as CLASS_CD4,\t\tifnull(GOODS_NM,'') as GOODS_NM,\t\tifnull(GOODS_SEARCH,'') as GOODS_SEARCH,\t\tifnull(IMG_PATH,'') as IMG_PATH,ifnull(IMG_PATH1,'') as IMG_PATH1,\t\tifnull(IMG_PATH2,'') as IMG_PATH2,ifnull(IMG_PATH3,'') as IMG_PATH3,\t\tifnull(IMG_PATH4,'') as IMG_PATH4,\t\tifnull(GOODS_REMARKS,'') as GOODS_REMARKS,\t\tifnull(SHOP_CID_INFO,'') as SHOP_CID_INFO  FROM shopprodinfo  WHERE compno=?    and COMPAYNY_GOODS_CD=? and prodseq = ? ";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, compno);
                    pstmt_orddtl.setString(2, company_goods_cd);
                    pstmt_orddtl.setString(3, prodseq);
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        int idx = 0;
                        result[idx++] = rs.getString("SELFMOD_NO");
                        result[idx++] = rs.getString("CLASS_CD1");
                        result[idx++] = rs.getString("CLASS_CD2");
                        result[idx++] = rs.getString("CLASS_CD3");
                        result[idx++] = rs.getString("CLASS_CD4");
                        result[idx++] = rs.getString("GOODS_NM");
                        result[idx++] = rs.getString("GOODS_SEARCH");
                        result[idx++] = rs.getString("IMG_PATH");
                        result[idx++] = rs.getString("IMG_PATH1");
                        result[idx++] = rs.getString("IMG_PATH2");
                        result[idx++] = rs.getString("IMG_PATH3");
                        result[idx++] = rs.getString("IMG_PATH4");
                        result[idx++] = rs.getString("GOODS_REMARKS");
                        result[idx++] = rs.getString("SHOP_CID_INFO");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void saveShopOptProdIn(String modi, List<ProductItemDto> contents) throws Exception {
        int row = 0;
        Connection connection2 = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist2 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection2 = DBCPInit.getInstance().getConnection();
                connection2.setAutoCommit(false);
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("SENDSEQ");
                lstInsert.add("SKUSEQ");
                lstInsert.add("COMPNO");
                lstInsert.add("SHOPPRODNO");
                lstInsert.add("SHOPPRODSKU_NM");
                lstInsert.add("PRODSEQ");
                lstInsert.add("OPTPRODCD");
                lstInsert.add("OPTPRODNM");
                lstInsert.add("OPTSPECDES");
                lstInsert.add("OPTSAFESTOCK");
                lstInsert.add("OPTVERTSTOCK");
                lstInsert.add("OPTADDAMT");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("SHOPPRODSKU_NM");
                lstUpdate.add("OPTPRODCD");
                lstUpdate.add("OPTPRODNM");
                lstUpdate.add("OPTSPECDES");
                lstUpdate.add("OPTSAFESTOCK");
                lstUpdate.add("OPTVERTSTOCK");
                lstUpdate.add("OPTADDAMT");
                lstUpdate.add("MODIFYDT");
                lstUpdate.add("MODIFYID");
                String sql2 = DomesinShopDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "shop_optprodin");
                sql2 = sql2.toUpperCase();
                pstmt2 = connection2.prepareStatement(sql2);
                statementlist2.add(pstmt2);
                String sql = "SELECT sendseq,shopprodno,prodseq   FROM shopprodin  where compno = ?    and compayny_goods_cd= ? ";
                sql = sql.toUpperCase();
                pstmt = connection2.prepareStatement(sql);
                for (ProductItemDto list : contents) {
                    String optionString;
                    String[] chgitems = DomesinShopDao.isShopProductInfoExits(YDMASessonUtil.getCompnoInfo().getCompno(), list.getIcode());
                    if (!modi.equals("")) {
                        chgitems[0] = modi;
                    }
                    if (chgitems[0].contains("9") || list.isModifyMode() && !list.isOptionModify() || (optionString = list.getSelect_option()).isEmpty()) continue;
                    YDMAStringUtil.Print();
                    List<DomesinOption> options = DomesinCommon.get().getOptionList((String)optionString).options;
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.getIcode());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int sendseq = rs.getInt(1);
                        String shopprodno = rs.getString(2);
                        int prodseq = rs.getInt(3);
                        int i = 0;
                        for (DomesinOption option2 : options) {
                            int rowIdx2 = 0;
                            pstmt2.setInt(++rowIdx2, sendseq);
                            pstmt2.setInt(++rowIdx2, ++i);
                            pstmt2.setString(++rowIdx2, YDMASessonUtil.getCompnoInfo().getCompno());
                            pstmt2.setString(++rowIdx2, shopprodno);
                            pstmt2.setString(++rowIdx2, option2.getOptionName1());
                            pstmt2.setInt(++rowIdx2, prodseq);
                            String optrprodcd = list.getIcode().concat("-").concat(YDMAStringUtil.leftPad(String.valueOf(i), 2, "0"));
                            pstmt2.setString(++rowIdx2, optrprodcd);
                            pstmt2.setString(++rowIdx2, option2.getOptionName1());
                            pstmt2.setString(++rowIdx2, !option2.getOptionName1().equals("") ? option2.getOptionName1().concat(option2.getOptionName2().equals("") ? "" : ":" + option2.getOptionName2()) : "");
                            int cnt = option2.getSoldOut() == 0 ? 999 : 0;
                            pstmt2.setInt(++rowIdx2, cnt);
                            pstmt2.setInt(++rowIdx2, cnt);
                            int price2 = option2.getOptionPrice() - YDMAStringUtil.convertToInt(list.getPrice());
                            pstmt2.setInt(++rowIdx2, price2);
                            pstmt2.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                            pstmt2.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                            pstmt2.setString(++rowIdx2, option2.getOptionName1());
                            pstmt2.setString(++rowIdx2, optrprodcd);
                            pstmt2.setString(++rowIdx2, option2.getOptionName1());
                            pstmt2.setString(++rowIdx2, !option2.getOptionName1().equals("") ? option2.getOptionName1().concat(option2.getOptionName2().equals("") ? "" : ":" + option2.getOptionName2()) : "");
                            pstmt2.setInt(++rowIdx2, cnt);
                            pstmt2.setInt(++rowIdx2, cnt);
                            pstmt2.setInt(++rowIdx2, price2);
                            pstmt2.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                            pstmt2.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                            YDMAStringUtil.Print(pstmt2.toString());
                            ++row;
                            pstmt2.addBatch();
                            pstmt2.clearParameters();
                        }
                    }
                }
                if (row > 0) {
                    pstmt2.executeBatch();
                    connection2.setAutoCommit(true);
                    pstmt2.clearBatch();
                }
            }
            catch (Exception ex) {
                connection2.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection2, statementlist2, rs);
        }
    }

    public static int excelProductInUpdate(String selfmod, List<ProductItemDto> list, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                StringBuilder sql = new StringBuilder();
                sql.append(" update shopprodin set \r\n");
                sql.append("SHOPSENDSTATUS = ? ,\r\n ");
                sql.append("SELFMOD_NO = ? \r\n ");
                sql.append("where compno = ? and COMPAYNY_GOODS_CD = ?");
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductItemDto dto : list) {
                    int j = 0;
                    pstmt.setInt(++j, 6000);
                    pstmt.setString(++j, selfmod);
                    pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++j, dto.getIcode());
                    YDMAStringUtil.Print("[excelProductInfoUpdate]" + pstmt.toString());
                    ++result;
                    ++row;
                    try {
                        monitor.subTask("[\uc1fc\ud551\ubab0 \uc0c1\ud488\uc815\ubcf4 \ucc98\ub9ac\uc911..] " + dto.getIcode() + " " + result + " of " + workload + "...");
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            monitor.done();
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    if (result <= 1 || result % 1000 != 0) continue;
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                    connection.setAutoCommit(false);
                    row = 0;
                }
                if (row > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public static int excelProductInfoUpdate(String selfmod, List<ProductItemDto> list, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                StringBuilder sql = new StringBuilder();
                sql.append(" update shopprodinfo set \r\n");
                sql.append("SHOPSENDSTATUS = ? ,\r\n ");
                sql.append("SELFMOD_NO = ? \r\n ");
                sql.append("where compno = ? and COMPAYNY_GOODS_CD = ?");
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductItemDto dto : list) {
                    int j = 0;
                    pstmt.setInt(++j, 6100);
                    pstmt.setString(++j, selfmod);
                    pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++j, dto.getIcode());
                    ++result;
                    ++row;
                    try {
                        monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \ucc98\ub9ac\uc911..] " + dto.getIcode() + " " + result + " of " + workload + "...");
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            monitor.done();
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    YDMAStringUtil.Print("[excelProductInfoUpdate]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    if (result <= 1 || result % 1000 != 0) continue;
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                    connection.setAutoCommit(false);
                    row = 0;
                }
                if (row > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public boolean saveInfoReverse(List<ProductItemDto> contents, IProgressMonitor monitor) throws Exception {
        boolean ret = false;
        try {
            try {
                saveProdThreadReverse op = new saveProdThreadReverse(contents);
                op.run(monitor);
                ret = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {}
        return ret;
    }

    public List<ProductItemDto> isExitsShopprodInfo(List<ProductItemDto> params) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt_orddtl = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql_orddtl = " SELECT COUNT(PRODSEQ) AS CNT from shopprodinfo WHERE compno = ? AND COMPAYNY_GOODS_CD = ? ";
                sql_orddtl = sql_orddtl.toUpperCase();
                for (ProductItemDto dto : params) {
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_orddtl.setString(2, dto.getIcode());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        dto.setCount(rs.getInt("CNT"));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
        }
        return params;
    }

    public static void saveShopAddProdInfo(List<ProductItemDto> contents, IProgressMonitor monitor, int workload) throws Exception {
        int result = 0;
        int row = 0;
        Connection connection2 = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist2 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection2 = DBCPInit.getInstance().getConnection();
                connection2.setAutoCommit(false);
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("PRODSEQ");
                lstInsert.add("SKUSEQ");
                lstInsert.add("COMPNO");
                lstInsert.add("COMPAYNY_GOODS_CD");
                lstInsert.add("USER_CODE");
                lstInsert.add("PROD_TYPE1");
                lstInsert.add("PROD_VAL1");
                lstInsert.add("PROD_TYPE2");
                lstInsert.add("PROD_VAL2");
                lstInsert.add("PROD_AMT");
                lstInsert.add("PROD_CNT");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                String sql2 = DomesinShopDao.getInsertOrUpdateQueryMapper(lstInsert, null, "shopaddprodinfo");
                sql2 = sql2.toUpperCase();
                pstmt2 = connection2.prepareStatement(sql2);
                statementlist2.add(pstmt2);
                String sql = "SELECT prodseq  FROM shopprodinfo where compno = ? and compayny_goods_cd=? ";
                sql = sql.toUpperCase();
                pstmt = connection2.prepareStatement(sql);
                for (ProductItemDto list : contents) {
                    int prodseq = 0;
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.getIcode());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        prodseq = rs.getInt(1);
                    }
                    if (list.getText_option().isEmpty()) {
                        DomesinShopDao.deleteProdAddInfo(prodseq);
                        continue;
                    }
                    String[] text_option = list.getText_option().split("\n");
                    int k = 0;
                    while (k < text_option.length - 2) {
                        int cnt;
                        int rowIdx2 = 0;
                        pstmt2.setInt(++rowIdx2, prodseq);
                        pstmt2.setInt(++rowIdx2, k + 1);
                        pstmt2.setInt(++rowIdx2, Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                        pstmt2.setString(++rowIdx2, list.getIcode());
                        pstmt2.setString(++rowIdx2, text_option[0]);
                        pstmt2.setString(++rowIdx2, "\ucd94\uac00\uc0c1\ud488\uba85");
                        pstmt2.setString(++rowIdx2, text_option[0]);
                        String prod_type2 = "";
                        String prod_val2 = "";
                        String[] prod_type = text_option[1].split("=");
                        String[] detail = text_option[2 + k].split("=");
                        int amount = Integer.parseInt(detail[3]);
                        int n = Integer.parseInt(detail[4]) == 0 ? 999 : (cnt = Integer.parseInt(detail[4]) == 9999 ? 0 : Integer.parseInt(detail[4]));
                        if (text_option[1].contains("=")) {
                            prod_type2 = String.valueOf(prod_type[0].substring(prod_type[0].indexOf(91) + 1)) + "_" + prod_type[1].substring(0, prod_type[1].indexOf(93));
                            prod_val2 = String.valueOf(detail[0]) + "_" + detail[1];
                        } else {
                            prod_type2 = prod_type[0].substring(prod_type[0].indexOf(91) + 1, prod_type[0].indexOf(93));
                            prod_val2 = detail[0];
                        }
                        pstmt2.setString(++rowIdx2, prod_type2);
                        pstmt2.setString(++rowIdx2, prod_val2);
                        pstmt2.setInt(++rowIdx2, amount);
                        pstmt2.setInt(++rowIdx2, cnt);
                        pstmt2.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt2.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt2.addBatch();
                        pstmt2.clearParameters();
                        ++row;
                        ++k;
                    }
                    if (++result > 1 && result % 1000 == 0) {
                        pstmt2.executeBatch();
                        connection2.setAutoCommit(true);
                        pstmt2.clearBatch();
                        connection2.setAutoCommit(false);
                        row = 0;
                    }
                    if (workload <= 0) continue;
                    try {
                        monitor.subTask("[\ucd94\uac00 \uc635\uc158 \ucc98\ub9ac\uc911..]  " + result + " of " + workload + "...");
                        monitor.worked(1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (row > 0) {
                    pstmt2.executeBatch();
                    connection2.setAutoCommit(true);
                    pstmt2.clearBatch();
                }
            }
            catch (Exception ex) {
                connection2.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection2, statementlist2, rs);
        }
    }

    public static void deleteProdAddInfo(int prodseq) throws Exception {
        block5: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "delete from shopaddprodinfo where prodseq = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setInt(1, prodseq);
                    pstmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public String setDome_icode(String dome_code, String icode) {
        String value = "";
        switch (dome_code) {
            case "11": {
                value = "OM" + icode;
                break;
            }
            case "17": {
                value = "RM" + icode;
                break;
            }
            case "18": {
                value = "DMT" + icode;
                break;
            }
            case "34": {
                value = "CBW" + icode;
                break;
            }
            default: {
                value = icode;
            }
        }
        return value;
    }

    private static class ShopCateInfo {
        private String cid;
        public String cate_dept;
        private String es_auction;
        private String es_gmarket;
        private String es_11st;
        private String es_interpark;
        private String es_storefarm;
        private String esm_auction;
        private String esm_gmarket;
        private String es_cafe24;
        private String es_coupang;
        private String i_code;

        public ShopCateInfo(String cid, String es_auction, String es_gmarket, String es_11st, String es_interpark, String es_storefarm, String esm_auction, String esm_gmarket, String es_cafe24, String es_coupang, String cate_dept, String i_code) {
            this.cid = String.valueOf(cid);
            this.es_auction = String.valueOf(es_auction);
            this.es_gmarket = String.valueOf(es_gmarket);
            this.es_11st = String.valueOf(es_11st);
            this.es_interpark = String.valueOf(es_interpark);
            this.es_storefarm = String.valueOf(es_storefarm);
            this.esm_auction = String.valueOf(esm_auction);
            this.esm_gmarket = String.valueOf(esm_gmarket);
            this.es_cafe24 = String.valueOf(es_cafe24);
            this.es_coupang = String.valueOf(es_coupang);
            this.cate_dept = String.valueOf(cate_dept);
            this.i_code = String.valueOf(i_code);
        }
    }

    private static class ShopCateItem {
        private String shopcd;
        private String esm_gmarket;
        private String esm_auction;
        private String cid;

        private ShopCateItem() {
        }

        public String getShopcd() {
            return this.shopcd;
        }

        public void setShopcd(String shopcd) {
            this.shopcd = shopcd;
        }

        public String getEsm_gmarket() {
            return this.esm_gmarket;
        }

        public void setEsm_gmarket(String esm_gmarket) {
            this.esm_gmarket = esm_gmarket;
        }

        public String getEsm_auction() {
            return this.esm_auction;
        }

        public void setEsm_auction(String esm_auction) {
            this.esm_auction = esm_auction;
        }

        public String getCid() {
            return this.cid;
        }

        public void setCid(String cid) {
            this.cid = cid;
        }
    }

    private static class ShopGosiInfo {
        private String gosi1;
        private String gosi2;
        private String gosi3;
        private String gosi4;
        private String gosi5;
        private String gosi6;
        private String gosi7;
        private String gosi8;
        private String gosi9;
        private String gosi10;
        private String gosi11;
        private String gosi12;
        private String gosi13;
        private String gosi14;
        private String gosi15;
        private String gosi16;
        private String gosi17;
        private String gosi18;
        private String gosi19;
        private String gosi20;
        private String gosi21;
        private String gosi22;

        private ShopGosiInfo() {
        }

        public String getGosi1() {
            return this.gosi1;
        }

        public void setGosi1(String gosi1) {
            this.gosi1 = gosi1;
        }

        public String getGosi2() {
            return this.gosi2;
        }

        public void setGosi2(String gosi2) {
            this.gosi2 = gosi2;
        }

        public String getGosi3() {
            return this.gosi3;
        }

        public void setGosi3(String gosi3) {
            this.gosi3 = gosi3;
        }

        public String getGosi4() {
            return this.gosi4;
        }

        public void setGosi4(String gosi4) {
            this.gosi4 = gosi4;
        }

        public String getGosi5() {
            return this.gosi5;
        }

        public void setGosi5(String gosi5) {
            this.gosi5 = gosi5;
        }

        public String getGosi6() {
            return this.gosi6;
        }

        public void setGosi6(String gosi6) {
            this.gosi6 = gosi6;
        }

        public String getGosi7() {
            return this.gosi7;
        }

        public void setGosi7(String gosi7) {
            this.gosi7 = gosi7;
        }

        public String getGosi8() {
            return this.gosi8;
        }

        public void setGosi8(String gosi8) {
            this.gosi8 = gosi8;
        }

        public String getGosi9() {
            return this.gosi9;
        }

        public void setGosi9(String gosi9) {
            this.gosi9 = gosi9;
        }

        public String getGosi10() {
            return this.gosi10;
        }

        public void setGosi10(String gosi10) {
            this.gosi10 = gosi10;
        }

        public String getGosi11() {
            return this.gosi11;
        }

        public void setGosi11(String gosi11) {
            this.gosi11 = gosi11;
        }

        public String getGosi12() {
            return this.gosi12;
        }

        public void setGosi12(String gosi12) {
            this.gosi12 = gosi12;
        }

        public String getGosi13() {
            return this.gosi13;
        }

        public void setGosi13(String gosi13) {
            this.gosi13 = gosi13;
        }

        public String getGosi14() {
            return this.gosi14;
        }

        public void setGosi14(String gosi14) {
            this.gosi14 = gosi14;
        }

        public String getGosi15() {
            return this.gosi15;
        }

        public void setGosi15(String gosi15) {
            this.gosi15 = gosi15;
        }

        public String getGosi16() {
            return this.gosi16;
        }

        public void setGosi16(String gosi16) {
            this.gosi16 = gosi16;
        }

        public String getGosi17() {
            return this.gosi17;
        }

        public void setGosi17(String gosi17) {
            this.gosi17 = gosi17;
        }

        public String getGosi18() {
            return this.gosi18;
        }

        public void setGosi18(String gosi18) {
            this.gosi18 = gosi18;
        }

        public String getGosi19() {
            return this.gosi19;
        }

        public void setGosi19(String gosi19) {
            this.gosi19 = gosi19;
        }

        public String getGosi20() {
            return this.gosi20;
        }

        public void setGosi20(String gosi20) {
            this.gosi20 = gosi20;
        }

        public String getGosi21() {
            return this.gosi21;
        }

        public void setGosi21(String gosi21) {
            this.gosi21 = gosi21;
        }

        public String getGosi22() {
            return this.gosi22;
        }

        public void setGosi22(String gosi22) {
            this.gosi22 = gosi22;
        }
    }

    private static class excelupdateProdThread
    implements IRunnableWithProgress {
        private int workload;
        List<ProductItemDto> contents;

        public excelupdateProdThread(List<ProductItemDto> contents) {
            this.workload = contents.size();
            this.contents = contents;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("\ub370\uc774\ud130 \uc800\uc7a5\uc911..", this.workload * 6);
            try {
                monitor.subTask("init");
                DomesinShopDao.excelProductInfoUpdate("", this.contents, monitor, this.workload);
                DomesinShopDao.excelProductInUpdate("", this.contents, monitor, this.workload);
                String query = this.contents.stream().map(p -> String.format("SELECT '%s' AS ICODE,'%s' AS MODIFYID  \r\n", p.getIcode(), YDMATimeUtil.getCurrentTimeByYDFormat())).collect(Collectors.joining(" UNION ALL ", "WITH CTE_PRODLIST AS( ", ")"));
                DomesinProductGetDao.get().getModifyProduct(this.contents, query, -1);
                monitor.subTask("finish");
                DomesinShopDao.excelProductInfoUpdate("1:2:3:4:5:6", this.contents, monitor, this.workload);
                DomesinShopDao.excelProductInUpdate("1:2:3:4:5:6", this.contents, monitor, this.workload);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InterruptedException(e.getMessage());
            }
            monitor.done();
        }
    }

    private static class saveProdThread
    implements IRunnableWithProgress {
        private int workload;
        List<ProductItemDto> contents;

        public saveProdThread(List<ProductItemDto> contents) {
            this.workload = contents.size();
            this.contents = contents;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("\ub370\uc774\ud130 \uc800\uc7a5\uc911..", this.workload * 4);
            try {
                monitor.subTask("saveCategoryShop");
                DomesinShopDao.updateCategoryShopApiSetting(this.contents, monitor, this.workload);
                monitor.subTask("saveShopProdInfo");
                DomesinShopDao.saveShopProdInfo("", this.contents, monitor, this.workload);
                if (monitor.isCanceled()) {
                    monitor.done();
                    return;
                }
                monitor.subTask("saveShopOptProdInfo");
                DomesinShopDao.saveShopOptProdInfo("", this.contents, monitor, this.workload);
                monitor.subTask("saveShopAddProdInfo");
                DomesinShopDao.saveShopAddProdInfo(this.contents, monitor, this.workload);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InterruptedException(e.getMessage());
            }
            monitor.done();
        }
    }

    private static class saveProdThreadReverse
    implements IRunnableWithProgress {
        private int workload;
        List<ProductItemDto> contents;

        public saveProdThreadReverse(List<ProductItemDto> contents) {
            this.workload = contents.size();
            this.contents = contents;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("\ub370\uc774\ud130 \uc800\uc7a5\uc911..", this.workload * 4);
            try {
                monitor.subTask("saveShopProdInfo");
                DomesinShopDao.saveShopProdInfo("", this.contents, monitor, this.workload);
                if (monitor.isCanceled()) {
                    monitor.done();
                    return;
                }
                monitor.subTask("saveShopOptProdInfo");
                DomesinShopDao.saveShopOptProdInfo("", this.contents, monitor, this.workload);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InterruptedException(e.getMessage());
            }
            monitor.done();
        }
    }
}

