/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.coupang;

import com.coupang.openapi.sdk.Hmac;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.ShopProdInDto;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.common.IProduct;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.yellim.shop.coupang.CoupangExitsProductCd;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCoupangAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class CoupangProductRegService
implements IProduct {
    List<ShopProdAttrnmDto> retAttrData = new ArrayList<ShopProdAttrnmDto>();
    List<requiredDoc> requiredDoc = new ArrayList<requiredDoc>();
    List<ShopOptionDto> shopOptionDtos = null;

    public String jsonElementNullStr(JsonElement val) {
        if (val.isJsonNull()) {
            return "";
        }
        return val.getAsString();
    }

    private List<ReturnShippingCenter> getReturnShippingCenters(ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        ArrayList<ReturnShippingCenter> returnShippingCenters = new ArrayList<ReturnShippingCenter>();
        try {
            String URL2 = "/v2/providers/openapi/apis/api/v4/vendors/%s/returnShippingCenters";
            String acessKey = shoppingMallDetailDto.getAuthkey1();
            String secretKey = shoppingMallDetailDto.getAuthkey2();
            String vendorid = shoppingMallDetailDto.getVendorId();
            URL2 = String.format(URL2, vendorid);
            URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
            String authorization = Hmac.generate((String)"GET", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
            uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
            client = HttpClients.createDefault();
            HttpGet get = new HttpGet(uriBuilder.build().toString());
            get.addHeader("Authorization", authorization);
            get.addHeader("content-type", "application/json");
            response = client.execute((HttpUriRequest)get);
            int status2 = response.getStatusLine().getStatusCode();
            response.getStatusLine().getReasonPhrase();
            if (status2 == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                YDMAStringUtil.Print(resObject);
                this.jsonElementNullStr(resObject.get("code"));
                JsonObject datas = (JsonObject)resObject.get("data");
                JsonArray contents = (JsonArray)datas.get("content");
                int i = 0;
                while (i < contents.size()) {
                    JsonObject data2 = (JsonObject)contents.get(i);
                    ReturnShippingCenter returnShippingCenter = new ReturnShippingCenter();
                    returnShippingCenter.setVendorId(this.jsonElementNullStr(data2.get("vendorId")));
                    returnShippingCenter.setReturnCenterCode(this.jsonElementNullStr(data2.get("returnCenterCode")));
                    returnShippingCenter.setShippingPlaceName(this.jsonElementNullStr(data2.get("shippingPlaceName")));
                    returnShippingCenter.setDeliverCode(this.jsonElementNullStr(data2.get("deliverCode")));
                    returnShippingCenter.setGoodsflowStatus(this.jsonElementNullStr(data2.get("goodsflowStatus")));
                    returnShippingCenter.setVendorId(this.jsonElementNullStr(data2.get("vendorId")));
                    returnShippingCenters.add(returnShippingCenter);
                    ++i;
                }
                ArrayList<ReturnShippingCenter> arrayList = returnShippingCenters;
                return arrayList;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return returnShippingCenters;
    }

    private Result getCateRecommend(String json, ShoppingmallDTO shopInfo) throws Exception {
        block31: {
            CloseableHttpResponse response = null;
            CloseableHttpClient client = null;
            try {
                YDMAStringUtil.Print(json);
                String URL2 = "/v2/providers/openapi/apis/api/v1/categorization/predict";
                String acessKey = shopInfo.getAUTHKEY1();
                String secretKey = shopInfo.getAUTHKEY2();
                String vendorid = shopInfo.getVENDORID();
                URL2 = String.format(URL2, vendorid);
                URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
                String authorization = Hmac.generate((String)"POST", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
                uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
                StringEntity params = new StringEntity(json, "UTF-8");
                client = HttpClients.createDefault();
                HttpPost requestPatch = new HttpPost(uriBuilder.build().toString());
                requestPatch.addHeader("Authorization", authorization);
                requestPatch.addHeader("content-type", "application/json");
                requestPatch.setEntity((HttpEntity)params);
                response = client.execute((HttpUriRequest)requestPatch);
                int status2 = response.getStatusLine().getStatusCode();
                response.getStatusLine().getReasonPhrase();
                if (status2 != 200) break block31;
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                String result = this.jsonElementNullStr(resObject.get("code"));
                String result_message = this.jsonElementNullStr(resObject.get("message"));
                if (result.equals("200")) {
                    JsonObject o = (JsonObject)resObject.get("data");
                    String isSucess = this.jsonElementNullStr(o.get("autoCategorizationPredictionResultType"));
                    if (isSucess.equals("SUCCESS")) {
                        String predictedCategoryId = this.jsonElementNullStr(o.get("predictedCategoryId"));
                        Result result2 = new Result(1, result_message, predictedCategoryId);
                        return result2;
                    }
                    Result result3 = new Result(-1, result_message, "");
                    return result3;
                }
                try {
                    String strShop = String.format("(%s) %s", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID());
                    CommonProgressDialog.get().setValue(String.valueOf(strShop) + result_message, 100);
                    throw new Exception(result_message);
                }
                catch (Exception e) {
                    Result result4 = new Result(-1, e.getMessage());
                    return result4;
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (client != null) {
                    client.close();
                }
            }
        }
        return new Result(-1, "\uce74\ud14c\uace0\ub9ac\ucd94\ucc9c \uc5d0\ub7ec \ubc1c\uc0dd");
    }

    private List<ShopProdAttrnmDto> getCategoryMeta(ShoppingmallDTO shopInfo, String displayCode, List<ShopProdAttrnmDto> shopProdAttrnmSrcDtos) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        ArrayList<ShopProdAttrnmDto> retList = new ArrayList<ShopProdAttrnmDto>();
        try {
            String URL2 = "/v2/providers/seller_api/apis/api/v1/marketplace/meta/category-related-metas/display-category-codes/%s";
            String acessKey = shopInfo.getAUTHKEY1();
            String secretKey = shopInfo.getAUTHKEY2();
            shopInfo.getVENDORID();
            URL2 = String.format(URL2, displayCode);
            URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
            String authorization = Hmac.generate((String)"GET", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
            uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
            client = HttpClients.createDefault();
            HttpGet get = new HttpGet(uriBuilder.build().toString());
            get.addHeader("Authorization", authorization);
            get.addHeader("content-type", "application/json");
            response = client.execute((HttpUriRequest)get);
            int status2 = response.getStatusLine().getStatusCode();
            response.getStatusLine().getReasonPhrase();
            if (status2 == 200) {
                Object dto;
                String name;
                JsonObject attribute;
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                YDMAStringUtil.Print(resObject);
                JsonObject resData = (JsonObject)resObject.get("data");
                JsonArray resImage = (JsonArray)resData.get("requiredDocumentNames");
                JsonArray resGosi = (JsonArray)resData.get("noticeCategories");
                JsonArray attributes = (JsonArray)resData.get("attributes");
                JsonObject content = null;
                int i = 0;
                while (i < resGosi.size()) {
                    JsonObject content1 = (JsonObject)resGosi.get(i);
                    content = content1.get("noticeCategoryName").getAsString().equals("\uae30\ud0c0 \uc7ac\ud654") ? (JsonObject)resGosi.get(i) : (JsonObject)resGosi.get(0);
                    ++i;
                }
                String noticeCategoryName = this.jsonElementNullStr(content.get("noticeCategoryName"));
                JsonArray noticeCategoryDetails = (JsonArray)content.get("noticeCategoryDetailNames");
                for (JsonElement e : resImage) {
                    attribute = (JsonObject)e;
                    name = this.jsonElementNullStr(attribute.get("templateName"));
                    String required = this.jsonElementNullStr(attribute.get("required"));
                    dto = new requiredDoc();
                    ((requiredDoc)dto).setTempnm(name);
                    ((requiredDoc)dto).setRequired(required);
                    this.requiredDoc.add((requiredDoc)dto);
                }
                for (JsonElement e : attributes) {
                    attribute = (JsonObject)e;
                    name = this.jsonElementNullStr(attribute.get("attributeTypeName"));
                    boolean required = this.jsonElementNullStr(attribute.get("required")).equals("MANDATORY");
                    dto = new ShopProdAttrnmDto();
                    ((ShopProdAttrnmDto)dto).setAttrnm(name);
                    if (required) {
                        ((ShopProdAttrnmDto)dto).setAttrcd("option");
                        retList.add((ShopProdAttrnmDto)dto);
                    }
                    this.retAttrData.add((ShopProdAttrnmDto)dto);
                }
                for (JsonElement e : noticeCategoryDetails) {
                    JsonObject notice = (JsonObject)e;
                    ShopProdAttrnmDto dto2 = new ShopProdAttrnmDto();
                    dto2.setAttrnm(noticeCategoryName);
                    String attrnm = this.jsonElementNullStr(notice.get("noticeCategoryDetailName"));
                    String val = shopProdAttrnmSrcDtos.stream().filter(p -> p.getAttrnm().equals(attrnm)).map(p -> p.getProp_val()).findAny().orElse("");
                    if (!val.isEmpty()) {
                        dto2.setAttrcd("notice");
                        dto2.setIntercode(attrnm);
                        dto2.setAttrvl(val);
                    } else {
                        dto2.setAttrcd("notice");
                        dto2.setIntercode(attrnm);
                        dto2.setAttrvl("\uc0c1\uc138\ud398\uc774\uc9c0\ucc38\uc870");
                    }
                    retList.add(dto2);
                }
                ArrayList<ShopProdAttrnmDto> arrayList = retList;
                return arrayList;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return retList;
    }

    private void isExitsProduct(ShoppingMallDetailDto shoppingMallDetailDto, String sellerProdCd) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            shoppingMallDetailDto.getShopProdNo();
            String URL2 = "/v2/providers/seller_api/apis/api/v1/marketplace/seller-products/external-vendor-sku-codes/%s";
            String acessKey = shoppingMallDetailDto.getAuthkey1();
            String secretKey = shoppingMallDetailDto.getAuthkey2();
            shoppingMallDetailDto.getVendorId();
            URL2 = String.format(URL2, "DMM26261134");
            URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
            String authorization = Hmac.generate((String)"GET", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
            uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
            client = HttpClients.createDefault();
            HttpGet get = new HttpGet(uriBuilder.build().toString());
            get.addHeader("Authorization", authorization);
            get.addHeader("content-type", "application/json");
            response = client.execute((HttpUriRequest)get);
            int status2 = response.getStatusLine().getStatusCode();
            response.getStatusLine().getReasonPhrase();
            if (status2 == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                YDMAStringUtil.Print(resObject);
                JsonArray cfr_ignored_0 = (JsonArray)resObject.get("data");
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getApiJsonString(ProductDTO dto, ShopCoupangAdditionalDto dtllist, ShoppingmallDTO shopInfo) throws Exception {
        CupongProductReg cupongProductReg = new CupongProductReg();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.setProductName(dto, dtllist, cupongProductReg);
        try {
            if (dtllist.getIsCategory().equals("1")) {
                cupongProductReg.displayCategoryCode = Long.parseLong(dtllist.getShopcatno());
            } else {
                long categ = YDMAStringUtil.convertToLong(dto.getShopCid());
                YDMAStringUtil.Print("\uce74\ud14c\uace0\ub9ac \ud655\uc778 1 : " + categ);
                Thread.sleep(1000L);
                cupongProductReg.displayCategoryCode = categ;
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uce74\ud14c\uace0\ub9ac \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        this.setSalePeriod(dto, dtllist, shopInfo, cupongProductReg);
        try {
            String brand = "";
            brand = dtllist.getBrandyn().equals("N") ? dtllist.getBrandnm() : (String.valueOf(dto.getBrand_nm()).isEmpty() ? dto.getMaker() : dto.getBrand_nm());
            cupongProductReg.brand = brand;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ube0c\ub79c\ub4dc \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        this.setExpress(dtllist, cupongProductReg, dto);
        cupongProductReg.vendorUserId = shopInfo.getSHOPPINGID();
        cupongProductReg.requested = true;
        List<CupongProductItem> items = this.getItems(dto, dtllist, shopInfo);
        for (CupongProductItem item : items) {
            cupongProductReg.items.add(item);
        }
        try {
            for (requiredDoc d : this.requiredDoc) {
                if (!d.getRequired().toUpperCase().equals("MANDATORY")) continue;
                cupongProductReg.requiredDocuments.add(new RequiredDocument(d.getTempnm(), "\uc0c1\uc138\ud398\uc774\uc9c0 \ucc38\uc870"));
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uae30\ud0c0\uc778\uc99d\uc11c\ub958 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        cupongProductReg.extraInfoMessage = "";
        cupongProductReg.manufacture = dto.getMaker();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        String json = mapper.writeValueAsString((Object)cupongProductReg);
        return json;
    }

    private void setExpress(ShopCoupangAdditionalDto dtllist, CupongProductReg cupongProductReg, ProductDTO dto) throws Exception {
        try {
            PreferencesMallDTO systemconf;
            cupongProductReg.deliveryMethod = dtllist.getDeliverymethod();
            if (dtllist.getTypeaddi().equals("Y")) {
                if (dto.getDelv_type().equals("2")) {
                    cupongProductReg.deliveryChargeType = "CHARGE_RECEIVED";
                } else {
                    cupongProductReg.deliveryChargeType = dtllist.getDeliverychargetype();
                }
            } else {
                cupongProductReg.deliveryChargeType = dtllist.getDeliverychargetype();
            }
            cupongProductReg.deliveryCompanyCode = dtllist.getDeliverycompanycd();
            String deliveryFee = "";
            String returnDeliveryFee = "";
            if (dtllist.getDeliverycharge().equals("9999")) {
                if (!dto.getDelv_cost().equals("0")) {
                    deliveryFee = dto.getDelv_cost();
                } else {
                    systemconf = ShopCommonDao.get().getSystemConf();
                    deliveryFee = String.valueOf(systemconf.getDELIVERYCOST());
                    dto.setDelv_cost(deliveryFee);
                }
            } else {
                deliveryFee = dtllist.getDeliverycharge();
                dto.setDelv_cost(deliveryFee);
            }
            if (dtllist.getReturncharge().equals("9999")) {
                if (!dto.getDelv_r_cost().equals("0")) {
                    returnDeliveryFee = dto.getDelv_r_cost();
                } else {
                    systemconf = ShopCommonDao.get().getSystemConf();
                    returnDeliveryFee = String.valueOf(systemconf.getDELIVERYCOST());
                    dto.setDelv_r_cost(returnDeliveryFee);
                }
            } else {
                returnDeliveryFee = dtllist.getReturncharge();
                dto.setDelv_r_cost(returnDeliveryFee);
            }
            cupongProductReg.deliveryCharge = YDMAStringUtil.convertToLong(deliveryFee);
            cupongProductReg.freeShipOverAmount = YDMAStringUtil.convertToLong(dtllist.getFreeshipovercharge().replaceAll("[^0-9]", ""));
            cupongProductReg.deliveryChargeOnReturn = YDMAStringUtil.convertToLong(returnDeliveryFee);
            cupongProductReg.remoteAreaDeliverable = dtllist.getRemoteareadeliverable();
            cupongProductReg.unionDeliveryType = dtllist.getUniondeliverytype().equals("Y") ? "UNION_DELIVERY" : "NOT_UNION_DELIVERY";
            cupongProductReg.returnCenterCode = dtllist.getRetaddrcd();
            cupongProductReg.returnChargeName = dtllist.getRetaddrname();
            cupongProductReg.companyContactNumber = dtllist.getRetaddrcel();
            cupongProductReg.returnZipCode = dtllist.getRetaddrzipcd();
            cupongProductReg.returnAddress = dtllist.getRetaddr();
            cupongProductReg.returnAddressDetail = dtllist.getRetaddrdtl();
            cupongProductReg.returnCharge = YDMAStringUtil.convertToLong(returnDeliveryFee);
            cupongProductReg.outboundShippingPlaceCode = YDMAStringUtil.convertToLong(dtllist.getOutaddrplace());
            String delvtype = dtllist.getDeliverychargetype().equals("CONDITIONAL_FREE") ? "\uc870\uac74\ubd80 \ubb34\ub8cc\ubc30\uc1a1" : (dtllist.getDeliverychargetype().equals("CHARGE_RECEIVED") ? "\ucc29\ubd88\ubc30\uc1a1" : (dtllist.getDeliverychargetype().equals("NOT_FREE") ? "\uc720\ub8cc\ubc30\uc1a1" : "\ubb34\ub8cc\ubc30\uc1a1"));
            long delvcost = delvtype.equals("\ubb34\ub8cc\ubc30\uc1a1") ? 0L : YDMAStringUtil.convertToLong(deliveryFee);
            dto.setPack_code_str(delvtype.concat("=").concat(String.valueOf(delvcost)));
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ubc30\uc1a1\uc815\ucc45 , \ucd9c\uace0/\ubc18\ud488, AS\uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setSalePeriod(ProductDTO dto, ShopCoupangAdditionalDto dtllist, ShoppingmallDTO shopInfo, CupongProductReg cupongProductReg) throws Exception {
        try {
            cupongProductReg.vendorId = shopInfo.getVENDORID();
            cupongProductReg.saleStartedAt = String.valueOf(YDMATimeUtil.getCurrentDateScheduler()) + "T00:00:00";
            cupongProductReg.saleEndedAt = String.valueOf(dtllist.getSaletodate()) + "T23:59:59";
            dto.setSaleenddt(dtllist.getSaletodate().equals("") ? "2099-12-31" : dtllist.getSaletodate());
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud310\ub9e4\uc77c \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setProductName(ProductDTO dto, ShopCoupangAdditionalDto dtllist, CupongProductReg cupongProductReg) throws Exception {
        try {
            String displayProductName;
            String sellerProductName;
            String value = "";
            switch (dtllist.getProdouttype()) {
                case "0": {
                    value = dto.getGoods_nm();
                    break;
                }
                case "1": {
                    value = dto.getModel_nm();
                    break;
                }
                case "2": {
                    value = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "3": {
                    value = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "4": {
                    value = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "5": {
                    value = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    value = dto.getGoods_nm();
                }
            }
            if (!dtllist.getProdnmfirst().equals("")) {
                value = dtllist.getProdnmfirst().concat(value);
            }
            if (!dtllist.getProdnmend().equals("")) {
                value = value.concat(" ").concat(dtllist.getProdnmend());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "L", 99);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            CoupangProductRegService.numberGen(6, 2);
            if (dto.getProdnmlenyn().equals("Y")) {
                sellerProductName = YDMAStringUtil.setTextStrtok(value, 190);
                displayProductName = YDMAStringUtil.setTextStrtok(value, 190);
            } else {
                sellerProductName = value;
                displayProductName = value;
            }
            cupongProductReg.sellerProductName = sellerProductName;
            cupongProductReg.displayProductName = displayProductName;
            cupongProductReg.generalProductName = displayProductName;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc0c1\ud488\uba85 \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    public static String numberGen(int len, int dupCd) {
        Random rand = new Random();
        String numStr = "";
        int i = 0;
        while (i < len) {
            String ran = Integer.toString(rand.nextInt(10));
            if (dupCd == 1) {
                numStr = String.valueOf(numStr) + ran;
            } else if (dupCd == 2) {
                if (!numStr.contains(ran)) {
                    numStr = String.valueOf(numStr) + ran;
                } else {
                    --i;
                }
            }
            ++i;
        }
        return numStr;
    }

    private List<CupongProductItem> getItems(ProductDTO dto, ShopCoupangAdditionalDto dtllist, ShoppingmallDTO shopInfo) throws Exception {
        Long salePrice1 = YDMAStringUtil.convertToLong(dto.getGoods_cost());
        if (dtllist.getDeliverychargetype().equals("FREE") && dtllist.getFreedelivery().equals("T")) {
            int deliveryFee;
            if (dtllist.getExpprc() == 9999) {
                if (!dto.getDelv_cost().equals("0")) {
                    deliveryFee = Integer.parseInt(dto.getDelv_cost());
                } else {
                    PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                    deliveryFee = systemconf.getDELIVERYCOST();
                }
            } else {
                deliveryFee = dtllist.getExpprc();
            }
            salePrice1 = salePrice1 + (long)deliveryFee;
        }
        int limit_price1 = YDMAStringUtil.convertToInt(dto.getLimit_price());
        ResultMarketPrice resultMarketPrice1 = ShopProductSendDto.getMarketCalcate(dtllist, limit_price1, salePrice1);
        if (salePrice1 > YDMAStringUtil.convertToLong(resultMarketPrice1.getConsumer_if_sale_price())) {
            resultMarketPrice1 = ShopProductSendDto.getMarketCalcate(dtllist, limit_price1, salePrice1);
        }
        if (salePrice1 > YDMAStringUtil.convertToLong(resultMarketPrice1.getConsumer_if_sale_price()) || salePrice1 > YDMAStringUtil.convertToLong(resultMarketPrice1.getTotal_sale_discount())) {
            YDMAStringUtil.Print(salePrice1);
        }
        dto.setGoods_price(resultMarketPrice1.getTotal_sale_discount());
        dto.setMarket_price(resultMarketPrice1.getTotal_sale_discount());
        dto.setGoods_consumer_price(resultMarketPrice1.getTotal_sale_discount());
        this.shopOptionDtos = this.getProductOptions(dto);
        ArrayList<CupongProductItem> items = new ArrayList<CupongProductItem>();
        String prop = dto.getProp1_cd();
        if (dto.getProp1_cd().equals("039")) {
            dto.setProp1_cd("041");
        } else if (dto.getProp1_cd().equals("040")) {
            dto.setProp1_cd("042");
        }
        ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
        List<ShopProdAttrnmDto> shopProdAttrnmSrcDtos = dto.getShopProdAttrnmDtos();
        List<Object> shopProdAttrnmDtos = new ArrayList();
        shopProdAttrnmDtos = dtllist.getIsCategory().equals("1") ? this.getCategoryMeta(shopInfo, dtllist.getShopcatno(), shopProdAttrnmSrcDtos) : this.getCategoryMeta(shopInfo, dto.getShopCid(), shopProdAttrnmSrcDtos);
        if (shopProdAttrnmDtos.size() == 0) {
            CateRecommend cateRecommend = new CateRecommend();
            cateRecommend.productName = dto.getGoods_nm();
            cateRecommend.brand = dto.getBrand_nm();
            cateRecommend.productDescription = dto.getGoods_keyword();
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            String json = mapper.writeValueAsString((Object)cateRecommend);
            Result result = this.getCateRecommend(json, shopInfo);
            if (result.getIsSucess() == 1) {
                shopProdAttrnmDtos = this.getCategoryMeta(shopInfo, result.productCode, shopProdAttrnmSrcDtos);
            }
        }
        if (this.shopOptionDtos.size() == 0) {
            ShopOptionDto shopOptionDto = new ShopOptionDto();
            shopOptionDto.setSkuseq("1");
            shopOptionDto.setName("\ubcf8\uc0c1\ud488 \uc120\ud0dd");
            shopOptionDto.setOptspecdes("\ubcf8\uc0c1\ud488");
            shopOptionDto.setOptcompanycd("\ucf54\ub4dc\uc5c6\uc74c");
            shopOptionDto.setCnt("999");
            shopOptionDto.setAmt("0");
            shopOptionDto.setLimit_price("0");
            this.shopOptionDtos.add(shopOptionDto);
        }
        for (ShopOptionDto optionDto : this.shopOptionDtos) {
            String price_cost = dto.getGoods_cost();
            CupongProductItem item = new CupongProductItem();
            try {
                if (dtllist.getDeliverychargetype().equals("FREE") && dtllist.getFreedelivery().equals("T")) {
                    int deliveryFee;
                    if (dtllist.getExpprc() == 9999) {
                        if (!dto.getDelv_cost().equals("0")) {
                            deliveryFee = Integer.parseInt(dto.getDelv_cost());
                        } else {
                            PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                            deliveryFee = systemconf.getDELIVERYCOST();
                        }
                    } else {
                        deliveryFee = dtllist.getExpprc();
                    }
                    price_cost = String.valueOf(YDMAStringUtil.convertToLong(price_cost) + (long)deliveryFee);
                }
                Long salePrice = YDMAStringUtil.convertToLong(price_cost) + YDMAStringUtil.convertToLong(optionDto.getAmt());
                int limit_price = YDMAStringUtil.convertToInt(optionDto.getLimit_price());
                ResultMarketPrice resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price()) || salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getTotal_sale_discount())) {
                    resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                }
                if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price()) || salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getTotal_sale_discount())) {
                    YDMAStringUtil.Print(salePrice);
                }
                item.originalPrice = YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price());
                item.salePrice = YDMAStringUtil.convertToLong(resultMarketPrice.getTotal_sale_discount());
            }
            catch (Exception exception) {
                throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud310\ub9e4\uac00 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
            String optionName = "";
            List<String> OptionNames = Arrays.asList(optionDto.getOptspecdes().split(":"));
            if (OptionNames.size() > 0) {
                optionName = OptionNames.get(0);
            }
            if (OptionNames.size() > 1) {
                optionName = String.valueOf(optionName) + " - " + OptionNames.get(1);
            }
            if (OptionNames.size() > 2) {
                optionName = String.valueOf(optionName) + " - " + OptionNames.get(2);
            }
            item.itemName = optionName;
            item.maximumBuyCount = YDMAStringUtil.convertToLong(optionDto.getCnt());
            try {
                item.maximumBuyForPerson = YDMAStringUtil.convertToLong(dtllist.getMaximumbuyperson());
                item.outboundShippingTimeDay = YDMAStringUtil.convertToLong(dtllist.getOutboundshoptimeday());
                item.maximumBuyForPersonPeriod = YDMAStringUtil.convertToLong(dtllist.getMaximumbuypersonperiod().equals("0") ? "1" : dtllist.getMaximumbuypersonperiod());
            }
            catch (Exception exception) {
                throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ucd5c\ub300\uad6c\ub9e4\uc81c\ud55c, \ucd9c\uace0\uc5ec\ubd80, \uad6c\ub9e4\uc81c\ud55c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
            item.unitCount = 0L;
            if (dtllist.getTypeaddi().equals("Y")) {
                item.adultOnly = dto.getAdult().equals("0") ? "EVERYONE" : "ADULT_ONLY";
            } else {
                item.adultOnly = dtllist.getAdultonly();
            }
            item.offerCondition = dtllist.getUsedyn().equals("N") ? "NEW" : dtllist.getUsedstatus();
            item.offerDescription = dtllist.getUsedyn().equals("N") ? "" : dtllist.getUseddetail();
            if (YDMASessonUtil.getLoginType() == 2) {
                item.taxType = dto.getTax_yn().equals("0") ? "TAX" : "FREE";
            } else {
                item.taxType = dto.getTax_yn().equals("4") ? "FREE" : "TAX";
            }
            item.parallelImported = dtllist.getParallelimport();
            item.overseasPurchased = dtllist.getOverseaspurchased();
            item.pccNeeded = Boolean.getBoolean(dtllist.getPccneeded());
            item.externalVendorSku = dto.getCompayny_goods_cd();
            item.barcode = "";
            item.emptyBarcode = dtllist.getBarcodeyn().equals("N");
            if (dtllist.getBarcodeyn().equals("N")) {
                item.emptyBarcodeReason = dtllist.getBarcode().equals("") ? dtllist.getBarcodereason() : dtllist.getBarcode();
            }
            item.modelNo = dto.getModel_no() == null ? "" : dto.getModel_no();
            item.certifications.add(new Certification("NOT_REQUIRED", ""));
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> removetag = new ArrayList<String>();
            List<String> search = new ArrayList<String>();
            if (dto.getExcepkeywdyn().equals("Y")) {
                removetag.addAll(Arrays.asList(dto.getExcepkeywd().split(",")));
                list.addAll(Arrays.asList(dto.getGoods_search().split(",")));
                search = IProduct.checkSearch(list, removetag, search);
            } else {
                search.addAll(Arrays.asList(dto.getGoods_search().split(",")));
            }
            for (String site : search) {
                String match = "[^\uac00-\ud7a3xfe0-9a-zA-Z\\s]";
                String target = ".*[\u2e80-\u2eff\u31c0-\u31ef\u3200-\u32ff\u3400-\u4dbf\u4e00-\u9fbf\uf900-\ufaff].*";
                if (site.matches(match) && site.matches(target)) continue;
                item.searchTags.add(site);
            }
            this.setImg(dto, item, dtllist, shopInfo);
            this.setNotice(dtllist, shopProdAttrnmDtos, item);
            try {
                if (this.shopOptionDtos.size() == 0) {
                    if (!dto.getChar_2_nm().isEmpty()) {
                        int i = 0;
                        while (i < 2) {
                            switch (i) {
                                case 0: {
                                    item.attributes.add(new Attributes(dto.getChar_1_nm(), "\ubc30\uc1a1\uba54\ubaa8\uc5d0 \uae30\uc785\ud558\uc138\uc694."));
                                    break;
                                }
                                case 1: {
                                    item.attributes.add(new Attributes(dto.getChar_2_nm(), "\ubc30\uc1a1\uba54\ubaa8\uc5d0 \uae30\uc785\ud558\uc138\uc694."));
                                }
                            }
                            ++i;
                        }
                    } else {
                        item.attributes.add(new Attributes(dto.getChar_1_nm(), "\ubc30\uc1a1\uba54\ubaa8\uc5d0 \uae30\uc785\ud558\uc138\uc694."));
                    }
                } else {
                    String[] optionTypes = optionDto.getName().split(":");
                    int i = 0;
                    while (i < optionTypes.length) {
                        item.attributes.add(new Attributes(optionTypes[i], OptionNames.get(i)));
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc635\uc158 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
            Contents content = new Contents("HTML");
            List<String> remark = this.getGoodsRemarks(dto);
            String addDetailPlus = "";
            try {
                if (dtllist.getDetailkeywordb().equals("Y")) {
                    addDetailPlus = String.valueOf(dtllist.getDetailKeywordL()) + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
                }
                if (dtllist.getDetailproductcodeb().equals("Y")) {
                    addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
                }
                if (dtllist.getDetailproductnameb().equals("Y")) {
                    addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
                }
                int i = 0;
                while (i < remark.size()) {
                    String detail = "";
                    remark.set(i, dtllist.getProdnmdtltop().concat(remark.get(i)));
                    detail = i == Integer.parseInt(dtllist.getProdremarktype()) ? remark.get(i).concat(dtllist.getProdnmdtlbottom()) : remark.get(i);
                    if (dtllist.getRemarktop().equals("Y")) {
                        detail = "<h2 style='font-size:16px;font-weight: bold;font-family: Dotum;text-align: center;'>\uc0c1\ud488\uba85 : " + dto.getGoods_nm() + "</h2>".concat(detail);
                    }
                    detail = "<html><div>&nbsp;</div><div>".concat(detail).concat("</div></html>");
                    content.contentDetails.add(new ContentDetail(String.valueOf(addDetailPlus) + detail, "TEXT"));
                    item.contents.add(content);
                    items.add(item);
                    ++i;
                }
            }
            catch (Exception exception) {
                throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc0c1\ud488\uc0c1\uc138 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
        }
        dto.setProp1_cd(prop);
        return items;
    }

    private void setImg(ProductDTO dto, CupongProductItem item, ShopCoupangAdditionalDto dtllist, ShoppingmallDTO shopInfo) throws Exception {
        List<Object> strImages = new ArrayList();
        try {
            strImages = dtllist.getChangesize().equals("Y") ? this.getProductImages(dto, dtllist.getChangeSizeX(), dtllist.getChangeSizeY(), dtllist.getChangeSizeW(), dtllist.getChangeSizeH(), dtllist.getAngle(), dtllist.getScalePercent()) : this.getProductImages(dto);
            int i = 0;
            while (i < strImages.size()) {
                if (i <= 9) {
                    if (i == 0) {
                        item.images.add(new Image(i, "REPRESENTATION", (String)strImages.get(0), ""));
                    } else {
                        item.images.add(new Image(i, "DETAIL", (String)strImages.get(i), ""));
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc774\ubbf8\uc9c0 \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private List<ShopProdAttrnmDto> setNotice(ShopCoupangAdditionalDto dtllist, List<ShopProdAttrnmDto> shopProdAttrnmDtos, CupongProductItem item) throws Exception {
        List noticeDto = shopProdAttrnmDtos.stream().filter(d -> !d.getAttrcd().equals("option")).collect(Collectors.toList());
        List<ShopProdAttrnmDto> optDto = shopProdAttrnmDtos.stream().filter(d -> d.getAttrcd().equals("option")).collect(Collectors.toList());
        try {
            if (dtllist.getBatchyn().equals("Y")) {
                int i = 0;
                while (i < noticeDto.size()) {
                    if (dtllist.getAttrcdtitleyn().equals("Y")) {
                        item.notices.add(new Notices(((ShopProdAttrnmDto)noticeDto.get(i)).getAttrnm(), ((ShopProdAttrnmDto)noticeDto.get(i)).getIntercode(), String.valueOf(((ShopProdAttrnmDto)noticeDto.get(i)).getIntercode()) + " : \uc0c1\uc138\uc815\ubcf4 \ubcc4\ub3c4\ud45c\uae30"));
                    } else {
                        item.notices.add(new Notices(((ShopProdAttrnmDto)noticeDto.get(i)).getAttrnm(), ((ShopProdAttrnmDto)noticeDto.get(i)).getIntercode(), "\uc0c1\uc138\uc815\ubcf4 \ubcc4\ub3c4\ud45c\uae30"));
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < noticeDto.size()) {
                    if (dtllist.getAttrcdtitleyn().equals("Y")) {
                        item.notices.add(new Notices(((ShopProdAttrnmDto)noticeDto.get(i)).getAttrnm(), ((ShopProdAttrnmDto)noticeDto.get(i)).getIntercode(), ((ShopProdAttrnmDto)noticeDto.get(i)).getAttrvl()));
                    } else {
                        item.notices.add(new Notices(((ShopProdAttrnmDto)noticeDto.get(i)).getAttrnm(), ((ShopProdAttrnmDto)noticeDto.get(i)).getIntercode(), String.valueOf(((ShopProdAttrnmDto)noticeDto.get(i)).getIntercode()) + " : " + ((ShopProdAttrnmDto)noticeDto.get(i)).getAttrvl()));
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uace0\uc2dc\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return optDto;
    }

    public List<String> getGoodsRemarks(ProductDTO dto) {
        List<String> ret = Arrays.asList(dto.getGoods_remarks(), dto.getGoods_remarks2(), dto.getGoods_remarks3(), dto.getGoods_remarks4());
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    public List<String> getProducCharnm(ProductDTO dto) {
        List<String> ret = Arrays.asList(dto.getChar_1_nm(), dto.getChar_2_nm());
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result postProductReg(String json, ShoppingmallDTO shopInfo, ProductDTO dto) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            YDMAStringUtil.Print(json);
            String URL2 = "/v2/providers/seller_api/apis/api/v1/marketplace/seller-products";
            String acessKey = shopInfo.getAUTHKEY1();
            String secretKey = shopInfo.getAUTHKEY2();
            String vendorid = shopInfo.getVENDORID();
            URL2 = String.format(URL2, vendorid);
            URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
            String authorization = Hmac.generate((String)"POST", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
            uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
            StringEntity params = new StringEntity(json, "UTF-8");
            client = HttpClients.createDefault();
            HttpPost requestPatch = new HttpPost(uriBuilder.build().toString());
            requestPatch.addHeader("Authorization", authorization);
            requestPatch.addHeader("content-type", "application/json");
            requestPatch.setEntity((HttpEntity)params);
            response = client.execute((HttpUriRequest)requestPatch);
            int status2 = response.getStatusLine().getStatusCode();
            String message = response.getStatusLine().getReasonPhrase();
            if (status2 != 200) throw new Exception(message);
            InputStream is = response.getEntity().getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
            JsonParser parser = new JsonParser();
            JsonObject resObject = (JsonObject)parser.parse((Reader)br);
            YDMAStringUtil.Print(resObject);
            String result = this.jsonElementNullStr(resObject.get("code"));
            String result_message = this.jsonElementNullStr(resObject.get("message"));
            if (result.equals("SUCCESS")) {
                String productid = this.jsonElementNullStr(resObject.get("data"));
                Result result2 = new Result(1, "\uc0c1\ud488\ub4f1\ub85d\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \uc9c4\ud589 \ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc0c1\ud488\ubc88\ud638 : " + productid, productid);
                return result2;
            }
            try {
                throw new Exception(result_message);
            }
            catch (Exception e) {
                Result result3 = new Result(-1, e.getMessage());
                return result3;
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
    }

    private String getProductId(ProductDTO dto, ShoppingMallDetailDto shoppingMallDetailDto) {
        String prodcd = "";
        String loginID = shoppingMallDetailDto.getShoppingid();
        String loginPw = shoppingMallDetailDto.getPassword();
        String shopcd = shoppingMallDetailDto.getShopcd();
        String authkey = shoppingMallDetailDto.getAuthkey1() == null ? "" : shoppingMallDetailDto.getAuthkey1();
        IShopCommonLogin i = new IShopCommonLogin(){};
        String json = "{\"searchIds\":\"" + dto.getCompayny_goods_cd() + "\",\"startTime\":\"2000-01-01\",\"endTime\":\"2099-12-31\",\"productName\":\"\",\"brandName\":\"\",\"manufacturerName\":\"\"," + "\"productType\":\"\",\"dateType\":\"productRegistrationDate\",\"dateRangeShowStyle\":true,\"dateRange\":\"all\",\"saleEndDatePeriodType\":\"\",\"includeUsedProduct\":\"\"," + "\"deleteType\":\"false\",\"deliveryMethod\":\"\",\"shippingType\":\"\",\"shipping\":\"\",\"otherType\":\"\",\"productStatus\":[\"VALID\"]," + "\"advanceConditionShow\":false,\"displayCategoryCodes\":[],\"currentMenuCode\":\"\",\"page\":1,\"countPerPage\":50,\"sortField\":\"vendorInventoryId\",\"desc\":true,\"fromListV2\":true}";
        try {
            Map<String, String> cookies = i.loginCookie(loginID, loginPw, shopcd, true, authkey);
            Connection.Response rs = Jsoup.connect((String)"https://wing.coupang.com/tenants/seller-web/vendor-inventory/search").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36").header("Host", "wing.coupang.com").header("Connection", "keep-alive").header("sec-ch-ua", "\"Google Chrome\";v=\"87\", \" Not;A Brand\";v=\"99\", \"Chromium\";v=\"87\"").header("X-Requested-With", "XMLHttpRequest").header("Content-Type", "application/json").header("Origin", "https://wing.coupang.com").requestBody(json).referrer("https://wing.coupang.com/vendor-inventory/list").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = rs.body();
            YDMAStringUtil.Print(body);
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
            JsonObject databody = (JsonObject)jsonobject.get("body");
            JsonArray resultV2 = (JsonArray)databody.get("resultV2");
            if (resultV2.size() > 0) {
                JsonObject obj = (JsonObject)resultV2.get(0);
                prodcd = obj.get("vendorInventoryId").getAsString();
            }
        }
        catch (Exception exception) {
            return prodcd;
        }
        return prodcd;
    }

    private List<ShopProductOptionDto> getMallItemInfo(ProductDTO infoDto, ShoppingmallDTO shopInfo) throws Exception {
        ArrayList<ShopProductOptionDto> dtos;
        block18: {
            CloseableHttpResponse response = null;
            CloseableHttpClient client = null;
            dtos = new ArrayList<ShopProductOptionDto>();
            try {
                try {
                    String URL2 = "/v2/providers/seller_api/apis/api/v1/marketplace/seller-products/%s";
                    String acessKey = shopInfo.getAUTHKEY1();
                    String secretKey = shopInfo.getAUTHKEY2();
                    shopInfo.getVENDORID();
                    URL2 = String.format(URL2, infoDto.getShopprodno());
                    URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
                    String authorization = Hmac.generate((String)"GET", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
                    uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
                    client = HttpClients.createDefault();
                    HttpGet requestPatch = new HttpGet(uriBuilder.build().toString());
                    requestPatch.addHeader("Authorization", authorization);
                    requestPatch.addHeader("content-type", "application/json");
                    response = client.execute((HttpUriRequest)requestPatch);
                    int status2 = response.getStatusLine().getStatusCode();
                    String message = response.getStatusLine().getReasonPhrase();
                    if (status2 == 200) {
                        InputStream is = response.getEntity().getContent();
                        BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                        JsonParser parser = new JsonParser();
                        JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                        String result = this.jsonElementNullStr(resObject.get("code"));
                        String result_message = this.jsonElementNullStr(resObject.get("message"));
                        if (result.equals("SUCCESS")) {
                            ShopProdInDto prodIn = ShopProductDao.get().getShopSaleProductInfo(infoDto.getShopprodno());
                            JsonObject data2 = (JsonObject)resObject.get("data");
                            JsonArray items = (JsonArray)data2.get("items");
                            int i = 0;
                            while (i < items.size()) {
                                JsonObject item = (JsonObject)items.get(i);
                                ShopProductOptionDto dto = new ShopProductOptionDto();
                                dto.setSendseq(prodIn.getSendseq());
                                dto.setSkuseq(i + 1);
                                dto.setCompno(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                                dto.setShopprodno(infoDto.getShopprodno());
                                dto.setShopprodsku(this.jsonElementNullStr(item.get("sellerProductItemId")));
                                dto.setShopprodsku_nm(infoDto.getGoods_nm());
                                dto.setProdseq(Integer.parseInt(infoDto.getPRODSEQ()));
                                dto.setOptprodcd(String.valueOf(infoDto.getCompayny_goods_cd()) + "-" + Integer.toString(i + 1));
                                dto.setOptprodnm(this.getStringOptType(item.get("attributes").getAsJsonArray()));
                                dto.setOptspecdes(this.jsonElementNullStr(item.get("itemName")).replace(" - ", ":"));
                                dto.setOptsafestock(this.jsonElementNullStr(item.get("salePrice")));
                                dto.setOptvertstock(this.jsonElementNullStr(item.get("maximumBuyCount")));
                                dto.setOptaddamt(0);
                                dto.setBarcode(this.jsonElementNullStr(item.get("vendorItemId")));
                                dto.setInsertdt(YDMATimeUtil.getCurrentTimeByYDFormat());
                                dto.setInsertid(YDMASessonUtil.getCompnoInfo().getUserId());
                                dtos.add(dto);
                                ++i;
                            }
                            break block18;
                        }
                        throw new Exception(result_message);
                    }
                    throw new Exception(message);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (client != null) {
                    client.close();
                }
            }
        }
        return dtos;
    }

    private String getStringOptType(JsonArray list) {
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (i < list.size()) {
            JsonObject option2 = list.get(i).getAsJsonObject();
            nameList.add(option2.get("attributeTypeName").getAsString());
            ++i;
        }
        return nameList.stream().collect(Collectors.joining(":"));
    }

    @Override
    public synchronized ShopProductSendDto excute(ShopProductSendDto sendDTO) throws Exception {
        ShoppingmallDTO shopInfo = sendDTO.getShoppingmallDTO();
        List<ProductDTO> prodList = sendDTO.getShopProductDto();
        ShopCoupangAdditionalDto dtllist = (ShopCoupangAdditionalDto)sendDTO.getProductAdditionDto();
        PreferencesMallDTO dto1 = ShopCommonDao.get().getSystemConf();
        WorkMngDto workMngDto = sendDTO.getWorkMngDto();
        String uuid = sendDTO.getWorkgrp();
        if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
            workMngDto.setWork_status("W02");
            WorkMngDao.get().saveMst(uuid, sendDTO.getWorkMngDto());
            return sendDTO;
        }
        int progress = workMngDto.getProgress_rate();
        List<WorkMngDetailDto> workMngDetailDtos = workMngDto.getWork_detail();
        try {
            String.format("(%s) %s", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID());
            int mod = dto1.getPROCCNT() / prodList.size();
            workMngDto.setWork_status("W06");
            WorkMngDao.get().saveMst(uuid, sendDTO.getWorkMngDto());
            for (ProductDTO dto : prodList) {
                workMngDto.setProgress_rate(progress += mod);
                workMngDto.setWork_status("W08");
                ShopWorkDataQueue.get().notifyObservers();
                WorkMngDetailDto workMngDetailDto = workMngDetailDtos.stream().filter(p -> p.getProdseq().equals(dto.getCompayny_goods_cd())).findAny().orElse(null);
                if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
                    workMngDetailDto.setStatus("W02");
                    workMngDetailDto.setMessage("\ucde8\uc18c \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                if (workMngDetailDto.getStatus().equals("W06")) continue;
                if (workMngDto.getWork_status().equals("W02")) {
                    ShopProductSendDto shopProductSendDto = sendDTO;
                    return shopProductSendDto;
                }
                try {
                    try {
                        String prodNo = CoupangExitsProductCd.get().getisExistsProdNo(shopInfo.getAUTHKEY2(), shopInfo.getAUTHKEY1(), dto.getCompayny_goods_cd());
                        if (!prodNo.equals("")) {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774 \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            dto.setResult_code("-1");
                            dto.setResult_text("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774 \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                            continue;
                        }
                        String json = this.getApiJsonString(dto, dtllist, shopInfo);
                        Result result = this.postProductReg(json, shopInfo, dto);
                        if (result.getIsSucess() > 0) {
                            dto.setResult_code("1");
                            workMngDetailDto.setStatus("W06");
                            workMngDetailDto.setMessage(result.getMessage());
                            dto.setShopprodno(result.getProductCode());
                            dto.setResult_text(result.getMessage());
                            sendDTO.setShopProductDto(Arrays.asList(dto));
                            WorkMngDao.get().saveProductIn(sendDTO);
                            WorkMngDao.get().saveProdLog(dto, json);
                            if (this.shopOptionDtos.size() > 0) {
                                Thread.sleep(1000L);
                                List<ShopProductOptionDto> ItemList2 = this.getMallItemInfo(dto, shopInfo);
                                if (ItemList2.size() > 0) {
                                    if (this.shopOptionDtos.size() != ItemList2.size()) {
                                        Thread.sleep(5000L);
                                        ItemList2 = this.getMallItemInfo(dto, shopInfo);
                                        if (this.shopOptionDtos.size() != ItemList2.size()) {
                                            Thread.sleep(5000L);
                                            ItemList2 = this.getMallItemInfo(dto, shopInfo);
                                        }
                                    }
                                    WorkMngDao.get().insertOptprodin(ItemList2);
                                }
                            }
                        } else {
                            String errorMessage = this.setErrorMessage(result.getMessage());
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage(errorMessage);
                            dto.setResult_code("-1");
                            dto.setResult_text(errorMessage);
                        }
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    catch (Exception e) {
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage(e.getMessage());
                        dto.setResult_code("-1");
                        dto.setResult_text(e.getMessage());
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    continue;
                }
                catch (Exception exception) {
                    workMngDto.setWork_status("-1");
                }
                break;
            }
        }
        finally {
            WorkMngDao.get().saveMst(uuid, sendDTO.getWorkMngDto());
        }
        return sendDTO;
    }

    private String setErrorMessage(String error) {
        String errorMessage = "";
        errorMessage = error.contains("omDispNo") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488 \uce74\ud14c\uace0\ub9ac \uac12 \ube44\uc874\uc7ac] " + error : (error.contains("\ub3d9\uc77c\ud55c \uc0c1\ud488 \ub4f1\ub85d \ubd88\uac00") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488\uba85 \uc911\ubcf5\ub4f1\ub85d \ubd88\uac00] " + error : "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : " + error);
        return errorMessage;
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    private static class Attributes {
        private String attributeTypeName;
        private String attributeValueName;

        public Attributes(String attributeTypeName, String attributeValueName) {
            this.attributeTypeName = attributeTypeName;
            this.attributeValueName = attributeValueName;
        }
    }

    public static class CateRecommend {
        private String productName;
        private String productDescription;
        private String brand;
        private String sellerSkuCode;
    }

    private static class Certification {
        private String certificationType;
        private String certificationCode;

        public Certification(String certificationType, String certificationCode) {
            this.certificationType = certificationType;
            this.certificationCode = certificationCode;
        }
    }

    private static class ContentDetail {
        private String content;
        private String detailType;

        public ContentDetail(String content, String detailType) {
            this.content = content;
            this.detailType = detailType;
        }
    }

    private static class Contents {
        private String contentsType;
        private List<ContentDetail> contentDetails;

        public Contents(String contentsType) {
            this.contentsType = contentsType;
            this.contentDetails = new ArrayList<ContentDetail>();
        }
    }

    private static final class CupongProductItem {
        private String itemName;
        private long originalPrice;
        private long salePrice;
        private long maximumBuyCount;
        private long maximumBuyForPerson;
        private long maximumBuyForPersonPeriod;
        private long outboundShippingTimeDay;
        private long unitCount;
        private String adultOnly;
        private String taxType;
        private String parallelImported;
        private String overseasPurchased;
        private boolean pccNeeded;
        private String externalVendorSku;
        private String barcode;
        private boolean emptyBarcode;
        private String emptyBarcodeReason;
        private String modelNo;
        private Map<String, String> extraProperties = new HashMap<String, String>();
        private List<Certification> certifications = new ArrayList<Certification>();
        private List<String> searchTags = new ArrayList<String>();
        private List<Image> images = new ArrayList<Image>();
        private List<Notices> notices = new ArrayList<Notices>();
        private List<Attributes> attributes = new ArrayList<Attributes>();
        private List<Contents> contents = new ArrayList<Contents>();
        private String offerCondition;
        private String offerDescription;

        private CupongProductItem() {
        }
    }

    private static final class CupongProductReg {
        private long displayCategoryCode;
        private String sellerProductName;
        private String vendorId;
        private String saleStartedAt;
        private String saleEndedAt;
        private String displayProductName;
        private String brand;
        private String generalProductName;
        private String productGroup;
        private String deliveryMethod;
        private String deliveryCompanyCode;
        private String deliveryChargeType;
        private long deliveryCharge;
        private long freeShipOverAmount;
        private long deliveryChargeOnReturn;
        private String remoteAreaDeliverable;
        private String unionDeliveryType;
        private String returnCenterCode;
        private String returnChargeName;
        private String companyContactNumber;
        private String returnZipCode;
        private String returnAddress;
        private String returnAddressDetail;
        private long returnCharge;
        private String returnChargeVendor;
        private String afterServiceInformation;
        private String afterServiceContactNumber;
        private long outboundShippingPlaceCode;
        private String vendorUserId;
        private boolean requested;
        private List<CupongProductItem> items = new ArrayList<CupongProductItem>();
        private List<RequiredDocument> requiredDocuments = new ArrayList<RequiredDocument>();
        private String extraInfoMessage;
        private String manufacture;

        private CupongProductReg() {
        }
    }

    private static class Image {
        private long imageOrder;
        private String imageType;
        private String cdnPath;
        private String vendorPath;

        public Image(long imageOrder, String imageType, String cdnPath, String vendorPath) {
            this.imageOrder = imageOrder;
            this.imageType = imageType;
            this.cdnPath = cdnPath;
            this.vendorPath = vendorPath;
        }
    }

    private static class Notices {
        private String noticeCategoryName;
        private String noticeCategoryDetailName;
        private String content;

        public Notices(String noticeCategoryName, String noticeCategoryDetailName, String content) {
            this.noticeCategoryName = noticeCategoryName;
            this.noticeCategoryDetailName = noticeCategoryDetailName;
            this.content = content;
        }
    }

    private static class RequiredDocument {
        private String templateName;
        private String vendorDocumentPath;

        public RequiredDocument(String templateName, String vendorDocumentPath) {
            this.templateName = templateName;
            this.vendorDocumentPath = vendorDocumentPath;
        }
    }

    private final class Result {
        private int isSucess;
        private String message;
        private String productCode;

        public int getIsSucess() {
            return this.isSucess;
        }

        public void setIsSucess(int isSucess) {
            this.isSucess = isSucess;
        }

        public String getMessage() {
            return this.message;
        }

        public Result(int isSucess, String message, String productCode) {
            this.isSucess = isSucess;
            this.message = message;
            this.productCode = productCode;
        }

        public Result(int isSucess, String message) {
            this.isSucess = isSucess;
            this.message = message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getProductCode() {
            return this.productCode;
        }

        public void setProductCode(String productCode) {
            this.productCode = productCode;
        }
    }

    private static final class ReturnShippingCenter {
        private String vendorId;
        private String returnCenterCode;
        private String shippingPlaceName;
        private String deliverCode;
        private String deliverName;
        private String goodsflowStatus;
        private String errorMessage;
        private String createdAt;
        private String vendorCreditFee05kg;
        private String vendorCreditFee10kg;
        private String vendorCreditFee20kg;
        private String vendorCashFee05kg;
        private String vendorCashFee10kg;
        private String vendorCashFee20kg;
        private String consumerCashFee05kg;
        private String consumerCashFee10kg;
        private String consumerCashFee20kg;
        private String returnFee05kg;
        private String returnFee10kg;
        private String returnFee20kg;
        private boolean usable;
        List<PlaceAddresses> placeAddress = new ArrayList<PlaceAddresses>();

        private ReturnShippingCenter() {
        }

        public String getVendorId() {
            return this.vendorId;
        }

        public void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        public String getReturnCenterCode() {
            return this.returnCenterCode;
        }

        public void setReturnCenterCode(String returnCenterCode) {
            this.returnCenterCode = returnCenterCode;
        }

        public String getShippingPlaceName() {
            return this.shippingPlaceName;
        }

        public void setShippingPlaceName(String shippingPlaceName) {
            this.shippingPlaceName = shippingPlaceName;
        }

        public String getDeliverCode() {
            return this.deliverCode;
        }

        public void setDeliverCode(String deliverCode) {
            this.deliverCode = deliverCode;
        }

        public String getDeliverName() {
            return this.deliverName;
        }

        public void setDeliverName(String deliverName) {
            this.deliverName = deliverName;
        }

        public String getGoodsflowStatus() {
            return this.goodsflowStatus;
        }

        public void setGoodsflowStatus(String goodsflowStatus) {
            this.goodsflowStatus = goodsflowStatus;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getVendorCreditFee05kg() {
            return this.vendorCreditFee05kg;
        }

        public void setVendorCreditFee05kg(String vendorCreditFee05kg) {
            this.vendorCreditFee05kg = vendorCreditFee05kg;
        }

        public String getVendorCreditFee10kg() {
            return this.vendorCreditFee10kg;
        }

        public void setVendorCreditFee10kg(String vendorCreditFee10kg) {
            this.vendorCreditFee10kg = vendorCreditFee10kg;
        }

        public String getVendorCreditFee20kg() {
            return this.vendorCreditFee20kg;
        }

        public void setVendorCreditFee20kg(String vendorCreditFee20kg) {
            this.vendorCreditFee20kg = vendorCreditFee20kg;
        }

        public String getVendorCashFee05kg() {
            return this.vendorCashFee05kg;
        }

        public void setVendorCashFee05kg(String vendorCashFee05kg) {
            this.vendorCashFee05kg = vendorCashFee05kg;
        }

        public String getVendorCashFee10kg() {
            return this.vendorCashFee10kg;
        }

        public void setVendorCashFee10kg(String vendorCashFee10kg) {
            this.vendorCashFee10kg = vendorCashFee10kg;
        }

        public String getVendorCashFee20kg() {
            return this.vendorCashFee20kg;
        }

        public void setVendorCashFee20kg(String vendorCashFee20kg) {
            this.vendorCashFee20kg = vendorCashFee20kg;
        }

        public String getConsumerCashFee05kg() {
            return this.consumerCashFee05kg;
        }

        public void setConsumerCashFee05kg(String consumerCashFee05kg) {
            this.consumerCashFee05kg = consumerCashFee05kg;
        }

        public String getConsumerCashFee10kg() {
            return this.consumerCashFee10kg;
        }

        public void setConsumerCashFee10kg(String consumerCashFee10kg) {
            this.consumerCashFee10kg = consumerCashFee10kg;
        }

        public String getConsumerCashFee20kg() {
            return this.consumerCashFee20kg;
        }

        public void setConsumerCashFee20kg(String consumerCashFee20kg) {
            this.consumerCashFee20kg = consumerCashFee20kg;
        }

        public String getReturnFee05kg() {
            return this.returnFee05kg;
        }

        public void setReturnFee05kg(String returnFee05kg) {
            this.returnFee05kg = returnFee05kg;
        }

        public String getReturnFee10kg() {
            return this.returnFee10kg;
        }

        public void setReturnFee10kg(String returnFee10kg) {
            this.returnFee10kg = returnFee10kg;
        }

        public String getReturnFee20kg() {
            return this.returnFee20kg;
        }

        public void setReturnFee20kg(String returnFee20kg) {
            this.returnFee20kg = returnFee20kg;
        }

        public boolean isUsable() {
            return this.usable;
        }

        public void setUsable(boolean usable) {
            this.usable = usable;
        }

        public List<PlaceAddresses> getPlaceAddress() {
            return this.placeAddress;
        }

        public void setPlaceAddress(List<PlaceAddresses> placeAddress) {
            this.placeAddress = placeAddress;
        }

        class PlaceAddresses {
            private String addressType;
            private String countryCode;
            private String companyContactNumber;
            private String phoneNumber2;
            private String returnZipCode;
            private String returnAddress;
            private String returnAddressDetail;

            PlaceAddresses() {
            }

            public String getAddressType() {
                return this.addressType;
            }

            public void setAddressType(String addressType) {
                this.addressType = addressType;
            }

            public String getCountryCode() {
                return this.countryCode;
            }

            public void setCountryCode(String countryCode) {
                this.countryCode = countryCode;
            }

            public String getCompanyContactNumber() {
                return this.companyContactNumber;
            }

            public void setCompanyContactNumber(String companyContactNumber) {
                this.companyContactNumber = companyContactNumber;
            }

            public String getPhoneNumber2() {
                return this.phoneNumber2;
            }

            public void setPhoneNumber2(String phoneNumber2) {
                this.phoneNumber2 = phoneNumber2;
            }

            public String getReturnZipCode() {
                return this.returnZipCode;
            }

            public void setReturnZipCode(String returnZipCode) {
                this.returnZipCode = returnZipCode;
            }

            public String getReturnAddress() {
                return this.returnAddress;
            }

            public void setReturnAddress(String returnAddress) {
                this.returnAddress = returnAddress;
            }

            public String getReturnAddressDetail() {
                return this.returnAddressDetail;
            }

            public void setReturnAddressDetail(String returnAddressDetail) {
                this.returnAddressDetail = returnAddressDetail;
            }
        }
    }

    private static class requiredDoc {
        private String tempnm;
        private String required;

        private requiredDoc() {
        }

        public String getTempnm() {
            return this.tempnm;
        }

        public void setTempnm(String tempnm) {
            this.tempnm = tempnm;
        }

        public String getRequired() {
            return this.required;
        }

        public void setRequired(String required) {
            this.required = required;
        }
    }
}

