/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.coupang;

import com.coupang.openapi.sdk.Hmac;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class CoupangChangeOrderExpressCommand
implements IShopOrderCommand {
    private static CoupangChangeOrderExpressCommand instance = new CoupangChangeOrderExpressCommand();

    public static CoupangChangeOrderExpressCommand getInstance() {
        return instance;
    }

    private CoupangChangeOrderExpressCommand() {
    }

    @Override
    public void Login(String loginID, String loginPw, String gubun) throws Exception {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return 0;
    }

    @Override
    public int Search_conf(String URL2, String startdt, String enddt, String searchkeyword) throws Exception {
        return 0;
    }

    private List<ShopOrderMstDto> getApiList(List<ShopOrderMstDto> param, String json) throws Exception {
        new ArrayList();
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String id = param.get(0).getShop_userid();
        param.get(0).getShopPw();
        String shopid = param.get(0).getShopid();
        try {
            String URL2 = "/v2/providers/openapi/apis/api/v4/vendors/%s/orders/updateInvoices";
            String acessKey = param.get(0).getAuthkey1();
            String secretKey = param.get(0).getAuthKey2();
            String vendorid = param.get(0).getApikey();
            URL2 = String.format(URL2, vendorid);
            URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
            String authorization = Hmac.generate((String)"POST", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
            uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
            StringEntity params = new StringEntity(json, "UTF-8");
            client = HttpClients.createDefault();
            HttpPost requestPatch = new HttpPost(uriBuilder.build().toString());
            requestPatch.addHeader("Authorization", authorization);
            requestPatch.addHeader("content-type", "application/json");
            requestPatch.setEntity((HttpEntity)params);
            response = client.execute((HttpUriRequest)requestPatch);
            int status2 = response.getStatusLine().getStatusCode();
            response.getStatusLine().getReasonPhrase();
            if (status2 == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                YDMAStringUtil.Print(resObject);
                JsonObject RESULT = (JsonObject)resObject.get("data");
                Long result = RESULT.get("responseCode").getAsLong();
                String result_message = RESULT.get("responseMessage").getAsString();
                if (result == 0L) {
                    param.forEach(dto -> {
                        dto.setResult_code("1");
                        dto.setShopid(shopid);
                        dto.setShop_userid(id);
                        dto.setOrder_status("403");
                    });
                } else if (result == 1L) {
                    param.forEach(dto -> {
                        dto.setResult_code("-1");
                        dto.setResult_text("\ubd80\ubd84\uc2e4\ud328");
                        dto.setShopid(shopid);
                        dto.setShop_userid(id);
                    });
                } else if (result == 99L) {
                    param.forEach(dto -> {
                        dto.setResult_code("-1");
                        dto.setResult_text(result_message);
                        dto.setShopid(shopid);
                        dto.setShop_userid(id);
                    });
                } else if (result == -1L) {
                    param.forEach(dto -> {
                        dto.setResult_code("-1");
                        dto.setResult_text("\ub370\uc774\ud0c0 \uc5c6\uc74c");
                        dto.setShopid(shopid);
                        dto.setShop_userid(id);
                    });
                }
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return param;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> ret_list = new ArrayList<ShopOrderMstDto>();
        String vendorid = param.get(0).getApikey();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Map<String, List<ShopOrderMstDto>> mapList = param.stream().collect(Collectors.groupingBy(ShopOrderMstDto::getOrder_id));
        for (String ordid : mapList.keySet()) {
            RequestParameters requestParameters = new RequestParameters();
            ArrayList<OrderSheetInvoiceApplyDtos> orderSheetInvoiceApplyList = new ArrayList<OrderSheetInvoiceApplyDtos>();
            List<ShopOrderMstDto> list = mapList.get(ordid);
            requestParameters.setVendorId(vendorid);
            for (ShopOrderMstDto dto : list) {
                OrderSheetInvoiceApplyDtos orderSheetInvoiceApplyDtos = new OrderSheetInvoiceApplyDtos();
                orderSheetInvoiceApplyDtos.setShipmentBoxId(Long.valueOf(dto.getCopy_idx()));
                orderSheetInvoiceApplyDtos.setOrderId(Long.valueOf(dto.getOrder_id()));
                orderSheetInvoiceApplyDtos.setDeliveryCompanyCode(dto.getDelivery_id());
                orderSheetInvoiceApplyDtos.setInvoiceNumber(this.splitMark(dto.getInvoice_no()));
                orderSheetInvoiceApplyDtos.setVendorItemId(Long.valueOf(dto.getSku_id()));
                orderSheetInvoiceApplyDtos.setSplitShipping("false");
                orderSheetInvoiceApplyDtos.setPreSplitShipped("false");
                orderSheetInvoiceApplyDtos.setEstimatedShippingDate("");
                orderSheetInvoiceApplyList.add(orderSheetInvoiceApplyDtos);
            }
            requestParameters.setOrderSheetInvoiceApplyDtos(orderSheetInvoiceApplyList);
            String json = mapper.writeValueAsString((Object)requestParameters);
            List<ShopOrderMstDto> retlist = this.getApiList(list, json);
            ret_list.addAll(retlist);
        }
        return ret_list;
    }

    public String splitMark(String text) {
        String[] split = text.split(" ");
        String complite = "";
        int j = 0;
        while (j < split.length) {
            complite = String.valueOf(complite) + split[j];
            complite = complite.trim();
            ++j;
        }
        return complite;
    }

    static class OrderSheetInvoiceApplyDtos {
        Long shipmentBoxId;
        Long orderId;
        String deliveryCompanyCode;
        String invoiceNumber;
        Number vendorItemId;
        String splitShipping;
        String preSplitShipped;
        String estimatedShippingDate;

        OrderSheetInvoiceApplyDtos() {
        }

        public Long getShipmentBoxId() {
            return this.shipmentBoxId;
        }

        public void setShipmentBoxId(Long shipmentBoxId) {
            this.shipmentBoxId = shipmentBoxId;
        }

        public Long getOrderId() {
            return this.orderId;
        }

        public void setOrderId(Long orderId) {
            this.orderId = orderId;
        }

        public String getDeliveryCompanyCode() {
            return this.deliveryCompanyCode;
        }

        public void setDeliveryCompanyCode(String deliveryCompanyCode) {
            this.deliveryCompanyCode = deliveryCompanyCode;
        }

        public String getInvoiceNumber() {
            return this.invoiceNumber;
        }

        public void setInvoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
        }

        public Number getVendorItemId() {
            return this.vendorItemId;
        }

        public void setVendorItemId(Number vendorItemId) {
            this.vendorItemId = vendorItemId;
        }

        public String getSplitShipping() {
            return this.splitShipping;
        }

        public void setSplitShipping(String splitShipping) {
            this.splitShipping = splitShipping;
        }

        public String getPreSplitShipped() {
            return this.preSplitShipped;
        }

        public void setPreSplitShipped(String preSplitShipped) {
            this.preSplitShipped = preSplitShipped;
        }

        public String getEstimatedShippingDate() {
            return this.estimatedShippingDate;
        }

        public void setEstimatedShippingDate(String estimatedShippingDate) {
            this.estimatedShippingDate = estimatedShippingDate;
        }
    }

    static class RequestParameters {
        List<OrderSheetInvoiceApplyDtos> orderSheetInvoiceApplyDtos;
        private String vendorId;

        RequestParameters() {
        }

        public String getVendorId() {
            return this.vendorId;
        }

        public void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        public List<OrderSheetInvoiceApplyDtos> getOrderSheetInvoiceApplyDtos() {
            return this.orderSheetInvoiceApplyDtos;
        }

        public void setOrderSheetInvoiceApplyDtos(List<OrderSheetInvoiceApplyDtos> orderSheetInvoiceApplyDtos) {
            this.orderSheetInvoiceApplyDtos = orderSheetInvoiceApplyDtos;
        }
    }
}

