/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class NaverStoreProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    JsonParser jsonparser = new JsonParser();
    JsonObject jsonobject = new JsonObject();

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto) throws Exception {
        String shopInfoLog = String.format("[%s - %s(%s)]", dto.getSHOPINFO().getSHOPNM(), dto.getSHOPINFO().getSHOPPINGID(), dto.getSHOPINFO().getNICKNM1());
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 3000: 
                case 4000: {
                    this.setProductStop(dto.getPRODUCT(), dto.getCOOKIES());
                    this.logProductInDetail(shopInfoLog, dto.getPRODUCT(), "\uc0ad\uc81c", dto.getSHOPINFO(), "\uc131\uacf5", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                }
            }
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    private void setProductStop(ProductDTO product2, Map<String, String> cookies) throws Exception {
        block8: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPatch httpPatch = new HttpPatch("https://sell.smartstore.naver.com/api/products/bulk-update?_action=updateProductStatusType");
            httpPatch.setHeader("Cookie", this.ConvertDictionaryToParameter(cookies));
            httpPatch.setHeader("x-to-stateName", "main.product.origin-list");
            httpPatch.setHeader("Origin", "https://sell.smartstore.naver.com");
            httpPatch.setHeader("Pragma", "no-cache");
            httpPatch.setHeader("Cache-Control", "no-cache");
            httpPatch.setHeader("x-current-stateName", "main.product.origin-list");
            httpPatch.setHeader("x-current-state", "https://sell.smartstore.naver.com/#/products/origin-list");
            httpPatch.setHeader("Sec-Fetch-Site", "same-origin");
            httpPatch.setHeader("Sec-Fetch-Mode", "cors");
            httpPatch.setHeader("Sec-Fetch-Dest", "empty");
            httpPatch.setHeader("Referer", "https://sell.smartstore.naver.com/");
            httpPatch.setHeader("Content-Type", "application/json;charset=UTF-8");
            StringBuilder sb = new StringBuilder();
            sb.append("{").append("\"productNos\":[").append(product2.getShopprodno()).append("],").append("\"productStatusType\":\"DELETE\",").append("\"productBulkUpdateType\":\"DELETE\"").append("}");
            ByteArrayEntity entity = new ByteArrayEntity(sb.toString().getBytes("UTF-8"));
            try {
                httpPatch.setEntity((HttpEntity)entity);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPatch);
            HttpEntity respEntity = response.getEntity();
            String content = "";
            String message = "";
            try {
                content = EntityUtils.toString((HttpEntity)respEntity);
                this.jsonobject = (JsonObject)this.jsonparser.parse(content);
                message = this.jsonobject.get("status").toString();
                if (message.contains("STARTED")) {
                    try {
                        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/bulk-update?_action=getBulkUpdateProgressResult").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").header("Connection", "keep-alive").header("x-to-stateName", "main.product.origin-list").header("Content-Type", "application/json;charset=UTF-8").header("Origin", "https://sell.smartstore.naver.com").header("Pragma", "no-cache").header("Cache-Control", "no-cache").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
                        this.jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
                        this.jsonobject = this.jsonobject.get("productBulkUpdateResultVO").getAsJsonObject();
                        JsonObject obj = this.jsonobject.get("resultMessage").getAsJsonObject();
                        String key = obj.entrySet().stream().findFirst().map(Map.Entry::getKey).orElse(null);
                        String resultMessage = obj.get(key).getAsString();
                        if (!resultMessage.contains("\uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4")) {
                            product2.setResult_text("\uba54\uc138\uc9c0 \ud655\uc778 \uc2e4\ud328.");
                            throw new Exception("\uc0c1\ud488\uc0ad\uc81c\uc2e4\ud328 : " + resultMessage);
                        }
                        product2.setResult_code("1");
                        product2.setResult_text("\uc815\uc0c1\uc801\uc73c\ub85c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                        break block8;
                    }
                    catch (Exception e) {
                        product2.setResult_text("\uba54\uc138\uc9c0 \ud655\uc778 \uc2e4\ud328.");
                        throw e;
                    }
                }
                product2.setResult_text("\uc0c1\ud488\uc0ad\uc81c\uc2e4\ud328 : \uc7a0\uc2dc\ud6c4\uc5d0 \ub2e4\uc2dc \uc804\uc1a1\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                throw new Exception("\uc0c1\ud488\uc0ad\uc81c\uc2e4\ud328 : \uc7a0\uc2dc\ud6c4\uc5d0 \ub2e4\uc2dc \uc804\uc1a1\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
            }
            catch (Exception e) {
                product2.setResult_code("-1");
                throw new Exception(e);
            }
        }
    }

    @Override
    private String ConvertDictionaryToParameter(Map<String, String> parameters) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            list.add(String.valueOf(key) + "=" + value);
        }
        return list.stream().collect(Collectors.joining(";"));
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        return null;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        return true;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        return false;
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String logType) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        this.setValueAndLogForProdIn(comment, 50, prodInfo, shoppingmallDTO, "YEL_DEL", jobResult, logType);
    }

    private void setValueAndLogForProdIn(String title, int value, ProductDTO item, ShoppingmallDTO shopInfo, String jobType, String jobResult, String logMsg) {
        CommonProgressDialog.get().setValueAndLogForProdIn(title, value, item, shopInfo, jobType, jobResult, logMsg);
    }
}

