/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.helper.LoginHelper;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class TossShoppingProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto) throws Exception {
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        ProductDTO prodInfo = dto.getPRODUCT();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 3000: 
                case 4000: {
                    boolean flag = this.DeleteProduct(shopInfo, prodInfo);
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\uc0ad\uc81c", shopInfo, "\uc131\uacf5", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                }
            }
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    private boolean DeleteProduct(ShoppingmallDTO shoppingMallDetailDto, ProductDTO shopProductDto) {
        block4: {
            ObjectMapper mapper;
            JsonObject merchantUser;
            JsonObject merchantMappingInfo;
            JsonParser jsonParser;
            Map<String, String> cookies;
            block5: {
                cookies = LoginHelper.getTossCookies(shoppingMallDetailDto.getSHOPPINGID(), shoppingMallDetailDto.getPASSWORD());
                Connection.Response rs = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/my-info").cookies(cookies).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                jsonParser = new JsonParser();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(rs.body());
                String resultType = jsonObject.get("resultType").getAsString();
                if (!resultType.equals("SUCCESS")) break block4;
                JsonObject success = (JsonObject)jsonObject.get("success");
                JsonArray merchantMappingArray = (JsonArray)success.get("merchantMappingInfo");
                merchantMappingInfo = Integer.parseInt(shoppingMallDetailDto.getAUTHKEY1()) == 0 ? merchantMappingArray.get(0).getAsJsonObject() : merchantMappingArray.get(Integer.parseInt(shoppingMallDetailDto.getAUTHKEY1()) - 1).getAsJsonObject();
                merchantUser = (JsonObject)success.get("merchantUser");
                mapper = new ObjectMapper();
                HideJson hideJson = new HideJson();
                hideJson.hide = true;
                hideJson.merchantId = merchantMappingInfo.get("merchantId").getAsInt();
                hideJson.merchantUserId = merchantUser.get("id").getAsInt();
                hideJson.productIds.add(Integer.parseInt(shopProductDto.getShopprodno()));
                String jsonHide = mapper.writeValueAsString((Object)hideJson);
                String hideUrl = "https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/" + hideJson.merchantId + "/v1/products/update-hide-status";
                Connection.Response hidePost = Jsoup.connect((String)hideUrl).header("Content-Type", "application/json").cookies(cookies).method(Connection.Method.POST).requestBody(jsonHide).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                JsonObject hideObject = (JsonObject)jsonParser.parse(hidePost.body());
                String hideResultType = hideObject.get("resultType").getAsString();
                if (hideResultType.equals("SUCCESS")) break block5;
                return false;
            }
            try {
                DeleteJson deleteJson = new DeleteJson();
                deleteJson.merchantId = merchantMappingInfo.get("merchantId").getAsInt();
                deleteJson.merchantUserId = merchantUser.get("id").getAsInt();
                deleteJson.productIds.add(Integer.parseInt(shopProductDto.getShopprodno()));
                String json = mapper.writeValueAsString((Object)deleteJson);
                String url = "https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/" + deleteJson.merchantId + "/v1/delete-products";
                Connection.Response rsPost = Jsoup.connect((String)url).header("Content-Type", "application/json").cookies(cookies).method(Connection.Method.POST).requestBody(json).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                JsonObject object = (JsonObject)jsonParser.parse(rsPost.body());
                String resultType2 = object.get("resultType").getAsString();
                if (resultType2.equals("SUCCESS")) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        return null;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingmallDTO, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        return false;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingmallDTO, Map<String, String> loginCookie) throws Exception {
        return false;
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String logType) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        this.setValueAndLogForProdIn(comment, 50, prodInfo, shoppingmallDTO, "YEL_DEL", jobResult, logType);
    }

    private void setValueAndLogForProdIn(String title, int value, ProductDTO item, ShoppingmallDTO shopInfo, String jobType, String jobResult, String logMsg) {
        CommonProgressDialog.get().setValueAndLogForProdIn(title, value, item, shopInfo, jobType, jobResult, logMsg);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static final class DeleteJson {
        private List<Integer> productIds = new ArrayList<Integer>();
        private int merchantId;
        private int merchantUserId;

        private DeleteJson() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static final class HideJson {
        private boolean hide;
        private List<Integer> productIds = new ArrayList<Integer>();
        private int merchantId;
        private int merchantUserId;

        private HideJson() {
        }
    }
}

