/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.jobLog;

import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dao.ShoppingmallDAO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.yellim.shop.jobLog.JobLogDTO;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobLogHelper {
    public static final String \uc0c1\ud488 = "PROD";
    public static final String \uc8fc\ubb38 = "ORD";
    public static final String \ubb38\uc758 = "QNA";
    public static final String \uc610\ub9bc = "YEL";
    public static final String \uc218\uc2e0 = "RECV";
    public static final String \ub4f1\ub85d = "REG";
    public static final String \uc218\uc815 = "MODI";
    public static final String \uc0ad\uc81c = "DEL";
    public static final String \uc218\uc9d1 = "COLLECT";
    public static final String \ud655\uc778 = "CONFIRM";
    public static final String \ub3d9\uae30\ud654 = "SYNC";
    public static final String \ub3c4\ub9e4\uc8fc\ubb38 = "DOME_SEND";
    public static final String \ub3c4\ub9e4\uc218\uc9d1 = "DOME_COLLECT";
    public static final String \ubc1c\uc1a1 = "DELV_SEND";
    public static final String \ucd94\uac00 = "ADD";
    public static final String \ub3c4\ub9e4\ubab0\uc218\uc815 = "DOME_MODI";
    public static final String \ub3c4\ub9e4\ub3d9\uae30\ud654 = "DOME_SYNC";
    public static final String \uc5d1\uc140 = "EXCEL";
    public static final String \uac80\uc0c9 = "SEARCH";
    public static final String \uc2a4\ucf00\uc974\ub7ec = "SCHEDULER";
    public static final String \uc0c1\ud488\uc218\uc2e0 = "PROD_RECV";
    public static final String \uc0c1\ud488\ub4f1\ub85d = "PROD_REG";
    public static final String \uc0c1\ud488\uc218\uc815 = "PROD_MODI";
    public static final String \uc0c1\ud488\uc0ad\uc81c = "PROD_DEL";
    public static final String \uc0c1\ud488\ub3d9\uae30\ud654 = "PROD_SYNC";
    public static final String \uc8fc\ubb38\uc218\uc9d1 = "ORD_COLLECT";
    public static final String \uc8fc\ubb38\ud655\uc778 = "ORD_CONFIRM";
    public static final String \uc8fc\ubb38\ub3d9\uae30\ud654 = "ORD_SYNC";
    public static final String \uc8fc\ubb38_\ub3c4\ub9e4\uc8fc\ubb38 = "ORD_DOME_SEND";
    public static final String \uc8fc\ubb38_\ub3c4\ub9e4\uc218\uc9d1 = "ORD_DOME_COLLECT";
    public static final String \uc8fc\ubb38_\ub3c4\ub9e4\ub3d9\uae30\ud654 = "ORD_DOME_SYNC";
    public static final String \uc8fc\ubb38\ubc1c\uc1a1 = "ORD_DELV_SEND";
    public static final String \ubb38\uc758\uc218\uc9d1 = "QNA_NEW";
    public static final String \ubb38\uc758\ub2f5\ubcc0 = "QNA_SEND";
    public static final String \uc610\ub9bc\ucd94\uac00 = "YEL_ADD";
    public static final String \uc610\ub9bc\uc0ad\uc81c = "YEL_DEL";
    public static final String \uc610\ub9bc\uc218\uc815 = "YEL_MODI";
    public static final String \uc610\ub9bc\ub3c4\ub9e4\ubab0\uc218\uc815 = "YEL_DOME_MODI";
    public static final String \uc790\ub3d9\uc0ad\uc81c = "[\uc610\ub9bc \uc790\ub3d9\uc0ad\uc81c] \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc790\ub3d9\uc0ad\uc81c\ubbf8\uc874\uc7ac = "[\uc610\ub9bc \uc790\ub3d9\uc0ad\uc81c] \uc1fc\ud551\ubab0\uc5d0 \ud574\ub2f9 \uc0c1\ud488\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc544 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \ud488\ub2e8\uc885\ucc98\ub9ac\uc0ad\uc81c = "[\uc610\ub9bc \ud488\ub2e8\uc885\uc0c1\ud488] \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \ud488\ub2e8\uc885\ucc98\ub9ac = "[\uc610\ub9bc \ud488\ub2e8\uc885\uc0c1\ud488] \ud488\ub2e8\uc885 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc6b4\uc601\uc0c1\ud488\uad00\ub9ac\uc0ad\uc81c = "[\uc610\ub9bc \uc6b4\uc601\uc0c1\ud488\uad00\ub9ac] \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc6b4\uc601\uc0c1\ud488\uad00\ub9ac\ud488\ub2e8\uc885 = "[\uc610\ub9bc \uc6b4\uc601\uc0c1\ud488\uad00\ub9ac] \ud488\ub2e8\uc885 \ub300\uc0c1\uc73c\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc5d1\uc140\uc0ad\uc81c = "[\uc610\ub9bc \uc5d1\uc140\uc5c5\ub85c\ub4dc] \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc1fc\ud551\ubab0\uc0c1\ud488\ucd94\uac00 = "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc1fc\ud551\ubab0\uc0c1\ud488\uc218\uc815 = "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488 \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc5d1\uc140\ucd94\uac00 = "[\uc610\ub9bc \uc5d1\uc140\uc5c5\ub85c\ub4dc] \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc5d1\uc140\uc218\uc815 = "[\uc610\ub9bc \uc5d1\uc140\uc5c5\ub85c\ub4dc] \uc0c1\ud488\uc774 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc1fc\ud551\ubab0\ud488\uc808 = "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud488\uc808 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.";
    public static final String \uc1fc\ud551\ubab0\ud310\ub9e4\uc885\ub8cc = "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc885\ub8cc \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.";
    public static final String \uc1fc\ud551\ubab0\ud310\ub9e4\uc911\uc9c0 = "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\uc9c0 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.";
    public static final String \uc1fc\ud551\ubab0\uc0ad\uc81c = "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2e4\ud328_\ub3d9\uc77c\uc0c1\ud0dc\ubcc0\uacbd = "\ub3d9\uc77c\ud55c \uc0c1\ud0dc\ub85c\uc758 \ubcc0\uacbd\uc785\ub2c8\ub2e4.";
    public static final String \uc2e4\ud328_\ubbf8\uc874\uc7ac = "\ud574\ub2f9 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2e4\ud328_\ud655\uc778\ud544\uc694 = "\uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0c1\ud488\uc744 \ud655\uc778\ud574 \uc8fc\uc138\uc694.";
    public static final String \uc2e4\ud328 = "\uc1fc\ud551\ubab0 \uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";

    public static JobLogDTO createJobLogForProdIn(ProductDTO product2, ShoppingmallDTO shopInfo, String jobType, String jobResult, String logMsg) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        dto.setJobMain(parsed.get("jobMain"));
        dto.setJobSub(parsed.get("jobSub"));
        dto.setProdCd(product2.getCompayny_goods_cd());
        dto.setShopProdNo(product2.getShopprodno());
        dto.setShopCd(shopInfo.getSHOPCD());
        dto.setShopUserId(shopInfo.getSHOPPINGID());
        dto.setNickname(shopInfo.getNICKNM1());
        dto.setShopSeq(shopInfo.getSHOPSEQ());
        dto.setJobResult(jobResult);
        dto.setLogMessage(logMsg);
        return dto;
    }

    public static JobLogDTO createJobLogForProdIn(ProductDTO product2, String jobType, String jobResult, String logMsg) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        dto.setJobMain(parsed.get("jobMain"));
        dto.setJobSub(parsed.get("jobSub"));
        dto.setProdCd(product2.getCompayny_goods_cd());
        dto.setShopProdNo(product2.getShopprodno());
        dto.setShopCd(product2.getShopcd());
        dto.setShopUserId(product2.getSHOP_USERID());
        dto.setNickname(JobLogHelper.findNicknameByProduct(product2));
        dto.setShopSeq(Integer.parseInt(product2.getShopseq()));
        dto.setJobResult(jobResult);
        dto.setLogMessage(logMsg);
        return dto;
    }

    public static JobLogDTO createJobLogForProdInfo(ProductDTO product2, String jobType, String jobResult, String logMsg) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        dto.setJobMain(parsed.get("jobMain"));
        dto.setJobSub(parsed.get("jobSub"));
        dto.setProdCd(product2.getCompayny_goods_cd());
        dto.setJobResult(jobResult);
        dto.setLogMessage(logMsg);
        return dto;
    }

    public static JobLogDTO createJobLogForDome(ProductItemDto ProductItem, String jobResult) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(\uc610\ub9bc\ub3c4\ub9e4\ubab0\uc218\uc815);
        dto.setJobMain(\uc610\ub9bc);
        dto.setJobSub(\ub3c4\ub9e4\ubab0\uc218\uc815);
        dto.setProdCd(ProductItem != null ? ProductItem.getIcode() : "");
        dto.setJobResult(jobResult);
        dto.setLogMessage(ProductItem.getChange_list());
        return dto;
    }

    private static String processLogMessage(String jobResult, String logMessage) {
        if ("\uc2e4\ud328".equals(jobResult)) {
            String[] parts = logMessage.split("\u2192", 2);
            return parts.length > 1 ? parts[1].trim() : logMessage.trim();
        }
        return logMessage;
    }

    private static String findNicknameByProduct(ProductDTO dto) {
        List<List<String>> shopList = JobLogHelper.getAllShopIds();
        if (shopList == null || shopList.isEmpty() || dto == null) {
            return "";
        }
        return shopList.stream().filter(list -> dto.getShopcd().equals(list.get(1)) && dto.getSHOP_USERID().equals(list.get(3)) && dto.getShopseq().equals(list.get(2))).map(list -> (String)list.get(6)).findFirst().orElse("");
    }

    private static List<List<String>> getAllShopIds() {
        ShoppingmallDAO dao = new ShoppingmallDAO();
        try {
            return dao.getShopidAlllist();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static Map<String, String> parseJobType(String jobType) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (jobType == null || jobType.isEmpty()) {
            result.put("jobMain", "");
            result.put("jobSub", "");
            return result;
        }
        HashMap<String, String[]> overrideMap = new HashMap<String, String[]>();
        overrideMap.put(\uc610\ub9bc\ub3c4\ub9e4\ubab0\uc218\uc815, new String[]{\uc610\ub9bc, \ub3c4\ub9e4\ubab0\uc218\uc815});
        if (overrideMap.containsKey(jobType)) {
            String[] arr = (String[])overrideMap.get(jobType);
            result.put("jobMain", arr[0]);
            result.put("jobSub", arr[1]);
            return result;
        }
        String[] parts = jobType.split("_");
        if (parts.length == 2) {
            result.put("jobMain", parts[0]);
            result.put("jobSub", parts[1]);
        } else if (parts.length == 3) {
            result.put("jobMain", parts[0]);
            result.put("jobSub", String.valueOf(parts[1]) + "_" + parts[2]);
        } else {
            result.put("jobMain", "");
            result.put("jobSub", "");
        }
        return result;
    }
}

