/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.ui;

import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dao.ShoppingmallDAO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.factory.ProductProcessFactory;
import com.kdjsystem.mlink.yellim.helper.LoginHelper;
import com.kdjsystem.mlink.yellim.ui.CommandDialog;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.YellimFreeInfomationDialog;
import com.kdjsystem.mlink.yellim.util.ProductDiscontinueSelectUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class ProductDiscontinueSelectDialog
extends CommandDialog {
    public static String TITLE_MST = "\ud488\ub2e8\uc885 \ucc98\ub9ac";
    private ProductDiscontinueSelectUtil _util;
    private List<ProductDTO> _selectedProducts;
    private Button btn_soldOut;
    private Button btn_extinction;
    private Button btn_exit;
    private Tree tree;

    public ProductDiscontinueSelectDialog(Shell parentShell, List<ProductDTO> products) {
        super(parentShell);
        this.setShellStyle(32800);
        this._util = new ProductDiscontinueSelectUtil();
        this._selectedProducts = products;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 7, 0));
        Composite container = new Composite(parent, 2048);
        container.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 7, 0));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 2048);
        composite.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 7, 0));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(3, false));
        this.btn_soldOut = new Button(composite, 16);
        this.btn_soldOut.setText("\ud488\uc808");
        this.btn_extinction = new Button(composite, 16);
        this.btn_extinction.setText("\ub2e8\uc885");
        this.btn_exit = new Button(composite, 16);
        this.btn_exit.setText("\ud310\ub9e4\uc885\ub8cc");
        Composite composite_tree = new Composite(composite, 0);
        composite_tree.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 3, 1));
        composite_tree.setLayout((Layout)new GridLayout(1, false));
        this.tree = new Tree(composite_tree, 67618);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        this.tree.setHeaderForeground(SWTResourceManager.getColor(1));
        this.tree.setHeaderBackground(SWTResourceManager.getColor(68, 80, 94));
        this.tree.setForeground(SWTResourceManager.getColor(2));
        this.tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem item = (TreeItem)event.item;
                    ProductDiscontinueSelectDialog.this.tree_event(item);
                }
            }
        });
        TreeColumn column_shop = new TreeColumn(this.tree, 0x1000000);
        column_shop.setWidth(200);
        column_shop.setText("\uc1fc\ud551\ubab0");
        TreeColumn column_id = new TreeColumn(this.tree, 0x1000000);
        column_id.setWidth(150);
        column_id.setText("ID");
        TreeColumn column_nickName = new TreeColumn(this.tree, 0x1000000);
        column_nickName.setWidth(150);
        column_nickName.setText("\ub2c9\ub124\uc784");
        TreeColumn column_shopCode = new TreeColumn(this.tree, 0x1000000);
        column_shopCode.setWidth(0);
        TreeColumn column_shopSeq = new TreeColumn(this.tree, 0x1000000);
        column_shopSeq.setWidth(0);
        TreeColumn column_password = new TreeColumn(this.tree, 0x1000000);
        column_password.setWidth(0);
        TreeColumn column_apiKey = new TreeColumn(this.tree, 0x1000000);
        column_apiKey.setWidth(0);
        TreeColumn column_authKey1 = new TreeColumn(this.tree, 0x1000000);
        column_authKey1.setWidth(0);
        TreeColumn column_authKey2 = new TreeColumn(this.tree, 0x1000000);
        column_authKey2.setWidth(0);
        TreeColumn column_vendorID = new TreeColumn(this.tree, 0x1000000);
        column_vendorID.setWidth(0);
        TreeColumn column_suppstditem = new TreeColumn(this.tree, 0x1000000);
        column_suppstditem.setWidth(0);
        TreeColumn column_suppstdrati = new TreeColumn(this.tree, 0x1000000);
        column_suppstdrati.setWidth(0);
        TreeColumn column_editauthkey1 = new TreeColumn(this.tree, 0x1000000);
        column_editauthkey1.setWidth(0);
        TreeColumn column_editapikey = new TreeColumn(this.tree, 0x1000000);
        column_editapikey.setWidth(0);
        this.initDataBinding_tree();
        return container;
    }

    private void tree_event(TreeItem item) {
        boolean checked = item.getChecked();
        try {
            item.setGrayed(false);
            item.setChecked(checked);
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].setGrayed(false);
                items[i].setChecked(checked);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initDataBinding_tree() {
        try {
            List<ShoppingmallDTO> shopDetails = ShoppingmallDAO.get().selectTradingShoppingMallAllData();
            for (String shopCode : MallCode.getTradeShopList()) {
                List shopInfos = shopDetails.stream().filter(p -> p.getSHOPCD().equals(shopCode)).sorted(Comparator.comparing(ShoppingmallDTO::getSHOPPINGID)).collect(Collectors.toList());
                if (shopInfos == null || shopInfos.size() == 0) continue;
                TreeItem item = new TreeItem(this.tree, 0);
                item.setText(new String[]{((ShoppingmallDTO)shopInfos.get(0)).getSHOPNM(), "", "", "", "", "", "", "", "", "", "", "", "", ""});
                for (ShoppingmallDTO info : shopInfos) {
                    TreeItem subItem = new TreeItem(item, 0);
                    subItem.setText(new String[]{info.getSHOPNM(), info.getSHOPPINGID(), info.getNICKNM1(), info.getSHOPCD(), String.valueOf(info.getSHOPSEQ()), info.getPASSWORD(), info.getAPIKEY(), info.getAUTHKEY1(), info.getAUTHKEY2(), info.getVENDORID(), info.getSUPPSTDITEM(), info.getSUPPSTDRATI(), info.getEDITAUTHKEY1(), info.getEDITAPIKEY()});
                }
            }
            TreeItem[] treeItemArray = this.tree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                TreeItem[] treeItemArray2 = item.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem subItem = treeItemArray2[n4];
                    item.setExpanded(false);
                    subItem.setExpanded(false);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getProcessDivision() {
        if (this.btn_soldOut.getSelection() || this.btn_extinction.getSelection()) {
            return 4000;
        }
        if (this.btn_exit.getSelection()) {
            return 3000;
        }
        return -9999;
    }

    private String getProcessStatus() {
        if (this.btn_soldOut.getSelection()) {
            return "1";
        }
        if (this.btn_extinction.getSelection()) {
            return "2";
        }
        if (this.btn_exit.getSelection()) {
            return "3";
        }
        return "9999";
    }

    protected void okPressed() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date enduse = null;
        try {
            String yEnduseStr = YDMASessonUtil.getUserInfo().getY_enduse();
            String enduseStr = YDMASessonUtil.getUserInfo().getEnduse();
            if (yEnduseStr != null) {
                formatter.parse(yEnduseStr);
            }
            if (enduseStr != null) {
                enduse = formatter.parse(enduseStr);
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        Date today = new Date();
        YDMASessonUtil.getUserInfo().getY_pricetype();
        String pricetype = YDMASessonUtil.getUserInfo().getPricetype();
        if (enduse != null && pricetype != null && today.before(enduse) && this.isPriceType(pricetype)) {
            this.SoldOutProcess();
            super.okPressed();
        } else {
            this.YellimFreeInfomationDialog();
        }
    }

    public void SoldOutProcess() {
        int processCode = this.getProcessDivision();
        if (processCode == -9999) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE_MST, (String)"\ucc98\ub9ac\ud560 \uc218 \uc5c6\ub294 \uc791\uc5c5\ucf54\ub4dc\uc785\ub2c8\ub2e4.");
            return;
        }
        String processStatus = this.getProcessStatus();
        if (processStatus.equals("9999")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE_MST, (String)"\ucc98\ub9ac\ud560 \uc218 \uc5c6\ub294 \uc791\uc5c5\ucf54\ub4dc\uc785\ub2c8\ub2e4.");
            return;
        }
        ArrayList<TreeItem> selectedItem = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            selectedItem.addAll(Arrays.asList(item.getItems()).stream().filter(p -> p.getChecked()).collect(Collectors.toList()));
            ++n2;
        }
        CommonProgressDialog.get().start("[\ud488\ub2e8\uc885\uc0c1\ud488\uad00\ub9ac] \uc0c1\ud488\ubcc4 \ud488\ub2e8\uc885 \ucc98\ub9ac", 100, 100, true);
        try {
            List<ShoppingmallDTO> shopInfos = this._util.getSelectedShoppingMallInfos(selectedItem);
            for (ShoppingmallDTO info : shopInfos) {
                int mod;
                List<ProductDTO> saleProducts = this._util.getSaleProducts(info, this._selectedProducts);
                int count = 0;
                int procPage = 0;
                int allcount = saleProducts.size();
                int block = saleProducts.size() / 25;
                int totalpage = block + ((mod = saleProducts.size() % 25) > 0 ? 1 : 0);
                if (totalpage == 0) {
                    totalpage = 1;
                }
                String shopinfoStr = String.format("[%s - %s(%s)]", info.getSHOPNM(), info.getSHOPPINGID(), info.getNICKNM1());
                if (allcount <= 0) {
                    this.setValueBack(String.valueOf(shopinfoStr) + " \ud488\ub2e8\uc885 \ub300\uc0c1 \uc0c1\ud488\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.", 0);
                    this.setValue("--------------------------------------------------------------------------------------", 100);
                    continue;
                }
                this.setValueBack(String.valueOf(shopinfoStr) + " \uc804\uccb4 " + allcount + "\uac1c " + totalpage + "\ud398\uc774\uc9c0\uc758 \ud488\ub2e8\uc885 \ucc98\ub9ac\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", 0);
                for (ProductDTO product2 : saleProducts) {
                    String coment;
                    IProductModifyProcess process;
                    ResultProcessDTO result;
                    ++count;
                    ProductModifyProcessDTO processDTO = new ProductModifyProcessDTO();
                    processDTO.setPRODUCT(product2);
                    processDTO.setSHOPINFO(info);
                    processDTO.setPROCESS_STATUS(processCode);
                    String shopcd = info.getSHOPCD();
                    if (shopcd.equals("shop0004") || shopcd.equals("shop0106") || shopcd.equals("shop0055") || shopcd.equals("shop0067") || shopcd.equals("shop00671") || shopcd.equals("shop0068") || shopcd.equals("shop00681") || shopcd.equals("shop0003") || shopcd.equals("shop00031") || shopcd.equals("shop0076") || shopcd.equals("shop0110") || shopcd.equals("shop0075")) {
                        processDTO.setCOOKIES(LoginHelper.loginCookie(info));
                    }
                    if ((result = (process = ProductProcessFactory.get().getProductModifyObject(shopcd)).modifyProcess(processDTO)).getRESULT_CODE() == 0) {
                        String.format(" [%s] %s\n \u2192 \uc1fc\ud551\ubab0 \ud488\ub2e8\uc885 \uc791\uc5c5\uc774 \ubaa8\ub450 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", product2.getCompayny_goods_cd(), product2.getGoods_nm());
                        if (shopcd.equals("shop0004") || shopcd.equals("shop0076") || shopcd.equals("shop0287") || shopcd.equals("shop0372") || shopcd.equals("shop0273")) {
                            if (ProductDAO.get().updateProductInStatus(Arrays.asList(product2.getSENDSEQ()), processStatus, processCode) == 1) {
                                ProductDAO.get().updateOptProductInSoldout(Arrays.asList(product2.getSENDSEQ()));
                                coment = String.format(" %s [%s] %s\n \u2192 \ud488\ub2e8\uc885 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopinfoStr, product2.getCompayny_goods_cd(), product2.getGoods_nm());
                                this.setValueBackAndLogForProdIn(coment, 50, product2, info, "YEL_MODI", "\uc131\uacf5", "[\uc610\ub9bc \ud488\ub2e8\uc885\uc0c1\ud488] \ud488\ub2e8\uc885 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                            }
                        } else if ((shopcd.equals("shop0003") || shopcd.equals("shop00031") || shopcd.equals("shop0055") || shopcd.equals("shop00671") || shopcd.equals("shop00681") || shopcd.equals("shop0075") || shopcd.equals("shop9984") || shopcd.equals("shop0106") || shopcd.equals("shop9982") || shopcd.equals("shop0110")) && ProductDAO.get().deleteProductIn(Arrays.asList(product2.getSENDSEQ())) == 1) {
                            ProductDAO.get().deleteOptProductIn(Arrays.asList(product2.getSENDSEQ()));
                            coment = String.format(" %s [%s] %s\n \u2192 \uc815\uc0c1 \uc0ad\uc81c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopinfoStr, product2.getCompayny_goods_cd(), product2.getGoods_nm());
                            this.setValueBackAndLogForProdIn(coment, 50, product2, info, "YEL_DEL", "\uc131\uacf5", "[\uc610\ub9bc \ud488\ub2e8\uc885\uc0c1\ud488] \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                        }
                    } else {
                        coment = String.format(" %s [%s] %s\n \u2192 \ud488\ub2e8\uc885 \uc791\uc5c5\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.", shopinfoStr, product2.getCompayny_goods_cd(), product2.getGoods_nm());
                        this.setValueBackAndLogForProdIn(coment, 50, product2, info, "YEL_DEL", "\uc2e4\ud328", "\uc1fc\ud551\ubab0 \uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    }
                    if (shopcd.equals("shop0067") || shopcd.equals("shop0068") || shopcd.equals("shop00681")) {
                        InterruptSource.Thread.sleep((long)2000L);
                    }
                    if (count != allcount && count % 25 != 0) continue;
                    CommonProgressDialog.get().setValueBack(String.valueOf(shopinfoStr) + " \uc804\uccb4 \ud398\uc774\uc9c0 " + totalpage + "\ud398\uc774\uc9c0 \uc911 " + String.valueOf(++procPage) + "\ud398\uc774\uc9c0 \uc0c1\ud488\uc774 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 0);
                    InterruptSource.Thread.sleep((long)2000L);
                }
                this.setValue(String.valueOf(shopinfoStr) + " \ud488\ub2e8\uc885 \uc885\ub8cc", 100);
                this.setValue("--------------------------------------------------------------------------------------", 100);
            }
            this.setValue("5\ucd08 \ud6c4 \ucc3d\uc774 \uc790\ub3d9\uc73c\ub85c \ub2eb\ud799\ub2c8\ub2e4.", 100);
            InterruptSource.Thread.sleep((long)5000L);
            CommonProgressDialog.get().end();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CommonProgressDialog.get().dispose();
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "\ud655\uc778", false);
        this.createButton(parent, 1, "\ucde8\uc18c", false);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(TITLE_MST);
        super.configureShell(newShell);
    }

    private boolean isPriceType(String priceType) {
        return priceType.equals("1") || priceType.equals("2") || priceType.equals("3") || priceType.equals("4") || priceType.equals("5") || priceType.equals("6");
    }

    private boolean isYPriceType(String priceType) {
        return priceType.equals("1") || priceType.equals("2") || priceType.equals("3");
    }

    protected void YellimFreeInfomationDialog() {
        YellimFreeInfomationDialog d = new YellimFreeInfomationDialog(this.getShell());
        d.open();
    }

    private void setValueBack(String message, int value) {
        CommonProgressDialog.get().setValueBack(message, value);
    }

    private void setValue(String message, int value) {
        CommonProgressDialog.get().setValue(message, value);
    }

    private void setValueBackAndLogForProdIn(String title, int value, ProductDTO item, ShoppingmallDTO shopInfo, String jobType, String jobResult, String logMsg) {
        CommonProgressDialog.get().setValueBackAndLogForProdIn(title, value, item, shopInfo, jobType, jobResult, logMsg);
    }

    private void setValueBackAndLogForProdInfo(String title, int value, ProductDTO item, String jobType, String jobResult, String logMsg) {
        CommonProgressDialog.get().setValueBackAndLogForProdInfo(title, value, item, jobType, jobResult, logMsg);
    }
}

