/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.FtpUtil;
import com.kdjsystem.mlink.yellim.common.YDMAProperties;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.data.dao.ShopAddProdInfoDto;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.protocol.InterParkProduct;
import com.kdjsystem.mlink.yellim.protocol.InterParkProductDetailDto;
import com.kdjsystem.mlink.yellim.protocol.InterParkProductOption;
import com.kdjsystem.mlink.yellim.protocol.InterParkProductOptionList;
import com.kdjsystem.mlink.yellim.protocol.InterParkUpdateOptionRequest;
import com.kdjsystem.mlink.yellim.shop.common.IProduct;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCatInfDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopInterParkAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InterParkProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    private Map<String, ShopCatInfDto> mapShopcateInfo = new HashMap<String, ShopCatInfDto>();

    private synchronized void setProductStop(String venderItemID, ShoppingmallDTO shoppingMallDetailDto, ProductDTO dto, ShopProductAdditionDto dtllist) throws Exception {
        String remoteDir = "";
        String templatefilename = "";
        try {
            try {
                ProductInterParkReg productInterParkReg = new ProductInterParkReg();
                productInterParkReg.item.prdNo = dto.getShopprodno();
                productInterParkReg.item.prdNm = dto.getGoods_nm();
                if (venderItemID.equals("8")) {
                    productInterParkReg.item.saleStatTp = "02";
                } else if (!venderItemID.equals("6")) {
                    if (venderItemID.equals("7")) {
                        productInterParkReg.item.saleStatTp = "98";
                    } else {
                        productInterParkReg.item.saleStatTp = "01";
                    }
                }
                Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_price());
                int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
                ResultMarketPrice resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                productInterParkReg.item.saleUnitcost = resultMarketPrice.getConsumer_if_sale_price();
                templatefilename = this.upLoadFTP(productInterParkReg);
                List<String> result = this.getCode(shoppingMallDetailDto, templatefilename);
                if (!InterParkProductModifyService.isNumeric(result.get(0))) {
                    dto.setResult_code("-1");
                    throw new Exception(result.get(2));
                }
            }
            catch (Exception e) {
                throw new Exception("FTP\uc5c5\ub85c\ub4dc \ubc0f \uc0ad\uc81c\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
            }
        }
        finally {
            remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
            FtpUtil.deletefile(remoteDir, templatefilename);
            File deleteFile = new File(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\03.SabangNet\\template\\" + templatefilename);
            if (deleteFile.exists()) {
                deleteFile.delete();
            }
        }
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private List<String> getCode(ShoppingmallDTO shoppingMallDetailDto, String templatefilename) throws MalformedURLException, IOException, UnsupportedEncodingException, ParserConfigurationException, SAXException {
        StringBuffer response = new StringBuffer();
        String xmlfile = "";
        xmlfile = "http://itsm.kdjsystem.com/xmldir/" + templatefilename;
        String url = String.format("http://ipss1.interpark.com/openapi/product/ProductAPIService.do?_method=UpdateProductAPIData&citeKey=%s&secretKey=%s&dataUrl=%s", shoppingMallDetailDto.getEDITAUTHKEY1(), shoppingMallDetailDto.getEDITAPIKEY(), xmlfile);
        URL obj = new URL(url);
        HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
        int responseCode = httpConnection.getResponseCode();
        if (responseCode == 200) {
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
            String inputLine = null;
            while ((inputLine = buffReader.readLine()) != null) {
                response.append(inputLine);
            }
            buffReader.close();
        }
        ArrayList<String> callback = new ArrayList<String>();
        httpConnection.disconnect();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        ByteArrayInputStream bis = new ByteArrayInputStream(response.toString().getBytes());
        Document doc = db.parse(bis);
        Node n = doc.getFirstChild();
        NodeList nl = n.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node an = nl.item(i);
            if (an.getNodeType() == 1) {
                NodeList nl2 = an.getChildNodes();
                int i2 = 0;
                while (i2 < nl2.getLength()) {
                    Node an2 = nl2.item(i2);
                    if (an2.hasChildNodes()) {
                        callback.add(an2.getTextContent());
                    }
                    YDMAStringUtil.Print(an2.getNodeValue());
                    ++i2;
                }
            }
            ++i;
        }
        return callback;
    }

    private String upLoadFTP(ProductInterParkReg productInterParkReg) throws ParserConfigurationException, SAXException, IOException, JAXBException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException, Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(productInterParkReg.getXml())));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "euc-kr");
        transformer.setOutputProperty("indent", "yes");
        DOMSource DOMsource = new DOMSource(doc);
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        int anum = random.nextInt();
        String localfile = String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\03.SabangNet\\template\\EditProductInterPark" + YDMASessonUtil.getCompnoInfo().getCompno() + YDMASessonUtil.getUserInfo().getUserId() + Integer.toString(anum) + ".xml";
        StreamResult result = new StreamResult(new File(localfile));
        transformer.transform(DOMsource, result);
        String remoteDir = "";
        remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
        String templatefilename = FtpUtil.upload(remoteDir, localfile);
        return templatefilename;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    private String getProductBasic(ShopInterParkAdditionalDto dtllist, ProductDTO dto, ProductInterParkReg productInterParkReg) throws Exception {
        String categoryNum = "";
        try {
            productInterParkReg.item.prdStat = dtllist.getProdstatus();
            if (dtllist.getProdstatus().equals("02")) {
                productInterParkReg.item.oldUseMonth = dtllist.getUsedmonths();
            }
            productInterParkReg.item.prdModelNo = dto.getCompayny_goods_cd();
            productInterParkReg.item.brandNo = "";
            productInterParkReg.item.brandNm = dto.getBrand_nm();
            if (dtllist.getIsCategory().equals("1")) {
                categoryNum = dtllist.getShopcatno();
                productInterParkReg.item.omDispNo = categoryNum;
            } else {
                YDMAStringUtil.Print("\uce74\ud14c\uace0\ub9ac \ud655\uc778 1 : " + dto.getShopCid());
                if (dto.getShopCid().equals("") || dto.getShopCid().equals(null)) {
                    throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uce74\ud14c\uace0\ub9ac\uac00 \uc9c0\uc815\ub418\uc9c0 \uc54a\uc558\uac70\ub098 \ud574\ub2f9 \uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                }
                categoryNum = dto.getShopCid();
                productInterParkReg.item.omDispNo = categoryNum;
            }
            String value = "";
            switch (dtllist.getProdoutput()) {
                case "0": {
                    value = dto.getGoods_nm();
                    break;
                }
                case "1": {
                    value = dto.getModel_nm();
                    break;
                }
                case "2": {
                    value = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "3": {
                    value = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "4": {
                    value = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "5": {
                    value = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    value = dto.getGoods_nm();
                }
            }
            if (!dtllist.getProdnmfirst().equals("")) {
                value = dtllist.getProdnmfirst().concat(value);
            }
            if (!dtllist.getProdnmlast().equals("")) {
                value = value.concat(" ").concat(dtllist.getProdnmlast());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 99);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            if (dtllist.getProhibitedlan().equals("1")) {
                value = value.replaceAll("<|>|`|'|\"|^|\\|\uff03|\uff06|\uff20|\u00a7|\u203b|\u2606|\u2605|\u25cb|\u25cf|\u25ce|\u25c7|\u25c6|\u25a1|\u25a0|\u25b3|\u0394|\u25b2|\u25bd|\u25bc|\u25c1|\u25c0|\u25b7|\u25b6|\u2664|\u2660|\u2661|\u2665|\u2667|\u2663|\u2299|\u25c8|\u25a3|\u25d0|\u25d1|\u03b1|\u039b|\u03b8|\u03a9|\u03b2", "");
            }
            String sellerProductName = dto.getProdnmlenyn().equals("Y") ? YDMAStringUtil.setTextStrtok(value, 99) : value;
            productInterParkReg.item.prdNm = sellerProductName;
            productInterParkReg.item.hdelvMafcEntrNm = dto.getMaker();
            productInterParkReg.item.prdOriginTp = dto.getOrigin();
            if (dtllist.getTaxsmall().equals("N")) {
                if (YDMASessonUtil.getLoginType() == 2) {
                    productInterParkReg.item.taxTp = dto.getTax_yn().equals("0") ? "01" : "02";
                } else {
                    productInterParkReg.item.taxTp = dto.getTax_yn().equals("1") ? "01" : "02";
                }
            } else {
                productInterParkReg.item.taxTp = "03";
            }
            if (dtllist.getTypeaddi().equals("Y")) {
                productInterParkReg.item.ordAgeRstrYn = dto.getAdult().equals("0") ? "N" : "Y";
            } else {
                productInterParkReg.item.ordAgeRstrYn = dtllist.getMinorselcnyn().equals("02") ? "Y" : "N";
            }
            productInterParkReg.item.saleStatTp = "01";
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc0c1\ud48d\uba85, \uc0c1\ud488\uc0c1\ud0dc, \uacfc\uc138, \uc131\uc778\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return categoryNum;
    }

    private void getSalePeriod(ShopInterParkAdditionalDto dtllist, ProductInterParkReg productInterParkReg, ProductDTO dto) throws Exception {
        block14: {
            try {
                if (dtllist.getSaleperiodyn().equals("02")) {
                    if (dtllist.getSaleperiodset().equals("999")) {
                        productInterParkReg.item.saleStrDts = dtllist.getSaleperiodsrt().replaceAll("[^0-9]", "");
                        productInterParkReg.item.saleEndDts = dtllist.getSaleperiodend().replaceAll("[^0-9]", "");
                    } else {
                        productInterParkReg.item.saleStrDts = YDMATimeUtil.getCurrentDateHanjin();
                        productInterParkReg.item.saleEndDts = this.setDefaultDate(dtllist.getSaleperiodset());
                    }
                } else {
                    productInterParkReg.item.saleStrDts = YDMATimeUtil.getCurrentDateHanjin();
                    productInterParkReg.item.saleEndDts = "99991231";
                }
                if (dtllist.getSelmthdcd().equals("02")) {
                    if (dtllist.getPresaledate1().equals("999")) {
                        productInterParkReg.item.prdReleaseDt = dtllist.getPresaledate2().replaceAll("[^0-9]", "");
                    } else {
                        productInterParkReg.item.prdReleaseDt = this.setDefaultDate(dtllist.getSaleperiodset());
                    }
                }
                try {
                    if (dtllist.getSaleperiodyn().equals("02")) {
                        if (dtllist.getSaleperiodset().equals("999")) {
                            dto.setSaleenddt(dtllist.getSaleperiodend());
                        } else {
                            String saleEnddt = YDMATimeUtil.getSaleEndDt(dtllist.getSaleperiodend());
                            dto.setSaleenddt(saleEnddt);
                        }
                        break block14;
                    }
                    dto.setSaleenddt("2999-12-31");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception exception) {
                throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud310\ub9e4\uae30\uac04 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
        }
    }

    private void getDelivery(ShopInterParkAdditionalDto dtllist, ProductInterParkReg productInterParkReg, ProductDTO dto) throws Exception {
        try {
            productInterParkReg.item.delvMthd = dtllist.getDelvmethod();
            if (dtllist.getDelvtype().equals("0")) {
                productInterParkReg.item.proddelvCostUseYn = "Y";
                productInterParkReg.item.delvCostApplyTp = dto.getDelv_type().equals("3") ? "03" : "02";
                productInterParkReg.item.delvAmtPayTpCom = dto.getDelv_type().equals("2") ? "01" : "02";
                if (dto.getDelv_type().equals("2")) {
                    productInterParkReg.item.delvAmtPayTpCom = "01";
                }
                productInterParkReg.item.delvCost = dto.getDelv_cost();
                if (dto.getDelv_type().equals("3")) {
                    productInterParkReg.item.stdQty = dto.getDelivery_qty();
                }
                productInterParkReg.item.freedelvStdCnt = "0";
                String delvtype = dto.getDelv_type().equals("0") ? "\uae30\ubcf8\ubc30\uc1a1" : (dto.getDelv_type().equals("1") ? "\ubb34\ub8cc\ubc30\uc1a1" : (dto.getDelv_type().equals("2") ? "\ucc29\ubd88\ubc30\uc1a1" : "\uc218\ub7c9\ubcc4 \ubc30\uc1a1"));
                long delvcost = delvtype.equals("\ubb34\ub8cc\ubc30\uc1a1") ? 0 : Integer.parseInt(dto.getDelv_cost());
                dto.setPack_code_str(delvtype.concat("=").concat(String.valueOf(delvcost)));
            } else {
                productInterParkReg.item.proddelvCostUseYn = dtllist.getDelvtype().equals("1") ? "N" : "Y";
                if (dtllist.getDelvtype().equals("1")) {
                    productInterParkReg.item.delvPlcNo = dtllist.getDelvbundlecd();
                    dto.setPack_code_str("\ubc30\uc1a1\ud15c\ud50c\ub9bf(" + dtllist.getDelvbundlecd() + ")".concat("=").concat(String.valueOf("0")));
                } else if (dtllist.getDelvtype().equals("2")) {
                    if (dtllist.getDelvcosttype().equals("01")) {
                        productInterParkReg.item.delvAmtPayTpCom = "02";
                        productInterParkReg.item.freedelvStdCnt = "0";
                    } else {
                        productInterParkReg.item.delvAmtPayTpCom = dtllist.getDelvprepayyn();
                    }
                    String deliveryCost = "";
                    if (dtllist.getDelvcost().equals("9999")) {
                        if (!dto.getDelv_cost().equals("0")) {
                            deliveryCost = dto.getDelv_cost();
                        } else {
                            PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                            deliveryCost = String.valueOf(systemconf.getDELIVERYCOST());
                            dto.setDelv_cost(deliveryCost);
                        }
                    } else {
                        deliveryCost = dtllist.getDelvcost();
                        dto.setDelv_cost(deliveryCost);
                    }
                    productInterParkReg.item.delvCost = dtllist.getDelvcost().equals("") ? "0" : deliveryCost;
                    productInterParkReg.item.delvCostApplyTp = dtllist.getDelvcosttype().equals("05") ? "03" : (dtllist.getDelvcosttype().equals("02") ? "02" : (dtllist.getDelvcosttype().equals("04") ? "01" : "01"));
                    if (dtllist.getDelvcosttype().equals("05")) {
                        productInterParkReg.item.freedelvStdCnt = "0";
                        productInterParkReg.item.stdQty = dtllist.getDelvcost1();
                    } else if (dtllist.getDelvcosttype().equals("03") || dtllist.getDelvcosttype().equals("04")) {
                        productInterParkReg.item.freedelvStdCnt = dtllist.getDelvcost1();
                    } else if (dtllist.getDelvcosttype().equals("02")) {
                        productInterParkReg.item.freedelvStdCnt = "0";
                    }
                    String delvtype = dtllist.getDelvcosttype().equals("01") ? "\ubb34\ub8cc\ubc30\uc1a1" : (dtllist.getDelvcosttype().equals("02") ? "\uc720\ub8cc\ubc30\uc1a1" : (dtllist.getDelvcosttype().equals("03") ? "\uc218\ub7c9\ubcc4 \ubc30\uc1a1" : (dtllist.getDelvcosttype().equals("04") ? "\uac1c\ub2f9 \ubc30\uc1a1" : "\uc218\ub7c9\ubcc4 \ubc30\uc1a1")));
                    long delvcost = delvtype.equals("\ubb34\ub8cc\ubc30\uc1a1") ? 0 : Integer.parseInt(dtllist.getDelvcost());
                    dto.setPack_code_str(delvtype.concat("=").concat(String.valueOf(delvcost)));
                }
                productInterParkReg.item.jejuetcDelvCostUseYn = dtllist.getDelvaddcostyn();
                if (dtllist.getDelvaddcostyn().equals("Y")) {
                    productInterParkReg.item.jejuDelvCost = dtllist.getDelvjejucost();
                    productInterParkReg.item.etcDelvCost = dtllist.getDelvislandcost();
                }
            }
            productInterParkReg.item.prdrtnCostUseYn = dtllist.getDelvretexcyn().equals("1") ? "Y" : "N";
            if (dtllist.getDelvretexcyn().equals("1")) {
                String returnDeliveryCost = "";
                if (dtllist.getDelvretexccost().equals("9999")) {
                    if (!dto.getDelv_r_cost().equals("0")) {
                        returnDeliveryCost = dto.getDelv_r_cost();
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        returnDeliveryCost = String.valueOf(systemconf.getDELIVERYCOST());
                        dto.setDelv_r_cost(returnDeliveryCost);
                    }
                } else {
                    returnDeliveryCost = dtllist.getDelvretexccost();
                    dto.setDelv_r_cost(returnDeliveryCost);
                }
                productInterParkReg.item.rtndelvCost = returnDeliveryCost;
            }
            productInterParkReg.item.rtndelvNo = dtllist.getReturncd();
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ubc30\uc1a1\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getItems(ShopInterParkAdditionalDto dtllist, ProductDTO dto, ProductInterParkReg productInterParkReg, ResultMarketPrice resultMarketPrice, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        String remark = "";
        String addDetailPlus = "";
        List<Object> strImages = new ArrayList();
        try {
            remark = dtllist.getRemarkoutput().equals("0") ? dtllist.getRemarkfirst().concat(dto.getGoods_remarks()).concat(dtllist.getRemarklast()) : dto.getGoods_remarks();
            if (dtllist.getRemarktop().equals("Y")) {
                remark = "<h2 style='font-size:16px;font-weight: bold;font-family: Dotum;text-align: center;'>\uc0c1\ud488\uba85 : " + dto.getGoods_nm() + "</h2>".concat(remark);
            }
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = String.valueOf(dtllist.getDetailKeywordL()) + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            productInterParkReg.item.prdBasisExplanEd = String.valueOf(addDetailPlus) + remark;
            strImages = dtllist.getChangesize().equals("Y") ? this.getProductImages(dto, dtllist.getChangeSizeX(), dtllist.getChangeSizeY(), dtllist.getChangeSizeW(), dtllist.getChangeSizeH()) : this.getProductImages(dto);
            if (dtllist.getImgThreeOnFour().equals("Y")) {
                strImages = this.setImgRatioChange(dto, strImages, shoppingMallDetailDto);
            }
            productInterParkReg.item.zoomImg = (String)strImages.get(0);
            productInterParkReg.item.prdPostfix = "";
            String main = "";
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> removetag = new ArrayList<String>();
            List<String> search = new ArrayList<String>();
            if (dto.getExcepkeywdyn().equals("Y")) {
                removetag.addAll(Arrays.asList(dto.getExcepkeywd().split(",")));
                list.addAll(Arrays.asList(dto.getGoods_search().split(",")));
                search = IProduct.checkSearch(list, removetag, search);
            } else {
                search.addAll(Arrays.asList(dto.getGoods_search().split(",")));
            }
            if (search.size() > 4) {
                int i = 0;
                while (i < 4) {
                    main = String.valueOf(main) + search.get(i);
                    if (i != 3) {
                        main = String.valueOf(main) + ",";
                    }
                    ++i;
                }
                productInterParkReg.item.prdKeywd = main;
            } else {
                productInterParkReg.item.prdKeywd = search.stream().collect(Collectors.joining(","));
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc0c1\uc138\uc124\uba85, \uac80\uc0c9\uc5b4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dtllist.getIpointcost().equals("0")) {
                if (dtllist.getIpointtype().equals("0")) {
                    double point = (double)Integer.parseInt(dtllist.getIpointcost()) / 100.0;
                    int price2 = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                    int total = (int)((double)price2 * point);
                    productInterParkReg.item.entrPoint = String.valueOf(total);
                } else {
                    productInterParkReg.item.entrPoint = dtllist.getIpointcost();
                }
            }
            if (dtllist.getSellimittypcd().equals("Y")) {
                productInterParkReg.item.perordRstrQty = dtllist.getSellimittypcnt();
            }
        }
        catch (Exception exception) {
            throw new Exception("\ud3ec\uc778\ud2b8, \uc8fc\ubb34\uc81c\ud55c\uc218\ub7c9 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void shopNotification(String categoryNum, ProductInterParkReg productInterParkReg, ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookie, ShopInterParkAdditionalDto dtllist) throws Exception {
        try {
            Connection.Response rs = Jsoup.connect((String)("https://seller.interpark.com/api/redis/info-noti-map?dispNo=" + categoryNum)).cookies(cookie).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36").referrer("https://seller.interpark.com/views/products/regist").ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).method(Connection.Method.GET).execute();
            String body = rs.body();
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonparser.parse(body);
            JsonObject dataObject = jsonObject.getAsJsonObject("data");
            String attrcd = dataObject.get("infoGroupNo").getAsString();
            attrcd = "0" + attrcd;
            dto.setProp1_cd(attrcd);
            String prop = dto.getProp1_cd();
            if (dto.getProp1_cd().equals("039")) {
                dto.setProp1_cd("041");
            } else if (dto.getProp1_cd().equals("040")) {
                dto.setProp1_cd("042");
            }
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            for (ShopProdAttrnmDto prodattrnm : dto.getShopProdAttrnmDtos()) {
                if (prodattrnm.getInterapicode().equals("")) continue;
                List<String> OptionNames = Arrays.asList(prodattrnm.getInterapicode().split(","));
                for (String code : OptionNames) {
                    if (dtllist.getNoticebatchyn().equals("Y")) {
                        if (dtllist.getNoticetitleyn().equals("Y")) {
                            code = code.trim().replaceAll("\r\n", "");
                            productInterParkReg.item.prdinfoNoti.setItems(code, prodattrnm.getInterapitype(), String.valueOf(prodattrnm.getAttrnm()) + " : \uc0c1\uc138\ud398\uc774\uc9c0 \ucc38\uc870");
                            continue;
                        }
                        code = code.trim().replaceAll("\r\n", "");
                        productInterParkReg.item.prdinfoNoti.setItems(code, prodattrnm.getInterapitype(), "\uc0c1\uc138\ud398\uc774\uc9c0 \ucc38\uc870");
                        continue;
                    }
                    String attval = prodattrnm.getProp_val();
                    if (attval.equals("") || attval.equals(", ")) {
                        if (dtllist.getNoticetitleyn().equals("Y")) {
                            code = code.trim().replaceAll("\r\n", "");
                            productInterParkReg.item.prdinfoNoti.setItems(code, prodattrnm.getInterapitype(), String.valueOf(prodattrnm.getAttrnm()) + " : \uc0c1\uc138\ud398\uc774\uc9c0 \ucc38\uc870");
                            continue;
                        }
                        code = code.trim().replaceAll("\r\n", "");
                        productInterParkReg.item.prdinfoNoti.setItems(code, prodattrnm.getInterapitype(), "\uc0c1\uc138\ud398\uc774\uc9c0 \ucc38\uc870");
                        continue;
                    }
                    if (dtllist.getNoticetitleyn().equals("Y")) {
                        code = code.trim().replaceAll("\r\n", "");
                        productInterParkReg.item.prdinfoNoti.setItems(code, prodattrnm.getInterapitype(), String.valueOf(prodattrnm.getAttrnm()) + " : " + attval);
                        continue;
                    }
                    code = code.trim().replaceAll("\r\n", "");
                    productInterParkReg.item.prdinfoNoti.setItems(code, prodattrnm.getInterapitype(), attval);
                }
            }
            dto.setProp1_cd(prop);
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uace0\uc2dc\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getOption(ShopInterParkAdditionalDto dtllist, ProductDTO dto, ProductInterParkReg productInterParkReg, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
            if (!dto.getChar_1_nm().equals("\ub2e8\ud488")) {
                StringBuffer type1 = new StringBuffer();
                StringBuffer type2 = new StringBuffer();
                if (shopOptionDtos.size() > 0) {
                    Map<String, List<ShopOptionDto>> mapList = shopOptionDtos.stream().collect(Collectors.groupingBy(ShopOptionDto::getName));
                    productInterParkReg.item.selOptName = String.format("%s%s", dto.getChar_1_nm(), dto.getChar_2_nm().equals("") ? "" : "," + dto.getChar_2_nm());
                    for (String optname : mapList.keySet()) {
                        String addOptionLeftNm = "";
                        String addOptionRightNm = "";
                        List<ShopOptionDto> list = mapList.get(optname);
                        ArrayList<String> name = new ArrayList<String>();
                        ArrayList<String> cnt = new ArrayList<String>();
                        ArrayList<String> addprice = new ArrayList<String>();
                        ArrayList<String> optcd = new ArrayList<String>();
                        ArrayList<String> flag = new ArrayList<String>();
                        for (ShopOptionDto optDto : list) {
                            int amt = YDMAStringUtil.convertToInt(optDto.getAmt());
                            Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
                            int deliveryFee = 0;
                            if (dtllist.getDelvcosttype().equals("01") && dtllist.getFreedelivery().equals("T")) {
                                if (dtllist.getExpprc() == 9999) {
                                    if (!dto.getDelv_cost().equals("0")) {
                                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                                    } else {
                                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                                        deliveryFee = systemconf.getDELIVERYCOST();
                                    }
                                } else {
                                    deliveryFee = dtllist.getExpprc();
                                }
                                salePrice = salePrice + (long)deliveryFee;
                            }
                            salePrice = salePrice + YDMAStringUtil.convertToLong(optDto.getAmt());
                            int limit_price = YDMAStringUtil.convertToInt(optDto.getLimit_price());
                            ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                            if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                                optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                            }
                            amt = Integer.parseInt(optionprice.getConsumer_if_sale_price()) - Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                            if (dto.getChar_2_nm().equals("")) {
                                if (dtllist.getAddoptionlb().equals("Y")) {
                                    addOptionLeftNm = dtllist.getAddOptionL();
                                }
                                if (dtllist.getAddoptionrb().equals("Y")) {
                                    addOptionRightNm = dtllist.getAddOptionR();
                                }
                                optname.replaceAll(" ", "");
                                type1.append("{" + addOptionLeftNm + dto.getChar_1_nm().replaceAll(" ", "") + "-" + optDto.getOptspecdes().replaceAll(" ", "") + addOptionRightNm + "\uc218\ub7c9<" + optDto.getCnt() + ">\ucd94\uac00\uae08\uc561<" + amt + ">\uc635\uc158\ucf54\ub4dc<" + optDto.getOptcompanycd() + ">\uc0ac\uc6a9\uc5ec\ubd80<Y>}");
                                continue;
                            }
                            if (dtllist.getAddoptionlb().equals("Y")) {
                                addOptionLeftNm = dtllist.getAddOptionL();
                            }
                            if (dtllist.getAddoptionrb().equals("Y")) {
                                addOptionRightNm = dtllist.getAddOptionR();
                            }
                            name.add(String.valueOf(optDto.getOptspecdes().split(":")[1].replaceAll(" ", "")) + addOptionRightNm);
                            cnt.add(optDto.getCnt());
                            addprice.add(String.valueOf(amt));
                            optcd.add(optDto.getOptcompanycd());
                            flag.add("Y");
                        }
                        type2.append("{" + addOptionLeftNm + optname.replaceAll(" ", "") + "<" + name.stream().collect(Collectors.joining(",")) + ">\uc218\ub7c9<" + cnt.stream().collect(Collectors.joining(",")) + ">" + "\ucd94\uac00\uae08\uc561<" + addprice.stream().collect(Collectors.joining(",")) + ">\uc635\uc158\ucf54\ub4dc<" + optcd.stream().collect(Collectors.joining(",")) + ">\uc0ac\uc6a9\uc5ec\ubd80<" + flag.stream().collect(Collectors.joining(",")) + ">}");
                    }
                    if (!type1.toString().equals("")) {
                        productInterParkReg.item.prdOption = type1.toString();
                    } else {
                        productInterParkReg.item.prdOption = type2.toString();
                    }
                }
                productInterParkReg.item.optPrirTp = dtllist.getOptsortyn().equals("") ? "01" : (dtllist.getOptsortyn().equals("00") ? "01" : dtllist.getOptsortyn());
            }
            List<Object> prodNms = new ArrayList<String>();
            ArrayList<String> prodVals = new ArrayList<String>();
            ArrayList<String> prodCnts = new ArrayList<String>();
            ArrayList<String> prodAmts = new ArrayList<String>();
            ArrayList<String> prodCodes = new ArrayList<String>();
            List<ShopAddProdInfoDto> addProdList = ShopProductDao.get().getAddProdInfo(dto.getPRODSEQ());
            if (addProdList.size() > 0) {
                for (ShopAddProdInfoDto addProd : addProdList) {
                    prodNms.add(addProd.getProd_val1());
                    prodVals.add(addProd.getProd_val2().equals("") ? addProd.getProd_val1().concat(":").concat("\ub2e8\ud488") : addProd.getProd_val1().concat(":").concat(addProd.getProd_val2()));
                    prodCnts.add(addProd.getProd_cnt() == 0 ? addProd.getProd_val1().concat(":").concat("0") : addProd.getProd_val1().concat(":").concat(Integer.toString(addProd.getProd_cnt())));
                    prodAmts.add(addProd.getProd_amt() == 0 ? addProd.getProd_val1().concat(":").concat("0") : addProd.getProd_val1().concat(":").concat(Integer.toString(addProd.getProd_amt())));
                    prodCodes.add(addProd.getProd_val1().concat(":").concat(addProd.getUser_code()));
                }
                StringBuilder stringBuilder = new StringBuilder();
                prodNms = prodNms.stream().distinct().collect(Collectors.toList());
                for (String string : prodNms) {
                    stringBuilder.append("{");
                    stringBuilder.append(string.concat("<"));
                    stringBuilder.append(prodVals.stream().filter(p -> p.contains(prodNm)).map(p -> p.replace(prodNm.concat(":"), "")).distinct().collect(Collectors.joining(",")).concat(">"));
                    stringBuilder.append("\uc218\ub7c9<");
                    stringBuilder.append(prodCnts.stream().filter(p -> p.contains(prodNm)).map(p -> p.replace(prodNm.concat(":"), "")).collect(Collectors.joining(",")).concat(">"));
                    stringBuilder.append("\uae08\uc561<");
                    stringBuilder.append(prodAmts.stream().filter(p -> p.contains(prodNm)).map(p -> p.replace(prodNm.concat(":"), "")).collect(Collectors.joining(",")).concat(">"));
                    stringBuilder.append("\uc635\uc158\ucf54\ub4dc<");
                    stringBuilder.append(prodCodes.stream().filter(p -> p.contains(prodNm)).map(p -> p.replace(prodNm.concat(":"), "")).collect(Collectors.joining(",")).concat(">"));
                    stringBuilder.append("}");
                }
                productInterParkReg.item.addOption = stringBuilder.toString();
            }
            productInterParkReg.item.smOptYn = "N";
            if ("N".equals("Y")) {
                productInterParkReg.item.smOptTeplTp = "";
                productInterParkReg.item.smOptInfo = "";
                productInterParkReg.item.smOptExplanTop = "";
                productInterParkReg.item.smOptExplanBottom = "";
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc635\uc158 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getCertNMobile(ProductDTO dto, ProductInterParkReg productInterParkReg, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        try {
            if (!dto.getCert_type().equals("")) {
                productInterParkReg.item.prdCertStatus = dto.getCert_type().equals("1") ? "Y" : (dto.getCert_type().equals("2") ? "S" : "N");
                if (dto.getCert_type().equals("1")) {
                    productInterParkReg.item.prdCertDetail = dto.getCert();
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc778\uc99d\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    public String setDefaultDate(String data2) {
        String day = "";
        if (data2.equals("")) {
            return day;
        }
        switch (data2) {
            case "5": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, 5);
                Date date = calendar.getTime();
                day = new SimpleDateFormat("yyyyMMdd").format(date);
                break;
            }
            case "7": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, 7);
                Date date = calendar.getTime();
                day = new SimpleDateFormat("yyyyMMdd").format(date);
                break;
            }
            case "15": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, 15);
                Date date = calendar.getTime();
                day = new SimpleDateFormat("yyyyMMdd").format(date);
                break;
            }
            case "30": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, 1);
                Date date = calendar.getTime();
                day = new SimpleDateFormat("yyyyMMdd").format(date);
                break;
            }
            case "60": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, 2);
                Date date = calendar.getTime();
                day = new SimpleDateFormat("yyyyMMdd").format(date);
                break;
            }
            case "90": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, 3);
                Date date = calendar.getTime();
                day = new SimpleDateFormat("yyyyMMdd").format(date);
                break;
            }
            case "180": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, 6);
                Date date = calendar.getTime();
                day = new SimpleDateFormat("yyyyMMdd").format(date);
                break;
            }
            case "360": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(1, 1);
                Date date = calendar.getTime();
                day = new SimpleDateFormat("yyyyMMdd").format(date);
                break;
            }
        }
        return day;
    }

    private String InterParkProductSave(ShopInterParkAdditionalDto dtllist, ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookie) throws InterruptedException, Exception {
        ResultMarketPrice resultMarketPrice;
        ProductInterParkReg productInterParkReg = new ProductInterParkReg();
        productInterParkReg.item.prdNo = dto.getShopprodno();
        String categoryNum = this.getProductBasic(dtllist, dto, productInterParkReg);
        try {
            Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            int deliveryFee = 0;
            if (dtllist.getDelvcosttype().equals("01") && dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDELIVERYCOST();
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice = salePrice + (long)deliveryFee;
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            productInterParkReg.item.saleUnitcost = resultMarketPrice.getConsumer_if_sale_price();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud310\ub9e4\uac00 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        productInterParkReg.item.saleLmtQty = "9999";
        this.getSalePeriod(dtllist, productInterParkReg, dto);
        this.getDelivery(dtllist, productInterParkReg, dto);
        this.getItems(dtllist, dto, productInterParkReg, resultMarketPrice, shoppingMallDetailDto);
        this.getOption(dtllist, dto, productInterParkReg, resultMarketPrice);
        try {
            productInterParkReg.item.spcaseEd = dtllist.getUniqueness();
            productInterParkReg.item.ippSubmitYn = dtllist.getCostcomparisonyn();
            productInterParkReg.item.originPrdNo = dto.getCompayny_goods_cd();
            productInterParkReg.item.asInfo = dtllist.getAsdetail();
            if (dtllist.getInteryn().equals("02")) {
                productInterParkReg.item.intfreeInstmStrDts = dtllist.getInterperiodsrt();
                productInterParkReg.item.intfreeInstmEndDts = dtllist.getInterperiodend();
                productInterParkReg.item.listInstmMonths = String.valueOf(Integer.parseInt(dtllist.getInterperiodyn()));
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud2b9\uc774\uc0ac\ud56d, A/S, \uac00\uaca9\ube44\uad50 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            productInterParkReg.item.entrDcUseYn = dtllist.getSellburdenyn();
            if (dtllist.getSellburdenyn().equals("Y")) {
                productInterParkReg.item.entrDcTp = dtllist.getSellburdenfixrateyn().equals("01") ? "1" : (dtllist.getSellburdenfixrateyn().equals("02") ? "2" : "");
                productInterParkReg.item.entrDcNum = dtllist.getSellburdenfixratecost();
            }
            if (dtllist.getSellburdenperiodyn().equals("Y")) {
                productInterParkReg.item.entrDcStrDt = dtllist.getSellburdenperiodsrt().replaceAll("[^0-9]", "");
                productInterParkReg.item.entrDcEndDt = dtllist.getSellburdenperiodend().replaceAll("[^0-9]", "");
            }
            productInterParkReg.item.abroadBsYn = dtllist.getForabrdbuyclf().equals("Y") ? "Y" : "N";
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud310\ub9e4\uc790\ubd80\ub2f4\ud560\uc778, \uad6c\ub9e4\ub300\ud589 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        this.shopNotification(categoryNum, productInterParkReg, dto, shoppingMallDetailDto, cookie, dtllist);
        this.getCertNMobile(dto, productInterParkReg, shoppingMallDetailDto);
        YDMAStringUtil.Print(productInterParkReg.getXml());
        return productInterParkReg.getXml();
    }

    private List<String> SendInterParkProduct(ShoppingmallDTO shoppingMallDetailDto, String templatefilename) throws Exception {
        StringBuffer response = new StringBuffer();
        ArrayList<String> callback = new ArrayList<String>();
        HttpURLConnection httpConnection = null;
        URL obj = null;
        String xmlfile = "";
        xmlfile = "http://itsm.kdjsystem.com/xmldir/" + templatefilename;
        String url = String.format("http://ipss1.interpark.com/openapi/product/ProductAPIService.do?_method=UpdateProductAPIData&citeKey=%s&secretKey=%s&dataUrl=%s", shoppingMallDetailDto.getEDITAUTHKEY1(), shoppingMallDetailDto.getEDITAPIKEY(), xmlfile);
        obj = new URL(url);
        httpConnection = (HttpURLConnection)obj.openConnection();
        int responseCode = httpConnection.getResponseCode();
        if (responseCode == 200) {
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
            String inputLine = null;
            while ((inputLine = buffReader.readLine()) != null) {
                response.append(inputLine);
            }
            buffReader.close();
        }
        httpConnection.disconnect();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        ByteArrayInputStream bis = new ByteArrayInputStream(response.toString().getBytes());
        Document doc = db.parse(bis);
        Node n = doc.getFirstChild();
        NodeList nl = n.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node an = nl.item(i);
            if (an.getNodeType() == 1) {
                NodeList nl2 = an.getChildNodes();
                int i2 = 0;
                while (i2 < nl2.getLength()) {
                    Node an2 = nl2.item(i2);
                    if (an2.hasChildNodes()) {
                        callback.add(an2.getTextContent());
                    }
                    ++i2;
                }
            }
            ++i;
        }
        String remoteDir = "";
        remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
        FtpUtil.deletefile(remoteDir, templatefilename);
        File deleteFile = new File(String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\" + templatefilename);
        if (deleteFile.exists()) {
            deleteFile.delete();
        }
        return callback;
    }

    private String setXmlFile(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "euc-kr");
        transformer.setOutputProperty("indent", "yes");
        DOMSource DOMsource = new DOMSource(doc);
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        int anum = random.nextInt();
        String localfile = String.valueOf(YDMASessonUtil.getAppPath()) + "\\YDwmsData\\EditProductInterPark" + YDMASessonUtil.getCompnoInfo().getCompno() + YDMASessonUtil.getUserInfo().getUserId() + Integer.toString(anum) + ".xml";
        StreamResult result = new StreamResult(new File(localfile));
        transformer.transform(DOMsource, result);
        String remoteDir = "";
        remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
        String templatefilename = FtpUtil.upload(remoteDir, localfile);
        return templatefilename;
    }

    private boolean setProductChangeAll(ProductDTO dto, ShopInterParkAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookie) throws Exception {
        String xml = this.InterParkProductSave(dtllist, dto, shoppingMallDetailDto, cookie);
        String templatefilename = this.setXmlFile(xml);
        List<String> callback = this.SendInterParkProduct(shoppingMallDetailDto, templatefilename);
        boolean flag = InterParkProductModifyService.isNumeric(callback.get(0));
        if (!flag) {
            String errorMessage = this.setErrorMessage(callback.get(2));
            throw new Exception(errorMessage);
        }
        return flag;
    }

    private String setErrorMessage(String error) {
        String errorMessage = "";
        errorMessage = error.contains("omDispNo") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488 \uce74\ud14c\uace0\ub9ac \uac12 \ube44\uc874\uc7ac] " + error : (error.contains("\ub3d9\uc77c\ud55c \uc0c1\ud488 \ub4f1\ub85d \ubd88\uac00") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488\uba85 \uc911\ubcf5\ub4f1\ub85d \ubd88\uac00] " + error : "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : " + error);
        return errorMessage;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        try {
            shopProductSendDto.getWorkMngDto().getWorkcd();
            switch (status2) {
                case "8": {
                    this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist);
                    shopProductDto.setShopprodno("");
                    break;
                }
                case "0": {
                    boolean flag = this.setProductChangeAll(shopProductDto, (ShopInterParkAdditionalDto)dtllist, shoppingMallDetailDto, loginCookies);
                    if (flag) break;
                    return flag;
                }
                case "6": 
                case "7": {
                    this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist);
                    shopProductDto.setShopprodno("");
                    break;
                }
                case "9": {
                    this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist);
                }
            }
            shopProductDto.setResult_code("1");
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            throw new Exception(e);
        }
        return true;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        block4: {
            if (dto.getShopprodno().equals("")) {
                return false;
            }
            String json = "{\"page\":\"1\",\"rows\":50,\"searchOrderBy\":\"01\",\"searchPrdNo\":\"" + dto.getShopprodno() + "\",\"searchPrdNm\":\"\",\"searchHdelvMafcEntrNm\":\"\",\"searchPrdModel\":\"\",\"searchBrandNm\":\"\",\"searchSaleStatTp\":\"01,09\",\"searchDispNo\":\"\",\"searchDateTp\":\"\",\"searchStrDts\":\"\",\"searchEndDts\":\"\",\"searchPossRestQty\":\"\",\"searchSaleEndDts\":\"\",\"searchDelvCostTp\":\"\",\"searchBenefitTp\":\"\"}";
            try {
                Connection.Response rs = Jsoup.connect((String)"https://seller.interpark.com/api/products/search/list").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://seller.interpark.com/views/products/search").header("Host", "seller.interpark.com").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.POST).requestBody(json).followRedirects(true).ignoreHttpErrors(true).followRedirects(true).ignoreContentType(true).execute();
                String body = rs.body();
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
                if (!jsonObject.get("code").getAsString().equals("200")) break block4;
                JsonObject data2 = (JsonObject)jsonObject.get("data");
                JsonArray productList = (JsonArray)data2.get("productList");
                return productList.size() > 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        throw new Exception("\uc0c1\ud488\uc870\ud68c\uc2e4\ud328 : \uc0ac\uc774\ud2b8\uc5d0\uc11c \uc0c1\ud488\uc744 \uc870\ud68c\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
    }

    private boolean setProductDelete(String shopprodno, Map<String, String> cookies) throws Exception {
        if (shopprodno.equals("")) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("{");
        sb.append("\"prdNo\":\"").append(shopprodno).append("\"");
        sb.append("}");
        sb.append("]");
        try {
            JsonObject data2;
            JsonArray updateProductInfoDtoList;
            Connection.Response rs = Jsoup.connect((String)"https://seller.buyzle.co.kr/api/products/delete").cookies(cookies).header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.POST).requestBody(sb.toString()).timeout(20000).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonparser.parse(rs.body());
            return jsonObject.get("code").getAsString().equals("200") && (updateProductInfoDtoList = (JsonArray)(data2 = (JsonObject)jsonObject.get("data")).get("updateProductInfoDtoList")).size() > 0;
        }
        catch (Exception e) {
            throw new Exception("\ubc14\uc774\uc990 \uc0c1\ud488 \uc0ad\uc81c \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + e.getMessage() + "]");
        }
    }

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto) throws Exception {
        String shopInfoLog = String.format("[%s - %s(%s)]", dto.getSHOPINFO().getSHOPNM(), dto.getSHOPINFO().getSHOPPINGID(), dto.getSHOPINFO().getNICKNM1());
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 3000: 
                case 4000: {
                    boolean flag = this.setProductDelete(dto.getPRODUCT().getShopprodno(), dto.getCOOKIES());
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, dto.getPRODUCT(), "\uc0ad\uc81c", dto.getSHOPINFO(), "\uc131\uacf5", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                }
            }
            dto.getPRODUCT().setResult_code("1");
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        ArrayList<ProductOptionDTO> requestOptions = new ArrayList<ProductOptionDTO>();
        try {
            List<ProductOptionDTO> options = dto.getPRODUCT().getOPTIONS();
            List<ProductOptionDTO> oldOptions = ProductDAO.get().selectOptProductIn(dto.getPRODUCT().getSENDSEQ());
            for (ProductOptionDTO oldOption : oldOptions) {
                ProductOptionDTO filter = options.stream().filter(p -> p.getSENDSEQ() == oldOption.getSENDSEQ() && p.getSKUSEQ() == oldOption.getSKUSEQ()).findFirst().orElse(null);
                if (filter != null) {
                    oldOption.setOPTVERTSTOCK(0);
                }
                requestOptions.add(oldOption);
            }
            options.sort((p1, p2) -> Integer.compare(p1.getSKUSEQ(), p2.getSKUSEQ()));
            String json = this.getOptionModifyJson(requestOptions);
            Connection.Response response = Jsoup.connect((String)MallCode.getInterParkOptionModifyURL(dto.getPRODUCT().getShopprodno())).cookies(dto.getCOOKIES()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://seller.interpark.com/views/products/search").header("Host", "seller.interpark.com").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.PUT).requestBody(json).followRedirects(true).ignoreHttpErrors(true).followRedirects(true).ignoreContentType(true).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject bodyObj = (JsonObject)parser.parse(body);
            if (bodyObj.get("code").getAsInt() == 200) {
                return new ResultProcessDTO(0, bodyObj.get("message").getAsString(), dto.getPRODUCT().getCompayny_goods_cd());
            }
            return new ResultProcessDTO(-1, bodyObj.get("message").getAsString(), dto.getPRODUCT().getCompayny_goods_cd());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getCompayny_goods_cd());
        }
    }

    private String getOptionModifyJson(List<ProductOptionDTO> options) {
        try {
            InterParkProductDetailDto productDetailDto = new InterParkProductDetailDto();
            productDetailDto.setOptPrirTp("01");
            InterParkProduct product2 = new InterParkProduct();
            product2.setProductDetailDto(productDetailDto);
            product2.setOptStkMgtYn("Y");
            ArrayList<InterParkProductOption> productOptions = new ArrayList<InterParkProductOption>();
            ArrayList<InterParkProductOptionList> productOptionLists = new ArrayList<InterParkProductOptionList>();
            for (ProductOptionDTO option2 : options) {
                String[] names = option2.getOPTPRODNM().split("/");
                String[] vals = option2.getOPTSPECDES().split("/");
                InterParkProductOption productOption = new InterParkProductOption();
                InterParkProductOptionList productOptionList = new InterParkProductOptionList();
                productOptionList.setOptMainImg("");
                productOptionList.setOriginOptMainImg("");
                productOptionList.setOptDtlImg1("");
                productOptionList.setOriginOptDtlImg1("");
                productOptionList.setOptDtlImg2("");
                productOptionList.setOriginOptDtlImg2("");
                productOptionList.setOptDtlImg3("");
                productOptionList.setOriginOptDtlImg3("");
                productOptionList.setOptDtlImg4("");
                productOptionList.setOriginOptDtlImg4("");
                productOptionList.setOptDtlImg5("");
                productOptionList.setOriginOptDtlImg5("");
                if (names.length == 1) {
                    productOption.setOptItemNm(option2.getOPTSPECDES());
                    productOption.setOptItemNm2(null);
                    productOptionList.setOptNm(names[0]);
                    productOptionList.setOptNm2(null);
                    productOptionList.setOptItemNm(vals[0]);
                    productOptionList.setOptNo("0");
                    productOptionList.setPrdNo(option2.getSHOPPRODSKU());
                    productOptionList.setOptTp(option2.getOPTVERTSTOCK() > 0 ? "01" : "02");
                    productOptionList.setAddPrice(String.valueOf(option2.getOPTADDAMT()));
                    productOptionList.setSalePossRestQty(String.valueOf(option2.getOPTVERTSTOCK()));
                    productOptionList.setSaleLmtQty("999");
                    productOptionList.setExternalPrdNo(option2.getOPTPRODCD());
                } else if (names.length == 2) {
                    productOption.setOptItemNm(vals[0]);
                    productOption.setOptItemNm2(vals[1]);
                    productOptionList.setOptNm(names[0]);
                    productOptionList.setOptNm2(names[1]);
                    productOptionList.setOptItemNm(vals[0]);
                    productOptionList.setOptItemNm2(vals[1]);
                    productOptionList.setOptNo("0");
                    productOptionList.setPrdNo(option2.getSHOPPRODSKU());
                    productOptionList.setOptTp(option2.getOPTVERTSTOCK() > 0 ? "01" : "02");
                    productOptionList.setAddPrice(String.valueOf(option2.getOPTADDAMT()));
                    productOptionList.setSalePossRestQty(String.valueOf(option2.getOPTVERTSTOCK()));
                    productOptionList.setSaleLmtQty("999");
                    productOptionList.setExternalPrdNo(option2.getOPTPRODCD());
                }
                productOptions.add(productOption);
                productOptionLists.add(productOptionList);
            }
            InterParkUpdateOptionRequest request2 = new InterParkUpdateOptionRequest();
            request2.setProduct(product2);
            request2.setProductOption(productOptions);
            request2.setProductOptionList(productOptionLists);
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString((Object)request2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String logType) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackAndLogForProdIn(comment, 50, prodInfo, shoppingmallDTO, "YEL_DEL", jobResult, logType);
    }

    static final class AdaptorCDATA
    extends XmlAdapter<String, String> {
        AdaptorCDATA() {
        }

        public String marshal(String v) throws Exception {
            return "<![CDATA[" + v + "]]>";
        }

        public String unmarshal(String v) throws Exception {
            return v;
        }
    }

    private static class InterParkFile {
        public String fileName;
        public String filePath;
        public String storedFilePath;
        public String fileSize;
        public String contentType;
        public String previewFileName;

        private InterParkFile() {
        }
    }

    private static class InterParkFileUpload {
        public String success;
        public String message;
        public List<InterParkFile> files;

        private InterParkFileUpload() {
        }
    }

    private static class Item {
        @XmlElement(name="prdNo")
        private String prdNo;
        @XmlElement(name="prdStat")
        private String prdStat;
        @XmlElement(name="shopNo")
        private String shopNo = "0000100000";
        @XmlElement(name="omDispNo")
        private String omDispNo;
        @XmlElement(name="prdNm")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String prdNm;
        @XmlElement(name="hdelvMafcEntrNm")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String hdelvMafcEntrNm;
        @XmlElement(name="prdOriginTp")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String prdOriginTp;
        @XmlElement(name="taxTp")
        private String taxTp;
        @XmlElement(name="ordAgeRstrYn")
        private String ordAgeRstrYn;
        @XmlElement(name="saleStatTp")
        private String saleStatTp;
        @XmlElement(name="saleUnitcost")
        private String saleUnitcost;
        @XmlElement(name="saleLmtQty")
        private String saleLmtQty;
        @XmlElement(name="saleStrDts")
        private String saleStrDts;
        @XmlElement(name="saleEndDts")
        private String saleEndDts;
        @XmlElement(name="prdReleaseDt")
        private String prdReleaseDt;
        @XmlElement(name="proddelvCostUseYn")
        private String proddelvCostUseYn;
        @XmlElement(name="delvPlcNo")
        private String delvPlcNo;
        @XmlElement(name="prdrtnCostUseYn")
        private String prdrtnCostUseYn;
        @XmlElement(name="rtndelvCost")
        private String rtndelvCost;
        @XmlElement(name="rtndelvNo")
        private String rtndelvNo;
        @XmlElement(name="prdBasisExplanEd")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String prdBasisExplanEd;
        @XmlElement(name="zoomImg")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String zoomImg;
        @XmlElement(name="prdPostfix")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String prdPostfix;
        @XmlElement(name="prdKeywd")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String prdKeywd;
        @XmlElement(name="prdModelNo")
        private String prdModelNo;
        @XmlElement(name="brandNo")
        private String brandNo;
        @XmlElement(name="brandNm")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String brandNm;
        @XmlElement(name="entrPoint")
        private String entrPoint;
        @XmlElement(name="perordRstrQty")
        private String perordRstrQty;
        @XmlElement(name="selOptName")
        private String selOptName;
        @XmlElement(name="optPrirTp")
        private String optPrirTp;
        @XmlElement(name="prdOption")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String prdOption;
        @XmlElement(name="addOption")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String addOption;
        @XmlElement(name="addQtyUseYn")
        private String addQtyUseYn;
        @XmlElement(name="inOpt")
        private String inOpt;
        @XmlElement(name="smOptYn")
        private String smOptYn;
        @XmlElement(name="smOptTeplTp")
        private String smOptTeplTp;
        @XmlElement(name="smOptInfo")
        private String smOptInfo;
        @XmlElement(name="smOptExplanTop")
        private String smOptExplanTop;
        @XmlElement(name="smOptExplanBottom")
        private String smOptExplanBottom;
        @XmlElement(name="delvCost")
        private String delvCost;
        @XmlElement(name="delvAmtPayTpCom")
        private String delvAmtPayTpCom;
        @XmlElement(name="delvCostApplyTp")
        private String delvCostApplyTp;
        @XmlElement(name="freedelvStdCnt")
        private String freedelvStdCnt;
        @XmlElement(name="stdQty")
        private String stdQty;
        @XmlElement(name="jejuetcDelvCostUseYn")
        private String jejuetcDelvCostUseYn;
        @XmlElement(name="jejuDelvCost")
        private String jejuDelvCost;
        @XmlElement(name="etcDelvCost")
        private String etcDelvCost;
        @XmlElement(name="delvMthd")
        private String delvMthd;
        @XmlElement(name="spcaseEd")
        private String spcaseEd;
        @XmlElement(name="intfreeInstmStrDts")
        private String intfreeInstmStrDts;
        @XmlElement(name="intfreeInstmEndDts")
        private String intfreeInstmEndDts;
        @XmlElement(name="listInstmMonths")
        private String listInstmMonths;
        @XmlElement(name="ippSubmitYn")
        private String ippSubmitYn;
        @XmlElement(name="originPrdNo")
        private String originPrdNo;
        @XmlElement(name="asInfo")
        private String asInfo;
        @XmlElement(name="shopDispInfo")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String shopDispInfo;
        @XmlElement(name="detailImg")
        private String detailImg;
        @XmlElement(name="abroadBsYn")
        private String abroadBsYn;
        @XmlElement(name="medicalCertTp")
        private String medicalCertTp;
        @XmlElement(name="medicalRepOrg")
        private String medicalRepOrg;
        @XmlElement(name="medicalRepNo")
        private String medicalRepNo;
        @XmlElement(name="medicalPerNo")
        private String medicalPerNo;
        @XmlElement(name="medicalRevNo")
        private String medicalRevNo;
        @XmlElement(name="healthCertTp")
        private String healthCertTp;
        @XmlElement(name="healthRepOrg")
        private String healthRepOrg;
        @XmlElement(name="healthRepNo")
        private String healthRepNo;
        @XmlElement(name="healthCertDtlTp")
        private String healthCertDtlTp;
        @XmlElement(name="healthRevNo")
        private String healthRevNo;
        @XmlElement(name="foodCertTp")
        private String foodCertTp;
        @XmlElement(name="foodRepOrg")
        private String foodRepOrg;
        @XmlElement(name="foodRepNo")
        private String foodRepNo;
        @XmlElement(name="ecoCertYn")
        private String ecoCertYn;
        @XmlElement(name="ecoCertTp")
        private String ecoCertTp;
        @XmlElement(name="ecoCertOrg")
        private String ecoCertOrg;
        @XmlElement(name="ecoCertNo")
        private String ecoCertNo;
        @XmlElement(name="isbn")
        private String isbn;
        @XmlElement(name="oldUseMonth")
        private String oldUseMonth;
        @XmlElement(name="barcode")
        private String barcode;
        @XmlElement(name="prdCertStatus")
        private String prdCertStatus;
        @XmlElement(name="prdCertOptTp")
        private String prdCertOptTp;
        @XmlElement(name="prdCertDetail")
        private String prdCertDetail;
        @XmlElement(name="prdinfoNoti")
        private prdinfoNoti prdinfoNoti = new prdinfoNoti();
        @XmlElement(name="giftInfo")
        private String giftInfo;
        @XmlElement(name="planTxt")
        private String planTxt;
        @XmlElement(name="membershipTp")
        private String membershipTp;
        @XmlElement(name="usimTp")
        private String usimTp;
        @XmlElement(name="entrDcUseYn")
        private String entrDcUseYn;
        @XmlElement(name="entrDcTp")
        private String entrDcTp;
        @XmlElement(name="entrDcNum")
        private String entrDcNum;
        @XmlElement(name="entrDcStrDt")
        private String entrDcStrDt;
        @XmlElement(name="entrDcEndDt")
        private String entrDcEndDt;

        private Item() {
        }

        private static class NotificationItem {
            @XmlElement(name="infoSubNo")
            @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
            private String infoSubNo;
            @XmlElement(name="infoCd")
            private String infoCd;
            @XmlElement(name="infoTx")
            @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
            private String infoTx;

            private NotificationItem() {
            }
        }

        private static class prdinfoNoti {
            @XmlElement(name="info")
            private List<NotificationItem> items = new ArrayList<NotificationItem>();

            private prdinfoNoti() {
            }

            public prdinfoNoti setItems(String infoSubNo, String infoCd, String infoTx) {
                NotificationItem item = new NotificationItem();
                item.infoSubNo = infoSubNo;
                item.infoCd = infoCd;
                item.infoTx = infoTx;
                this.items.add(item);
                return this;
            }
        }
    }

    @XmlRootElement(name="result")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static final class ProductInterParkReg {
        @XmlElement(name="title")
        private String title = "Interpark Product API";
        @XmlElement(name="description")
        private String description = "\uc0c1\ud488 \uc218\uc815";
        @XmlElement(name="item")
        private Item item = new Item();

        private ProductInterParkReg() {
        }

        public String getXml() throws JAXBException {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProductInterParkReg.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"euc-kr");
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)this, (Writer)writer);
            String theXML = writer.toString().replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            return theXML;
        }
    }
}

