/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.dao.CategoryDAO;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.CategoryDTO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductAddProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductAddProcess;
import com.kdjsystem.mlink.yellim.helper.AppConfigHelper;
import com.kdjsystem.mlink.yellim.helper.DateHelper;
import com.kdjsystem.mlink.yellim.helper.JsonHelper;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAddDialog;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.core.runtime.IProgressMonitor;

public class LotteOnProductAddService
implements IProductAddProcess {
    private static final String Host = "https://openapi.lotteon.com";

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto) throws Exception {
        boolean flag = true;
        int page = 1;
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        while (flag) {
            String json = this.getJson(shopInfo, page, dto.getSTART_DATE(), dto.getEND_DATE());
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/v1/openapi/product/v1/product/list")).method("POST", body).addHeader("Content-Type", "application/json;").addHeader("Accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("Authorization", "Bearer " + shopInfo.getAPIKEY()).build();
            OkHttpClient client = AppConfigHelper.getInstance().getOkHttpClient();
            try {
                Throwable throwable = null;
                Object var16_18 = null;
                try (Response response = client.newCall(request2).execute();){
                    JsonParser parser = new JsonParser();
                    JsonObject result = (JsonObject)parser.parse(response.body().string());
                    if (!result.get("returnCode").getAsString().equals("0000")) {
                        this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                        this.setValue("--------------------------------------------------------------------------------------", 100);
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    int dataCount = result.get("dataCount").getAsInt();
                    if (dataCount == 0) {
                        this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                        this.setValue("--------------------------------------------------------------------------------------", 100);
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    if (result.get("data").isJsonNull()) {
                        this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                        this.setValue("--------------------------------------------------------------------------------------", 100);
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    JsonArray dataArr = (JsonArray)result.get("data");
                    if (dataArr.size() == 0) {
                        this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                        this.setValue("--------------------------------------------------------------------------------------", 100);
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                    int i = 0;
                    while (i < dataArr.size()) {
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        JsonObject data2 = dataArr.get(i).getAsJsonObject();
                        ProductDTO responseProduct = this.setDataBinding(shopInfo, data2, domemallInfos);
                        if (responseProduct != null) {
                            responseProducts.add(responseProduct);
                            this.setValue(String.format(" %s [%s] \ubd88\ub7ec\uc624\ub294 \uc911..", shopInfoLog, responseProduct.getCompayny_goods_cd()), 0);
                        }
                        ++i;
                    }
                    if (responseProducts.size() > 0) {
                        this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", page, responseProducts.size()), 0);
                        for (ProductDTO product2 : responseProducts) {
                            int ret;
                            if (ProductAddDialog.getIsCanceled()) {
                                return new ResultProcessDTO(0, "", infoRet, inRet);
                            }
                            ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                            if (copyProduct == null) {
                                if (!this.getSendStatus(product2.getSaleStatusCd()).equals(Integer.toString(8000))) continue;
                                ret = ProductDAO.get().insertProductInfo(product2);
                                if (ret == 1) {
                                    infoRet += ret;
                                    String comment = String.format(" %s [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                    this.setValueAndLogForProdInfo(comment, 50, product2, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                                }
                            } else {
                                copyProduct.setClass_cd3(product2.getClass_cd3());
                                copyProduct.setShop_cid_info(product2.getShop_cid_info());
                                ret = ProductDAO.get().updateProductInfo(copyProduct);
                                if (ret == 1) {
                                    infoRet += ret;
                                    String comment = String.format(" %s [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                    this.setValueAndLogForProdInfo(comment, 50, product2, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488 \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                                }
                            }
                            copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                            ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                            if (copyProductIn == null) {
                                product2.setPRODSEQ(copyProduct.getPRODSEQ());
                                int ret2 = ProductDAO.get().insertProductIn(product2);
                                if (ret2 == 1) {
                                    inRet += ret2;
                                    String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                    this.setValueAndLogForProdIn(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                                }
                            } else {
                                copyProductIn.setClass_cd3(product2.getClass_cd3());
                                copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                                copyProductIn.setGoods_nm(product2.getGoods_nm());
                                copyProductIn.setShopprodno(product2.getShopprodno());
                                copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                                copyProductIn.setSaleenddt(product2.getSaleenddt());
                                copyProductIn.setMarket_price(product2.getMarket_price());
                                copyProductIn.setGoods_price(product2.getGoods_price());
                                copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                                copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                                copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                                copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                                copyProductIn.setStatus(product2.getStatus());
                                copyProductIn.setSendstats(product2.getSendstats());
                                String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                                copyProductIn.setGoods_keyword(codeDivision);
                                int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                                if (ret3 == 1) {
                                    inRet += ret3;
                                    String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                    this.setValueAndLogForProdIn(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488 \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                                }
                            }
                            copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                            if (product2.getOPTIONS() == null) continue;
                            for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                                ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                                if (copyOption == null) {
                                    option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                    option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                    ProductDAO.get().insertOptProductInfo(option2);
                                } else {
                                    copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                    copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                    copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                    copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                    copyOption.setOPTEA(option2.getOPTEA());
                                    copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                    copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                    copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                    copyOption.setINSERTDT(option2.getINSERTDT());
                                    copyOption.setINSERTID(option2.getINSERTID());
                                    copyOption.setMODIFYDT(option2.getMODIFYDT());
                                    copyOption.setSTATUS(option2.getSTATUS());
                                }
                                ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                                if (copyOptionIn == null) {
                                    option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                    option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                    ProductDAO.get().insertOptProductIn(option2);
                                    continue;
                                }
                                copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                                copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                                copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                                copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOptionIn.setOPTEA(option2.getOPTEA());
                                copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOptionIn.setINSERTDT(option2.getINSERTDT());
                                copyOptionIn.setINSERTID(option2.getINSERTID());
                                copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                                copyOptionIn.setSTATUS(option2.getSTATUS());
                            }
                        }
                    }
                    ++page;
                    response.body().close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String errorMessage = e.getMessage() != null ? e.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
                this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
                this.setValue("--------------------------------------------------------------------------------------", 100);
                return new ResultProcessDTO(-1, "", 0, 0);
            }
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto, List<String> specificCodes) throws Exception {
        boolean flag = true;
        int page = 1;
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        while (flag) {
            String json = this.getJson(shopInfo, specificCodes, page, dto.getSTART_DATE(), dto.getEND_DATE());
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/v1/openapi/product/v1/product/list")).method("POST", body).addHeader("Content-Type", "application/json;").addHeader("Accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("Authorization", "Bearer " + shopInfo.getAPIKEY()).build();
            OkHttpClient client = AppConfigHelper.getInstance().getOkHttpClient();
            try {
                Throwable throwable = null;
                Object var17_19 = null;
                try (Response response = client.newCall(request2).execute();){
                    JsonParser parser = new JsonParser();
                    JsonObject result = (JsonObject)parser.parse(response.body().string());
                    if (!result.get("returnCode").getAsString().equals("0000")) {
                        this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                        this.setValue("--------------------------------------------------------------------------------------", 100);
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    int dataCount = result.get("dataCount").getAsInt();
                    if (dataCount == 0) {
                        this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                        this.setValue("--------------------------------------------------------------------------------------", 100);
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    if (result.get("data").isJsonNull()) {
                        this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                        this.setValue("--------------------------------------------------------------------------------------", 100);
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    JsonArray dataArr = (JsonArray)result.get("data");
                    if (dataArr.size() == 0) {
                        this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                        this.setValue("--------------------------------------------------------------------------------------", 100);
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                    int i = 0;
                    while (i < dataArr.size()) {
                        ProductDTO responseProduct;
                        String specificCode;
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        JsonObject data2 = dataArr.get(i).getAsJsonObject();
                        if (!(specificCodes.size() > 0 && (specificCode = specificCodes.stream().filter(p -> p.equals(JsonHelper.jsonNullStr(data2.get("epdNo")))).findFirst().orElse("")).equals("") || (responseProduct = this.setDataBinding(shopInfo, data2, domemallInfos)) == null)) {
                            responseProducts.add(responseProduct);
                            this.setValue(String.format(" %s [%s] \ubd88\ub7ec\uc624\ub294 \uc911..", shopInfoLog, responseProduct.getCompayny_goods_cd()), 0);
                        }
                        ++i;
                    }
                    if (responseProducts.size() > 0) {
                        this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", page, responseProducts.size()), 0);
                        for (ProductDTO product2 : responseProducts) {
                            int ret;
                            if (ProductAddDialog.getIsCanceled()) {
                                return new ResultProcessDTO(0, "", infoRet, inRet);
                            }
                            ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                            if (copyProduct == null) {
                                if (!this.getSendStatus(product2.getSaleStatusCd()).equals(Integer.toString(8000))) continue;
                                ret = ProductDAO.get().insertProductInfo(product2);
                                if (ret == 1) {
                                    infoRet += ret;
                                    String comment = String.format(" %s [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                    this.setValueAndLogForProdInfo(comment, 50, product2, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                                }
                            } else {
                                copyProduct.setClass_cd3(product2.getClass_cd3());
                                copyProduct.setShop_cid_info(product2.getShop_cid_info());
                                ret = ProductDAO.get().updateProductInfo(copyProduct);
                                if (ret == 1) {
                                    infoRet += ret;
                                    String comment = String.format(" %s [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                    this.setValueAndLogForProdInfo(comment, 50, product2, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488 \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                                }
                            }
                            copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                            ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                            if (copyProductIn == null) {
                                product2.setPRODSEQ(copyProduct.getPRODSEQ());
                                int ret2 = ProductDAO.get().insertProductIn(product2);
                                if (ret2 == 1) {
                                    inRet += ret2;
                                    String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                    this.setValueAndLogForProdIn(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                                }
                            } else {
                                copyProductIn.setClass_cd3(product2.getClass_cd3());
                                copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                                copyProductIn.setGoods_nm(product2.getGoods_nm());
                                copyProductIn.setShopprodno(product2.getShopprodno());
                                copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                                copyProductIn.setSaleenddt(product2.getSaleenddt());
                                copyProductIn.setMarket_price(product2.getMarket_price());
                                copyProductIn.setGoods_price(product2.getGoods_price());
                                copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                                copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                                copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                                copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                                copyProductIn.setStatus(product2.getStatus());
                                copyProductIn.setSendstats(product2.getSendstats());
                                String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                                copyProductIn.setGoods_keyword(codeDivision);
                                int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                                if (ret3 == 1) {
                                    inRet += ret3;
                                    String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                    this.setValueAndLogForProdIn(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488 \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                                }
                            }
                            copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                            if (product2.getOPTIONS() == null) continue;
                            for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                                ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                                if (copyOption == null) {
                                    option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                    option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                    ProductDAO.get().insertOptProductInfo(option2);
                                } else {
                                    copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                    copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                    copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                    copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                    copyOption.setOPTEA(option2.getOPTEA());
                                    copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                    copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                    copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                    copyOption.setINSERTDT(option2.getINSERTDT());
                                    copyOption.setINSERTID(option2.getINSERTID());
                                    copyOption.setMODIFYDT(option2.getMODIFYDT());
                                    copyOption.setSTATUS(option2.getSTATUS());
                                    ProductDAO.get().updateOptProductInfo(copyOption);
                                }
                                ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                                if (copyOptionIn == null) {
                                    option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                    option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                    ProductDAO.get().insertOptProductIn(option2);
                                    continue;
                                }
                                copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                                copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                                copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                                copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOptionIn.setOPTEA(option2.getOPTEA());
                                copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOptionIn.setINSERTDT(option2.getINSERTDT());
                                copyOptionIn.setINSERTID(option2.getINSERTID());
                                copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                                copyOptionIn.setSTATUS(option2.getSTATUS());
                                ProductDAO.get().updateOptProductIn(copyOptionIn);
                            }
                        }
                    }
                    ++page;
                    response.body().close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String errorMessage = e.getMessage() != null ? e.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
                this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
                this.setValue("--------------------------------------------------------------------------------------", 100);
                return new ResultProcessDTO(-1, "", 0, 0);
            }
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    private ProductDTO setDataBinding(ShoppingmallDTO shopInfo, JsonObject data2, List<DomemallDTO> domemallInfos) throws Exception {
        ProductDTO responseProduct;
        block20: {
            responseProduct = new ProductDTO();
            JsonParser parser = new JsonParser();
            try {
                responseProduct.setShopcd(shopInfo.getSHOPCD());
                responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
                responseProduct.setGoods_nm(JsonHelper.jsonNullStr(data2.get("spdNm")));
                responseProduct.setShopprodno(JsonHelper.jsonNullStr(data2.get("spdNo")));
                responseProduct.setCompayny_goods_cd(JsonHelper.jsonNullStr(data2.get("epdNo")));
                responseProduct.setInsertdt(JsonHelper.jsonNullStr(data2.get("slStrtDttm")));
                responseProduct.setSaleenddt(JsonHelper.jsonNullStr(data2.get("slEndDttm")));
                responseProduct.setStatus(this.getStatus(JsonHelper.jsonNullStr(data2.get("slStatCd"))));
                responseProduct.setSendstats(this.getSendStatus(JsonHelper.jsonNullStr(data2.get("slStatCd"))));
                responseProduct.setSaleStatusCd(this.getSendStatus(JsonHelper.jsonNullStr(data2.get("slStatCd"))));
                if (responseProduct.getSaleStatusCd().equals("8000")) {
                    responseProduct.setSaleStatusCd("SALE");
                }
                responseProduct.setInsertdt(JsonHelper.jsonNullStr(data2.get("slStrtDttm")));
                String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(responseProduct.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                responseProduct.setGoods_keyword(codeDivision);
                CategoryDTO category = this.getCategory(data2);
                responseProduct.setClass_cd3(category.getCODE());
                responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                responseProduct.setGmcategnm(category.getFULL_NAME());
                MediaType mediaType = MediaType.parse((String)"application/json");
                RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)this.getJson(shopInfo.getAUTHKEY1(), responseProduct.getShopprodno()));
                Request request2 = new Request.Builder().url(Host.concat("/v1/openapi/product/v1/product/detail")).method("POST", requestBody).addHeader("Content-Type", "application/json;").addHeader("Accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("Authorization", "Bearer " + shopInfo.getAPIKEY()).build();
                OkHttpClient client = AppConfigHelper.getInstance().getOkHttpClient();
                try {
                    Throwable throwable = null;
                    Object var13_16 = null;
                    try (Response response = client.newCall(request2).execute();){
                        JsonObject body = (JsonObject)parser.parse(response.body().string());
                        if (body.get("returnCode").getAsString().equals("0000") && Integer.parseInt(body.get("dataCount").getAsString()) > 0) {
                            JsonObject dataObj = body.get("data").getAsJsonObject();
                            JsonArray itmLst = (JsonArray)dataObj.get("itmLst");
                            if (itmLst.size() > 1) {
                                responseProduct.setMarket_price(JsonHelper.jsonElementNullInt(itmLst.get(0).getAsJsonObject().get("slPrc")));
                                responseProduct.setGoods_price(JsonHelper.jsonElementNullInt(itmLst.get(0).getAsJsonObject().get("slPrc")));
                                responseProduct.setGoods_consumer_price(JsonHelper.jsonElementNullInt(itmLst.get(0).getAsJsonObject().get("slPrc")));
                                List<ProductOptionDTO> options = this.getOption(responseProduct, itmLst);
                                responseProduct.setOPTIONS(options);
                                String[] optionNames = options.stream().map(p -> p.getOPTPRODNM()).findFirst().orElse("").split("/");
                                if (optionNames.length == 1) {
                                    responseProduct.setChar_1_nm(optionNames[0]);
                                } else if (optionNames.length == 2) {
                                    responseProduct.setChar_1_nm(optionNames[0]);
                                    responseProduct.setChar_2_nm(optionNames[1]);
                                }
                            } else {
                                JsonObject product2 = (JsonObject)itmLst.get(0);
                                responseProduct.setMarket_price(JsonHelper.jsonElementNullInt(product2.get("slPrc")));
                                responseProduct.setGoods_price(JsonHelper.jsonElementNullInt(product2.get("slPrc")));
                                responseProduct.setGoods_consumer_price(JsonHelper.jsonElementNullInt(product2.get("slPrc")));
                                responseProduct.setChar_1_nm("\ub2e8\ud488");
                                responseProduct.setChar_1_val("");
                                responseProduct.setChar_2_nm("");
                                responseProduct.setChar_2_val("");
                            }
                            break block20;
                        }
                        throw new Exception("\uc0c1\ud488 \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n");
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseProduct;
    }

    private String getJson(ShoppingmallDTO shopInfo, int page, String startDate, String endDate) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("\"trGrpCd\":\"SR\",");
        builder.append("\"pageNo\":" + page + ",");
        builder.append("\"rowsPerPage\":100,");
        builder.append("\"trNo\":\"" + shopInfo.getAUTHKEY1() + "\",");
        builder.append("\"regStrtDttm\":\"" + DateHelper.convertToDateTime(startDate) + "\",");
        builder.append("\"regEndDttm\":\"" + DateHelper.convertToDateTime(endDate) + "\",");
        builder.append("\"slStatCd\":\"SALE\"");
        builder.append("}");
        return builder.toString();
    }

    private String getJson(ShoppingmallDTO shopInfo, List<String> specificCodes, int page, String startDate, String endDate) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("\"trGrpCd\":\"SR\",");
        builder.append("\"trNo\":\"").append(shopInfo.getAUTHKEY1()).append("\",");
        builder.append("\"epdNo\": [");
        int i = 0;
        while (i < specificCodes.size()) {
            builder.append("\"").append(specificCodes.get(i)).append("\"");
            if (i < specificCodes.size() - 1) {
                builder.append(",");
            }
            ++i;
        }
        builder.append("],");
        builder.append("\"pageNo\":").append(page).append(",");
        builder.append("\"rowsPerPage\":100,");
        builder.append("\"regStrtDttm\":\"").append(DateHelper.convertToDateTime(startDate)).append("\",");
        builder.append("\"regEndDttm\":\"").append(DateHelper.convertToDateTime(endDate)).append("\"");
        builder.append("}");
        return builder.toString();
    }

    private String getJson(String authkey, String shopprodno) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("\"trGrpCd\":\"SR\", ");
        builder.append("\"trNo\":\"" + authkey + "\", ");
        builder.append("\"spdNo\":\"" + shopprodno + "\"");
        builder.append("}");
        return builder.toString();
    }

    public CategoryDTO getCategory(JsonObject data2) {
        try {
            String code = JsonHelper.jsonNullStr(data2.get("scatNo"));
            CategoryDTO category = CategoryDAO.get().selectShoppingMallCategory(code);
            if (category == null) {
                category = CategoryDAO.get().selectCategory("350119000");
            }
            return category;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<ProductOptionDTO> getOption(ProductDTO responseProduct, JsonArray itmLst) {
        ArrayList<ProductOptionDTO> options = new ArrayList<ProductOptionDTO>();
        try {
            int i = 0;
            while (i < itmLst.size()) {
                JsonObject item = itmLst.get(i).getAsJsonObject();
                ProductOptionDTO option2 = new ProductOptionDTO();
                option2.setSKUSEQ(i + 1);
                option2.setSHOPPRODNO(responseProduct.getShopprodno());
                option2.setSHOPPRODSKU(item.get("sitmNm").getAsString());
                option2.setSHOPPRODSKU_NM(responseProduct.getGoods_nm());
                option2.setPRODCD(responseProduct.getCompayny_goods_cd());
                option2.setOPTPRODCD(responseProduct.getCompayny_goods_cd().concat("-" + String.valueOf(i + 1)));
                JsonArray itmOptLst = item.get("itmOptLst").getAsJsonArray();
                String optprodnm = "";
                String optspecdes = "";
                if (itmOptLst.size() == 1) {
                    optprodnm = itmOptLst.get(0).getAsJsonObject().get("optNm").getAsString();
                    optspecdes = itmOptLst.get(0).getAsJsonObject().get("optVal").getAsString();
                } else if (itmOptLst.size() == 2) {
                    String name1 = itmOptLst.get(0).getAsJsonObject().get("optNm").getAsString();
                    String name2 = itmOptLst.get(1).getAsJsonObject().get("optNm").getAsString();
                    optprodnm = String.valueOf(name1) + "/" + name2;
                    String val1 = itmOptLst.get(0).getAsJsonObject().get("optVal").getAsString();
                    String val2 = itmOptLst.get(1).getAsJsonObject().get("optVal").getAsString();
                    optspecdes = String.valueOf(val1) + "/" + val2;
                }
                option2.setOPTPRODNM(optprodnm);
                option2.setOPTSPECDES(optspecdes);
                option2.setOPTSAFESTOCK(Integer.parseInt(responseProduct.getGoods_price()));
                option2.setOPTVERTSTOCK(item.get("stkQty").getAsInt());
                option2.setOPTADDAMT(item.get("slPrc").getAsInt() - Integer.parseInt(responseProduct.getGoods_price()));
                option2.setINSERTDT(responseProduct.getInsertdt());
                option2.setINSERTID(YDMASessonUtil.getUserInfo().getUserId());
                option2.setSTATUS(item.get("stkQty").getAsInt() > 0 ? "0" : "1");
                options.add(option2);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            options = null;
        }
        return options;
    }

    private String getStatus(String status2) {
        switch (status2) {
            case "SALE": {
                return "0";
            }
            case "SOUT": {
                return "1";
            }
            case "END": 
            case "STP": {
                return "3";
            }
        }
        return "";
    }

    private String getSendStatus(String status2) {
        switch (status2) {
            case "SALE": {
                return String.valueOf(8000);
            }
            case "END": 
            case "STP": {
                return String.valueOf(3000);
            }
            case "SOUT": {
                return String.valueOf(4000);
            }
        }
        return "";
    }

    @Override
    public ResultProcessDTO addProcess2(ProductAddProcessDTO proDto, List<String> specificCodes, IProgressMonitor monitor, ShoppingmallDTO dto) throws Exception {
        return null;
    }

    private void setValue(String message, int value) {
        CommonProgressDialog.get().setValue(message, value);
    }

    private void setValueAndLogForProdIn(String title, int value, ProductDTO item, ShoppingmallDTO shopInfo, String jobType, String jobResult, String logMsg) {
        CommonProgressDialog.get().setValueAndLogForProdIn(title, value, item, shopInfo, jobType, jobResult, logMsg);
    }

    private void setValueAndLogForProdInfo(String title, int value, ProductDTO item, String jobType, String jobResult, String logMsg) {
        CommonProgressDialog.get().setValueAndLogForProdInfo(title, value, item, jobType, jobResult, logMsg);
    }
}

