/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.shop.common.ChromeExtention;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopMelchiAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.data.Melchi.MelchiExitsProductCd;
import com.kdjsystem.mlink.yellim.shop.data.Melchi.MelchiProductDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;

public class MelchiProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    List<ShopOptionDto> shopOptionDtos;

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        block3: {
            String shopprodno = "";
            try {
                Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/product/register/productList/list").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.45 Safari/537.36").cookies(cookies).data("schYn", "Y").data("listType", "list").data("searchDateType", "01").data("searchOptional", "01").data("searchOptionalValue", dto.getShopprodno()).data("searchListCountType", "01").data("page", "1").method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).execute();
                Document body = Jsoup.parseBodyFragment((String)response.body());
                Elements eLTd = body.select("div.sub_section_01 table#table_style04 tbody tr td");
                if (eLTd.size() <= 0) return false;
                String status2 = body.select("#table_style04 > tbody > tr:nth-child(3) > td:nth-child(6) > span").toString();
                if (!status2.contains("\ud310\ub9e4\uc911") && !status2.contains("\ud310\ub9e4\ub300\uae30")) throw new Exception("\uc0c1\ud488\ubc88\ud638[" + dto.getShopprodno() + "]\uac74\uc73c\ub85c \uac80\uc0c9\ub41c \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                shopprodno = body.select("#table_style04 > tbody > tr:nth-child(3) > td:nth-child(4)").text();
                if (!shopprodno.equals(dto.getShopprodno())) break block3;
                return true;
            }
            catch (Exception exception) {
                throw new Exception("\uc0c1\ud488\ubc88\ud638 \uc870\ud68c\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
        }
        throw new Exception("\uc0c1\ud488\ubc88\ud638[" + dto.getShopprodno() + "]\uac74\uc73c\ub85c \uac80\uc0c9\ub41c \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> cookies) throws Exception {
        boolean flag = true;
        try {
            switch (status2) {
                case "7": 
                case "8": {
                    flag = this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto, cookies);
                    if (!flag) {
                        return flag;
                    }
                    shopProductDto.setShopprodno("");
                    Thread.sleep(5000L);
                    break;
                }
                case "0": {
                    Thread.sleep(1000L);
                    ShopMelchiAdditionalDto shopmelchidtllist = null;
                    shopmelchidtllist = (ShopMelchiAdditionalDto)shopProductSendDto.getProductAdditionDto();
                    List<Object> strImages = new ArrayList();
                    strImages = shopmelchidtllist.getChangesize().equals("Y") ? this.getProductImages(shopProductDto, shopmelchidtllist.getChangeSizeX(), shopmelchidtllist.getChangeSizeY(), shopmelchidtllist.getChangeSizeW(), shopmelchidtllist.getChangeSizeH()) : this.getProductImages(shopProductDto);
                    this.DownLoadImage(shopmelchidtllist, shoppingMallDetailDto, strImages);
                    Map<String, String> pdData = this.setProductReg(shopProductDto, cookies, shopmelchidtllist, shoppingMallDetailDto, strImages);
                    this.productRegSend(pdData, cookies, shopProductDto, strImages, shopmelchidtllist);
                    Thread.sleep(30000L);
                    break;
                }
                case "6": {
                    flag = this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto, cookies);
                    if (!flag) {
                        return flag;
                    }
                    shopProductDto.setShopprodno("");
                    Thread.sleep(5000L);
                }
                default: {
                    break;
                }
                case "9": {
                    return true;
                }
            }
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean setProductStop(String status2, ShoppingmallDTO shoppingMallDetailDto, ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShopProductSendDto shopProductSendDto, Map<String, String> cookies) throws Exception {
        Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/product/register/changeStatus.json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.45 Safari/537.36").header("Host", "scm.smelchi.com").cookies(cookies).data("field", "status").data("status", "03").data("productCds", shopProductDto.getShopprodno()).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        YDMAStringUtil.Print(response);
        Thread.sleep(25000L);
        String prodNo = MelchiExitsProductCd.get().isSoldOutcheck(shopProductDto.getCompayny_goods_cd(), cookies);
        if (prodNo.equals("")) {
            shopProductDto.setResult_code("-1");
            return false;
        }
        shopProductDto.setResult_code("1");
        return true;
    }

    private void DownLoadImage(ShopMelchiAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto, List<String> strImages) throws Exception, InterruptedException {
        for (String img : strImages) {
            ShopCommon.downloadImgFile(img, 720, 758);
            Thread.sleep(1000L);
        }
    }

    private synchronized void productRegSend(Map<String, String> pdData, Map<String, String> cookies, ProductDTO dto, List<String> strImages, ShopMelchiAdditionalDto dtllist) throws Exception {
        try {
            Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/product/register/save").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.45 Safari/537.36").cookies(cookies).data(pdData).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).execute();
            this.productCheck(cookies, dto, response, strImages, dtllist);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private Map<String, String> setProductReg(ProductDTO dto, Map<String, String> cookies, ShopMelchiAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto, List<String> strImages) throws Exception {
        HashMap<String, String> pdData = new HashMap<String, String>();
        MelchiProductDto melDto = new MelchiProductDto();
        try {
            this.Category(pdData, dtllist, melDto);
            this.ItemBasic(dto, dtllist, pdData);
            this.Option(dto, dtllist, pdData);
            this.BasicShipping(dto, dtllist, pdData);
            this.DetailRemark(dto, dtllist, pdData);
            pdData.put("isUploadImages", "true");
            pdData.put("isUploadImagesYn", "true");
            this.basicNoti(dto, pdData, dtllist);
            this.SaleInfo(pdData, dtllist);
            this.etc(pdData, dto, cookies);
        }
        catch (Exception e) {
            throw new Exception("\uc0c1\ud488\uc744 \uc218\uc815\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
        }
        return pdData;
    }

    private void Category(Map<String, String> pdData, ShopMelchiAdditionalDto dtllist, MelchiProductDto melDto) throws Exception {
        try {
            if (dtllist.getIsCategory().equals("1")) {
                pdData.put("categoryTmp_1", dtllist.getLagcatcd());
                melDto.categoryTmp_1 = dtllist.getLagcatcd();
                pdData.put("categoryTmp_2", dtllist.getMidcatcd());
                melDto.categoryTmp_2 = dtllist.getMidcatcd();
                pdData.put("categoryTmp_3", dtllist.getSmlcatcd());
                melDto.categoryTmp_3 = dtllist.getSmlcatcd();
                pdData.put("cateCd", dtllist.getShopcatno());
                melDto.cateCd = dtllist.getShopcatno();
                pdData.put("categoryTmp_4", dtllist.getDetcatcd());
                melDto.categoryTmp_4 = dtllist.getDetcatcd();
            } else {
                pdData.put("categoryTmp_1", dtllist.getLagcatcd());
                pdData.put("categoryTmp_2", dtllist.getMidcatcd());
                pdData.put("categoryTmp_3", dtllist.getSmlcatcd());
                pdData.put("cateCd", dtllist.getShopcatno());
                pdData.put("categoryTmp_4", dtllist.getDetcatcd());
            }
        }
        catch (Exception e) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac\ub97c \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private void ItemBasic(ProductDTO dto, ShopMelchiAdditionalDto dtllist, Map<String, String> pdData) throws Exception {
        try {
            pdData.put("sellerProductCd", dto.getCompayny_goods_cd());
            pdData.put("prevStatus", "02");
            pdData.put("modelCd", dto.getCompayny_goods_cd());
            pdData.put("modelName", dto.getGoods_nm());
            this.Basic(dto, dtllist, pdData);
            this.Brand(dto, pdData);
            pdData.put("originName", dto.getOrigin());
            pdData.put("manufacName", dto.getMaker());
            pdData.put("typecd", dto.getItype());
            pdData.put("isTaxed", dtllist.getIsTaxedYn());
            pdData.put("saleDisplayType", "01");
            pdData.put("OVERSEAS_GOODS_SALES_YN", dtllist.getOverseas_goods_sales_Yn());
        }
        catch (Exception e) {
            throw new Exception("\uc0c1\ud488\uba85\uc744 \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private void Basic(ProductDTO dto, ShopMelchiAdditionalDto dtllist, Map<String, String> pdData) throws Exception {
        String prodName = "";
        try {
            switch (dtllist.getProdnmout()) {
                case "1": {
                    prodName = dto.getGoods_nm();
                    break;
                }
                case "2": {
                    prodName = dto.getModel_nm();
                    break;
                }
                case "3": {
                    prodName = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "4": {
                    prodName = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "5": {
                    prodName = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "6": {
                    prodName = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    prodName = dto.getGoods_nm();
                }
            }
            if (!dtllist.getProdnmstart().equals("")) {
                prodName = dtllist.getProdnmstart().concat(prodName);
            }
            if (!dtllist.getProdnmend().equals("")) {
                prodName = prodName.concat(dtllist.getProdnmend());
            }
            dto.setGoods_nm(prodName);
            pdData.put("productName", dto.getGoods_nm());
        }
        catch (Exception e) {
            throw new Exception("\uc0c1\ud488\uba85\uc744 \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private void Brand(ProductDTO dto, Map<String, String> pdData) throws Exception {
        try {
            pdData.put("brandNameSe", "\uc9c1\uc811\uc785\ub825");
            if (dto.getBrand_nm().equals("")) {
                pdData.put("brandName", "\uae30\ud0c0");
            } else {
                pdData.put("brandName", dto.getBrand_nm());
            }
            pdData.put("brandcd", "0");
        }
        catch (Exception e) {
            throw new Exception("\ube0c\ub79c\ub4dc\ub97c \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private void Option(ProductDTO dto, ShopMelchiAdditionalDto dtllist, Map<String, String> pdData) throws Exception {
        int salePrice = this.SalePrice(dto, dtllist);
        try {
            if (!dto.getChar_1_nm().equals("\ub2e8\ud488")) {
                pdData.put("sellingPrice", Integer.toString(salePrice));
                pdData.put("supplyPrice", "0");
                pdData.put("isUsedProductOption", "1");
                pdData.put("prdqty", dto.getQty() == null ? "9999" : dto.getQty());
            } else {
                pdData.put("sellingPrice", Integer.toString(salePrice));
                pdData.put("supplyPrice", "0");
                pdData.put("isUsedProductOption", "0");
                pdData.put("prdqty", dto.getQty() == null ? "9999" : dto.getQty());
            }
        }
        catch (Exception e) {
            throw new Exception("\ub2e8\ud488\uc635\uc158\uc744 \ub4f1\ub85d\ud558\ub294 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private int SalePrice(ProductDTO dto, ShopMelchiAdditionalDto dtllist) throws Exception {
        int salePrice = 0;
        try {
            int limit_price;
            ResultMarketPrice resultMarketPrice;
            salePrice = YDMAStringUtil.convertToInt(dto.getGoods_cost());
            int deliveryFee = 0;
            if (dtllist.getFreeDelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDELIVERYCOST();
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice += deliveryFee;
            }
            if ((long)salePrice > YDMAStringUtil.convertToLong((resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price()), salePrice)).getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception e) {
            throw new Exception("\uae30\ubcf8\ud310\ub9e4\uac00 \uacc4\uc0b0\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4." + e);
        }
        return Integer.parseInt(dto.getGoods_price());
    }

    private void BasicShipping(ProductDTO dto, ShopMelchiAdditionalDto dtllist, Map<String, String> pdData) throws Exception {
        String deliveryCost = "";
        try {
            if (dtllist.getShippingFeeTmp2().equals("9999") || dtllist.getShippingFeeTmp4().equals("9999")) {
                if (!dto.getDelv_cost().equals("0")) {
                    deliveryCost = dto.getDelv_cost();
                } else {
                    Object systemconf = ShopCommonDao.get().getSystemConf();
                    deliveryCost = String.valueOf(((PreferencesMallDTO)systemconf).getDELIVERYCOST());
                }
            }
            pdData.put("releaseTerm", dtllist.getReleaseTerm());
            pdData.put("shippingMethod", dtllist.getShippingMethodYn());
            pdData.put("shippingFeeType", dtllist.getShippingFeeType());
            switch (dtllist.getShippingFeeType()) {
                case "01": {
                    pdData.put("shippingFee", "0");
                    pdData.put("shippingFeePayType", "01");
                    pdData.put("shippingFeeTmp2", "0");
                    pdData.put("shippingFeeTmp4", "0");
                    pdData.put("freeShippingAmount", "0");
                    break;
                }
                case "02": {
                    pdData.put("shippingFee", dtllist.getShippingFeeTmp2().equals("9999") ? deliveryCost : dtllist.getShippingFeeTmp2());
                    pdData.put("shippingFeePayType", "02");
                    pdData.put("shippingFeeTmp2", dtllist.getShippingFeeTmp2());
                    pdData.put("shippingFeePayTypeTmp2", dtllist.getShippingFeePayTypeTmp2());
                    pdData.put("shippingFeeTmp4", "0");
                    pdData.put("freeShippingAmount", "0");
                    break;
                }
                case "03": {
                    pdData.put("shippingFee", dto.getDelv_cost());
                    pdData.put("shippingFeePayType", "03");
                    pdData.put("shippingFeeTypeTmp3", dtllist.getShippingFeeTypeTmp3());
                    pdData.put("shippingFeeTmp2", "0");
                    pdData.put("shippingFeeTmp4", "0");
                    pdData.put("freeShippingAmount", "0");
                    break;
                }
                case "04": {
                    pdData.put("shippingFee", dtllist.getShippingFeeTmp4().equals("9999") ? deliveryCost : dtllist.getShippingFeeTmp4());
                    pdData.put("shippingFeePayType", "04");
                    pdData.put("shippingFeeTmp2", "0");
                    pdData.put("shippingFeeTmp4", dtllist.getShippingFeeTmp4());
                    pdData.put("freeShippingAmount", dtllist.getFreeShippingAmount());
                    pdData.put("shippingFeePayTypeTmp4", dtllist.getShippingFeePayTypeTmp4());
                }
            }
            pdData.put("limitCntUseYn", dtllist.getUI_limitCntUseYn());
            pdData.put("quantityCntUseYn", dtllist.getUI_quantityCntUseYn());
            pdData.put("limitCntUseYn", dtllist.getUI_limitCntUseYn());
            pdData.put("isAdditionalShippingFee", dtllist.getIsAdditionalShippingFee());
            pdData.put("additionalShippingFee", dtllist.getAdditionalShippingFee());
            pdData.put("returnShippingFee", dtllist.getReturnShippingFee());
            pdData.put("changeShippingFee", dtllist.getChangeShippingFee());
            pdData.put("isReturnedAddress", dtllist.getIsReturnedAddressYn());
        }
        catch (Exception e) {
            throw new Exception("\ubc30\uc1a1\uc815\ubcf4\ub97c \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private void DetailRemark(ProductDTO dto, ShopMelchiAdditionalDto dtllist, Map<String, String> pdData) throws Exception {
        String addDetailPlus = "";
        try {
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = String.valueOf(dtllist.getDetailKeywordL()) + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            pdData.put("contents", String.valueOf(addDetailPlus) + dtllist.getRemarkstart() + dto.getGoods_remarks() + dtllist.getRemarkend());
        }
        catch (Exception e) {
            throw new Exception("\uc0c1\uc138\uc124\uba85\uc744 \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private void basicNoti(ProductDTO dto, Map<String, String> pdData, ShopMelchiAdditionalDto dtllist) throws Exception {
        try {
            List<ShopProdAttrnmDto> melchiPdAttrList = ShopProductDao.get().getProductMelchiNotice(dto.getProp1_cd(), "shop0106");
            pdData.put("notiGroupCd", dto.getProp1_cd().substring(1));
            if (dtllist.getTotalApplicationYn().equals("Y")) {
                pdData.put("productNotiRegMethod", "01");
                pdData.put("isDisplayType", "1");
            } else {
                pdData.put("productNotiRegMethod", "02");
                pdData.put("isDisplayType", "2");
            }
            pdData.put("lastOrderSeq", Integer.toString(melchiPdAttrList.size() - 1));
        }
        catch (Exception e) {
            throw new Exception("\uace0\uc2dc\uc815\ubcf4\ub97c \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private void SaleInfo(Map<String, String> pdData, ShopMelchiAdditionalDto dtllist) throws Exception {
        try {
            if (dtllist.getProductDiRegMethodYn().equals("Y")) {
                pdData.put("productDiRegMethod", "01");
                pdData.put("displayMethod", "2");
                pdData.put("item1", "\uc81c\ud488 \ud558\uc790\uac00 \uc544\ub2cc \uc18c\ube44\uc790\uc758 \ub2e8\uc21c \ubcc0\uc2ec, \ucc29\uc624 \uad6c\ub9e4\uc5d0 \ub530\ub978 \uccad\uc57d \ucca0\ud68c\uac00 \ubd88\uac00\ub2a5\ud55c \uacbd\uc6b0 \uadf8 \uad6c\uccb4\uc801\uc778 \uc0ac\uc720\uc640 \uadfc\uac70");
                pdData.put("itemDetail1", "\uc804\uc790\uc0c1\uac70\ub798\ub4f1\uc5d0\uc11c\uc758 \uc18c\ube44\uc790\ubcf4\ud638\uc5d0 \uad00\ud55c \ubc95\ub960 \uc81c 17\uc870 \uc81c2\ud56d\uc5d0 \uc758\ud55c \uccad\uc57d\ucca0\ud68c \uc81c\ud55c \uc0ac\uc720\uc5d0 \ud574\ub2f9\ud558\ub294 \uacbd\uc6b0");
                pdData.put("itemDetailEx1", "\uc804\uc790\uc0c1\uac70\ub798\ub4f1\uc5d0\uc11c\uc758 \uc18c\ube44\uc790\ubcf4\ud638\uc5d0 \uad00\ud55c \ubc95\ub960 \uc81c 17\uc870 \uc81c2\ud56d\uc5d0 \uc758\ud55c \uccad\uc57d\ucca0\ud68c \uc81c\ud55c \uc0ac\uc720\uc5d0 \ud574\ub2f9\ud558\ub294 \uacbd\uc6b0");
                pdData.put("isDisplayEachDetailDesc1", "0");
                pdData.put("item2", "\uc0c1\ud488\uc758 \uad50\ud658/\ubc18\ud488/\ubcf4\uc99d \uc870\uac74 \ubc0f \ud488\uc9c8 \ubcf4\uc99d \uae30\uc900");
                pdData.put("itemDetail2", "\uad50\ud658/\ubc18\ud488/\ubcf4\uc99d \uc870\uac74 \ubc0f \ud488\uc9c8\ubcf4\uc99d \uae30\uc900\uc740 '\uc18c\ube44\uc790 \uae30\ubcf8\ubc95'\uc5d0 \ub530\ub978 \uc18c\ube44\uc790\ubd84\uc7c1 \ud574\uacb0 \uae30\uc900\uc5d0 \ub530\ub77c \ubcf4\uc0c1");
                pdData.put("itemDetailEx2", "\uad50\ud658/\ubc18\ud488/\ubcf4\uc99d \uc870\uac74 \ubc0f \ud488\uc9c8\ubcf4\uc99d \uae30\uc900\uc740 '\uc18c\ube44\uc790 \uae30\ubcf8\ubc95'\uc5d0 \ub530\ub978 \uc18c\ube44\uc790\ubd84\uc7c1 \ud574\uacb0 \uae30\uc900\uc5d0 \ub530\ub77c \ubcf4\uc0c1");
                pdData.put("isDisplayEachDetailDesc2", "0");
                pdData.put("item3", "\uc18c\ube44\uc790\ud53c\ud574 \ubcf4\uc0c1\uc758 \ucc98\ub9ac, \uc7ac\ud654\ub4f1\uc5d0 \ub300\ud55c \ubd88\ub9cc \ucc98\ub9ac \ubc0f \uc18c\ube44\uc790\uc640 \uc0ac\uc5c5\uc790 \uc0ac\uc774\uc758 \ubd84\uc7c1 \ucc98\ub9ac\uc5d0 \uad00\ud55c \uc0ac\ud56d");
                pdData.put("itemDetail3", "\ubcf8 \uc0c1\ud488\uc740 \uc18c\ube44\uc790 \ubd84\uc7c1 \ud574\uacb0 \uae30\uc900(\uacf5\uc815\uac70\ub798 \uc704\uc6d0\ud68c \uace0\uc2dc)\uc5d0 \ub530\ub77c \ud53c\ud574\ub97c \ubcf4\uc0c1\ubc1b\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
                pdData.put("itemDetailEx3", "\ubcf8 \uc0c1\ud488\uc740 \uc18c\ube44\uc790 \ubd84\uc7c1 \ud574\uacb0 \uae30\uc900(\uacf5\uc815\uac70\ub798 \uc704\uc6d0\ud68c \uace0\uc2dc)\uc5d0 \ub530\ub77c \ud53c\ud574\ub97c \ubcf4\uc0c1\ubc1b\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
                pdData.put("isDisplayEachDetailDesc3", "0");
                pdData.put("item4", "\uac70\ub798\uc5d0 \uad00\ud55c \uc57d\uad00\uc758 \ub0b4\uc6a9 \ub610\ub294 \ud655\uc778\ud560 \uc218 \uc788\ub294 \ubc29\ubc95");
                pdData.put("itemDetail4", "\uc0c1\ud488 \uc0c1\uc138\ud398\uc774\uc9c0 \ub0b4\uc6a9 \ubc0f \ud398\uc774\uc9c0 \ud558\ub2e8\uc758 \uc774\uc6a9\uc57d\uad00 \ub9c1\ud06c \ucc38\uc870");
                pdData.put("itemDetailEx4", "\uc0c1\ud488 \uc0c1\uc138\ud398\uc774\uc9c0 \ub0b4\uc6a9 \ubc0f \ud398\uc774\uc9c0 \ud558\ub2e8\uc758 \uc774\uc6a9\uc57d\uad00 \ub9c1\ud06c \ucc38\uc870");
                pdData.put("isDisplayEachDetailDesc4", "0");
            } else {
                pdData.put("productDiRegMethod", "01");
                pdData.put("displayMethod", "2");
                pdData.put("item1", "\uc81c\ud488 \ud558\uc790\uac00 \uc544\ub2cc \uc18c\ube44\uc790\uc758 \ub2e8\uc21c \ubcc0\uc2ec, \ucc29\uc624 \uad6c\ub9e4\uc5d0 \ub530\ub978 \uccad\uc57d \ucca0\ud68c\uac00 \ubd88\uac00\ub2a5\ud55c \uacbd\uc6b0 \uadf8 \uad6c\uccb4\uc801\uc778 \uc0ac\uc720\uc640 \uadfc\uac70");
                pdData.put("itemDetail1", "\uc804\uc790\uc0c1\uac70\ub798\ub4f1\uc5d0\uc11c\uc758 \uc18c\ube44\uc790\ubcf4\ud638\uc5d0 \uad00\ud55c \ubc95\ub960 \uc81c 17\uc870 \uc81c2\ud56d\uc5d0 \uc758\ud55c \uccad\uc57d\ucca0\ud68c \uc81c\ud55c \uc0ac\uc720\uc5d0 \ud574\ub2f9\ud558\ub294 \uacbd\uc6b0");
                pdData.put("itemDetailEx1", "\uc804\uc790\uc0c1\uac70\ub798\ub4f1\uc5d0\uc11c\uc758 \uc18c\ube44\uc790\ubcf4\ud638\uc5d0 \uad00\ud55c \ubc95\ub960 \uc81c 17\uc870 \uc81c2\ud56d\uc5d0 \uc758\ud55c \uccad\uc57d\ucca0\ud68c \uc81c\ud55c \uc0ac\uc720\uc5d0 \ud574\ub2f9\ud558\ub294 \uacbd\uc6b0");
                pdData.put("isDisplayEachDetailDesc1", "0");
                pdData.put("item2", "\uc0c1\ud488\uc758 \uad50\ud658/\ubc18\ud488/\ubcf4\uc99d \uc870\uac74 \ubc0f \ud488\uc9c8 \ubcf4\uc99d \uae30\uc900");
                pdData.put("itemDetail2", "\uad50\ud658/\ubc18\ud488/\ubcf4\uc99d \uc870\uac74 \ubc0f \ud488\uc9c8\ubcf4\uc99d \uae30\uc900\uc740 '\uc18c\ube44\uc790 \uae30\ubcf8\ubc95'\uc5d0 \ub530\ub978 \uc18c\ube44\uc790\ubd84\uc7c1 \ud574\uacb0 \uae30\uc900\uc5d0 \ub530\ub77c \ubcf4\uc0c1");
                pdData.put("itemDetailEx2", "\uad50\ud658/\ubc18\ud488/\ubcf4\uc99d \uc870\uac74 \ubc0f \ud488\uc9c8\ubcf4\uc99d \uae30\uc900\uc740 '\uc18c\ube44\uc790 \uae30\ubcf8\ubc95'\uc5d0 \ub530\ub978 \uc18c\ube44\uc790\ubd84\uc7c1 \ud574\uacb0 \uae30\uc900\uc5d0 \ub530\ub77c \ubcf4\uc0c1");
                pdData.put("isDisplayEachDetailDesc2", "0");
                pdData.put("item3", "\uc18c\ube44\uc790\ud53c\ud574 \ubcf4\uc0c1\uc758 \ucc98\ub9ac, \uc7ac\ud654\ub4f1\uc5d0 \ub300\ud55c \ubd88\ub9cc \ucc98\ub9ac \ubc0f \uc18c\ube44\uc790\uc640 \uc0ac\uc5c5\uc790 \uc0ac\uc774\uc758 \ubd84\uc7c1 \ucc98\ub9ac\uc5d0 \uad00\ud55c \uc0ac\ud56d");
                pdData.put("itemDetail3", "\ubcf8 \uc0c1\ud488\uc740 \uc18c\ube44\uc790 \ubd84\uc7c1 \ud574\uacb0 \uae30\uc900(\uacf5\uc815\uac70\ub798 \uc704\uc6d0\ud68c \uace0\uc2dc)\uc5d0 \ub530\ub77c \ud53c\ud574\ub97c \ubcf4\uc0c1\ubc1b\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
                pdData.put("itemDetailEx3", "\ubcf8 \uc0c1\ud488\uc740 \uc18c\ube44\uc790 \ubd84\uc7c1 \ud574\uacb0 \uae30\uc900(\uacf5\uc815\uac70\ub798 \uc704\uc6d0\ud68c \uace0\uc2dc)\uc5d0 \ub530\ub77c \ud53c\ud574\ub97c \ubcf4\uc0c1\ubc1b\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
                pdData.put("isDisplayEachDetailDesc3", "0");
                pdData.put("item4", "\uac70\ub798\uc5d0 \uad00\ud55c \uc57d\uad00\uc758 \ub0b4\uc6a9 \ub610\ub294 \ud655\uc778\ud560 \uc218 \uc788\ub294 \ubc29\ubc95");
                pdData.put("itemDetail4", "\uc0c1\ud488 \uc0c1\uc138\ud398\uc774\uc9c0 \ub0b4\uc6a9 \ubc0f \ud398\uc774\uc9c0 \ud558\ub2e8\uc758 \uc774\uc6a9\uc57d\uad00 \ub9c1\ud06c \ucc38\uc870");
                pdData.put("itemDetailEx4", "\uc0c1\ud488 \uc0c1\uc138\ud398\uc774\uc9c0 \ub0b4\uc6a9 \ubc0f \ud398\uc774\uc9c0 \ud558\ub2e8\uc758 \uc774\uc6a9\uc57d\uad00 \ub9c1\ud06c \ucc38\uc870");
                pdData.put("isDisplayEachDetailDesc4", "0");
            }
        }
        catch (Exception e) {
            throw new Exception("\uac70\ub798\uc815\ubcf4 \ub4f1\ub85d\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private void etc(Map<String, String> pdData, ProductDTO dto, Map<String, String> cookies) throws Exception {
        try {
            String sellerCd = this.getSellerCd(cookies);
            if (sellerCd.equals("")) {
                throw new Exception("\ud68c\uc6d0\uc815\ubcf4\ub97c \uc870\ud68c\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
            }
            pdData.put("sellerCd", sellerCd);
            pdData.put("enterType", "01");
            pdData.put("productCd", dto.getShopprodno());
            pdData.put("productViewCd", dto.getShopprodno());
            pdData.put("originSellingPrice", dto.getGoods_price());
            pdData.put("isSaveType", "2");
            pdData.put("isSaveSubmit", "true");
            pdData.put("page", "0");
            pdData.put("regMethodType", "01");
            pdData.put("modifyMethodType", "01");
        }
        catch (Exception e) {
            throw new Exception("\uae30\ud0c0\uc815\ubcf4 \ub4f1\ub85d\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4." + e);
        }
    }

    private String getSellerCd(Map<String, String> cookies) throws Exception {
        String sellerCd = "";
        try {
            Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/member/seller/detailBasic?step=1").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.45 Safari/537.36").data("Host", "scm.smelchi.com").cookies(cookies).method(Connection.Method.GET).followRedirects(true).ignoreHttpErrors(true).execute();
            Document body = Jsoup.parseBodyFragment((String)response.body());
            Elements elementSellerCd = body.select("#table_style03-2 > tbody > tr:nth-child(2) > td:nth-child(4) > span");
            sellerCd = elementSellerCd.text();
        }
        catch (Exception e) {
            throw new Exception("\ud310\ub9e4\uc790\ucf54\ub4dc\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4." + e);
        }
        return sellerCd;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void productCheck(Map<String, String> cookies, ProductDTO dto, Connection.Response response, List<String> strImages, ShopMelchiAdditionalDto dtllist) throws InterruptedException, Exception {
        String body = response.body();
        Thread.sleep(5000L);
        if (!body.contains("HTTP Status 500")) {
            dto.setResult_code("-1");
            return;
        }
        String companyGoodsCd = dto.getCompayny_goods_cd();
        String prodNo = MelchiExitsProductCd.get().getisExistsProdNo(companyGoodsCd, cookies);
        if (!prodNo.equals("")) {
            dto.setShopprodno(prodNo);
            this.registerImgAndNotice(dto, strImages, prodNo, dtllist);
            dto.setResult_code("1");
            return;
        }
        Thread.sleep(5000L);
        prodNo = MelchiExitsProductCd.get().getisExistsProdNo(companyGoodsCd, cookies);
        if (!prodNo.equals("")) {
            dto.setShopprodno(prodNo);
            dto.setResult_code("1");
            return;
        }
        Thread.sleep(5000L);
        prodNo = MelchiExitsProductCd.get().getisExistsProdNo(companyGoodsCd, cookies);
        if (!prodNo.equals("")) {
            dto.setShopprodno(prodNo);
            dto.setResult_code("1");
            return;
        }
        dto.setResult_code("-1");
        throw new Exception("\uc811\uc18d\ud558\uc5ec \ub4f1\ub85d\uc0c1\ud0dc\ub97c \ud655\uc778\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4. \r\n case 1. \ub9cc\uc57d \uc1fc\ud551\ubab0\uc5d0\ub294 \uc815\uc0c1 \ub4f1\ub85d \ub418\uc5c8\ub2e4\uba74 \uc1fc\ud551\ubab0 \uc0ad\uc81c\ud6c4 \ub2e4\uc2dc \ub4f1\ub85d \ubc14\ub78d\ub2c8\ub2e4.\r\ncase 2. \ub9cc\uc57d \uc1fc\ud551\ubab0\uc5d0 \ub4f1\ub85d\ub418\uc9c0 \ubabb\ud588\ub2e4\uba74 \uc0ac\uc774\ud2b8 \uc811\uc18d \uacfc\ubd80\ud654\ub85c \uc778\ud574 \uc7a0\uc2dc\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d \ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4. ");
    }

    private void registerImgAndNotice(ProductDTO dto, List<String> strImages, String prodNo, ShopMelchiAdditionalDto dtllist) throws InterruptedException, Exception {
        String image = strImages.get(0);
        String imgPath = ShopCommon.getImgLocalPath2(image);
        this.shopOptionDtos = this.getProductOptions(dto);
        String url = "https://scm.smelchi.com/login";
        ChromeDriver driver = ChromeExtention.getInstace().getDriver(false);
        driver.get(url);
        WebElement id = driver.findElement(By.id((String)"j_username"));
        id.sendKeys(new CharSequence[]{"kdjsystem01"});
        WebElement pword = driver.findElement(By.id((String)"j_password"));
        pword.sendKeys(new CharSequence[]{"rnrdyd7564!!"});
        WebElement submit = driver.findElement(By.cssSelector((String)"#loginForm > fieldset > div.login-form > button"));
        submit.submit();
        driver.executeScript("location.href='https://scm.smelchi.com/product/register/list/list'", new Object[]{""});
        Thread.sleep(500L);
        WebElement prodNoSearch = driver.findElement(By.cssSelector((String)"#searchOptionalValue"));
        prodNoSearch.sendKeys(new CharSequence[]{prodNo});
        WebElement prodSearch = driver.findElement(By.cssSelector((String)"#btn_search"));
        prodSearch.click();
        Thread.sleep(500L);
        WebElement detailView = driver.findElement(By.cssSelector((String)"#table_style04 > tbody > tr:nth-child(3) > td:nth-child(13) > button"));
        detailView.click();
        if (this.shopOptionDtos.size() > 0) {
            this.Options(dto, prodNo, driver, dtllist);
        }
        WebElement imgUpload = driver.findElement(By.id((String)"files"));
        imgUpload.sendKeys(new CharSequence[]{imgPath});
        WebElement modify = driver.findElement(By.id((String)"btn_save2"));
        modify.click();
        Thread.sleep(500L);
        driver.close();
    }

    private void Options(ProductDTO dto, String prodNo, ChromeDriver driver, ShopMelchiAdditionalDto dtllist) {
        driver.executeScript("window.open()", new Object[0]);
        ArrayList tabList = new ArrayList(driver.getWindowHandles());
        driver.switchTo().window((String)tabList.get(1)).navigate().to("https://scm.smelchi.com/product/register/editOptionForm?productCd=" + prodNo + "&isSaveType=1");
        List<ShopOptionDto> option_s_in = this.getProductInOptions(dto);
        this.shopOptionDtos = this.getProductOptions(dto);
        ArrayList<ShopOptionDto> addOptions = new ArrayList<ShopOptionDto>();
        ArrayList<ShopOptionDto> modifyOptions = new ArrayList<ShopOptionDto>();
        for (ShopOptionDto optDto : this.shopOptionDtos) {
            ShopOptionDto shopOption = option_s_in.stream().filter(p -> p.getOptcompanycd().equals(optDto.getOptcompanycd())).findAny().orElse(null);
            if (shopOption != null) {
                optDto.setSellerProductItemId(shopOption.getSellerProductItemId());
                modifyOptions.add(optDto);
                continue;
            }
            addOptions.add(optDto);
        }
        if (modifyOptions.size() > 0) {
            this.setModifyOptlist(modifyOptions, dto, driver, dtllist);
        }
        if (addOptions.size() > 0) {
            this.setAddOptlist(addOptions, dto, modifyOptions.size() + 1, driver, dtllist);
        }
        WebElement optModify = driver.findElement(By.cssSelector((String)"#btn_save"));
        optModify.click();
        driver.switchTo().alert().accept();
        driver.close();
        driver.switchTo().window((String)tabList.get(0));
    }

    private void setModifyOptlist(List<ShopOptionDto> modifyOptions, ProductDTO dto, ChromeDriver driver, ShopMelchiAdditionalDto dtllist) {
        int i = 1;
        String addOptionLeftNm = "";
        String addOptionRightNm = "";
        if (dtllist.getAddoptionlb().equals("Y")) {
            addOptionLeftNm = dtllist.getAddOptionL();
        }
        if (dtllist.getAddoptionrb().equals("Y")) {
            addOptionRightNm = dtllist.getAddOptionR();
        }
        for (ShopOptionDto shopOptionDto : modifyOptions) {
            WebElement optVal;
            String countNum = Integer.toString(i++);
            List<String> names = Arrays.asList(shopOptionDto.getOptspecdes().split(":"));
            if (names.size() > 1) {
                optVal = driver.findElement(By.cssSelector((String)("#span_optionItemNo_" + countNum + " > p > #optionItem")));
                optVal.clear();
                optVal.sendKeys(new CharSequence[]{String.valueOf(addOptionLeftNm) + names.get(0) + addOptionRightNm});
                WebElement optVal2 = driver.findElement(By.cssSelector((String)("#span_optionItemDetailNo_" + countNum + " > p > #optionItemDetail")));
                optVal2.clear();
                optVal2.sendKeys(new CharSequence[]{String.valueOf(addOptionLeftNm) + names.get(1) + addOptionRightNm});
                WebElement optPrice = driver.findElement(By.cssSelector((String)("#span_optionPriceNo_" + countNum + " > p > #optionPrice")));
                optPrice.clear();
                optPrice.sendKeys(new CharSequence[]{shopOptionDto.getAmt()});
                WebElement optQty = driver.findElement(By.cssSelector((String)("#span_optionQtyNo_" + countNum + " > p > #optionQty")));
                optQty.clear();
                optQty.sendKeys(new CharSequence[]{shopOptionDto.getCnt()});
                if (!shopOptionDto.getCnt().equals("0")) continue;
                WebElement optSaleYn = driver.findElement(By.cssSelector((String)("#span_isAvaNo_" + countNum + " > p > span:nth-child(2) > #radio_isAva_2")));
                optSaleYn.click();
                continue;
            }
            optVal = driver.findElement(By.cssSelector((String)("#span_optionItemNo_" + countNum + " > p > #optionItem")));
            optVal.clear();
            optVal.sendKeys(new CharSequence[]{String.valueOf(addOptionLeftNm) + names.get(0) + addOptionRightNm});
            WebElement optPrice = driver.findElement(By.cssSelector((String)("#span_optionPriceNo_" + countNum + " > p > #optionPrice")));
            optPrice.clear();
            optPrice.sendKeys(new CharSequence[]{shopOptionDto.getAmt()});
            WebElement optQty = driver.findElement(By.cssSelector((String)("#span_optionQtyNo_" + countNum + " > p > #optionQty")));
            optQty.clear();
            optQty.sendKeys(new CharSequence[]{shopOptionDto.getCnt()});
            if (!shopOptionDto.getCnt().equals("0")) continue;
            WebElement optSaleYn = driver.findElement(By.cssSelector((String)("#span_isAvaNo_" + countNum + " > p > span:nth-child(2) > #radio_isAva_2")));
            optSaleYn.click();
        }
    }

    private void setAddOptlist(List<ShopOptionDto> addOptions, ProductDTO dto, int i, ChromeDriver driver, ShopMelchiAdditionalDto dtllist) {
        String countNum = Integer.toString(i++);
        String addOptionLeftNm = "";
        String addOptionRightNm = "";
        if (dtllist.getAddoptionlb().equals("Y")) {
            addOptionLeftNm = dtllist.getAddOptionL();
        }
        if (dtllist.getAddoptionrb().equals("Y")) {
            addOptionRightNm = dtllist.getAddOptionR();
        }
        for (ShopOptionDto shopOptionDto : addOptions) {
            WebElement optVal;
            WebElement optAdd;
            List<String> names = Arrays.asList(shopOptionDto.getOptspecdes().split(":"));
            if (names.size() > 1) {
                optAdd = driver.findElement(By.cssSelector((String)"#btn_addOptionItem"));
                optAdd.click();
                optVal = driver.findElement(By.cssSelector((String)("#span_optionItemNo_" + countNum + " > p > #optionItem")));
                optVal.clear();
                optVal.sendKeys(new CharSequence[]{String.valueOf(addOptionLeftNm) + names.get(0) + addOptionRightNm});
                WebElement optVal2 = driver.findElement(By.cssSelector((String)("#span_optionItemDetailNo_" + countNum + " > p > #optionItemDetail")));
                optVal2.clear();
                optVal2.sendKeys(new CharSequence[]{String.valueOf(addOptionLeftNm) + names.get(1) + addOptionRightNm});
                WebElement optPrice = driver.findElement(By.cssSelector((String)("#span_optionPriceNo_" + countNum + " > p > #optionPrice")));
                optPrice.clear();
                optPrice.sendKeys(new CharSequence[]{shopOptionDto.getAmt()});
                WebElement optQty = driver.findElement(By.cssSelector((String)("#span_optionQtyNo_" + countNum + " > p > #optionQty")));
                optQty.clear();
                optQty.sendKeys(new CharSequence[]{shopOptionDto.getCnt()});
                continue;
            }
            optAdd = driver.findElement(By.cssSelector((String)"#btn_addOptionItem"));
            optAdd.click();
            optVal = driver.findElement(By.cssSelector((String)("#span_optionItemNo_" + countNum + " > p > #optionItem")));
            optVal.clear();
            optVal.sendKeys(new CharSequence[]{String.valueOf(addOptionLeftNm) + names.get(0) + addOptionRightNm});
            WebElement optPrice = driver.findElement(By.cssSelector((String)("#span_optionPriceNo_" + countNum + " > p > #optionPrice")));
            optPrice.clear();
            optPrice.sendKeys(new CharSequence[]{shopOptionDto.getAmt()});
            WebElement optQty = driver.findElement(By.cssSelector((String)("#span_optionQtyNo_" + countNum + " > p > #optionQty")));
            optQty.clear();
            optQty.sendKeys(new CharSequence[]{shopOptionDto.getCnt()});
        }
    }

    private void Notice(ProductDTO dto, ChromeDriver driver) throws Exception {
        ArrayList<String> propValLst = new ArrayList<String>();
        ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
        List<ShopProdAttrnmDto> melchiPdAttrList = ShopProductDao.get().getProductMelchiNotice(dto.getProp1_cd(), "shop0106");
        for (ShopProdAttrnmDto melchiPdAttr : melchiPdAttrList) {
            ShopProdAttrnmDto shopProdAttrnmDtos = dto.getShopProdAttrnmDtos().stream().filter(p -> p.getAttrnm().contains(melchiPdAttr.getAttrvl())).findAny().orElse(null);
            if (shopProdAttrnmDtos != null) {
                if (shopProdAttrnmDtos.equals(null)) {
                    shopProdAttrnmDtos.setProp_val("\uc0c1\uc138\uc124\uba85 \ubcc4\ub3c4 \ud45c\uae30");
                    continue;
                }
                propValLst.add(shopProdAttrnmDtos.getProp_val());
                continue;
            }
            propValLst.add("\uc0c1\uc138\uc124\uba85 \ubcc4\ub3c4 \ud45c\uae30");
        }
        int i = 5;
        WebElement notiView = driver.findElement(By.id((String)"btn_notify"));
        notiView.click();
        int j = 0;
        while (j < melchiPdAttrList.size()) {
            WebElement notiExbtn = driver.findElement(By.cssSelector((String)("#table_style04 > tbody > tr:nth-child(" + Integer.toString(i) + ") > td > #isDisplayCheck")));
            notiExbtn.click();
            WebElement notiVal = driver.findElement(By.cssSelector((String)("#table_style04 > tbody > tr:nth-child(" + Integer.toString(i) + ") > td > #itemContents")));
            notiVal.sendKeys(new CharSequence[]{(CharSequence)propValLst.get(j)});
            ++i;
            ++i;
            ++j;
        }
    }

    private boolean setProductStop(ProductDTO prodInfo, Map<String, String> cookies) throws Exception {
        Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/product/register/changeStatus.json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.45 Safari/537.36").header("Host", "scm.smelchi.com").cookies(cookies).data("field", "status").data("status", "03").data("productCds", prodInfo.getShopprodno()).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        YDMAStringUtil.Print(response);
        Thread.sleep(25000L);
        String prodNo = MelchiExitsProductCd.get().isSoldOutcheck(prodInfo.getCompayny_goods_cd(), cookies);
        if (prodNo.equals("")) {
            prodInfo.setResult_code("-1");
            return false;
        }
        prodInfo.setResult_code("1");
        return true;
    }

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto) throws Exception {
        boolean flag = true;
        String shopInfoLog = String.format("[%s - %s(%s)]", dto.getSHOPINFO().getSHOPNM(), dto.getSHOPINFO().getSHOPPINGID(), dto.getSHOPINFO().getNICKNM1());
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 3000: 
                case 4000: {
                    flag = this.setProductStop(dto.getPRODUCT(), dto.getCOOKIES());
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, dto.getPRODUCT(), "\ud488\uc808", dto.getSHOPINFO(), "\uc131\uacf5", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud488\uc808 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    Thread.sleep(1000L);
                }
            }
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        return null;
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String logType) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackAndLogForProdIn(comment, 50, prodInfo, shoppingmallDTO, "YEL_DEL", jobResult, logType);
    }
}

