/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.TimeUtils;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dao.CategoryDAO;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.data.dao.ShopAddProdInfoDto;
import com.kdjsystem.mlink.yellim.data.dao.ShoppingMallDao;
import com.kdjsystem.mlink.yellim.dto.CategoryDTO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductAddProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductAddProcess;
import com.kdjsystem.mlink.yellim.helper.DateHelper;
import com.kdjsystem.mlink.yellim.helper.JsonHelper;
import com.kdjsystem.mlink.yellim.helper.ServiceHelper;
import com.kdjsystem.mlink.yellim.shop.common.CaffeineCategoryCache;
import com.kdjsystem.mlink.yellim.shop.common.ChromeExtention;
import com.kdjsystem.mlink.yellim.shop.common.ChromeScript;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinShopDao;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAddDialog;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class NaverStoreProductAddService
implements IProductAddProcess {
    Map<String, String> cookie;
    int companyGoodsCd = 0;
    int cnt = 0;

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto) throws Exception {
        boolean flag = true;
        int page = -1;
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        try {
            while (flag) {
                String json = this.getJson(dto.getSTART_DATE(), dto.getEND_DATE(), ++page);
                JsonParser parser = new JsonParser();
                Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/list/search").cookies(dto.getCOOKIES()).header("Host", "sell.smartstore.naver.com").header("Connection", "keep-alive").header("x-to-statename", "main.product.origin-list").header("Pragma", "no-cache").header("Cache-Control", "no-cache").header("x-current-stateName", "main.product.origin-list").header("x-current-state", "https://sell.smartstore.naver.com/#/products/origin-list").header("Origin", "https://sell.smartstore.naver.com").header("Content-Type", "application/json;charset=UTF-8").header("Accept", "*/*").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").requestBody(json).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
                String body = response.body();
                JsonObject object = (JsonObject)parser.parse(body);
                JsonArray content = (JsonArray)object.get("content");
                if (content == null || content.size() == 0) {
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                List<String> hiddenProductIds = this.gethiddenProductId(content);
                List<String> productIds = this.getProductId(content);
                if (hiddenProductIds.size() < 100) {
                    flag = false;
                }
                if (hiddenProductIds.size() <= 0) continue;
                List<ProductDTO> responseProducts = this.getProductDetailApiSearch(hiddenProductIds, productIds, shopInfo, dto.getCOOKIES(), domemallInfos);
                this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", page + 1, responseProducts.size()), 0);
                for (ProductDTO product2 : responseProducts) {
                    int ret;
                    if (ProductAddDialog.getIsCanceled()) {
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                    if (copyProduct == null) {
                        ret = ProductDAO.get().insertProductInfo(product2);
                        if (ret == 1) {
                            infoRet += ret;
                            String comment = String.format(" %s [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                            this.setValueAndLogForProdInfo(comment, 50, product2, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                        }
                    } else {
                        copyProduct.setClass_cd3(product2.getClass_cd3());
                        copyProduct.setShop_cid_info(product2.getShop_cid_info());
                        ret = ProductDAO.get().updateProductInfo(copyProduct);
                        if (ret == 1) {
                            infoRet += ret;
                            String comment = String.format(" %s [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                            this.setValueAndLogForProdInfo(comment, 50, product2, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488 \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                        }
                    }
                    copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                    ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                    if (copyProductIn == null) {
                        product2.setPRODSEQ(copyProduct.getPRODSEQ());
                        int ret2 = ProductDAO.get().insertProductIn(product2);
                        if (ret2 == 1) {
                            inRet += ret2;
                            String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                            this.setValueAndLogForProdIn(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                        }
                    } else {
                        copyProductIn.setClass_cd3(product2.getClass_cd3());
                        copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                        copyProductIn.setGoods_nm(product2.getGoods_nm());
                        copyProductIn.setShopprodno(product2.getShopprodno());
                        copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                        copyProductIn.setSaleenddt(product2.getSaleenddt());
                        copyProductIn.setMarket_price(product2.getMarket_price());
                        copyProductIn.setGoods_price(product2.getGoods_price());
                        copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                        copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                        copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                        copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                        copyProductIn.setStatus(product2.getStatus());
                        copyProductIn.setSendstats(product2.getSendstats());
                        String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                        copyProductIn.setGoods_keyword(codeDivision);
                        int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                        if (ret3 == 1) {
                            inRet += ret3;
                            String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                            this.setValueAndLogForProdIn(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488 \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                        }
                    }
                    copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                    if (product2.getOPTIONS() == null) continue;
                    for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                        ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                        if (copyOption == null) {
                            option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                            option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                            ProductDAO.get().insertOptProductInfo(option2);
                        } else {
                            copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                            copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOption.setOPTEA(option2.getOPTEA());
                            copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOption.setINSERTDT(option2.getINSERTDT());
                            copyOption.setINSERTID(option2.getINSERTID());
                            copyOption.setMODIFYDT(option2.getMODIFYDT());
                            copyOption.setSTATUS(option2.getSTATUS());
                        }
                        ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                        if (copyOptionIn == null) {
                            option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                            option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                            ProductDAO.get().insertOptProductIn(option2);
                            continue;
                        }
                        copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                        copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                        copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                        copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                        copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                        copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                        copyOptionIn.setOPTEA(option2.getOPTEA());
                        copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                        copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                        copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                        copyOptionIn.setINSERTDT(option2.getINSERTDT());
                        copyOptionIn.setINSERTID(option2.getINSERTID());
                        copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                        copyOptionIn.setSTATUS(option2.getSTATUS());
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String errorMessage = ex.getMessage() != null ? ex.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
            this.setValue("--------------------------------------------------------------------------------------", 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto, List<String> specificCodes) throws Exception {
        boolean flag = true;
        int page = 0;
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        try {
            while (flag) {
                String json = this.getJsonParamForSpecificCode(dto.getSTART_DATE(), dto.getEND_DATE(), page, specificCodes);
                JsonParser parser = new JsonParser();
                Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/list/search").cookies(dto.getCOOKIES()).header("Host", "sell.smartstore.naver.com").header("Connection", "keep-alive").header("x-to-stateName", "main.product.origin-list").header("Pragma", "no-cache").header("Cache-Control", "no-cache").header("x-current-stateName", "main.product.origin-list").header("x-current-state", "https://sell.smartstore.naver.com/#/products/origin-list").header("Origin", "https://sell.smartstore.naver.com").header("Content-Type", "application/json;charset=UTF-8").header("Accept", "*/*").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").requestBody(json).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
                String body = response.body();
                JsonObject object = (JsonObject)parser.parse(body);
                JsonArray content = (JsonArray)object.get("content");
                if (content == null || content.size() == 0) {
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                List<String> hiddenProductIds = this.gethiddenProductId(content, specificCodes);
                List<String> productIds = this.getProductId(content, specificCodes);
                if (hiddenProductIds.size() < 100) {
                    flag = false;
                }
                if (hiddenProductIds.size() > 0) {
                    List<ProductDTO> responseProducts = this.getProductDetailApiSearch(hiddenProductIds, productIds, shopInfo, dto.getCOOKIES(), domemallInfos);
                    this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", page + 1, responseProducts.size()), 0);
                    for (ProductDTO product2 : responseProducts) {
                        int ret;
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            ret = ProductDAO.get().insertProductInfo(product2);
                            if (ret == 1) {
                                String comment = String.format(" %s [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                this.setValueAndLogForProdInfo(comment, 50, product2, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                            }
                        } else {
                            copyProduct.setClass_cd3(product2.getClass_cd3());
                            copyProduct.setShop_cid_info(product2.getShop_cid_info());
                            ret = ProductDAO.get().updateProductInfo(copyProduct);
                            if (ret == 1) {
                                infoRet += ret;
                                String comment = String.format(" %s [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                this.setValueAndLogForProdInfo(comment, 50, product2, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488 \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product2.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret2 = ProductDAO.get().insertProductIn(product2);
                            if (ret2 == 1) {
                                inRet += ret2;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                this.setValueAndLogForProdIn(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                            }
                        } else {
                            copyProductIn.setClass_cd3(product2.getClass_cd3());
                            copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                            copyProductIn.setGoods_nm(product2.getGoods_nm());
                            copyProductIn.setShopprodno(product2.getShopprodno());
                            copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product2.getSaleenddt());
                            copyProductIn.setMarket_price(product2.getMarket_price());
                            copyProductIn.setGoods_price(product2.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                            copyProductIn.setStatus(product2.getStatus());
                            copyProductIn.setSendstats(product2.getSendstats());
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                            if (ret3 == 1) {
                                inRet += ret3;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                this.setValueAndLogForProdIn(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc610\ub9bc \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488 \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product2.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                                ProductDAO.get().updateOptProductInfo(copyOption);
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                            ProductDAO.get().updateOptProductIn(copyOptionIn);
                        }
                    }
                }
                ++page;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String errorMessage = ex.getMessage() != null ? ex.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
            this.setValue("--------------------------------------------------------------------------------------", 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    private List<String> gethiddenProductId(JsonArray datas) {
        ArrayList<String> hiddenProductId = new ArrayList<String>();
        int i = 0;
        while (i < datas.size()) {
            JsonObject obj = (JsonObject)datas.get(i);
            String productId = obj.get("id").getAsString();
            hiddenProductId.add(productId);
            ++i;
        }
        return hiddenProductId;
    }

    private List<String> gethiddenProductId(JsonArray datas, List<String> specificCodes) {
        ArrayList<String> hiddenProductId = new ArrayList<String>();
        int i = 0;
        while (i < datas.size()) {
            JsonObject obj = (JsonObject)datas.get(i);
            String productId = obj.get("id").getAsString();
            if (specificCodes.size() > 0) {
                String specificCode = specificCodes.stream().filter(p -> p.equals(obj.get("sellerManagementCode").getAsString())).findFirst().orElse("");
                if (!specificCode.equals("")) {
                    hiddenProductId.add(productId);
                }
            } else {
                hiddenProductId.add(productId);
            }
            ++i;
        }
        return hiddenProductId;
    }

    private List<String> getProductId(JsonArray datas) {
        ArrayList<String> productId = new ArrayList<String>();
        int i = 0;
        while (i < datas.size()) {
            JsonObject obj = (JsonObject)datas.get(i);
            String prdId = obj.get("storefarmChannelProductNo").getAsString();
            productId.add(prdId);
            ++i;
        }
        return productId;
    }

    private List<String> getProductId(JsonArray datas, List<String> specificCodes) {
        ArrayList<String> productId = new ArrayList<String>();
        int i = 0;
        while (i < datas.size()) {
            JsonObject obj = (JsonObject)datas.get(i);
            String prdId = obj.get("storefarmChannelProductNo").getAsString();
            if (specificCodes.size() > 0) {
                String specificCode = specificCodes.stream().filter(p -> p.equals(obj.get("sellerManagementCode").getAsString())).findFirst().orElse("");
                if (!specificCode.equals("")) {
                    productId.add(prdId);
                }
            } else {
                productId.add(prdId);
            }
            ++i;
        }
        return productId;
    }

    private String getSellerId(Map<String, String> cookies) {
        String sellerId = "";
        try {
            Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/sellers/account?maskApplyTypes=MEMBER&maskApplyTypes=SETTLEMENT").cookies(cookies).header("Host", "smartstore.naver.com").method(Connection.Method.GET).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            JsonParser parser = new JsonParser();
            JsonObject body = parser.parse(response.body()).getAsJsonObject();
            JsonObject defaultChannel = body.get("defaultChannel").getAsJsonObject();
            sellerId = defaultChannel.get("url").getAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sellerId;
    }

    private List<ProductDTO> getProductDetailApiSearch(List<String> hiddenProductIds, List<String> productIds, ShoppingmallDTO shopInfo, Map<String, String> cookies, List<DomemallDTO> domemallInfos) throws Exception {
        ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        try {
            int i = 0;
            while (i < hiddenProductIds.size()) {
                if (ProductAddDialog.getIsCanceled()) {
                    return responseProducts;
                }
                String URL2 = "https://sell.smartstore.naver.com/api/products/%s";
                URL2 = String.format(URL2, hiddenProductIds.get(i));
                Connection.Response response = Jsoup.connect((String)URL2).cookies(cookies).header("Host", "sell.smartstore.naver.com").header("Connection", "keep-alive").header("x-to-stateName", "main.product.edit").header("Pragma", "no-cache").header("Cache-Control", "no-cache").header("x-current-stateName", "main.product.origin-list").header("x-current-state", "https://sell.smartstore.naver.com/#/products/edit/" + hiddenProductIds.get(i)).header("Accept", "*/*").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
                String body = response.body();
                JsonParser jsonparser = new JsonParser();
                JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
                JsonObject datas = (JsonObject)jsonobject.get("product");
                if (response.statusCode() == 200 && datas.size() > 0) {
                    try {
                        ProductDTO responseProduct = new ProductDTO();
                        responseProduct.setShopprodno(hiddenProductIds.get(i));
                        responseProduct.setNaverprdcd(productIds.get(i));
                        responseProduct.setGoods_nm(JsonHelper.jsonNullStr(datas.get("name")));
                        responseProduct.setMarket_price(JsonHelper.jsonElementNullInt(datas.get("salePrice")));
                        responseProduct.setQty(JsonHelper.jsonElementNullInt(datas.get("stockQuantity")));
                        responseProduct.setStatus(this.getStatus(JsonHelper.jsonNullStr(datas.get("statusType")).replace("\"", "")));
                        responseProduct.setSendstats(this.getSendStatus(JsonHelper.jsonNullStr(datas.get("statusType")).replace("\"", "")));
                        String saleStartDate = JsonHelper.jsonNullStr(datas.get("saleStartDate"));
                        saleStartDate = saleStartDate.substring(0, saleStartDate.indexOf(".")).replace("T", " ");
                        if (saleStartDate.equals("")) {
                            responseProduct.setInsertdt(YDMATimeUtil.getCurrentDateScheduler());
                        } else {
                            responseProduct.setInsertdt(saleStartDate);
                        }
                        String saleEndDate = JsonHelper.jsonNullStr(datas.get("saleEndDate"));
                        saleEndDate = saleEndDate.substring(0, saleEndDate.indexOf(".")).replace("T", " ");
                        responseProduct.setSaleenddt(saleEndDate);
                        JsonObject shopCategory = (JsonObject)datas.get("category");
                        CategoryDTO category = this.getCategory(shopCategory, shopInfo);
                        responseProduct.setClass_cd3(category.getCODE());
                        responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                        responseProduct.setGmcategnm(shopCategory.get("wholeCategoryName").getAsString());
                        JsonObject detailAttribute = (JsonObject)datas.get("detailAttribute");
                        JsonObject naverShoppingSearchInfo = (JsonObject)detailAttribute.get("naverShoppingSearchInfo");
                        if (naverShoppingSearchInfo == null) {
                            responseProduct.setMaker("");
                            responseProduct.setBrand_nm("");
                            responseProduct.setModel_no("");
                        }
                        JsonObject originAreaInfo = (JsonObject)detailAttribute.get("originAreaInfo");
                        responseProduct.setOrigin(JsonHelper.jsonNullStr(originAreaInfo.get("content")));
                        responseProduct.setGoods_price(JsonHelper.jsonElementNullInt(datas.get("salePrice")));
                        responseProduct.setGoods_consumer_price(JsonHelper.jsonElementNullInt(datas.get("salePrice")));
                        JsonObject sellerCodeInfo = (JsonObject)detailAttribute.get("sellerCodeInfo");
                        if (sellerCodeInfo == null) {
                            responseProduct.setCompayny_goods_cd("");
                        } else {
                            responseProduct.setCompayny_goods_cd(JsonHelper.jsonNullStr(sellerCodeInfo.get("sellerManagementCode")));
                            this.setValue(String.format(" %s [%s] \ubd88\ub7ec\uc624\ub294 \uc911..", shopInfoLog, responseProduct.getCompayny_goods_cd()), 0);
                        }
                        if (responseProduct.getCompayny_goods_cd().length() < 5) {
                            responseProduct.setCompayny_goods_cd("");
                        }
                        responseProduct.setGoods_keyword(ServiceHelper.codeDivision(responseProduct.getCompayny_goods_cd(), domemallInfos));
                        responseProduct.setChar_1_nm("\ub2e8\ud488");
                        responseProduct.setShopcd(shopInfo.getSHOPCD());
                        responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                        responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
                        responseProducts.add(responseProduct);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return responseProducts;
    }

    private CategoryDTO getCategory(JsonObject data2, ShoppingmallDTO shopInfo) {
        try {
            String code = data2.get("id").getAsString();
            String lastName = data2.get("name").getAsString();
            CategoryDTO category = CategoryDAO.get().selectShoppingMallCategory(code, lastName);
            if (category == null && (category = CategoryDAO.get().selectShoppingMallCategory(code)) == null) {
                category = CategoryDAO.get().selectCategory("350119000");
            }
            return category;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getStatus(String status2) {
        switch (status2) {
            case "UNADMISSION": 
            case "SALE": 
            case "WAIT": 
            case "REJECTION": {
                return "0";
            }
            case "OUTOFSTOCK": {
                return "1";
            }
            case "CLOSE": 
            case "SUSPENSION": 
            case "PROHIBITION": {
                return "3";
            }
        }
        return "";
    }

    private String getSendStatus(String status2) {
        switch (status2) {
            case "UNADMISSION": 
            case "WAIT": 
            case "REJECTION": {
                return String.valueOf(9000);
            }
            case "SALE": {
                return String.valueOf(8000);
            }
            case "OUTOFSTOCK": {
                return String.valueOf(4000);
            }
            case "CLOSE": 
            case "SUSPENSION": 
            case "PROHIBITION": {
                return String.valueOf(3000);
            }
        }
        return "";
    }

    private String getDeliveryType(String status2) {
        switch (status2) {
            case "FREE": {
                return "0";
            }
            case "PAID": {
                return "1";
            }
            case "UNIT_QUANTITY_PAID": {
                return "3";
            }
            case "RANGE_QUANTITY_PAID": {
                return "3";
            }
            case "CONDITIONAL_FREE": {
                return "0";
            }
        }
        return "";
    }

    private String getTax(String status2) {
        switch (status2) {
            case "TAX": {
                return "0";
            }
            case "DUTYFREE": {
                return "1";
            }
        }
        return "";
    }

    private String getKeyWord(JsonArray sellerTags) throws Exception {
        String tags = "";
        if (sellerTags != null) {
            int i = 0;
            while (i < sellerTags.size()) {
                String addtag = JsonHelper.jsonNullStr(sellerTags.get(i).getAsJsonObject().get("text"));
                if (addtag != "" && i != sellerTags.size() - 1) {
                    tags = String.valueOf(tags) + addtag + ",";
                } else if (addtag != "" && i == sellerTags.size() - 1) {
                    tags = String.valueOf(tags) + addtag;
                }
                ++i;
            }
        }
        return tags;
    }

    private void getApiImages(ProductDTO responseProduct, int k, String image) {
        switch (k) {
            case 0: {
                responseProduct.setImg_path(image);
                break;
            }
            case 1: {
                responseProduct.setImg_path1(image);
                break;
            }
            case 2: {
                responseProduct.setImg_path2(image);
                break;
            }
            case 3: {
                responseProduct.setImg_path3(image);
                break;
            }
            case 4: {
                responseProduct.setImg_path4(image);
                break;
            }
            case 5: {
                responseProduct.setImg_path5(image);
                break;
            }
            case 6: {
                responseProduct.setImg_path6(image);
                break;
            }
            case 7: {
                responseProduct.setImg_path7(image);
                break;
            }
            case 8: {
                responseProduct.setImg_path8(image);
                break;
            }
            case 9: {
                responseProduct.setImg_path9(image);
                break;
            }
            case 10: {
                responseProduct.setImg_path10(image);
            }
        }
    }

    private List<ProductOptionDTO> getOption(ProductDTO responseProduct, JsonObject datas, int price2) throws Exception {
        ArrayList<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        JsonArray options = (JsonArray)datas.get("options");
        JsonArray optionCombinations = (JsonArray)datas.get("optionCombinations");
        try {
            if (options.size() > 0 && optionCombinations.size() > 0) {
                int i = 0;
                while (i < optionCombinations.size()) {
                    JsonObject optionCombination = optionCombinations.get(i).getAsJsonObject();
                    ProductOptionDTO option2 = new ProductOptionDTO();
                    option2.setSKUSEQ(i + 1);
                    option2.setSHOPPRODNO(responseProduct.getShopprodno());
                    option2.setSHOPPRODSKU(optionCombination.get("id").getAsString());
                    option2.setSHOPPRODSKU_NM(responseProduct.getGoods_nm());
                    option2.setPRODCD(responseProduct.getCompayny_goods_cd());
                    option2.setOPTPRODCD(responseProduct.getCompayny_goods_cd().concat("-" + String.valueOf(i + 1)));
                    if (options.size() == 1) {
                        JsonObject optionObj = options.get(0).getAsJsonObject();
                        option2.setOPTPRODNM(optionObj.get("groupName").getAsString());
                        option2.setOPTSPECDES(optionCombination.get("optionName1").getAsString());
                    } else if (options.size() == 2) {
                        JsonObject optionObj1 = options.get(0).getAsJsonObject();
                        JsonObject optionObj2 = options.get(1).getAsJsonObject();
                        option2.setOPTPRODNM(optionObj1.get("groupName").getAsString().concat("/").concat(optionObj2.get("groupName").getAsString()));
                        option2.setOPTSPECDES(optionCombination.get("optionName1").getAsString().concat("/").concat(optionCombination.get("optionName2").getAsString()));
                    }
                    option2.setOPTSAFESTOCK(Integer.parseInt(responseProduct.getGoods_price()));
                    option2.setOPTVERTSTOCK(optionCombination.get("stockQuantity").getAsInt());
                    option2.setOPTADDAMT(optionCombination.get("price").getAsInt());
                    option2.setINSERTDT(responseProduct.getInsertdt());
                    option2.setINSERTID(YDMASessonUtil.getUserInfo().getUserId());
                    option2.setSTATUS(optionCombination.get("stockQuantity").getAsInt() > 0 ? "0" : "1");
                    result.add(option2);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    private String getGosiInfo(String noticetype) {
        switch (noticetype) {
            case "IMAGE_APPLIANCES": {
                return "\uc601\uc0c1\uac00\uc804(TV\ub958)";
            }
            case "HOME_APPLIANCES": {
                return "\uac00\uc815\uc6a9\uc804\uae30\uc81c\ud488(\ub0c9\uc7a5\uace0/\uc138\ud0c1\uae30/\uc2dd\uae30\uc138\ucc99\uae30/\uc804\uc790";
            }
            case "SEASON_APPLIANCES": {
                return "\uacc4\uc808\uac00\uc804(\uc5d0\uc5b4\ucee8/\uc628\ud48d\uae30)";
            }
            case "OFFICE_APPLIANCES": {
                return "\uc0ac\ubb34\uc6a9\uae30\uae30(\ucef4\ud4e8\ud130/\ub178\ud2b8\ubd81/\ud504\ub9b0\ud130)";
            }
            case "OPTICS_APPLIANCES": {
                return "\uad11\ud559\uae30\uae30(\ub514\uc9c0\ud138\uce74\uba54\ub77c/\ucea0\ucf54\ub354)";
            }
            case "MICROELECTRONICS": {
                return "\uc18c\ud615\uc804\uc790(MP3/\uc804\uc790\uc0ac\uc804 \ub4f1)";
            }
            case "NAVIGATION": {
                return "\ub0b4\ube44\uac8c\uc774\uc158";
            }
            case "CAR_ARTICLES": {
                return "\uc790\ub3d9\ucc28\uc6a9\ud488 (\uc790\ub3d9\ucc28\ubd80\ud488 / \uae30\ud0c0 \uc790\ub3d9\ucc28\uc6a9\ud488)";
            }
            case "MOBILE_COUPON": {
                return "\ubaa8\ubc14\uc77c\ucfe0\ud3f0";
            }
            case "WEAR": {
                return "\uc758\ub958";
            }
            case "SHOES": {
                return "\uad6c\ub450/\uc2e0\ubc1c";
            }
            case "BAG": {
                return "\uac00\ubc29";
            }
            case "FASHION_ITEMS": {
                return "\ud328\uc158\uc7a1\ud654(\ubaa8\uc790/\ubca8\ud2b8/\uc561\uc138\uc11c\ub9ac)";
            }
            case "SLEEPING_GEAR": {
                return "\uce68\uad6c\ub958/\ucee4\ud2bc";
            }
            case "FURNITURE": {
                return "\uac00\uad6c(\uce68\ub300/\uc18c\ud30c/\uc2f1\ud06c\ub300/DIY\uc81c\ud488";
            }
            case "COSMETIC": {
                return "\ud654\uc7a5\ud488";
            }
            case "FOOD": {
                return "\uc2dd\ud488(\ub18d\uc218\uc0b0\ubb3c)";
            }
            case "GENERAL_FOOD": {
                return "\uac00\uacf5\uc2dd\ud488";
            }
            case "DIET_FOOD": {
                return "\uac74\uac15\uae30\ub2a5\uc2dd\ud488";
            }
            case "KIDS": {
                return "\uc601\uc720\uc544\uc6a9\ud488";
            }
            case "SPORTS_EQUIPMENT": {
                return "\uc2a4\ud3ec\uce20\uc6a9\ud488";
            }
            case "BOOKS": {
                return "\uc11c\uc801";
            }
            case "DIGITAL_CONTENTS": {
                return "\ub514\uc9c0\ud138 \ucf58\ud150\uce20(\uc74c\uc6d0/\uac8c\uc784/\uc778\ud130\ub137 \uac15\uc758 \ub4f1)";
            }
            case "BIOCHEMISTRY": {
                return "\uae30\ud0c0";
            }
            case "BIOCIDAL": {
                return "\uae30\ud0c0";
            }
        }
        return "\uae30\ud0c0";
    }

    public List<String> getProvidedNotice_eng(JsonObject ProvidedNotice) {
        ArrayList<String> prop = new ArrayList<String>();
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "itemName"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "modelName"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "certificateDetails"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "manufacturer"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "afterServiceDirector"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "actor"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "adCaution"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "amount"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "applyModel"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "approvalNumber"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "area"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "author"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "babyFoodOrDietFoodAdDeliberation"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "bandMaterial"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "cancelationCondition"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "cancelationPolicy"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "capacity"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "caution"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "cautionAndSideEffect"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "certificationType"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "chemicals"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "childProtection"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "color"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "component"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "components"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "consumerSafetyCaution"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "customerServicePhoneNumber"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "description"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "detailContent"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "displaySpecification"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "distributor"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "dosageForm"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "effect"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "energyEfficiencyRating"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "expirationDateText"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "foodItem"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "foodType"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "freeCostPeriod"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "geneticallyModified"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "harmfulChemicalSubstance"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "height"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "importDeclaration"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "importDeclarationCheck"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "importer"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "ingredients"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "installedCharge"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "issuer"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "keep"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "licenceNo"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "location"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "mainIngredient"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "maleficence"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "material"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "medium"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "nonMedicinalUsesMessage"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "nutritionFacts"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "ownershipTransferCondition"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "packDateText"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "pages"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "payingForLossOrDamage"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "periodDays"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "powerConsumption"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "producer"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "productComposition"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "productName"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "provideWarranty"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "publishDateText"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "publisher"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "purity"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "purpose"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "rangeOfUse"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "ratedVoltage"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "rating"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "recommendedAge"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "refundPolicy"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "refundPolicyForCancel"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "releaseDateText"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "relevantLawContent"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "requirement"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "roadWorthyCertification"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "safeCriterionNo"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "serviceProvider"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "showPlace"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "showTime"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "size"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "specification"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "sponsor"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "termsOfUse"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "title"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "type"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "updateCost"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "usableCondition"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "usableStore"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "usage"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "usePeriod"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "useStorePlace"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "warrantyPolicy"));
        prop.add(JsonHelper.jsonStringOrDefault(ProvidedNotice, "weight"));
        return prop;
    }

    private void setProp(String gosiNum, List<String> prop, ProductDTO data2) throws Exception {
        HashMap<String, String> propMapping = ShopProductDao.get().setNaverNotice(gosiNum, prop);
        Set<String> keySet = propMapping.keySet();
        for (String key : keySet) {
            if (propMapping.get(key) == null) continue;
            String[] seqList = propMapping.get(key).split(",");
            String inputProp = "";
            if (key.contains("\ud488\uba85")) {
                inputProp = prop.get(0);
            } else if (key.contains("\ubaa8\ub378\uba85")) {
                inputProp = prop.get(1);
            } else if (key.contains("\uc778\uc99d \ud5c8\uac00")) {
                inputProp = prop.get(2);
            } else if (key.contains("\uc81c\uc870\uc790") || key.contains("\uc0dd\uc0b0\uc790")) {
                inputProp = prop.get(3);
            } else if (key.contains("A/S \ucc45\uc784\uc790")) {
                inputProp = prop.get(4);
            } else if (key.contains("\uc8fc\uc5f0")) {
                inputProp = prop.get(5);
            } else if (key.contains("\uc2dd\ud488\ub4f1\uc758\ud45c\uc2dc\u00b7\uad11\uace0")) {
                inputProp = prop.get(6);
            } else if (key.contains("\ud3ec\uc7a5\ub2e8\uc704") || key.contains("\ud310\ub9e4\uac1c\uc218")) {
                inputProp = prop.get(7);
            } else if (key.contains("\uc801\uc6a9\ucc28\uc885")) {
                inputProp = prop.get(8);
            } else if (key.contains("\uc2b9\uc778\ubc88\ud638")) {
                inputProp = prop.get(9);
            } else if (key.contains("\ub0c9\ub09c\ubc29\uba74\uc801")) {
                inputProp = prop.get(10);
            } else if (key.contains("\uc800\uc790") || key.contains("\ucd9c\ud310\uc0ac")) {
                inputProp = prop.get(11);
            } else if (key.contains("\uc601\uc720\uc544\uc2dd") || key.contains("\uccb4\uc911\uc870\uc808\uc2dd\ud488")) {
                inputProp = prop.get(12);
            } else if (key.contains("\uc18c\uc7ac") || key.contains("\uc7ac\uc9c8")) {
                inputProp = prop.get(13);
            } else if (key.contains("\uc608\ub9e4 \ucde8\uc18c \uc870\uac74")) {
                inputProp = prop.get(14);
            } else if (key.contains("\ud658\ubd88") || key.contains("\uccad\uc57d\ucca0\ud68c")) {
                inputProp = prop.get(15);
            } else if (key.contains("\uc6a9\ub7c9 \ub610\ub294 \uc911\ub7c9") || key.contains("\uc911\ub7c9 \ub610\ub294 \uc6a9\ub7c9")) {
                inputProp = prop.get(16);
            } else if (key.contains("\uc8fc\uc758\uc0ac\ud56d")) {
                inputProp = prop.get(17);
            } else if (key.contains("\uc12d\ucde8\uc2dc \uc8fc\uc758\uc0ac\ud56d")) {
                inputProp = prop.get(18);
            } else if (key.contains("KC\uc778\uc99d\ud544 \ud56d\ubaa9")) {
                inputProp = prop.get(19);
            } else if (key.contains("\ud654\ud559\ubb3c\uc9c8 \uba85\uce6d")) {
                inputProp = prop.get(20);
            } else if (key.contains("\ubcf4\ud638\ud3ec\uc7a5")) {
                inputProp = prop.get(21);
            } else if (key.contains("\uc0c9\uc0c1")) {
                inputProp = prop.get(22);
            } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
                inputProp = prop.get(23);
            } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
                inputProp = prop.get(24);
            } else if (key.contains("\ubd80\uc791\uc6a9\ubc1c\uc0dd \uac00\ub2a5\uc131 \uc5ec\ubd80")) {
                inputProp = prop.get(25);
            } else if (key.contains("\uc0c1\ub2f4") || key.contains("\uc608\uc57d\ub2f4\ub2f9")) {
                inputProp = prop.get(26);
            } else if (key.contains("\ubaa9\ucc28 \ub610\ub294 \ucc45\uc18c\uac1c")) {
                inputProp = prop.get(27);
            } else if (key.contains("\uc0c1\ud488\ubcc4 \uc138\ubd80 \uc0ac\uc591")) {
                inputProp = prop.get(28);
            } else if (key.contains("\ud654\uba74\uc0ac\uc591")) {
                inputProp = prop.get(29);
            } else if (key.contains("\uc81c\uc870\uc0ac(\uc218\uc785\uc790/\ubcd1\ud589\uc218\uc785)")) {
                inputProp = prop.get(30);
            } else if (key.equals("\uc6a9\ub3c4")) {
                inputProp = prop.get(31);
            } else if (key.equals("\ud6a8\uacfc")) {
                inputProp = prop.get(32);
            } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
                inputProp = prop.get(33);
            } else if (key.contains("\uc720\ud1b5\uae30\ud55c")) {
                inputProp = prop.get(34);
            } else if (key.contains("\ud488\ubaa9 \ub610\ub294 \uba85\uce6d") || key.contains("\ud488\ubaa9 \ubc0f \uc81c\ud488\uba85")) {
                inputProp = prop.get(35);
            } else if (key.contains("\uc2dd\ud488\uc758 \uc720\ud615")) {
                inputProp = prop.get(36);
            } else if (key.contains("\ubb34\uc0c1\uae30\uac04")) {
                inputProp = prop.get(37);
            } else if (key.contains("GMO") || key.contains("\uc720\uc804\uc790 \uc7ac\uc870\ud569")) {
                inputProp = prop.get(38);
            } else if (key.contains("\uc0b4\uc0dd\ubb3c\ubb3c\uc9c8")) {
                inputProp = prop.get(39);
            } else if (key.contains("\uce58\uc218")) {
                inputProp = prop.get(40);
            } else if (key.contains("\uc2dd\ud488\uc704\uc0dd\ubc95")) {
                inputProp = prop.get(41);
            } else if (key.contains("\uc218\uc785\uc2dd\ud488 \uc5ec\ubd80")) {
                inputProp = prop.get(42);
            } else if (key.contains("\uc218\uc785\uc790")) {
                inputProp = prop.get(43);
            } else if (key.contains("\ud568\ub7c9")) {
                inputProp = prop.get(44);
            } else if (key.contains("\ubc30\uc1a1\uc124\uce58") || key.contains("\ucd94\uac00\uc124\uce58")) {
                inputProp = prop.get(45);
            } else if (key.contains("\ubc1c\ud589\uc790")) {
                inputProp = prop.get(46);
            } else if (key.contains("\ubcf4\uad00\ubc29\ubc95 \ub610\ub294 \ucde8\uae09\ubc29\ubc95")) {
                inputProp = prop.get(47);
            } else if (key.contains("\uc758\ub8cc\uae30\uae30 \ud5c8\uac00")) {
                inputProp = prop.get(48);
            } else if (key.contains("\uc0dd\uc0b0\uc790 \ubc0f \uc18c\uc7ac\uc9c0")) {
                inputProp = prop.get(49);
            } else if (key.contains("\uc8fc\uc694\uc131\ubd84")) {
                inputProp = prop.get(50);
            } else if (key.contains("\uc720\ud574\uc131 \ubc0f \uc704\ud574\uc131")) {
                inputProp = prop.get(51);
            } else if (key.contains("\uc7ac\uc9c8") || key.contains("\uc18c\uc7ac")) {
                inputProp = prop.get(52);
            } else if (key.contains("\uc0c1\ud488 \uc81c\uacf5 \ubc29\uc2dd")) {
                inputProp = prop.get(53);
            } else if (key.contains("\uc9c8\ubcd1\uc608\ubc29")) {
                inputProp = prop.get(54);
            } else if (key.contains("\uc601\uc591\uc131\ubd84") || key.contains("\uc601\uc591\uc815\ubcf4")) {
                inputProp = prop.get(55);
            } else if (key.contains("\uc18c\uc720\uad8c \uc774\uc804 \uc870\uac74")) {
                inputProp = prop.get(56);
            } else if (key.contains("\uc81c\uc870\uc5f0\uc6d4")) {
                inputProp = prop.get(57);
            } else if (key.contains("\ucabd\uc218")) {
                inputProp = prop.get(58);
            } else if (key.contains("\uc18c\ube44\uc790 \ucc45\uc784")) {
                inputProp = prop.get(59);
            } else if (key.equals("\uc720\ud6a8\uae30\uac04")) {
                inputProp = prop.get(60);
            } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
                inputProp = prop.get(61);
            } else if (key.contains("\uc81c\uc870\uad6d")) {
                inputProp = prop.get(62);
            } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
                inputProp = prop.get(63);
            } else if (key.contains("\ud488\uba85") || key.contains("\uc81c\ud488\uc720\ud615")) {
                inputProp = prop.get(64);
            } else if (key.contains("\ud488\uc9c8\ubcf4\uc99d\uc11c")) {
                inputProp = prop.get(65);
            } else if (key.contains("\ucd9c\uac04\uc77c")) {
                inputProp = prop.get(66);
            } else if (key.contains("\ucd9c\ud310\uc0ac")) {
                inputProp = prop.get(67);
            } else if (key.contains("\uc21c\ub3c4")) {
                inputProp = prop.get(68);
            } else if (key.contains("\uc0ac\uc6a9\ubaa9\uc801")) {
                inputProp = prop.get(69);
            } else if (key.contains("\uc0ac\uc6a9\ub300\uc0c1\uc790")) {
                inputProp = prop.get(70);
            } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
                inputProp = prop.get(71);
            } else if (key.contains("\uad00\ub78c\ub4f1\uae09")) {
                inputProp = prop.get(72);
            } else if (key.contains("\uc0ac\uc6a9\uc5f0\ub839")) {
                inputProp = prop.get(73);
            } else if (key.contains("\uc794\uc561\ud658\uae09\uc870\uac74")) {
                inputProp = prop.get(74);
            } else if (key.contains("\ud658\ubd88\uae30\uc900")) {
                inputProp = prop.get(75);
            } else if (key.contains("\ub3d9\uc77c\ubaa8\ub378 \ucd9c\uc2dc\ub144\uc6d4")) {
                inputProp = prop.get(76);
            } else if (key.contains("\uad00\ub828\ubc95\uc0c1 \ud45c\uc2dc\uc0ac\ud56d")) {
                inputProp = prop.get(77);
            } else if (key.contains("\ucd5c\uc18c \uc2dc\uc2a4\ud15c \uc0ac\uc591") || key.contains("\ud544\uc218 \uc18c\ud504\ud2b8\uc6e8\uc5b4")) {
                inputProp = prop.get(78);
            } else if (key.contains("\uac80\uc0ac\ud569\uaca9\uc99d \ubc88\ud638")) {
                inputProp = prop.get(79);
            } else if (key.contains("\uc548\uc804\uae30\uc900 \uc801\ud569")) {
                inputProp = prop.get(80);
            } else if (key.contains("\uc11c\ube44\uc2a4 \uc81c\uacf5 \uc0ac\uc5c5\uc790")) {
                inputProp = prop.get(81);
            } else if (key.contains("\uacf5\uc5f0\uc7a5\uc18c")) {
                inputProp = prop.get(82);
            } else if (key.contains("\uacf5\uc5f0\uc2dc\uac04")) {
                inputProp = prop.get(83);
            } else if (key.contains("\uce58\uc218")) {
                inputProp = prop.get(84);
            } else if (key.contains("\uae30\ub2a5\uc815\ubcf4") || key.contains("\uc81c\ud488 \uc8fc\uc694 \uc0ac\uc591")) {
                inputProp = prop.get(85);
            } else if (key.contains("\uc8fc\ucd5c \ub610\ub294 \uae30\ud68d")) {
                inputProp = prop.get(86);
            } else if (key.contains("\uc774\uc6a9\uc870\uac74")) {
                inputProp = prop.get(87);
            } else if (key.contains("\ub3c4\uc11c\uba85")) {
                inputProp = prop.get(88);
            } else if (key.equals("\uc885\ub958")) {
                inputProp = prop.get(89);
            } else if (key.contains("\ub9f5 \uc5c5\ub370\uc774\ud2b8")) {
                inputProp = prop.get(90);
            } else if (key.contains("\uc774\uc6a9\uc870\uac74")) {
                inputProp = prop.get(91);
            } else if (key.contains("\uc774\uc6a9\uac00\ub2a5\ub9e4\uc7a5")) {
                inputProp = prop.get(92);
            } else if (key.contains("\uc0ac\uc6a9\ubc29\ubc95")) {
                inputProp = prop.get(93);
            } else if (key.contains("\uc0ac\uc6a9\uae30\ud55c \ub610\ub294 \uac1c\ubd09 \ud6c4 \uc0ac\uc6a9\uae30\uac04")) {
                inputProp = prop.get(94);
            } else if (key.contains("\uc774\uc6a9\uac00\ub2a5\ub9e4\uc7a5")) {
                inputProp = prop.get(95);
            } else if (key.contains("\ud488\uc9c8\ubcf4\uc99d\uae30\uc900")) {
                inputProp = prop.get(96);
            } else if (key.contains("\uc911\ub7c9") || key.contains("\ud06c\uae30,\ubb34\uac8c")) {
                inputProp = prop.get(97);
            }
            int i = 0;
            while (i < seqList.length) {
                if (seqList[i].equals("1") && inputProp != "") {
                    data2.setProp_val1(inputProp);
                }
                if (seqList[i].equals("2") && inputProp != "") {
                    data2.setProp_val2(inputProp);
                }
                if (seqList[i].equals("3") && inputProp != "") {
                    data2.setProp_val3(inputProp);
                }
                if (seqList[i].equals("4") && inputProp != "") {
                    data2.setProp_val4(inputProp);
                }
                if (seqList[i].equals("5") && inputProp != "") {
                    data2.setProp_val5(inputProp);
                }
                if (seqList[i].equals("6") && inputProp != "") {
                    data2.setProp_val6(inputProp);
                }
                if (seqList[i].equals("7") && inputProp != "") {
                    data2.setProp_val7(inputProp);
                }
                if (seqList[i].equals("8") && inputProp != "") {
                    data2.setProp_val8(inputProp);
                }
                if (seqList[i].equals("9") && inputProp != "") {
                    data2.setProp_val9(inputProp);
                }
                if (seqList[i].equals("10") && inputProp != "") {
                    data2.setProp_val10(inputProp);
                }
                if (seqList[i].equals("11") && inputProp != "") {
                    data2.setProp_val11(inputProp);
                }
                if (seqList[i].equals("12") && inputProp != "") {
                    data2.setProp_val12(inputProp);
                }
                if (seqList[i].equals("13") && inputProp != "") {
                    data2.setProp_val13(inputProp);
                }
                if (seqList[i].equals("14") && inputProp != "") {
                    data2.setProp_val14(inputProp);
                }
                if (seqList[i].equals("15") && inputProp != "") {
                    data2.setProp_val15(inputProp);
                }
                if (seqList[i].equals("16") && inputProp != "") {
                    data2.setProp_val16(inputProp);
                }
                if (seqList[i].equals("17") && inputProp != "") {
                    data2.setProp_val17(inputProp);
                }
                if (seqList[i].equals("18") && inputProp != "") {
                    data2.setProp_val18(inputProp);
                }
                if (seqList[i].equals("19") && inputProp != "") {
                    data2.setProp_val19(inputProp);
                }
                if (seqList[i].equals("20") && inputProp != "") {
                    data2.setProp_val20(inputProp);
                }
                if (seqList[i].equals("21") && inputProp != "") {
                    data2.setProp_val21(inputProp);
                }
                if (seqList[i].equals("22") && inputProp != "") {
                    data2.setProp_val22(inputProp);
                }
                if (seqList[i].equals("23") && inputProp != "") {
                    data2.setProp_val23(inputProp);
                }
                if (seqList[i].equals("24") && inputProp != "") {
                    data2.setProp_val24(inputProp);
                }
                if (seqList[i].equals("25") && inputProp != "") {
                    data2.setProp_val25(inputProp);
                }
                if (seqList[i].equals("26") && inputProp != "") {
                    data2.setProp_val26(inputProp);
                }
                if (seqList[i].equals("27") && inputProp != "") {
                    data2.setProp_val27(inputProp);
                }
                if (seqList[i].equals("28") && inputProp != "") {
                    data2.setProp_val28(inputProp);
                }
                ++i;
            }
        }
    }

    private String setProductType(String code) {
        switch (code) {
            case "NEW": {
                return "0";
            }
            case "OLD": {
                return "1";
            }
        }
        return "";
    }

    private String getJson(String startDate, String endDate, int page) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("\"searchKeywordType\":\"CHANNEL_PRODUCT_NO\",");
        builder.append("\"searchKeyword\":\"\",");
        builder.append("\"productName\":\"\",");
        builder.append("\"modelName\":\"\",");
        builder.append("\"manufacturerName\":\"\",");
        builder.append("\"brandName\":\"\",");
        builder.append("\"searchDynamicPricingType\":\"ALL\",");
        builder.append("\"searchPeriodType\":\"PROD_REG_DAY\",");
        builder.append("\"deliveryAttributeType\":\"\",");
        builder.append("\"productKindType\":\"\",");
        builder.append("\"etcCondition\":\"\",");
        builder.append("\"subscriptionType\":\"\",");
        builder.append("\"logisticsCompanyNo\":\"\",");
        builder.append("\"deliveryCompanyId\":\"\",");
        builder.append("\"useDeliveryCompany\":true,");
        builder.append("\"evaluateSkuStatusType\":\"\",");
        builder.append("\"fromDate\":\"" + startDate + "T00:00:00.000+09:00\",");
        builder.append("\"toDate\":\"" + endDate + "T23:59:59.999+09:00\",");
        builder.append("\"viewData\":{");
        builder.append("\"productStatusTypes\":[\"SALE\"],");
        builder.append("\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\",\"\"],");
        builder.append("\"pageSize\":\"100\"},");
        builder.append("\"useSizeType\":\"\",");
        builder.append("\"groupProductSearchType\":\"\",");
        builder.append("\"searchOrderType\":\"REG_DATE\",");
        builder.append("\"productStatusTypes\":[\"SALE\"],");
        builder.append("\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\"],");
        builder.append("\"page\":" + page + ",");
        builder.append("\"size\":100,");
        builder.append("\"sort\":[]");
        builder.append("}");
        return builder.toString();
    }

    private String getJsonParamForSpecificCode(String startDate, String endDate, int page, List<String> specificCodes) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("\"searchKeywordType\":\"SELLER_CODE\",");
        builder.append("\"searchKeyword\":\"").append(String.join((CharSequence)"\\n", specificCodes)).append("\",");
        builder.append("\"productName\":\"\",");
        builder.append("\"modelName\":\"\",");
        builder.append("\"manufacturerName\":\"\",");
        builder.append("\"brandName\":\"\",");
        builder.append("\"searchPaymentType\":\"ALL\",");
        builder.append("\"searchPeriodType\":\"PROD_REG_DAY\",");
        builder.append("\"deliveryAttributeType\":\"\",");
        builder.append("\"productKindType\":\"\",");
        builder.append("\"etcCondition\":\"\",");
        builder.append("\"subscriptionType\":\"\",");
        builder.append("\"logisticsCompanyNo\":\"\",");
        builder.append("\"useProductLogistics\":true,");
        builder.append("\"deliveryCompanyId\":\"\",");
        builder.append("\"useDeliveryCompany\":true,");
        builder.append("\"fromDate\":\"" + startDate + "T00:00:00.000+09:00\",");
        builder.append("\"toDate\":\"" + endDate + "T23:59:59.999+09:00\",");
        builder.append("\"viewData\":{");
        builder.append("\"productStatusTypes\":[\"SALE\"],");
        builder.append("\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\",\"\"],");
        builder.append("\"pageSize\":100},");
        builder.append("\"searchOrderType\":\"REG_DATE\",");
        builder.append("\"productStatusTypes\":[\"SALE\"],");
        builder.append("\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\"],");
        builder.append("\"page\":" + page + ",");
        builder.append("\"size\":100,");
        builder.append("\"sort\":[]}");
        builder.append("}");
        return builder.toString();
    }

    @Override
    public ResultProcessDTO addProcess2(ProductAddProcessDTO procDto, List<String> specificCodes, IProgressMonitor monitor, ShoppingmallDTO dto) throws Exception {
        ArrayList<ProductDTO> syncList = new ArrayList<ProductDTO>();
        ChromeDriver driver = ChromeExtention.getInstace().getDriver(true);
        String URL2 = "https://shopping.naver.com/";
        ChromeScript.get().get(driver, URL2);
        InterruptSource.Thread.sleep((long)2000L);
        this.cookie = ChromeScript.get().getCookies(driver);
        for (String strUrl : specificCodes) {
            try {
                String url = String.format("%s", strUrl);
                Connection.Response rs = Jsoup.connect((String)url).cookies(this.cookie).header("Host", "brand.naver.com").header("Connection", "keep-alive").header("Upgrade-Insecure-Requests", "1").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").header("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7").header("Sec-Fetch-Site", "none").header("Sec-Fetch-Mode", "navigate").header("Sec-Fetch-User", "?1").header("Sec-Fetch-Dest", "document").header("Accept-Encoding", "gzip").header("Accept-Language", "ko-KR,ko;q=0.9,en-US;q=0.8,en;q=0.7").method(Connection.Method.GET).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).execute();
                Document body = Jsoup.parseBodyFragment((String)rs.body());
                Elements scripts = body.select("script");
                String jsonData = "";
                for (Element script : scripts) {
                    if (!script.html().contains("window.__PRELOADED_STATE__")) continue;
                    jsonData = script.html().replaceFirst("window\\.__PRELOADED_STATE__\\s*=\\s*", "");
                    if (!jsonData.endsWith(";")) break;
                    jsonData = jsonData.substring(0, jsonData.length() - 1);
                    break;
                }
                YDMAStringUtil.Print(jsonData);
                if (jsonData.isEmpty()) continue;
                try {
                    JsonObject product2;
                    JsonReader reader = new JsonReader((Reader)new StringReader(jsonData));
                    reader.setLenient(true);
                    JsonParser parser = new JsonParser();
                    JsonElement rootElement = parser.parse(reader);
                    if (!rootElement.getAsJsonObject().has("product") || !(product2 = rootElement.getAsJsonObject().getAsJsonObject("product")).has("A")) continue;
                    JsonObject aObject = product2.getAsJsonObject("A");
                    if (rs.statusCode() != 200 || aObject.size() <= 0) continue;
                    try {
                        this.onDatabindandSaveDB(aObject, dto, url, driver, monitor, this.cookie);
                        syncList.add(new ProductDTO());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        driver.close();
        ResultProcessDTO result = new ResultProcessDTO();
        result.setSUCCESS_CNT(syncList.size());
        return result;
    }

    private void onDatabindandSaveDB(JsonObject datas, ShoppingmallDTO dto, String url, ChromeDriver driver, IProgressMonitor monitor, Map<String, String> cookies) throws Exception {
        ProductDTO data2 = new ProductDTO();
        data2.setGoods_nm(ShopCommon.jsonElementNullStr(datas.get("name")));
        YDMAStringUtil.Print(datas);
        try {
            JsonObject naverShoppingSearchInfo = (JsonObject)datas.get("naverShoppingSearchInfo");
            data2.setMaker(ShopCommon.jsonElementNullStr(naverShoppingSearchInfo.get("manufacturerName")));
            data2.setBrand_nm(ShopCommon.jsonElementNullStr(naverShoppingSearchInfo.get("brandName")));
            data2.setModel_no(ShopCommon.jsonElementNullStr(naverShoppingSearchInfo.get("modelName")));
        }
        catch (Exception exception) {
            data2.setMaker("");
            data2.setBrand_nm("");
            data2.setModel_no("");
        }
        JsonObject originAreaInfo = (JsonObject)datas.get("originAreaInfo");
        data2.setOrigin(ShopCommon.jsonElementNullStr(originAreaInfo.get("content")));
        JsonObject shopcategory = (JsonObject)datas.get("category");
        data2.setClass_cd3(ShopCommon.jsonElementNullStr(shopcategory.get("categoryId")));
        data2.setGmcategnm(ShopCommon.jsonElementNullStr(shopcategory.get("wholeCategoryName")));
        String category = ShopCommonDao.get().getEsCodeNaver(data2.getClass_cd3());
        if (!category.equals("")) {
            data2.setEs(category.split("[|]")[0]);
            data2.setCatno(category.split("[|]")[0]);
            data2.setShop_cid_info(category.split("[|]")[1]);
        } else {
            String catShortName = ShopCommon.jsonElementNullStr(shopcategory.get("categoryName"));
            boolean result = ShoppingMallDao.get().saveCatImsiTot(dto.getSHOPCD(), data2.getClass_cd3(), catShortName);
            if (result) {
                String catInfo = ShopCommonDao.get().getEsCodeNaver(data2.getClass_cd3());
                if (!catInfo.equals("")) {
                    data2.setEs(catInfo.split("[|]")[0]);
                    data2.setCatno(catInfo.split("[|]")[0]);
                    data2.setShop_cid_info(catInfo.split("[|]")[1]);
                } else {
                    data2.setEs("");
                    data2.setShop_cid_info("");
                }
            } else {
                data2.setEs("");
                data2.setShop_cid_info("");
            }
        }
        String full_cateName = CaffeineCategoryCache.getInstance().getFullCategoryName(data2.getEs());
        data2.setGmcategnm(full_cateName);
        try {
            JsonObject deliveryInfo = (JsonObject)datas.get("productDeliveryInfo");
            data2.setDelv_cost(ShopCommon.jsonElementNullStr(deliveryInfo.get("baseFee")));
            data2.setDelv_type(data2.getDelv_cost().equals("0") ? "1" : "0");
            JsonObject claimDeliveryInfo = (JsonObject)datas.get("claimDeliveryInfo");
            data2.setDelv_r_cost(ShopCommon.jsonElementNullStr(claimDeliveryInfo.get("exchangeDeliveryFee")));
        }
        catch (Exception exception) {
            data2.setDelv_cost("0");
            data2.setDelv_type(data2.getDelv_cost().equals("0") ? "1" : "0");
            data2.setDelv_r_cost("0");
        }
        String salePrice = ShopCommon.jsonElementNullInt(datas.get("discountedSalePrice"));
        data2.setMarket_price(salePrice);
        data2.setGoods_price(salePrice);
        data2.setGoods_consumer_price(salePrice);
        data2.setQty(ShopCommon.jsonElementNullInt(datas.get("stockQuantity")));
        JsonArray sellerTags = (JsonArray)datas.get("sellerTags");
        data2.setGoods_search(this.getKeyWord(sellerTags));
        JsonArray images = (JsonArray)datas.get("productImages");
        int i = 0;
        while (i < images.size()) {
            String image = ShopCommon.jsonElementNullStr(images.get(i).getAsJsonObject().get("url"));
            this.getApiImages(data2, i, image);
            ++i;
        }
        data2.setSelect_option("");
        if (datas.get("optionUsable").getAsString().equals("true")) {
            String option2 = this.getApioption(datas, Integer.parseInt(data2.getMarket_price()));
            data2.setSelect_option(option2);
            JsonArray optionTypes = datas.get("options").getAsJsonArray();
            data2.setChar_1_nm(optionTypes.size() > 0 ? optionTypes.get(0).getAsJsonObject().get("groupName").getAsString() : "");
            data2.setChar_2_nm(optionTypes.size() > 1 ? optionTypes.get(1).getAsJsonObject().get("groupName").getAsString() : "");
            JsonArray optionVals = datas.get("optionCombinations").getAsJsonArray();
            ArrayList<String> val1s = new ArrayList<String>();
            ArrayList<String> val2s = new ArrayList<String>();
            int i2 = 0;
            while (i2 < optionVals.size()) {
                JsonObject val = optionVals.get(i2).getAsJsonObject();
                if (optionTypes.size() > 1) {
                    val1s.add(val.get("optionName1").getAsString());
                    val2s.add(val.get("optionName2").getAsString());
                } else {
                    val1s.add(val.get("optionName1").getAsString());
                }
                ++i2;
            }
            if (val1s.size() > 0) {
                String val1 = val1s.stream().distinct().collect(Collectors.joining(":"));
                data2.setChar_1_val(val1);
            }
            if (val2s.size() > 0) {
                String val2 = val2s.stream().distinct().collect(Collectors.joining(":"));
                data2.setChar_2_val(val2);
            }
        }
        JsonObject productInfoProvidedNotice = (JsonObject)datas.get("productInfoProvidedNoticeView");
        JsonObject productInfoProvidedNoticeContent = (JsonObject)productInfoProvidedNotice.get("basic");
        this.getProvidedNotice_kor(productInfoProvidedNoticeContent, data2);
        String cert = ShopCommon.jsonElementNullStr(datas.get("certification"));
        if (cert.equals("true")) {
            JsonArray prodCert = (JsonArray)datas.get("productCertificationInfos");
            data2.setCert(ShopCommon.jsonElementNullStr(prodCert.get(0).getAsJsonObject().get("certificationTypeName")));
            data2.setCert_type("1");
            data2.setCertno(ShopCommon.jsonElementNullStr(prodCert.get(0).getAsJsonObject().get("certificationNumber")));
            data2.setCertdate("");
            data2.setCertmodel(ShopCommon.jsonElementNullStr(prodCert.get(0).getAsJsonObject().get("certificationMarkType")));
            data2.setCertfield(ShopCommon.jsonElementNullStr(prodCert.get(0).getAsJsonObject().get("certificationMarkUrl")));
        } else {
            data2.setCert_type("0");
        }
        data2.setGoods_remarks(this.getDetailProducts(driver, url));
        String icode = this.saveShopprodinfoReverse(dto, data2, this.companyGoodsCd, this.cnt, monitor);
        if (!icode.equals("")) {
            try {
                JsonArray supplements = datas.get("supplements").getAsJsonArray();
                ProductDTO infoDto = ShopProductDao.get().getShopInfOne("COMPAYNY_GOODS_CD", icode);
                this.saveSupplements(supplements, infoDto.getPRODSEQ(), infoDto.getCompayny_goods_cd());
            }
            catch (Exception exception) {}
        }
        try {
            monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 [" + data2.getCompayny_goods_cd() + "] \ubcc0\ud658 \uc911\uc785\ub2c8\ub2e4.]");
            monitor.worked(1);
            if (monitor.isCanceled()) {
                monitor.done();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveSupplements(JsonArray supplements, String prodseq, String icode) throws Exception {
        ArrayList<ShopAddProdInfoDto> addOptDtoList = new ArrayList<ShopAddProdInfoDto>();
        int seq = 0;
        int i = 0;
        while (i < supplements.size()) {
            JsonArray options = supplements.get(i).getAsJsonObject().get("options").getAsJsonArray();
            int j = 0;
            while (j < options.size()) {
                ShopAddProdInfoDto addOptDto = new ShopAddProdInfoDto();
                addOptDto.setProdseq(Integer.parseInt(prodseq));
                addOptDto.setSkuseq(++seq);
                addOptDto.setCompno(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                addOptDto.setCompayny_goods_cd(icode);
                addOptDto.setUser_code("001");
                addOptDto.setProd_type1(ShopCommon.jsonElementNullStr(options.get(j).getAsJsonObject().get("groupName")));
                addOptDto.setProd_val1(ShopCommon.jsonElementNullStr(options.get(j).getAsJsonObject().get("name")));
                addOptDto.setProd_type2("");
                addOptDto.setProd_val2("");
                addOptDto.setProd_amt(Integer.parseInt(ShopCommon.jsonElementNullInt(options.get(j).getAsJsonObject().get("price"))));
                addOptDto.setProd_cnt(Integer.parseInt(ShopCommon.jsonElementNullInt(options.get(j).getAsJsonObject().get("stockQuantity"))));
                addOptDto.setInsertdt(TimeUtils.getCurrentTimeFormat());
                addOptDto.setInsertid(YDMASessonUtil.getUserInfo().getUserId());
                addOptDtoList.add(addOptDto);
                ++j;
            }
            ++i;
        }
        ShopProductDao.get().insertAddProdInfo(addOptDtoList);
    }

    public String saveShopprodinfoReverse(ShoppingmallDTO dto, ProductDTO data2, int companyGoodsCd, int cnt, IProgressMonitor monitor) throws Exception {
        ArrayList<ProductItemDto> infoTotal = new ArrayList<ProductItemDto>();
        ProductItemDto newInfoDto = new ProductItemDto();
        newInfoDto.setSearch("shop0000");
        if (companyGoodsCd == 0) {
            companyGoodsCd = ShopProductDao.get().getMaxCompanyGoodsCd();
        }
        String icode = "MLK" + String.format("%05d", ++companyGoodsCd);
        int count = (int)infoTotal.stream().filter(d -> d.getIcode().contains(icode)).count();
        String icode2 = icode;
        if (count > 1) {
            icode2 = String.valueOf(icode) + "_" + String.valueOf(cnt++);
        }
        newInfoDto.setIcode(icode2);
        newInfoDto.setIname(data2.getGoods_nm());
        newInfoDto.setCid(data2.getEs());
        newInfoDto.setCate_depth("3");
        newInfoDto.setClass_cd3(data2.getEs());
        String[] image = new String[24];
        int i = 0;
        while (i < image.length) {
            this.saveImage(data2, i, image);
            ++i;
        }
        newInfoDto.setImg(image);
        newInfoDto.setPrice(data2.getGoods_price());
        newInfoDto.setPrice_consumer(data2.getGoods_price());
        newInfoDto.setSelect_option(data2.getSelect_option());
        newInfoDto.setContent(data2.getGoods_remarks());
        newInfoDto.setKeyword(data2.getGoods_search());
        newInfoDto.setStatus("0");
        newInfoDto.setAdult(data2.getAdult());
        newInfoDto.setDelivery_qty("0");
        newInfoDto.setIslimit("0");
        newInfoDto.setDelivery_amount(data2.getDelv_cost());
        newInfoDto.setIsreturn("1");
        newInfoDto.setR_delivery_amount(data2.getDelv_r_cost());
        newInfoDto.setDelivery_type(data2.getDelv_type());
        newInfoDto.setTax("0");
        newInfoDto.setBrand(data2.getBrand_nm());
        newInfoDto.setMaker(data2.getMaker());
        newInfoDto.setModel(data2.getModel_no());
        newInfoDto.setOrigin(data2.getOrigin());
        if (!data2.getShop_cid_info().equals("")) {
            ShopCommonDao.get().getSyncCategory(newInfoDto, data2);
        }
        newInfoDto.setPa_gmarket(data2.getGmcategnm());
        newInfoDto.setGosi_code(data2.getProp1_cd());
        newInfoDto.setGosi1(data2.getProp_val1() != null && data2.getProp_val1().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val1());
        newInfoDto.setGosi2(data2.getProp_val2() != null && data2.getProp_val2().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val2());
        newInfoDto.setGosi3(data2.getProp_val3() != null && data2.getProp_val3().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val3());
        newInfoDto.setGosi4(data2.getProp_val4() != null && data2.getProp_val4().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val4());
        newInfoDto.setGosi5(data2.getProp_val5() != null && data2.getProp_val5().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val5());
        newInfoDto.setGosi6(data2.getProp_val6() != null && data2.getProp_val6().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val6());
        newInfoDto.setGosi7(data2.getProp_val7() != null && data2.getProp_val7().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val7());
        newInfoDto.setGosi8(data2.getProp_val8() != null && data2.getProp_val8().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val8());
        newInfoDto.setGosi9(data2.getProp_val9() != null && data2.getProp_val9().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val9());
        newInfoDto.setGosi10(data2.getProp_val10() != null && data2.getProp_val10().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val10());
        newInfoDto.setGosi11(data2.getProp_val11() != null && data2.getProp_val11().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val11());
        newInfoDto.setGosi12(data2.getProp_val12() != null && data2.getProp_val12().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val12());
        newInfoDto.setGosi13(data2.getProp_val13() != null && data2.getProp_val13().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val13());
        newInfoDto.setGosi14(data2.getProp_val14() != null && data2.getProp_val14().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val14());
        newInfoDto.setGosi15(data2.getProp_val15() != null && data2.getProp_val15().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val15());
        newInfoDto.setGosi16(data2.getProp_val16() != null && data2.getProp_val16().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val16());
        newInfoDto.setGosi17(data2.getProp_val17() != null && data2.getProp_val17().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val17());
        newInfoDto.setGosi18(data2.getProp_val18() != null && data2.getProp_val18().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val18());
        newInfoDto.setGosi19(data2.getProp_val19() != null && data2.getProp_val19().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val19());
        newInfoDto.setGosi20(data2.getProp_val20() != null && data2.getProp_val20().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val20());
        newInfoDto.setGosi21(data2.getProp_val21() != null && data2.getProp_val21().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val21());
        newInfoDto.setGosi22(data2.getProp_val22() != null && data2.getProp_val22().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val22());
        newInfoDto.setCert_type(data2.getCert_type());
        newInfoDto.setCert(data2.getCert());
        newInfoDto.setCert_no(data2.getCertno());
        infoTotal.add(newInfoDto);
        boolean result = DomesinShopDao.get().saveInfoReverse(infoTotal, monitor);
        if (result) {
            return newInfoDto.getIcode();
        }
        return "";
    }

    private String getApioption(JsonObject datas, int price2) throws Exception {
        String result = "";
        JsonArray options = (JsonArray)datas.get("options");
        JsonArray optionCombinations = (JsonArray)datas.get("optionCombinations");
        String groupName = options.get(0).getAsJsonObject().get("groupName").getAsString();
        try {
            if (optionCombinations.size() > 0) {
                if (options.size() == 1) {
                    result = "[" + groupName + "]\n";
                    int i = 0;
                    while (i < optionCombinations.size()) {
                        result = String.valueOf(result) + optionCombinations.get(i).getAsJsonObject().get("optionName1").getAsString() + "==" + String.valueOf(optionCombinations.get(i).getAsJsonObject().get("price").getAsInt() + price2) + "=0=0=" + (String.valueOf(optionCombinations.get(i).getAsJsonObject().get("stockQuantity").getAsInt()).equals("0") ? "1" : "0") + "\n";
                        ++i;
                    }
                } else if (options.size() == 2) {
                    result = "[" + groupName + "=" + options.get(1).getAsJsonObject().get("groupName").getAsString() + "]\n";
                    int i = 0;
                    while (i < optionCombinations.size()) {
                        JsonObject obj = optionCombinations.get(i).getAsJsonObject();
                        result = String.valueOf(result) + obj.getAsJsonObject().get("optionName1").getAsString() + "=" + (obj.has("optionName2") ? obj.get("optionName2").getAsString() : "") + "=" + String.valueOf(obj.getAsJsonObject().get("price").getAsInt() + price2) + "=0=0=" + (String.valueOf(obj.getAsJsonObject().get("stockQuantity").getAsInt()).equals("0") ? "1" : "0") + "\n";
                        ++i;
                    }
                } else if (options.size() == 3) {
                    result = "[" + groupName.concat("=").concat(options.get(1).getAsJsonObject().get("groupName").getAsString()).concat("=").concat(options.get(2).getAsJsonObject().get("groupName").getAsString()).concat("]\n");
                    int i = 0;
                    while (i < optionCombinations.size()) {
                        JsonObject obj = optionCombinations.get(i).getAsJsonObject();
                        result = String.valueOf(result) + obj.getAsJsonObject().get("optionName1").getAsString().concat("=").concat(obj.has("optionName2") ? obj.get("optionName2").getAsString() : "").concat("=").concat(obj.has("optionName3") ? obj.get("optionName3").getAsString() : "").concat("=").concat(String.valueOf(obj.getAsJsonObject().get("price").getAsInt() + price2)).concat("=0=0=").concat(String.valueOf(obj.getAsJsonObject().get("stockQuantity").getAsInt()).equals("0") ? "1" : "0").concat("\n");
                        ++i;
                    }
                }
            } else {
                List<Object> optionTitle = new ArrayList<String>();
                ArrayList<String> optionValue = new ArrayList<String>();
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                int cnt = 1;
                YDMAStringUtil.Print();
                int i = 0;
                while (i < options.size()) {
                    optionTitle.add(options.get(i).getAsJsonObject().get("groupName").getAsString());
                    optionValue.add(options.get(i).getAsJsonObject().get("name").getAsString());
                    if (i > 0 && ((String)optionTitle.get(i)).equals(optionTitle.get(i - 1))) {
                        map.put((String)optionTitle.get(i), ++cnt);
                    } else {
                        cnt = 1;
                    }
                    ++i;
                }
                int firstOption = (Integer)map.get((optionTitle = optionTitle.stream().distinct().collect(Collectors.toList())).get(0));
                if (firstOption < options.size()) {
                    result = "[" + (String)optionTitle.get(0) + "=" + (String)optionTitle.get(1) + "]\n";
                    int i2 = 0;
                    while (i2 < firstOption) {
                        int j = firstOption;
                        while (j < options.size()) {
                            result = String.valueOf(result) + (String)optionValue.get(i2) + "=" + (String)optionValue.get(j) + "=" + price2 + "=0=0=0\n";
                            ++j;
                        }
                        ++i2;
                    }
                } else if (firstOption == options.size()) {
                    result = "[" + groupName + "]\n";
                    int i3 = 0;
                    while (i3 < options.size()) {
                        result = String.valueOf(result) + (String)optionValue.get(i3) + "==" + price2 + "=0=0=0\n";
                        ++i3;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158 \uc77d\ub294 \uc911 \uc624\ub958 \ubc1c\uc0dd.");
        }
        return result;
    }

    private String getDetailProducts(ChromeDriver driver, String url) throws Exception {
        StringBuilder detailDesc = new StringBuilder();
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--headless"});
        options.addArguments(new String[]{"user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36"});
        driver = new ChromeDriver(options);
        driver.get(url);
        InterruptSource.Thread.sleep((long)5000L);
        WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
        WebElement Element2 = null;
        try {
            Element2 = driver.findElement(By.xpath((String)"//*[@id=\"INTRODUCE\"]/div/div[6]/button"));
            driver.executeScript("arguments[0].scrollIntoView();", new Object[]{Element2});
            InterruptSource.Thread.sleep((long)1000L);
            driver.executeScript("document.querySelector('#INTRODUCE > div > div:nth-child(4) > div > button').click();", new Object[]{""});
        }
        catch (Exception exception) {
            try {
                Element2 = driver.findElement(By.xpath((String)"//*[@id='INTRODUCE']/div/div[5]/div/button"));
                driver.executeScript("arguments[0].scrollIntoView();", new Object[]{Element2});
                InterruptSource.Thread.sleep((long)1000L);
                driver.executeScript("document.querySelector('#INTRODUCE > div > div:nth-child(5) > div > button').click();", new Object[]{""});
            }
            catch (Exception exception2) {
                try {
                    driver.executeScript("window.scrollBy(0,4500)", new Object[]{""});
                    InterruptSource.Thread.sleep((long)1000L);
                    driver.executeScript("document.querySelector('#INTRODUCE > div > div:nth-child(5) > div > button').click();", new Object[]{""});
                }
                catch (Exception exception3) {}
            }
        }
        String getGoods_remarks1 = "";
        String getGoods_remarks2 = "";
        detailDesc.append("<p align=center>");
        try {
            InterruptSource.Thread.sleep((long)2000L);
            getGoods_remarks1 = ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.className((String)"HU3BvGpu9d")))).getAttribute("innerHTML");
            BufferedReader reader = new BufferedReader(new StringReader(getGoods_remarks1));
            while (true) {
                String line;
                if (!(line = reader.readLine()).equals("") && line != null) {
                    continue;
                }
                int len = line.length();
                int strIdx = line.indexOf("data-src=\"http");
                if (strIdx == -1) continue;
                int strPos = strIdx + 10;
                String findStr = line.substring(strPos, len);
                int endPos = findStr.indexOf("\"");
                String rsultStr = findStr.substring(1, endPos);
                detailDesc.append("<img src=");
                detailDesc.append(rsultStr);
                detailDesc.append("></p><p align=center>");
            }
        }
        catch (Exception exception) {
            try {
                String line;
                InterruptSource.Thread.sleep((long)4000L);
                getGoods_remarks2 = String.valueOf(getGoods_remarks2) + ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.className((String)"_9F9CWn02VE")))).getAttribute("innerHTML");
                BufferedReader reader = new BufferedReader(new StringReader(getGoods_remarks2));
                while (!(line = reader.readLine()).equals("") && line != null) {
                    int len = line.length();
                    int strIdx = line.indexOf("data-src=\"http");
                    if (strIdx == -1) continue;
                    int strPos = strIdx + 10;
                    String findStr = line.substring(strPos, len);
                    int endPos = findStr.indexOf("\"");
                    String rsultStr = findStr.substring(0, endPos);
                    detailDesc.append("<img src=");
                    detailDesc.append(rsultStr);
                    detailDesc.append("></p><p align=center>");
                }
            }
            catch (Exception exception4) {}
            detailDesc.append("</p><p align=center>");
            return detailDesc.toString();
        }
    }

    public void getProvidedNotice_kor(JsonObject ProvidedNotice, ProductDTO data2) throws Exception {
        ArrayList<String> prop = new ArrayList<String>(100);
        int i = 0;
        while (i < 100) {
            prop.add(i, "");
            ++i;
        }
        data2.setProp1_cd("035");
        Set entrySet = ProvidedNotice.entrySet();
        for (Map.Entry entry : entrySet) {
            String key1 = (String)entry.getKey();
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                data2.setProp1_cd("021");
                Set entrySet2 = ((JsonElement)entry.getValue()).getAsJsonObject().entrySet();
                for (Map.Entry entry2 : entrySet2) {
                    String key21 = (String)entry2.getKey();
                    String val21 = ((JsonElement)entry2.getValue()).getAsString();
                    prop.set(this.getProvidedNotice_kor_detail(key21), val21);
                }
                continue;
            }
            String val1 = ((JsonElement)entry.getValue()).getAsString();
            prop.set(this.getProvidedNotice_kor_detail(key1), val1);
        }
        ArrayList<String> proShop = new ArrayList<String>(100);
        int i2 = 0;
        while (i2 < 100) {
            if (!((String)prop.get(i2)).equals("")) {
                proShop.add(String.valueOf(i2 + 1));
            }
            ++i2;
        }
        Map<String, Map<String, String>> propMapping = null;
        try {
            propMapping = ShopProductDao.get().setNaverNotice2();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int cntwin = 0;
        String findwin = "";
        for (Map.Entry entry : propMapping.entrySet()) {
            String key = ((String)entry.getKey()).toString();
            int cnt = 0;
            Set entrypPop2 = ((Map)entry.getValue()).entrySet();
            for (Map.Entry popList : entrypPop2) {
                String[] seqList = ((String)popList.getValue()).toString().split(",");
                int i3 = 0;
                while (i3 < seqList.length) {
                    int j = 0;
                    while (j < proShop.size()) {
                        if (seqList[i3].equals(proShop.get(j))) {
                            ++cnt;
                        }
                        ++j;
                    }
                    ++i3;
                }
            }
            if (cnt <= cntwin) continue;
            cntwin = cnt;
            findwin = key;
        }
        if (cntwin > 3) {
            data2.setProp1_cd(findwin);
        }
        this.setProp(data2.getProp1_cd(), prop, data2);
    }

    public int getProvidedNotice_kor_detail(String key) {
        int idx = 0;
        if (key.contains("\ud488\uba85")) {
            idx = 0;
        } else if (key.contains("\ubaa8\ub378\uba85")) {
            idx = 1;
        } else if (key.contains("\uc778\uc99d \ud5c8\uac00")) {
            idx = 2;
        } else if (key.contains("\uc81c\uc870\uc790") || key.contains("\uc0dd\uc0b0\uc790")) {
            idx = 3;
        } else if (key.contains("A/S \ucc45\uc784\uc790")) {
            idx = 4;
        } else if (key.contains("\uc8fc\uc5f0")) {
            idx = 5;
        } else if (key.contains("\uc2dd\ud488\ub4f1\uc758\ud45c\uc2dc\u00b7\uad11\uace0")) {
            idx = 6;
        } else if (key.contains("\ud3ec\uc7a5\ub2e8\uc704") || key.contains("\ud310\ub9e4\uac1c\uc218")) {
            idx = 7;
        } else if (key.contains("\uc801\uc6a9\ucc28\uc885")) {
            idx = 8;
        } else if (key.contains("\uc2b9\uc778\ubc88\ud638")) {
            idx = 9;
        } else if (key.contains("\ub0c9\ub09c\ubc29\uba74\uc801")) {
            idx = 10;
        } else if (key.contains("\uc800\uc790") || key.contains("\ucd9c\ud310\uc0ac")) {
            idx = 11;
        } else if (key.contains("\uc601\uc720\uc544\uc2dd") || key.contains("\uccb4\uc911\uc870\uc808\uc2dd\ud488")) {
            idx = 12;
        } else if (key.contains("\uc18c\uc7ac") || key.contains("\uc7ac\uc9c8")) {
            idx = 13;
        } else if (key.contains("\uc608\ub9e4 \ucde8\uc18c \uc870\uac74")) {
            idx = 14;
        } else if (key.contains("\ud658\ubd88") || key.contains("\uccad\uc57d\ucca0\ud68c")) {
            idx = 15;
        } else if (key.contains("\uc6a9\ub7c9 \ub610\ub294 \uc911\ub7c9") || key.contains("\uc911\ub7c9 \ub610\ub294 \uc6a9\ub7c9")) {
            idx = 16;
        } else if (key.contains("\uc8fc\uc758\uc0ac\ud56d")) {
            idx = 17;
        } else if (key.contains("\uc12d\ucde8\uc2dc \uc8fc\uc758\uc0ac\ud56d")) {
            idx = 18;
        } else if (key.contains("KC\uc778\uc99d\ud544 \ud56d\ubaa9")) {
            idx = 19;
        } else if (key.contains("\ud654\ud559\ubb3c\uc9c8 \uba85\uce6d")) {
            idx = 20;
        } else if (key.contains("\ubcf4\ud638\ud3ec\uc7a5")) {
            idx = 21;
        } else if (key.contains("\uc0c9\uc0c1")) {
            idx = 22;
        } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
            idx = 23;
        } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
            idx = 24;
        } else if (key.contains("\ubd80\uc791\uc6a9\ubc1c\uc0dd \uac00\ub2a5\uc131 \uc5ec\ubd80")) {
            idx = 25;
        } else if (key.contains("\uc0c1\ub2f4") || key.contains("\uc608\uc57d\ub2f4\ub2f9")) {
            idx = 26;
        } else if (key.contains("\ubaa9\ucc28 \ub610\ub294 \ucc45\uc18c\uac1c")) {
            idx = 27;
        } else if (key.contains("\uc0c1\ud488\ubcc4 \uc138\ubd80 \uc0ac\uc591")) {
            idx = 28;
        } else if (key.contains("\ud654\uba74\uc0ac\uc591")) {
            idx = 29;
        } else if (key.contains("\uc81c\uc870\uc0ac(\uc218\uc785\uc790/\ubcd1\ud589\uc218\uc785)")) {
            idx = 30;
        } else if (key.equals("\uc6a9\ub3c4")) {
            idx = 31;
        } else if (key.equals("\ud6a8\uacfc")) {
            idx = 32;
        } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
            idx = 33;
        } else if (key.contains("\uc720\ud1b5\uae30\ud55c")) {
            idx = 34;
        } else if (key.contains("\ud488\ubaa9 \ub610\ub294 \uba85\uce6d") || key.contains("\ud488\ubaa9 \ubc0f \uc81c\ud488\uba85")) {
            idx = 35;
        } else if (key.contains("\uc2dd\ud488\uc758 \uc720\ud615")) {
            idx = 36;
        } else if (key.contains("\ubb34\uc0c1\uae30\uac04")) {
            idx = 37;
        } else if (key.contains("GMO") || key.contains("\uc720\uc804\uc790 \uc7ac\uc870\ud569")) {
            idx = 38;
        } else if (key.contains("\uc0b4\uc0dd\ubb3c\ubb3c\uc9c8")) {
            idx = 39;
        } else if (key.contains("\uce58\uc218")) {
            idx = 40;
        } else if (key.contains("\uc2dd\ud488\uc704\uc0dd\ubc95")) {
            idx = 41;
        } else if (key.contains("\uc218\uc785\uc2dd\ud488 \uc5ec\ubd80")) {
            idx = 42;
        } else if (key.contains("\uc218\uc785\uc790")) {
            idx = 43;
        } else if (key.contains("\ud568\ub7c9")) {
            idx = 44;
        } else if (key.contains("\ubc30\uc1a1\uc124\uce58") || key.contains("\ucd94\uac00\uc124\uce58")) {
            idx = 45;
        } else if (key.contains("\ubc1c\ud589\uc790")) {
            idx = 46;
        } else if (key.contains("\ubcf4\uad00\ubc29\ubc95 \ub610\ub294 \ucde8\uae09\ubc29\ubc95")) {
            idx = 47;
        } else if (key.contains("\uc758\ub8cc\uae30\uae30 \ud5c8\uac00")) {
            idx = 48;
        } else if (key.contains("\uc0dd\uc0b0\uc790 \ubc0f \uc18c\uc7ac\uc9c0")) {
            idx = 49;
        } else if (key.contains("\uc8fc\uc694\uc131\ubd84")) {
            idx = 50;
        } else if (key.contains("\uc720\ud574\uc131 \ubc0f \uc704\ud574\uc131")) {
            idx = 51;
        } else if (key.contains("\uc7ac\uc9c8") || key.contains("\uc18c\uc7ac")) {
            idx = 52;
        } else if (key.contains("\uc0c1\ud488 \uc81c\uacf5 \ubc29\uc2dd")) {
            idx = 53;
        } else if (key.contains("\uc9c8\ubcd1\uc608\ubc29")) {
            idx = 54;
        } else if (key.contains("\uc601\uc591\uc131\ubd84") || key.contains("\uc601\uc591\uc815\ubcf4")) {
            idx = 55;
        } else if (key.contains("\uc18c\uc720\uad8c \uc774\uc804 \uc870\uac74")) {
            idx = 56;
        } else if (key.contains("\uc81c\uc870\uc5f0\uc6d4")) {
            idx = 57;
        } else if (key.contains("\ucabd\uc218")) {
            idx = 58;
        } else if (key.contains("\uc18c\ube44\uc790 \ucc45\uc784")) {
            idx = 59;
        } else if (key.equals("\uc720\ud6a8\uae30\uac04")) {
            idx = 60;
        } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
            idx = 61;
        } else if (key.contains("\uc81c\uc870\uad6d")) {
            idx = 62;
        } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
            idx = 63;
        } else if (key.contains("\ud488\uba85") || key.contains("\uc81c\ud488\uc720\ud615")) {
            idx = 64;
        } else if (key.contains("\ud488\uc9c8\ubcf4\uc99d\uc11c")) {
            idx = 65;
        } else if (key.contains("\ucd9c\uac04\uc77c")) {
            idx = 66;
        } else if (key.contains("\ucd9c\ud310\uc0ac")) {
            idx = 67;
        } else if (key.contains("\uc21c\ub3c4")) {
            idx = 68;
        } else if (key.contains("\uc0ac\uc6a9\ubaa9\uc801")) {
            idx = 69;
        } else if (key.contains("\uc0ac\uc6a9\ub300\uc0c1\uc790")) {
            idx = 70;
        } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
            idx = 71;
        } else if (key.contains("\uad00\ub78c\ub4f1\uae09")) {
            idx = 72;
        } else if (key.contains("\uc0ac\uc6a9\uc5f0\ub839")) {
            idx = 73;
        } else if (key.contains("\uc794\uc561\ud658\uae09\uc870\uac74")) {
            idx = 74;
        } else if (key.contains("\ud658\ubd88\uae30\uc900")) {
            idx = 75;
        } else if (key.contains("\ub3d9\uc77c\ubaa8\ub378 \ucd9c\uc2dc\ub144\uc6d4")) {
            idx = 76;
        } else if (key.contains("\uad00\ub828\ubc95\uc0c1 \ud45c\uc2dc\uc0ac\ud56d")) {
            idx = 77;
        } else if (key.contains("\ucd5c\uc18c \uc2dc\uc2a4\ud15c \uc0ac\uc591") || key.contains("\ud544\uc218 \uc18c\ud504\ud2b8\uc6e8\uc5b4")) {
            idx = 78;
        } else if (key.contains("\uac80\uc0ac\ud569\uaca9\uc99d \ubc88\ud638")) {
            idx = 79;
        } else if (key.contains("\uc548\uc804\uae30\uc900 \uc801\ud569")) {
            idx = 80;
        } else if (key.contains("\uc11c\ube44\uc2a4 \uc81c\uacf5 \uc0ac\uc5c5\uc790")) {
            idx = 81;
        } else if (key.contains("\uacf5\uc5f0\uc7a5\uc18c")) {
            idx = 82;
        } else if (key.contains("\uacf5\uc5f0\uc2dc\uac04")) {
            idx = 83;
        } else if (key.contains("\uce58\uc218")) {
            idx = 84;
        } else if (key.contains("\uae30\ub2a5\uc815\ubcf4") || key.contains("\uc81c\ud488 \uc8fc\uc694 \uc0ac\uc591")) {
            idx = 85;
        } else if (key.contains("\uc8fc\ucd5c \ub610\ub294 \uae30\ud68d")) {
            idx = 86;
        } else if (key.contains("\uc774\uc6a9\uc870\uac74")) {
            idx = 87;
        } else if (key.contains("\ub3c4\uc11c\uba85")) {
            idx = 88;
        } else if (key.equals("\uc885\ub958")) {
            idx = 89;
        } else if (key.contains("\ub9f5 \uc5c5\ub370\uc774\ud2b8")) {
            idx = 90;
        } else if (key.contains("\uc774\uc6a9\uc870\uac74")) {
            idx = 91;
        } else if (key.contains("\uc774\uc6a9\uac00\ub2a5\ub9e4\uc7a5")) {
            idx = 92;
        } else if (key.contains("\uc0ac\uc6a9\ubc29\ubc95")) {
            idx = 93;
        } else if (key.contains("\uc0ac\uc6a9\uae30\ud55c \ub610\ub294 \uac1c\ubd09 \ud6c4 \uc0ac\uc6a9\uae30\uac04")) {
            idx = 94;
        } else if (key.contains("\uc774\uc6a9\uac00\ub2a5\ub9e4\uc7a5")) {
            idx = 95;
        } else if (key.contains("\ud488\uc9c8\ubcf4\uc99d\uae30\uc900")) {
            idx = 96;
        } else if (key.contains("\uc911\ub7c9") || key.contains("\ud06c\uae30,\ubb34\uac8c")) {
            idx = 97;
        }
        return idx;
    }

    private void saveImage(ProductDTO syncDto, int k, String[] image) {
        switch (k) {
            case 0: {
                image[k] = syncDto.getImg_path();
                break;
            }
            case 1: {
                image[k] = syncDto.getImg_path1();
                break;
            }
            case 2: {
                image[k] = syncDto.getImg_path2();
                break;
            }
            case 3: {
                image[k] = syncDto.getImg_path3();
                break;
            }
            case 4: {
                image[k] = syncDto.getImg_path4();
                break;
            }
            case 5: {
                image[k] = syncDto.getImg_path5();
                break;
            }
            case 6: {
                image[k] = syncDto.getImg_path6();
                break;
            }
            case 7: {
                image[k] = syncDto.getImg_path7();
                break;
            }
            case 8: {
                image[k] = syncDto.getImg_path8();
                break;
            }
            case 9: {
                image[k] = syncDto.getImg_path9();
                break;
            }
            case 10: {
                image[k] = syncDto.getImg_path10();
                break;
            }
            case 11: {
                image[k] = syncDto.getImg_path11();
                break;
            }
            case 12: {
                image[k] = syncDto.getImg_path12();
                break;
            }
            case 13: {
                image[k] = syncDto.getImg_path13();
                break;
            }
            case 14: {
                image[k] = syncDto.getImg_path14();
                break;
            }
            case 15: {
                image[k] = syncDto.getImg_path15();
                break;
            }
            case 16: {
                image[k] = syncDto.getImg_path16();
                break;
            }
            case 17: {
                image[k] = syncDto.getImg_path17();
                break;
            }
            case 18: {
                image[k] = syncDto.getImg_path18();
                break;
            }
            case 19: {
                image[k] = syncDto.getImg_path19();
                break;
            }
            case 20: {
                image[k] = syncDto.getImg_path20();
                break;
            }
            case 21: {
                image[k] = syncDto.getImg_path21();
                break;
            }
            case 22: {
                image[k] = syncDto.getImg_path22();
                break;
            }
            case 23: {
                image[k] = syncDto.getImg_path23();
                break;
            }
            case 24: {
                image[k] = syncDto.getImg_path24();
            }
        }
    }

    private void setValue(String message, int value) {
        CommonProgressDialog.get().setValue(message, value);
    }

    private void setValueAndLogForProdIn(String title, int value, ProductDTO item, ShoppingmallDTO shopInfo, String jobType, String jobResult, String logMsg) {
        CommonProgressDialog.get().setValueAndLogForProdIn(title, value, item, shopInfo, jobType, jobResult, logMsg);
    }

    private void setValueAndLogForProdInfo(String title, int value, ProductDTO item, String jobType, String jobResult, String logMsg) {
        CommonProgressDialog.get().setValueAndLogForProdInfo(title, value, item, jobType, jobResult, logMsg);
    }
}

