/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.protocol.TmonOptions;
import com.kdjsystem.mlink.yellim.protocol.TmonUpdateOptionRequest;
import com.kdjsystem.mlink.yellim.shop.common.IProduct;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopTmonAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class TmonProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    private String categoryNo;
    private String dealCategoryNo;
    private String tPinCatNo;
    private String depth2catNo;
    private String optionNo;
    private String uniqueIdForDiff;
    Options options1 = new Options();
    private String dealNo;
    ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
    private String gosiNum;
    private String prodName;

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    private boolean setProductStop(String status2, ShoppingmallDTO shoppingMallDetailDto, ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws IOException {
        String json = "[" + this.dealNo + "]";
        Connection.Response rs = Jsoup.connect((String)"https://spc-om.tmon.co.kr/api/deals/close?api=1.0").cookies(loginCookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36").header("Host", "spc-om.tmon.co.kr").header("Content-Type", "application/json; charset=UTF-8").header("Origin", "https://spc-om.tmon.co.kr").referrer("https://spc-om.tmon.co.kr/").method(Connection.Method.POST).requestBody(json).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        String body = rs.body();
        JsonParser jsonparser = new JsonParser();
        JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
        JsonArray cfr_ignored_0 = (JsonArray)jsonobject.get("data");
        String Success = jsonobject.get("httpStatus").getAsString();
        if (!Success.equals("OK")) {
            shopProductDto.setResult_code("-1");
            return false;
        }
        shopProductDto.setResult_code("1");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        boolean flag = true;
        int cnt = this.getMultithreadCount();
        loginCookies.put("SpcPassCampaign", "1");
        this.dealNo = shopProductDto.getShopprodno();
        try {
            shopProductSendDto.getWorkMngDto().getWorkcd();
            switch (status2) {
                case "7": 
                case "8": {
                    flag = this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto, loginCookies);
                    if (!flag) {
                        return flag;
                    }
                    shopProductDto.setShopprodno("");
                    Thread.sleep(5000L);
                    return true;
                }
                case "0": {
                    Thread.sleep(1000L);
                    ShopTmonAdditionalDto shopTmondtllist = null;
                    shopTmondtllist = (ShopTmonAdditionalDto)shopProductSendDto.getProductAdditionDto();
                    List<Object> strImages = new ArrayList();
                    strImages = shopTmondtllist.getChangesize().equals("Y") ? this.getProductImages(shopProductDto, shopTmondtllist.getChangeSizeX(), shopTmondtllist.getChangeSizeY(), shopTmondtllist.getChangeSizeW(), shopTmondtllist.getChangeSizeH(), shopTmondtllist.getAngle(), shopTmondtllist.getScalePercent()) : this.getProductImages(shopProductDto);
                    this.setProductReg(shopProductDto, loginCookies, shopTmondtllist, shoppingMallDetailDto, strImages);
                    Thread.sleep(30000L);
                    return true;
                }
                case "6": {
                    flag = this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto, loginCookies);
                    if (!flag) {
                        return flag;
                    }
                    shopProductDto.setShopprodno("");
                    Thread.sleep(5000L);
                }
                default: {
                    return true;
                }
                case "9": 
            }
            return true;
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            return false;
        }
    }

    private int getMultithreadCount() {
        int cnt;
        try {
            cnt = ShopWorkDao.get().getMultiThreadCnt();
            int cores = Runtime.getRuntime().availableProcessors();
            if (cnt != 1 && cnt > cores / 2) {
                cnt = cores / 2;
            }
        }
        catch (Exception exception) {
            return 1;
        }
        return cnt;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        return true;
    }

    private void DownLoadImage(ShopTmonAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception, InterruptedException {
        for (String img : strImages) {
            ShopCommon.downloadImgFile(img, 720, 758);
            Thread.sleep(1000L);
        }
    }

    private void setMainOption(Map<String, String> cookies, ProductDTO dto, String dealNo, ObjectMapper mapper, ShopTmonAdditionalDto dtllist, JsonParser jsonparser, ResultMarketPrice resultMarketPrice) throws Exception {
        Option option2 = new Option();
        option2.optionHeaders = new ArrayList();
        option2.options = new ArrayList();
        option2.optionHeaders.add("\uc0c1\ud488\uba85");
        Options options = new Options();
        try {
            Connection.Response optionreg1 = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/deals/" + dealNo + "/options?seed=&api=1.0 ")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/deals/" + dealNo + "/options?ex=false").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            String option22 = optionreg1.body();
            JsonObject optionJson = (JsonObject)jsonparser.parse(option22);
            JsonObject dataJson = (JsonObject)optionJson.get("data");
            JsonArray optionsJson = (JsonArray)dataJson.get("options");
            JsonObject optionLstJson = (JsonObject)optionsJson.get(0);
            this.optionNo = optionLstJson.get("optionNo").getAsString();
            ObjectMapper mapper2 = new ObjectMapper();
            mapper2.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper2.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper2.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            options = (Options)mapper2.readValue(optionLstJson.toString(), Options.class);
            options.listPrice = resultMarketPrice.getConsumer_if_sale_price();
            options.discountPrice = resultMarketPrice.getConsumer_if_sale_price();
            int qty = Integer.parseInt(dtllist.getMaxqtyperperson()) - 1;
            options.maxBuyableQtyPerPerson = String.valueOf(qty);
            options.partnerProductCode = dto.getCompayny_goods_cd();
            options.quantity = 999;
            options.remainQuantity = 999;
            options.option0 = dto.getGoods_nm();
            option2.options.add(options);
            String optJson = "";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            optJson = mapper.writeValueAsString((Object)option2);
            Thread.sleep(1000L);
            Connection.Response optionreg = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/deals/" + dealNo + "/options?api=1.0")).cookies(cookies).header("content-type", "application/json; charset=UTF-8").requestBody(optJson).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/deals/" + dealNo + "/options?ex=false").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            optionreg.body();
            YDMAStringUtil.Print(optJson);
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158 \ub4f1\ub85d/\uc218\uc815\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String Basic(ProductDTO dto, ShopTmonAdditionalDto dtllist) throws Exception {
        String prodName = "";
        try {
            switch (dtllist.getProdoutput()) {
                case "1": {
                    prodName = dto.getGoods_nm();
                    break;
                }
                case "2": {
                    prodName = dto.getModel_nm();
                    break;
                }
                case "3": {
                    prodName = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "4": {
                    prodName = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "5": {
                    prodName = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "6": {
                    prodName = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    prodName = dto.getGoods_nm();
                }
            }
            if (!dtllist.getProdnmfirst().equals("")) {
                prodName = dtllist.getProdnmfirst().concat(prodName);
            }
            if (!dtllist.getProdnmlast().equals("")) {
                prodName = prodName.concat(dtllist.getProdnmlast());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                prodName = ShopCommon.setAddKeywordInProdName(prodName, dto.getGoods_search(), "B", 118);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                prodName = ShopCommon.setWordRandomGenerator(prodName);
            }
            if (prodName.length() > 118) {
                prodName = prodName.substring(0, 110);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85 \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return prodName;
    }

    private void setSave(Map<String, String> cookies, ProductDTO dto, ShopTmonAdditionalDto dtllist, Deal productDealData, String dealNo, ObjectMapper mapper, JsonParser jsonparser, String status2, ResultMarketPrice resultMarketPrice, String prodName) throws Exception {
        try {
            Deal deal = new Deal();
            deal.dealNo = Long.valueOf(dealNo);
            deal.partnerNo = productDealData.partnerNo;
            deal.isOM = productDealData.isOM;
            deal.isExternal = productDealData.isExternal;
            deal.status = productDealData.status;
            deal.contentsMaker = productDealData.contentsMaker;
            deal.dealFrom = productDealData.dealFrom;
            deal.isHide = productDealData.isHide;
            deal.isPause = productDealData.isPause;
            deal.tagNo = 0L;
            deal.isContract = productDealData.isContract;
            deal.salesManager = new SalesManager();
            deal.salesManager.name = productDealData.salesManager.name;
            deal.salesManager.phoneNumber = productDealData.salesManager.phoneNumber;
            deal.salesManager.email = productDealData.salesManager.email;
            deal.title = prodName;
            deal.categoryNo = productDealData.categoryNo;
            deal.dealCategoryNo = productDealData.dealCategoryNo;
            deal.selectedCatFullName = dto.getClass_nm1();
            deal.babyFilterNos = new ArrayList();
            deal.requiredDoc = "";
            LocalDate.now();
            LocalTime.now();
            try {
                Connection.Response rs = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/deals/" + dealNo + "/detail")).cookies(cookies).header("content-type", "application/json; charset=UTF-8").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/detail/" + dealNo).method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
                String body = rs.body();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode rootNode = objectMapper.readTree(body);
                JsonNode startDateNode = rootNode.path("data").path("data").path("deal").path("startDate");
                deal.startDate = new StartDate();
                deal.startDate.year = startDateNode.path("year").asInt();
                deal.startDate.monthValue = startDateNode.path("monthValue").asInt();
                deal.startDate.dayOfMonth = startDateNode.path("dayOfMonth").asInt();
                deal.startDate.hour = startDateNode.path("hour").asInt();
                deal.startDate.minute = startDateNode.path("minute").asInt();
                deal.startDate.second = startDateNode.path("second").asInt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            deal.endDate = new EndDate();
            deal.endDate.year = 2099;
            deal.endDate.monthValue = 12;
            deal.endDate.dayOfMonth = 31;
            deal.endDate.hour = 23;
            deal.endDate.minute = 59;
            deal.endDate.second = 59;
            deal.allTimesSale = "Y";
            deal.listPriceSource = productDealData.listPriceSource;
            deal.reasonOfListPriceSource = "\uc624\ud508\ub9c8\ucf13\uc5d0\uc11c \ucc45\uc815\ud55c \ud310\ub9e4\uac00\uaca9\uc785\ub2c8\ub2e4.";
            deal.minPurchasableQtyPerPerson = 1;
            deal.initPeriodOfPurchaseLimit = Integer.parseInt(dtllist.getPurchaselimit());
            deal.maxPurchasableQtyPerPerson = Integer.parseInt(dtllist.getMaxqtyperperson());
            deal.listPrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
            deal.discountPrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
            deal.discountRate = 0;
            deal.forSaleOnMobile = "Y";
            deal.reasonOfNotForSaleOnMobile = "";
            deal.onlyForSaleOnMobile = "N";
            deal.collectibleSocialNo = "Y";
            deal.adultConfirmation = dtllist.getAdultconfirmation();
            deal.isKcAuth = "N";
            deal.isTaxBaseCoupon = "Y";
            deal.isEncore = "N";
            deal.kcAuthInfos = new ArrayList();
            deal.isHotNotice = "N";
            deal.hotNotices = new ArrayList();
            deal.productStatus = dtllist.getProductstatus();
            deal.sellMethod = dtllist.getSellmethod();
            deal.createdAt = YDMATimeUtil.getCurrentDateScheduler();
            deal.updatedAt = YDMATimeUtil.getCurrentTimeByYDFormat();
            deal.deliverySpot = productDealData.deliverySpot;
            deal.showCategoryNo = 0;
            deal.scCatYn = "N";
            deal.deliveryAgentType = "N";
            deal.deliveryProductType = productDealData.deliveryProductType;
            deal.deliveryType = "";
            deal.theDayDeliveryStartTime = productDealData.theDayDeliveryStartTime;
            deal.isCollectIdentify = "N";
            deal.isReturnCargo = productDealData.isReturnCargo;
            deal.returnCargoType = productDealData.returnCargoType;
            deal.deliveryFeePolicy = productDealData.deliveryFeePolicy;
            deal.deliveryFee = productDealData.deliveryFee;
            deal.deliveryFeeInConditional = productDealData.deliveryFeeInConditional;
            deal.deliveryFeeSrl = productDealData.deliveryFeeSrl;
            deal.deliveryCorpType = dtllist.getDeliverycorptype();
            deal.isLongDistanceDelivery = "N";
            deal.isLongDistanceAddDeliveryFee = "N";
            deal.longDistanceAddDeliveryFee = "";
            deal.isDifferentGradeDeliveryFeePerLocal = dtllist.getDifferentdeliveryfee();
            deal.differentGradeDeliveryContentsPerLocal = dtllist.getDifferentdeliveryfeecontents();
            deal.separateInstallmentFee = "N";
            deal.maxItemNumPerBox = 0;
            deal.deliveryManagerInfo = new DeliveryManagerInfo();
            deal.returnDeliveryManagerInfo = new ReturnDeliveryManagerInfo();
            deal.needForAddMessage = "N";
            deal.addMessage = "";
            deal.refundType = "S";
            deal.reasonOfNoRefund = "";
            deal.kcConfirmFiles = new ArrayList();
            deal.priceBaseFiles = new ArrayList();
            deal.adConfirmFiles = new ArrayList();
            deal.etcRequiredFiles = new ArrayList();
            deal.importFiles = new ArrayList();
            deal.liveDeal = false;
            deal.preparedForModificationApproval = false;
            deal.babyFilterCategory = false;
            deal.preparedForCreationApproval = false;
            deal.rssBlockDealsUseYn = dtllist.getPricecomparison();
            deal.brand = new Brand();
            deal.brand.mainDealNo = Long.valueOf(dealNo);
            deal.brand.brandNo = "0";
            deal.brand.brandNm = dto.getBrand_nm();
            deal.brand.brandSubNm = "";
            deal.brand.visible = true;
            deal.brand.mainBrandYn = dto.getBrand_nm().equals("") ? "N" : "Y";
            deal.brand.useYn = dto.getBrand_nm().equals("") ? "N" : "Y";
            deal.brand.updater = "";
            deal.brand.viewName = dto.getBrand_nm();
            deal.employee = new Employee();
            deal.employee.adId = "";
            deal.employee.corpEmail = "";
            deal.employee.deptCode = "";
            deal.employee.deptMail = "";
            deal.employee.deptNameKo = "";
            deal.employee.empNo = "";
            deal.employee.fullNameKo = "";
            deal.employee.isManager = false;
            deal.employee.mobileTelNo = "";
            deal.employee.officeTelNo = "";
            deal.employee.parentDeptCode = "";
            deal.employee.positionName = "";
            deal.employee.rankName = "";
            deal.categoryChangeYn = false;
            deal.depth2catNo = productDealData.depth2catNo;
            deal.selectedCatNo = productDealData.dealCategoryNo;
            deal.hotNoticeContent = "";
            String dealJson = "";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            dealJson = mapper.writeValueAsString((Object)deal);
            YDMAStringUtil.Print(dealJson);
            Thread.sleep(1000L);
            Connection.Response deal1 = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/deals/" + dealNo + "/" + status2 + "?api=1.0 ")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").header("Content-Type", "application/json; charset=UTF-8").requestBody(dealJson).referrer("https://spc-om.tmon.co.kr/").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String deal2 = deal1.body();
            JsonObject jsonobject = (JsonObject)jsonparser.parse(deal2);
            JsonObject jsonobject1 = (JsonObject)jsonobject.get("data");
            String result = jsonobject1.get("result").getAsString();
            if (!result.equals("OK")) {
                String message = jsonobject1.get("errorMsg").getAsString();
                if (status2.equals("save")) {
                    throw new Exception("\uc784\uc2dc \uc800\uc7a5\uc5d0 \uc2e4\ud328 \ud588\uc2b5\ub2c8\ub2e4. " + message);
                }
                throw new Exception("\uc0c1\ud488 \ub4f1\ub85d\uc5d0 \uc2e4\ud328 \ud588\uc2b5\ub2c8\ub2e4. " + message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private void dealInfomation(ProductDTO dto, Map<String, String> cookies, ShopTmonAdditionalDto dtllist, String dealNo, JsonParser jsonparser, ShoppingmallDTO shoppingMallDetailDto, List<String> strImages, ObjectMapper mapper, ResultMarketPrice resultMarketPrice, String prodName) throws Exception {
        String originCountry = "";
        try {
            originCountry = dto.getOrigin().contains("\uad6d\ub0b4\uc0b0") || dto.getOrigin().contains("\ub300\ud55c\ubbfc\uad6d") ? "O" : "D";
            Connection.Response prodInfo = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/designContent/" + dealNo)).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/deals/" + dealNo + "/designContent?ex=false").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            String prodIfomation = prodInfo.body();
            JsonObject prodInfo1 = (JsonObject)jsonparser.parse(prodIfomation);
            JsonObject prodInfo2 = (JsonObject)prodInfo1.get("data");
            String flagUnitSale = prodInfo2.get("flagUnitSale").getAsString();
            String useInfoTitle1 = prodInfo2.get("useInfoTitle1").getAsString();
            String useInfoTitle2 = prodInfo2.get("useInfoTitle2").getAsString();
            String useInfoDesc1 = prodInfo2.get("useInfoDesc1").getAsString();
            String useInfoDesc2 = prodInfo2.get("useInfoDesc2").getAsString();
            String imgpath = null;
            try {
                if (shoppingMallDetailDto.getSHOPCD().equals("shop0076")) {
                    imgpath = ShopCommon.getImgLocalPath2(strImages.get(0));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File file = new File(!imgpath.contains(".jpg") ? strImages.get(0) : imgpath);
            String fileName = file.getName();
            String imgFront = "";
            String imgMobile = "";
            String imgCatList3ColV2 = "";
            String imgAround = "";
            Connection.Response imageReg = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/designContent/uploadFile/" + dealNo + "/rule/front/maxSize/2048000")).cookies(cookies).header("Origin", "https://spc-om.tmon.co.kr").data("Filedata", fileName, (InputStream)new FileInputStream(file)).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/deals/" + dealNo + "/designContent?ex=false").method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
            String imageReg1 = imageReg.body();
            JsonObject image1 = (JsonObject)jsonparser.parse(imageReg1);
            JsonObject image2 = (JsonObject)image1.get("data");
            JsonArray image3 = (JsonArray)image2.get("dealImagesInfoList");
            int i = 0;
            while (i < image3.size()) {
                JsonObject image4 = (JsonObject)image3.get(i);
                switch (i) {
                    case 0: {
                        imgFront = image4.get("imageValue").getAsString();
                        break;
                    }
                    case 1: {
                        imgMobile = image4.get("imageValue").getAsString();
                        break;
                    }
                    case 2: {
                        imgCatList3ColV2 = image4.get("imageValue").getAsString();
                        break;
                    }
                    case 3: {
                        imgAround = image4.get("imageValue").getAsString();
                    }
                }
                ++i;
            }
            Connection.Response imageReg2 = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/smartImage/uploadImg/" + dealNo + "/summary")).cookies(cookies).header("Origin", "https://spc-om.tmon.co.kr").data("file", fileName, (InputStream)new FileInputStream(file)).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/deals/" + dealNo + "/designContent?ex=false").method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
            String imageReg3 = imageReg2.body();
            JsonObject imageReg4 = (JsonObject)jsonparser.parse(imageReg3);
            JsonObject imageReg5 = (JsonObject)imageReg4.get("data");
            JsonArray imageReg6 = (JsonArray)imageReg5.get("fileObject");
            String thmb = imageReg6.get(0).getAsString();
            String mainData = "{\"tmplNo\":\"1\",\"depth\":\"1\",\"summaryCols\":\"column1\",\"saveType\":\"DN\",\"viewPrice\":\"Y\"}";
            String data2 = "[{\"" + this.optionNo + "\":{\"thmb\":\"" + thmb + "\",\"subject\":\"" + prodName + "\"," + "\"detail\":\"\",\"bcolor\":\"\",\"child\":\"\"}}]";
            Connection.Response loadSummary = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/smartImage/save/loadSummary/" + dealNo)).cookies(cookies).header("Content-type", "application/x-www-form-urlencoded; charset=UTF-8").header("Origin", "https://spc-om.tmon.co.kr").data("saveType", "DN").data("data", data2).data("mainData", mainData).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/deals/" + dealNo + "/designContent?ex=false").method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
            loadSummary.body();
            String remark = dtllist.getRemarkfirst().concat(dto.getGoods_remarks()).concat(dtllist.getRemarklast());
            remark = remark.replaceAll("\"", "'");
            String addDetailPlus = "";
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = String.valueOf(dtllist.getDetailKeywordL()) + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            String data1 = "[{\"" + this.optionNo + "\":\"" + addDetailPlus + remark + "\"}]";
            data1 = data1.replaceAll("\r\n", "");
            data1 = data1.replaceAll("\n", "");
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> removetag = new ArrayList<String>();
            List<Object> keywordList = new ArrayList<String>();
            ArrayList<String> search = new ArrayList<String>();
            if (dto.getExcepkeywdyn().equals("Y")) {
                removetag.addAll(Arrays.asList(dto.getExcepkeywd().split(",")));
                list.addAll(Arrays.asList(dto.getGoods_search().split(",")));
                keywordList = IProduct.checkSearch(list, removetag, search);
            } else {
                keywordList.addAll(Arrays.asList(dto.getGoods_search().split(",")));
            }
            search.clear();
            int i2 = 0;
            while (i2 < keywordList.size()) {
                if (i2 < 5) {
                    search.add((String)keywordList.get(i2));
                }
                ++i2;
            }
            prodName = YDMAStringUtil.setTextStrtok(prodName, 60);
            Connection.Response designContent = Jsoup.connect((String)"https://spc-om.tmon.co.kr/api/designContent/edit").cookies(cookies).data("summaryYn", "Y").data("dealNo", dealNo).data("flagType", "S").data("dealType", "opt_no").data("flagUnitSale", flagUnitSale).data("orgPriceTitle", "").data("orgPriceContent", "").data("orgPriceView", "Y").data("flagEnableSearch", dtllist.getSearchexposure()).data("originCountry", originCountry).data("originCountryDesc", "").data("searchKeyword", search.stream().collect(Collectors.joining(" "))).data("titleName", prodName).data("title", dtllist.getProdnmtop().equals("") ? YDMAStringUtil.setTextStrtok(dto.getGoods_nm(), 30) : dtllist.getProdnmtop()).data("titleList", dtllist.getProdnmtop().equals("") ? YDMAStringUtil.setTextStrtok(dto.getGoods_nm(), 30) : dtllist.getProdnmtop()).data("titlePoint", dtllist.getProdnmtop().equals("") ? YDMAStringUtil.setTextStrtok(dto.getGoods_nm(), 30) : dtllist.getProdnmtop()).data("titleApp", prodName).data("titleTextBanner", prodName).data("titleImgSub", dtllist.getProdnmtop().equals("") ? YDMAStringUtil.setTextStrtok(dto.getGoods_nm(), 30) : dtllist.getProdnmtop()).data("titleImg", prodName).data("titleImgPoint", "").data("summaryText", "\uc0c1\ud488\uba85" + prodName + "\uc815\uc0c1\uac00 " + resultMarketPrice.getConsumer_if_sale_price() + "\uc6d0" + "\ud560\uc778\uac00" + resultMarketPrice.getConsumer_if_sale_price() + "\uc6d0").data("useInfoTitle1", String.valueOf(useInfoTitle1) + "\\;\\;").data("useInfoTitle2", String.valueOf(useInfoTitle2) + "\\;\\;").data("useInfoTitle3", "\\;\\;").data("useInfoTitle4", "\\;\\;").data("useInfoTitle5", "\\;\\;").data("useInfoTitle6", "\\;\\;").data("useInfoDesc1", useInfoDesc1).data("useInfoDesc2", useInfoDesc2).data("useInfoDesc3", "").data("useInfoDesc4", "").data("useInfoDesc5", "").data("useInfoDesc6", "").data("imgCatList3ColV2", imgCatList3ColV2).data("imgFront", imgFront).data("imgMobile", imgMobile).data("imgAround", imgAround).data("imgSummary", "").data("imgReviewContent", "").data("imgMobileContent", "").data("imgMiscContent", "").data("reApprovalMessage", "").data("mode", "DIRECT").header("Origin", "https://spc-om.tmon.co.kr").header("Host", "spc-om.tmon.co.kr").header("Connection", "keep-alive").header("content-type", "application/x-www-form-urlencoded; charset=UTF-8").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/deals/" + dealNo + "/designContent?ex=false").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            designContent.body();
            Connection.Response Summary = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/smartImage/save/summary/" + dealNo)).cookies(cookies).header("Content-type", "application/x-www-form-urlencoded; charset=UTF-8").header("Origin", "https://spc-om.tmon.co.kr").data("saveType", "DN").data("data", data2).data("mainData", mainData).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/deals/" + dealNo + "/designContent?ex=false").method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
            Summary.body();
            Connection.Response saveSmartImage = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/smartImage/save/review/" + dealNo)).cookies(cookies).header("Content-type", "application/x-www-form-urlencoded; charset=UTF-8").header("Origin", "https://spc-om.tmon.co.kr").data("saveType", "DN").data("data", data1).data("mainData", mainData).data("viewPrice", "Y").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/deals/" + dealNo + "/designContent?ex=false").method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).execute();
            saveSmartImage.body();
            Connection.Response optionreg = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/deals/" + dealNo + "/supplement_status?api=1.0")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            optionreg.body();
        }
        catch (Exception exception) {
            throw new Exception("\ucee8\ud150\uce20 \uc815\ubcf4 \ub4f1\ub85d\uc5d0 \uc2e4\ud328 \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getCateinfo(Map<String, String> cookies, JsonParser jsonparser, String cateNum) throws Exception {
        Thread.sleep(1000L);
        Connection.Response cate = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/categories/" + cateNum + "?scCatYn=N&api=1.0")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        String cateBody = cate.body();
        JsonObject cate1 = (JsonObject)jsonparser.parse(cateBody);
        JsonObject cate2 = (JsonObject)cate1.get("data");
        JsonObject cate3 = (JsonObject)cate2.get("data");
        this.categoryNo = cate3.get("salesCatNo").toString();
        this.dealCategoryNo = cate3.get("leafCatNo").toString();
        this.tPinCatNo = cate3.get("tpinCatNo").toString();
        this.depth2catNo = cate3.get("vwCatNo1").toString();
    }

    private void deliveryTemplate(Map<String, String> cookies, ShopTmonAdditionalDto dtllist, Deal productDealData, JsonParser jsonparser, String dealNo) throws IOException {
        String deliveryTemplateNo = dtllist.getDeliveryfeesrl();
        Connection.Response deliveryTemplate = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/delivery/template?&partnerNo=" + productDealData.partnerNo + "&detail=true&includeMainDealNo=" + dealNo + "&api=1.0")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        String deliveryTemplate1 = deliveryTemplate.body();
        JsonObject template1 = (JsonObject)jsonparser.parse(deliveryTemplate1);
        JsonObject template2 = (JsonObject)template1.get("data");
        JsonArray template3 = (JsonArray)template2.get("list");
        int i = 0;
        while (i < template3.size()) {
            JsonObject data2 = (JsonObject)template3.get(i);
            if (data2.get("deliveryFeeSrl").getAsString().equals(deliveryTemplateNo)) {
                JsonObject data1 = (JsonObject)data2.get("detail");
                JsonObject data22 = (JsonObject)data1.get("deliveryFeeInfo");
                JsonObject data3 = (JsonObject)data22.get("deliveryFeePolicy");
                new Template();
                JsonArray arrayData = (JsonArray)data22.get("deliveryProductTypes");
                Template.deliveryProductType = arrayData.get(0).getAsString();
                Template.theDayDeliveryStartTime = data22.get("ddayDeliveryTime").isJsonNull() ? "00:00:00" : data22.get("ddayDeliveryTime").getAsString();
                Template.isReturnCargo = data22.get("returnCargoYn").getAsString();
                Template.returnCargoType = data22.get("returnCargoType").isJsonNull() ? "H" : data22.get("returnCargoType").getAsString();
                Template.deliveryFee = data22.get("deliveryAmount").getAsString();
                Template.deliveryFeeInConditional = data22.get("deliveryIfAmount").getAsString();
                Template.deliveryFeePolicy = data3.get("code").getAsString();
            }
            ++i;
        }
    }

    private String setProductReg(ProductDTO dto, Map<String, String> cookies, ShopTmonAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto, List<String> strImages) throws Exception {
        JsonParser jsonparser = new JsonParser();
        ObjectMapper mapper = new ObjectMapper();
        Deal productDealData = null;
        try {
            String prodName = this.Basic(dto, dtllist);
            String price_cost = dto.getGoods_cost();
            int deliveryFee = 0;
            if (dtllist.getFreedelivery().equals("Y") && dtllist.getFreedelivery().equals("Y")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDELIVERYCOST();
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                price_cost = String.valueOf(YDMAStringUtil.convertToLong(price_cost) + (long)deliveryFee);
            }
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            this.resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(this.resultMarketPrice.getConsumer_if_sale_price())) {
                this.resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            Connection.Response rs1 = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/deals/" + this.dealNo + "/detail?api=1.0")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            String body1 = rs1.body();
            JsonObject dealJson11 = (JsonObject)jsonparser.parse(body1);
            JsonObject dealJson1 = (JsonObject)dealJson11.get("data");
            JsonObject dealJson2 = (JsonObject)dealJson1.get("data");
            String dealJson3 = dealJson2.get("deal").toString();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            productDealData = (Deal)mapper.readValue(dealJson3, Deal.class);
            this.salePrice(dto, dtllist);
            this.setMainOption(cookies, dto, this.dealNo, mapper, dtllist, jsonparser, this.resultMarketPrice);
            this.dealInfomation(dto, cookies, dtllist, this.dealNo, jsonparser, shoppingMallDetailDto, strImages, mapper, this.resultMarketPrice, prodName);
            this.setSave(cookies, dto, dtllist, productDealData, this.dealNo, mapper, jsonparser, "complete", this.resultMarketPrice, prodName);
        }
        catch (Exception e) {
            throw new Exception("\uc218\uc815\ub4f1\ub85d\uc5d0 \uc2e4\ud328 \ud588\uc2b5\ub2c8\ub2e4. " + e.getMessage());
        }
        return null;
    }

    private void salePrice(ProductDTO dto, ShopTmonAdditionalDto dtllist) throws Exception {
        try {
            String price_cost = dto.getGoods_cost();
            int deliveryFee = 0;
            if (Template.deliveryFeePolicy != null && Template.deliveryFeePolicy.equals("FREE") && dtllist.getFreedelivery().equals("Y")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDELIVERYCOST();
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                price_cost = String.valueOf(YDMAStringUtil.convertToLong(price_cost) + (long)deliveryFee);
            }
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            this.resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(this.resultMarketPrice.getConsumer_if_sale_price())) {
                this.resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            dto.setGoods_price(this.resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(this.resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(this.resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00 \uacc4\uc0b0\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private List<GosiTemplate> getGosiInfo(Map<String, String> cookies, JsonParser jsonparser, ProductDTO dto) throws Exception {
        this.gosiNum = ShopProductDao.get().getTmonGosiNum(dto.getProp1_cd());
        Thread.sleep(1000L);
        Connection.Response gosi = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/product_info_provide/template/" + this.gosiNum + "?api=1.0")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        String body3 = gosi.body();
        JsonObject gosiObject = (JsonObject)jsonparser.parse(body3);
        JsonArray jsonArray = (JsonArray)gosiObject.get("data");
        ArrayList<GosiTemplate> gosiList = new ArrayList<GosiTemplate>();
        int i = 0;
        while (i < jsonArray.size()) {
            JsonObject gosiObject1 = (JsonObject)jsonArray.get(i);
            GosiTemplate gosiTemplate = new GosiTemplate();
            gosiTemplate.seqNo = gosiObject1.get("seqNo").getAsString();
            gosiTemplate.title = gosiObject1.get("title").getAsString();
            gosiTemplate.contents = gosiObject1.get("contents").isJsonNull() ? "" : gosiObject1.get("contents").getAsString();
            gosiTemplate.fixedContents = gosiObject1.get("fixedContents").getAsString();
            gosiTemplate.prodDetailInfoRefUseYN = gosiObject1.get("prodDetailInfoRefUseYN").getAsString();
            gosiTemplate.requiredItem1 = gosiObject1.get("requiredItem1").isJsonNull() ? "" : gosiObject1.get("requiredItem1").getAsString();
            gosiTemplate.requiredItem2 = gosiObject1.get("requiredItem2").isJsonNull() ? "" : gosiObject1.get("requiredItem2").getAsString();
            gosiTemplate.requiredItem2Option = gosiObject1.get("requiredItem2Option").isJsonNull() ? "" : gosiObject1.get("requiredItem2Option").getAsString();
            gosiList.add(gosiTemplate);
            ++i;
        }
        return gosiList;
    }

    private void GosiJson(Map<String, String> cookies, JsonParser jsonparser, String dealNo, ObjectMapper mapper, List<GosiTemplate> gosiList, ProductDTO dto) throws Exception {
        try {
            Connection.Response gosiNumber = Jsoup.connect((String)"https://spc-om.tmon.co.kr/api/product_info_provide/?api=1.0").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://spc-om.tmon.co.kr/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            String body2 = gosiNumber.body();
            JsonObject gosiObject3 = (JsonObject)jsonparser.parse(body2);
            JsonArray jsonArray3 = (JsonArray)gosiObject3.get("data");
            String productType = null;
            int i = 0;
            while (i < jsonArray3.size()) {
                JsonObject object = (JsonObject)jsonArray3.get(i);
                if (object.get("productInfoProvideTypeNo").toString().equals(this.gosiNum)) {
                    productType = object.get("productInfoProvideName").getAsString();
                }
                ++i;
            }
            Product_info_Provide product_into_Provide = new Product_info_Provide();
            product_into_Provide.success = "true";
            product_into_Provide.kft = new ArrayList();
            Kft kft = new Kft();
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            kft.productype = productType;
            kft.items = new ArrayList();
            int i2 = 0;
            while (i2 < gosiList.size()) {
                Items items = new Items();
                items.key = gosiList.get(i2).title;
                String key = gosiList.get(i2).title.substring(3);
                items.value = new Value();
                ShopProdAttrnmDto shopProdAttrnmDto = dto.getShopProdAttrnmDtos().stream().filter(d -> d.getAttrnm().contains(key)).findAny().orElse(null);
                dto.getShopProdAttrnmDtos().get(i2).getAttrnm();
                if (shopProdAttrnmDto == null) {
                    items.value.contents = "\uc0c1\ud488\uc0c1\uc138\uc124\uba85 \ucc38\uc870";
                } else {
                    items.value.contents = shopProdAttrnmDto.getProp_val();
                }
                items.value.refUseYN = gosiList.get(i2).prodDetailInfoRefUseYN;
                kft.items.add(items);
                ++i2;
            }
            product_into_Provide.kft.add(kft);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            String gosiJson = mapper.writeValueAsString((Object)product_into_Provide);
            YDMAStringUtil.Print(gosiJson);
            Connection.Response gosi1 = Jsoup.connect((String)("https://spc-om.tmon.co.kr/api/deals/" + dealNo + "/product_info_provide?api=1.0")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").header("Content-Type", "application/json; charset=UTF-8").requestBody(gosiJson).referrer("https://spc-om.tmon.co.kr/popup?title=\uc0c1\ud488\uc815\ubcf4\uc81c\uacf5\uace0\uc2dc&app=prodInfoApp&cmp=prod-info&dealNo=" + dealNo + "&categoryNo=0&isExternal=N").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String gosiinfo = gosi1.body();
            JsonObject gosiObject1 = (JsonObject)jsonparser.parse(gosiinfo);
            JsonObject gosiObject2 = (JsonObject)gosiObject1.get("data");
            gosiObject2.get("result").toString();
        }
        catch (Exception exception) {
            throw new Exception("\uace0\uc2dc\uc815\ubcf4 \ub4f1\ub85d \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private boolean setProductStop(ProductDTO prodInfo, Map<String, String> cookies) throws IOException {
        String json = "[" + prodInfo.getShopprodno() + "]";
        Connection.Response rs = Jsoup.connect((String)"https://spc-om.tmon.co.kr/api/deals/close?api=1.0").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36").header("Host", "spc-om.tmon.co.kr").header("Content-Type", "application/json; charset=UTF-8").header("Origin", "https://spc-om.tmon.co.kr").referrer("https://spc-om.tmon.co.kr/").method(Connection.Method.POST).requestBody(json).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        String body = rs.body();
        JsonParser jsonparser = new JsonParser();
        JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
        JsonArray cfr_ignored_0 = (JsonArray)jsonobject.get("data");
        String Success = jsonobject.get("httpStatus").getAsString();
        if (!Success.equals("OK")) {
            prodInfo.setResult_code("-1");
            return false;
        }
        prodInfo.setResult_code("1");
        return true;
    }

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto) throws Exception {
        boolean flag = true;
        String shopInfoLog = String.format("[%s - %s(%s)]", dto.getSHOPINFO().getSHOPNM(), dto.getSHOPINFO().getSHOPPINGID(), dto.getSHOPINFO().getNICKNM1());
        dto.getCOOKIES().put("SpcPassCampaign", "1");
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 3000: 
                case 4000: {
                    flag = this.setProductStop(dto.getPRODUCT(), dto.getCOOKIES());
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, dto.getPRODUCT(), "\ud310\ub9e4\uc885\ub8cc", dto.getSHOPINFO(), "\uc131\uacf5", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc885\ub8cc \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    Thread.sleep(5000L);
                }
            }
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        ArrayList<TmonOptions> requestOptions = new ArrayList<TmonOptions>();
        try {
            List<ProductOptionDTO> options = dto.getPRODUCT().getOPTIONS();
            List<TmonOptions> oldOptions = this.getTmonOptionDatas(dto);
            for (TmonOptions oldOption : oldOptions) {
                ProductOptionDTO filter = options.stream().filter(p -> Long.parseLong(p.getSHOPPRODSKU()) == oldOption.getOptionNo()).findFirst().orElse(null);
                if (filter != null) {
                    if (oldOption.getIsMainOption() == 1) continue;
                    oldOption.setQuantity(0);
                    oldOption.setRemainQuantity(0);
                    oldOption.setIsSoldout("Y");
                }
                requestOptions.add(oldOption);
            }
            options.sort((p1, p2) -> Integer.compare(p1.getSKUSEQ(), p2.getSKUSEQ()));
            String json = this.getOptionModifyJson(requestOptions, options);
            Connection.Response response = Jsoup.connect((String)MallCode.getTmonProductOptionSearchURL(dto.getPRODUCT().getShopprodno())).cookies(dto.getCOOKIES()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer(MallCode.getTmonProductOptionSearchReferer(dto.getPRODUCT().getShopprodno())).header("Host", "spc-om.tmon.co.kr").header("Origin", "https://spc-om.tmon.co.kr").header("Content-Type", "application/json").method(Connection.Method.POST).requestBody(json).followRedirects(true).ignoreHttpErrors(true).followRedirects(true).ignoreContentType(true).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject bodyObj = (JsonObject)parser.parse(body);
            if (bodyObj.get("httpCode").getAsInt() == 200) {
                return new ResultProcessDTO(0, bodyObj.get("httpStatus").getAsString(), dto.getPRODUCT().getCompayny_goods_cd());
            }
            return new ResultProcessDTO(-1, bodyObj.get("httpStatus").getAsString(), dto.getPRODUCT().getCompayny_goods_cd());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getCompayny_goods_cd());
        }
    }

    private List<TmonOptions> getTmonOptionDatas(ProductModifyProcessDTO dto) {
        ArrayList<TmonOptions> options = new ArrayList<TmonOptions>();
        try {
            Connection.Response response = Jsoup.connect((String)MallCode.getTmonProductOptionSearchURL(dto.getPRODUCT().getShopprodno())).header("Host", "spc-om.tmon.co.kr").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer(MallCode.getTmonProductOptionSearchReferer(dto.getPRODUCT().getShopprodno())).method(Connection.Method.GET).cookies(dto.getCOOKIES()).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = (JsonObject)parser.parse(body);
            JsonObject data2 = (JsonObject)object.get("data");
            JsonArray optionsArr = (JsonArray)data2.get("options");
            int i = 0;
            while (i < optionsArr.size()) {
                JsonObject optionObj = optionsArr.get(i).getAsJsonObject();
                TmonOptions option2 = new TmonOptions();
                option2.setOptionNo(optionObj.get("optionNo").getAsLong());
                option2.setDealNo(optionObj.get("dealNo").getAsLong());
                option2.setStatus(optionObj.get("status").getAsString());
                option2.setListPrice(optionObj.get("listPrice").getAsInt());
                option2.setDiscountPrice(optionObj.get("discountPrice").getAsInt());
                option2.setDiscountRate(optionObj.get("discountRate").getAsInt());
                option2.setQuantity(optionObj.get("quantity").getAsInt());
                option2.setBuyCount(optionObj.get("buyCount").getAsInt());
                option2.setRemainQuantity(optionObj.get("remainQuantity").getAsInt());
                option2.setMaxBuyableQtyPerPerson(optionObj.get("maxBuyableQtyPerPerson").getAsInt());
                option2.setTotalServiceFee(optionObj.get("totalServiceFee").getAsInt());
                option2.setDepositPrice(optionObj.get("depositPrice").getAsInt());
                option2.setDepth(optionObj.get("depth").getAsInt());
                option2.setPartnerProductCode(optionObj.get("partnerProductCode").getAsString());
                option2.setIsMainOption(optionObj.get("isMainOption").getAsInt());
                option2.setDealMaxNo(optionObj.get("dealMaxNo").getAsLong());
                option2.setIsDisplayed(optionObj.get("isDisplayed").getAsString());
                option2.setIsSoldout(optionObj.get("isSoldout").getAsString());
                option2.setUniqueIdForDiff(optionObj.get("uniqueIdForDiff").getAsString());
                option2.setOptionTitle(optionObj.get("optionTitle").getAsString());
                option2.setFullOptionNames(optionObj.get("fullOptionNames").getAsString());
                if (option2.getDepth() == 2) {
                    option2.setOption0(optionObj.get("option0").getAsString());
                    option2.setOption1(optionObj.get("option1").getAsString());
                } else if (option2.getDepth() == 3) {
                    option2.setOption0(optionObj.get("option0").getAsString());
                    option2.setOption1(optionObj.get("option1").getAsString());
                    option2.setOption2(optionObj.get("option2").getAsString());
                }
                options.add(option2);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }

    private String getOptionModifyJson(List<TmonOptions> optionParams, List<ProductOptionDTO> soldoutOptions) {
        try {
            ArrayList<String> optionHeaders = new ArrayList<String>();
            String[] names = soldoutOptions.get(0).getOPTPRODNM().split("/");
            if (names.length == 1) {
                optionHeaders.add("\uc0c1\ud488\uba85");
                optionHeaders.add(names[0]);
            } else if (names.length == 2) {
                optionHeaders.add("\uc0c1\ud488\uba85");
                optionHeaders.add(names[0]);
                optionHeaders.add(names[1]);
            }
            TmonUpdateOptionRequest request2 = new TmonUpdateOptionRequest();
            request2.setOptionHeaders(optionHeaders);
            request2.setOptions(optionParams);
            request2.setSortType("N");
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString((Object)request2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String logType) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackAndLogForProdIn(comment, 50, prodInfo, shoppingmallDTO, "YEL_DEL", jobResult, logType);
    }

    private static class AdConfirmFiles {
        private AdConfirmFiles() {
        }
    }

    private static class BabyFilterNos {
        private BabyFilterNos() {
        }
    }

    private static class Brand {
        @JsonProperty(value="mainDealNo")
        private Long mainDealNo;
        @JsonProperty(value="brandNo")
        private String brandNo;
        @JsonProperty(value="brandNm")
        private String brandNm;
        @JsonProperty(value="brandSubNm")
        private String brandSubNm;
        @JsonProperty(value="visible")
        private boolean visible;
        @JsonProperty(value="mainBrandYn")
        private String mainBrandYn;
        @JsonProperty(value="useYn")
        private String useYn;
        @JsonProperty(value="updater")
        private String updater;
        @JsonProperty(value="viewName")
        private String viewName;

        private Brand() {
        }
    }

    private static class Chronology {
        @JsonProperty(value="calendarType")
        private String calendarType;
        @JsonProperty(value="id")
        private String id;

        private Chronology() {
        }
    }

    private static class Deal {
        @JsonProperty(value="dealNo")
        private Long dealNo;
        @JsonProperty(value="partnerNo")
        private int partnerNo;
        @JsonProperty(value="isOM")
        private String isOM;
        @JsonProperty(value="isExternal")
        private String isExternal;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="contentsMaker")
        private String contentsMaker;
        @JsonProperty(value="dealFrom")
        private String dealFrom;
        @JsonProperty(value="isHide")
        private String isHide;
        @JsonProperty(value="isPause")
        private String isPause;
        @JsonProperty(value="tagNo")
        private Long tagNo;
        @JsonProperty(value="isContract")
        private String isContract;
        @JsonProperty(value="salesManager")
        private SalesManager salesManager;
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="categoryNo")
        private int categoryNo;
        @JsonProperty(value="dealCategoryNo")
        private int dealCategoryNo;
        @JsonProperty(value="babyFilterNos")
        private List<BabyFilterNos> babyFilterNos;
        @JsonProperty(value="requiredDoc")
        private String requiredDoc;
        @JsonProperty(value="startDate")
        private StartDate startDate;
        @JsonProperty(value="endDate")
        private EndDate endDate;
        @JsonProperty(value="allTimesSale")
        private String allTimesSale;
        @JsonProperty(value="listPriceSource")
        private String listPriceSource;
        @JsonProperty(value="reasonOfListPriceSource")
        private String reasonOfListPriceSource;
        @JsonProperty(value="minPurchasableQtyPerPerson")
        private int minPurchasableQtyPerPerson;
        @JsonProperty(value="initPeriodOfPurchaseLimit")
        private int initPeriodOfPurchaseLimit;
        @JsonProperty(value="maxPurchasableQtyPerPerson")
        private int maxPurchasableQtyPerPerson;
        @JsonProperty(value="listPrice")
        private int listPrice;
        @JsonProperty(value="discountPrice")
        private int discountPrice;
        @JsonProperty(value="discountRate")
        private int discountRate;
        @JsonProperty(value="forSaleOnMobile")
        private String forSaleOnMobile;
        @JsonProperty(value="reasonOfNotForSaleOnMobile")
        private String reasonOfNotForSaleOnMobile;
        @JsonProperty(value="onlyForSaleOnMobile")
        private String onlyForSaleOnMobile;
        @JsonProperty(value="collectibleSocialNo")
        private String collectibleSocialNo;
        @JsonProperty(value="adultConfirmation")
        private String adultConfirmation;
        @JsonProperty(value="isKcAuth")
        private String isKcAuth;
        @JsonProperty(value="isTaxBaseCoupon")
        private String isTaxBaseCoupon;
        @JsonProperty(value="isEncore")
        private String isEncore;
        @JsonProperty(value="kcAuthInfos")
        private List<KcAuthInfos> kcAuthInfos;
        @JsonProperty(value="isHotNotice")
        private String isHotNotice;
        @JsonProperty(value="hotNotices")
        private List<HotNotices> hotNotices;
        @JsonProperty(value="productStatus")
        private String productStatus;
        @JsonProperty(value="sellMethod")
        private String sellMethod;
        @JsonProperty(value="createdAt")
        private String createdAt;
        @JsonProperty(value="updatedAt")
        private String updatedAt;
        @JsonProperty(value="deliverySpot")
        private String deliverySpot;
        @JsonProperty(value="showCategoryNo")
        private int showCategoryNo;
        @JsonProperty(value="scCatYn")
        private String scCatYn;
        @JsonProperty(value="deliveryAgentType")
        private String deliveryAgentType;
        @JsonProperty(value="deliveryProductType")
        private String deliveryProductType;
        @JsonProperty(value="deliveryType")
        private String deliveryType;
        @JsonProperty(value="theDayDeliveryStartTime")
        private String theDayDeliveryStartTime;
        @JsonProperty(value="isCollectIdentify")
        private String isCollectIdentify;
        @JsonProperty(value="isReturnCargo")
        private String isReturnCargo;
        @JsonProperty(value="returnCargoType")
        private String returnCargoType;
        @JsonProperty(value="deliveryFeePolicy")
        private String deliveryFeePolicy;
        @JsonProperty(value="deliveryFee")
        private int deliveryFee;
        @JsonProperty(value="deliveryFeeInConditional")
        private int deliveryFeeInConditional;
        @JsonProperty(value="deliveryFeeSrl")
        private int deliveryFeeSrl;
        @JsonProperty(value="deliveryCorpType")
        private String deliveryCorpType;
        @JsonProperty(value="isLongDistanceDelivery")
        private String isLongDistanceDelivery;
        @JsonProperty(value="isLongDistanceAddDeliveryFee")
        private String isLongDistanceAddDeliveryFee;
        @JsonProperty(value="longDistanceAddDeliveryFee")
        private String longDistanceAddDeliveryFee;
        @JsonProperty(value="isDifferentGradeDeliveryFeePerLocal")
        private String isDifferentGradeDeliveryFeePerLocal;
        @JsonProperty(value="differentGradeDeliveryContentsPerLocal")
        private String differentGradeDeliveryContentsPerLocal;
        @JsonProperty(value="separateInstallmentFee")
        private String separateInstallmentFee;
        @JsonProperty(value="maxItemNumPerBox")
        private int maxItemNumPerBox;
        @JsonProperty(value="deliveryManagerInfo")
        private DeliveryManagerInfo deliveryManagerInfo;
        @JsonProperty(value="returnDeliveryManagerInfo")
        private ReturnDeliveryManagerInfo returnDeliveryManagerInfo;
        @JsonProperty(value="needForAddMessage")
        private String needForAddMessage;
        @JsonProperty(value="addMessage")
        private String addMessage;
        @JsonProperty(value="refundType")
        private String refundType;
        @JsonProperty(value="reasonOfNoRefund")
        private String reasonOfNoRefund;
        @JsonProperty(value="kcConfirmFiles")
        private List<KcConfirmFiles> kcConfirmFiles;
        @JsonProperty(value="priceBaseFiles")
        private List<PriceBaseFiles> priceBaseFiles;
        @JsonProperty(value="adConfirmFiles")
        private List<AdConfirmFiles> adConfirmFiles;
        @JsonProperty(value="etcRequiredFiles")
        private List<EtcRequiredFiles> etcRequiredFiles;
        @JsonProperty(value="importFiles")
        private List<ImportFiles> importFiles;
        @JsonProperty(value="liveDeal")
        private boolean liveDeal;
        @JsonProperty(value="preparedForModificationApproval")
        private boolean preparedForModificationApproval;
        @JsonProperty(value="babyFilterCategory")
        private boolean babyFilterCategory;
        @JsonProperty(value="preparedForCreationApproval")
        private boolean preparedForCreationApproval;
        @JsonProperty(value="selectedCatFullName")
        private String selectedCatFullName;
        @JsonProperty(value="rssBlockDealsUseYn")
        private String rssBlockDealsUseYn;
        @JsonProperty(value="brand")
        private Brand brand;
        @JsonProperty(value="categoryChangeYn")
        private boolean categoryChangeYn;
        @JsonProperty(value="depth2catNo")
        private int depth2catNo;
        @JsonProperty(value="selectedCatNo")
        private int selectedCatNo;
        @JsonProperty(value="hotNoticeContent")
        private String hotNoticeContent;
        @JsonProperty(value="employee")
        private Employee employee;

        private Deal() {
        }
    }

    private static class DeliveryManagerInfo {
        private DeliveryManagerInfo() {
        }
    }

    private static class DeliveryTemplate {
        @JsonProperty(value="partnerNo")
        private String partnerNo;
        @JsonProperty(value="templateName")
        private String templateName;
        @JsonProperty(value="deliveryGroupYn")
        private String deliveryGroupYn;
        @JsonProperty(value="deliveryProductGroup")
        private String deliveryProductGroup;
        @JsonProperty(value="deliveryType")
        private String deliveryType;
        @JsonProperty(value="deliveryFeePolicy")
        private String deliveryFeePolicy;
        @JsonProperty(value="isTmonReturnCargo")
        private String isTmonReturnCargo;
        @JsonProperty(value="ddayDeliveryTm")
        private String ddayDeliveryTm;
        @JsonProperty(value="deliveryAmount")
        private String deliveryAmount;
        @JsonProperty(value="deliveryIfAmount")
        private String deliveryIfAmount;
        @JsonProperty(value="isAreaDelivery")
        private String isAreaDelivery;
        @JsonProperty(value="extraCharge")
        private String extraCharge;
        @JsonProperty(value="extraChargePrepayYn")
        private String extraChargePrepayYn;
        @JsonProperty(value="extraChargeJeju")
        private String extraChargeJeju;
        @JsonProperty(value="extraChargeExtJeju")
        private String extraChargeExtJeju;
        @JsonProperty(value="extraChargeDiscMin")
        private String extraChargeDiscMin;
        @JsonProperty(value="extraChargeDiscMax")
        private String extraChargeDiscMax;
        @JsonProperty(value="deliverySpot")
        private String deliverySpot;
        @JsonProperty(value="deliveryAddrSeqno")
        private String deliveryAddrSeqno;
        @JsonProperty(value="returnAddrSeqno")
        private String returnAddrSeqno;
        @JsonProperty(value="isPostDelivery")
        private String isPostDelivery;
        @JsonProperty(value="postCriticalValue")
        private String postCriticalValue;

        private DeliveryTemplate() {
        }
    }

    private static class Employee {
        @JsonProperty(value="adId")
        private String adId;
        @JsonProperty(value="corpEmail")
        private String corpEmail;
        @JsonProperty(value="deptCode")
        private String deptCode;
        @JsonProperty(value="deptMail")
        private String deptMail;
        @JsonProperty(value="deptNameKo")
        private String deptNameKo;
        @JsonProperty(value="empNo")
        private String empNo;
        @JsonProperty(value="fullNameKo")
        private String fullNameKo;
        @JsonProperty(value="isManager")
        private boolean isManager;
        @JsonProperty(value="mobileTelNo")
        private String mobileTelNo;
        @JsonProperty(value="officeTelNo")
        private String officeTelNo;
        @JsonProperty(value="parentDeptCode")
        private String parentDeptCode;
        @JsonProperty(value="positionName")
        private String positionName;
        @JsonProperty(value="rankName")
        private String rankName;

        private Employee() {
        }
    }

    private static class EndDate {
        @JsonProperty(value="year")
        private int year;
        @JsonProperty(value="monthValue")
        private int monthValue;
        @JsonProperty(value="dayOfMonth")
        private int dayOfMonth;
        @JsonProperty(value="hour")
        private int hour;
        @JsonProperty(value="minute")
        private int minute;
        @JsonProperty(value="second")
        private int second;

        private EndDate() {
        }
    }

    private static class EtcRequiredFiles {
        private EtcRequiredFiles() {
        }
    }

    private static class GosiTemplate {
        private String seqNo = "";
        private String title = "";
        private String contents = "";
        private String fixedContents = "";
        private String prodDetailInfoRefUseYN = "";
        private String requiredItem1 = "";
        private String requiredItem2 = "";
        private String requiredItem2Option = "";

        private GosiTemplate() {
        }

        public String getSeqNo() {
            return this.seqNo;
        }

        public void setSeqNo(String seqNo) {
            this.seqNo = seqNo;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContents() {
            return this.contents;
        }

        public void setContents(String contents) {
            this.contents = contents;
        }

        public String getFixedContents() {
            return this.fixedContents;
        }

        public void setFixedContents(String fixedContents) {
            this.fixedContents = fixedContents;
        }

        public String getProdDetailInfoRefUseYN() {
            return this.prodDetailInfoRefUseYN;
        }

        public void setProdDetailInfoRefUseYN(String prodDetailInfoRefUseYN) {
            this.prodDetailInfoRefUseYN = prodDetailInfoRefUseYN;
        }

        public String getRequiredItem1() {
            return this.requiredItem1;
        }

        public void setRequiredItem1(String requiredItem1) {
            this.requiredItem1 = requiredItem1;
        }

        public String getRequiredItem2() {
            return this.requiredItem2;
        }

        public void setRequiredItem2(String requiredItem2) {
            this.requiredItem2 = requiredItem2;
        }

        public String getRequiredItem2Option() {
            return this.requiredItem2Option;
        }

        public void setRequiredItem2Option(String requiredItem2Option) {
            this.requiredItem2Option = requiredItem2Option;
        }
    }

    private static class HotNotices {
        private HotNotices() {
        }
    }

    private static class ImportFiles {
        private ImportFiles() {
        }
    }

    private static class Items {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="value")
        private Value value;

        private Items() {
        }
    }

    private static class KcAuthInfos {
        private KcAuthInfos() {
        }
    }

    private static class KcConfirmFiles {
        private KcConfirmFiles() {
        }
    }

    private static class Kft {
        @JsonProperty(value="productype")
        private String productype;
        @JsonProperty(value="items")
        private List<Items> items;

        private Kft() {
        }
    }

    private static class Option {
        @JsonProperty(value="optionHeaders")
        private List<String> optionHeaders;
        @JsonProperty(value="options")
        private List<Options> options;

        private Option() {
        }
    }

    private static class Options {
        @JsonProperty(value="optionNo")
        private String optionNo;
        @JsonProperty(value="dealNo")
        private String dealNo;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="listPrice")
        private String listPrice;
        @JsonProperty(value="discountPrice")
        private String discountPrice;
        @JsonProperty(value="quantity")
        private int quantity;
        @JsonProperty(value="remainQuantity")
        private int remainQuantity;
        @JsonProperty(value="maxBuyableQtyPerPerson")
        private String maxBuyableQtyPerPerson;
        @JsonProperty(value="totalServiceFee")
        private int totalServiceFee;
        @JsonProperty(value="depositPrice")
        private int depositPrice;
        @JsonProperty(value="depth")
        private int depth;
        @JsonProperty(value="partnerProductCode")
        private String partnerProductCode;
        @JsonProperty(value="option0")
        private String option0;
        @JsonProperty(value="option1")
        private String option1;
        @JsonProperty(value="option2")
        private String option2;
        @JsonProperty(value="isMainOption")
        private String isMainOption;
        @JsonProperty(value="dealMaxNo")
        private String dealMaxNo;
        @JsonProperty(value="isDisplayed")
        private String isDisplayed;
        @JsonProperty(value="isSoldout")
        private String isSoldout;
        @JsonProperty(value="uniqueIdForDiff")
        private String uniqueIdForDiff;
        @JsonProperty(value="optionTitle")
        private String optionTitle;
        @JsonProperty(value="fullOptionNames")
        private String fullOptionNames;
        @JsonProperty(value="discountRate")
        private String discountRate;

        private Options() {
        }
    }

    private static class PriceBaseFiles {
        private PriceBaseFiles() {
        }
    }

    private static class Product_info_Provide {
        @JsonProperty(value="success")
        private String success;
        @JsonProperty(value="kft")
        private List<Kft> kft;

        private Product_info_Provide() {
        }
    }

    private static class ReturnDeliveryManagerInfo {
        private ReturnDeliveryManagerInfo() {
        }
    }

    private static class SalesManager {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="phoneNumber")
        private String phoneNumber;
        @JsonProperty(value="email")
        private String email;

        private SalesManager() {
        }
    }

    private static class StartDate {
        @JsonProperty(value="year")
        private int year;
        @JsonProperty(value="monthValue")
        private int monthValue;
        @JsonProperty(value="dayOfMonth")
        private int dayOfMonth;
        @JsonProperty(value="hour")
        private int hour;
        @JsonProperty(value="minute")
        private int minute;
        @JsonProperty(value="second")
        private int second;
        @JsonProperty(value="month")
        private String month;
        @JsonProperty(value="nano")
        private int nano;
        @JsonProperty(value="dayOfWeek")
        private String dayOfWeek;
        @JsonProperty(value="dayOfYear")
        private int dayOfYear;
        @JsonProperty(value="chronology")
        private Chronology chronology;

        private StartDate() {
        }
    }

    private static class Template {
        private static String deliveryProductType;
        private static String deliveryType;
        private static String theDayDeliveryStartTime;
        private static String isCollectIdentify;
        private static String isReturnCargo;
        private static String returnCargoType;
        private static String deliveryFeePolicy;
        private static String deliveryFee;
        private static String deliveryFeeInConditional;
        private static String deliveryFeeSrl;
        private static String deliveryCorpType;
        private static String isLongDistanceDeliver;
        private static String isLongDistanceAddDeliveryFee;
        private static String longDistanceAddDeliveryFee;
        private static String isDifferentGradeDeliveryFeePerLocal;
        private static String differentGradeDeliveryContentsPerLocal;
        private static String separateInstallmentFee;
        private static String maxItemNumPerBox;

        private Template() {
        }

        static /* synthetic */ String access$1() {
            return deliveryProductType;
        }

        static /* synthetic */ String access$3() {
            return theDayDeliveryStartTime;
        }

        static /* synthetic */ String access$5() {
            return isReturnCargo;
        }

        static /* synthetic */ String access$7() {
            return returnCargoType;
        }

        static /* synthetic */ String access$9() {
            return deliveryFee;
        }

        static /* synthetic */ String access$11() {
            return deliveryFeeInConditional;
        }
    }

    private static class Value {
        @JsonProperty(value="contents")
        private String contents;
        @JsonProperty(value="refUseYN")
        private String refUseYN;

        private Value() {
        }
    }
}

