/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.helper.AppConfigHelper;
import com.kdjsystem.mlink.yellim.protocol.WemarketOption;
import com.kdjsystem.mlink.yellim.protocol.WemarketSelectOptionValueList;
import com.kdjsystem.mlink.yellim.protocol.WemarketUpdateOptionRequest;
import com.kdjsystem.mlink.yellim.shop.common.IProduct;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.common.IShopProductCategory;
import com.kdjsystem.mlink.yellim.shop.common.ProductCategoryService;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopWeMarketAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class WemarketProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    private static final String Host = "http://api.kdjsystem.com:8082/";

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    private void DownLoadImage(ShopWeMarketAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception, InterruptedException {
        for (String img : strImages) {
            if (dtllist.getImageresizeyn().equals("Y")) {
                ShopCommon.downloadImgFile(img, Integer.parseInt(dtllist.getImageresize()), Integer.parseInt(dtllist.getImageresize()));
                Thread.sleep(1000L);
                continue;
            }
            ShopCommon.downloadImgFile(img, 460, 460);
            Thread.sleep(1000L);
        }
    }

    private void setCategoryNKeyword(ProductDTO dto, Map<String, String> params) {
        params.put("dcateCd", "4104458");
        params.put("prodStatus", "A");
        params.put("removeProdOptionNoStr", "");
        params.put("removeProdImgNoStr", "");
        params.put("removeProdFileNoStr", "");
        params.put("removeProdGnoticeNoStr", "");
        params.put("agreeNo", "");
        ArrayList<String> list = new ArrayList<String>();
        List<String> search = new ArrayList<String>();
        if (dto.getExcepkeywdyn().equals("Y")) {
            list.addAll(Arrays.asList(dto.getExcepkeywd().split(",")));
            list.addAll(Arrays.asList(dto.getGoods_search().split(",")));
            search = list.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() == 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        } else {
            search.addAll(Arrays.asList(dto.getGoods_search().split(",")));
        }
        ArrayList<String> goodsearch = new ArrayList<String>();
        if (search.size() > 9) {
            int i = 0;
            while (i < 9) {
                goodsearch.add((String)search.get(i));
                ++i;
            }
        } else {
            goodsearch.addAll(search);
        }
        params.put("keywordWmp", goodsearch.stream().collect(Collectors.joining(",")));
        params.put("keywordEp", goodsearch.stream().collect(Collectors.joining(",")));
        params.put("searchSpecialYn", "");
        params.put("searchSpecialPrice", "");
        params.put("schCateType", "SELECT");
        params.put("cateSchNm", "");
    }

    private void setProductName(ProductDTO dto, ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            String value = "";
            switch (dtllist.getProdoutput()) {
                case "1": {
                    value = dto.getGoods_nm();
                    break;
                }
                case "2": {
                    value = dto.getModel_nm();
                    break;
                }
                case "3": {
                    value = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "4": {
                    value = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "5": {
                    value = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "6": {
                    value = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    value = dto.getGoods_nm();
                }
            }
            if (!dtllist.getProdnmfirst().equals("")) {
                value = dtllist.getProdnmfirst().concat(value);
            }
            if (!dtllist.getProdnmlast().equals("")) {
                value = value.concat(dtllist.getProdnmlast());
            }
            String sellerProductName = dto.getProdnmlenyn().equals("Y") ? (value.length() > 69 ? value.substring(0, 69) : value) : value;
            params.put("prodNm", sellerProductName);
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85 \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private ResultMarketPrice setPrice(ProductDTO dto, ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            int deliveryFee = 0;
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDELIVERYCOST();
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice = salePrice + (long)deliveryFee;
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            ResultMarketPrice resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            params.put("originPrice", resultMarketPrice.getConsumer_if_sale_price());
            params.put("salePrice", resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
            return resultMarketPrice;
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setSalePeriod(ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            params.put("commissionType", "FR");
            params.put("commissionRate", "");
            params.put("commissionPrice", "");
            params.put("salePeriod", dtllist.getSaleperiodyn());
            params.put("saleStartDt", String.valueOf(YDMATimeUtil.getCurrentDateScheduler()) + " 00:00");
            params.put("saleEndDt", String.valueOf(dtllist.getSaleendperiod()) + " 23:00");
            params.put("stockCount", "999");
            params.put("saleStatus", "A");
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uae30\uac04 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setLimitCnt(ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            params.put("purchaseMinCount", dtllist.getPurchasemincount());
            params.put("purchaseLimitYn", dtllist.getPurchaselimityn());
            if (dtllist.getPurchaselimityn().equals("Y")) {
                params.put("purchaseLimitDuration", dtllist.getPurchaselimitduration());
                params.put("purchaseLimitDay", dtllist.getPurchaselimitday().equals("0") ? "" : dtllist.getPurchaselimitday());
                params.put("purchaseLimitCount", dtllist.getPurchaselimitcount());
            }
            params.put("basketLimitYn", dtllist.getBasketlimityn());
            params.put("validPeriod", "PERIOD");
            params.put("validStartDt", "");
            params.put("validEndDt", "");
            params.put("validDay", "");
            params.put("storeZipcode", "");
            params.put("storeAddr1", "");
            params.put("storeAddr2", "");
            params.put("storeRoadAddr1", "");
            params.put("storeRoadAddr2", "");
            params.put("storeLatitude", "");
            params.put("storeLongitude", "");
        }
        catch (Exception exception) {
            throw new Exception("\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9, \uad6c\ub9e4\uc218\ub7c9\uc81c\ud55c, \uc7a5\ubc14\uad6c\ub2c8\uc81c\ud55c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setOption(ProductDTO dto, ShopWeMarketAdditionDto dtllist, Map<String, String> params, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
            if (shopOptionDtos.size() > 0) {
                params.put("optSelUseYn", "Y");
                List ShopOptions = shopOptionDtos.stream().filter(d -> !d.getCnt().equals("0")).collect(Collectors.toList());
                List<String> name = Arrays.asList(((ShopOptionDto)ShopOptions.get(0)).getOptspecdes().split(":"));
                ArrayList<String> opt1 = new ArrayList<String>();
                ArrayList<String> opt2 = new ArrayList<String>();
                for (ShopOptionDto option2 : ShopOptions) {
                    if (Arrays.asList(option2.getOptspecdes().split(":")).size() > 1) {
                        opt1.add(option2.getOptspecdes().split(":")[0]);
                        opt2.add(option2.getOptspecdes().split(":")[1]);
                        continue;
                    }
                    if (Arrays.asList(option2.getOptspecdes().split(":")).size() != 1) continue;
                    opt1.add(option2.getOptspecdes().split(":")[0]);
                }
                params.put("optionDepth", String.valueOf(name.size()));
                params.put("opt1[1]", dto.getChar_1_nm());
                params.put("opt2[1]", opt1.stream().distinct().collect(Collectors.joining(",")));
                params.put("opt1[2]", dto.getChar_2_nm());
                params.put("opt2[2]", opt2.size() > 0 ? opt2.stream().distinct().collect(Collectors.joining(",")) : "");
                params.put("opt1[3]", "");
                params.put("opt2[3]", "");
                params.put("opt1[4]", "");
                params.put("opt2[4]", "");
                params.put("opt1[5]", "");
                params.put("opt2[5]", "");
                int i = 0;
                while (i < ShopOptions.size()) {
                    params.put("optionList[" + i + "].priority", String.valueOf(i));
                    params.put("optionList[" + i + "].useYn", "Y");
                    List<String> opt = Arrays.asList(((ShopOptionDto)ShopOptions.get(i)).getOptspecdes().split(":"));
                    Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
                    int deliveryFee = 0;
                    if (dtllist.getFreedelivery().equals("T")) {
                        if (dtllist.getExpprc() == 9999) {
                            if (!dto.getDelv_cost().equals("0")) {
                                deliveryFee = Integer.parseInt(dto.getDelv_cost());
                            } else {
                                PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                                deliveryFee = systemconf.getDELIVERYCOST();
                            }
                        } else {
                            deliveryFee = dtllist.getExpprc();
                        }
                        salePrice = salePrice + (long)deliveryFee;
                    }
                    int amt = YDMAStringUtil.convertToInt(((ShopOptionDto)ShopOptions.get(i)).getAmt());
                    salePrice = salePrice + YDMAStringUtil.convertToLong(((ShopOptionDto)ShopOptions.get(i)).getAmt());
                    int limit_price = YDMAStringUtil.convertToInt(((ShopOptionDto)ShopOptions.get(i)).getLimit_price());
                    ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                    if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                        optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                    }
                    amt = Integer.parseInt(optionprice.getConsumer_if_sale_price()) - Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                    if (opt.size() > 1) {
                        params.put("optionList[" + i + "].opt1Val", opt.get(0));
                        params.put("optionList[" + i + "].opt2Val", opt.get(1));
                        params.put("optionList[" + i + "].optAddPrice", String.valueOf(amt));
                        params.put("optionList[" + i + "].stockCount", ((ShopOptionDto)ShopOptions.get(i)).getCnt());
                        params.put("optionList[" + i + "].sellerOptCd", "");
                        params.put("optionList[" + i + "].saleStatus", "A");
                        params.put("optionList[" + i + "].dispYn", "Y");
                    } else if (opt.size() == 1) {
                        params.put("optionList[" + i + "].opt1Val", opt.get(0));
                        params.put("optionList[" + i + "].optAddPrice", String.valueOf(amt));
                        params.put("optionList[" + i + "].stockCount", ((ShopOptionDto)ShopOptions.get(i)).getCnt());
                        params.put("optionList[" + i + "].sellerOptCd", "");
                        params.put("optionList[" + i + "].saleStatus", "A");
                        params.put("optionList[" + i + "].dispYn", "Y");
                    }
                    ++i;
                }
                params.put("sOptType", "S");
                params.put("sDepth", String.valueOf(name.size()));
                params.put("sOpt1Title", dto.getChar_1_nm());
                params.put("sOpt2Title", dto.getChar_2_nm());
                params.put("sOpt3Title", "");
                params.put("sOpt4Title", "");
                params.put("sOpt5Title", "");
                params.put("optTxtUseYn", "N");
            } else {
                params.put("optSelUseYn", "N");
                params.put("optTxtUseYn", "N");
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setIsbnNCert(Map<String, String> params) throws Exception {
        try {
            params.put("isbn13", "");
            params.put("isbn10", "");
            params.put("certList[0].isCert", "D");
            params.put("certList[0].certGroup", "KD");
            params.put("certList[1].isCert", "D");
            params.put("certList[1].certGroup", "LF");
            params.put("certList[2].isCert", "D");
            params.put("certList[2].certGroup", "ER");
            params.put("certList[3].isCert", "D");
            params.put("certList[3].certGroup", "RP");
            params.put("certList[4].isCert", "D");
            params.put("certList[4].certGroup", "LC");
            params.put("cert.KD.isCert", "D");
            params.put("epMinPrice", "");
            params.put("epDt", "");
            params.put("epChannel", "");
            params.put("cobuyCount", "");
            params.put("cobuyPeriodYn", "Y");
            params.put("cobuyStartDt", String.valueOf(YDMATimeUtil.getCurrentDateScheduler()) + " 00:00");
            params.put("cobuyEndDt", "");
        }
        catch (Exception exception) {
            throw new Exception("ISBN, \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setLabels(ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            List<String> labels = Arrays.asList(dtllist.getLabelnolist().split(","));
            params.put("labelList[0].labelGroup", "P");
            params.put("labelList[0].labelNo", "19");
            params.put("labelList[1].labelGroup", "P");
            params.put("labelList[1].labelNo", "20");
            params.put("labelList[2].labelGroup", "P");
            params.put("labelList[2].labelNo", "21");
            params.put("labelList[3].labelGroup", "P");
            params.put("labelList[3].labelNo", "22");
            if (labels.size() > 0) {
                for (String label : labels) {
                    if (label.equals("01")) {
                        params.put("labelList[0].useYn", "Y");
                        continue;
                    }
                    if (label.equals("02")) {
                        params.put("labelList[1].useYn", "Y");
                        continue;
                    }
                    if (label.equals("03")) {
                        params.put("labelList[2].useYn", "Y");
                        continue;
                    }
                    if (!label.equals("04")) continue;
                    params.put("labelList[3].useYn", "Y");
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc18d\uc131 \ub77c\ubca8 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setEtc(ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            params.put("epYn", dtllist.getPricecomparisonsiteyn());
            params.put("reviewDisp", dtllist.getReviewdisp());
            params.put("adultLimitYn", dtllist.getAdultlimityn());
            params.put("localLiquorYn", "N");
            params.put("parallelImportYn", dtllist.getParallelimportyn());
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\ud734\ucc44\ub110, \uad6c\ub9e4\ud6c4\uae30, 19\uae08\uc81c\ud55c, \uc804\ud1b5\uc8fc, \ubcd1\ud589\uc218\uc785 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void Basic(ProductDTO dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg) throws Exception {
        try {
            weProductReg.basic = new Basic();
            String value = "";
            switch (dtllist.getProdoutput()) {
                case "1": {
                    value = dto.getGoods_nm();
                    break;
                }
                case "2": {
                    value = dto.getModel_nm();
                    break;
                }
                case "3": {
                    value = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "4": {
                    value = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "5": {
                    value = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "6": {
                    value = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    value = dto.getGoods_nm();
                }
            }
            if (!dtllist.getProdnmfirst().equals("")) {
                value = dtllist.getProdnmfirst().concat(value);
            }
            if (!dtllist.getProdnmlast().equals("")) {
                value = value.concat(dtllist.getProdnmlast());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "L", 70);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            String sellerProductName = dto.getProdnmlenyn().equals("Y") ? (value.length() > 70 ? value.substring(0, 130) : value) : value;
            weProductReg.basic.productName = sellerProductName;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85 \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.basic.productType = dtllist.getProducttype();
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc720\ud615 \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void BasicShipping(ProductDTO dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        try {
            weProductReg.basic.shipPolicyNo = dtllist.getShippolicyno();
            weProductReg.basic.shipInfo = new ShipInfo();
            Data ship = this.getShipAPI(dtllist, shoppingMallDetailDto);
            weProductReg.basic.shipInfo.claimShipFee = ship.getBundleKind().equals("BND") ? null : ship.getClaimShipFee();
            weProductReg.basic.shipInfo.releaseZipCode = ship.getBundleKind().equals("BND") ? null : ship.getReleaseZipCode();
            weProductReg.basic.shipInfo.releaseRoadAddress1 = ship.getBundleKind().equals("BND") ? null : ship.getReleaseRoadAddress1();
            weProductReg.basic.shipInfo.releaseRoadAddress2 = ship.getBundleKind().equals("BND") ? null : ship.getReleaseRoadAddress2();
            weProductReg.basic.shipInfo.releaseAddress1 = ship.getBundleKind().equals("BND") ? null : ship.getReleaseAddress1();
            weProductReg.basic.shipInfo.releaseAddress2 = ship.getBundleKind().equals("BND") ? null : ship.getReleaseAddress2();
            weProductReg.basic.shipInfo.returnZipCode = ship.getBundleKind().equals("BND") ? null : ship.getReturnZipCode();
            weProductReg.basic.shipInfo.returnRoadAddress1 = ship.getBundleKind().equals("BND") ? null : ship.getReturnRoadAddress1();
            weProductReg.basic.shipInfo.returnRoadAddress2 = ship.getBundleKind().equals("BND") ? null : ship.getReturnRoadAddress2();
            weProductReg.basic.shipInfo.returnAddress1 = ship.getBundleKind().equals("BND") ? null : ship.getReturnAddress1();
            weProductReg.basic.shipInfo.returnAddress2 = ship.getBundleKind().equals("BND") ? null : ship.getReturnAddress2();
            weProductReg.basic.shipInfo.releaseDay = ship.getBundleKind().equals("BND") ? null : ship.getReleaseDay();
            weProductReg.basic.shipInfo.releaseTime = ship.getBundleKind().equals("BND") ? null : ship.getReleaseTime();
            weProductReg.basic.shipInfo.holidayExceptYn = ship.getBundleKind().equals("BND") ? null : ship.getHolidayExceptYn();
        }
        catch (Exception exception) {
            throw new Exception("\ubc30\uc1a1\uc815\ucc45\ubc88\ud638 \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private Data getShipAPI(ShopWeMarketAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto) throws IOException, JsonParseException, JsonMappingException {
        Shippingpolicy shipPolicy;
        String path = "wemarket/api/v1/getShipAPI";
        ObjectMapper mapper = new ObjectMapper();
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(Host.concat(path)).method("GET", null).addHeader("apiKey", shoppingMallDetailDto.getAPIKEY()).build();
        Throwable throwable = null;
        Object var9_9 = null;
        try (Response response = client.newCall(request2).execute();){
            shipPolicy = (Shippingpolicy)mapper.readValue(response.body().string().toString(), Shippingpolicy.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Data ship = shipPolicy.data.stream().filter(d -> d.getShipPolicyNo() == Integer.parseInt(dtllist.getShippolicyno())).findAny().get();
        return ship;
    }

    private void BasicEtc(ProductDTO dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        Object brand;
        String response;
        String path;
        ObjectMapper mapper;
        try {
            weProductReg.basic.adultLimitYn = dtllist.getAdultlimityn();
        }
        catch (Exception exception) {
            throw new Exception("19\uae08\uc81c\ud55c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.basic.displayYn = dtllist.getDisplayyn();
        }
        catch (Exception exception) {
            throw new Exception("\ub178\ucd9c\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.basic.bizYn = dtllist.getBizyn();
        }
        catch (Exception exception) {
            throw new Exception("\uc0ac\uc5c5\uc790\uc804\uc6a9\uc0c1\ud488 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        weProductReg.basic.styleYn = "N";
        try {
            if (dtllist.getBrandyn().equals("Y")) {
                if (dtllist.getBrandno().equals("")) {
                    weProductReg.basic.brandNo = "";
                } else {
                    weProductReg.basic.brandNo = dtllist.getBrandno();
                }
            } else {
                mapper = new ObjectMapper();
                String brandnm = dto.getBrand_nm();
                path = "wemarket/api/v1/getBrandAPI?brandName=" + brandnm;
                response = this.getBrandNMakerAPI(dto, dtllist, shoppingMallDetailDto, path);
                if (!response.equals("")) {
                    brand = (Brand)mapper.readValue(response, Brand.class);
                    if (((Brand)brand).data != null) {
                        BrandData brandNm = ((Brand)brand).data.stream().filter(d -> d.getBrandName().equals(dto.getBrand_nm())).findAny().orElse(null);
                        if (brandNm == null) {
                            weProductReg.basic.brandNo = "";
                        } else {
                            weProductReg.basic.brandNo = brandNm.getBrandNo();
                        }
                    } else {
                        weProductReg.basic.brandNo = "";
                    }
                } else {
                    weProductReg.basic.brandNo = "";
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ube0c\ub79c\ub4dc \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (dtllist.getMakeryn().equals("Y")) {
                if (dtllist.getMakerno().equals("")) {
                    weProductReg.basic.makerNo = "";
                } else {
                    weProductReg.basic.makerNo = dtllist.getMakerno();
                }
            } else {
                mapper = new ObjectMapper();
                String makernm = dto.getMaker();
                path = "wemarket/api/v1/getMakerAPI?makerName=" + makernm;
                response = this.getBrandNMakerAPI(dto, dtllist, shoppingMallDetailDto, path);
                if (!response.equals("")) {
                    brand = (Maker)mapper.readValue(response, Maker.class);
                    if (((Maker)brand).data != null) {
                        MakerData makerNM = ((Maker)brand).data.stream().filter(d -> d.getMakerName().equals(dto.getMaker())).findAny().orElse(null);
                        if (makerNM == null) {
                            weProductReg.basic.makerNo = "";
                        } else {
                            weProductReg.basic.makerNo = makerNM.getMakerNo();
                        }
                    } else {
                        weProductReg.basic.makerNo = "";
                    }
                } else {
                    weProductReg.basic.makerNo = "";
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\uc870\uc0ac \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String getBrandNMakerAPI(ProductDTO dto, ShopWeMarketAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String path) throws IOException, JsonParseException, JsonMappingException {
        String value = "";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(Host.concat(path)).method("GET", null).addHeader("apiKey", shoppingMallDetailDto.getAPIKEY()).build();
        Throwable throwable = null;
        Object var9_10 = null;
        try (Response response = client.newCall(request2).execute();){
            value = response.code() == 200 ? response.body().string() : "";
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return value;
    }

    private void SalePeriod(ProductDTO dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg) throws Exception {
        weProductReg.sale = new Sale();
        try {
            weProductReg.sale.salePeriod = dtllist.getSaleperiodyn();
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\uc870\uc0ac \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.saleStartDate = String.valueOf(YDMATimeUtil.getCurrentDateScheduler()) + " 00:00";
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\uc870\uc0ac \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.saleEndDate = String.valueOf(dtllist.getSaleendperiod()) + " 23:00";
            dto.setSaleenddt(dtllist.getSaleendperiod());
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\uc870\uc0ac \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private ResultMarketPrice SalePrice(ProductDTO dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg) throws Exception {
        try {
            Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            int deliveryFee = 0;
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDELIVERYCOST();
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice = salePrice + (long)deliveryFee;
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            ResultMarketPrice resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            weProductReg.sale.originPrice = resultMarketPrice.getConsumer_if_sale_price();
            weProductReg.sale.salePrice = resultMarketPrice.getConsumer_if_sale_price();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
            return resultMarketPrice;
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void SaleEtc(ProductDTO dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg) throws Exception {
        weProductReg.sale.stockCount = "998";
        try {
            weProductReg.sale.taxYn = dtllist.getTaxyn();
        }
        catch (Exception exception) {
            throw new Exception("\uacfc\uc138\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.purchaseMinCount = dtllist.getPurchasemincount();
        }
        catch (Exception exception) {
            throw new Exception("\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.purchaseLimitYn = dtllist.getPurchaselimityn();
        }
        catch (Exception exception) {
            throw new Exception("1\uc778\ub2f9 \uad6c\ub9e4\uc81c\ud55c \uc0ac\uc6a9\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (dtllist.getPurchaselimityn().equals("Y")) {
                weProductReg.sale.purchaseLimitDuration = dtllist.getPurchaselimitduration();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\uc81c\ud55c \ud0c0\uc785 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (dtllist.getPurchaselimityn().equals("Y")) {
                weProductReg.sale.purchaseLimitDay = dtllist.getPurchaselimitday().equals("0") ? null : dtllist.getPurchaselimitday();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\uc81c\ud55c \uc77c\uc790 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (dtllist.getPurchaselimityn().equals("Y")) {
                weProductReg.sale.purchaseLimitCount = dtllist.getPurchaselimitcount();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\uc81c\ud55c \uac1c\uc218 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.basketLimitYn = dtllist.getBasketlimityn();
        }
        catch (Exception exception) {
            throw new Exception("\uc7a5\ubc14\uad6c\ub2c8\uc81c\ud55c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.referencePriceType = dtllist.getReferencepricetype();
        }
        catch (Exception exception) {
            throw new Exception("\uae30\uc900\uac00\uaca9 \uadfc\uac70\uc815\ubcf4\ud0c0\uc785 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void DetailImgNRemark(ProductDTO dto, ShopWeMarketAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, WeMarketProductReg weProductReg, List<String> strImages) throws Exception {
        try {
            weProductReg.detail = new Detail();
            weProductReg.detail.addImgUrlList = new ArrayList();
            weProductReg.detail.basicImgUrl = strImages.get(0);
            if (strImages.size() > 1) {
                int i = 1;
                while (i < strImages.size()) {
                    if (i <= 2) {
                        weProductReg.detail.addImgUrlList.add(strImages.get(i));
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub300\ud45c \ubc0f \ucd94\uac00\uc774\ubbf8\uc9c0 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.detail.listImgUrl = strImages.get(0);
        }
        catch (Exception exception) {
            throw new Exception("\ub9ac\uc2a4\ud305\uc774\ubbf8\uc9c0 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        String addDetailPlus = "";
        try {
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = String.valueOf(dtllist.getDetailKeywordL()) + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            weProductReg.detail.descType = "HTML";
            weProductReg.detail.descHtml = String.valueOf(addDetailPlus.replace("\n", "").replace("\"", "'")) + dto.getGoods_remarks().replace("\n", "").replace("\"", "'");
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc0c1\uc138\uc124\uba85 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void Option(ProductDTO dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ResultMarketPrice resultMarketPrice) throws Exception {
        List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
        String addOptionLeftNm = "";
        String addOptionRightNm = "";
        try {
            weProductReg.option = new Option();
            if (shopOptionDtos.size() > 0) {
                if (dtllist.getAddoptionlb().equals("Y")) {
                    addOptionLeftNm = dtllist.getAddOptionL();
                }
                if (dtllist.getAddoptionrb().equals("Y")) {
                    addOptionRightNm = dtllist.getAddOptionR();
                }
                weProductReg.option.selectOptionUseYn = "Y";
                List options = shopOptionDtos.stream().filter(d -> !d.getCnt().equals("0")).collect(Collectors.toList());
                if (options.size() > 0) {
                    String[] optionTypes = ((ShopOptionDto)options.get(0)).getName().split(":");
                    weProductReg.option.selectOptionDepth = String.valueOf(optionTypes.length);
                    if (optionTypes.length == 3) {
                        weProductReg.option.selectOptionTitle1 = optionTypes[0];
                        weProductReg.option.selectOptionTitle2 = optionTypes[1];
                        weProductReg.option.selectOptionTitle3 = optionTypes[2];
                    } else if (optionTypes.length == 2) {
                        weProductReg.option.selectOptionTitle1 = optionTypes[0];
                        weProductReg.option.selectOptionTitle2 = optionTypes[1];
                    } else {
                        weProductReg.option.selectOptionTitle1 = optionTypes[0];
                    }
                    weProductReg.option.selectOptionValueList = new ArrayList();
                    int i = 0;
                    while (i < options.size()) {
                        SelectOptionValueList selectOptionValueList = new SelectOptionValueList();
                        List<String> opt = Arrays.asList(((ShopOptionDto)options.get(i)).getOptspecdes().split(":"));
                        Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
                        int deliveryFee = 0;
                        if (dtllist.getFreedelivery().equals("T")) {
                            if (dtllist.getExpprc() == 9999) {
                                if (!dto.getDelv_cost().equals("0")) {
                                    deliveryFee = Integer.parseInt(dto.getDelv_cost());
                                } else {
                                    PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                                    deliveryFee = systemconf.getDELIVERYCOST();
                                }
                            } else {
                                deliveryFee = dtllist.getExpprc();
                            }
                            salePrice = salePrice + (long)deliveryFee;
                        }
                        int amt = YDMAStringUtil.convertToInt(((ShopOptionDto)options.get(i)).getAmt());
                        salePrice = salePrice + YDMAStringUtil.convertToLong(((ShopOptionDto)options.get(i)).getAmt());
                        int limit_price = YDMAStringUtil.convertToInt(((ShopOptionDto)options.get(i)).getLimit_price());
                        ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                        if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                            optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                        }
                        amt = Integer.parseInt(optionprice.getConsumer_if_sale_price()) - Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                        if (opt.size() > 2) {
                            selectOptionValueList.optionValue1 = String.valueOf(addOptionLeftNm) + opt.get(0) + addOptionRightNm;
                            selectOptionValueList.optionValue2 = String.valueOf(addOptionLeftNm) + opt.get(1) + addOptionRightNm;
                            selectOptionValueList.optionValue3 = String.valueOf(addOptionLeftNm) + opt.get(2) + addOptionRightNm;
                            selectOptionValueList.optAddPrice = String.valueOf(amt);
                            selectOptionValueList.stockCount = ((ShopOptionDto)options.get(i)).getCnt();
                            selectOptionValueList.displayYn = "Y";
                        } else if (opt.size() > 1) {
                            selectOptionValueList.optionValue1 = String.valueOf(addOptionLeftNm) + opt.get(0) + addOptionRightNm;
                            selectOptionValueList.optionValue2 = String.valueOf(addOptionLeftNm) + opt.get(1) + addOptionRightNm;
                            selectOptionValueList.optAddPrice = String.valueOf(amt);
                            selectOptionValueList.stockCount = ((ShopOptionDto)options.get(i)).getCnt();
                            selectOptionValueList.displayYn = "Y";
                        } else {
                            selectOptionValueList.optionValue1 = String.valueOf(addOptionLeftNm) + opt.get(0) + addOptionRightNm;
                            selectOptionValueList.optAddPrice = String.valueOf(amt);
                            selectOptionValueList.stockCount = ((ShopOptionDto)options.get(i)).getCnt();
                            selectOptionValueList.displayYn = "Y";
                        }
                        weProductReg.option.selectOptionValueList.add(selectOptionValueList);
                        ++i;
                    }
                    weProductReg.option.textOptionUseYn = "N";
                } else {
                    weProductReg.option.selectOptionUseYn = "N";
                    weProductReg.option.textOptionUseYn = "N";
                }
            } else {
                weProductReg.option.selectOptionUseYn = "N";
                weProductReg.option.textOptionUseYn = "N";
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void Notice(ProductDTO dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        try {
            int gnoticeNo = Integer.parseInt(dto.getProp1_cd());
            if (gnoticeNo > 26 || gnoticeNo < 31) {
                gnoticeNo = 37;
            } else if (gnoticeNo > 33 || gnoticeNo < 41) {
                gnoticeNo = 37;
            }
            NoticeData data2 = this.getNoticeAPI(gnoticeNo, shoppingMallDetailDto);
            String attrcd = gnoticeNo < 10 ? "00".concat(String.valueOf(gnoticeNo)) : "0".concat(String.valueOf(gnoticeNo));
            dto.setProp1_cd(attrcd);
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            NoticeListMain group = new NoticeListMain();
            group.groupNoticeNo = data2.groupNoticeNo;
            int i = 0;
            while (i < data2.noticeList.size()) {
                int num = i;
                NoticeListValue value = new NoticeListValue();
                ShopProdAttrnmDto shopProdAttrnmDto = dto.getShopProdAttrnmDtos().stream().filter(d -> d.getAttrnm().contains(((NoticeLists)data2.noticeList.get(num)).noticeName)).findAny().orElse(null);
                if (shopProdAttrnmDto == null) {
                    value.description = "\uc0c1\ud488\uc0c1\uc138 \uc124\uba85 \ucc38\uace0";
                } else if (shopProdAttrnmDto.getProp_val().equals("")) {
                    value.description = "\uc0c1\ud488\uc0c1\uc138 \uc124\uba85 \ucc38\uace0";
                } else {
                    value.description = shopProdAttrnmDto.getProp_val();
                }
                value.noticeNo = ((NoticeLists)data2.noticeList.get(i)).getNoticeNo();
                group.noticeList.add(value);
                ++i;
            }
            weProductReg.noticeList.add(group);
        }
        catch (Exception exception) {
            throw new Exception("\uace0\uc2dc\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private NoticeData getNoticeAPI(int gnoticeNo, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        String path = "wemarket/api/v1/getNoticeAPI";
        ObjectMapper mapper = new ObjectMapper();
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(Host.concat(path)).method("GET", null).addHeader("apiKey", shoppingMallDetailDto.getAPIKEY()).build();
        Throwable throwable = null;
        Object var8_9 = null;
        try (Response response = client.newCall(request2).execute();){
            if (response.code() == 200) {
                NoticeTypeGET shipPolicy = (NoticeTypeGET)mapper.readValue(response.body().string().toString(), NoticeTypeGET.class);
                NoticeData ship = shipPolicy.data.stream().filter(d -> d.getGroupNoticeNo().equals(String.valueOf(gnoticeNo))).findAny().get();
                return ship;
            }
            throw new Exception("\uace0\uc2dc\uc815\ubcf4\ub97c \ud68d\ub4dd\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4..");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void Etc(ProductDTO dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        weProductReg.etc = new Etc();
        try {
            weProductReg.etc.parallelImportYn = dtllist.getParallelimportyn();
        }
        catch (Exception exception) {
            throw new Exception("\ubcd1\ud589\uc218\uc785 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dto.getCert_type().equals("0")) {
                weProductReg.etc.kcKidIsCertification = "D";
                weProductReg.etc.kcKidCertificationList = new ArrayList();
                KcKidCertificationList kcKidCertificationList = new KcKidCertificationList();
                kcKidCertificationList.certificationType = "KD_SAFETY_CT";
                weProductReg.etc.kcKidCertificationList.add(kcKidCertificationList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc5b4\ub9b0\uc774\uc81c\ud488 \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dto.getCert_type().equals("0")) {
                weProductReg.etc.kcLifeIsCertification = "D";
                weProductReg.etc.kcLifeCertificationList = new ArrayList();
                KcLifeCertificationList kcLifeCertificationList = new KcLifeCertificationList();
                kcLifeCertificationList.certificationType = "LF_SAFETY_CT";
                weProductReg.etc.kcLifeCertificationList.add(kcLifeCertificationList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0dd\ud65c\uc6a9\ud488 \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dto.getCert_type().equals("0")) {
                weProductReg.etc.kcElectricIsCertification = "D";
                weProductReg.etc.kcElectricCertificationList = new ArrayList();
                KcElectricCertificationList kcElectricCertificationList = new KcElectricCertificationList();
                kcElectricCertificationList.certificationType = "ER_SAFETY_CT";
                weProductReg.etc.kcElectricCertificationList.add(kcElectricCertificationList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc804\uae30\uc6a9\ud488 \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dto.getCert_type().equals("0")) {
                weProductReg.etc.kcReportIsCertification = "D";
                weProductReg.etc.kcReportCertificationList = new ArrayList();
                KcReportCertificationList kcReportCertificationList = new KcReportCertificationList();
                kcReportCertificationList.certificationType = "RP_STB";
                weProductReg.etc.kcReportCertificationList.add(kcReportCertificationList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\ubc29\uc1a1\ud1b5\uc2e0\uae30\uc790\uc7ac \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dto.getCert_type().equals("0")) {
                weProductReg.etc.kcLifeChemistryIsCertification = "D";
                weProductReg.etc.kcLifeChemistryCertificationList = new ArrayList();
                KcLifeChemistryCertificationList kcLifeChemistryCertificationList = new KcLifeChemistryCertificationList();
                kcLifeChemistryCertificationList.certificationType = "LC_SELF_CHECK";
                weProductReg.etc.kcLifeChemistryCertificationList.add(kcLifeChemistryCertificationList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0dd\ud65c\ud654\ud559\uc81c\ud488 \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.etc.sellerProdCode = dto.getCompayny_goods_cd();
        }
        catch (Exception exception) {
            throw new Exception("\uc790\uccb4\uc0c1\ud488\ucf54\ub4dc \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.etc.priceComparisonSiteYn = dtllist.getPricecomparisonsiteyn();
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\ud734\ucc44\ub110 \ub4f1\ub85d\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> removetag = new ArrayList<String>();
            List<String> search = new ArrayList<String>();
            if (dto.getExcepkeywdyn().equals("Y")) {
                removetag.addAll(Arrays.asList(dto.getExcepkeywd().split(",")));
                list.addAll(Arrays.asList(dto.getGoods_search().split(",")));
                search = IProduct.checkSearch(list, removetag, search);
            } else {
                search.addAll(Arrays.asList(dto.getGoods_search().split(",")));
            }
            ArrayList<String> goodsearch = new ArrayList<String>();
            if (search.size() > 9) {
                int i = 0;
                while (i < 9) {
                    goodsearch.add(search.get(i));
                    ++i;
                }
            } else {
                goodsearch.addAll(search);
            }
            weProductReg.etc.keywordPriceComparisonSite = goodsearch.stream().collect(Collectors.joining(","));
            weProductReg.etc.keywordWemakeprice = goodsearch.stream().collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            throw new Exception("\ud0a4\uc6cc\ub4dc \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        weProductReg.etc.isbn13 = "";
        weProductReg.etc.isbn10 = "";
        try {
            weProductReg.etc.displayOnlyDealYn = dtllist.getDisplayonlydealyn();
        }
        catch (Exception exception) {
            throw new Exception("\ub51c\uc5d0\uc11c\ub9cc \ub178\ucd9c\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.etc.reviewDisp = dtllist.getReviewdisp();
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\ud6c4\uae30 \ub178\ucd9c\uc81c\ud55c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            List<String> labels = Arrays.asList(dtllist.getLabelnolist().split(","));
            if (labels.size() > 0) {
                weProductReg.etc.labelNoList = new ArrayList();
                for (String label : labels) {
                    if (label.equals("01")) {
                        weProductReg.etc.labelNoList.add("19");
                        continue;
                    }
                    if (label.equals("02")) {
                        weProductReg.etc.labelNoList.add("20");
                        continue;
                    }
                    if (label.equals("03")) {
                        weProductReg.etc.labelNoList.add("21");
                        continue;
                    }
                    if (!label.equals("04")) continue;
                    weProductReg.etc.labelNoList.add("22");
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc18d\uc131 \ub77c\ubca8 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void Category(ProductDTO dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        try {
            if (dtllist.getIsCategory().equals("1")) {
                weProductReg.basic.dcateCode = dtllist.getShopcatno();
            } else if (dto.getShopCid() == null || dto.getShopCid().equals("")) {
                ProductCategoryService service = new ProductCategoryService(IShopProductCategory.getSearchBean(dto.getShopcd()));
                String cateNum = service.excute(dto, null, shoppingMallDetailDto);
                weProductReg.basic.dcateCode = cateNum;
            } else {
                weProductReg.basic.dcateCode = dto.getShopCid();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String setProductReg(ProductDTO dto, ShopWeMarketAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> loginCookie, List<String> strImages) throws Exception {
        String json = "";
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        WeMarketProductReg weProductReg = new WeMarketProductReg();
        weProductReg.productNo = dto.getShopprodno();
        this.Basic(dto, dtllist, weProductReg);
        this.Category(dto, dtllist, weProductReg, shoppingMallDetailDto);
        this.BasicShipping(dto, dtllist, weProductReg, shoppingMallDetailDto);
        this.BasicEtc(dto, dtllist, weProductReg, shoppingMallDetailDto);
        this.SalePeriod(dto, dtllist, weProductReg);
        ResultMarketPrice resultMarketPrice = this.SalePrice(dto, dtllist, weProductReg);
        this.SaleEtc(dto, dtllist, weProductReg);
        this.DetailImgNRemark(dto, dtllist, shoppingMallDetailDto, weProductReg, strImages);
        this.Option(dto, dtllist, weProductReg, resultMarketPrice);
        this.Notice(dto, dtllist, weProductReg, shoppingMallDetailDto);
        this.Etc(dto, dtllist, weProductReg, shoppingMallDetailDto);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)weProductReg);
        return json;
    }

    private boolean setProductStop(String status2, ShoppingmallDTO shoppingMallDetailDto, ProductDTO dto, ShopProductAdditionDto dtllist, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) {
        JsonObject jsonObject;
        block3: {
            ProductStatus productStatus = new ProductStatus();
            productStatus.productNo = dto.getShopprodno();
            productStatus.productStatus = "S";
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            String json = mapper.writeValueAsString((Object)productStatus);
            YDMAStringUtil.Print(json);
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("wemarket/api/v1/setProductStatusAPI")).method("POST", body).addHeader("apiKey", shoppingMallDetailDto.getAPIKEY()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request2).execute();
            String data2 = response.body().string().toString();
            JsonParser jsonParser = new JsonParser();
            jsonObject = (JsonObject)jsonParser.parse(data2);
            int code = jsonObject.get("resultCode").getAsInt();
            if (code != 200) break block3;
            return true;
        }
        try {
            String returnMsg = jsonObject.get("returnMsg").getAsString();
            dto.setResult_text(returnMsg);
        }
        catch (Exception exception) {
            dto.setResult_text("\uc218\uc815\uc2dc \uc54c\uc218\uc5c6\ub294 \uc624\ub958\uac00 \ubc1c\uc0dd");
        }
        return false;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        boolean flag = true;
        try {
            shopProductSendDto.getWorkMngDto().getWorkcd();
            switch (status2) {
                case "6": 
                case "7": 
                case "8": {
                    flag = this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto, loginCookies);
                    if (!flag) {
                        return flag;
                    }
                    shopProductDto.setShopprodno("");
                    break;
                }
                case "0": {
                    Thread.sleep(1000L);
                    ShopWeMarketAdditionDto wemarketdtllist = (ShopWeMarketAdditionDto)shopProductSendDto.getProductAdditionDto();
                    List<Object> strImages = new ArrayList();
                    strImages = wemarketdtllist.getChangesize().equals("Y") ? this.getProductImages(shopProductDto, wemarketdtllist.getChangeSizeX(), wemarketdtllist.getChangeSizeY(), wemarketdtllist.getChangeSizeW(), wemarketdtllist.getChangeSizeH()) : this.getProductImages(shopProductDto);
                    if (wemarketdtllist.getImgThreeOnFour().equals("Y")) {
                        strImages = this.setImgRatioChange(shopProductDto, strImages, shoppingMallDetailDto);
                    }
                    String json = this.setProductReg(shopProductDto, wemarketdtllist, shoppingMallDetailDto, loginCookies, strImages);
                    this.productRegSend(json, shopProductDto, shoppingMallDetailDto);
                }
                default: {
                    break;
                }
                case "9": {
                    return true;
                }
            }
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            return false;
        }
        return true;
    }

    private synchronized void productRegSend(String json, ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        YDMAStringUtil.Print(json);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
        Request request2 = new Request.Builder().url(Host.concat("wemarket/api/v1/setProductAPI")).method("POST", body).addHeader("apiKey", shoppingMallDetailDto.getAPIKEY()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string().toString();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
        int code = jsonObject.get("resultCode").getAsInt();
        if (code == 200) {
            JsonObject value = (JsonObject)jsonObject.get("data");
            dto.setResult_code("1");
            dto.setShopprodno(value.get("productNo").getAsString());
        } else {
            dto.setResult_code("-1");
            dto.setResult_text(jsonObject.get("error").getAsString());
        }
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request2 = new Request.Builder().url(Host.concat(String.format("wemarket/api/v1/getProductAPI?productNo=%s", dto.getShopprodno()))).method("GET", null).addHeader("apiKey", shoppingMallDetailDto.getAPIKEY()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request2).execute();
            String data2 = response.body().string().toString();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
            int code = jsonObject.get("resultCode").getAsInt();
            return code == 200;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private boolean setProductStop(ShoppingmallDTO shopInfo, ProductDTO prodInfo) {
        JsonObject jsonObject;
        block3: {
            ProductStatus productStatus = new ProductStatus();
            productStatus.productNo = prodInfo.getShopprodno();
            productStatus.productStatus = "S";
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            String json = mapper.writeValueAsString((Object)productStatus);
            YDMAStringUtil.Print(json);
            OkHttpClient client = AppConfigHelper.getInstance().getOkHttpClient();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("wemarket/api/v1/setProductStatusAPI")).method("POST", body).addHeader("apiKey", shopInfo.getAPIKEY()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request2).execute();
            String data2 = response.body().string().toString();
            JsonParser jsonParser = new JsonParser();
            jsonObject = (JsonObject)jsonParser.parse(data2);
            int code = jsonObject.get("resultCode").getAsInt();
            if (code != 200 && code != 422) break block3;
            return true;
        }
        try {
            String returnMsg = jsonObject.get("returnMsg").getAsString();
            prodInfo.setResult_text(returnMsg);
        }
        catch (Exception exception) {
            prodInfo.setResult_text("\uc218\uc815\uc2dc \uc54c\uc218\uc5c6\ub294 \uc624\ub958\uac00 \ubc1c\uc0dd");
        }
        return false;
    }

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto) throws Exception {
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        ProductDTO prodInfo = dto.getPRODUCT();
        String shopInfoLog = String.format("[%s - %s(%s)]", dto.getSHOPINFO().getSHOPNM(), dto.getSHOPINFO().getSHOPPINGID(), dto.getSHOPINFO().getNICKNM1());
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 3000: 
                case 4000: {
                    boolean flag = this.setProductStop(shopInfo, prodInfo);
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\ud310\ub9e4\uc911\uc9c0", shopInfo, "\uc131\uacf5", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\uc9c0 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    dto.getPRODUCT().setShopprodno("");
                    Thread.sleep(1000L);
                }
            }
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        ArrayList<ProductOptionDTO> requestOptions = new ArrayList<ProductOptionDTO>();
        try {
            List<ProductOptionDTO> options = dto.getPRODUCT().getOPTIONS();
            List<ProductOptionDTO> oldOptions = ProductDAO.get().selectOptProductIn(dto.getPRODUCT().getSENDSEQ());
            for (ProductOptionDTO oldOption : oldOptions) {
                ProductOptionDTO filter = options.stream().filter(p -> p.getSENDSEQ() == oldOption.getSENDSEQ() && p.getSKUSEQ() == oldOption.getSKUSEQ()).findFirst().orElse(null);
                if (filter != null) {
                    oldOption.setOPTVERTSTOCK(0);
                }
                requestOptions.add(oldOption);
            }
            options.sort((p1, p2) -> Integer.compare(p1.getSKUSEQ(), p2.getSKUSEQ()));
            String json = this.getOptionModifyJson(requestOptions);
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(MallCode.getWemarketOptionModifyURL()).method("POST", body).addHeader("apiKey", dto.getSHOPINFO().getAPIKEY()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
            OkHttpClient client = AppConfigHelper.getInstance().getOkHttpClient();
            Response response = client.newCall(request2).execute();
            JsonParser parser = new JsonParser();
            JsonObject bodyObj = (JsonObject)parser.parse(response.body().string());
            if (bodyObj.get("resultCode").getAsInt() == 200) {
                return new ResultProcessDTO(0, "Success", dto.getPRODUCT().getCompayny_goods_cd());
            }
            return new ResultProcessDTO(-1, "Failed", dto.getPRODUCT().getCompayny_goods_cd());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getCompayny_goods_cd());
        }
    }

    private String getOptionModifyJson(List<ProductOptionDTO> optionParams) {
        String[] names = optionParams.get(0).getOPTPRODNM().split("/");
        try {
            ArrayList<WemarketSelectOptionValueList> selectOptionValueList = new ArrayList<WemarketSelectOptionValueList>();
            for (ProductOptionDTO param : optionParams) {
                String[] vals = param.getOPTSPECDES().split("/");
                WemarketSelectOptionValueList selectOptionValue = new WemarketSelectOptionValueList();
                selectOptionValue.setOptionValue1(vals.length > 0 ? vals[0] : "");
                selectOptionValue.setOptionValue2(vals.length > 1 ? vals[1] : "");
                selectOptionValue.setStockCount(param.getOPTVERTSTOCK());
                selectOptionValue.setDisplayYn("Y");
                selectOptionValue.setSellerOptionCode(param.getOPTPRODCD());
                selectOptionValueList.add(selectOptionValue);
            }
            WemarketOption option2 = new WemarketOption();
            option2.setSelectOptionUseYn("Y");
            option2.setSelectOptionDepth(names.length);
            option2.setSelectOptionTitle1(names.length > 0 ? names[0] : "");
            option2.setSelectOptionTitle2(names.length > 1 ? names[1] : "");
            option2.setSelectOptionValueList(selectOptionValueList);
            option2.setTextOptionUseYn("N");
            option2.setTextOptionDepth(1);
            WemarketUpdateOptionRequest request2 = new WemarketUpdateOptionRequest();
            request2.setProductNo(Long.parseLong(optionParams.get(0).getSHOPPRODNO()));
            request2.setOption(option2);
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString((Object)request2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String logType) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackAndLogForProdIn(comment, 50, prodInfo, shoppingmallDTO, "YEL_DEL", jobResult, logType);
    }

    private static class Basic {
        private String productName;
        private String productType;
        private String dcateCode;
        private String shipPolicyNo;
        private ShipInfo shipInfo;
        private String adultLimitYn;
        private String displayYn;
        private String bizYn;
        private String styleYn;
        private String brandNo;
        private String makerNo;

        private Basic() {
        }

        public String getProductName() {
            return this.productName;
        }

        public void setProductName(String productName) {
            this.productName = productName;
        }

        public String getProductType() {
            return this.productType;
        }

        public void setProductType(String productType) {
            this.productType = productType;
        }

        public String getDcateCode() {
            return this.dcateCode;
        }

        public void setDcateCode(String dcateCode) {
            this.dcateCode = dcateCode;
        }

        public String getShipPolicyNo() {
            return this.shipPolicyNo;
        }

        public void setShipPolicyNo(String shipPolicyNo) {
            this.shipPolicyNo = shipPolicyNo;
        }

        public ShipInfo getShipInfo() {
            return this.shipInfo;
        }

        public void setShipInfo(ShipInfo shipInfo) {
            this.shipInfo = shipInfo;
        }

        public String getAdultLimitYn() {
            return this.adultLimitYn;
        }

        public void setAdultLimitYn(String adultLimitYn) {
            this.adultLimitYn = adultLimitYn;
        }

        public String getDisplayYn() {
            return this.displayYn;
        }

        public void setDisplayYn(String displayYn) {
            this.displayYn = displayYn;
        }

        public String getBizYn() {
            return this.bizYn;
        }

        public void setBizYn(String bizYn) {
            this.bizYn = bizYn;
        }

        public String getStyleYn() {
            return this.styleYn;
        }

        public void setStyleYn(String styleYn) {
            this.styleYn = styleYn;
        }

        public String getBrandNo() {
            return this.brandNo;
        }

        public void setBrandNo(String brandNo) {
            this.brandNo = brandNo;
        }

        public String getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(String makerNo) {
            this.makerNo = makerNo;
        }
    }

    private static class BranchList {
        private String branchId;
        private String originPrice;
        private String salePrice;
        private String useYn;

        private BranchList() {
        }

        public String getBranchId() {
            return this.branchId;
        }

        public void setBranchId(String branchId) {
            this.branchId = branchId;
        }

        public String getOriginPrice() {
            return this.originPrice;
        }

        public void setOriginPrice(String originPrice) {
            this.originPrice = originPrice;
        }

        public String getSalePrice() {
            return this.salePrice;
        }

        public void setSalePrice(String salePrice) {
            this.salePrice = salePrice;
        }

        public String getUseYn() {
            return this.useYn;
        }

        public void setUseYn(String useYn) {
            this.useYn = useYn;
        }
    }

    private static class Brand {
        private String resultCode;
        private List<BrandData> data;
        private String error;

        private Brand() {
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public List<BrandData> getData() {
            return this.data;
        }

        public void setData(List<BrandData> data2) {
            this.data = data2;
        }
    }

    private static class BrandData {
        private String brandNo;
        private String brandName;
        private String brandNameEnglish;
        private String makerNo;
        private String makerName;

        private BrandData() {
        }

        public String getBrandNo() {
            return this.brandNo;
        }

        public void setBrandNo(String brandNo) {
            this.brandNo = brandNo;
        }

        public String getBrandName() {
            return this.brandName;
        }

        public void setBrandName(String brandName) {
            this.brandName = brandName;
        }

        public String getBrandNameEnglish() {
            return this.brandNameEnglish;
        }

        public void setBrandNameEnglish(String brandNameEnglish) {
            this.brandNameEnglish = brandNameEnglish;
        }

        public String getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(String makerNo) {
            this.makerNo = makerNo;
        }

        public String getMakerName() {
            return this.makerName;
        }

        public void setMakerName(String makerName) {
            this.makerName = makerName;
        }
    }

    private static class BrandSearch {
        private String brandDesc;
        private String brandNm;
        private String brandNmEng;
        private String brandNo;
        private String chgDt;
        private String chgNm;
        private String imgUrl;
        private String makerNm;
        private String makerNo;
        private String regDt;
        private String regNm;
        private String useYn;

        private BrandSearch() {
        }

        public String getBrandDesc() {
            return this.brandDesc;
        }

        public void setBrandDesc(String brandDesc) {
            this.brandDesc = brandDesc;
        }

        public String getBrandNm() {
            return this.brandNm;
        }

        public void setBrandNm(String brandNm) {
            this.brandNm = brandNm;
        }

        public String getBrandNmEng() {
            return this.brandNmEng;
        }

        public void setBrandNmEng(String brandNmEng) {
            this.brandNmEng = brandNmEng;
        }

        public String getBrandNo() {
            return this.brandNo;
        }

        public void setBrandNo(String brandNo) {
            this.brandNo = brandNo;
        }

        public String getChgDt() {
            return this.chgDt;
        }

        public void setChgDt(String chgDt) {
            this.chgDt = chgDt;
        }

        public String getChgNm() {
            return this.chgNm;
        }

        public void setChgNm(String chgNm) {
            this.chgNm = chgNm;
        }

        public String getImgUrl() {
            return this.imgUrl;
        }

        public void setImgUrl(String imgUrl) {
            this.imgUrl = imgUrl;
        }

        public String getMakerNm() {
            return this.makerNm;
        }

        public void setMakerNm(String makerNm) {
            this.makerNm = makerNm;
        }

        public String getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(String makerNo) {
            this.makerNo = makerNo;
        }

        public String getRegDt() {
            return this.regDt;
        }

        public void setRegDt(String regDt) {
            this.regDt = regDt;
        }

        public String getRegNm() {
            return this.regNm;
        }

        public void setRegNm(String regNm) {
            this.regNm = regNm;
        }

        public String getUseYn() {
            return this.useYn;
        }

        public void setUseYn(String useYn) {
            this.useYn = useYn;
        }
    }

    private static class Data {
        private String partnerGroupId;
        private int shipPolicyNo;
        private String shipPolicyName;
        private String shipMng;
        private String shipMethod;
        private String parcelCompanyCode;
        private String bundleKind;
        private String shipType;
        private String shipFee;
        private String shipFeeDisplayYn;
        private String freeCondition;
        private String differenceYn;
        private String differenceCount;
        private String prepaymentYn;
        private String claimShipFee;
        private String shipArea;
        private String jejuShipFee;
        private String islandMountainShipFee;
        private String releaseDay;
        private String releaseTime;
        private String holidayExceptYn;
        private String releaseZipCode;
        private String releaseRoadAddress1;
        private String releaseRoadAddress2;
        private String releaseAddress1;
        private String releaseAddress2;
        private String returnZipCode;
        private String returnRoadAddress1;
        private String returnRoadAddress2;
        private String returnAddress1;
        private String returnAddress2;
        private String safetyNoDisplayYn;

        private Data() {
        }

        public String getPartnerGroupId() {
            return this.partnerGroupId;
        }

        public void setPartnerGroupId(String partnerGroupId) {
            this.partnerGroupId = partnerGroupId;
        }

        public int getShipPolicyNo() {
            return this.shipPolicyNo;
        }

        public void setShipPolicyNo(int shipPolicyNo) {
            this.shipPolicyNo = shipPolicyNo;
        }

        public String getShipPolicyName() {
            return this.shipPolicyName;
        }

        public void setShipPolicyName(String shipPolicyName) {
            this.shipPolicyName = shipPolicyName;
        }

        public String getShipMng() {
            return this.shipMng;
        }

        public void setShipMng(String shipMng) {
            this.shipMng = shipMng;
        }

        public String getShipMethod() {
            return this.shipMethod;
        }

        public String getParcelCompanyCode() {
            return this.parcelCompanyCode;
        }

        public void setParcelCompanyCode(String parcelCompanyCode) {
            this.parcelCompanyCode = parcelCompanyCode;
        }

        public void setShipMethod(String shipMethod) {
            this.shipMethod = shipMethod;
        }

        public String getBundleKind() {
            return this.bundleKind;
        }

        public void setBundleKind(String bundleKind) {
            this.bundleKind = bundleKind;
        }

        public String getShipType() {
            return this.shipType;
        }

        public void setShipType(String shipType) {
            this.shipType = shipType;
        }

        public String getShipFee() {
            return this.shipFee;
        }

        public void setShipFee(String shipFee) {
            this.shipFee = shipFee;
        }

        public String getShipFeeDisplayYn() {
            return this.shipFeeDisplayYn;
        }

        public void setShipFeeDisplayYn(String shipFeeDisplayYn) {
            this.shipFeeDisplayYn = shipFeeDisplayYn;
        }

        public String getFreeCondition() {
            return this.freeCondition;
        }

        public void setFreeCondition(String freeCondition) {
            this.freeCondition = freeCondition;
        }

        public String getDifferenceYn() {
            return this.differenceYn;
        }

        public void setDifferenceYn(String differenceYn) {
            this.differenceYn = differenceYn;
        }

        public String getDifferenceCount() {
            return this.differenceCount;
        }

        public void setDifferenceCount(String differenceCount) {
            this.differenceCount = differenceCount;
        }

        public String getPrepaymentYn() {
            return this.prepaymentYn;
        }

        public void setPrepaymentYn(String prepaymentYn) {
            this.prepaymentYn = prepaymentYn;
        }

        public String getClaimShipFee() {
            return this.claimShipFee;
        }

        public void setClaimShipFee(String claimShipFee) {
            this.claimShipFee = claimShipFee;
        }

        public String getShipArea() {
            return this.shipArea;
        }

        public void setShipArea(String shipArea) {
            this.shipArea = shipArea;
        }

        public String getJejuShipFee() {
            return this.jejuShipFee;
        }

        public void setJejuShipFee(String jejuShipFee) {
            this.jejuShipFee = jejuShipFee;
        }

        public String getIslandMountainShipFee() {
            return this.islandMountainShipFee;
        }

        public void setIslandMountainShipFee(String islandMountainShipFee) {
            this.islandMountainShipFee = islandMountainShipFee;
        }

        public String getReleaseDay() {
            return this.releaseDay;
        }

        public void setReleaseDay(String releaseDay) {
            this.releaseDay = releaseDay;
        }

        public String getReleaseTime() {
            return this.releaseTime;
        }

        public void setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
        }

        public String getHolidayExceptYn() {
            return this.holidayExceptYn;
        }

        public void setHolidayExceptYn(String holidayExceptYn) {
            this.holidayExceptYn = holidayExceptYn;
        }

        public String getReleaseZipCode() {
            return this.releaseZipCode;
        }

        public void setReleaseZipCode(String releaseZipCode) {
            this.releaseZipCode = releaseZipCode;
        }

        public String getReleaseRoadAddress1() {
            return this.releaseRoadAddress1;
        }

        public void setReleaseRoadAddress1(String releaseRoadAddress1) {
            this.releaseRoadAddress1 = releaseRoadAddress1;
        }

        public String getReleaseRoadAddress2() {
            return this.releaseRoadAddress2;
        }

        public void setReleaseRoadAddress2(String releaseRoadAddress2) {
            this.releaseRoadAddress2 = releaseRoadAddress2;
        }

        public String getReleaseAddress1() {
            return this.releaseAddress1;
        }

        public void setReleaseAddress1(String releaseAddress1) {
            this.releaseAddress1 = releaseAddress1;
        }

        public String getReleaseAddress2() {
            return this.releaseAddress2;
        }

        public void setReleaseAddress2(String releaseAddress2) {
            this.releaseAddress2 = releaseAddress2;
        }

        public String getReturnZipCode() {
            return this.returnZipCode;
        }

        public void setReturnZipCode(String returnZipCode) {
            this.returnZipCode = returnZipCode;
        }

        public String getReturnRoadAddress1() {
            return this.returnRoadAddress1;
        }

        public void setReturnRoadAddress1(String returnRoadAddress1) {
            this.returnRoadAddress1 = returnRoadAddress1;
        }

        public String getReturnRoadAddress2() {
            return this.returnRoadAddress2;
        }

        public void setReturnRoadAddress2(String returnRoadAddress2) {
            this.returnRoadAddress2 = returnRoadAddress2;
        }

        public String getReturnAddress1() {
            return this.returnAddress1;
        }

        public void setReturnAddress1(String returnAddress1) {
            this.returnAddress1 = returnAddress1;
        }

        public String getReturnAddress2() {
            return this.returnAddress2;
        }

        public void setReturnAddress2(String returnAddress2) {
            this.returnAddress2 = returnAddress2;
        }

        public String getSafetyNoDisplayYn() {
            return this.safetyNoDisplayYn;
        }

        public void setSafetyNoDisplayYn(String safetyNoDisplayYn) {
            this.safetyNoDisplayYn = safetyNoDisplayYn;
        }
    }

    private static class Detail {
        private String basicImgUrl;
        private List<String> addImgUrlList;
        private String listImgUrl;
        private String descType;
        private List<String> descImgUrlList;
        private String descHtml;

        private Detail() {
        }

        public String getBasicImgUrl() {
            return this.basicImgUrl;
        }

        public void setBasicImgUrl(String basicImgUrl) {
            this.basicImgUrl = basicImgUrl;
        }

        public List<String> getAddImgUrlList() {
            return this.addImgUrlList;
        }

        public void setAddImgUrlList(List<String> addImgUrlList) {
            this.addImgUrlList = addImgUrlList;
        }

        public String getListImgUrl() {
            return this.listImgUrl;
        }

        public void setListImgUrl(String listImgUrl) {
            this.listImgUrl = listImgUrl;
        }

        public String getDescType() {
            return this.descType;
        }

        public void setDescType(String descType) {
            this.descType = descType;
        }

        public List<String> getDescImgUrlList() {
            return this.descImgUrlList;
        }

        public void setDescImgUrlList(List<String> descImgUrlList) {
            this.descImgUrlList = descImgUrlList;
        }

        public String getDescHtml() {
            return this.descHtml;
        }

        public void setDescHtml(String descHtml) {
            this.descHtml = descHtml;
        }
    }

    private static class Etc {
        private String parallelImportYn;
        private String parallelImportUrl;
        private String kcKidIsCertification;
        private List<KcKidCertificationList> kcKidCertificationList;
        private String kcLifeIsCertification;
        private List<KcLifeCertificationList> kcLifeCertificationList;
        private String kcElectricIsCertification;
        private List<KcElectricCertificationList> kcElectricCertificationList;
        private String kcReportIsCertification;
        private List<KcReportCertificationList> kcReportCertificationList;
        private String kcLifeChemistryIsCertification;
        private List<KcLifeChemistryCertificationList> kcLifeChemistryCertificationList;
        private String sellerProdCode;
        private String priceComparisonSiteYn;
        private String keywordPriceComparisonSite;
        private String keywordWemakeprice;
        private String isbn13;
        private String isbn10;
        private String displayOnlyDealYn;
        private String reviewDisp;
        private List<String> labelNoList;

        private Etc() {
        }
    }

    private static class KcElectricCertificationList {
        private String certificationType;
        private String certificationNo;

        private KcElectricCertificationList() {
        }

        public String getCertificationType() {
            return this.certificationType;
        }

        public void setCertificationType(String certificationType) {
            this.certificationType = certificationType;
        }

        public String getCertificationNo() {
            return this.certificationNo;
        }

        public void setCertificationNo(String certificationNo) {
            this.certificationNo = certificationNo;
        }
    }

    private static class KcKidCertificationList {
        private String certificationType;
        private String certificationNo;

        private KcKidCertificationList() {
        }

        public String getCertificationType() {
            return this.certificationType;
        }

        public void setCertificationType(String certificationType) {
            this.certificationType = certificationType;
        }

        public String getCertificationNo() {
            return this.certificationNo;
        }

        public void setCertificationNo(String certificationNo) {
            this.certificationNo = certificationNo;
        }
    }

    private static class KcLifeCertificationList {
        private String certificationType;
        private String certificationNo;

        private KcLifeCertificationList() {
        }

        public String getCertificationType() {
            return this.certificationType;
        }

        public void setCertificationType(String certificationType) {
            this.certificationType = certificationType;
        }

        public String getCertificationNo() {
            return this.certificationNo;
        }

        public void setCertificationNo(String certificationNo) {
            this.certificationNo = certificationNo;
        }
    }

    private static class KcLifeChemistryCertificationList {
        private String certificationType;
        private String certificationNo;

        private KcLifeChemistryCertificationList() {
        }

        public String getCertificationType() {
            return this.certificationType;
        }

        public void setCertificationType(String certificationType) {
            this.certificationType = certificationType;
        }

        public String getCertificationNo() {
            return this.certificationNo;
        }

        public void setCertificationNo(String certificationNo) {
            this.certificationNo = certificationNo;
        }
    }

    private static class KcReportCertificationList {
        private String certificationType;
        private String certificationNo;

        private KcReportCertificationList() {
        }

        public String getCertificationType() {
            return this.certificationType;
        }

        public void setCertificationType(String certificationType) {
            this.certificationType = certificationType;
        }

        public String getCertificationNo() {
            return this.certificationNo;
        }

        public void setCertificationNo(String certificationNo) {
            this.certificationNo = certificationNo;
        }
    }

    private static class Maker {
        private String resultCode;
        private List<MakerData> data;
        private String error;

        private Maker() {
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public List<MakerData> getData() {
            return this.data;
        }

        public void setData(List<MakerData> data2) {
            this.data = data2;
        }
    }

    private static class MakerData {
        private String makerNo;
        private String makerName;
        private String makerNameEnglish;

        private MakerData() {
        }

        public String getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(String makerNo) {
            this.makerNo = makerNo;
        }

        public String getMakerName() {
            return this.makerName;
        }

        public void setMakerName(String makerName) {
            this.makerName = makerName;
        }

        public String getMakerNameEnglish() {
            return this.makerNameEnglish;
        }

        public void setMakerNameEnglish(String makerNameEnglish) {
            this.makerNameEnglish = makerNameEnglish;
        }
    }

    private static class MakerSearch {
        private String chgDt;
        private String chgNm;
        private String makerNm;
        private String makerNmEng;
        private String makerNo;
        private String regDt;
        private String regNm;
        private String siteUrl;
        private String useYn;

        private MakerSearch() {
        }

        public String getChgDt() {
            return this.chgDt;
        }

        public void setChgDt(String chgDt) {
            this.chgDt = chgDt;
        }

        public String getChgNm() {
            return this.chgNm;
        }

        public void setChgNm(String chgNm) {
            this.chgNm = chgNm;
        }

        public String getMakerNm() {
            return this.makerNm;
        }

        public void setMakerNm(String makerNm) {
            this.makerNm = makerNm;
        }

        public String getMakerNmEng() {
            return this.makerNmEng;
        }

        public void setMakerNmEng(String makerNmEng) {
            this.makerNmEng = makerNmEng;
        }

        public String getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(String makerNo) {
            this.makerNo = makerNo;
        }

        public String getRegDt() {
            return this.regDt;
        }

        public void setRegDt(String regDt) {
            this.regDt = regDt;
        }

        public String getRegNm() {
            return this.regNm;
        }

        public void setRegNm(String regNm) {
            this.regNm = regNm;
        }

        public String getSiteUrl() {
            return this.siteUrl;
        }

        public void setSiteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
        }

        public String getUseYn() {
            return this.useYn;
        }

        public void setUseYn(String useYn) {
            this.useYn = useYn;
        }
    }

    private static class NoticeData {
        private String groupNoticeNo;
        private String groupNoticeNoName;
        private List<NoticeLists> noticeList;

        private NoticeData() {
        }

        public String getGroupNoticeNo() {
            return this.groupNoticeNo;
        }

        public void setGroupNoticeNo(String groupNoticeNo) {
            this.groupNoticeNo = groupNoticeNo;
        }

        public String getGroupNoticeNoName() {
            return this.groupNoticeNoName;
        }

        public void setGroupNoticeNoName(String groupNoticeNoName) {
            this.groupNoticeNoName = groupNoticeNoName;
        }

        public List<NoticeLists> getNoticeList() {
            return this.noticeList;
        }

        public void setNoticeList(List<NoticeLists> noticeList) {
            this.noticeList = noticeList;
        }
    }

    private static class NoticeListMain {
        private String groupNoticeNo;
        private List<NoticeListValue> noticeList = new ArrayList<NoticeListValue>();

        private NoticeListMain() {
        }

        public String getGroupNoticeNo() {
            return this.groupNoticeNo;
        }

        public void setGroupNoticeNo(String groupNoticeNo) {
            this.groupNoticeNo = groupNoticeNo;
        }

        public List<NoticeListValue> getNoticeList() {
            return this.noticeList;
        }

        public void setNoticeList(List<NoticeListValue> noticeList) {
            this.noticeList = noticeList;
        }
    }

    private static class NoticeListValue {
        private String noticeNo;
        private String description;

        private NoticeListValue() {
        }

        public String getNoticeNo() {
            return this.noticeNo;
        }

        public void setNoticeNo(String noticeNo) {
            this.noticeNo = noticeNo;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    private static class NoticeLists {
        private String noticeNo;
        private String noticeName;
        private String defaltValue;

        private NoticeLists() {
        }

        public String getNoticeNo() {
            return this.noticeNo;
        }

        public void setNoticeNo(String noticeNo) {
            this.noticeNo = noticeNo;
        }

        public String getNoticeName() {
            return this.noticeName;
        }

        public void setNoticeName(String noticeName) {
            this.noticeName = noticeName;
        }

        public String getDefaltValue() {
            return this.defaltValue;
        }

        public void setDefaltValue(String defaltValue) {
            this.defaltValue = defaltValue;
        }
    }

    private static class NoticeType {
        private int gnoticeNo;
        private int noticeNo;
        private String noticeNm;
        private int priority;
        private String commentType;
        private String commentTypeName;
        private String placeholder;
        private String useYn;
        private String prodDesc;

        private NoticeType() {
        }

        public int getGnoticeNo() {
            return this.gnoticeNo;
        }

        public void setGnoticeNo(int gnoticeNo) {
            this.gnoticeNo = gnoticeNo;
        }

        public int getNoticeNo() {
            return this.noticeNo;
        }

        public void setNoticeNo(int noticeNo) {
            this.noticeNo = noticeNo;
        }

        public String getNoticeNm() {
            return this.noticeNm;
        }

        public void setNoticeNm(String noticeNm) {
            this.noticeNm = noticeNm;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public String getCommentType() {
            return this.commentType;
        }

        public void setCommentType(String commentType) {
            this.commentType = commentType;
        }

        public String getCommentTypeName() {
            return this.commentTypeName;
        }

        public void setCommentTypeName(String commentTypeName) {
            this.commentTypeName = commentTypeName;
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        public void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }

        public String getUseYn() {
            return this.useYn;
        }

        public void setUseYn(String useYn) {
            this.useYn = useYn;
        }

        public String getProdDesc() {
            return this.prodDesc;
        }

        public void setProdDesc(String prodDesc) {
            this.prodDesc = prodDesc;
        }
    }

    private static class NoticeTypeGET {
        private String resultCode;
        private List<NoticeData> data;
        private String error;

        private NoticeTypeGET() {
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public List<NoticeData> getData() {
            return this.data;
        }

        public void setData(List<NoticeData> data2) {
            this.data = data2;
        }
    }

    private static class Option {
        private String selectOptionUseYn;
        private String selectOptionDepth;
        private String selectOptionTitle1;
        private String selectOptionTitle2;
        private String selectOptionTitle3;
        private String selectOptionTitle4;
        private String selectOptionTitle5;
        private List<SelectOptionValueList> selectOptionValueList;
        private String textOptionUseYn;
        private String textOptionDepth;
        private String textOptionTitle1;
        private String textOptionTitle2;

        private Option() {
        }

        public String getSelectOptionUseYn() {
            return this.selectOptionUseYn;
        }

        public void setSelectOptionUseYn(String selectOptionUseYn) {
            this.selectOptionUseYn = selectOptionUseYn;
        }

        public String getSelectOptionDepth() {
            return this.selectOptionDepth;
        }

        public void setSelectOptionDepth(String selectOptionDepth) {
            this.selectOptionDepth = selectOptionDepth;
        }

        public String getSelectOptionTitle1() {
            return this.selectOptionTitle1;
        }

        public void setSelectOptionTitle1(String selectOptionTitle1) {
            this.selectOptionTitle1 = selectOptionTitle1;
        }

        public String getSelectOptionTitle2() {
            return this.selectOptionTitle2;
        }

        public void setSelectOptionTitle2(String selectOptionTitle2) {
            this.selectOptionTitle2 = selectOptionTitle2;
        }

        public String getSelectOptionTitle3() {
            return this.selectOptionTitle3;
        }

        public void setSelectOptionTitle3(String selectOptionTitle3) {
            this.selectOptionTitle3 = selectOptionTitle3;
        }

        public String getSelectOptionTitle4() {
            return this.selectOptionTitle4;
        }

        public void setSelectOptionTitle4(String selectOptionTitle4) {
            this.selectOptionTitle4 = selectOptionTitle4;
        }

        public String getSelectOptionTitle5() {
            return this.selectOptionTitle5;
        }

        public void setSelectOptionTitle5(String selectOptionTitle5) {
            this.selectOptionTitle5 = selectOptionTitle5;
        }

        public List<SelectOptionValueList> getSelectOptionValueList() {
            return this.selectOptionValueList;
        }

        public void setSelectOptionValueList(List<SelectOptionValueList> selectOptionValueList) {
            this.selectOptionValueList = selectOptionValueList;
        }

        public String getTextOptionUseYn() {
            return this.textOptionUseYn;
        }

        public void setTextOptionUseYn(String textOptionUseYn) {
            this.textOptionUseYn = textOptionUseYn;
        }

        public String getTextOptionDepth() {
            return this.textOptionDepth;
        }

        public void setTextOptionDepth(String textOptionDepth) {
            this.textOptionDepth = textOptionDepth;
        }

        public String getTextOptionTitle1() {
            return this.textOptionTitle1;
        }

        public void setTextOptionTitle1(String textOptionTitle1) {
            this.textOptionTitle1 = textOptionTitle1;
        }

        public String getTextOptionTitle2() {
            return this.textOptionTitle2;
        }

        public void setTextOptionTitle2(String textOptionTitle2) {
            this.textOptionTitle2 = textOptionTitle2;
        }
    }

    private static class ProductStatus {
        private String productNo;
        private String productStatus;

        private ProductStatus() {
        }
    }

    private static class Sale {
        private String salePeriod;
        private String saleStartDate;
        private String saleEndDate;
        private String originPrice;
        private String salePrice;
        private String stockCount;
        private String taxYn;
        private String purchaseMinCount;
        private String purchaseLimitYn;
        private String purchaseLimitDuration;
        private String purchaseLimitDay;
        private String purchaseLimitCount;
        private String basketLimitYn;
        private String referencePriceType;

        private Sale() {
        }

        public String getSalePeriod() {
            return this.salePeriod;
        }

        public void setSalePeriod(String salePeriod) {
            this.salePeriod = salePeriod;
        }

        public String getSaleStartDate() {
            return this.saleStartDate;
        }

        public void setSaleStartDate(String saleStartDate) {
            this.saleStartDate = saleStartDate;
        }

        public String getSaleEndDate() {
            return this.saleEndDate;
        }

        public void setSaleEndDate(String saleEndDate) {
            this.saleEndDate = saleEndDate;
        }

        public String getOriginPrice() {
            return this.originPrice;
        }

        public void setOriginPrice(String originPrice) {
            this.originPrice = originPrice;
        }

        public String getSalePrice() {
            return this.salePrice;
        }

        public void setSalePrice(String salePrice) {
            this.salePrice = salePrice;
        }

        public String getStockCount() {
            return this.stockCount;
        }

        public void setStockCount(String stockCount) {
            this.stockCount = stockCount;
        }

        public String getTaxYn() {
            return this.taxYn;
        }

        public void setTaxYn(String taxYn) {
            this.taxYn = taxYn;
        }

        public String getPurchaseMinCount() {
            return this.purchaseMinCount;
        }

        public void setPurchaseMinCount(String purchaseMinCount) {
            this.purchaseMinCount = purchaseMinCount;
        }

        public String getPurchaseLimitYn() {
            return this.purchaseLimitYn;
        }

        public void setPurchaseLimitYn(String purchaseLimitYn) {
            this.purchaseLimitYn = purchaseLimitYn;
        }

        public String getPurchaseLimitDuration() {
            return this.purchaseLimitDuration;
        }

        public void setPurchaseLimitDuration(String purchaseLimitDuration) {
            this.purchaseLimitDuration = purchaseLimitDuration;
        }

        public String getPurchaseLimitDay() {
            return this.purchaseLimitDay;
        }

        public void setPurchaseLimitDay(String purchaseLimitDay) {
            this.purchaseLimitDay = purchaseLimitDay;
        }

        public String getPurchaseLimitCount() {
            return this.purchaseLimitCount;
        }

        public void setPurchaseLimitCount(String purchaseLimitCount) {
            this.purchaseLimitCount = purchaseLimitCount;
        }

        public String getBasketLimitYn() {
            return this.basketLimitYn;
        }

        public void setBasketLimitYn(String basketLimitYn) {
            this.basketLimitYn = basketLimitYn;
        }

        public String getReferencePriceType() {
            return this.referencePriceType;
        }

        public void setReferencePriceType(String referencePriceType) {
            this.referencePriceType = referencePriceType;
        }
    }

    private static class SelectOptionValueList {
        private String optionValue1;
        private String optionValue2;
        private String optionValue3;
        private String optionValue4;
        private String optionValue5;
        private String optAddPrice;
        private String stockCount;
        private String displayYn;
        private String sellerOptionCode;

        private SelectOptionValueList() {
        }

        public String getOptionValue1() {
            return this.optionValue1;
        }

        public void setOptionValue1(String optionValue1) {
            this.optionValue1 = optionValue1;
        }

        public String getOptionValue2() {
            return this.optionValue2;
        }

        public void setOptionValue2(String optionValue2) {
            this.optionValue2 = optionValue2;
        }

        public String getOptionValue3() {
            return this.optionValue3;
        }

        public void setOptionValue3(String optionValue3) {
            this.optionValue3 = optionValue3;
        }

        public String getOptionValue4() {
            return this.optionValue4;
        }

        public void setOptionValue4(String optionValue4) {
            this.optionValue4 = optionValue4;
        }

        public String getOptionValue5() {
            return this.optionValue5;
        }

        public void setOptionValue5(String optionValue5) {
            this.optionValue5 = optionValue5;
        }

        public String getOptAddPrice() {
            return this.optAddPrice;
        }

        public void setOptAddPrice(String optAddPrice) {
            this.optAddPrice = optAddPrice;
        }

        public String getStockCount() {
            return this.stockCount;
        }

        public void setStockCount(String stockCount) {
            this.stockCount = stockCount;
        }

        public String getDisplayYn() {
            return this.displayYn;
        }

        public void setDisplayYn(String displayYn) {
            this.displayYn = displayYn;
        }

        public String getSellerOptionCode() {
            return this.sellerOptionCode;
        }

        public void setSellerOptionCode(String sellerOptionCode) {
            this.sellerOptionCode = sellerOptionCode;
        }
    }

    private static class ShipInfo {
        private String claimShipFee;
        private String releaseZipCode;
        private String releaseRoadAddress1;
        private String releaseRoadAddress2;
        private String releaseAddress1;
        private String releaseAddress2;
        private String returnZipCode;
        private String returnRoadAddress1;
        private String returnRoadAddress2;
        private String returnAddress1;
        private String returnAddress2;
        private String releaseDay;
        private String releaseTime;
        private String holidayExceptYn;

        private ShipInfo() {
        }

        public String getClaimShipFee() {
            return this.claimShipFee;
        }

        public void setClaimShipFee(String claimShipFee) {
            this.claimShipFee = claimShipFee;
        }

        public String getReleaseZipCode() {
            return this.releaseZipCode;
        }

        public void setReleaseZipCode(String releaseZipCode) {
            this.releaseZipCode = releaseZipCode;
        }

        public String getReleaseRoadAddress1() {
            return this.releaseRoadAddress1;
        }

        public void setReleaseRoadAddress1(String releaseRoadAddress1) {
            this.releaseRoadAddress1 = releaseRoadAddress1;
        }

        public String getReleaseRoadAddress2() {
            return this.releaseRoadAddress2;
        }

        public void setReleaseRoadAddress2(String releaseRoadAddress2) {
            this.releaseRoadAddress2 = releaseRoadAddress2;
        }

        public String getReleaseAddress1() {
            return this.releaseAddress1;
        }

        public void setReleaseAddress1(String releaseAddress1) {
            this.releaseAddress1 = releaseAddress1;
        }

        public String getReleaseAddress2() {
            return this.releaseAddress2;
        }

        public void setReleaseAddress2(String releaseAddress2) {
            this.releaseAddress2 = releaseAddress2;
        }

        public String getReturnZipCode() {
            return this.returnZipCode;
        }

        public void setReturnZipCode(String returnZipCode) {
            this.returnZipCode = returnZipCode;
        }

        public String getReturnRoadAddress1() {
            return this.returnRoadAddress1;
        }

        public void setReturnRoadAddress1(String returnRoadAddress1) {
            this.returnRoadAddress1 = returnRoadAddress1;
        }

        public String getReturnRoadAddress2() {
            return this.returnRoadAddress2;
        }

        public void setReturnRoadAddress2(String returnRoadAddress2) {
            this.returnRoadAddress2 = returnRoadAddress2;
        }

        public String getReturnAddress1() {
            return this.returnAddress1;
        }

        public void setReturnAddress1(String returnAddress1) {
            this.returnAddress1 = returnAddress1;
        }

        public String getReturnAddress2() {
            return this.returnAddress2;
        }

        public void setReturnAddress2(String returnAddress2) {
            this.returnAddress2 = returnAddress2;
        }

        public String getReleaseDay() {
            return this.releaseDay;
        }

        public void setReleaseDay(String releaseDay) {
            this.releaseDay = releaseDay;
        }

        public String getReleaseTime() {
            return this.releaseTime;
        }

        public void setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
        }

        public String getHolidayExceptYn() {
            return this.holidayExceptYn;
        }

        public void setHolidayExceptYn(String holidayExceptYn) {
            this.holidayExceptYn = holidayExceptYn;
        }
    }

    private static class ShipPolicy {
        private int shipPolicyNo;
        private String shipPolicyNm;
        private String defaultYn;
        private String shipMng;
        private String shipMngNm;
        private String warehouseInside;
        private String warehouseOutside;
        private String shipMethod;
        private String shipMethodNm;
        private String releaseDay;
        private String holidayExceptYn;
        private String holidayExceptYnNm;
        private String bundleKind;
        private String bundleKindNm;
        private String shipType;
        private String shipTypeNm;
        private String shipFee;
        private String shipFeeDispYn;
        private String shipFeeDispYnNm;
        private String freeCondition;
        private String diffYn;
        private String prepaymentYn;
        private String claimShipFee;
        private String shipArea;
        private String shipAreaNm;
        private String releaseZipcode;
        private String releaseAddr1;
        private String releaseAddr2;
        private String releaseRoadAddr1;
        private String releaseRoadAddr2;
        private String returnZipcode;
        private String returnAddr1;
        private String returnAddr2;
        private String returnRoadAddr1;
        private String returnRoadAddr2;
        private String useYn;
        private String safetyNoDispYn;
        private String safetyNoDispYnNm;

        private ShipPolicy() {
        }

        public int getShipPolicyNo() {
            return this.shipPolicyNo;
        }

        public void setShipPolicyNo(int shipPolicyNo) {
            this.shipPolicyNo = shipPolicyNo;
        }

        public String getShipPolicyNm() {
            return this.shipPolicyNm;
        }

        public void setShipPolicyNm(String shipPolicyNm) {
            this.shipPolicyNm = shipPolicyNm;
        }

        public String getDefaultYn() {
            return this.defaultYn;
        }

        public void setDefaultYn(String defaultYn) {
            this.defaultYn = defaultYn;
        }

        public String getShipMng() {
            return this.shipMng;
        }

        public void setShipMng(String shipMng) {
            this.shipMng = shipMng;
        }

        public String getShipMngNm() {
            return this.shipMngNm;
        }

        public void setShipMngNm(String shipMngNm) {
            this.shipMngNm = shipMngNm;
        }

        public String getWarehouseInside() {
            return this.warehouseInside;
        }

        public void setWarehouseInside(String warehouseInside) {
            this.warehouseInside = warehouseInside;
        }

        public String getWarehouseOutside() {
            return this.warehouseOutside;
        }

        public void setWarehouseOutside(String warehouseOutside) {
            this.warehouseOutside = warehouseOutside;
        }

        public String getShipMethod() {
            return this.shipMethod;
        }

        public void setShipMethod(String shipMethod) {
            this.shipMethod = shipMethod;
        }

        public String getShipMethodNm() {
            return this.shipMethodNm;
        }

        public void setShipMethodNm(String shipMethodNm) {
            this.shipMethodNm = shipMethodNm;
        }

        public String getReleaseDay() {
            return this.releaseDay;
        }

        public void setReleaseDay(String releaseDay) {
            this.releaseDay = releaseDay;
        }

        public String getHolidayExceptYn() {
            return this.holidayExceptYn;
        }

        public void setHolidayExceptYn(String holidayExceptYn) {
            this.holidayExceptYn = holidayExceptYn;
        }

        public String getHolidayExceptYnNm() {
            return this.holidayExceptYnNm;
        }

        public void setHolidayExceptYnNm(String holidayExceptYnNm) {
            this.holidayExceptYnNm = holidayExceptYnNm;
        }

        public String getBundleKind() {
            return this.bundleKind;
        }

        public void setBundleKind(String bundleKind) {
            this.bundleKind = bundleKind;
        }

        public String getBundleKindNm() {
            return this.bundleKindNm;
        }

        public void setBundleKindNm(String bundleKindNm) {
            this.bundleKindNm = bundleKindNm;
        }

        public String getShipType() {
            return this.shipType;
        }

        public void setShipType(String shipType) {
            this.shipType = shipType;
        }

        public String getShipTypeNm() {
            return this.shipTypeNm;
        }

        public void setShipTypeNm(String shipTypeNm) {
            this.shipTypeNm = shipTypeNm;
        }

        public String getShipFee() {
            return this.shipFee;
        }

        public void setShipFee(String shipFee) {
            this.shipFee = shipFee;
        }

        public String getShipFeeDispYn() {
            return this.shipFeeDispYn;
        }

        public void setShipFeeDispYn(String shipFeeDispYn) {
            this.shipFeeDispYn = shipFeeDispYn;
        }

        public String getShipFeeDispYnNm() {
            return this.shipFeeDispYnNm;
        }

        public void setShipFeeDispYnNm(String shipFeeDispYnNm) {
            this.shipFeeDispYnNm = shipFeeDispYnNm;
        }

        public String getFreeCondition() {
            return this.freeCondition;
        }

        public void setFreeCondition(String freeCondition) {
            this.freeCondition = freeCondition;
        }

        public String getDiffYn() {
            return this.diffYn;
        }

        public void setDiffYn(String diffYn) {
            this.diffYn = diffYn;
        }

        public String getPrepaymentYn() {
            return this.prepaymentYn;
        }

        public void setPrepaymentYn(String prepaymentYn) {
            this.prepaymentYn = prepaymentYn;
        }

        public String getClaimShipFee() {
            return this.claimShipFee;
        }

        public void setClaimShipFee(String claimShipFee) {
            this.claimShipFee = claimShipFee;
        }

        public String getShipArea() {
            return this.shipArea;
        }

        public void setShipArea(String shipArea) {
            this.shipArea = shipArea;
        }

        public String getShipAreaNm() {
            return this.shipAreaNm;
        }

        public void setShipAreaNm(String shipAreaNm) {
            this.shipAreaNm = shipAreaNm;
        }

        public String getReleaseZipcode() {
            return this.releaseZipcode;
        }

        public void setReleaseZipcode(String releaseZipcode) {
            this.releaseZipcode = releaseZipcode;
        }

        public String getReleaseAddr1() {
            return this.releaseAddr1;
        }

        public void setReleaseAddr1(String releaseAddr1) {
            this.releaseAddr1 = releaseAddr1;
        }

        public String getReleaseAddr2() {
            return this.releaseAddr2;
        }

        public void setReleaseAddr2(String releaseAddr2) {
            this.releaseAddr2 = releaseAddr2;
        }

        public String getReleaseRoadAddr1() {
            return this.releaseRoadAddr1;
        }

        public void setReleaseRoadAddr1(String releaseRoadAddr1) {
            this.releaseRoadAddr1 = releaseRoadAddr1;
        }

        public String getReleaseRoadAddr2() {
            return this.releaseRoadAddr2;
        }

        public void setReleaseRoadAddr2(String releaseRoadAddr2) {
            this.releaseRoadAddr2 = releaseRoadAddr2;
        }

        public String getReturnZipcode() {
            return this.returnZipcode;
        }

        public void setReturnZipcode(String returnZipcode) {
            this.returnZipcode = returnZipcode;
        }

        public String getReturnAddr1() {
            return this.returnAddr1;
        }

        public void setReturnAddr1(String returnAddr1) {
            this.returnAddr1 = returnAddr1;
        }

        public String getReturnAddr2() {
            return this.returnAddr2;
        }

        public void setReturnAddr2(String returnAddr2) {
            this.returnAddr2 = returnAddr2;
        }

        public String getReturnRoadAddr1() {
            return this.returnRoadAddr1;
        }

        public void setReturnRoadAddr1(String returnRoadAddr1) {
            this.returnRoadAddr1 = returnRoadAddr1;
        }

        public String getReturnRoadAddr2() {
            return this.returnRoadAddr2;
        }

        public void setReturnRoadAddr2(String returnRoadAddr2) {
            this.returnRoadAddr2 = returnRoadAddr2;
        }

        public String getUseYn() {
            return this.useYn;
        }

        public void setUseYn(String useYn) {
            this.useYn = useYn;
        }

        public String getSafetyNoDispYn() {
            return this.safetyNoDispYn;
        }

        public void setSafetyNoDispYn(String safetyNoDispYn) {
            this.safetyNoDispYn = safetyNoDispYn;
        }

        public String getSafetyNoDispYnNm() {
            return this.safetyNoDispYnNm;
        }

        public void setSafetyNoDispYnNm(String safetyNoDispYnNm) {
            this.safetyNoDispYnNm = safetyNoDispYnNm;
        }
    }

    private static class ShipPolicyMng {
        private String bundleKindTxt;
        private String chgDt;
        private int claimShipFee;
        private String defaultYnTxt;
        private int shipFee;
        private String shipMethodTxt;
        private String shipMngTxt;
        private String shipPolicyNm;
        private String shipPolicyNo;
        private String shipTypeTxt;
        private String useYnNm;

        private ShipPolicyMng() {
        }

        public String getBundleKindTxt() {
            return this.bundleKindTxt;
        }

        public void setBundleKindTxt(String bundleKindTxt) {
            this.bundleKindTxt = bundleKindTxt;
        }

        public String getChgDt() {
            return this.chgDt;
        }

        public void setChgDt(String chgDt) {
            this.chgDt = chgDt;
        }

        public int getClaimShipFee() {
            return this.claimShipFee;
        }

        public void setClaimShipFee(int claimShipFee) {
            this.claimShipFee = claimShipFee;
        }

        public String getDefaultYnTxt() {
            return this.defaultYnTxt;
        }

        public void setDefaultYnTxt(String defaultYnTxt) {
            this.defaultYnTxt = defaultYnTxt;
        }

        public int getShipFee() {
            return this.shipFee;
        }

        public void setShipFee(int shipFee) {
            this.shipFee = shipFee;
        }

        public String getShipMethodTxt() {
            return this.shipMethodTxt;
        }

        public void setShipMethodTxt(String shipMethodTxt) {
            this.shipMethodTxt = shipMethodTxt;
        }

        public String getShipMngTxt() {
            return this.shipMngTxt;
        }

        public void setShipMngTxt(String shipMngTxt) {
            this.shipMngTxt = shipMngTxt;
        }

        public String getShipPolicyNm() {
            return this.shipPolicyNm;
        }

        public void setShipPolicyNm(String shipPolicyNm) {
            this.shipPolicyNm = shipPolicyNm;
        }

        public String getShipPolicyNo() {
            return this.shipPolicyNo;
        }

        public void setShipPolicyNo(String shipPolicyNo) {
            this.shipPolicyNo = shipPolicyNo;
        }

        public String getShipTypeTxt() {
            return this.shipTypeTxt;
        }

        public void setShipTypeTxt(String shipTypeTxt) {
            this.shipTypeTxt = shipTypeTxt;
        }

        public String getUseYnNm() {
            return this.useYnNm;
        }

        public void setUseYnNm(String useYnNm) {
            this.useYnNm = useYnNm;
        }
    }

    private static class Shippingpolicy {
        private String resultCode;
        private List<Data> data;
        private String error;

        private Shippingpolicy() {
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public List<Data> getData() {
            return this.data;
        }

        public void setData(List<Data> data2) {
            this.data = data2;
        }
    }

    private static class Upload_file {
        @JsonProperty(value="absolute_path")
        private String absolute_path;
        @JsonProperty(value="directory")
        private String directory;
        @JsonProperty(value="extension")
        private String extension;
        @JsonProperty(value="file_name")
        private String file_name;
        @JsonProperty(value="file_size")
        private String file_size;
        @JsonProperty(value="full_name")
        private String full_name;
        @JsonProperty(value="height")
        private String height;
        @JsonProperty(value="mime_type")
        private String mime_type;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="width")
        private String width;

        private Upload_file() {
        }
    }

    private static class WeMarketProductReg {
        private String productNo;
        private Basic basic;
        private Sale sale;
        private Detail detail;
        private Option option;
        private List<NoticeListMain> noticeList = new ArrayList<NoticeListMain>();
        private Etc etc;
        private BranchList branchList;

        private WeMarketProductReg() {
        }

        public List<NoticeListMain> getNoticeList() {
            return this.noticeList;
        }

        public void setNoticeList(List<NoticeListMain> noticeList) {
            this.noticeList = noticeList;
        }

        public String getProductNo() {
            return this.productNo;
        }

        public void setProductNo(String productNo) {
            this.productNo = productNo;
        }

        public Basic getBasic() {
            return this.basic;
        }

        public void setBasic(Basic basic) {
            this.basic = basic;
        }

        public Sale getSale() {
            return this.sale;
        }

        public void setSale(Sale sale) {
            this.sale = sale;
        }

        public Detail getDetail() {
            return this.detail;
        }

        public void setDetail(Detail detail) {
            this.detail = detail;
        }

        public Option getOption() {
            return this.option;
        }

        public void setOption(Option option2) {
            this.option = option2;
        }

        public Etc getEtc() {
            return this.etc;
        }

        public void setEtc(Etc etc) {
            this.etc = etc;
        }

        public BranchList getBranchList() {
            return this.branchList;
        }

        public void setBranchList(BranchList branchList) {
            this.branchList = branchList;
        }
    }

    private static class fileArr {
        @JsonProperty(value="original_file")
        private String original_file;
        @JsonProperty(value="upload_file")
        private Upload_file upload_file;

        private fileArr() {
        }
    }
}

