/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.ssgmarket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.data.ssgmarket.IShopSSGOrderCommand;
import com.kdjsystem.mlink.yellim.shop.data.ssgmarket.SSGOrderDto;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SSGOrderNewCommand
extends IShopSSGOrderCommand {
    private static final String Host = "https://eapi.ssgadm.com";
    private final OkHttpClient client = new OkHttpClient().newBuilder().build();
    private static IShopOrderCommand instance = new SSGOrderNewCommand();

    public static IShopOrderCommand getIstance() {
        return instance;
    }

    SSGOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<ShopOrderMstDto> ret_list = new ArrayList<ShopOrderMstDto>();
        this.getNewOrder(param, mapper, ret_list);
        this.getBeforeDelivery(param, mapper, ret_list);
        String startDate = param.get(0).getStartDt().substring(0, 8);
        String endDate = param.get(0).getEndDt().substring(0, 8);
        this.deliveryCompleted(param, ret_list, startDate, endDate);
        return ret_list;
    }

    private List<ShopOrderMstDto> deliveryCompleted(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret_list, String startDate, String endDate) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String completionJson = this.setListDeliveryCompletionRequestParams(param);
        MediaType mediaType = MediaType.parse((String)"");
        RequestBody completionBody = RequestBody.create((MediaType)mediaType, (String)completionJson);
        Request completionRequest = new Request.Builder().url(Host.concat("/api/pd/1/listDeliveryEnd.ssg")).method("POST", completionBody).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (Response completionResponse = this.client.newCall(completionRequest).execute();){
                SSGOrderDto.DeliveryCompletionListReponseBody responseShppDirection = (SSGOrderDto.DeliveryCompletionListReponseBody)mapper.readValue(completionResponse.body().string().toString(), SSGOrderDto.DeliveryCompletionListReponseBody.class);
                if (responseShppDirection.result.resultCode.equals("00")) {
                    for (SSGOrderDto.DeliveryCompletionListReponseBody.Result.DeliveryEnd shopDeliveryDto : responseShppDirection.result.deliveryEnds) {
                        String ordNo = shopDeliveryDto.ordNo;
                        if (ShopOrderDao.get().isOrdered(ordNo)) continue;
                        ArrayList<ShopOrderMstDto> update = new ArrayList<ShopOrderMstDto>();
                        ShopOrderMstDto dto = new ShopOrderMstDto();
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setShopid(param.get(0).getShopid());
                        dto.setShop_userid(param.get(0).getShop_userid());
                        dto.setOrder_id(shopDeliveryDto.ordNo);
                        dto.setMall_product_id(shopDeliveryDto.itemId);
                        dto.setOrder_status("410");
                        dto.setP_product_name(shopDeliveryDto.itemNm);
                        dto.setOrder_date(shopDeliveryDto.paymtDt);
                        dto.setProduct_name(shopDeliveryDto.itemNm);
                        dto.setP_sku_value("");
                        dto.setSku_value("");
                        dto.setSale_cnt(shopDeliveryDto.whoutItemQty);
                        dto.setUser_name(shopDeliveryDto.ordpeNm);
                        dto.setUser_email("");
                        dto.setUser_id("");
                        dto.setReceive_name(shopDeliveryDto.rcptpeNm);
                        dto.setDelv_cost("");
                        dto.setTotal_cost(shopDeliveryDto.sellprc);
                        dto.setSale_cost(shopDeliveryDto.sellprc);
                        dto.setReceive_cel("");
                        dto.setReceive_addr("");
                        dto.setReceive_zipcode("");
                        dto.setDelv_msg(shopDeliveryDto.ordMemoCntt);
                        dto.setUser_cel("");
                        dto.setCompayny_goods_cd(shopDeliveryDto.splVenItemId);
                        dto.setMall_won_cost("");
                        dto.setDelivery_method_str2("");
                        dto.setMall_exp_cd(shopDeliveryDto.ordItemSeq);
                        dto.setWon_cost(shopDeliveryDto.sellprc);
                        dto.setResult_code("1");
                        update.add(dto);
                        dto.setResult_code("1");
                        ret_list.add(dto);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return ret_list;
    }

    private String setListDeliveryCompletionRequestParams(List<ShopOrderMstDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            String startDate = param.get(0).getStartDt().substring(0, 8);
            startDate = String.valueOf(startDate.substring(0, 4)) + startDate.substring(4, 6) + startDate.substring(6, 8);
            String endDate = param.get(0).getEndDt().substring(0, 8);
            endDate = String.valueOf(endDate.substring(0, 4)) + endDate.substring(4, 6) + endDate.substring(6, 8);
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            String date = new SimpleDateFormat("yyyyMMdd").format(date_from);
            SSGOrderDto.ReqDeliveryCompletionParameter reqDeliveryCompletionParameter = new SSGOrderDto.ReqDeliveryCompletionParameter();
            reqDeliveryCompletionParameter.requestDeliveryEnd = new SSGOrderDto.ReqDeliveryCompletionParameter.RequestDeliveryEnd();
            reqDeliveryCompletionParameter.requestDeliveryEnd.perdType = "01";
            reqDeliveryCompletionParameter.requestDeliveryEnd.perdStrDts = date;
            reqDeliveryCompletionParameter.requestDeliveryEnd.perdEndDts = endDate;
            reqDeliveryCompletionParameter.requestDeliveryEnd.commType = "";
            reqDeliveryCompletionParameter.requestDeliveryEnd.commValue = "";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqDeliveryCompletionParameter);
        }
        catch (Exception exception) {}
        return json;
    }

    private List<ShopOrderMstDto> getNewOrder(List<ShopOrderMstDto> param, ObjectMapper mapper, List<ShopOrderMstDto> ret_list) throws Exception {
        try {
            String json = this.setRequestParams(param);
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/api/pd/1/listShppDirection.ssg")).method("POST", body).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var9_12 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    SSGOrderDto.ResponseShppDirection responseShppDirection = (SSGOrderDto.ResponseShppDirection)mapper.readValue(response.body().string().toString(), SSGOrderDto.ResponseShppDirection.class);
                    if (responseShppDirection.getResult().getResultCode().equals("00")) {
                        this.getJsonManager(responseShppDirection, param, "100", ret_list);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return ret_list;
    }

    private List<ShopOrderMstDto> getBeforeDelivery(List<ShopOrderMstDto> param, ObjectMapper mapper, List<ShopOrderMstDto> ret_list) throws Exception {
        try {
            String json = this.setlistWarehouseOutRequestParams(param);
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/api/pd/1/listWarehouseOut.ssg")).method("POST", body).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var9_12 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    SSGOrderDto.ResponseListWarehouseOut responseShppDirection = (SSGOrderDto.ResponseListWarehouseOut)mapper.readValue(response.body().string().toString(), SSGOrderDto.ResponseListWarehouseOut.class);
                    if (responseShppDirection.result.resultCode.equals("00")) {
                        this.getJsonManagerBeforeDelivery(responseShppDirection, param, "100", ret_list);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return ret_list;
    }

    private String setRequestParams(List<ShopOrderMstDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            SSGOrderDto.ReqShppDirection reqShppDirection = new SSGOrderDto.ReqShppDirection();
            reqShppDirection.requestShppDirection = new SSGOrderDto.ReqShppDirection.RequestShppDirection();
            reqShppDirection.requestShppDirection.perdType = "02";
            String startDate = param.get(0).getStartDt().substring(0, 8);
            startDate = String.valueOf(startDate.substring(0, 4)) + "-" + startDate.substring(4, 6) + "-" + startDate.substring(6, 8);
            String endDate = param.get(0).getEndDt().substring(0, 8);
            endDate = String.valueOf(endDate.substring(0, 4)) + "-" + endDate.substring(4, 6) + "-" + endDate.substring(6, 8);
            reqShppDirection.requestShppDirection.perdStrDts = startDate;
            reqShppDirection.requestShppDirection.perdEndDts = endDate;
            reqShppDirection.requestShppDirection.shppStatCd = "10";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqShppDirection);
        }
        catch (Exception exception) {}
        return json;
    }

    private String setlistWarehouseOutRequestParams(List<ShopOrderMstDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            String date;
            SSGOrderDto.ReqListWarehouseOut reqListWarehouseOut = new SSGOrderDto.ReqListWarehouseOut();
            reqListWarehouseOut.requestWarehouseOut = new SSGOrderDto.ReqListWarehouseOut.RequestWarehouseOut();
            reqListWarehouseOut.requestWarehouseOut.perdType = "02";
            String endDate = param.get(0).getEndDt().substring(0, 8);
            endDate = String.valueOf(endDate.substring(0, 4)) + "-" + endDate.substring(4, 6) + "-" + endDate.substring(6, 8);
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            reqListWarehouseOut.requestWarehouseOut.perdStrDts = date = new SimpleDateFormat("yyyyMMdd").format(date_from);
            reqListWarehouseOut.requestWarehouseOut.perdEndDts = endDate;
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqListWarehouseOut);
        }
        catch (Exception exception) {}
        return json;
    }

    private List<ShopOrderMstDto> getJsonManager(SSGOrderDto.ResponseShppDirection responseShppDirection, List<ShopOrderMstDto> param, String orderStatus, List<ShopOrderMstDto> ret_list) throws Exception {
        try {
            if (responseShppDirection.getResult().getShppDirections().size() > 0) {
                for (SSGOrderDto.ResponseShppDirection.Result.ShppDirections shppDirections : responseShppDirection.getResult().getShppDirections()) {
                    if (shppDirections.getShppDirection().size() <= 0) continue;
                    for (SSGOrderDto.ResponseShppDirection.Result.ShppDirections.ShppDirection shppDirection : shppDirections.getShppDirection()) {
                        ShopOrderMstDto dto = new ShopOrderMstDto();
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setOrder_status(orderStatus);
                        dto.setShopid(param.get(0).getShopid());
                        dto.setShop_userid(param.get(0).getShop_userid());
                        dto.setCopy_idx(shppDirection.getShppNo());
                        dto.setMall_product_id(shppDirection.getItemId());
                        dto.setOrder_id(shppDirection.getOrdNo());
                        dto.setUser_name(shppDirection.getOrdpeNm());
                        dto.setP_product_name(shppDirection.getItemNm());
                        dto.setP_sku_value(shppDirection.getUitemNm());
                        dto.setSale_cnt(shppDirection.getOrdQty());
                        int price2 = YDMAStringUtil.convertToInt(shppDirection.getSellprc());
                        YDMAStringUtil.convertToInt(shppDirection.getShppcst());
                        int qty = YDMAStringUtil.convertToInt(shppDirection.getOrdQty());
                        dto.setTotal_cost(String.valueOf(price2 * qty));
                        dto.setSale_cost(shppDirection.getSellprc());
                        dto.setOrder_date(shppDirection.getOrdCmplDts());
                        dto.setReceive_name(shppDirection.getRcptpeNm());
                        dto.setReceive_cel(shppDirection.getRcptpeHpno());
                        dto.setReceive_addr(shppDirection.getShpplocAddr());
                        dto.setReceive_zipcode(shppDirection.getShpplocZipcd());
                        dto.setDelv_msg(shppDirection.getOrdMemoCntt());
                        dto.setUser_cel(shppDirection.getOrdpeHpno());
                        dto.setMall_exp_cd(shppDirection.getShppSeq());
                        dto.setCompayny_goods_cd(shppDirection.getSplVenItemId());
                        dto.setWon_cost("0");
                        dto.setMall_won_cost("0");
                        dto.setDelv_cost(shppDirection.getShppcst());
                        dto.setDelivery_method_str2(shppDirection.getShppcstCodYn().equals("Y") ? "\ucc29\ubd88" : "\uc120\ubd88");
                        dto.setDelivery_id("");
                        dto.setInvoice_no("");
                        dto.setProduct_id("");
                        dto.setCompno("");
                        dto.setLabel("");
                        dto.setUser_tel("");
                        dto.setUser_email("");
                        dto.setReceive_tel(shppDirection.getRcptpeTelno());
                        dto.setReceive_email("");
                        dto.setPay_cost("0");
                        dto.setBox_ea("0");
                        dto.setSku_value("");
                        dto.setAuthkey1(param.get(0).getAuthkey1());
                        dto.setResult_code("1");
                        ret_list.add(dto);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("SSG\ub2f7\ucef4 \uc8fc\ubb38 \uc2e0\uaddc \uc218\uc9d1 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return ret_list;
    }

    private List<ShopOrderMstDto> getJsonManagerBeforeDelivery(SSGOrderDto.ResponseListWarehouseOut responseWareHouseOut, List<ShopOrderMstDto> param, String orderStatus, List<ShopOrderMstDto> ret_list) throws Exception {
        try {
            if (responseWareHouseOut.result.warehouseOuts.size() > 0) {
                for (SSGOrderDto.ResponseListWarehouseOut.Result.WarehouseOuts WarehouseOuts2 : responseWareHouseOut.result.warehouseOuts) {
                    if (WarehouseOuts2.warehouseOut.size() <= 0) continue;
                    for (SSGOrderDto.ResponseListWarehouseOut.Result.WarehouseOuts.WarehouseOut warehouseOut : WarehouseOuts2.warehouseOut) {
                        ShopOrderMstDto dto = new ShopOrderMstDto();
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setOrder_status(orderStatus);
                        dto.setShopid(param.get(0).getShopid());
                        dto.setShop_userid(param.get(0).getShop_userid());
                        dto.setCopy_idx(warehouseOut.getShppNo());
                        dto.setMall_product_id(warehouseOut.getItemId());
                        dto.setOrder_id(warehouseOut.getOrdNo());
                        dto.setUser_name(warehouseOut.getOrdpeNm());
                        dto.setP_sku_value(warehouseOut.getUitemNm());
                        dto.setSale_cnt(warehouseOut.getOrdQty());
                        int price2 = YDMAStringUtil.convertToInt(warehouseOut.getSellprc());
                        int qty = YDMAStringUtil.convertToInt(warehouseOut.getOrdQty());
                        YDMAStringUtil.convertToInt(warehouseOut.getShppcst());
                        if (warehouseOut.getOrdItemDivNm().equals("\uad50\ud658\uc8fc\ubb38")) {
                            dto.setP_product_name("<\uad50\ud658\uc8fc\ubb38>" + warehouseOut.getItemNm());
                            dto.setTotal_cost("0");
                            dto.setSale_cost("0");
                        } else {
                            dto.setP_product_name(warehouseOut.getItemNm());
                            dto.setTotal_cost(String.valueOf(price2 * qty));
                            dto.setSale_cost(warehouseOut.getSellprc());
                        }
                        dto.setOrder_date(warehouseOut.getOrdCmplDts());
                        dto.setReceive_name(warehouseOut.getRcptpeNm());
                        dto.setReceive_cel(warehouseOut.getRcptpeHpno());
                        dto.setReceive_addr(warehouseOut.getShpplocAddr());
                        dto.setReceive_zipcode(warehouseOut.getShpplocZipcd());
                        dto.setDelv_msg(warehouseOut.getOrdMemoCntt());
                        dto.setUser_cel(warehouseOut.getOrdpeHpno());
                        dto.setMall_exp_cd(warehouseOut.getShppSeq());
                        dto.setCompayny_goods_cd(warehouseOut.getSplVenItemId());
                        dto.setWon_cost("0");
                        dto.setMall_won_cost("0");
                        dto.setDelv_cost(warehouseOut.getShppcst());
                        dto.setDelivery_method_str2(warehouseOut.getShppcstCodYn().equals("Y") ? "\ucc29\ubd88" : "\uc120\ubd88");
                        dto.setDelivery_id("");
                        dto.setInvoice_no("");
                        dto.setProduct_id("");
                        dto.setCompno("");
                        dto.setLabel("");
                        dto.setUser_tel("");
                        dto.setUser_email("");
                        dto.setReceive_tel(warehouseOut.getRcptpeTelno());
                        dto.setReceive_email("");
                        dto.setPay_cost("0");
                        dto.setBox_ea("0");
                        dto.setSku_value("");
                        dto.setAuthkey1(param.get(0).getAuthkey1());
                        dto.setResult_code("1");
                        ret_list.add(dto);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("SSG\ub2f7\ucef4 \uc8fc\ubb38 \uc2e0\uaddc \uc218\uc9d1 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return ret_list;
    }
}

