/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.data.excel;

import com.kdjsystem.mlink.yellim.data.excel.AbstractDataManager;
import com.kdjsystem.mlink.yellim.data.excel.MyExcelManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class MyXLSXExcelManagerImple
extends AbstractDataManager
implements MyExcelManager {
    private Workbook wkbook;

    @Override
    public Workbook getWkbook() {
        return this.wkbook;
    }

    public MyXLSXExcelManagerImple(String fileURI) throws FileNotFoundException {
        super(fileURI);
    }

    @Override
    public List<List<String>> getSheetContents(int sheetNumber, int startRowNumber) {
        Sheet sheet = this.wkbook.getSheetAt(sheetNumber);
        ArrayList<List<String>> sheetContents = new ArrayList<List<String>>();
        if (sheet == null) {
            return null;
        }
        for (Row row : sheet) {
            if (row.getRowNum() < startRowNumber) continue;
            ArrayList<String> rowContent = new ArrayList<String>();
            for (Cell cell : row) {
                String cellContent = "";
                switch (cell.getCellType()) {
                    case 4: {
                        cellContent = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case 2: {
                        cellContent = cell.getCellFormula();
                        break;
                    }
                    case 1: {
                        cellContent = cell.getRichStringCellValue().getString();
                        break;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                            cellContent = sFormat.format(cell.getDateCellValue());
                            break;
                        }
                        cell.setCellType(1);
                        cellContent = cell.getRichStringCellValue().toString();
                    }
                }
                rowContent.add(cellContent);
            }
            sheetContents.add(rowContent);
        }
        return sheetContents;
    }

    @Override
    public void loadData() throws FileNotFoundException {
        String fileName = this.uriStr;
        FileInputStream inStream = new FileInputStream(fileName);
        try {
            this.wkbook = new XSSFWorkbook((InputStream)inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveData() throws IOException {
        this.fitColumnToContent();
        this.fitSheetToOnePage();
        FileOutputStream fileOut = new FileOutputStream(this.uriStr);
        this.wkbook.write((OutputStream)fileOut);
        fileOut.close();
    }

    @Override
    public List<String> getHeaderRowContents() {
        return null;
    }

    @Override
    public void setHeaderRowContents(Sheet sheet, List<String> headerRowContents) {
        if (this.wkbook == null) {
            this.createWorkbook();
        }
        Row headerRow = sheet.createRow(0);
        CellStyle headerCellStyle = this.getHeaderCellStyle();
        int cellNo = 0;
        for (String cellContent : headerRowContents) {
            Cell cell = headerRow.createCell(cellNo);
            cell.setCellValue(cellContent);
            cell.setCellStyle(headerCellStyle);
            ++cellNo;
        }
    }

    @Override
    public int setSheetContents(int sheetNo, int startRowNo, List<List<String>> sheetContent) {
        Sheet sheet = this.createSheet("sheet-" + sheetNo);
        return this.setSheetContents(sheet, startRowNo, sheetContent);
    }

    private int setSheetContents(Sheet sheet, int startRowNo, List<List<String>> sheetContent) {
        CellStyle headerCellStyle = this.getHeaderCellStyle();
        CellStyle contentCellStyle = this.getContentCellStyle();
        int rowNo = startRowNo;
        for (List<String> rowContents : sheetContent) {
            Row row = sheet.createRow(rowNo);
            int cellNo = 0;
            for (String cellContents : rowContents) {
                Cell cell = row.createCell(cellNo);
                cell.setCellValue(cellContents);
                if (rowNo == 0) {
                    cell.setCellStyle(headerCellStyle);
                } else {
                    cell.setCellStyle(contentCellStyle);
                }
                ++cellNo;
            }
            ++rowNo;
        }
        return rowNo;
    }

    private Sheet createSheet(String sheetName) {
        if (this.wkbook == null) {
            this.createWorkbook();
        }
        Sheet sheet = null;
        try {
            sheet = this.wkbook.createSheet(sheetName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            sheet = this.wkbook.getSheet(sheetName);
        }
        return sheet;
    }

    private void createWorkbook() {
        this.wkbook = new XSSFWorkbook();
    }

    @Override
    public int setSheetContents(String sheetName, int startRowNo, List<List<String>> sheetContent) {
        Sheet sheet = this.createSheet(sheetName);
        return this.setSheetContents(sheet, startRowNo, sheetContent);
    }

    @Override
    public int setSheetContentsWithHeaderRowContents(int sheetNo, List<List<String>> sheetContent) {
        return this.setSheetContents(sheetNo, 0, sheetContent);
    }

    private List<String> getHeader(Sheet sheet, int headerIndex) {
        ArrayList<String> headers = new ArrayList<String>();
        Row row = sheet.getRow(headerIndex);
        int cellNumber = 0;
        while (cellNumber < row.getLastCellNum()) {
            Cell cell = row.getCell(cellNumber, Row.CREATE_NULL_AS_BLANK);
            String cellValue = "";
            switch (cell.getCellType()) {
                case 4: {
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case 2: {
                    cellValue = cell.getCellFormula();
                    break;
                }
                case 1: {
                    cellValue = cell.getRichStringCellValue().getString();
                    break;
                }
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        cellValue = sFormat.format(cell.getDateCellValue());
                        break;
                    }
                    cell.setCellType(1);
                    cellValue = cell.getRichStringCellValue().toString();
                }
            }
            headers.add(cellValue);
            ++cellNumber;
        }
        return headers;
    }

    @Override
    public Map<Integer, HashMap<String, String>> getSheetMapContents(int sheetNumber, int headerRowNumber) {
        Sheet sheet = this.wkbook.getSheetAt(sheetNumber);
        HashMap<Integer, HashMap<String, String>> sheetContents = new HashMap<Integer, HashMap<String, String>>();
        if (sheet == null) {
            return null;
        }
        List<String> headers = this.getHeader(sheet, headerRowNumber);
        Integer cnt = 0;
        for (Row row : sheet) {
            if (row.getRowNum() <= headerRowNumber) continue;
            HashMap<String, String> rowContent = new HashMap<String, String>();
            int cellNumber = 0;
            while (cellNumber < row.getLastCellNum()) {
                Cell cell = row.getCell(cellNumber, Row.CREATE_NULL_AS_BLANK);
                String cellValue = "";
                switch (cell.getCellType()) {
                    case 4: {
                        cellValue = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case 2: {
                        cellValue = cell.getCellFormula();
                        break;
                    }
                    case 1: {
                        cellValue = cell.getRichStringCellValue().getString();
                        break;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                            cellValue = sFormat.format(cell.getDateCellValue());
                            break;
                        }
                        cell.setCellType(1);
                        cellValue = cell.getRichStringCellValue().toString();
                    }
                }
                rowContent.put(headers.get(cellNumber), cellValue);
                ++cellNumber;
            }
            sheetContents.put(cnt, rowContent);
            cnt = cnt + 1;
        }
        return sheetContents;
    }

    @Override
    public int setSheetContents(TableViewer viewer) {
        Sheet sheet;
        if (this.wkbook == null) {
            this.createWorkbook();
        }
        try {
            sheet = this.wkbook.createSheet("sheet-1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            sheet = this.wkbook.getSheet("sheet-1");
        }
        TableItem[] items = viewer.getTable().getItems();
        int col = viewer.getTable().getColumnCount();
        ArrayList<String> columnHeaderNames = new ArrayList<String>();
        int i = 0;
        while (i < col) {
            String columnHeaderName = viewer.getTable().getColumn(i).getText();
            columnHeaderNames.add(columnHeaderName);
            ++i;
        }
        this.setHeaderRowContents(sheet, columnHeaderNames);
        CellStyle contentsCellStyle = this.getContentCellStyle();
        int i2 = 0;
        while (i2 < items.length) {
            TableItem item = items[i2];
            Row row = sheet.createRow((short)i2 + 1);
            int j = 0;
            while (j < col) {
                String b = item.getText(j);
                Cell cell = row.createCell((int)((short)j));
                cell.setCellValue(b);
                cell.setCellStyle(contentsCellStyle);
                ++j;
            }
            ++i2;
        }
        return items.length + 1;
    }

    private CellStyle getHeaderCellStyle() {
        CellStyle cellStyle = this.wkbook.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setFillPattern((short)1);
        Font font = this.wkbook.createFont();
        font.setBoldweight((short)700);
        font.setFontName("\ub9d1\uc740 \uace0\ub515");
        cellStyle.setFont(font);
        return cellStyle;
    }

    private CellStyle getContentCellStyle() {
        CellStyle cellStyle = this.wkbook.createCellStyle();
        cellStyle.setAlignment((short)1);
        cellStyle.setVerticalAlignment((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        cellStyle.setFillPattern((short)1);
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    @Override
    public void setSheetContentsWithHeaderRowContents(String sheetName, List<List<String>> sheetContent) {
        this.setSheetContents(sheetName, 0, sheetContent);
    }

    @Override
    public List<List<String>> getSheetContents(String sheetName, int startRowNo) {
        return this.getSheetContents(this.wkbook.getSheetIndex(sheetName), startRowNo);
    }

    private void fitColumnToContent() {
        int i = 0;
        while (i < this.wkbook.getNumberOfSheets()) {
            Sheet sheet = this.wkbook.getSheetAt(i);
            if (sheet != null) {
                Row firstRow = sheet.getRow(0);
                for (Cell cell : firstRow) {
                    sheet.autoSizeColumn(cell.getColumnIndex());
                }
            }
            ++i;
        }
    }

    private void fitSheetToOnePage() {
        int i = 0;
        while (i < this.wkbook.getNumberOfSheets()) {
            Sheet sheet = this.wkbook.getSheetAt(i);
            PrintSetup ps = sheet.getPrintSetup();
            sheet.setAutobreaks(true);
            ps.setFitHeight((short)1);
            ps.setFitWidth((short)1);
            ps.setLandscape(true);
            ++i;
        }
    }

    @Override
    public List<List<String>> getSheetUploadContents(int sheetNo, int startRowNo) {
        Sheet sheet = this.wkbook.getSheetAt(sheetNo);
        ArrayList<List<String>> sheetContents = new ArrayList<List<String>>();
        if (sheet == null) {
            return null;
        }
        for (Row row : sheet) {
            if (row.getRowNum() < startRowNo) continue;
            ArrayList<String> rowContent = new ArrayList<String>();
            for (Cell cell : row) {
                String cellContent = "";
                switch (cell.getCellType()) {
                    case 4: {
                        cellContent = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case 2: {
                        cellContent = cell.getCellFormula();
                        break;
                    }
                    case 1: {
                        cellContent = cell.getRichStringCellValue().getString();
                        break;
                    }
                    case 0: {
                        BigDecimal val = new BigDecimal(cell.getNumericCellValue());
                        cellContent = String.valueOf(val);
                        break;
                    }
                }
                rowContent.add(cellContent);
            }
            sheetContents.add(rowContent);
        }
        return sheetContents;
    }
}

