/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.helper.JsonHelper;
import com.kdjsystem.mlink.yellim.protocol.KakaoStoreCombinationAttributes;
import com.kdjsystem.mlink.yellim.protocol.KakaoStoreCombinations;
import com.kdjsystem.mlink.yellim.protocol.KakaoStoreName;
import com.kdjsystem.mlink.yellim.protocol.KakaoStoreOption;
import com.kdjsystem.mlink.yellim.protocol.KakaoStoreUpdateOptionRequest;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopKakaoStoreAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.yellim.shop.data.kakaostore.KakaoStoreProductDto;
import com.kdjsystem.mlink.yellim.shop.data.kakaostore.ShopKakaoStoreUtil;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class KakaoStoreProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    private static final String Host = "https://kapi.kakao.com";
    List<ShopOptionDto> options;

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    private void setProductStop(String status2, ShoppingmallDTO shoppingMallDetailDto, ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShopProductSendDto shopProductSendDto) throws Exception {
        String body = "";
        try {
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/product/update").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shoppingMallDetailDto.getAPIKEY()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("productId", shopProductDto.getShopprodno()).data("saleStatus", "OFF").followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = (JsonObject)parser.parse(body);
            if (object.has("productId")) {
                shopProductDto.setResult_code("1");
            } else {
                shopProductDto.setResult_code("-1");
                shopProductDto.setResult_text(body);
            }
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(body);
            if (e.getMessage().equals("HTTP error fetching URL")) {
                throw new Exception("\uc774\ubbf8 \ud310\ub9e4\uc911\uc9c0 \ub41c \uc0c1\ud488\uc785\ub2c8\ub2e4. \uc1fc\ud551\ubab0\uc5d0\uc11c \uc9c1\uc811 \uc0ad\uc81c\ud574\uc8fc\uc138\uc694.");
            }
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + body + e.getMessage());
        }
    }

    private String iSExistsProdNo(String prodNo, Map<String, String> loginCookies) {
        return null;
    }

    private String setProductReg(ProductDTO dto, ShopKakaoStoreAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto, List<String> strImages) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest productRequest = new KakaoStoreProductDto.ProdRequest.ProductRequest();
            this.setProductName(dto, dtllist, productRequest);
            this.setCategory(dto, productRequest, shoppingMallDetailDto, dtllist);
            this.setCert(dto, productRequest);
            this.setModel(dtllist, productRequest);
            this.setDelivery(dto, dtllist, productRequest);
            this.setDiscount(dtllist, productRequest);
            this.setShareDiscount(dtllist, productRequest);
            this.setGroupDiscount(dtllist, productRequest);
            this.setMaxNMinsetting(dtllist, productRequest);
            this.setMinorPurchasable(dto, dtllist, productRequest);
            ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
            resultMarketPrice = this.setSaleCost(dto, dtllist, resultMarketPrice, productRequest);
            this.setOption(dto, dtllist, resultMarketPrice, productRequest);
            this.setImageRemark(dto, dtllist, shoppingMallDetailDto, strImages, productRequest);
            this.setOrigin(dto, dtllist, productRequest);
            this.setNotice(dto, dtllist, productRequest);
            productRequest.productId = dto.getShopprodno();
            productRequest.storeManagementCode = dto.getCompayny_goods_cd();
            productRequest.taxType = dtllist.getTax();
            productRequest.displayStatus = dtllist.getDisplaystatus();
            productRequest.productCondition = dtllist.getProdcondition();
            productRequest.plusFriendSubscriberExclusive = dtllist.getPlusfriend().equals("true");
            productRequest.shoppingHowDisplayable = dtllist.getShophowdisplayable().equals("true");
            productRequest.useSalePeriod = dtllist.getSaleperiod().equals("Y");
            if (dtllist.getSaleperiod().equals("Y")) {
                KakaoStoreProductDto.ProdRequest.ProductRequest.Period salePeriod = new KakaoStoreProductDto.ProdRequest.ProductRequest.Period();
                salePeriod.from = YDMATimeUtil.getCurrentTime();
                salePeriod.to = YDMATimeUtil.getSaleEndDt(dtllist.getSalefrom()).replaceAll("-", "").concat("235959");
                productRequest.salePeriod = salePeriod;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)productRequest);
            YDMAStringUtil.Print(json);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return json;
    }

    private void setProductName(ProductDTO dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        String value = "";
        try {
            switch (dtllist.getProdnmoutput()) {
                case "1": {
                    value = dto.getGoods_nm();
                    break;
                }
                case "2": {
                    value = dto.getModel_nm();
                    break;
                }
                case "3": {
                    value = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "4": {
                    value = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "5": {
                    value = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "6": {
                    value = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    value = dto.getGoods_nm();
                }
            }
            if (!dtllist.getProdnmaddfront().equals("")) {
                value = dtllist.getProdnmaddfront().concat(value);
            }
            if (!dtllist.getProdnmaddback().equals("")) {
                value = value.concat(" ").concat(dtllist.getProdnmaddback());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "L", 69);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            if (dtllist.getProdnmedit().equals("Y")) {
                value = value.replaceAll("[@|#|$|^|{|}|\u00a7|\u203b|\u2606|\u2605|\u266a|\u321c|\u2122|;|\uff06|-|\uff0a|:|`|<|>|\u2191|\u2192|\u2193|\u00b7|\u2103|\u339d|\u3396|\u2665|\u2661|&]", "");
            }
            if (dto.getProdnmlenyn().equals("Y") && value.length() > 138) {
                value = value.substring(0, 130);
            }
            productRequest.name = value;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85\uc744 \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setCategory(ProductDTO dto, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest, ShoppingmallDTO shoppingMallDetailDto, ShopKakaoStoreAdditionalDto dtllist) throws Exception {
        String cateNum = "";
        try {
            if (dtllist.getIsCategory().equals("1")) {
                cateNum = dtllist.getShopcatno();
            } else {
                if (dto.getShopCid() == null || dto.getShopCid().equals("")) {
                    throw new Exception("\ud574\ub2f9\uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \ucf54\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                }
                cateNum = dto.getShopCid();
            }
            productRequest.categoryId = cateNum;
        }
        catch (Exception exception) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setCert(ProductDTO dto, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Cert> certs = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Cert>();
            if (!dto.getCert_type().equals("0")) {
                if (dto.getCert_type().equals("2")) {
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Cert cert = new KakaoStoreProductDto.ProdRequest.ProductRequest.Cert();
                    cert.certType = "DETAIL_REF";
                    certs.add(cert);
                } else {
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Cert cert = new KakaoStoreProductDto.ProdRequest.ProductRequest.Cert();
                    cert.certType = "NOT_APPLICABLE";
                    certs.add(cert);
                }
                productRequest.certs = certs;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setModel(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            String string = productRequest.modelId = dtllist.getModelid().equals("") ? "" : dtllist.getModelid();
            if (dtllist.getModelid().equals("")) {
                productRequest.brand = dtllist.getBrand().equals("") ? "\uae30\ud0c0" : dtllist.getBrand();
                productRequest.manufacturer = dtllist.getManufacturer().equals("") ? "\uae30\ud0c0" : dtllist.getManufacturer();
            } else {
                productRequest.brand = "";
                productRequest.manufacturer = "";
            }
        }
        catch (Exception exception) {
            throw new Exception("\ubaa8\ub378,\ube0c\ub79c\ub4dc,\uc81c\uc870\uc0ac\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setDelivery(ProductDTO dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.Delivery delivery = new KakaoStoreProductDto.ProdRequest.ProductRequest.Delivery();
            delivery.deliveryMethodType = dtllist.getDelivery();
            delivery.bundleGroupAvailable = dtllist.getBundlegroup().equals("true");
            if (dtllist.getDeliverytype().equals("Y")) {
                if (dto.getDelv_type().equals("1")) {
                    delivery.deliveryFeeType = "FREE";
                    delivery.baseFee = new BigDecimal(0);
                    delivery.deliveryFeePaymentType = "COLLECT";
                } else if (dto.getDelv_type().equals("2")) {
                    delivery.deliveryFeeType = "PAID";
                    delivery.baseFee = new BigDecimal(dto.getDelv_cost());
                    delivery.deliveryFeePaymentType = "COLLECT";
                } else if (dto.getDelv_type().equals("3")) {
                    delivery.deliveryFeeType = "QUANTITY_PAID";
                    delivery.baseFee = new BigDecimal(dto.getDelv_cost());
                    delivery.bundleGroupAvailable = false;
                    delivery.repeatQuantity = new Integer(dto.getDelv_qty());
                    delivery.deliveryFeePaymentType = "PAID";
                } else {
                    delivery.deliveryFeeType = "PAID";
                    delivery.baseFee = new BigDecimal(dto.getDelv_cost());
                    delivery.deliveryFeePaymentType = "PAID";
                }
            } else {
                String deliveryFee = "";
                delivery.deliveryFeeType = dtllist.getDeliveryfeetype();
                delivery.deliveryFeePaymentType = dtllist.getDeliverypaymenttype();
                if (dtllist.getDeliveryfeetype().equals("FREE")) {
                    delivery.baseFee = new BigDecimal(0);
                } else if (dtllist.getDeliveryfeetype().equals("PAID")) {
                    if (dtllist.getBasefee().equals("9999")) {
                        if (!dto.getDelv_cost().equals("0")) {
                            deliveryFee = dto.getDelv_cost();
                        } else {
                            PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                            deliveryFee = String.valueOf(systemconf.getDELIVERYCOST());
                        }
                    } else {
                        deliveryFee = dtllist.getBasefee();
                    }
                    delivery.baseFee = new BigDecimal(deliveryFee);
                } else if (dtllist.getDeliveryfeetype().equals("CONDITIONAL_FREE")) {
                    if (dtllist.getBasefee().equals("9999")) {
                        if (!dto.getDelv_cost().equals("0")) {
                            deliveryFee = dto.getDelv_cost();
                        } else {
                            PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                            deliveryFee = String.valueOf(systemconf.getDELIVERYCOST());
                        }
                    } else {
                        deliveryFee = dtllist.getBasefee();
                    }
                    delivery.baseFee = new BigDecimal(deliveryFee);
                    delivery.freeConditionalAmount = new BigDecimal(dtllist.getAddbasefee());
                } else if (dtllist.getDeliveryfeetype().equals("QUANTITY_PAID")) {
                    delivery.bundleGroupAvailable = false;
                    delivery.baseFee = new BigDecimal(dtllist.getBasefee());
                    delivery.repeatQuantity = new Integer(dtllist.getAddbasefee());
                }
            }
            delivery.returnDeliveryFee = new BigDecimal(dtllist.getReturndeliveryfee());
            delivery.exchangeDeliveryFee = new BigDecimal(dtllist.getExchangedeliveryfee());
            delivery.shippingAddressId = new Long(dtllist.getShippingaddrid());
            delivery.returnAddressId = new Long(dtllist.getReturnaddrid());
            delivery.asPhoneNumber = dtllist.getAsphonenumber();
            delivery.asGuideWords = dtllist.getAsguidewords();
            delivery.usePickUpDelivery = false;
            delivery.useQuickDelivery = false;
            delivery.useIsolatedAreaNotice = dtllist.getUseisolatedarea().equals("true");
            if (dtllist.getUseisolatedarea().equals("true")) {
                delivery.isolatedAreaNotice = dtllist.getIsolateareanotice();
            }
            if (dtllist.getJjmt_delv_yn().equals("Y")) {
                delivery.availableIsolatedArea = true;
                if (dtllist.getJejuMountYn().equals("Y")) {
                    delivery.useIsolatedAreaFee = true;
                    delivery.jejuAreaAdditionalFee = new BigDecimal(dtllist.getJejuDeliveryFee().equals("") ? "0" : dtllist.getJejuDeliveryFee());
                    delivery.isolatedAreaAdditionalFee = new BigDecimal(dtllist.getMountDeliveryFee().equals("") ? "0" : dtllist.getMountDeliveryFee());
                }
            } else {
                delivery.availableIsolatedArea = false;
            }
            productRequest.delivery = delivery;
        }
        catch (Exception exception) {
            throw new Exception("\ubc30\uc1a1\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setDiscount(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.Discount discount = new KakaoStoreProductDto.ProdRequest.ProductRequest.Discount();
            discount.useDiscount = dtllist.getDiscount().equals("true");
            discount.useDiscountPeriod = dtllist.getDiscountperiod().equals("true");
            if (dtllist.getDiscount().equals("true")) {
                discount.type = dtllist.getDiscounttype();
                discount.value = new Integer(dtllist.getDiscountval().equals("") ? null : dtllist.getDiscountval());
                if (dtllist.getDiscountperiod().equals("true")) {
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Discount.Period discountPeriod = new KakaoStoreProductDto.ProdRequest.ProductRequest.Discount.Period();
                    discountPeriod.from = YDMATimeUtil.getCurrentTime();
                    discountPeriod.to = YDMATimeUtil.getSaleEndDt(dtllist.getDiscountfrom()).replaceAll("-", "").concat("235959");
                    discount.discountPeriod = discountPeriod;
                }
            }
            productRequest.discount = discount;
        }
        catch (Exception exception) {
            throw new Exception("\uc989\uc2dc\ud560\uc778\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setShareDiscount(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest shareDiscount = new KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest();
            shareDiscount.useShareDiscount = dtllist.getSharediscount().equals("true");
            if (dtllist.getSharediscount().equals("true")) {
                shareDiscount.value = new Long(dtllist.getSharediscountval());
                shareDiscount.slotCount = new Integer(dtllist.getSharedslotcnt());
                shareDiscount.useSalePeriod = true;
                KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest.Period discountPeriod = new KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest.Period();
                discountPeriod.from = YDMATimeUtil.getCurrentTime();
                discountPeriod.to = YDMATimeUtil.getSaleEndDt(dtllist.getSharedfrom()).replaceAll("-", "").concat("235959");
                shareDiscount.discountPeriod = discountPeriod;
            } else {
                shareDiscount.value = new Long("0");
                shareDiscount.useSalePeriod = false;
            }
            productRequest.shareDiscount = shareDiscount;
        }
        catch (Exception exception) {
            throw new Exception("\uc18c\ubb38\ub0b4\uba74\ud560\uc778\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setGroupDiscount(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        String groupfrom = "";
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest groupDiscount = new KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest();
            groupDiscount.useGroupDiscount = dtllist.getGroupdiscount().equals("true");
            if (dtllist.getGroupdiscount().equals("true")) {
                groupDiscount.price = new BigDecimal(dtllist.getGroupprice());
                groupDiscount.useStock = dtllist.getGroupstockyn().equals("true");
                groupDiscount.stock = new Integer(dtllist.getGroupstock().equals("") ? null : dtllist.getGroupstock());
                KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest.Period period = new KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest.Period();
                period.from = YDMATimeUtil.getCurrentTime();
                groupfrom = dtllist.getGroupfrom().equals("24") ? "1" : (dtllist.getGroupfrom().equals("48") ? "2" : "3");
                period.to = YDMATimeUtil.getSaleEndDt(groupfrom).replaceAll("-", "").concat("235959");
                groupDiscount.period = period;
            } else {
                groupDiscount.price = new BigDecimal(0);
                groupDiscount.useStock = false;
            }
            productRequest.groupDiscount = groupDiscount;
        }
        catch (Exception exception) {
            throw new Exception("\ud1a1\ub51c\ud560\uc778\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setMaxNMinsetting(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            productRequest.minPurchaseQuantity = new Integer(dtllist.getMinpurchaseqty().equals("") ? "0" : dtllist.getMinpurchaseqty());
            productRequest.maxPurchaseQuantity = new Integer(dtllist.getMaxpurchaseqty().equals("") ? "0" : dtllist.getMaxpurchaseqty());
            productRequest.maxPurchaseQuantityOfBuyer = 999;
        }
        catch (Exception exception) {
            throw new Exception("\ucd5c\ub300,\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9\uc744 \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setMinorPurchasable(ProductDTO dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            productRequest.minorPurchasable = dtllist.getTypeaddi().equals("Y") ? Boolean.valueOf(dto.getAdult().equals("0")) : Boolean.valueOf(true);
        }
        catch (Exception exception) {
            throw new Exception("\uc131\uc778\uc0c1\ud488\uc5ec\ubd80\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private ResultMarketPrice setSaleCost(ProductDTO dto, ShopKakaoStoreAdditionalDto dtllist, ResultMarketPrice resultMarketPrice, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        int deliveryFee = 0;
        long price_cost = YDMAStringUtil.convertToLong(dto.getGoods_cost());
        try {
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDELIVERYCOST();
                    }
                } else {
                    deliveryFee = Integer.parseInt(dtllist.getExpprc());
                }
                price_cost += (long)deliveryFee;
            }
            Long salePrice = price_cost;
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            productRequest.salePrice = new BigDecimal(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00\ub97c \uacc4\uc0b0\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return resultMarketPrice;
    }

    private void setOption(ProductDTO dto, ShopKakaoStoreAdditionalDto dtllist, ResultMarketPrice resultMarketPrice, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        this.options = this.getProductOptions(dto);
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.Option option2 = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option();
            if (!dto.getChar_1_nm().equals("\ub2e8\ud488")) {
                ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination> combinations = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination>();
                ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute> combinationAttributes = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute>();
                for (ShopOptionDto opt : this.options) {
                    String resultOptionValue;
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name name;
                    if (opt.getName().contains("\ud488\uc808") || opt.getOptspecdes().contains("\ud488\uc808") || opt.getCnt().equals("0")) continue;
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination combination = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination();
                    ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name> names = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name>();
                    List<String> typeLst = Arrays.asList(opt.getName().split(":"));
                    List<String> nameLst = Arrays.asList(opt.getOptspecdes().split(":"));
                    option2.type = "COMBINATION";
                    if (typeLst.size() == 3) {
                        combination.usable = true;
                        combination.price = new BigDecimal(opt.getAmt().equals("") ? "0" : opt.getAmt());
                        combination.stockQuantity = new Integer(opt.getCnt().equals("") ? "0" : opt.getCnt());
                        combination.managedCode = opt.getOptcompanycd();
                        combination.name = names;
                        combinations.add(combination);
                        int i = 0;
                        while (i < typeLst.size()) {
                            name = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name();
                            resultOptionValue = ShopKakaoStoreUtil.addText(dtllist, nameLst.get(i));
                            name.key = typeLst.get(i);
                            name.value = resultOptionValue;
                            names.add(name);
                            ++i;
                        }
                        continue;
                    }
                    if (typeLst.size() == 2) {
                        combination.usable = true;
                        combination.price = new BigDecimal(opt.getAmt().equals("") ? "0" : opt.getAmt());
                        combination.stockQuantity = new Integer(opt.getCnt().equals("") ? "0" : opt.getCnt());
                        combination.managedCode = opt.getOptcompanycd();
                        combination.name = names;
                        combinations.add(combination);
                        int i = 0;
                        while (i < typeLst.size()) {
                            name = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name();
                            resultOptionValue = ShopKakaoStoreUtil.addText(dtllist, nameLst.get(i));
                            name.key = typeLst.get(i);
                            name.value = resultOptionValue;
                            names.add(name);
                            ++i;
                        }
                        continue;
                    }
                    combination.usable = true;
                    combination.price = new BigDecimal(opt.getAmt().equals("") ? "0" : opt.getAmt());
                    combination.stockQuantity = new Integer(opt.getCnt().equals("") ? "0" : opt.getCnt());
                    combination.managedCode = opt.getOptcompanycd();
                    combination.name = names;
                    combinations.add(combination);
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name name2 = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name();
                    String resultOptionValue2 = ShopKakaoStoreUtil.addText(dtllist, nameLst.get(0));
                    name2.key = opt.getName();
                    name2.value = resultOptionValue2;
                    names.add(name2);
                }
                option2.combinations = combinations;
                Function<List, List> getStr = list -> list.stream().map(p -> String.valueOf(p.key) + ":" + p.value).collect(Collectors.toList());
                List options = combinations.stream().flatMap(p -> ((List)getStr.apply(p.name)).stream()).distinct().collect(Collectors.toList());
                int i = 0;
                while (i < options.size()) {
                    String[] strOption = ((String)options.get(i)).split(":");
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute combinationAttribute = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute();
                    combinationAttribute.name = strOption[0];
                    combinationAttribute.value = ShopKakaoStoreUtil.addText(dtllist, strOption[1]);
                    combinationAttributes.add(combinationAttribute);
                    option2.combinationAttributes = combinationAttributes;
                    ++i;
                }
            } else {
                productRequest.stockQuantity = new Integer("999");
                option2.type = "NONE";
            }
            productRequest.option = option2;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc635\uc158\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private int setOptPrice(ShopKakaoStoreAdditionalDto dtllist, Long salePrice, ShopOptionDto shopOptionDto) throws Exception {
        int amt = YDMAStringUtil.convertToInt(shopOptionDto.getAmt());
        try {
            salePrice = salePrice + YDMAStringUtil.convertToLong(shopOptionDto.getAmt());
            int limit_price = YDMAStringUtil.convertToInt(shopOptionDto.getLimit_price());
            ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            amt = Integer.parseInt(optionprice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ud310\ub9e4\uac00\ub97c \uacc4\uc0b0\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return amt;
    }

    private void setImageRemark(ProductDTO dto, ShopKakaoStoreAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto, List<String> strImages, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        String remark = dto.getGoods_remarks();
        String addDetailPlus = "";
        try {
            remark = dtllist.getProddetailfront().concat(remark);
            remark = remark.concat(dtllist.getProddetailback());
            if (dtllist.getRemarktop().equals("Y")) {
                remark = "<h2 style='font-size:16px;font-weight: bold;font-family: Dotum;text-align: center;'>\uc0c1\ud488\uba85 : " + dto.getGoods_nm() + "</h2>".concat(remark);
            }
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = String.valueOf(dtllist.getDetailKeywordL()) + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            productRequest.productDetailDescription = String.valueOf(addDetailPlus) + remark;
            List<String> url = this.getImage(dto, strImages, dtllist, shoppingMallDetailDto);
            KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage productImage = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage();
            productImage.imageRatio = "SQUARE";
            KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.RepresentImage representImage = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.RepresentImage();
            representImage.url = url.get(0);
            if (url.size() > 1) {
                ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage> optionalImages = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage>();
                int i = 1;
                while (i < url.size()) {
                    if (i <= 3) {
                        KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage optionalImage = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage();
                        optionalImage.url = url.get(i);
                        optionalImages.add(optionalImage);
                    }
                    ++i;
                }
                productImage.optionalImages = optionalImages;
            }
            productImage.representImage = representImage;
            productRequest.productImage = productImage;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\uc138\uc124\uba85 \ubc0f \uc774\ubbf8\uc9c0\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String getImagePath(String path, String apikey) throws Exception {
        try {
            Connection.Response response = Jsoup.connect((String)("https://kapi.kakao.com/v1/store/product/image/check/url?url=" + path)).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apikey).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body = response.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            if (jsonObject.get("code").getAsString().equals("ACCEPTED")) {
                this.getImagePath(path, apikey);
            }
            path = jsonObject.get("url").getAsString();
        }
        catch (Exception e) {
            throw new Exception("\uc774\ubbf8\uc9c0 \ubcc0\ud658 \uc624\ub958" + e);
        }
        return path;
    }

    private List<String> getImage(ProductDTO dto, List<String> strImages, ShopKakaoStoreAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        ArrayList<String> decodedString = new ArrayList<String>();
        try {
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/product/image/upload/url").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shoppingMallDetailDto.getAPIKEY()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("url", strImages.get(0)).data("ratio", "SQUARE").followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = response.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            String imgpath = jsonObject.get("url").getAsString();
            imgpath = this.getImagePath(imgpath, shoppingMallDetailDto.getAPIKEY());
            decodedString.add(imgpath);
        }
        catch (Exception e) {
            throw new Exception("\ub300\ud45c \uc774\ubbf8\uc9c0 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
        }
        if (dtllist.getAddimage().equals("Y")) {
            int i = 1;
            while (i < strImages.size()) {
                try {
                    Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/options/image/upload/url").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shoppingMallDetailDto.getAPIKEY()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("url", String.valueOf(strImages.get(i)) + ".jpeg").data("type", "OPTION_REPRESENTATION").followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                    String body = response.body();
                    JsonParser jsonParser = new JsonParser();
                    JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
                    String imgpath = jsonObject.get("url").getAsString();
                    imgpath = this.getImagePath(imgpath, shoppingMallDetailDto.getAPIKEY());
                    decodedString.add(imgpath);
                }
                catch (Exception e) {
                    throw new Exception("\uc635\uc158 \uc774\ubbf8\uc9c0 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e);
                }
                ++i;
            }
        }
        return decodedString;
    }

    private void setOrigin(ProductDTO dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.ProductOriginAreaInfo productOriginAreaInfo = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductOriginAreaInfo();
            if (dtllist.getOriginyn().equals("N")) {
                productOriginAreaInfo.originAreaType = dtllist.getOriginlagid();
                productOriginAreaInfo.originAreaCode = dtllist.getOriginid();
                productOriginAreaInfo.originAreaContent = dtllist.getOrigin();
            } else {
                productOriginAreaInfo.originAreaContent = dto.getOrigin();
                if (dto.getOrigin().contains("\uad6d\ub0b4") || dto.getOrigin().contains("\ub300\ud55c\ubbfc\uad6d")) {
                    productOriginAreaInfo.originAreaCode = "0002190";
                    productOriginAreaInfo.originAreaType = "LOCAL";
                } else if (dto.getOrigin().contains("\ud574\uc678")) {
                    productOriginAreaInfo.originAreaCode = "0200037";
                    productOriginAreaInfo.originAreaType = "IMPORT";
                } else {
                    productOriginAreaInfo.originAreaCode = "03";
                    productOriginAreaInfo.originAreaType = "USER_INPUT";
                }
            }
            productOriginAreaInfo.registerWithOtherOriginArea = false;
            productRequest.productOriginAreaInfo = productOriginAreaInfo;
        }
        catch (Exception exception) {
            throw new Exception("\uc6d0\uc0b0\uc9c0\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setNotice(ProductDTO dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception, JAXBException {
        try {
            String announcementType = ShopProductDao.get().getAttrcd(dto);
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            KakaoStoreProductDto.ProdRequest.ProductRequest.AnnouncementInfo announcementInfo = new KakaoStoreProductDto.ProdRequest.ProductRequest.AnnouncementInfo();
            announcementInfo.announcementType = announcementType;
            List<ShopProdAttrnmDto> kakaoProductAttrList = ShopProductDao.get().getProductKakaoNotice(dto.getProp1_cd(), "shop0273");
            announcementInfo.announcement.put("announcementType", announcementType);
            announcementInfo.announcement.put("ignoreAll", false);
            for (ShopProdAttrnmDto kakaoProduct : kakaoProductAttrList) {
                ShopProdAttrnmDto shopProdAttrnmDtos = dto.getShopProdAttrnmDtos().stream().filter(p -> p.getAttrnm().contains(kakaoProduct.getAttrvl())).findAny().orElse(null);
                if (shopProdAttrnmDtos != null) {
                    if (shopProdAttrnmDtos.getProp_val().equals("")) {
                        shopProdAttrnmDtos.setProp_val("\uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870");
                    }
                    if (dtllist.getCollectapplication().equals("Y")) {
                        if (dtllist.getNoticetitleyn().equals("Y")) {
                            announcementInfo.announcement.put(kakaoProduct.getColseq(), String.valueOf(kakaoProduct.getColseq()) + " : \uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870");
                            continue;
                        }
                        announcementInfo.announcement.put(kakaoProduct.getColseq(), "\uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870");
                        continue;
                    }
                    if (dtllist.getNoticetitleyn().equals("Y")) {
                        announcementInfo.announcement.put(kakaoProduct.getColseq(), String.valueOf(kakaoProduct.getColseq()) + " : " + shopProdAttrnmDtos.getProp_val());
                        continue;
                    }
                    announcementInfo.announcement.put(kakaoProduct.getColseq(), shopProdAttrnmDtos.getProp_val());
                    continue;
                }
                announcementInfo.announcement.put(kakaoProduct.getColseq(), shopProdAttrnmDtos.getProp_val().equals(null) ? "\uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870" : shopProdAttrnmDtos.getProp_val());
            }
            productRequest.announcementInfo = announcementInfo;
        }
        catch (IOException iOException) {
            throw new Exception("\uace0\uc2dc\uc815\ubcf4\ub97c \ubd88\ub7ec\uc624\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void DownLoadImage(ShopKakaoStoreAdditionalDto dtllist, ShoppingmallDTO shoppingMallDetailDto, List<String> strImages) throws Exception, InterruptedException {
        for (String img : strImages) {
            if (dtllist.getImageresize().equals("Y")) {
                ShopCommon.downloadImgFile(img, 600, 600);
                Thread.sleep(1000L);
                continue;
            }
            if (dtllist.getImgThreeOnFour().equals("Y")) {
                ShopCommon.downloadImgFile(img, 450, 600);
                Thread.sleep(1000L);
                continue;
            }
            ShopCommon.downloadImgFile(img);
            Thread.sleep(1000L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        int cnt = this.getMultithreadCount();
        try {
            int slp = 0;
            shopProductSendDto.getWorkMngDto().getWorkcd();
            switch (status2) {
                case "7": 
                case "8": {
                    this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto);
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    shopProductDto.setShopprodno("");
                    slp = 2000 * cnt;
                    Thread.sleep(slp);
                    return true;
                }
                case "0": {
                    Thread.sleep(1000L);
                    ShopKakaoStoreAdditionalDto kakaodtllist = null;
                    kakaodtllist = (ShopKakaoStoreAdditionalDto)shopProductSendDto.getProductAdditionDto();
                    List<Object> strImages = new ArrayList();
                    strImages = kakaodtllist.getChangesize().equals("Y") ? this.getProductImages(shopProductDto, kakaodtllist.getChangeSizeX(), kakaodtllist.getChangeSizeY(), kakaodtllist.getChangeSizeW(), kakaodtllist.getChangeSizeH()) : this.getProductImages(shopProductDto);
                    if (kakaodtllist.getImgThreeOnFour().equals("Y")) {
                        strImages = this.setImgRatioChange(shopProductDto, strImages, shoppingMallDetailDto);
                    }
                    this.DownLoadImage(kakaodtllist, shoppingMallDetailDto, strImages);
                    String json = this.setProductReg(shopProductDto, kakaodtllist, shoppingMallDetailDto, strImages);
                    this.productRegSend(json, shopProductDto, shoppingMallDetailDto.getAPIKEY());
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    slp = 5000 * cnt;
                    Thread.sleep(slp);
                    return true;
                }
                case "6": {
                    this.setProductStop(status2, shoppingMallDetailDto, shopProductDto, dtllist, shopProductSendDto);
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    shopProductDto.setShopprodno("");
                    slp = 2000 * cnt;
                    Thread.sleep(slp);
                }
                default: {
                    return true;
                }
                case "9": 
            }
            return true;
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        String productId;
        block3: {
            productId = "";
            try {
                if (!dto.getShopprodno().equals("")) break block3;
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        Connection.Response response = Jsoup.connect((String)("https://kapi.kakao.com/v1/store/product/store_managed_code?code=" + dto.getCompayny_goods_cd())).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shoppingMallDetailDto.getAPIKEY()).header("channel_ids", "101").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        String body = response.body();
        JsonParser parser = new JsonParser();
        JsonArray jsonArray = (JsonArray)parser.parse(body);
        JsonObject jsonObject = (JsonObject)jsonArray.get(0);
        productId = jsonObject.get("productId").getAsString();
        return !productId.equals("");
    }

    private synchronized void productRegSend(String json, ProductDTO dto, String apiKey) throws Exception {
        String body = "";
        try {
            Connection.Response response = Jsoup.connect((String)Host.concat("/v1/store/product/update")).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apiKey).header("channel_ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("product", json).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = (JsonObject)parser.parse(body);
            dto.setShopprodno(object.get("productId").getAsString());
            if (!dto.getShopprodno().equals("")) {
                dto.setResult_code("1");
            } else {
                dto.setResult_code("-1");
                dto.setResult_text(body);
            }
        }
        catch (Exception e) {
            dto.setResult_code("-1");
            dto.setResult_text(body);
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + body + e.getMessage());
        }
    }

    private int getMultithreadCount() {
        int cnt;
        try {
            cnt = ShopWorkDao.get().getMultiThreadCnt();
            int cores = Runtime.getRuntime().availableProcessors();
            if (cnt != 1 && cnt > cores / 2) {
                cnt = cores / 2;
            }
        }
        catch (Exception exception) {
            return 1;
        }
        return cnt;
    }

    private void setProductStop(ShoppingmallDTO shopInfo, ProductDTO prodInfo) throws Exception {
        String body = "";
        try {
            String json = "{\"productIds\":[" + Integer.parseInt(prodInfo.getShopprodno()) + "]}";
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v2/store/products/delete").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shopInfo.getAPIKEY()).header("channel-ids", "101").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.PUT).execute();
            body = response.body();
            if (body.contains(prodInfo.getShopprodno()) && response.statusCode() == 200) {
                prodInfo.setResult_code("1");
            } else {
                prodInfo.setResult_code("-1");
                prodInfo.setResult_text(body);
            }
        }
        catch (Exception e) {
            prodInfo.setResult_code("-1");
            prodInfo.setResult_text(body);
            if (e.getMessage().equals("HTTP error fetching URL")) {
                prodInfo.setResult_code("1");
            }
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + body + e.getMessage());
        }
    }

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto, String jobType, String logMsg) throws Exception {
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        ProductDTO prodInfo = dto.getPRODUCT();
        String shopInfoLog = String.format("[%s - %s(%s)]", dto.getSHOPINFO().getSHOPNM(), dto.getSHOPINFO().getSHOPPINGID(), dto.getSHOPINFO().getNICKNM1());
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 3000: 
                case 4000: {
                    this.setProductStop(shopInfo, prodInfo);
                    if (!dto.getPRODUCT().getResult_code().equals("1")) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\uc0ad\uc81c", shopInfo, "\uc131\uacf5", jobType, logMsg);
                }
            }
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        try {
            KakaoStoreUpdateOptionRequest request2 = this.getKakaoOptionDatas(dto, dto.getPRODUCT().getOPTIONS());
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString((Object)request2);
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/product/option/update").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + dto.getSHOPINFO().getAPIKEY()).header("channel_ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("productId", dto.getPRODUCT().getShopprodno()).data("option", json).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject data2 = parser.parse(body).getAsJsonObject();
            if (JsonHelper.isExistsJsonObjectKey(data2, "productId")) {
                return new ResultProcessDTO(0, "Success", dto.getPRODUCT().getCompayny_goods_cd());
            }
            return new ResultProcessDTO(-1, "Failed", dto.getPRODUCT().getCompayny_goods_cd());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getCompayny_goods_cd());
        }
    }

    private KakaoStoreUpdateOptionRequest getKakaoOptionDatas(ProductModifyProcessDTO dto, List<ProductOptionDTO> soldoutOptions) {
        try {
            Connection.Response response = Jsoup.connect((String)MallCode.getKakaoProductOptionSearchURL(dto.getPRODUCT().getShopprodno())).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + dto.getSHOPINFO().getAPIKEY()).header("channel_ids", "101").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject data2 = parser.parse(body).getAsJsonObject();
            ArrayList<KakaoStoreCombinations> combinations = new ArrayList<KakaoStoreCombinations>();
            JsonArray combinationsArr = data2.get("combinations").getAsJsonArray();
            int i = 0;
            while (i < combinationsArr.size()) {
                JsonObject combinationsObj = combinationsArr.get(i).getAsJsonObject();
                ArrayList<KakaoStoreName> names = new ArrayList<KakaoStoreName>();
                JsonArray nameArr = combinationsObj.get("name").getAsJsonArray();
                int j = 0;
                while (j < nameArr.size()) {
                    JsonObject nameObj = nameArr.get(j).getAsJsonObject();
                    KakaoStoreName name = new KakaoStoreName();
                    name.setKey(nameObj.get("key").getAsString());
                    name.setValue(nameObj.get("value").getAsString());
                    names.add(name);
                    ++j;
                }
                ProductOptionDTO filter = soldoutOptions.stream().filter(p -> Long.parseLong(p.getSHOPPRODSKU()) == combinationsObj.get("id").getAsLong()).findFirst().orElse(null);
                KakaoStoreCombinations combination = new KakaoStoreCombinations();
                combination.setUsable(combinationsObj.get("usable").getAsBoolean());
                combination.setName(names);
                combination.setPrice(combinationsObj.get("price").getAsBigDecimal());
                combination.setStockQuantity(filter == null ? combinationsObj.get("stockQuantity").getAsInt() : 0);
                combination.setManagedCode(combinationsObj.get("managedCode").getAsString());
                combinations.add(combination);
                ++i;
            }
            ArrayList<KakaoStoreCombinationAttributes> combinationAttributes = new ArrayList<KakaoStoreCombinationAttributes>();
            JsonArray combinationAttributesArr = data2.get("combinationAttributes").getAsJsonArray();
            int i2 = 0;
            while (i2 < combinationAttributesArr.size()) {
                JsonObject combinationAttributesObj = combinationAttributesArr.get(i2).getAsJsonObject();
                KakaoStoreCombinationAttributes combinationAttribute = new KakaoStoreCombinationAttributes();
                combinationAttribute.setName(combinationAttributesObj.get("name").getAsString());
                combinationAttribute.setValue(combinationAttributesObj.get("value").getAsString());
                combinationAttributes.add(combinationAttribute);
                ++i2;
            }
            KakaoStoreOption option2 = new KakaoStoreOption();
            option2.setType(data2.get("type").getAsString());
            option2.setCombinations(combinations);
            option2.setCombinationAttributes(combinationAttributes);
            KakaoStoreUpdateOptionRequest result = new KakaoStoreUpdateOptionRequest();
            result.setOption(option2);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String jobType, String logMsg) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackProd(comment, 50, prodInfo, shoppingmallDTO, jobType, jobResult, logMsg, true);
    }
}

