/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.jcef;

import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cef.browser.CefBrowser;

public class ControlPanel
extends JPanel {
    private final JTextField address_field_;
    private final CefBrowser browser_;

    public ControlPanel(CefBrowser browser) {
        this.browser_ = browser;
        this.setEnabled(this.browser_ != null);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        this.add(Box.createHorizontalStrut(5));
        JLabel addressLabel = new JLabel("Address:");
        addressLabel.setAlignmentX(0.0f);
        this.add(addressLabel);
        this.add(Box.createHorizontalStrut(5));
        this.address_field_ = new JTextField(100);
        this.address_field_.setAlignmentX(0.0f);
        this.address_field_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.browser_.loadURL(ControlPanel.this.getAddress());
            }
        });
        this.address_field_.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                ControlPanel.this.address_field_.requestFocus();
            }
        });
        this.add(this.address_field_);
        this.add(Box.createHorizontalStrut(5));
    }

    public String getAddress() {
        String address = this.address_field_.getText();
        try {
            address = address.replaceAll(" ", "%20");
            URI test = new URI(address);
            if (test.getScheme() != null) {
                return address;
            }
            if (test.getHost() != null && test.getPath() != null) {
                return address;
            }
            String specific = test.getSchemeSpecificPart();
            if (specific.indexOf(46) == -1) {
                throw new URISyntaxException(specific, "No dot inside domain");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            address = "search://" + address;
        }
        return address;
    }

    public void setAddress(CefBrowser browser, String address) {
        if (browser == this.browser_) {
            this.address_field_.setText(address);
        }
    }
}

