/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.dao;

import com.kdjsystem.mlink.yellim.code.DBCode;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDiscontinueOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ProductFolderDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOperatingOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.helper.DataHelper;
import com.kdjsystem.mlink.yellim.helper.StringHelper;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class ProductDAO {
    private static ProductDAO instance = new ProductDAO();

    public static ProductDAO get() {
        return instance;
    }

    public List<ProductDTO> getOperatingProducts(ProductOperatingOptionDTO dto) throws Exception {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try (Connection connection = DBCPInit.getInstance().getConnection();){
            try {
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("WITH CTE_PRODLIST AS (  \r\n");
                query.append("\tSELECT \r\n");
                query.append("\t\t  IFNULL(PRODSEQ,'')           AS PRODSEQ  \r\n");
                query.append("\t\t, IFNULL(COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("\t\t, IFNULL(COMPNO,'') \t\t   AS COMPNO  \r\n");
                query.append("\t  FROM SHOPPRODINFO   \r\n");
                query.append("\t WHERE COMPNO = " + compno + "  \r\n");
                query.append("\t   AND STATUS = '0'  \r\n");
                if (!dto.getDomemall().equals("\uc804\uccb4")) {
                    query.append("\t   AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("                AND NOT EXISTS (SELECT 1 FROM shopprodfolders as F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodinfo.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("                AND EXISTS (SELECT 1 FROM shopprodfolders as F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodinfo.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append(String.format("\t   \t\t\t\t\t\t\t\t               AND FOLDER = '%s')  \r\n", dto.getFolder()));
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t   AND CLASS_CD3 LIKE '" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t   AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t    OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                if (dto.getSearchType().equals("IMG_PATH")) {
                    query.append("\t   AND IMG_PATH = ''  \r\n");
                } else if (!dto.getSearchText().equals("")) {
                    if (dto.getSearchType().equals("GOODS_COST") || dto.getSearchType().equals("DESCRITION") || dto.getSearchType().equals("DELV_COST") || dto.getSearchType().equals("RETURN_DELV_COST")) {
                        query.append(YDMAStringUtil.buildNumericCondition(dto.getSearchType(), dto.getSearchText()));
                    } else if (dto.getSearchType().equals("GOODS_SEARCH_CNT")) {
                        query.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + dto.getSearchText() + "\r\n");
                    } else if (!dto.getSearchType().equals("EXISTS_SHOPPING")) {
                        query.append(YDMAStringUtil.buildLikeClause(dto.getSearchType(), dto.getSearchText()));
                    }
                }
                query.append("\t ORDER BY INSERTDT DESC LIMIT " + dto.getSearchBlock() * dto.getSearchPage() + ", " + dto.getSearchBlock() + "  \r\n");
                query.append(") \r\n");
                query.append("SELECT  \r\n");
                query.append("      INFO.*   \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN STATUS = '0' THEN '\uacf5\uae09\uc911'  \r\n");
                query.append("         WHEN STATUS = '1' THEN '\ud488\uc808'  \r\n");
                query.append("         WHEN STATUS = '2' THEN '\ub2e8\uc885'  \r\n");
                query.append("         WHEN STATUS = '3' THEN '\uc0ad\uc81c'  \r\n");
                query.append("        END) AS STATUS_NM  \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN DELV_TYPE = '1' THEN '\ubb34\ub8cc'  \r\n");
                query.append("         WHEN DELV_TYPE = '2' THEN '\ucc29\ubd88'  \r\n");
                query.append("         WHEN DELV_TYPE = '3' THEN '\uc120\uacb0\uc81c'  \r\n");
                query.append("         WHEN DELV_TYPE = '4' THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'  \r\n");
                query.append("         ELSE ''  \r\n");
                query.append("        END) AS DELV_TYPE_NM   \r\n");
                query.append("  FROM (SELECT  \r\n");
                query.append("  \t\t\tIFNULL(A.PRODSEQ, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS PRODSEQ  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPAYNY_GOODS_CD, '')   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPAYNY_GOODS_CD  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPNO, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPNO  \r\n");
                query.append("  \t\t  , CONCAT(IFNULL(CLASS_CD1, ''), IFNULL(CLASS_CD2, ''), IFNULL(CLASS_CD3, ''), IFNULL(CLASS_CD4, '')) AS CODE  \r\n");
                query.append("  \t\t  , '0' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOPCD  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_USERID  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS IMG  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_KEYWORD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_KEYWORD  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_NM  \r\n");
                query.append("  \t\t  , IFNULL(MODEL_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS MODEL_NM  \r\n");
                query.append("  \t\t  , IFNULL(BRAND_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS BRAND_NM  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_SEARCH, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_SEARCH  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_GUBUN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_GUBUN  \r\n");
                query.append("  \t\t  , IFNULL(SHOP_CID_INFO, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_CID_INFO  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD1  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD2  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD3  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CLASS_CD4  \r\n");
                query.append("  \t\t  , IFNULL(PARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(DPARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DPARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(MAKER, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS MAKER  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ORIGIN  \r\n");
                query.append("  \t\t  , IFNULL(MAKE_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MAKE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SEX, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEX  \r\n");
                query.append("  \t\t  , IFNULL(STATUS, '') \t\t \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS STATUS  \r\n");
                query.append("  \t\t  , IFNULL(DELIV_ABLE_REGION, '')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELIV_ABLE_REGION  \r\n");
                query.append("  \t\t  , IFNULL(TAX_YN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS TAX_YN  \r\n");
                query.append("  \t\t  , IFNULL(CERT, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT  \r\n");
                query.append("  \t\t  , IFNULL(ISLIMIT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISLIMIT  \r\n");
                query.append("  \t\t  , IFNULL(LIMIT_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS LIMIT_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(IS_OVERSEAS, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IS_OVERSEAS  \r\n");
                query.append("  \t\t  , IFNULL(ITYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ITYPE  \r\n");
                query.append("  \t\t  , IFNULL(ADULT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ADULT  \r\n");
                query.append("  \t\t  , IFNULL(ISRETURN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISRETURN  \r\n");
                query.append("  \t\t  , IFNULL(TEXT_OPTION, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS TEXT_OPTION  \r\n");
                query.append("  \t\t  , IFNULL(DELV_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(DELV_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(RETURN_DELV_COST, '0')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS RETURN_DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(BANPUM_AREA, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS BANPUM_AREA  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_COST  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_CONSUMER_PRICE, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_CONSUMER_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_VAL  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_VAL  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMG_PATH  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH1  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH2  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH3  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH4  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH5  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH6  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH7  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH8  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH9, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH9  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH10, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH10  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH11, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH11  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH12, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH12  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_REMARKS, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_REMARKS  \r\n");
                query.append("  \t\t  , IFNULL(CERT_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(CERTNO, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTNO  \r\n");
                query.append("  \t\t  , IFNULL(AVLST_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLST_DM  \r\n");
                query.append("  \t\t  , IFNULL(AVLED_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLED_DM  \r\n");
                query.append("  \t\t  , IFNULL(ISSUEDATE, '') \t       \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ISSUEDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERTDATE, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERT_AGENCY, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT_AGENCY  \r\n");
                query.append("  \t\t  , IFNULL(CERTFIELD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTFIELD  \r\n");
                query.append("  \t\t  , IFNULL(CERTMODEL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTMODEL  \r\n");
                query.append("  \t\t  , IFNULL(CERTNAME, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTNAME  \r\n");
                query.append("  \t\t  , IFNULL(EXEMPTIONTYPE, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXEMPTIONTYPE  \r\n");
                query.append("  \t\t  , IFNULL(MATERIAL, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MATERIAL  \r\n");
                query.append("  \t\t  , IFNULL(STOCK_USE_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS STOCK_USE_YN  \r\n");
                query.append("  \t\t  , IFNULL(OPT_TYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS OPT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(PROP_EDIT_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP_EDIT_YN  \r\n");
                query.append("  \t\t  , IFNULL(PROP1_CD, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP1_CD  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL1  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL2  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL3  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL4  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL5  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL6  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL7  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL8  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL9, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL9  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL10, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL10  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL11, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL11  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL12, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL12  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL13, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL13  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL14, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL14  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL15, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL15  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL16, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL16  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL17, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL17  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL18, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL18  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL19, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL19  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL20, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL20  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL21, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL21  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL22, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL22  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL23, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL23  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL24, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL24  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL25, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL25  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL26, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL26  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL27, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL27  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL28, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL28  \r\n");
                query.append("  \t\t  , IFNULL(PACK_CODE_STR, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PACK_CODE_STR  \r\n");
                query.append("  \t\t  , IFNULL(IMPORTNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMPORTNO  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_COST2  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ORIGIN2  \r\n");
                query.append("  \t\t  , IFNULL(EXPIRE_DM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXPIRE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SUPPLY_SAVE_YN, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SUPPLY_SAVE_YN  \r\n");
                query.append("  \t\t  , IFNULL(DESCRITION, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DESCRITION  \r\n");
                query.append("  \t\t  , IFNULL(SHOPPRODNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPPRODNO  \r\n");
                query.append("  \t\t  , IFNULL(INSERTDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTDT  \r\n");
                query.append("  \t\t  , IFNULL(INSERTID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTID  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYDT  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYID  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SEQ  \r\n");
                query.append("  \t\t  , IFNULL(SHOPSENDSTATUS, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSTATS  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPSEQ  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SALEENDDT  \r\n");
                query.append("  \t\t  , IFNULL(DELV_QTY, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_QTY  \r\n");
                query.append("  \t\t  , IFNULL(GMCATEGNM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GMCATEGNM  \r\n");
                query.append("  \t\t  , IFNULL(SHOPMODIFYCONTENT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPMODIFYCONTENT  \r\n");
                query.append("  \t\t  , IFNULL(SELFMOD_NO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SELFMOD_NO  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSEQ  \r\n");
                query.append("  \t\tFROM SHOPPRODINFO AS A  \r\n");
                query.append("  \tINNER JOIN (SELECT * FROM CTE_PRODLIST) AS B ON A.PRODSEQ = B.PRODSEQ AND A.COMPNO = B.COMPNO \r\n");
                query.append(" ) AS INFO  ORDER BY INSERTDT desc\r\n");
                YDMAStringUtil.Print(query.toString());
                List items = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
                IntStream.range(0, result.size()).forEach(i -> ((ProductDTO)items.get(i)).setRowno(String.valueOf(i + 1)));
                result = items;
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return result;
    }

    public List<ProductDTO> getDiscontinueProductInfo(ProductDiscontinueOptionDTO dto) throws Exception {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("WITH CTE_PRODLIST AS (  \r\n");
                query.append("\tSELECT \r\n");
                query.append("\t\t  IFNULL(PRODSEQ,'')           AS PRODSEQ  \r\n");
                query.append("\t\t, IFNULL(COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("\t\t, IFNULL(COMPNO,'') \t\t   AS COMPNO  \r\n");
                query.append("\t  FROM SHOPPRODINFO   \r\n");
                query.append("\t WHERE COMPNO = " + compno + "  \r\n");
                query.append("\t   AND STATUS IN (1, 2, 3)  \r\n");
                if (!dto.getDomemall().equals("\uc804\uccb4")) {
                    query.append("\t   AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("                AND NOT EXISTS (SELECT 1 FROM shopprodfolders as F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodinfo.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("                AND EXISTS (SELECT 1 FROM shopprodfolders as F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodinfo.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append(String.format("\t   \t\t\t\t\t\t\t\t               AND FOLDER = '%s')  \r\n", dto.getFolder()));
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t   AND CLASS_CD3 LIKE '" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t   AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t    OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                if (dto.getSearchType().equals("IMG_PATH")) {
                    query.append("\t   AND IMG_PATH = ''  \r\n");
                } else if (!dto.getSearchText().equals("")) {
                    if (dto.getSearchType().equals("GOODS_COST") || dto.getSearchType().equals("DESCRITION") || dto.getSearchType().equals("DELV_COST") || dto.getSearchType().equals("RETURN_DELV_COST")) {
                        query.append(YDMAStringUtil.buildNumericCondition(dto.getSearchType(), dto.getSearchText()));
                    } else if (dto.getSearchType().equals("GOODS_SEARCH_CNT")) {
                        query.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + dto.getSearchText() + "\r\n");
                    } else if (!dto.getSearchType().equals("EXISTS_SHOPPING")) {
                        query.append(YDMAStringUtil.buildLikeClause(dto.getSearchType(), dto.getSearchText()));
                    }
                }
                query.append("\t ORDER BY MODIFYDT DESC LIMIT " + dto.getSearchBlock() * dto.getSearchPage() + ", " + dto.getSearchBlock() + "  \r\n");
                query.append(") \r\n");
                query.append("SELECT  \r\n");
                query.append("      INFO.*   \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN STATUS = '0' THEN '\uacf5\uae09\uc911'  \r\n");
                query.append("         WHEN STATUS = '1' THEN '\ud488\uc808'  \r\n");
                query.append("         WHEN STATUS = '2' THEN '\ub2e8\uc885'  \r\n");
                query.append("         WHEN STATUS = '3' THEN '\uc0ad\uc81c'  \r\n");
                query.append("        END) AS STATUS_NM  \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN DELV_TYPE = '1' THEN '\ubb34\ub8cc'  \r\n");
                query.append("         WHEN DELV_TYPE = '2' THEN '\ucc29\ubd88'  \r\n");
                query.append("         WHEN DELV_TYPE = '3' THEN '\uc120\uacb0\uc81c'  \r\n");
                query.append("         WHEN DELV_TYPE = '4' THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'  \r\n");
                query.append("         ELSE ''  \r\n");
                query.append("        END) AS DELV_TYPE_NM   \r\n");
                query.append("  FROM (SELECT  \r\n");
                query.append("  \t\t\tIFNULL(A.PRODSEQ, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS PRODSEQ  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPAYNY_GOODS_CD, '')   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPAYNY_GOODS_CD  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPNO, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPNO  \r\n");
                query.append("  \t\t  , CONCAT(IFNULL(CLASS_CD1, ''), IFNULL(CLASS_CD2, ''), IFNULL(CLASS_CD3, ''), IFNULL(CLASS_CD4, '')) AS CODE  \r\n");
                query.append("  \t\t  , '0' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOPCD  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_USERID  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS IMG  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_KEYWORD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_KEYWORD  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_NM  \r\n");
                query.append("  \t\t  , IFNULL(MODEL_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS MODEL_NM  \r\n");
                query.append("  \t\t  , IFNULL(BRAND_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS BRAND_NM  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_SEARCH, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_SEARCH  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_GUBUN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_GUBUN  \r\n");
                query.append("  \t\t  , IFNULL(SHOP_CID_INFO, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_CID_INFO  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD1  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD2  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD3  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CLASS_CD4  \r\n");
                query.append("  \t\t  , IFNULL(PARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(DPARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DPARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(MAKER, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS MAKER  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ORIGIN  \r\n");
                query.append("  \t\t  , IFNULL(MAKE_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MAKE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SEX, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEX  \r\n");
                query.append("  \t\t  , IFNULL(STATUS, '') \t\t \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS STATUS  \r\n");
                query.append("  \t\t  , IFNULL(DELIV_ABLE_REGION, '')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELIV_ABLE_REGION  \r\n");
                query.append("  \t\t  , IFNULL(TAX_YN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS TAX_YN  \r\n");
                query.append("  \t\t  , IFNULL(CERT, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT  \r\n");
                query.append("  \t\t  , IFNULL(ISLIMIT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISLIMIT  \r\n");
                query.append("  \t\t  , IFNULL(LIMIT_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS LIMIT_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(IS_OVERSEAS, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IS_OVERSEAS  \r\n");
                query.append("  \t\t  , IFNULL(ITYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ITYPE  \r\n");
                query.append("  \t\t  , IFNULL(ADULT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ADULT  \r\n");
                query.append("  \t\t  , IFNULL(ISRETURN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISRETURN  \r\n");
                query.append("  \t\t  , IFNULL(TEXT_OPTION, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS TEXT_OPTION  \r\n");
                query.append("  \t\t  , IFNULL(DELV_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(DELV_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(RETURN_DELV_COST, '0')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS RETURN_DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(BANPUM_AREA, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS BANPUM_AREA  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_COST  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_CONSUMER_PRICE, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_CONSUMER_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_VAL  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_VAL  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMG_PATH  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH1  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH2  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH3  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH4  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH5  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH6  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH7  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH8  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH9, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH9  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH10, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH10  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH11, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH11  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH12, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH12  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_REMARKS, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_REMARKS  \r\n");
                query.append("  \t\t  , IFNULL(CERT_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(CERTNO, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTNO  \r\n");
                query.append("  \t\t  , IFNULL(AVLST_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLST_DM  \r\n");
                query.append("  \t\t  , IFNULL(AVLED_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLED_DM  \r\n");
                query.append("  \t\t  , IFNULL(ISSUEDATE, '') \t       \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ISSUEDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERTDATE, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERT_AGENCY, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT_AGENCY  \r\n");
                query.append("  \t\t  , IFNULL(CERTFIELD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTFIELD  \r\n");
                query.append("  \t\t  , IFNULL(CERTMODEL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTMODEL  \r\n");
                query.append("  \t\t  , IFNULL(CERTNAME, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTNAME  \r\n");
                query.append("  \t\t  , IFNULL(EXEMPTIONTYPE, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXEMPTIONTYPE  \r\n");
                query.append("  \t\t  , IFNULL(MATERIAL, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MATERIAL  \r\n");
                query.append("  \t\t  , IFNULL(STOCK_USE_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS STOCK_USE_YN  \r\n");
                query.append("  \t\t  , IFNULL(OPT_TYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS OPT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(PROP_EDIT_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP_EDIT_YN  \r\n");
                query.append("  \t\t  , IFNULL(PROP1_CD, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP1_CD  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL1  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL2  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL3  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL4  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL5  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL6  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL7  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL8  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL9, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL9  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL10, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL10  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL11, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL11  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL12, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL12  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL13, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL13  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL14, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL14  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL15, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL15  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL16, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL16  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL17, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL17  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL18, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL18  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL19, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL19  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL20, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL20  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL21, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL21  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL22, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL22  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL23, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL23  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL24, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL24  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL25, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL25  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL26, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL26  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL27, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL27  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL28, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL28  \r\n");
                query.append("  \t\t  , IFNULL(PACK_CODE_STR, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PACK_CODE_STR  \r\n");
                query.append("  \t\t  , IFNULL(IMPORTNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMPORTNO  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_COST2  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ORIGIN2  \r\n");
                query.append("  \t\t  , IFNULL(EXPIRE_DM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXPIRE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SUPPLY_SAVE_YN, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SUPPLY_SAVE_YN  \r\n");
                query.append("  \t\t  , IFNULL(DESCRITION, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DESCRITION  \r\n");
                query.append("  \t\t  , IFNULL(SHOPPRODNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPPRODNO  \r\n");
                query.append("  \t\t  , IFNULL(INSERTDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTDT  \r\n");
                query.append("  \t\t  , IFNULL(INSERTID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTID  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYDT  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYID  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SEQ  \r\n");
                query.append("  \t\t  , IFNULL(SHOPSENDSTATUS, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSTATS  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPSEQ  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SALEENDDT  \r\n");
                query.append("  \t\t  , IFNULL(DELV_QTY, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_QTY  \r\n");
                query.append("  \t\t  , IFNULL(GMCATEGNM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GMCATEGNM  \r\n");
                query.append("  \t\t  , IFNULL(SHOPMODIFYCONTENT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPMODIFYCONTENT  \r\n");
                query.append("  \t\t  , IFNULL(SELFMOD_NO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SELFMOD_NO  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSEQ  \r\n");
                query.append("  \t\tFROM SHOPPRODINFO AS A  \r\n");
                query.append("  \tINNER JOIN (SELECT * FROM CTE_PRODLIST) AS B ON A.PRODSEQ = B.PRODSEQ AND A.COMPNO = B.COMPNO) AS INFO  \r\n");
                YDMAStringUtil.Print(query.toString());
                List items = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
                IntStream.range(0, result.size()).forEach(i -> ((ProductDTO)items.get(i)).setRowno(String.valueOf(i + 1)));
                result = items;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> getOperatingProductsIn(ProductOperatingOptionDTO dto, String commandID, String shopCode, String shopSeq, boolean next) throws Exception {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT * FROM ( \r\n");
                query.append("  WITH CTE_PRODLIST AS (  \r\n");
                query.append("      SELECT IFNULL(SENDSEQ, '') AS SENDSEQ  \r\n");
                query.append("\t\t  FROM SHOPPRODIN   \r\n");
                query.append("\t     WHERE COMPNO = " + compno + "  \r\n");
                query.append("         AND STATUS = 0  \r\n");
                if (commandID.equals("S")) {
                    query.append("\t       AND SHOPCD = '" + shopCode + "'  \r\n");
                } else if (commandID.equals("U")) {
                    query.append("\t       AND SHOPCD = '" + shopCode + "'  \r\n");
                    query.append("\t       AND SHOPSEQ = " + shopSeq + "  \r\n");
                }
                if (!dto.getDomemall().equals("\uc804\uccb4")) {
                    query.append("\t       AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("                AND NOT EXISTS (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("                AND EXISTS (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append(String.format("\t   \t\t\t\t\t\t\t\t               AND FOLDER = '%s')  \r\n", dto.getFolder()));
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t       AND CLASS_CD3 LIKE '" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t       AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t        OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                if (dto.getSearchType().equals("IMG_PATH")) {
                    query.append("\t   AND IMG_PATH = ''  \r\n");
                } else if (!dto.getSearchText().equals("")) {
                    if (dto.getSearchType().equals("GOODS_COST") || dto.getSearchType().equals("DESCRITION") || dto.getSearchType().equals("DELV_COST") || dto.getSearchType().equals("RETURN_DELV_COST")) {
                        query.append(YDMAStringUtil.buildNumericCondition(dto.getSearchType(), dto.getSearchText()));
                    } else if (dto.getSearchType().equals("GOODS_SEARCH_CNT")) {
                        query.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + dto.getSearchText() + "\r\n");
                    } else if (!dto.getSearchType().equals("EXISTS_SHOPPING")) {
                        query.append(YDMAStringUtil.buildLikeClause(dto.getSearchType(), dto.getSearchText()));
                    }
                }
                if (next) {
                    query.append("\t ORDER BY INSERTDT DESC LIMIT " + dto.getSearchBlock() * (dto.getSearchPage() - 1) + ", " + dto.getSearchBlock() + "  \r\n");
                } else {
                    query.append("\t ORDER BY INSERTDT DESC LIMIT " + dto.getSearchBlock() * dto.getSearchPage() + ", " + dto.getSearchBlock() + "  \r\n");
                }
                query.append(") \r\n");
                query.append("SELECT  \r\n");
                query.append("      INFO.*   \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN STATUS = '0' THEN '\uacf5\uae09\uc911'  \r\n");
                query.append("         WHEN STATUS = '1' THEN '\ud488\uc808'  \r\n");
                query.append("         WHEN STATUS = '2' THEN '\ub2e8\uc885'  \r\n");
                query.append("         WHEN STATUS = '3' THEN '\uc0ad\uc81c'  \r\n");
                query.append("        END) AS STATUS_NM  \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN DELV_TYPE = '1' THEN '\ubb34\ub8cc'  \r\n");
                query.append("         WHEN DELV_TYPE = '2' THEN '\ucc29\ubd88'  \r\n");
                query.append("         WHEN DELV_TYPE = '3' THEN '\uc120\uacb0\uc81c'  \r\n");
                query.append("         WHEN DELV_TYPE = '4' THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'  \r\n");
                query.append("         ELSE ''  \r\n");
                query.append("        END) AS DELV_TYPE_NM   \r\n");
                query.append("  FROM (SELECT  \r\n");
                query.append("  \t\t\tIFNULL(A.PRODSEQ, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS PRODSEQ  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPAYNY_GOODS_CD, '')   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPAYNY_GOODS_CD  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPNO, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPNO  \r\n");
                query.append("  \t\t  , CONCAT(IFNULL(CLASS_CD1, ''), IFNULL(CLASS_CD2, ''), IFNULL(CLASS_CD3, ''), IFNULL(CLASS_CD4, '')) AS CODE  \r\n");
                query.append("  \t\t  , IFNULL(SHOPCD, '') \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t   AS SHOPCD  \r\n");
                query.append("  \t\t  , IFNULL(SHOP_USERID,'' ) \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t   AS SHOP_USERID  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS IMG  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_KEYWORD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_KEYWORD  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_NM  \r\n");
                query.append("  \t\t  , IFNULL(MODEL_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS MODEL_NM  \r\n");
                query.append("  \t\t  , IFNULL(BRAND_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS BRAND_NM  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_SEARCH, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_SEARCH  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_GUBUN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_GUBUN  \r\n");
                query.append("  \t\t  , IFNULL(SHOP_CID_INFO, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_CID_INFO  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD1  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD2  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD3  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CLASS_CD4  \r\n");
                query.append("  \t\t  , IFNULL(PARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(DPARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DPARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(MAKER, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS MAKER  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ORIGIN  \r\n");
                query.append("  \t\t  , IFNULL(MAKE_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MAKE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SEX, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEX  \r\n");
                query.append("  \t\t  , IFNULL(STATUS, '') \t\t \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS STATUS  \r\n");
                query.append("  \t\t  , IFNULL(DELIV_ABLE_REGION, '')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELIV_ABLE_REGION  \r\n");
                query.append("  \t\t  , IFNULL(TAX_YN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS TAX_YN  \r\n");
                query.append("  \t\t  , IFNULL(CERT, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT  \r\n");
                query.append("  \t\t  , IFNULL(ISLIMIT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISLIMIT  \r\n");
                query.append("  \t\t  , IFNULL(LIMIT_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS LIMIT_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(IS_OVERSEAS, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IS_OVERSEAS  \r\n");
                query.append("  \t\t  , IFNULL(ITYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ITYPE  \r\n");
                query.append("  \t\t  , IFNULL(ADULT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ADULT  \r\n");
                query.append("  \t\t  , IFNULL(ISRETURN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISRETURN  \r\n");
                query.append("  \t\t  , IFNULL(TEXT_OPTION, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS TEXT_OPTION  \r\n");
                query.append("  \t\t  , IFNULL(DELV_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(DELV_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(RETURN_DELV_COST, '0')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS RETURN_DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(BANPUM_AREA, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS BANPUM_AREA  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_COST  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_CONSUMER_PRICE, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_CONSUMER_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_VAL  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_VAL  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMG_PATH  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH1  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH2  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH3  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH4  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH5  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH6  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH7  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH8  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH9, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH9  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH10, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH10  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH11, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH11  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH12, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH12  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_REMARKS, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_REMARKS  \r\n");
                query.append("  \t\t  , IFNULL(CERT_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(CERTNO, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTNO  \r\n");
                query.append("  \t\t  , IFNULL(AVLST_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLST_DM  \r\n");
                query.append("  \t\t  , IFNULL(AVLED_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLED_DM  \r\n");
                query.append("  \t\t  , IFNULL(ISSUEDATE, '') \t       \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ISSUEDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERTDATE, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERT_AGENCY, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT_AGENCY  \r\n");
                query.append("  \t\t  , IFNULL(CERTFIELD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTFIELD  \r\n");
                query.append("  \t\t  , IFNULL(CERTMODEL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTMODEL  \r\n");
                query.append("  \t\t  , IFNULL(CERTNAME, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTNAME  \r\n");
                query.append("  \t\t  , IFNULL(EXEMPTIONTYPE, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXEMPTIONTYPE  \r\n");
                query.append("  \t\t  , IFNULL(MATERIAL, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MATERIAL  \r\n");
                query.append("  \t\t  , IFNULL(STOCK_USE_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS STOCK_USE_YN  \r\n");
                query.append("  \t\t  , IFNULL(OPT_TYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS OPT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(PROP_EDIT_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP_EDIT_YN  \r\n");
                query.append("  \t\t  , IFNULL(PROP1_CD, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP1_CD  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL1  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL2  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL3  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL4  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL5  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL6  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL7  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL8  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL9, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL9  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL10, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL10  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL11, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL11  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL12, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL12  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL13, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL13  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL14, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL14  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL15, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL15  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL16, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL16  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL17, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL17  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL18, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL18  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL19, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL19  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL20, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL20  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL21, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL21  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL22, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL22  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL23, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL23  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL24, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL24  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL25, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL25  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL26, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL26  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL27, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL27  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL28, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL28  \r\n");
                query.append("  \t\t  , IFNULL(PACK_CODE_STR, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PACK_CODE_STR  \r\n");
                query.append("  \t\t  , IFNULL(IMPORTNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMPORTNO  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_COST2  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ORIGIN2  \r\n");
                query.append("  \t\t  , IFNULL(EXPIRE_DM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXPIRE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SUPPLY_SAVE_YN, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SUPPLY_SAVE_YN  \r\n");
                query.append("  \t\t  , IFNULL(DESCRITION, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DESCRITION  \r\n");
                query.append("  \t\t  , IFNULL(SHOPPRODNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPPRODNO  \r\n");
                query.append("  \t\t  , IFNULL(INSERTDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTDT  \r\n");
                query.append("  \t\t  , IFNULL(INSERTID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTID  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYDT  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYID  \r\n");
                query.append("  \t\t  , IFNULL(SEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEQ  \r\n");
                query.append("  \t\t  , IFNULL(SHOPSENDSTATUS, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSTATS  \r\n");
                query.append("  \t\t  , IFNULL(SHOPSEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SHOPSEQ  \r\n");
                query.append("  \t\t  , IFNULL(SALEENDDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SALEENDDT  \r\n");
                query.append("  \t\t  , IFNULL(DELV_QTY, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_QTY  \r\n");
                query.append("  \t\t  , IFNULL(GMCATEGNM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GMCATEGNM  \r\n");
                query.append("  \t\t  , IFNULL(SHOPMODIFYCONTENT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPMODIFYCONTENT  \r\n");
                query.append("  \t\t  , IFNULL(SELFMOD_NO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SELFMOD_NO  \r\n");
                query.append("  \t\t  , IFNULL(A.SENDSEQ,'') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SENDSEQ  \r\n");
                query.append("  \t\tFROM SHOPPRODIN AS A  \r\n");
                query.append("  \t   INNER JOIN (SELECT SENDSEQ FROM CTE_PRODLIST) AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append("  \t                ) AS INFO ORDER BY INSERTDT DESC) AS AA  \r\n");
                YDMAStringUtil.Print(query.toString());
                List items = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
                IntStream.range(0, result.size()).forEach(i -> ((ProductDTO)items.get(i)).setRowno(String.valueOf(i + 1)));
                result = items;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> getDiscontinueProductsIn(String shopCode, String shopSeq, int kind) throws Exception {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT * FROM ( \r\n");
                query.append("  WITH CTE_PRODLIST AS (  \r\n");
                query.append("      SELECT SENDSEQ AS SENDSEQ  \r\n");
                query.append("\t\t  FROM SHOPPRODIN   \r\n");
                query.append("\t     WHERE COMPNO = " + compno + "  \r\n");
                query.append("\t       AND SHOPCD = '" + shopCode + "'  \r\n");
                query.append("\t       AND SHOPSEQ = " + shopSeq + "  \r\n");
                if (kind == 1) {
                    query.append("         AND STATUS IN (1, 2, 3)  \r\n");
                }
                if (kind == 2) {
                    query.append("          AND SHOPSENDSTATUS = 7000  \r\n");
                }
                if (kind == 3) {
                    query.append("          AND SHOPSENDSTATUS = 6000  \r\n");
                }
                query.append("\t       AND NOT EXISTS (SELECT 1 FROM SHOPPRODFOLDERS AS F  \r\n");
                query.append("                                        WHERE COMPNO = " + compno + "  \r\n");
                query.append("\t   \t\t\t\t\t\t\t\t        AND SHOPPRODIN.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                query.append("                                          AND FOLDER LIKE 'NOT_%')  \r\n");
                query.append(") \r\n");
                query.append("SELECT  \r\n");
                query.append("      INFO.*   \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN STATUS = '0' THEN '\uacf5\uae09\uc911'  \r\n");
                query.append("         WHEN STATUS = '1' THEN '\ud488\uc808'  \r\n");
                query.append("         WHEN STATUS = '2' THEN '\ub2e8\uc885'  \r\n");
                query.append("         WHEN STATUS = '3' THEN '\uc0ad\uc81c'  \r\n");
                query.append("        END) AS STATUS_NM  \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN DELV_TYPE = '1' THEN '\ubb34\ub8cc'  \r\n");
                query.append("         WHEN DELV_TYPE = '2' THEN '\ucc29\ubd88'  \r\n");
                query.append("         WHEN DELV_TYPE = '3' THEN '\uc120\uacb0\uc81c'  \r\n");
                query.append("         WHEN DELV_TYPE = '4' THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'  \r\n");
                query.append("         ELSE ''  \r\n");
                query.append("        END) AS DELV_TYPE_NM   \r\n");
                query.append("  FROM (SELECT  \r\n");
                query.append("  \t\t\tIFNULL(A.PRODSEQ, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS PRODSEQ  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPAYNY_GOODS_CD, '')   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPAYNY_GOODS_CD  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPNO, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPNO  \r\n");
                query.append("  \t\t  , CONCAT(IFNULL(CLASS_CD1, ''), IFNULL(CLASS_CD2, ''), IFNULL(CLASS_CD3, ''), IFNULL(CLASS_CD4, '')) AS CODE  \r\n");
                query.append("  \t\t  , IFNULL(SHOPCD, '') \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t   AS SHOPCD  \r\n");
                query.append("  \t\t  , IFNULL(SHOP_USERID,'' ) \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t   AS SHOP_USERID  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS IMG  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_KEYWORD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_KEYWORD  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_NM  \r\n");
                query.append("  \t\t  , IFNULL(MODEL_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS MODEL_NM  \r\n");
                query.append("  \t\t  , IFNULL(BRAND_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS BRAND_NM  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_SEARCH, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_SEARCH  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_GUBUN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_GUBUN  \r\n");
                query.append("  \t\t  , IFNULL(SHOP_CID_INFO, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_CID_INFO  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD1  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD2  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD3  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CLASS_CD4  \r\n");
                query.append("  \t\t  , IFNULL(PARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(DPARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DPARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(MAKER, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS MAKER  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ORIGIN  \r\n");
                query.append("  \t\t  , IFNULL(MAKE_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MAKE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SEX, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEX  \r\n");
                query.append("  \t\t  , IFNULL(STATUS, '') \t\t \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS STATUS  \r\n");
                query.append("  \t\t  , IFNULL(DELIV_ABLE_REGION, '')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELIV_ABLE_REGION  \r\n");
                query.append("  \t\t  , IFNULL(TAX_YN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS TAX_YN  \r\n");
                query.append("  \t\t  , IFNULL(CERT, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT  \r\n");
                query.append("  \t\t  , IFNULL(ISLIMIT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISLIMIT  \r\n");
                query.append("  \t\t  , IFNULL(LIMIT_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS LIMIT_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(IS_OVERSEAS, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IS_OVERSEAS  \r\n");
                query.append("  \t\t  , IFNULL(ITYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ITYPE  \r\n");
                query.append("  \t\t  , IFNULL(ADULT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ADULT  \r\n");
                query.append("  \t\t  , IFNULL(ISRETURN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISRETURN  \r\n");
                query.append("  \t\t  , IFNULL(TEXT_OPTION, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS TEXT_OPTION  \r\n");
                query.append("  \t\t  , IFNULL(DELV_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(DELV_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(RETURN_DELV_COST, '0')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS RETURN_DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(BANPUM_AREA, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS BANPUM_AREA  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_COST  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_CONSUMER_PRICE, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_CONSUMER_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_VAL  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_VAL  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMG_PATH  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH1  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH2  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH3  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH4  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH5  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH6  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH7  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH8  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH9, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH9  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH10, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH10  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH11, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH11  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH12, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH12  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_REMARKS, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_REMARKS  \r\n");
                query.append("  \t\t  , IFNULL(CERT_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(CERTNO, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTNO  \r\n");
                query.append("  \t\t  , IFNULL(AVLST_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLST_DM  \r\n");
                query.append("  \t\t  , IFNULL(AVLED_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLED_DM  \r\n");
                query.append("  \t\t  , IFNULL(ISSUEDATE, '') \t       \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ISSUEDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERTDATE, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERT_AGENCY, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT_AGENCY  \r\n");
                query.append("  \t\t  , IFNULL(CERTFIELD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTFIELD  \r\n");
                query.append("  \t\t  , IFNULL(CERTMODEL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTMODEL  \r\n");
                query.append("  \t\t  , IFNULL(CERTNAME, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTNAME  \r\n");
                query.append("  \t\t  , IFNULL(EXEMPTIONTYPE, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXEMPTIONTYPE  \r\n");
                query.append("  \t\t  , IFNULL(MATERIAL, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MATERIAL  \r\n");
                query.append("  \t\t  , IFNULL(STOCK_USE_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS STOCK_USE_YN  \r\n");
                query.append("  \t\t  , IFNULL(OPT_TYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS OPT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(PROP_EDIT_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP_EDIT_YN  \r\n");
                query.append("  \t\t  , IFNULL(PROP1_CD, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP1_CD  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL1  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL2  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL3  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL4  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL5  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL6  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL7  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL8  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL9, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL9  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL10, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL10  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL11, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL11  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL12, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL12  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL13, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL13  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL14, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL14  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL15, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL15  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL16, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL16  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL17, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL17  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL18, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL18  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL19, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL19  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL20, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL20  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL21, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL21  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL22, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL22  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL23, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL23  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL24, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL24  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL25, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL25  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL26, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL26  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL27, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL27  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL28, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL28  \r\n");
                query.append("  \t\t  , IFNULL(PACK_CODE_STR, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PACK_CODE_STR  \r\n");
                query.append("  \t\t  , IFNULL(IMPORTNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMPORTNO  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_COST2  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ORIGIN2  \r\n");
                query.append("  \t\t  , IFNULL(EXPIRE_DM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXPIRE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SUPPLY_SAVE_YN, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SUPPLY_SAVE_YN  \r\n");
                query.append("  \t\t  , IFNULL(DESCRITION, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DESCRITION  \r\n");
                query.append("  \t\t  , IFNULL(SHOPPRODNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPPRODNO  \r\n");
                query.append("  \t\t  , IFNULL(INSERTDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTDT  \r\n");
                query.append("  \t\t  , IFNULL(INSERTID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTID  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYDT  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYID  \r\n");
                query.append("  \t\t  , IFNULL(SEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEQ  \r\n");
                query.append("  \t\t  , IFNULL(SHOPSENDSTATUS, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSTATS  \r\n");
                query.append("  \t\t  , IFNULL(SHOPSEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SHOPSEQ  \r\n");
                query.append("  \t\t  , IFNULL(SALEENDDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SALEENDDT  \r\n");
                query.append("  \t\t  , IFNULL(DELV_QTY, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_QTY  \r\n");
                query.append("  \t\t  , IFNULL(GMCATEGNM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GMCATEGNM  \r\n");
                query.append("  \t\t  , IFNULL(SHOPMODIFYCONTENT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPMODIFYCONTENT  \r\n");
                query.append("  \t\t  , IFNULL(SELFMOD_NO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SELFMOD_NO  \r\n");
                query.append("  \t\t  , IFNULL(A.SENDSEQ,'') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SENDSEQ  \r\n");
                query.append("  \t\tFROM SHOPPRODIN AS A  \r\n");
                query.append("  \t   INNER JOIN (SELECT SENDSEQ FROM CTE_PRODLIST) AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append("  \t                ORDER BY A.INSERTDT DESC) AS INFO) AS AA  \r\n");
                YDMAStringUtil.Print(query.toString());
                List items = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
                IntStream.range(0, result.size()).forEach(i -> ((ProductDTO)items.get(i)).setRowno(String.valueOf(i + 1)));
                result = items;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> getDiscontinueProductsIn(ProductDiscontinueOptionDTO dto, String commandID, String shopCode, String shopSeq, boolean next) throws Exception {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT * FROM ( \r\n");
                query.append("  WITH CTE_PRODLIST AS (  \r\n");
                query.append("      SELECT IFNULL(SENDSEQ, '') AS SENDSEQ  \r\n");
                query.append("\t\t  FROM SHOPPRODIN   \r\n");
                query.append("\t     WHERE COMPNO = " + compno + "  \r\n");
                query.append("         AND STATUS IN (1, 2, 3)  \r\n");
                if (commandID.equals("S")) {
                    query.append("\t       AND SHOPCD = '" + shopCode + "'  \r\n");
                } else if (commandID.equals("U")) {
                    query.append("\t       AND SHOPCD = '" + shopCode + "'  \r\n");
                    query.append("\t       AND SHOPSEQ = " + shopSeq + "  \r\n");
                }
                if (!dto.getDomemall().equals("\uc804\uccb4")) {
                    query.append("\t       AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("                AND NOT EXISTS (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("                AND EXISTS (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append(String.format("\t   \t\t\t\t\t\t\t\t               AND FOLDER = '%s')  \r\n", dto.getFolder()));
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t       AND CLASS_CD3 LIKE '" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t       AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t        OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                if (dto.getSearchType().equals("IMG_PATH")) {
                    query.append("\t   AND IMG_PATH = ''  \r\n");
                } else if (!dto.getSearchText().equals("")) {
                    if (dto.getSearchType().equals("GOODS_COST") || dto.getSearchType().equals("DESCRITION") || dto.getSearchType().equals("DELV_COST") || dto.getSearchType().equals("RETURN_DELV_COST")) {
                        query.append(YDMAStringUtil.buildNumericCondition(dto.getSearchType(), dto.getSearchText()));
                    } else if (dto.getSearchType().equals("GOODS_SEARCH_CNT")) {
                        query.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + dto.getSearchText() + "\r\n");
                    } else if (!dto.getSearchType().equals("EXISTS_SHOPPING")) {
                        query.append(YDMAStringUtil.buildLikeClause(dto.getSearchType(), dto.getSearchText()));
                    }
                }
                if (next) {
                    query.append("\t ORDER BY MODIFYDT DESC LIMIT " + dto.getSearchBlock() * (dto.getSearchPage() - 1) + ", " + dto.getSearchBlock() + "  \r\n");
                } else {
                    query.append("\t ORDER BY MODIFYDT DESC LIMIT " + dto.getSearchBlock() * dto.getSearchPage() + ", " + dto.getSearchBlock() + "  \r\n");
                }
                query.append(") \r\n");
                query.append("SELECT  \r\n");
                query.append("      INFO.*   \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN STATUS = '0' THEN '\uacf5\uae09\uc911'  \r\n");
                query.append("         WHEN STATUS = '1' THEN '\ud488\uc808'  \r\n");
                query.append("         WHEN STATUS = '2' THEN '\ub2e8\uc885'  \r\n");
                query.append("         WHEN STATUS = '3' THEN '\uc0ad\uc81c'  \r\n");
                query.append("        END) AS STATUS_NM  \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN DELV_TYPE = '1' THEN '\ubb34\ub8cc'  \r\n");
                query.append("         WHEN DELV_TYPE = '2' THEN '\ucc29\ubd88'  \r\n");
                query.append("         WHEN DELV_TYPE = '3' THEN '\uc120\uacb0\uc81c'  \r\n");
                query.append("         WHEN DELV_TYPE = '4' THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'  \r\n");
                query.append("         ELSE ''  \r\n");
                query.append("        END) AS DELV_TYPE_NM   \r\n");
                query.append("  FROM (SELECT  \r\n");
                query.append("  \t\t\tIFNULL(A.PRODSEQ, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS PRODSEQ  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPAYNY_GOODS_CD, '')   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPAYNY_GOODS_CD  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPNO, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPNO  \r\n");
                query.append("  \t\t  , CONCAT(IFNULL(CLASS_CD1, ''), IFNULL(CLASS_CD2, ''), IFNULL(CLASS_CD3, ''), IFNULL(CLASS_CD4, '')) AS CODE  \r\n");
                query.append("  \t\t  , IFNULL(SHOPCD, '') \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t   AS SHOPCD  \r\n");
                query.append("  \t\t  , IFNULL(SHOP_USERID,'' ) \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t   AS SHOP_USERID  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS IMG  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_KEYWORD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_KEYWORD  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_NM  \r\n");
                query.append("  \t\t  , IFNULL(MODEL_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS MODEL_NM  \r\n");
                query.append("  \t\t  , IFNULL(BRAND_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS BRAND_NM  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_SEARCH, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_SEARCH  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_GUBUN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_GUBUN  \r\n");
                query.append("  \t\t  , IFNULL(SHOP_CID_INFO, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_CID_INFO  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD1  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD2  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD3  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CLASS_CD4  \r\n");
                query.append("  \t\t  , IFNULL(PARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(DPARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DPARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(MAKER, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS MAKER  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ORIGIN  \r\n");
                query.append("  \t\t  , IFNULL(MAKE_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MAKE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SEX, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEX  \r\n");
                query.append("  \t\t  , IFNULL(STATUS, '') \t\t \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS STATUS  \r\n");
                query.append("  \t\t  , IFNULL(DELIV_ABLE_REGION, '')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELIV_ABLE_REGION  \r\n");
                query.append("  \t\t  , IFNULL(TAX_YN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS TAX_YN  \r\n");
                query.append("  \t\t  , IFNULL(CERT, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT  \r\n");
                query.append("  \t\t  , IFNULL(ISLIMIT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISLIMIT  \r\n");
                query.append("  \t\t  , IFNULL(LIMIT_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS LIMIT_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(IS_OVERSEAS, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IS_OVERSEAS  \r\n");
                query.append("  \t\t  , IFNULL(ITYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ITYPE  \r\n");
                query.append("  \t\t  , IFNULL(ADULT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ADULT  \r\n");
                query.append("  \t\t  , IFNULL(ISRETURN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISRETURN  \r\n");
                query.append("  \t\t  , IFNULL(TEXT_OPTION, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS TEXT_OPTION  \r\n");
                query.append("  \t\t  , IFNULL(DELV_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(DELV_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(RETURN_DELV_COST, '0')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS RETURN_DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(BANPUM_AREA, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS BANPUM_AREA  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_COST  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_CONSUMER_PRICE, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_CONSUMER_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_VAL  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_VAL  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMG_PATH  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH1  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH2  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH3  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH4  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH5  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH6  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH7  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH8  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH9, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH9  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH10, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH10  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH11, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH11  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH12, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH12  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_REMARKS, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_REMARKS  \r\n");
                query.append("  \t\t  , IFNULL(CERT_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(CERTNO, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTNO  \r\n");
                query.append("  \t\t  , IFNULL(AVLST_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLST_DM  \r\n");
                query.append("  \t\t  , IFNULL(AVLED_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLED_DM  \r\n");
                query.append("  \t\t  , IFNULL(ISSUEDATE, '') \t       \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ISSUEDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERTDATE, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERT_AGENCY, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT_AGENCY  \r\n");
                query.append("  \t\t  , IFNULL(CERTFIELD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTFIELD  \r\n");
                query.append("  \t\t  , IFNULL(CERTMODEL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTMODEL  \r\n");
                query.append("  \t\t  , IFNULL(CERTNAME, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTNAME  \r\n");
                query.append("  \t\t  , IFNULL(EXEMPTIONTYPE, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXEMPTIONTYPE  \r\n");
                query.append("  \t\t  , IFNULL(MATERIAL, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MATERIAL  \r\n");
                query.append("  \t\t  , IFNULL(STOCK_USE_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS STOCK_USE_YN  \r\n");
                query.append("  \t\t  , IFNULL(OPT_TYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS OPT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(PROP_EDIT_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP_EDIT_YN  \r\n");
                query.append("  \t\t  , IFNULL(PROP1_CD, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP1_CD  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL1  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL2  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL3  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL4  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL5  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL6  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL7  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL8  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL9, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL9  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL10, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL10  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL11, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL11  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL12, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL12  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL13, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL13  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL14, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL14  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL15, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL15  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL16, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL16  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL17, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL17  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL18, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL18  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL19, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL19  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL20, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL20  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL21, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL21  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL22, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL22  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL23, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL23  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL24, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL24  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL25, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL25  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL26, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL26  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL27, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL27  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL28, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL28  \r\n");
                query.append("  \t\t  , IFNULL(PACK_CODE_STR, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PACK_CODE_STR  \r\n");
                query.append("  \t\t  , IFNULL(IMPORTNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMPORTNO  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_COST2  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ORIGIN2  \r\n");
                query.append("  \t\t  , IFNULL(EXPIRE_DM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXPIRE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SUPPLY_SAVE_YN, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SUPPLY_SAVE_YN  \r\n");
                query.append("  \t\t  , IFNULL(DESCRITION, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DESCRITION  \r\n");
                query.append("  \t\t  , IFNULL(SHOPPRODNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPPRODNO  \r\n");
                query.append("  \t\t  , IFNULL(INSERTDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTDT  \r\n");
                query.append("  \t\t  , IFNULL(INSERTID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTID  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYDT  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYID  \r\n");
                query.append("  \t\t  , IFNULL(SEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEQ  \r\n");
                query.append("  \t\t  , IFNULL(SHOPSENDSTATUS, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSTATS  \r\n");
                query.append("  \t\t  , IFNULL(SHOPSEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SHOPSEQ  \r\n");
                query.append("  \t\t  , IFNULL(SALEENDDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SALEENDDT  \r\n");
                query.append("  \t\t  , IFNULL(DELV_QTY, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_QTY  \r\n");
                query.append("  \t\t  , IFNULL(GMCATEGNM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GMCATEGNM  \r\n");
                query.append("  \t\t  , IFNULL(SHOPMODIFYCONTENT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPMODIFYCONTENT  \r\n");
                query.append("  \t\t  , IFNULL(SELFMOD_NO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SELFMOD_NO  \r\n");
                query.append("  \t\t  , IFNULL(A.SENDSEQ,'') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SENDSEQ  \r\n");
                query.append("  \t\tFROM SHOPPRODIN AS A  \r\n");
                query.append("  \t   INNER JOIN (SELECT SENDSEQ FROM CTE_PRODLIST) AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append("  \t                ORDER BY A.INSERTDT DESC) AS INFO) AS AA  \r\n");
                YDMAStringUtil.Print(query.toString());
                List items = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
                IntStream.range(0, result.size()).forEach(i -> ((ProductDTO)items.get(i)).setRowno(String.valueOf(i + 1)));
                result = items;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> getOperatingProductInDistinctItem() {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT DISTINCT  \r\n");
                query.append("      SHOPCD      AS SHOPCD  \r\n");
                query.append("    , SHOP_USERID AS SHOPID  \r\n");
                query.append("    , SHOPSEQ     AS SHOPSEQ  \r\n");
                query.append("    , COUNT(*)    AS COUNTS  \r\n");
                query.append("  FROM SHOPPRODIN   \r\n");
                query.append(" WHERE COMPNO = " + compno + "  \r\n");
                query.append("\t AND STATUS = 0  \r\n");
                query.append("\t AND SHOPSENDSTATUS <> 9000  \r\n");
                query.append(" GROUP BY 1, 2, 3  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> getOperatingProductInDistinctItem(ProductOperatingOptionDTO dto) {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT DISTINCT  \r\n");
                query.append("      SHOPCD      AS SHOPCD  \r\n");
                query.append("    , SHOP_USERID AS SHOPID  \r\n");
                query.append("    , SHOPSEQ     AS SHOPSEQ  \r\n");
                query.append("    , COUNT(*)    AS COUNTS  \r\n");
                query.append("  FROM SHOPPRODIN   \r\n");
                query.append(" WHERE COMPNO = " + compno + "  \r\n");
                query.append("\t AND STATUS = 0  \r\n");
                query.append("\t AND SHOPSENDSTATUS <> 9000  \r\n");
                if (!dto.getDomemall().equals("\uc804\uccb4")) {
                    query.append("\t AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("                AND NOT EXISTS (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("                AND EXISTS (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append(String.format("\t   \t\t\t\t\t\t\t\t               AND FOLDER = '%s')  \r\n", dto.getFolder()));
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t AND CLASS_CD3 LIKE '" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t  OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                if (dto.getSearchType().equals("IMG_PATH")) {
                    query.append("\t   AND IMG_PATH = ''  \r\n");
                } else if (!dto.getSearchText().equals("")) {
                    if (dto.getSearchType().equals("GOODS_COST") || dto.getSearchType().equals("DESCRITION") || dto.getSearchType().equals("DELV_COST") || dto.getSearchType().equals("RETURN_DELV_COST")) {
                        query.append(YDMAStringUtil.buildNumericCondition(dto.getSearchType(), dto.getSearchText()));
                    } else if (dto.getSearchType().equals("GOODS_SEARCH_CNT")) {
                        query.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + dto.getSearchText() + "\r\n");
                    } else if (!dto.getSearchType().equals("EXISTS_SHOPPING")) {
                        query.append(YDMAStringUtil.buildLikeClause(dto.getSearchType(), dto.getSearchText()));
                    }
                }
                query.append(" GROUP BY 1, 2, 3  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> getDiscontinueProductInDistinctItem() {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT DISTINCT  \r\n");
                query.append("      SHOPCD      AS SHOPCD  \r\n");
                query.append("    , SHOP_USERID AS SHOPID  \r\n");
                query.append("    , SHOPSEQ     AS SHOPSEQ  \r\n");
                query.append("    , COUNT(*)    AS COUNTS  \r\n");
                query.append("  FROM SHOPPRODIN   \r\n");
                query.append(" WHERE COMPNO = " + compno + "  \r\n");
                query.append("\t AND STATUS IN (1, 2, 3)  \r\n");
                query.append("\t AND SHOPSENDSTATUS <> 9000  \r\n");
                query.append(" GROUP BY 1, 2, 3  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> getDiscontinueProductInDistinctItem(ProductDiscontinueOptionDTO dto) {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT DISTINCT  \r\n");
                query.append("      SHOPCD      AS SHOPCD  \r\n");
                query.append("    , SHOP_USERID AS SHOPID  \r\n");
                query.append("    , SHOPSEQ     AS SHOPSEQ  \r\n");
                query.append("    , COUNT(*)    AS COUNTS  \r\n");
                query.append("  FROM SHOPPRODIN   \r\n");
                query.append(" WHERE COMPNO = " + compno + "  \r\n");
                query.append("\t AND STATUS IN ('1', '2', '3')  \r\n");
                query.append("\t AND SHOPSENDSTATUS <> 9000  \r\n");
                if (!dto.getDomemall().equals("\uc804\uccb4")) {
                    query.append("\t AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("                AND NOT EXISTS (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("                AND EXISTS (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append(String.format("\t   \t\t\t\t\t\t\t\t               AND FOLDER = '%s')  \r\n", dto.getFolder()));
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t AND CLASS_CD3 LIKE '" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t  OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                if (dto.getSearchType().equals("IMG_PATH")) {
                    query.append("\t   AND IMG_PATH = ''  \r\n");
                } else if (!dto.getSearchText().equals("")) {
                    if (dto.getSearchType().equals("GOODS_COST") || dto.getSearchType().equals("DESCRITION") || dto.getSearchType().equals("DELV_COST") || dto.getSearchType().equals("RETURN_DELV_COST")) {
                        query.append(YDMAStringUtil.buildNumericCondition(dto.getSearchType(), dto.getSearchText()));
                    } else if (dto.getSearchType().equals("GOODS_SEARCH_CNT")) {
                        query.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + dto.getSearchText() + "\r\n");
                    } else if (!dto.getSearchType().equals("EXISTS_SHOPPING")) {
                        query.append(YDMAStringUtil.buildLikeClause(dto.getSearchType(), dto.getSearchText()));
                    }
                }
                query.append(" GROUP BY 1, 2, 3  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getOperatingProductAllCount(ProductOperatingOptionDTO dto) throws Exception {
        QueryRunner run = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT COUNT(*) AS CNT  \r\n");
                query.append("  FROM SHOPPRODINFO  \r\n");
                query.append(" WHERE COMPNO = " + compno + "  \r\n");
                query.append("   AND STATUS = 0  \r\n");
                if (!dto.getDomemall().equals("\uc804\uccb4")) {
                    query.append("\t AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("                AND NOT EXISTS (SELECT 1 FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodinfo.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("                AND EXISTS (SELECT 1 FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodinfo.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append(String.format("\t   \t\t\t\t\t\t\t\t               AND FOLDER = '%s')  \r\n", dto.getFolder()));
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t AND CLASS_CD3 LIKE '" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t  OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                if (dto.getSearchType().equals("IMG_PATH")) {
                    query.append("\t   AND IMG_PATH = ''  \r\n");
                } else if (!dto.getSearchText().equals("")) {
                    if (dto.getSearchType().equals("GOODS_COST") || dto.getSearchType().equals("DESCRITION") || dto.getSearchType().equals("DELV_COST") || dto.getSearchType().equals("RETURN_DELV_COST")) {
                        query.append(YDMAStringUtil.buildNumericCondition(dto.getSearchType(), dto.getSearchText()));
                    } else if (dto.getSearchType().equals("GOODS_SEARCH_CNT")) {
                        query.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + dto.getSearchText() + "\r\n");
                    } else if (!dto.getSearchType().equals("EXISTS_SHOPPING")) {
                        query.append(YDMAStringUtil.buildLikeClause(dto.getSearchType(), dto.getSearchText()));
                    }
                }
                YDMAStringUtil.Print(query.toString());
                Long result = (Long)run.query(connection, query.toString(), (ResultSetHandler)handler);
                return result.intValue();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getOperatingProductInAllCount(ProductOperatingOptionDTO dto, String commandID, String shopCode, String shopSeq) throws Exception {
        QueryRunner run = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT COUNT(*) AS CNT  \r\n");
                query.append("  FROM SHOPPRODIN  \r\n");
                query.append(" WHERE COMPNO = " + compno + "  \r\n");
                query.append("   AND STATUS = 0  \r\n");
                query.append("   AND SHOPCD = '" + shopCode + "'  \r\n");
                if (commandID.equals("U")) {
                    query.append("   AND SHOPSEQ = " + shopSeq + "  \r\n");
                }
                if (!dto.getDomemall().equals("\uc804\uccb4")) {
                    query.append("\t AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("                AND NOT EXISTS (SELECT 1 FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("                AND EXISTS (SELECT 1 FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append(String.format("\t   \t\t\t\t\t\t\t\t               AND FOLDER = '%s')  \r\n", dto.getFolder()));
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t AND CLASS_CD3 LIKE '" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t  OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                if (dto.getSearchType().equals("IMG_PATH")) {
                    query.append("\t   AND IMG_PATH = ''  \r\n");
                } else if (!dto.getSearchText().equals("")) {
                    if (dto.getSearchType().equals("GOODS_COST") || dto.getSearchType().equals("DESCRITION") || dto.getSearchType().equals("DELV_COST") || dto.getSearchType().equals("RETURN_DELV_COST")) {
                        query.append(YDMAStringUtil.buildNumericCondition(dto.getSearchType(), dto.getSearchText()));
                    } else if (dto.getSearchType().equals("GOODS_SEARCH_CNT")) {
                        query.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + dto.getSearchText() + "\r\n");
                    } else if (!dto.getSearchType().equals("EXISTS_SHOPPING")) {
                        query.append(YDMAStringUtil.buildLikeClause(dto.getSearchType(), dto.getSearchText()));
                    }
                }
                Long result = (Long)run.query(connection, query.toString(), (ResultSetHandler)handler);
                return result.intValue();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getDiscontinueProductInfoAllCount(ProductDiscontinueOptionDTO dto) throws Exception {
        QueryRunner run = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT COUNT(*) AS CNT  \r\n");
                query.append("  FROM SHOPPRODINFO  \r\n");
                query.append(" WHERE COMPNO = " + compno + "  \r\n");
                query.append("   AND STATUS IN (1, 2, 3)  \r\n");
                if (!dto.getDomemall().equals("\uc804\uccb4")) {
                    query.append("\t AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("                AND NOT EXISTS (SELECT 1 FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodinfo.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("                AND EXISTS (SELECT 1 FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodinfo.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append(String.format("\t   \t\t\t\t\t\t\t\t               AND FOLDER = '%s')  \r\n", dto.getFolder()));
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t AND CLASS_CD3 LIKE '" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t  OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                Long result = (Long)run.query(connection, query.toString(), (ResultSetHandler)handler);
                return result.intValue();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getDiscontinueProductInAllCount(ProductDiscontinueOptionDTO dto, String commandID, String shopCode, String shopSeq) throws Exception {
        QueryRunner run = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT COUNT(*) AS CNT  \r\n");
                query.append("  FROM SHOPPRODIN  \r\n");
                query.append(" WHERE COMPNO = " + compno + "  \r\n");
                query.append("   AND STATUS IN (1, 2, 3)  \r\n");
                query.append("   AND SHOPCD = '" + shopCode + "'  \r\n");
                if (commandID.equals("U")) {
                    query.append("   AND SHOPSEQ = " + shopSeq + "  \r\n");
                }
                if (!dto.getDomemall().equals("\uc804\uccb4")) {
                    query.append("\t AND GOODS_KEYWORD = '" + dto.getDomemall() + "'  \r\n");
                }
                if (dto.getFolder().equals("")) {
                    query.append("                AND NOT EXISTS (SELECT 1 FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND FOLDER LIKE 'NOT_%')  \r\n");
                } else {
                    query.append("                AND EXISTS (SELECT 1 FROM shopprodfolders  AS F \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t             WHERE COMPNO = " + compno + "  \r\n");
                    query.append("\t   \t\t\t\t\t\t\t\t               AND shopprodin.COMPAYNY_GOODS_CD = F.COMPAYNY_GOODS_CD  \r\n");
                    query.append(String.format("\t   \t\t\t\t\t\t\t\t               AND FOLDER = '%s')  \r\n", dto.getFolder()));
                }
                if (!dto.getCategory().equals("")) {
                    query.append("\t AND CLASS_CD3 LIKE '" + dto.getCategory() + "%'  \r\n");
                }
                if (!dto.getStartDate().equals("") && !dto.getEndDate().equals("")) {
                    query.append("\t AND ((INSERTDT >= '" + dto.getStartDate() + "' AND INSERTDT <= '" + dto.getEndDate() + "')  \r\n");
                    query.append("\t  OR (MODIFYDT >= '" + dto.getStartDate() + "' AND MODIFYDT <= '" + dto.getEndDate() + "'))  \r\n");
                }
                if (dto.getSearchType().equals("IMG_PATH")) {
                    query.append("\t   AND IMG_PATH = ''  \r\n");
                } else if (!dto.getSearchText().equals("")) {
                    if (dto.getSearchType().equals("GOODS_COST") || dto.getSearchType().equals("DESCRITION") || dto.getSearchType().equals("DELV_COST") || dto.getSearchType().equals("RETURN_DELV_COST")) {
                        query.append(YDMAStringUtil.buildNumericCondition(dto.getSearchType(), dto.getSearchText()));
                    } else if (dto.getSearchType().equals("GOODS_SEARCH_CNT")) {
                        query.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + dto.getSearchText() + "\r\n");
                    } else if (!dto.getSearchType().equals("EXISTS_SHOPPING")) {
                        query.append(YDMAStringUtil.buildLikeClause(dto.getSearchType(), dto.getSearchText()));
                    }
                }
                Long result = (Long)run.query(connection, query.toString(), (ResultSetHandler)handler);
                return result.intValue();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public List<ProductFolderDTO> getProductFolders() throws Exception {
        List result = null;
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductFolderDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("\t\tCOMPNO  \r\n");
                query.append("\t  , FOLDER  \r\n");
                query.append("\t  , COMPAYNY_GOODS_CD  \r\n");
                query.append("  FROM shopprodfolders  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno)};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int deleteClearProductFolders() {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM shopprodfolders WHERE COMPNO = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(compno)};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public int insertProductFolders(List<ProductFolderDTO> dtos) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int updateProductInStatus(int status2, List<ProductDTO> dtos) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN  \r\n");
        query.append("   SET SHOPSENDSTATUS = ?  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SENDSEQ IN (?)  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{status2, Integer.parseInt(compno), dtos.stream().map(p -> String.valueOf(p.getSENDSEQ())).collect(Collectors.joining(","))};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateProductInfoStatus(List<String> codes, String status2) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODINFO  \r\n");
        query.append("   SET STATUS = ?  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < codes.size()) {
            placeholders.append("?");
            if (i2 < codes.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        query.append("   AND COMPAYNY_GOODS_CD IN (").append((CharSequence)placeholders).append(")  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable i2 = null;
            Object var7_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(status2);
                params.add(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                params.addAll(codes);
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateProductInStatus(String status2, int sendStatus, String sendseq) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN  \r\n");
        query.append("   SET STATUS = ?  \r\n");
        query.append("     , SHOPSENDSTATUS = ?  \r\n");
        query.append(" WHERE SENDSEQ = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{status2, sendStatus, sendseq};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateProductInStatus(List<String> codes, String status2, int sendStatus) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN  \r\n");
        query.append("   SET STATUS = ?  \r\n");
        query.append("     , SHOPSENDSTATUS = ?  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < codes.size()) {
            placeholders.append("?");
            if (i2 < codes.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        query.append("   AND SENDSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable i2 = null;
            Object var8_11 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(status2);
                params.add(sendStatus);
                params.add(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                params.addAll(codes);
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateProductInStatus(List<String> codes, String status2, String shopCode, int sendStatus) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN  \r\n");
        query.append("   SET STATUS = ?  \r\n");
        query.append("     , SHOPSENDSTATUS = ?  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < codes.size()) {
            placeholders.append("?");
            if (i2 < codes.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        query.append("   AND SENDSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable i2 = null;
            Object var9_12 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(status2);
                params.add(sendStatus);
                params.add(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                params.add(shopCode);
                params.addAll(codes);
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateProductInStatusInSEQ(List<ProductDTO> prodInfos, String status2) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN  \r\n");
        query.append("   SET STATUS = ?  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        List shopSeqs = prodInfos.stream().map(p -> p.getShopseq()).distinct().collect(Collectors.toList());
        StringBuilder placeholder = new StringBuilder();
        int i = 0;
        while (i < shopSeqs.size()) {
            placeholder.append("?");
            if (i < shopSeqs.size() - 1) {
                placeholder.append(",");
            }
            ++i;
        }
        query.append("   AND SHOPSEQ IN (").append((CharSequence)placeholder).append(")  \r\n");
        List sendSeqs = prodInfos.stream().map(p -> String.valueOf(p.getSENDSEQ())).collect(Collectors.toList());
        StringBuilder placeholders = new StringBuilder();
        int i22 = 0;
        while (i22 < sendSeqs.size()) {
            placeholders.append("?");
            if (i22 < sendSeqs.size() - 1) {
                placeholders.append(",");
            }
            ++i22;
        }
        query.append("   AND SENDSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable i22 = null;
            Object var10_14 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(status2);
                params.add(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                params.add(prodInfos.get(0).getShopcd());
                params.addAll(shopSeqs);
                params.addAll(sendSeqs);
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i22 == null) {
                    i22 = throwable;
                } else if (i22 != throwable) {
                    i22.addSuppressed(throwable);
                }
                throw i22;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateProductInStatus(List<ProductDTO> prodInfos, String status2) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN  \r\n");
        query.append("   SET STATUS = ?  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        query.append("   AND SHOPSEQ = ?  \r\n");
        List sendSeqs = prodInfos.stream().map(p -> String.valueOf(p.getSENDSEQ())).collect(Collectors.toList());
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < sendSeqs.size()) {
            placeholders.append("?");
            if (i2 < sendSeqs.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        query.append("   AND SENDSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable i2 = null;
            Object var8_11 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(status2);
                params.add(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                params.add(prodInfos.get(0).getShopcd());
                params.add(Integer.parseInt(prodInfos.get(0).getShopseq()));
                params.addAll(sendSeqs);
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateOptProductInfoStatus(int prodseq, int skuseq, String status2) {
        int result = 0;
        QueryRunner runner = new QueryRunner();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("UPDATE shop_optprodinfo  \r\n");
                query.append("   SET STATUS = ?  \r\n");
                query.append(" WHERE PRODSEQ = ?  \r\n");
                query.append("   AND SKUSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{status2, prodseq, skuseq};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateOptProductInfoStatus(List<String> compayny_goods_cds, String status2) {
        int result = 0;
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < compayny_goods_cds.size()) {
            placeholders.append("?");
            if (i2 < compayny_goods_cds.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        try {
            Throwable i2 = null;
            Object var6_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("UPDATE shop_optprodinfo  \r\n");
                query.append("   SET STATUS = ?  \r\n");
                query.append(" WHERE PRODCD IN (").append((CharSequence)placeholders).append(")  \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<String> params = new ArrayList<String>();
                params.add(status2);
                params.addAll(compayny_goods_cds);
                QueryRunner runner = new QueryRunner();
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateOptProductInStatus(int sendseq, int skuseq, String status2) {
        int result = 0;
        QueryRunner runner = new QueryRunner();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("UPDATE shop_optprodin  \r\n");
                query.append("   SET STATUS = ?  \r\n");
                query.append(" WHERE SENDSEQ = ?  \r\n");
                query.append("   AND SKUSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{status2, sendseq, skuseq};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateOptProductInStatus(String optprodcd, String status2) {
        int result = 0;
        QueryRunner runner = new QueryRunner();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("UPDATE shop_optprodin  \r\n");
                query.append("   SET STATUS = ?  \r\n");
                query.append(" WHERE OPTPRODCD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{status2, optprodcd};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateOptProductInStatus(List<String> sendseqs, String status2) {
        int result = 0;
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < sendseqs.size()) {
            placeholders.append("?");
            if (i2 < sendseqs.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        try {
            Throwable i2 = null;
            Object var6_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("UPDATE shop_optprodin  \r\n");
                query.append("   SET STATUS = ?  \r\n");
                query.append(" WHERE SENDSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<String> params = new ArrayList<String>();
                params.add(status2);
                params.addAll(sendseqs);
                QueryRunner runner = new QueryRunner();
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateOptProductInSoldout(String sendseq) {
        int result = 0;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("UPDATE shop_optprodin  \r\n");
                query.append("   SET OPTVERTSTOCK = 0  \r\n");
                query.append("     , STATUS = '1'  \r\n");
                query.append(" WHERE SENDSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{sendseq};
                QueryRunner runner = new QueryRunner();
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateOptProductInSoldout(List<String> sendseqs) {
        int result = 0;
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < sendseqs.size()) {
            placeholders.append("?");
            if (i2 < sendseqs.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        try {
            Throwable i2 = null;
            Object var5_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("UPDATE shop_optprodin  \r\n");
                query.append("   SET OPTVERTSTOCK = 0  \r\n");
                query.append("     , STATUS = '1'  \r\n");
                query.append(" WHERE SENDSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<String> params = new ArrayList<String>();
                params.addAll(sendseqs);
                QueryRunner runner = new QueryRunner();
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int deleteOptProductIn(String sendseq) {
        int result = 0;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("DELETE FROM shop_optprodin  \r\n");
                query.append(" WHERE SENDSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{sendseq};
                QueryRunner runner = new QueryRunner();
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int deleteOptProductIn(List<String> sendseqs) {
        int result = 0;
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < sendseqs.size()) {
            placeholders.append("?");
            if (i2 < sendseqs.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        try {
            Throwable i2 = null;
            Object var5_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("DELETE FROM shop_optprodin  \r\n");
                query.append(" WHERE SENDSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<String> params = new ArrayList<String>();
                params.addAll(sendseqs);
                QueryRunner runner = new QueryRunner();
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateAllProductInStatus(List<ProductDTO> prodInfos, String status2) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN  \r\n");
        query.append("   SET STATUS = ?  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        List prodseqs = prodInfos.stream().map(p -> String.valueOf(p.getPRODSEQ())).collect(Collectors.toList());
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < prodseqs.size()) {
            placeholders.append("?");
            if (i2 < prodseqs.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        query.append("   AND PRODSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable i2 = null;
            Object var8_11 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(status2);
                params.add(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                params.addAll(prodseqs);
                QueryRunner runner = new QueryRunner();
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateAllOptProductInStatus(List<ProductDTO> prodInfos, String status2) {
        int result = 0;
        List prodseqs = prodInfos.stream().map(p -> String.valueOf(p.getPRODSEQ())).collect(Collectors.toList());
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < prodseqs.size()) {
            placeholders.append("?");
            if (i2 < prodseqs.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        try {
            Throwable i2 = null;
            Object var7_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("UPDATE shop_optprodin  \r\n");
                query.append("   SET STATUS = ?  \r\n");
                query.append(" WHERE PRODSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<String> params = new ArrayList<String>();
                params.add(status2);
                params.addAll(prodseqs);
                QueryRunner runner = new QueryRunner();
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int deleteProductIn(String codes) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM shopprodin  \r\n");
        query.append(" WHERE SENDSEQ = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{codes};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int deleteProductInfo(List<String> codes) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM shopprodinfo  \r\n");
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < codes.size()) {
            placeholders.append("?");
            if (i2 < codes.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        query.append(" WHERE PRODSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable i2 = null;
            Object var6_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                ArrayList<String> params = new ArrayList<String>();
                params.addAll(codes);
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int deleteProductIn(List<String> codes) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM shopprodin  \r\n");
        StringBuilder placeholders = new StringBuilder();
        int i2 = 0;
        while (i2 < codes.size()) {
            placeholders.append("?");
            if (i2 < codes.size() - 1) {
                placeholders.append(",");
            }
            ++i2;
        }
        query.append(" WHERE SENDSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable i2 = null;
            Object var6_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                ArrayList<String> params = new ArrayList<String>();
                params.addAll(codes);
                result = runner.update(connection, query.toString(), params.toArray());
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> getProductsIn(ShoppingmallDTO shopInfo, String sendSeqs) throws Exception {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT * FROM ( \r\n");
                query.append("  WITH CTE_PRODLIST AS (  \r\n");
                query.append("      SELECT IFNULL(SENDSEQ, '') AS SENDSEQ  \r\n");
                query.append("\t\t  FROM SHOPPRODIN   \r\n");
                query.append("\t     WHERE COMPNO = " + compno + "  \r\n");
                query.append("         AND INSERTDT <> ''  \r\n");
                query.append("         AND STATUS = 0  \r\n");
                query.append("         AND SENDSEQ IN ()  \r\n");
                query.append("\t       AND SHOPCD = '" + shopInfo.getSHOPCD() + "'  \r\n");
                query.append("\t       AND SHOPSEQ = " + shopInfo.getSHOPSEQ() + "  \r\n");
                query.append(") \r\n");
                query.append("SELECT  \r\n");
                query.append("      INFO.*   \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN STATUS = '0' THEN '\uacf5\uae09\uc911'  \r\n");
                query.append("         WHEN STATUS = '1' THEN '\ud488\uc808'  \r\n");
                query.append("         WHEN STATUS = '2' THEN '\ub2e8\uc885'  \r\n");
                query.append("         WHEN STATUS = '3' THEN '\uc0ad\uc81c'  \r\n");
                query.append("        END) AS STATUS_NM  \r\n");
                query.append("    , (CASE   \r\n");
                query.append("         WHEN DELV_TYPE = '1' THEN '\ubb34\ub8cc'  \r\n");
                query.append("         WHEN DELV_TYPE = '2' THEN '\ucc29\ubd88'  \r\n");
                query.append("         WHEN DELV_TYPE = '3' THEN '\uc120\uacb0\uc81c'  \r\n");
                query.append("         WHEN DELV_TYPE = '4' THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'  \r\n");
                query.append("         ELSE ''  \r\n");
                query.append("        END) AS DELV_TYPE_NM   \r\n");
                query.append("  FROM (SELECT  \r\n");
                query.append("  \t\t\tIFNULL(A.PRODSEQ, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS PRODSEQ  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPAYNY_GOODS_CD, '')   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPAYNY_GOODS_CD  \r\n");
                query.append("  \t\t  , IFNULL(A.COMPNO, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPNO  \r\n");
                query.append("  \t\t  , CONCAT(IFNULL(CLASS_CD1, ''), IFNULL(CLASS_CD2, ''), IFNULL(CLASS_CD3, ''), IFNULL(CLASS_CD4, '')) AS CODE  \r\n");
                query.append("  \t\t  , IFNULL(SHOPCD, '') \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t   AS SHOPCD  \r\n");
                query.append("  \t\t  , IFNULL(SHOP_USERID,'' ) \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t   AS SHOP_USERID  \r\n");
                query.append("  \t\t  , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS IMG  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_KEYWORD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_KEYWORD  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_NM  \r\n");
                query.append("  \t\t  , IFNULL(MODEL_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS MODEL_NM  \r\n");
                query.append("  \t\t  , IFNULL(BRAND_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS BRAND_NM  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_SEARCH, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_SEARCH  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_GUBUN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_GUBUN  \r\n");
                query.append("  \t\t  , IFNULL(SHOP_CID_INFO, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_CID_INFO  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD1  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD2  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD3  \r\n");
                query.append("  \t\t  , IFNULL(CLASS_CD4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CLASS_CD4  \r\n");
                query.append("  \t\t  , IFNULL(PARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(DPARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DPARTNER_ID  \r\n");
                query.append("  \t\t  , IFNULL(MAKER, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS MAKER  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ORIGIN  \r\n");
                query.append("  \t\t  , IFNULL(MAKE_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MAKE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SEX, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEX  \r\n");
                query.append("  \t\t  , IFNULL(STATUS, '') \t\t \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS STATUS  \r\n");
                query.append("  \t\t  , IFNULL(DELIV_ABLE_REGION, '')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELIV_ABLE_REGION  \r\n");
                query.append("  \t\t  , IFNULL(TAX_YN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS TAX_YN  \r\n");
                query.append("  \t\t  , IFNULL(CERT, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT  \r\n");
                query.append("  \t\t  , IFNULL(ISLIMIT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISLIMIT  \r\n");
                query.append("  \t\t  , IFNULL(LIMIT_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS LIMIT_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(IS_OVERSEAS, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IS_OVERSEAS  \r\n");
                query.append("  \t\t  , IFNULL(ITYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ITYPE  \r\n");
                query.append("  \t\t  , IFNULL(ADULT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ADULT  \r\n");
                query.append("  \t\t  , IFNULL(ISRETURN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISRETURN  \r\n");
                query.append("  \t\t  , IFNULL(TEXT_OPTION, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS TEXT_OPTION  \r\n");
                query.append("  \t\t  , IFNULL(DELV_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(DELV_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(RETURN_DELV_COST, '0')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS RETURN_DELV_COST  \r\n");
                query.append("  \t\t  , IFNULL(BANPUM_AREA, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS BANPUM_AREA  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_COST  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_CONSUMER_PRICE, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_CONSUMER_PRICE  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_1_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_VAL  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_NM  \r\n");
                query.append("  \t\t  , IFNULL(CHAR_2_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_VAL  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMG_PATH  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH1  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH2  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH3  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH4  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH5  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH6  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH7  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH8  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH9, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH9  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH10, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH10  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH11, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH11  \r\n");
                query.append("  \t\t  , IFNULL(IMG_PATH12, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH12  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_REMARKS, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_REMARKS  \r\n");
                query.append("  \t\t  , IFNULL(CERT_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(CERTNO, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTNO  \r\n");
                query.append("  \t\t  , IFNULL(AVLST_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLST_DM  \r\n");
                query.append("  \t\t  , IFNULL(AVLED_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLED_DM  \r\n");
                query.append("  \t\t  , IFNULL(ISSUEDATE, '') \t       \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ISSUEDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERTDATE, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTDATE  \r\n");
                query.append("  \t\t  , IFNULL(CERT_AGENCY, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT_AGENCY  \r\n");
                query.append("  \t\t  , IFNULL(CERTFIELD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTFIELD  \r\n");
                query.append("  \t\t  , IFNULL(CERTMODEL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTMODEL  \r\n");
                query.append("  \t\t  , IFNULL(CERTNAME, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTNAME  \r\n");
                query.append("  \t\t  , IFNULL(EXEMPTIONTYPE, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXEMPTIONTYPE  \r\n");
                query.append("  \t\t  , IFNULL(MATERIAL, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MATERIAL  \r\n");
                query.append("  \t\t  , IFNULL(STOCK_USE_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS STOCK_USE_YN  \r\n");
                query.append("  \t\t  , IFNULL(OPT_TYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS OPT_TYPE  \r\n");
                query.append("  \t\t  , IFNULL(PROP_EDIT_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP_EDIT_YN  \r\n");
                query.append("  \t\t  , IFNULL(PROP1_CD, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP1_CD  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL1  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL2  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL3  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL4  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL5  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL6  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL7  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL8  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL9, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL9  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL10, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL10  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL11, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL11  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL12, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL12  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL13, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL13  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL14, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL14  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL15, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL15  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL16, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL16  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL17, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL17  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL18, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL18  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL19, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL19  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL20, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL20  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL21, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL21  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL22, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL22  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL23, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL23  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL24, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL24  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL25, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL25  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL26, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL26  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL27, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL27  \r\n");
                query.append("  \t\t  , IFNULL(PROP_VAL28, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL28  \r\n");
                query.append("  \t\t  , IFNULL(PACK_CODE_STR, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PACK_CODE_STR  \r\n");
                query.append("  \t\t  , IFNULL(IMPORTNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMPORTNO  \r\n");
                query.append("  \t\t  , IFNULL(GOODS_COST2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_COST2  \r\n");
                query.append("  \t\t  , IFNULL(ORIGIN2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ORIGIN2  \r\n");
                query.append("  \t\t  , IFNULL(EXPIRE_DM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXPIRE_DM  \r\n");
                query.append("  \t\t  , IFNULL(SUPPLY_SAVE_YN, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SUPPLY_SAVE_YN  \r\n");
                query.append("  \t\t  , IFNULL(DESCRITION, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DESCRITION  \r\n");
                query.append("  \t\t  , IFNULL(SHOPPRODNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPPRODNO  \r\n");
                query.append("  \t\t  , IFNULL(INSERTDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTDT  \r\n");
                query.append("  \t\t  , IFNULL(INSERTID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTID  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYDT  \r\n");
                query.append("  \t\t  , IFNULL(MODIFYID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYID  \r\n");
                query.append("  \t\t  , IFNULL(SEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEQ  \r\n");
                query.append("  \t\t  , IFNULL(SHOPSENDSTATUS, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSTATS  \r\n");
                query.append("  \t\t  , IFNULL(SHOPSEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SHOPSEQ  \r\n");
                query.append("  \t\t  , IFNULL(SALEENDDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SALEENDDT  \r\n");
                query.append("  \t\t  , IFNULL(DELV_QTY, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_QTY  \r\n");
                query.append("  \t\t  , IFNULL(GMCATEGNM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GMCATEGNM  \r\n");
                query.append("  \t\t  , IFNULL(SHOPMODIFYCONTENT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPMODIFYCONTENT  \r\n");
                query.append("  \t\t  , IFNULL(SELFMOD_NO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SELFMOD_NO  \r\n");
                query.append("  \t\t  , IFNULL(A.SENDSEQ,'') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SENDSEQ  \r\n");
                query.append("  \t\tFROM SHOPPRODIN AS A  \r\n");
                query.append("  \t   INNER JOIN (SELECT SENDSEQ FROM CTE_PRODLIST) AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append("  \t                ORDER BY A.INSERTDT DESC) AS INFO) AS AA  \r\n");
                YDMAStringUtil.Print(query.toString());
                List items = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
                IntStream.range(0, result.size()).forEach(i -> ((ProductDTO)items.get(i)).setRowno(String.valueOf(i + 1)));
                result = items;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> selectProductsIn(List<String> sendseqs) throws Exception {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder placeholders = new StringBuilder();
                int i = 0;
                while (i < sendseqs.size()) {
                    placeholders.append("?");
                    if (i < sendseqs.size() - 1) {
                        placeholders.append(",");
                    }
                    ++i;
                }
                StringBuilder query = new StringBuilder();
                query.append(DataHelper.getQuerySelectColumns(DBCode.SHOPPRODIN.tableName));
                query.append(" WHERE SENDSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<String> params = new ArrayList<String>();
                params.addAll(sendseqs);
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params.toArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> selectProductIn(List<String> codes, String shopCode, String shopSeq) throws Exception {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder placeholders = new StringBuilder();
                int i = 0;
                while (i < codes.size()) {
                    placeholders.append("?");
                    if (i < codes.size() - 1) {
                        placeholders.append(",");
                    }
                    ++i;
                }
                StringBuilder query = new StringBuilder();
                query.append("SELECT *  \r\n");
                query.append("  FROM SHOPPRODIN  \r\n");
                query.append(" WHERE PRODSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
                query.append("   AND COMPNO = ? \r\n");
                query.append("   AND SHOPCD = ? \r\n");
                query.append("   AND SHOPSEQ = ? \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<Object> params = new ArrayList<Object>();
                params.addAll(codes);
                params.add(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                params.add(shopCode);
                params.add(shopSeq);
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params.toArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public int insertProductInfo(List<ProductDTO> dtos) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int insertProductIn(List<ProductDTO> dtos) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<ProductDTO> selectMultiProductInfo(List<String> codes) {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder placeholders = new StringBuilder();
                int i = 0;
                while (i < codes.size()) {
                    placeholders.append("?");
                    if (i < codes.size() - 1) {
                        placeholders.append(",");
                    }
                    ++i;
                }
                StringBuilder query = new StringBuilder();
                query.append(DataHelper.getQuerySelectColumns(DBCode.SHOPPRODINFO.tableName));
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND COMPAYNY_GOODS_CD IN (").append((CharSequence)placeholders).append(")  \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(Integer.parseInt(compno));
                params.addAll(codes);
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params.toArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> selectMultiProductIn(List<String> codes, String shopCode, int shopSeq) {
        List<ProductDTO> result = new ArrayList<ProductDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder placeholders = new StringBuilder();
                int i = 0;
                while (i < codes.size()) {
                    placeholders.append("?");
                    if (i < codes.size() - 1) {
                        placeholders.append(",");
                    }
                    ++i;
                }
                StringBuilder query = new StringBuilder();
                query.append(DataHelper.getQuerySelectColumns(DBCode.SHOPPRODIN.tableName));
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                query.append("   AND COMPAYNY_GOODS_CD IN (").append((CharSequence)placeholders).append(")  \r\n");
                query.append("   AND SHOPSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(Integer.parseInt(compno));
                params.add(shopCode);
                params.addAll(codes);
                params.add(shopSeq);
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params.toArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int insertProductInfo(ProductDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append(DataHelper.getQueryInsertColumns(DBCode.SHOPPRODINFO.tableName));
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getGoods_nm(), dto.getGoods_keyword(), dto.getModel_nm(), dto.getModel_no(), dto.getBrand_nm(), dto.getCompayny_goods_cd(), dto.getGoods_search(), dto.getGoods_gubun(), dto.getShop_cid_info(), dto.getSelect_option(), dto.getText_option(), dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4(), dto.getGmcategnm(), dto.getPartner_id(), dto.getDpartner_id(), dto.getMaker(), dto.getOrigin(), dto.getMake_year(), dto.getMake_dm(), dto.getGoods_season(), dto.getSex(), dto.getStatus(), dto.getDeliv_able_region(), dto.getTax_yn(), dto.getDelv_type(), StringHelper.isNullString(dto.getDelv_cost(), "0"), dto.getDelv_r_cost(), StringHelper.isNullString(dto.getDelv_qty(), "0"), dto.getBanpum_area(), StringHelper.isNullString(dto.getGoods_cost(), "0"), StringHelper.isNullString(dto.getGoods_price(), "0"), StringHelper.isNullString(dto.getGoods_consumer_price(), "0"), StringHelper.isNullString(dto.getIslimit(), "0"), StringHelper.isNullString(dto.getLimit_price(), "0"), StringHelper.isNullString(dto.getIs_overseas(), "0"), StringHelper.isNullString(dto.getAdult(), "0"), StringHelper.isNullString(dto.getIsreturn(), "0"), StringHelper.isNullString(dto.getItype(), "0"), dto.getOptionYN(), dto.getChar_1_nm(), dto.getChar_1_val(), dto.getChar_2_nm(), dto.getChar_2_val(), dto.getImg_path(), dto.getImg_path1(), dto.getImg_path2(), dto.getImg_path3(), dto.getImg_path4(), dto.getImg_path5(), dto.getImg_path6(), dto.getImg_path7(), dto.getImg_path8(), dto.getImg_path9(), dto.getImg_path10(), dto.getImg_path11(), dto.getImg_path12(), dto.getImg_path13(), dto.getImg_path14(), dto.getImg_path15(), dto.getImg_path16(), dto.getImg_path17(), dto.getImg_path18(), dto.getImg_path19(), dto.getImg_path20(), dto.getImg_path21(), dto.getImg_path22(), dto.getImg_path23(), dto.getImg_path24(), dto.getGoods_remarks(), StringHelper.isNullString(dto.getCert_type(), "0"), dto.getCert(), dto.getCertno(), dto.getAvlst_dm(), dto.getAvled_dm(), dto.getIssuedate(), dto.getCertdate(), dto.getCert_agency(), dto.getCertfield(), dto.getCertmodel(), dto.getCertname(), dto.getExemptiontype(), dto.getMaterial(), dto.getStock_use_yn(), dto.getOpt_type(), dto.getProp_edit_yn(), dto.getProp1_cd(), dto.getProp_val1(), dto.getProp_val2(), dto.getProp_val3(), dto.getProp_val4(), dto.getProp_val5(), dto.getProp_val6(), dto.getProp_val7(), dto.getProp_val8(), dto.getProp_val9(), dto.getProp_val10(), dto.getProp_val11(), dto.getProp_val12(), dto.getProp_val13(), dto.getProp_val14(), dto.getProp_val15(), dto.getProp_val16(), dto.getProp_val17(), dto.getProp_val18(), dto.getProp_val19(), dto.getProp_val20(), dto.getProp_val21(), dto.getProp_val22(), dto.getProp_val23(), dto.getProp_val24(), dto.getProp_val25(), dto.getProp_val26(), dto.getProp_val27(), dto.getProp_val28(), dto.getPack_code_str(), dto.getGoods_nm_en(), dto.getGoods_nm_pr(), dto.getGoods_remarks2(), dto.getGoods_remarks3(), dto.getGoods_remarks4(), dto.getImportno(), dto.getGoods_cost2(), dto.getOrigin2(), dto.getExpire_dm(), dto.getSupply_save_yn(), dto.getDescrition(), "", dto.getInsertdt(), YDMASessonUtil.getUserInfo().getUserId(), dto.getInsertdt(), dto.getModifyid(), StringHelper.isNullString(dto.getSendstats(), "-1"), dto.getShopmodifycontent(), dto.getSelfmod_no()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateProductInfo(ProductDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODINFO \r\n");
        query.append("   SET STATUS = ?   \r\n");
        query.append(" WHERE COMPNO = ?   \r\n");
        query.append("   AND COMPAYNY_GOODS_CD = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getStatus(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getCompayny_goods_cd()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateProductInfoByExcelUpload(ProductDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODINFO \t\t \r\n");
        query.append("   SET STATUS = ?   \t\t \r\n");
        query.append("     , GOODS_KEYWORD = ?   \r\n");
        query.append(" WHERE COMPNO = ?   \r\n");
        query.append("   AND COMPAYNY_GOODS_CD = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getStatus(), dto.getGoods_keyword(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getCompayny_goods_cd()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int insertProductIn(ProductDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append(DataHelper.getQueryInsertColumns(DBCode.SHOPPRODIN.tableName));
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getGoods_nm(), dto.getShopcd(), dto.getPRODSEQ(), dto.getSHOP_USERID(), StringHelper.isNullString(dto.getShopseq(), "0"), dto.getShopprodno(), StringHelper.isNullString(dto.getSeq(), "0"), dto.getShopcatcd(), dto.getGoods_keyword(), dto.getModel_nm(), dto.getBrand_nm(), dto.getCompayny_goods_cd(), dto.getGoods_search(), dto.getGoods_gubun(), dto.getShop_cid_info(), dto.getSelect_option(), dto.getText_option(), dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4(), dto.getGmcategnm(), dto.getPartner_id(), dto.getDpartner_id(), dto.getMaker(), dto.getOrigin(), dto.getMake_year(), dto.getMake_dm(), dto.getGoods_season(), dto.getSex(), dto.getStatus(), dto.getDeliv_able_region(), dto.getTax_yn(), dto.getDelv_type(), StringHelper.isNullString(dto.getDelv_cost(), "0"), dto.getDelv_r_cost(), StringHelper.isNullString(dto.getDelv_qty(), "0"), dto.getBanpum_area(), StringHelper.isNullString(dto.getGoods_cost(), "0"), StringHelper.isNullString(dto.getGoods_price(), "0"), StringHelper.isNullString(dto.getMarket_price(), "0"), StringHelper.isNullString(dto.getGoods_consumer_price(), "0"), StringHelper.isNullString(dto.getIslimit(), "0"), StringHelper.isNullString(dto.getLimit_price(), "0"), StringHelper.isNullString(dto.getIs_overseas(), "0"), StringHelper.isNullString(dto.getAdult(), "0"), StringHelper.isNullString(dto.getIsreturn(), "0"), StringHelper.isNullString(dto.getItype(), "0"), dto.getOptionYN(), dto.getChar_1_nm(), dto.getChar_1_val(), dto.getChar_2_nm(), dto.getChar_2_val(), dto.getImg_path(), dto.getImg_path1(), dto.getImg_path2(), dto.getImg_path3(), dto.getImg_path4(), dto.getImg_path5(), dto.getImg_path6(), dto.getImg_path7(), dto.getImg_path8(), dto.getImg_path9(), dto.getImg_path10(), dto.getImg_path11(), dto.getImg_path12(), dto.getImg_path13(), dto.getImg_path14(), dto.getImg_path15(), dto.getImg_path16(), dto.getImg_path17(), dto.getImg_path18(), dto.getImg_path19(), dto.getImg_path20(), dto.getImg_path21(), dto.getImg_path22(), dto.getImg_path23(), dto.getImg_path24(), dto.getGoods_remarks(), dto.getCert_type(), dto.getCert(), dto.getCertno(), dto.getAvlst_dm(), dto.getAvled_dm(), dto.getIssuedate(), dto.getCertdate(), dto.getCert_agency(), dto.getCertfield(), dto.getCertmodel(), dto.getCertname(), dto.getExemptiontype(), dto.getMaterial(), dto.getStock_use_yn(), dto.getOpt_type(), dto.getProp_edit_yn(), dto.getProp1_cd(), dto.getProp_val1(), dto.getProp_val2(), dto.getProp_val3(), dto.getProp_val4(), dto.getProp_val5(), dto.getProp_val6(), dto.getProp_val7(), dto.getProp_val8(), dto.getProp_val9(), dto.getProp_val10(), dto.getProp_val11(), dto.getProp_val12(), dto.getProp_val13(), dto.getProp_val14(), dto.getProp_val15(), dto.getProp_val16(), dto.getProp_val17(), dto.getProp_val18(), dto.getProp_val19(), dto.getProp_val20(), dto.getProp_val21(), dto.getProp_val22(), dto.getProp_val23(), dto.getProp_val24(), dto.getProp_val25(), dto.getProp_val26(), dto.getProp_val27(), dto.getProp_val28(), dto.getPack_code_str(), dto.getGoods_nm_en(), dto.getGoods_nm_pr(), dto.getGoods_remarks2(), dto.getGoods_remarks3(), dto.getGoods_remarks4(), dto.getImportno(), dto.getGoods_cost2(), dto.getOrigin2(), dto.getExpire_dm(), dto.getSupply_save_yn(), StringHelper.isNullString(dto.getDescrition(), "0"), dto.getInsertdt(), YDMASessonUtil.getUserInfo().getUserId(), dto.getInsertdt(), dto.getModifyid(), dto.getSaleenddt(), StringHelper.isNullString(dto.getSendstats(), "-1"), dto.getShopmodifycontent(), dto.getSelfmod_no()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateProductIn(ProductDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN \r\n");
        query.append("   SET STATUS = ?   \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        query.append("   AND PRODSEQ = ?  \r\n");
        query.append("   AND SHOPSEQ = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getStatus(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getShopcd(), dto.getPRODSEQ(), dto.getShopseq()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateProductInByExcelUpload(ProductDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN \r\n");
        query.append("   SET STATUS = ?   \r\n");
        query.append("     , GOODS_KEYWORD = ?   \r\n");
        query.append(" WHERE COMPNO = ?  \t\t \r\n");
        query.append("   AND PRODSEQ = ?  \t\t \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getStatus(), dto.getGoods_keyword(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getPRODSEQ()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public ProductDTO selectProductInfo(String code) {
        ProductDTO result = null;
        QueryRunner runner = new QueryRunner();
        BeanHandler handler = new BeanHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(PRODSEQ, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS PRODSEQ  \r\n");
                query.append("    , IFNULL(COMPAYNY_GOODS_CD, '')   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(COMPNO, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPNO  \r\n");
                query.append("    , CONCAT(IFNULL(CLASS_CD1, ''), IFNULL(CLASS_CD2, ''), IFNULL(CLASS_CD3, ''), IFNULL(CLASS_CD4, '')) AS CODE  \r\n");
                query.append("    , '0' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOPCD  \r\n");
                query.append("    , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_USERID  \r\n");
                query.append("    , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS IMG  \r\n");
                query.append("    , IFNULL(GOODS_KEYWORD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_KEYWORD  \r\n");
                query.append("    , IFNULL(GOODS_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_NM  \r\n");
                query.append("    , IFNULL(MODEL_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS MODEL_NM  \r\n");
                query.append("    , IFNULL(BRAND_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS BRAND_NM  \r\n");
                query.append("    , IFNULL(GOODS_SEARCH, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_SEARCH  \r\n");
                query.append("    , IFNULL(GOODS_GUBUN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_GUBUN  \r\n");
                query.append("    , IFNULL(SHOP_CID_INFO, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_CID_INFO  \r\n");
                query.append("    , IFNULL(CLASS_CD1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD1  \r\n");
                query.append("    , IFNULL(CLASS_CD2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD2  \r\n");
                query.append("    , IFNULL(CLASS_CD3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD3  \r\n");
                query.append("    , IFNULL(CLASS_CD4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CLASS_CD4  \r\n");
                query.append("    , IFNULL(PARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PARTNER_ID  \r\n");
                query.append("    , IFNULL(DPARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DPARTNER_ID  \r\n");
                query.append("    , IFNULL(MAKER, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS MAKER  \r\n");
                query.append("    , IFNULL(ORIGIN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ORIGIN  \r\n");
                query.append("    , IFNULL(MAKE_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MAKE_DM  \r\n");
                query.append("    , IFNULL(SEX, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEX  \r\n");
                query.append("    , IFNULL(STATUS, '') \t\t \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS STATUS  \r\n");
                query.append("    , IFNULL(DELIV_ABLE_REGION, '')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELIV_ABLE_REGION  \r\n");
                query.append("    , IFNULL(TAX_YN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS TAX_YN  \r\n");
                query.append("    , IFNULL(CERT, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT  \r\n");
                query.append("    , IFNULL(ISLIMIT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISLIMIT  \r\n");
                query.append("    , IFNULL(LIMIT_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS LIMIT_PRICE  \r\n");
                query.append("    , IFNULL(IS_OVERSEAS, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IS_OVERSEAS  \r\n");
                query.append("    , IFNULL(ITYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ITYPE  \r\n");
                query.append("    , IFNULL(ADULT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ADULT  \r\n");
                query.append("    , IFNULL(ISRETURN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISRETURN  \r\n");
                query.append("    , IFNULL(TEXT_OPTION, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS TEXT_OPTION  \r\n");
                query.append("    , IFNULL(DELV_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_TYPE  \r\n");
                query.append("    , IFNULL(DELV_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DELV_COST  \r\n");
                query.append("    , IFNULL(RETURN_DELV_COST, '0')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS RETURN_DELV_COST  \r\n");
                query.append("    , IFNULL(BANPUM_AREA, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS BANPUM_AREA  \r\n");
                query.append("    , IFNULL(GOODS_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_COST  \r\n");
                query.append("    , IFNULL(GOODS_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_PRICE  \r\n");
                query.append("    , IFNULL(GOODS_CONSUMER_PRICE, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_CONSUMER_PRICE  \r\n");
                query.append("    , IFNULL(CHAR_1_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_NM  \r\n");
                query.append("    , IFNULL(CHAR_1_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_VAL  \r\n");
                query.append("    , IFNULL(CHAR_2_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_NM  \r\n");
                query.append("    , IFNULL(CHAR_2_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_VAL  \r\n");
                query.append("    , IFNULL(IMG_PATH, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMG_PATH  \r\n");
                query.append("    , IFNULL(IMG_PATH1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH1  \r\n");
                query.append("    , IFNULL(IMG_PATH2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH2  \r\n");
                query.append("    , IFNULL(IMG_PATH3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH3  \r\n");
                query.append("    , IFNULL(IMG_PATH4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH4  \r\n");
                query.append("    , IFNULL(IMG_PATH5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH5  \r\n");
                query.append("    , IFNULL(IMG_PATH6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH6  \r\n");
                query.append("    , IFNULL(IMG_PATH7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH7  \r\n");
                query.append("    , IFNULL(IMG_PATH8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH8  \r\n");
                query.append("    , IFNULL(IMG_PATH9, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH9  \r\n");
                query.append("    , IFNULL(IMG_PATH10, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH10  \r\n");
                query.append("    , IFNULL(IMG_PATH11, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH11  \r\n");
                query.append("    , IFNULL(IMG_PATH12, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH12  \r\n");
                query.append("    , IFNULL(GOODS_REMARKS, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_REMARKS  \r\n");
                query.append("    , IFNULL(CERT_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERT_TYPE  \r\n");
                query.append("    , IFNULL(CERTNO, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTNO  \r\n");
                query.append("    , IFNULL(AVLST_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLST_DM  \r\n");
                query.append("    , IFNULL(AVLED_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLED_DM  \r\n");
                query.append("    , IFNULL(ISSUEDATE, '') \t       \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ISSUEDATE  \r\n");
                query.append("    , IFNULL(CERTDATE, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTDATE  \r\n");
                query.append("    , IFNULL(CERT_AGENCY, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT_AGENCY  \r\n");
                query.append("    , IFNULL(CERTFIELD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTFIELD  \r\n");
                query.append("    , IFNULL(CERTMODEL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTMODEL  \r\n");
                query.append("    , IFNULL(CERTNAME, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTNAME  \r\n");
                query.append("    , IFNULL(EXEMPTIONTYPE, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXEMPTIONTYPE  \r\n");
                query.append("    , IFNULL(MATERIAL, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MATERIAL  \r\n");
                query.append("    , IFNULL(STOCK_USE_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS STOCK_USE_YN  \r\n");
                query.append("    , IFNULL(OPT_TYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS OPT_TYPE  \r\n");
                query.append("    , IFNULL(PROP_EDIT_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP_EDIT_YN  \r\n");
                query.append("    , IFNULL(PROP1_CD, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP1_CD  \r\n");
                query.append("    , IFNULL(PROP_VAL1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL1  \r\n");
                query.append("    , IFNULL(PROP_VAL2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL2  \r\n");
                query.append("    , IFNULL(PROP_VAL3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL3  \r\n");
                query.append("    , IFNULL(PROP_VAL4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL4  \r\n");
                query.append("    , IFNULL(PROP_VAL5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL5  \r\n");
                query.append("    , IFNULL(PROP_VAL6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL6  \r\n");
                query.append("    , IFNULL(PROP_VAL7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL7  \r\n");
                query.append("    , IFNULL(PROP_VAL8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL8  \r\n");
                query.append("    , IFNULL(PROP_VAL9, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL9  \r\n");
                query.append("    , IFNULL(PROP_VAL10, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL10  \r\n");
                query.append("    , IFNULL(PROP_VAL11, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL11  \r\n");
                query.append("    , IFNULL(PROP_VAL12, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL12  \r\n");
                query.append("    , IFNULL(PROP_VAL13, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL13  \r\n");
                query.append("    , IFNULL(PROP_VAL14, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL14  \r\n");
                query.append("    , IFNULL(PROP_VAL15, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL15  \r\n");
                query.append("    , IFNULL(PROP_VAL16, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL16  \r\n");
                query.append("    , IFNULL(PROP_VAL17, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL17  \r\n");
                query.append("    , IFNULL(PROP_VAL18, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL18  \r\n");
                query.append("    , IFNULL(PROP_VAL19, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL19  \r\n");
                query.append("    , IFNULL(PROP_VAL20, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL20  \r\n");
                query.append("    , IFNULL(PROP_VAL21, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL21  \r\n");
                query.append("    , IFNULL(PROP_VAL22, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL22  \r\n");
                query.append("    , IFNULL(PROP_VAL23, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL23  \r\n");
                query.append("    , IFNULL(PROP_VAL24, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL24  \r\n");
                query.append("    , IFNULL(PROP_VAL25, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL25  \r\n");
                query.append("    , IFNULL(PROP_VAL26, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL26  \r\n");
                query.append("    , IFNULL(PROP_VAL27, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL27  \r\n");
                query.append("    , IFNULL(PROP_VAL28, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL28  \r\n");
                query.append("    , IFNULL(PACK_CODE_STR, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PACK_CODE_STR  \r\n");
                query.append("    , IFNULL(IMPORTNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMPORTNO  \r\n");
                query.append("    , IFNULL(GOODS_COST2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_COST2  \r\n");
                query.append("    , IFNULL(ORIGIN2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ORIGIN2  \r\n");
                query.append("    , IFNULL(EXPIRE_DM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXPIRE_DM  \r\n");
                query.append("    , IFNULL(SUPPLY_SAVE_YN, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SUPPLY_SAVE_YN  \r\n");
                query.append("    , IFNULL(DESCRITION, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DESCRITION  \r\n");
                query.append("    , IFNULL(SHOPPRODNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(INSERTDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTDT  \r\n");
                query.append("    , IFNULL(INSERTID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTID  \r\n");
                query.append("    , IFNULL(MODIFYDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYDT  \r\n");
                query.append("    , IFNULL(MODIFYID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYID  \r\n");
                query.append("    , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SEQ  \r\n");
                query.append("    , IFNULL(SHOPSENDSTATUS, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSTATS  \r\n");
                query.append("    , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPSEQ  \r\n");
                query.append("    , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SALEENDDT  \r\n");
                query.append("    , IFNULL(DELV_QTY, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_QTY  \r\n");
                query.append("    , IFNULL(GMCATEGNM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GMCATEGNM  \r\n");
                query.append("    , IFNULL(SHOPMODIFYCONTENT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPMODIFYCONTENT  \r\n");
                query.append("    , IFNULL(SELFMOD_NO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SELFMOD_NO  \r\n");
                query.append("    , '' \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSEQ  \r\n");
                query.append("  FROM shopprodinfo  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND COMPAYNY_GOODS_CD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), code};
                result = (ProductDTO)runner.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ProductDTO selectProductIn(ShoppingmallDTO shopInfo, String prodseq) {
        ProductDTO result = null;
        QueryRunner runner = new QueryRunner();
        BeanHandler handler = new BeanHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(PRODSEQ, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS PRODSEQ  \r\n");
                query.append("    , IFNULL(COMPAYNY_GOODS_CD, '')   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(COMPNO, '') \t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t       AS COMPNO  \r\n");
                query.append("    , CONCAT(IFNULL(CLASS_CD1, ''), IFNULL(CLASS_CD2, ''), IFNULL(CLASS_CD3, ''), IFNULL(CLASS_CD4, '')) AS CODE  \r\n");
                query.append("    , IFNULL(SHOPCD, '') \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t   AS SHOPCD  \r\n");
                query.append("    , IFNULL(SHOP_USERID,'' ) \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t   AS SHOP_USERID  \r\n");
                query.append("    , '' \t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS IMG  \r\n");
                query.append("    , IFNULL(GOODS_KEYWORD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_KEYWORD  \r\n");
                query.append("    , IFNULL(GOODS_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_NM  \r\n");
                query.append("    , IFNULL(MODEL_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS MODEL_NM  \r\n");
                query.append("    , IFNULL(BRAND_NM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS BRAND_NM  \r\n");
                query.append("    , IFNULL(GOODS_SEARCH, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_SEARCH  \r\n");
                query.append("    , IFNULL(GOODS_GUBUN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS GOODS_GUBUN  \r\n");
                query.append("    , IFNULL(SHOP_CID_INFO, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS SHOP_CID_INFO  \r\n");
                query.append("    , IFNULL(CLASS_CD1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD1  \r\n");
                query.append("    , IFNULL(CLASS_CD2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD2  \r\n");
                query.append("    , IFNULL(CLASS_CD3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   \t   AS CLASS_CD3  \r\n");
                query.append("    , IFNULL(CLASS_CD4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CLASS_CD4  \r\n");
                query.append("    , IFNULL(PARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PARTNER_ID  \r\n");
                query.append("    , IFNULL(DPARTNER_ID, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DPARTNER_ID  \r\n");
                query.append("    , IFNULL(MAKER, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS MAKER  \r\n");
                query.append("    , IFNULL(ORIGIN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ORIGIN  \r\n");
                query.append("    , IFNULL(MAKE_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MAKE_DM  \r\n");
                query.append("    , IFNULL(SEX, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEX  \r\n");
                query.append("    , IFNULL(STATUS, '') \t\t \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS STATUS  \r\n");
                query.append("    , IFNULL(DELIV_ABLE_REGION, '')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELIV_ABLE_REGION  \r\n");
                query.append("    , IFNULL(TAX_YN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS TAX_YN  \r\n");
                query.append("    , IFNULL(CERT, '') \t\t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT  \r\n");
                query.append("    , IFNULL(ISLIMIT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISLIMIT  \r\n");
                query.append("    , IFNULL(LIMIT_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS LIMIT_PRICE  \r\n");
                query.append("    , IFNULL(IS_OVERSEAS, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IS_OVERSEAS  \r\n");
                query.append("    , IFNULL(ITYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ITYPE  \r\n");
                query.append("    , IFNULL(ADULT, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ADULT  \r\n");
                query.append("    , IFNULL(ISRETURN, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ISRETURN  \r\n");
                query.append("    , IFNULL(TEXT_OPTION, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS TEXT_OPTION  \r\n");
                query.append("    , IFNULL(DELV_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_TYPE  \r\n");
                query.append("    , IFNULL(DELV_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DELV_COST  \r\n");
                query.append("    , IFNULL(RETURN_DELV_COST, '0')    \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS RETURN_DELV_COST  \r\n");
                query.append("    , IFNULL(BANPUM_AREA, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS BANPUM_AREA  \r\n");
                query.append("    , IFNULL(GOODS_COST, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_COST  \r\n");
                query.append("    , IFNULL(GOODS_PRICE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_PRICE  \r\n");
                query.append("    , IFNULL(MARKET_PRICE, '')                                                                          AS MARKET_PRICE  \r\n");
                query.append("    , IFNULL(GOODS_CONSUMER_PRICE, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_CONSUMER_PRICE  \r\n");
                query.append("    , IFNULL(CHAR_1_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_NM  \r\n");
                query.append("    , IFNULL(CHAR_1_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_1_VAL  \r\n");
                query.append("    , IFNULL(CHAR_2_NM, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_NM  \r\n");
                query.append("    , IFNULL(CHAR_2_VAL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CHAR_2_VAL  \r\n");
                query.append("    , IFNULL(IMG_PATH, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMG_PATH  \r\n");
                query.append("    , IFNULL(IMG_PATH1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH1  \r\n");
                query.append("    , IFNULL(IMG_PATH2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH2  \r\n");
                query.append("    , IFNULL(IMG_PATH3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH3  \r\n");
                query.append("    , IFNULL(IMG_PATH4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH4  \r\n");
                query.append("    , IFNULL(IMG_PATH5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH5  \r\n");
                query.append("    , IFNULL(IMG_PATH6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH6  \r\n");
                query.append("    , IFNULL(IMG_PATH7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH7  \r\n");
                query.append("    , IFNULL(IMG_PATH8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH8  \r\n");
                query.append("    , IFNULL(IMG_PATH9, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH9  \r\n");
                query.append("    , IFNULL(IMG_PATH10, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH10  \r\n");
                query.append("    , IFNULL(IMG_PATH11, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH11  \r\n");
                query.append("    , IFNULL(IMG_PATH12, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS IMG_PATH12  \r\n");
                query.append("    , IFNULL(GOODS_REMARKS, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GOODS_REMARKS  \r\n");
                query.append("    , IFNULL(CERT_TYPE, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERT_TYPE  \r\n");
                query.append("    , IFNULL(CERTNO, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTNO  \r\n");
                query.append("    , IFNULL(AVLST_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLST_DM  \r\n");
                query.append("    , IFNULL(AVLED_DM, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS AVLED_DM  \r\n");
                query.append("    , IFNULL(ISSUEDATE, '') \t       \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS ISSUEDATE  \r\n");
                query.append("    , IFNULL(CERTDATE, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTDATE  \r\n");
                query.append("    , IFNULL(CERT_AGENCY, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERT_AGENCY  \r\n");
                query.append("    , IFNULL(CERTFIELD, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTFIELD  \r\n");
                query.append("    , IFNULL(CERTMODEL, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS CERTMODEL  \r\n");
                query.append("    , IFNULL(CERTNAME, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS CERTNAME  \r\n");
                query.append("    , IFNULL(EXEMPTIONTYPE, '') \t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXEMPTIONTYPE  \r\n");
                query.append("    , IFNULL(MATERIAL, '')\t \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MATERIAL  \r\n");
                query.append("    , IFNULL(STOCK_USE_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS STOCK_USE_YN  \r\n");
                query.append("    , IFNULL(OPT_TYPE, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS OPT_TYPE  \r\n");
                query.append("    , IFNULL(PROP_EDIT_YN, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP_EDIT_YN  \r\n");
                query.append("    , IFNULL(PROP1_CD, '') \t\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS PROP1_CD  \r\n");
                query.append("    , IFNULL(PROP_VAL1, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL1  \r\n");
                query.append("    , IFNULL(PROP_VAL2, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL2  \r\n");
                query.append("    , IFNULL(PROP_VAL3, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL3  \r\n");
                query.append("    , IFNULL(PROP_VAL4, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL4  \r\n");
                query.append("    , IFNULL(PROP_VAL5, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL5  \r\n");
                query.append("    , IFNULL(PROP_VAL6, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL6  \r\n");
                query.append("    , IFNULL(PROP_VAL7, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL7  \r\n");
                query.append("    , IFNULL(PROP_VAL8, '') \t\t   \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL8  \r\n");
                query.append("    , IFNULL(PROP_VAL9, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL9  \r\n");
                query.append("    , IFNULL(PROP_VAL10, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL10  \r\n");
                query.append("    , IFNULL(PROP_VAL11, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL11  \r\n");
                query.append("    , IFNULL(PROP_VAL12, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL12  \r\n");
                query.append("    , IFNULL(PROP_VAL13, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL13  \r\n");
                query.append("    , IFNULL(PROP_VAL14, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL14  \r\n");
                query.append("    , IFNULL(PROP_VAL15, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL15  \r\n");
                query.append("    , IFNULL(PROP_VAL16, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL16  \r\n");
                query.append("    , IFNULL(PROP_VAL17, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL17  \r\n");
                query.append("    , IFNULL(PROP_VAL18, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL18  \r\n");
                query.append("    , IFNULL(PROP_VAL19, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL19  \r\n");
                query.append("    , IFNULL(PROP_VAL20, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL20  \r\n");
                query.append("    , IFNULL(PROP_VAL21, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL21  \r\n");
                query.append("    , IFNULL(PROP_VAL22, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL22  \r\n");
                query.append("    , IFNULL(PROP_VAL23, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL23  \r\n");
                query.append("    , IFNULL(PROP_VAL24, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL24  \r\n");
                query.append("    , IFNULL(PROP_VAL25, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL25  \r\n");
                query.append("    , IFNULL(PROP_VAL26, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL26  \r\n");
                query.append("    , IFNULL(PROP_VAL27, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL27  \r\n");
                query.append("    , IFNULL(PROP_VAL28, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PROP_VAL28  \r\n");
                query.append("    , IFNULL(PACK_CODE_STR, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS PACK_CODE_STR  \r\n");
                query.append("    , IFNULL(IMPORTNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS IMPORTNO  \r\n");
                query.append("    , IFNULL(GOODS_COST2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS GOODS_COST2  \r\n");
                query.append("    , IFNULL(ORIGIN2, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS ORIGIN2  \r\n");
                query.append("    , IFNULL(EXPIRE_DM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS EXPIRE_DM  \r\n");
                query.append("    , IFNULL(SUPPLY_SAVE_YN, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SUPPLY_SAVE_YN  \r\n");
                query.append("    , IFNULL(DESCRITION, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS DESCRITION  \r\n");
                query.append("    , IFNULL(SHOPPRODNO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(INSERTDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTDT  \r\n");
                query.append("    , IFNULL(INSERTID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS INSERTID  \r\n");
                query.append("    , IFNULL(MODIFYDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYDT  \r\n");
                query.append("    , IFNULL(MODIFYID, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS MODIFYID  \r\n");
                query.append("    , IFNULL(SEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SEQ  \r\n");
                query.append("    , IFNULL(SHOPSENDSTATUS, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SENDSTATS  \r\n");
                query.append("    , IFNULL(SHOPSEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(SALEENDDT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SALEENDDT  \r\n");
                query.append("    , IFNULL(DELV_QTY, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS DELV_QTY  \r\n");
                query.append("    , IFNULL(GMCATEGNM, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS GMCATEGNM  \r\n");
                query.append("    , IFNULL(SHOPMODIFYCONTENT, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SHOPMODIFYCONTENT  \r\n");
                query.append("    , IFNULL(SELFMOD_NO, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t   AS SELFMOD_NO  \r\n");
                query.append("    , IFNULL(SENDSEQ, '') \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   AS SENDSEQ  \r\n");
                query.append("  FROM shopprodin  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                query.append("   AND SHOPSEQ = ?  \r\n");
                query.append("   AND PRODSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), shopInfo.getSHOPCD(), shopInfo.getSHOPSEQ(), prodseq};
                result = (ProductDTO)runner.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String selectProductProdSeq(String code) {
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(PRODSEQ, 0) AS PRODSEQ  \r\n");
                query.append("  FROM shopprodinfo  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND COMPAYNY_GOODS_CD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), code};
                ProductDTO result = (ProductDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
                return result.getPRODSEQ();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean isNotExistsProductInfo(String code) {
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(PRODSEQ, 0) AS PRODSEQ  \r\n");
                query.append("  FROM shopprodinfo  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND COMPAYNY_GOODS_CD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), code};
                ProductDTO result = (ProductDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
                boolean bl = result == null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isNotExistsProductIn(ShoppingmallDTO shopInfo, String code) {
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ProductDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(SENDSEQ, 0) AS SENDSEQ  \r\n");
                query.append("  FROM shopprodin  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                query.append("   AND SHOPSEQ = ?  \r\n");
                query.append("   AND COMPAYNY_GOODS_CD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), shopInfo.getSHOPCD(), shopInfo.getSHOPSEQ(), code};
                ProductDTO result = (ProductDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
                boolean bl = result == null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isNotExistsOptProductInfo(int skuseq, String compayny_goods_cd) {
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(PRODSEQ, 0) AS PRODSEQ  \r\n");
                query.append("  FROM shop_optprodinfo  \r\n");
                query.append(" WHERE SKUSEQ = ?  \r\n");
                query.append("   AND PRODCD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{skuseq, compayny_goods_cd};
                ProductOptionDTO result = (ProductOptionDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
                boolean bl = result == null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isNotExistsOptProductIn(int skuseq, String shopprodno) {
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(SENDSEQ, 0) AS SENDSEQ  \r\n");
                query.append("  FROM shop_optprodin  \r\n");
                query.append(" WHERE SKUSEQ = ?  \r\n");
                query.append("   AND SHOPPRODNO = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{skuseq, shopprodno};
                ProductOptionDTO result = (ProductOptionDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
                boolean bl = result == null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<ProductOptionDTO> selectOptProductIn(String sendseq) {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(SENDSEQ, '')        AS SENDSEQ  \r\n");
                query.append("    , IFNULL(PRODSEQ, '')        AS PRODSEQ  \r\n");
                query.append("    , IFNULL(SKUSEQ, '')         AS SKUSEQ  \r\n");
                query.append("    , IFNULL(COMPNO, '')         AS COMPNO  \r\n");
                query.append("    , IFNULL(SHOPPRODNO, '')     AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(SHOPPRODSKU, '')    AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(SHOPPRODSKU_NM, '') AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(OPTPRODCD, '')      AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(OPTPRODNM, '')      AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(OPTSPECDES, '')     AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(OPTEA, '')          AS OPTEA  \r\n");
                query.append("    , IFNULL(OPTSAFESTOCK, '')   AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(OPTVERTSTOCK, '')   AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(OPTADDAMT, '')      AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(INSERTDT, '')       AS INSERTDT  \r\n");
                query.append("    , IFNULL(INSERTID, '')       AS INSERTID  \r\n");
                query.append("    , IFNULL(MODIFYDT, '')       AS MODIFYDT  \r\n");
                query.append("    , IFNULL(MODIFYID, '')       AS MODIFYID  \r\n");
                query.append("  FROM shop_optprodin  \r\n");
                query.append(" WHERE SENDSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{sendseq};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ProductOptionDTO selectOptProductInfo(String prodseq, int skuseq) {
        ProductOptionDTO result = null;
        QueryRunner runner = new QueryRunner();
        BeanHandler handler = new BeanHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(PRODSEQ, '')        AS PRODSEQ  \r\n");
                query.append("    , IFNULL(SKUSEQ, '')         AS SKUSEQ  \r\n");
                query.append("    , IFNULL(COMPNO, '')         AS COMPNO  \r\n");
                query.append("    , IFNULL(PRODCD, '')         AS PRODCD  \r\n");
                query.append("    , IFNULL(OPTPRODCD, '')      AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(OPTPRODNM, '')      AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(OPTSPECDES, '')     AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(OPTEA, '')          AS OPTEA  \r\n");
                query.append("    , IFNULL(OPTSAFESTOCK, '')   AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(OPTVERTSTOCK, '')   AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(OPTADDAMT, '')      AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(INSERTDT, '')       AS INSERTDT  \r\n");
                query.append("    , IFNULL(INSERTID, '')       AS INSERTID  \r\n");
                query.append("    , IFNULL(MODIFYDT, '')       AS MODIFYDT  \r\n");
                query.append("    , IFNULL(MODIFYID, '')       AS MODIFYID  \r\n");
                query.append("    , IFNULL(STATUS, '')         AS STATUS  \r\n");
                query.append("  FROM shop_optprodinfo  \r\n");
                query.append(" WHERE PRODSEQ = ?  \r\n");
                query.append("   AND SKUSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{prodseq, skuseq};
                result = (ProductOptionDTO)runner.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ProductOptionDTO selectOptProductIn(String sendseq, int skuseq) {
        ProductOptionDTO result = null;
        QueryRunner runner = new QueryRunner();
        BeanHandler handler = new BeanHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(SENDSEQ, '')        AS SENDSEQ  \r\n");
                query.append("    , IFNULL(PRODSEQ, '')        AS PRODSEQ  \r\n");
                query.append("    , IFNULL(SKUSEQ, '')         AS SKUSEQ  \r\n");
                query.append("    , IFNULL(COMPNO, '')         AS COMPNO  \r\n");
                query.append("    , IFNULL(SHOPPRODNO, '')     AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(SHOPPRODSKU, '')    AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(SHOPPRODSKU_NM, '') AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(OPTPRODCD, '')      AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(OPTPRODNM, '')      AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(OPTSPECDES, '')     AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(OPTEA, '')          AS OPTEA  \r\n");
                query.append("    , IFNULL(OPTSAFESTOCK, '')   AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(OPTVERTSTOCK, '')   AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(OPTADDAMT, '')      AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(INSERTDT, '')       AS INSERTDT  \r\n");
                query.append("    , IFNULL(INSERTID, '')       AS INSERTID  \r\n");
                query.append("    , IFNULL(MODIFYDT, '')       AS MODIFYDT  \r\n");
                query.append("    , IFNULL(MODIFYID, '')       AS MODIFYID  \r\n");
                query.append("    , IFNULL(STATUS, '')         AS STATUS  \r\n");
                query.append("  FROM shop_optprodin  \r\n");
                query.append(" WHERE SENDSEQ = ?  \r\n");
                query.append("   AND SKUSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{sendseq, skuseq};
                result = (ProductOptionDTO)runner.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int insertOptProductInfo(ProductOptionDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append(DataHelper.getQueryInsertColumns(DBCode.SHOP_OPTPRODINFO.tableName));
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getPRODSEQ(), dto.getSKUSEQ(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getCOMPAYNY_GOODS_CD(), dto.getOPTPRODCD(), dto.getOPTPRODNM(), dto.getOPTSPECDES(), dto.getOPTEA(), dto.getOPTSAFESTOCK(), dto.getOPTVERTSTOCK(), dto.getOPTADDAMT(), dto.getINSERTDT(), dto.getINSERTID(), dto.getMODIFYDT(), dto.getMODIFYID(), dto.getSTATUS()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int insertOptProductIn(ProductOptionDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append(DataHelper.getQueryInsertColumns(DBCode.SHOP_OPTPRODIN.tableName));
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getSENDSEQ(), dto.getSKUSEQ(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getSHOPPRODNO(), dto.getSHOPPRODSKU(), dto.getSHOPPRODSKU_NM(), dto.getPRODSEQ(), dto.getOPTPRODCD(), dto.getOPTPRODNM(), dto.getOPTSPECDES(), dto.getOPTEA(), dto.getOPTSAFESTOCK(), dto.getOPTVERTSTOCK(), dto.getOPTADDAMT(), YDMATimeUtil.getCurrentTimeByYDFormat(), YDMASessonUtil.getUserInfo().getUserId(), YDMATimeUtil.getCurrentTimeByYDFormat(), YDMASessonUtil.getUserInfo().getUserId(), dto.getSTATUS()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateOptProductInfo(ProductOptionDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append(DataHelper.getQueryUpdateColumns(DBCode.SHOP_OPTPRODINFO.tableName));
        query.append(" WHERE PRODSEQ = ?  \r\n");
        query.append("   AND SKUSEQ = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getPRODCD(), dto.getOPTPRODCD(), dto.getOPTPRODNM(), dto.getOPTSPECDES(), dto.getOPTEA(), dto.getOPTSAFESTOCK(), dto.getOPTVERTSTOCK(), dto.getOPTADDAMT(), dto.getINSERTDT(), dto.getINSERTID(), YDMATimeUtil.getCurrentTimeByYDFormat(), YDMASessonUtil.getUserInfo().getUserId(), dto.getSTATUS(), dto.getPRODSEQ(), dto.getSKUSEQ()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateOptProductIn(ProductOptionDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append(DataHelper.getQueryUpdateColumns(DBCode.SHOP_OPTPRODIN.tableName));
        query.append(" WHERE SENDSEQ = ?  \r\n");
        query.append("   AND SKUSEQ = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getSHOPPRODNO(), dto.getSHOPPRODSKU(), dto.getSHOPPRODSKU_NM(), dto.getPRODSEQ(), dto.getOPTPRODCD(), dto.getOPTPRODNM(), dto.getOPTSPECDES(), dto.getOPTEA(), dto.getOPTSAFESTOCK(), dto.getOPTVERTSTOCK(), dto.getOPTADDAMT(), YDMATimeUtil.getCurrentTimeByYDFormat(), YDMASessonUtil.getUserInfo().getUserId(), YDMATimeUtil.getCurrentTimeByYDFormat(), YDMASessonUtil.getUserInfo().getUserId(), dto.getSTATUS(), dto.getSENDSEQ(), dto.getSKUSEQ()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public List<ProductOptionDTO> selectSaleProductOption() {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(B.SHOPCD, '')            AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '')           AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SHOP_USERID, '')       AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.COMPAYNY_GOODS_CD, '') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(A.SENDSEQ, 0)            AS SENDSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODNO, '')        AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU, '')       AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU_NM, '')    AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSALE, '')           AS OPTSALE  \r\n");
                query.append("    , IFNULL(A.OPTSALEOUT, '')        AS OPTSALEOUT  \r\n");
                query.append("    , IFNULL(A.OPTNOTUSE, '')         AS OPTNOTUSE  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.OPTDELYN, '')          AS OPTDELYN  \r\n");
                query.append("    , IFNULL(A.BARCODE, '')           AS BARCODE  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(A.STATUS, '')            AS STATUS  \r\n");
                query.append("  FROM shop_optprodin AS A  \r\n");
                query.append("  JOIN shopprodin AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append(" WHERE A.STATUS = '1'  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectSaleProductOption(String shopCode, int shopSeq) {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(B.SHOPCD, '')            AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '')           AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SHOP_USERID, '')       AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.COMPAYNY_GOODS_CD, '') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(A.SENDSEQ, 0)            AS SENDSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODNO, '')        AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU, '')       AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU_NM, '')    AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSALE, '')           AS OPTSALE  \r\n");
                query.append("    , IFNULL(A.OPTSALEOUT, '')        AS OPTSALEOUT  \r\n");
                query.append("    , IFNULL(A.OPTNOTUSE, '')         AS OPTNOTUSE  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.OPTDELYN, '')          AS OPTDELYN  \r\n");
                query.append("    , IFNULL(A.BARCODE, '')           AS BARCODE  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(A.STATUS, '')            AS STATUS  \r\n");
                query.append("  FROM shop_optprodin AS A  \r\n");
                query.append("  JOIN shopprodin AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append(" WHERE A.STATUS = '1'  \r\n");
                query.append("   AND B.SHOPCD = ?  \r\n");
                query.append("   AND B.SHOPSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{shopCode, shopSeq};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectAllOptProductInBySellerProdCode(String compayny_goods_cd) {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(B.SHOPCD, '')            AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '')           AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SHOP_USERID, '')       AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.COMPAYNY_GOODS_CD, '') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(A.SENDSEQ, 0)            AS SENDSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODNO, '')        AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU, '')       AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU_NM, '')    AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSALE, '')           AS OPTSALE  \r\n");
                query.append("    , IFNULL(A.OPTSALEOUT, '')        AS OPTSALEOUT  \r\n");
                query.append("    , IFNULL(A.OPTNOTUSE, '')         AS OPTNOTUSE  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.OPTDELYN, '')          AS OPTDELYN  \r\n");
                query.append("    , IFNULL(A.BARCODE, '')           AS BARCODE  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(A.STATUS, '')            AS STATUS  \r\n");
                query.append("  FROM shop_optprodin AS A  \r\n");
                query.append("  JOIN shopprodin AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append(" WHERE A.OPTPRODCD LIKE '%" + compayny_goods_cd + "%'  \r\n");
                query.append("   AND A.STATUS = '1'  \r\n");
                query.append(" ORDER BY SENDSEQ, SKUSEQ  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectOptProductInCount(String searchText, String column) {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query;
                block25: {
                    query = new StringBuilder();
                    query.append("SELECT  \r\n");
                    query.append("      IFNULL(B.SHOPCD, '')      AS SHOPCD  \r\n");
                    query.append("    , IFNULL(B.SHOP_USERID, '') AS SHOPPINGID  \r\n");
                    query.append("    , COUNT(*)\t\t\t      AS COUNTS  \r\n");
                    query.append("  FROM shop_optprodin AS A  \r\n");
                    query.append("  JOIN shopprodin AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                    query.append(" WHERE A.STATUS = '1'  \r\n");
                    if (searchText.equals("")) break block25;
                    switch (column) {
                        case "COMPAYNY_GOODS_CD": {
                            query.append("   AND A.OPTPRODCD LIKE '%" + searchText + "%'  \r\n");
                            break;
                        }
                        case "SHOPPRODNO": {
                            query.append("   AND A.SHOPPRODNO LIKE '%" + searchText + "%'  \r\n");
                            break;
                        }
                        case "GOODS_NM": {
                            query.append("   AND A.SHOPPRODSKU_NM LIKE '%" + searchText + "%'  \r\n");
                        }
                    }
                }
                query.append(" GROUP BY B.SHOPCD, B.SHOP_USERID  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectOptProductInBySellerProdCode(String compayny_goods_cd, int end) {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(B.SHOPCD, '')            AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '')           AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SHOP_USERID, '')       AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.COMPAYNY_GOODS_CD, '') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(A.SENDSEQ, 0)            AS SENDSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODNO, '')        AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU, '')       AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU_NM, '')    AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSALE, '')           AS OPTSALE  \r\n");
                query.append("    , IFNULL(A.OPTSALEOUT, '')        AS OPTSALEOUT  \r\n");
                query.append("    , IFNULL(A.OPTNOTUSE, '')         AS OPTNOTUSE  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.OPTDELYN, '')          AS OPTDELYN  \r\n");
                query.append("    , IFNULL(A.BARCODE, '')           AS BARCODE  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(A.STATUS, '')            AS STATUS  \r\n");
                query.append("  FROM shop_optprodin AS A  \r\n");
                query.append("  JOIN shopprodin AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append(" WHERE A.OPTPRODCD LIKE '%" + compayny_goods_cd + "%'  \r\n");
                query.append("   AND A.STATUS = '1'  \r\n");
                query.append(" ORDER BY SENDSEQ, SKUSEQ  \r\n");
                query.append(" LIMIT 0, ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{end};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectOptProductInBySellerProdCode(String compayny_goods_cd, int start, int max) {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(B.SHOPCD, '')            AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '')           AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SHOP_USERID, '')       AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.COMPAYNY_GOODS_CD, '') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(A.SENDSEQ, 0)            AS SENDSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODNO, '')        AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU, '')       AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU_NM, '')    AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSALE, '')           AS OPTSALE  \r\n");
                query.append("    , IFNULL(A.OPTSALEOUT, '')        AS OPTSALEOUT  \r\n");
                query.append("    , IFNULL(A.OPTNOTUSE, '')         AS OPTNOTUSE  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.OPTDELYN, '')          AS OPTDELYN  \r\n");
                query.append("    , IFNULL(A.BARCODE, '')           AS BARCODE  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(A.STATUS, '')            AS STATUS  \r\n");
                query.append("  FROM shop_optprodin AS A  \r\n");
                query.append("  JOIN shopprodin AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append(" WHERE A.OPTPRODCD LIKE '%" + compayny_goods_cd + "%'  \r\n");
                query.append("   AND A.STATUS = '1'  \r\n");
                query.append(" ORDER BY SENDSEQ, SKUSEQ  \r\n");
                query.append(" LIMIT ?, ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{start, max};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectOptProductInByShopProdCode(String shopprodno, int end) {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(B.SHOPCD, '')            AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '')           AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SHOP_USERID, '')       AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.COMPAYNY_GOODS_CD, '') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(A.SENDSEQ, 0)            AS SENDSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODNO, '')        AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU, '')       AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU_NM, '')    AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSALE, '')           AS OPTSALE  \r\n");
                query.append("    , IFNULL(A.OPTSALEOUT, '')        AS OPTSALEOUT  \r\n");
                query.append("    , IFNULL(A.OPTNOTUSE, '')         AS OPTNOTUSE  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.OPTDELYN, '')          AS OPTDELYN  \r\n");
                query.append("    , IFNULL(A.BARCODE, '')           AS BARCODE  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(A.STATUS, '')            AS STATUS  \r\n");
                query.append("  FROM shop_optprodin AS A  \r\n");
                query.append("  JOIN shopprodin AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append(" WHERE A.SHOPPRODNO LIKE '%" + shopprodno + "%'  \r\n");
                query.append("   AND A.STATUS = '1'  \r\n");
                query.append(" ORDER BY SENDSEQ, SKUSEQ  \r\n");
                query.append(" LIMIT 0, ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{end};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectOptProductInByShopProdCode(String shopprodno, int start, int max) {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(B.SHOPCD, '')            AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '')           AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SHOP_USERID, '')       AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.COMPAYNY_GOODS_CD, '') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(A.SENDSEQ, 0)            AS SENDSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODNO, '')        AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU, '')       AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU_NM, '')    AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSALE, '')           AS OPTSALE  \r\n");
                query.append("    , IFNULL(A.OPTSALEOUT, '')        AS OPTSALEOUT  \r\n");
                query.append("    , IFNULL(A.OPTNOTUSE, '')         AS OPTNOTUSE  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.OPTDELYN, '')          AS OPTDELYN  \r\n");
                query.append("    , IFNULL(A.BARCODE, '')           AS BARCODE  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(A.STATUS, '')            AS STATUS  \r\n");
                query.append("  FROM shop_optprodin AS A  \r\n");
                query.append("  JOIN shopprodin AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append(" WHERE A.SHOPPRODNO LIKE '%" + shopprodno + "%'  \r\n");
                query.append("   AND A.STATUS = '1'  \r\n");
                query.append(" ORDER BY SENDSEQ, SKUSEQ  \r\n");
                query.append(" LIMIT ?, ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{start, max};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectOptProductInByProdName(String goods_nm, int end) {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(B.SHOPCD, '')            AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '')           AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SHOP_USERID, '')       AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.COMPAYNY_GOODS_CD, '') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(A.SENDSEQ, 0)            AS SENDSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODNO, '')        AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU, '')       AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU_NM, '')    AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSALE, '')           AS OPTSALE  \r\n");
                query.append("    , IFNULL(A.OPTSALEOUT, '')        AS OPTSALEOUT  \r\n");
                query.append("    , IFNULL(A.OPTNOTUSE, '')         AS OPTNOTUSE  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.OPTDELYN, '')          AS OPTDELYN  \r\n");
                query.append("    , IFNULL(A.BARCODE, '')           AS BARCODE  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(A.STATUS, '')            AS STATUS  \r\n");
                query.append("  FROM shop_optprodin AS A  \r\n");
                query.append("  JOIN shopprodin AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append(" WHERE A.SHOPPRODSKU_NM LIKE '%" + goods_nm + "%'  \r\n");
                query.append("   AND A.STATUS = '1'  \r\n");
                query.append(" ORDER BY SENDSEQ, SKUSEQ  \r\n");
                query.append(" LIMIT 0, ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{end};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectOptProductInByProdName(String goods_nm, int start, int max) {
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(B.SHOPCD, '')            AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '')           AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SHOP_USERID, '')       AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.COMPAYNY_GOODS_CD, '') AS COMPAYNY_GOODS_CD  \r\n");
                query.append("    , IFNULL(A.SENDSEQ, 0)            AS SENDSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODNO, '')        AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU, '')       AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU_NM, '')    AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSALE, '')           AS OPTSALE  \r\n");
                query.append("    , IFNULL(A.OPTSALEOUT, '')        AS OPTSALEOUT  \r\n");
                query.append("    , IFNULL(A.OPTNOTUSE, '')         AS OPTNOTUSE  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.OPTDELYN, '')          AS OPTDELYN  \r\n");
                query.append("    , IFNULL(A.BARCODE, '')           AS BARCODE  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(A.STATUS, '')            AS STATUS  \r\n");
                query.append("  FROM shop_optprodin AS A  \r\n");
                query.append("  JOIN shopprodin AS B ON A.SENDSEQ = B.SENDSEQ  \r\n");
                query.append(" WHERE A.SHOPPRODSKU_NM LIKE '%" + goods_nm + "%'  \r\n");
                query.append("   AND A.STATUS = '1'  \r\n");
                query.append(" ORDER BY SENDSEQ, SKUSEQ  \r\n");
                query.append(" LIMIT ?, ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{start, max};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectAllOptProductInfoByProdSeq(List<String> prodseqs) {
        if (prodseqs.size() == 0) {
            return null;
        }
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder placeholders = new StringBuilder();
                int i = 0;
                while (i < prodseqs.size()) {
                    placeholders.append("?");
                    if (i < prodseqs.size() - 1) {
                        placeholders.append(",");
                    }
                    ++i;
                }
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      ''                              AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.PRODCD, '')            AS PRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(B.STATUS, '')            AS STATUS  \r\n");
                query.append("    , IFNULL(B.SHOPSENDSTATUS, 0)\t    AS SENDSTATUS\t\r\n");
                query.append("  FROM SHOP_OPTPRODINFO AS A  \r\n");
                query.append("  INNER JOIN SHOPPRODINFO AS B ON A.PRODSEQ = B.PRODSEQ");
                query.append(" WHERE A.PRODSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
                query.append(" ORDER BY PRODSEQ, SKUSEQ  \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<String> params = new ArrayList<String>();
                params.addAll(prodseqs);
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params.toArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ProductOptionDTO> selectAllOptProductInBySendSeq(List<String> sendseqs) {
        if (sendseqs.size() == 0) {
            return null;
        }
        List<ProductOptionDTO> result = new ArrayList<ProductOptionDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ProductOptionDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder placeholders = new StringBuilder();
                int i = 0;
                while (i < sendseqs.size()) {
                    placeholders.append("?");
                    if (i < sendseqs.size() - 1) {
                        placeholders.append(",");
                    }
                    ++i;
                }
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.SENDSEQ, 0)            AS SENDSEQ  \r\n");
                query.append("    , IFNULL(A.SKUSEQ, 0)             AS SKUSEQ  \r\n");
                query.append("    , IFNULL(A.COMPNO, '')            AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODNO, '')        AS SHOPPRODNO  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU, '')       AS SHOPPRODSKU  \r\n");
                query.append("    , IFNULL(A.SHOPPRODSKU_NM, '')    AS SHOPPRODSKU_NM  \r\n");
                query.append("    , IFNULL(A.PRODSEQ, 0)            AS PRODSEQ  \r\n");
                query.append("    , IFNULL(A.OPTPRODCD, '')         AS OPTPRODCD  \r\n");
                query.append("    , IFNULL(A.OPTPRODNM, '')         AS OPTPRODNM  \r\n");
                query.append("    , IFNULL(A.OPTSPECDES, '')        AS OPTSPECDES  \r\n");
                query.append("    , IFNULL(A.OPTEA, 0)              AS OPTEA  \r\n");
                query.append("    , IFNULL(A.OPTSALE, '')           AS OPTSALE  \r\n");
                query.append("    , IFNULL(A.OPTSALEOUT, '')        AS OPTSALEOUT  \r\n");
                query.append("    , IFNULL(A.OPTNOTUSE, '')         AS OPTNOTUSE  \r\n");
                query.append("    , IFNULL(A.OPTSAFESTOCK, 0)       AS OPTSAFESTOCK  \r\n");
                query.append("    , IFNULL(A.OPTVERTSTOCK, 0)       AS OPTVERTSTOCK  \r\n");
                query.append("    , IFNULL(A.OPTADDAMT, 0)          AS OPTADDAMT  \r\n");
                query.append("    , IFNULL(A.OPTDELYN, '')          AS OPTDELYN  \r\n");
                query.append("    , IFNULL(A.BARCODE, '')           AS BARCODE  \r\n");
                query.append("    , IFNULL(A.INSERTDT, '')          AS INSERTDT  \r\n");
                query.append("    , IFNULL(A.INSERTID, '')          AS INSERTID  \r\n");
                query.append("    , IFNULL(A.MODIFYDT, '')          AS MODIFYDT  \r\n");
                query.append("    , IFNULL(A.MODIFYID, '')          AS MODIFYID  \r\n");
                query.append("    , IFNULL(B.STATUS, '')            AS STATUS  \r\n");
                query.append("    , IFNULL(B.SHOPSENDSTATUS, 0)     AS SENDSTATUS  \r\n");
                query.append("  FROM SHOP_OPTPRODIN AS A  \r\n");
                query.append("  INNER JOIN SHOPPRODIN AS B on A.SENDSEQ = B.SENDSEQ \r\n");
                query.append(" WHERE A.SENDSEQ IN (").append((CharSequence)placeholders).append(")  \r\n");
                query.append(" ORDER BY SENDSEQ, SKUSEQ  \r\n");
                YDMAStringUtil.Print(query.toString());
                ArrayList<String> params = new ArrayList<String>();
                params.addAll(sendseqs);
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params.toArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateProductInShopSendStatus(int sendStatus, String sendseq) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN  \r\n");
        query.append("   SET SHOPSENDSTATUS = ?  \r\n");
        query.append(" WHERE SENDSEQ = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{sendStatus, sendseq};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateProductInfoByAlwayzAndToss(ProductDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODINFO \t\t   \r\n");
        query.append("   SET COMPAYNY_GOODS_CD = ? \r\n");
        query.append(" WHERE COMPNO = ? \t\t   \r\n");
        query.append("   AND COMPAYNY_GOODS_CD = ?  ");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getCompayny_goods_cd(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getShopprodno()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateProductInByAlwayzAndToss(ProductDTO dto, String alwayzAndTossProdSeq, int shopSeq) {
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN \t\t   \r\n");
        query.append("   SET COMPAYNY_GOODS_CD = ? \r\n");
        query.append("     , PRODSEQ = ? \t\t   \r\n");
        query.append("     , GOODS_KEYWORD = ? \t   \r\n");
        query.append(" WHERE SHOPCD = ? \t\t   \r\n");
        query.append("   AND COMPNO = ?  \t\t   \r\n");
        query.append("   AND COMPAYNY_GOODS_CD = ?  \r\n");
        query.append("   AND PRODSEQ = ? ");
        query.append("   AND SHOPSEQ = ? ");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getCompayny_goods_cd(), dto.getPRODSEQ(), dto.getGoods_keyword(), dto.getShopcd(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getShopprodno(), alwayzAndTossProdSeq, shopSeq};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int updateProductInByAlwayzAndToss(ProductDTO dto, int shopSeq) {
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN \t\t   \r\n");
        query.append("   SET COMPAYNY_GOODS_CD = ? \r\n");
        query.append("     , GOODS_KEYWORD = ? \t   \r\n");
        query.append(" WHERE SHOPCD = ? \t\t   \r\n");
        query.append("   AND COMPNO = ?  \t\t   \r\n");
        query.append("   AND COMPAYNY_GOODS_CD = ?  \r\n");
        query.append("   AND PRODSEQ = ? ");
        query.append("   AND SHOPSEQ = ? ");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getCompayny_goods_cd(), dto.getGoods_keyword(), dto.getShopcd(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getShopprodno(), dto.getPRODSEQ(), shopSeq};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int deleteProductInfoByAlwayzAndToss(ProductDTO dto) {
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM SHOPPRODINFO \t   \r\n");
        query.append(" WHERE COMPNO = ? \t\t   \r\n");
        query.append("   AND COMPAYNY_GOODS_CD = ?  ");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getShopprodno()};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean checkTossErrorSyncShopprodno(String shopUserId, String compaynyGoodsCD) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT SHOPPRODNO \t\t\t\r\n");
        query.append("  FROM SHOPPRODIN \t\t\t\r\n");
        query.append(" WHERE SHOPPRODNO = '\uc0c1\ud488\uc874\uc7ac'\t\r\n");
        query.append("   AND SHOPCD = 'shop9982' \t\r\n");
        query.append("   AND SHOP_USERID = ?\t\t \r\n");
        query.append("   AND COMPAYNY_GOODS_CD = ? \r\n");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{shopUserId, compaynyGoodsCD};
                String result = (String)runner.query(connection, query.toString(), (ResultSetHandler)new ScalarHandler(), params);
                boolean bl = result != null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int updateProductTossErrorSyncShoppodno(String shopUserId, String compaynyGoodsCD, String shopprodno) {
        StringBuilder query = new StringBuilder();
        query.append("UPDATE SHOPPRODIN \t\t    \r\n");
        query.append("   SET SHOPPRODNO = ? \t\t\r\n");
        query.append(" WHERE SHOPCD = 'shop9982'   \r\n");
        query.append("   AND SHOPPRODNO = '\uc0c1\ud488\uc874\uc7ac'  \r\n");
        query.append("   AND COMPAYNY_GOODS_CD = ? \r\n");
        query.append("   AND SHOP_USERID = ? \r\n");
        YDMAStringUtil.Print(query.toString());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{shopprodno, compaynyGoodsCD, shopUserId};
                int result = runner.update(connection, query.toString(), params);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static /* synthetic */ Object[][] lambda$6(int n) {
        return new Object[n][];
    }
}

