/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class AuctionGmarket2ProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto, String jobType, String logMsg) throws Exception {
        boolean flag = true;
        String shopInfoLog = String.format("[%s - %s(%s)]", dto.getSHOPINFO().getSHOPNM(), dto.getSHOPINFO().getSHOPPINGID(), dto.getSHOPINFO().getNICKNM1());
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        ProductDTO prodDto = dto.getPRODUCT();
        String site = shopInfo.getSHOPCD().equals("shop00671") ? "1" : "2";
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 4100: {
                    this.productSoldOut(prodDto, site, dto.getCOOKIES());
                    if (prodDto.getResult_code().equals("1")) {
                        this.logProductInDetail(shopInfoLog, prodDto, "\ud310\ub9e4\uc911\ub2e8", shopInfo, "\uc131\uacf5", "YEL_DIS_AUT", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\ub2e8 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    } else if (prodDto.getResult_text().equals("\ub3d9\uc77c\ud55c \uc0c1\ud0dc\ub85c\uc758 \ubcc0\uacbd\uc785\ub2c8\ub2e4.")) {
                        this.logProductInDetail(shopInfoLog, prodDto, "\ub3d9\uc77c\ud55c \uc0c1\ud0dc\ub85c\uc758 \ubcc0\uacbd\uc785\ub2c8\ub2e4.", shopInfo, "\uc2e4\ud328", jobType, "\ub3d9\uc77c\ud55c \uc0c1\ud0dc\ub85c\uc758 \ubcc0\uacbd\uc785\ub2c8\ub2e4.");
                    } else {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    Thread.sleep(6000L);
                    break;
                }
                case 4200: {
                    this.productResumSale(prodDto, site, dto.getCOOKIES());
                    if (prodDto.getResult_code().equals("1") || prodDto.getResult_text().equals("\ub3d9\uc77c\ud55c \uc0c1\ud0dc\ub85c\uc758 \ubcc0\uacbd\uc785\ub2c8\ub2e4.")) break;
                    return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                }
                case 3000: 
                case 4000: {
                    flag = this.setProductDelete(shopInfo, dto.getPRODUCT(), dto.getCOOKIES(), shopInfoLog, jobType);
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, dto.getPRODUCT(), "\uc0ad\uc81c", dto.getSHOPINFO(), "\uc131\uacf5", jobType, logMsg);
                    Thread.sleep(6000L);
                }
            }
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    private boolean setProductDelete(ShoppingmallDTO shopInfo, ProductDTO prodInfo, Map<String, String> cookies, String shopInfoLog, String jobType) throws Exception {
        boolean flag2 = true;
        String site = shopInfo.getSHOPCD().equals("shop00671") ? "1" : "2";
        Modify dto = this.productSoldOut(prodInfo, site, cookies);
        if (prodInfo.getResult_code().equals("1")) {
            this.logProductInDetail(shopInfoLog, prodInfo, "\ud310\ub9e4\uc911\uc9c0", shopInfo, "\uc131\uacf5", jobType, "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\uc9c0 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
            flag2 = this.productDelete(prodInfo, cookies, dto);
        } else if (prodInfo.getResult_text().equals("\ub3d9\uc77c\ud55c \uc0c1\ud0dc\ub85c\uc758 \ubcc0\uacbd\uc785\ub2c8\ub2e4.")) {
            this.logProductInDetail(shopInfoLog, prodInfo, "\ub3d9\uc77c\ud55c \uc0c1\ud0dc\ub85c\uc758 \ubcc0\uacbd\uc785\ub2c8\ub2e4.", shopInfo, "\uc2e4\ud328", jobType, "\ub3d9\uc77c\ud55c \uc0c1\ud0dc\ub85c\uc758 \ubcc0\uacbd\uc785\ub2c8\ub2e4.");
            flag2 = this.productDelete(prodInfo, cookies, dto);
        } else {
            flag2 = false;
        }
        return flag2;
    }

    private boolean productDelete(ProductDTO shopProductDto, Map<String, String> cookies, Modify dto) throws Exception {
        block3: {
            try {
                Connection.Response rs = Jsoup.connect((String)("https://item.esmplus.com/api/ea/goods/" + dto.getCustno())).cookies(cookies).header("Origin", "https://item.esmplus.com").header("Connection", "keep-alive").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://item.esmplus.com/goods/list").method(Connection.Method.DELETE).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
                String body = rs.body();
                YDMAStringUtil.Print(body);
                JsonParser jsonparser = new JsonParser();
                JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
                int resultCode = jsonobject.get("resultCode").getAsInt();
                if (resultCode == 0) {
                    shopProductDto.setResult_code("1");
                    break block3;
                }
                shopProductDto.setResult_code("-1");
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        return true;
    }

    private Modify productSoldOut(ProductDTO shopProductDto, String site, Map<String, String> cookies) throws Exception {
        return this.updateSellStatus(shopProductDto, site, cookies, false);
    }

    private Modify productResumSale(ProductDTO shopProductDto, String site, Map<String, String> cookies) throws Exception {
        return this.updateSellStatus(shopProductDto, site, cookies, true);
    }

    private Modify updateSellStatus(ProductDTO shopProductDto, String site, Map<String, String> cookies, boolean isSell) throws Exception {
        Modify dto = new Modify();
        try {
            String goodsNo = this.getGoodsNo(shopProductDto.getShopprodno(), cookies);
            dto.setCustno(goodsNo);
            if (goodsNo.equals("")) {
                shopProductDto.setResult_code("-1");
                shopProductDto.setResult_text("\uc0c1\ud488\ubc88\ud638(goodNo)\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                return dto;
            }
            String header = site.equals("1") ? "x-a-seller-id" : "x-g-seller-id";
            String jsonBody = site.equals("1") ? "{\"isSell\":{\"iac\":" + isSell + "}}" : "{\"isSell\":{\"gmkt\":" + isSell + "}}";
            Connection.Response rs = Jsoup.connect((String)("https://item.esmplus.com/api/ea/goods/" + goodsNo + "/sellStatus")).cookies(cookies).header("Connection", "keep-alive").header("Content-Type", "application/json;charset=UTF-8").header(header, shopProductDto.getSHOP_USERID()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").referrer("https://item.esmplus.com/goods/list").requestBody(jsonBody).method(Connection.Method.PUT).ignoreContentType(true).execute();
            JsonObject jsonobject = jsonParser.parse(rs.body()).getAsJsonObject();
            int resultCode = jsonobject.get("resultCode").getAsInt();
            String message = jsonobject.get("message").getAsString();
            JsonObject dataObject = jsonobject.getAsJsonObject("data");
            JsonObject gmktObject = dataObject.getAsJsonObject("gmkt");
            int gmktResultCode = gmktObject.get("resultCode").getAsInt();
            String gmktMessage = gmktObject.get("message").getAsString();
            JsonObject iacObject = dataObject.getAsJsonObject("iac");
            int iacResultCode = iacObject.get("resultCode").getAsInt();
            String iacMessage = iacObject.get("message").getAsString();
            if (resultCode == 0 && gmktResultCode == 0 && iacResultCode == 0) {
                shopProductDto.setResult_code("1");
            } else {
                shopProductDto.setResult_code("-1");
                if (shopProductDto.getShopcd().equals("shop00671")) {
                    shopProductDto.setResult_text(message.equals("") ? iacMessage : message);
                } else {
                    shopProductDto.setResult_text(message.equals("") ? gmktMessage : message);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return dto;
    }

    private String getGoodsNo(String shopprodno, Map<String, String> cookies) throws Exception {
        String goodsNo = "";
        JsonObject query = new JsonObject();
        query.addProperty("goodsIds", shopprodno);
        query.addProperty("keyword", "");
        query.add("sellStatus", (JsonElement)new JsonArray());
        query.add("category", (JsonElement)new JsonObject());
        query.add("registrationDate", (JsonElement)new JsonObject());
        query.add("shipping", (JsonElement)new JsonObject());
        query.add("additionalService", (JsonElement)new JsonArray());
        JsonObject root = new JsonObject();
        root.add("query", (JsonElement)query);
        root.addProperty("pageIndex", (Number)1);
        root.addProperty("pageSize", (Number)50);
        root.addProperty("sortField", (Number)0);
        root.addProperty("sortOrder", (Number)1);
        Connection.Response rs = Jsoup.connect((String)"https://item.esmplus.com/api/ea/goods/search").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").requestBody(root.toString()).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject = jsonParser.parse(rs.body()).getAsJsonObject();
        JsonArray itemsArray = jsonobject.getAsJsonObject("data").getAsJsonArray("items");
        for (JsonElement item : itemsArray) {
            JsonObject itemObject = item.getAsJsonObject();
            goodsNo = itemObject.get("goodsNo").getAsString();
        }
        return goodsNo;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO prodInfo, ShopProductAdditionDto dtllist, ShoppingmallDTO shopInfo, String status2, ShopProductSendDto sendDTO, Map<String, String> loginCookies) throws Exception {
        return false;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shopInfo, Map<String, String> loginCookie) throws Exception {
        return false;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        return null;
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String jobType, String logMsg) {
        String comment = "";
        comment = jobResult.equals("\uc131\uacf5") ? String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action) : String.format(" %s [%s]\n \u2192 %s", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackProd(comment, 50, prodInfo, shoppingmallDTO, jobType, jobResult, logMsg, true);
    }

    class Modify {
        private String goodno;
        private String dispEndDate;
        private String goodsName;
        private String sellPrice;
        private String stockQty;
        private String sitecategory;
        private String custno;

        Modify() {
        }

        public String getCustno() {
            return this.custno;
        }

        public void setCustno(String custno) {
            this.custno = custno;
        }

        public String getSitecategory() {
            return this.sitecategory;
        }

        public void setSitecategory(String sitecategory) {
            this.sitecategory = sitecategory;
        }

        public String getGoodno() {
            return this.goodno;
        }

        public void setGoodno(String goodno) {
            this.goodno = goodno;
        }

        public String getDispEndDate() {
            return this.dispEndDate;
        }

        public void setDispEndDate(String dispEndDate) {
            this.dispEndDate = dispEndDate;
        }

        public String getGoodsName() {
            return this.goodsName;
        }

        public void setGoodsName(String goodsName) {
            this.goodsName = goodsName;
        }

        public String getSellPrice() {
            return this.sellPrice;
        }

        public void setSellPrice(String sellPrice) {
            this.sellPrice = sellPrice;
        }

        public String getStockQty() {
            return this.stockQty;
        }

        public void setStockQty(String stockQty) {
            this.stockQty = stockQty;
        }
    }
}

