/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.common;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

public class AutoCleanupDriver
extends ChromeDriver {
    private final Path profilePath;

    public AutoCleanupDriver(ChromeOptions options, String profileDir) {
        super(options);
        this.profilePath = Paths.get(profileDir, new String[0]);
    }

    public void quit() {
        super.quit();
        Path deleteTarget = this.profilePath;
        new Thread(() -> {
            try {
                Thread.sleep(200L);
                this.deleteDirectoryWithRetry(deleteTarget);
            }
            catch (Exception exception) {}
        }).start();
    }

    private void deleteDirectoryWithRetry(Path path) {
        int maxRetry = 20;
        int delay = 50;
        int i = 0;
        while (i < maxRetry) {
            try {
                this.deleteDirectory(path);
                return;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
    }

    private void deleteDirectory(Path path) throws Exception {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
            try {
                Files.deleteIfExists(p);
            }
            catch (Exception exception) {}
        });
    }
}

