/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.mlink;

import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.mlink.HomeObserver;
import com.kdjsystem.mlink.yellim.shop.mlink.HomeObserverable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class HomeWorkDataQueue
implements HomeObserverable {
    private static HomeWorkDataQueue instance = new HomeWorkDataQueue();
    private ArrayList<HomeObserver> observers;
    ExecutorService executorService;
    Map<String, ShoppingMallDetailDto> queue = new LinkedHashMap<String, ShoppingMallDetailDto>();
    Map<String, ShoppingmallDTO> queue2 = new LinkedHashMap<String, ShoppingmallDTO>();

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void stopExecutorService() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    YDMAStringUtil.Print("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private HomeWorkDataQueue() {
        int corePoolSize = 1;
        int maximumPoolSize = 1;
        long keepAliveTime = 3L;
        TimeUnit unit = TimeUnit.SECONDS;
        this.executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
        this.observers = new ArrayList();
    }

    public static HomeWorkDataQueue get() {
        return instance;
    }

    public void add(ShoppingMallDetailDto shopdtl) {
        String grp = String.valueOf(shopdtl.getShopcd()) + shopdtl.getShopseq();
        this.queue.put(grp, shopdtl);
        this.notifyObservers();
    }

    public void add(ShoppingmallDTO shopdtl) {
        String grp = String.valueOf(shopdtl.getSHOPCD()) + shopdtl.getSHOPSEQ();
        this.queue2.put(grp, shopdtl);
        this.notifyObservers();
    }

    public void modify(ShoppingMallDetailDto shopdtl) {
        String grp = String.valueOf(shopdtl.getShopcd()) + shopdtl.getShopseq();
        this.queue.put(grp, shopdtl);
        this.notifyObservers();
    }

    public void modify2(ShoppingmallDTO shopdtl) {
        String grp = String.valueOf(shopdtl.getSHOPCD()) + shopdtl.getSHOPSEQ();
        this.queue2.put(grp, shopdtl);
        this.notifyObservers();
    }

    public synchronized List<ShoppingMallDetailDto> getAllData() {
        if (this.queue.size() == 0) {
            return new ArrayList<ShoppingMallDetailDto>();
        }
        return this.queue.entrySet().stream().map(p -> (ShoppingMallDetailDto)p.getValue()).collect(Collectors.toList());
    }

    public synchronized List<ShoppingmallDTO> getAllData2() {
        if (this.queue2.size() == 0) {
            return new ArrayList<ShoppingmallDTO>();
        }
        return this.queue2.entrySet().stream().map(p -> (ShoppingmallDTO)p.getValue()).collect(Collectors.toList());
    }

    public synchronized List<ShoppingMallDetailDto> getWaitData() {
        if (this.queue.size() == 0) {
            return null;
        }
        List<ShoppingMallDetailDto> shopdtl = this.queue.entrySet().stream().map(p -> (ShoppingMallDetailDto)p.getValue()).collect(Collectors.toList());
        if (shopdtl == null) {
            return null;
        }
        this.notifyObservers();
        return shopdtl;
    }

    public synchronized List<ShoppingmallDTO> getWaitData2() {
        if (this.queue2.size() == 0) {
            return null;
        }
        List<ShoppingmallDTO> shopdtl = this.queue2.entrySet().stream().map(p -> (ShoppingmallDTO)p.getValue()).collect(Collectors.toList());
        if (shopdtl == null) {
            return null;
        }
        this.notifyObservers();
        return shopdtl;
    }

    @Override
    public void addObserver(HomeObserver o) {
        this.observers.add(o);
    }

    @Override
    public void deleteObserver(HomeObserver o) {
        int i = this.observers.indexOf(o);
        if (i >= 0) {
            this.observers.remove(i);
        }
    }

    @Override
    public void notifyObservers() {
        int i = 0;
        while (i < this.observers.size()) {
            HomeObserver observer = this.observers.get(i);
            observer.update(this);
            ++i;
        }
    }
}

