/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.dto.AutoStopSearchSetDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class ShoppingmallDAO {
    private static ShoppingmallDAO instance = new ShoppingmallDAO();

    public static ShoppingmallDAO get() {
        return instance;
    }

    public List<ShoppingmallDTO> selectShoppingmallInfos() {
        List<ShoppingmallDTO> result = new ArrayList<ShoppingmallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ShoppingmallDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.COMPNO, '') \t\t AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPCD,'')  \t\t AS SHOPCD  \r\n");
                query.append("    , IFNULL(C.SHOPNM,'')  \t\t AS SHOPNM  \r\n");
                query.append("    , IFNULL(C.SHOPURL,'') \t\t AS SHOPURL  \r\n");
                query.append("    , IFNULL(B.SHOPPINGID,'') \t AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.NICKNM1, B.NICKNM2) AS NICKNM1  \r\n");
                query.append("    , IFNULL(B.APIKEY,'') \t\t AS APIKEY  \r\n");
                query.append("    , IFNULL(B.DEALTREAD,'') \t     AS DEALTREAD  \r\n");
                query.append("    , IFNULL(B.PASSWORD, '') \t     AS PASSWORD  \r\n");
                query.append("    , IFNULL(B.AUTHKEY1, '') \t     AS AUTHKEY1  \r\n");
                query.append("    , IFNULL(B.AUTHKEY2, '') \t     AS AUTHKEY2  \r\n");
                query.append("    , IFNULL(B.EDITAUTHKEY1, '')   AS EDITAUTHKEY1  \r\n");
                query.append("    , IFNULL(B.EDITAPIKEY, '') \t AS EDITAPIKEY  \r\n");
                query.append("    , IFNULL(B.NICKNM2, '') \t     AS VENDORID  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '') \t     AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SUPPSTDITEM, '')    AS SUPPSTDITEM  \r\n");
                query.append("    , IFNULL(B.SUPPSTDRATI, '')    AS SUPPSTDRATI  \r\n");
                query.append("  FROM shopmst AS A  \r\n");
                query.append("  LEFT JOIN shopdtl AS B ON A.COMPNO = B.COMPNO AND A.SHOPCD = B.SHOPCD  \r\n");
                query.append("  JOIN shopinfo AS C ON A.shopcd = C.shopcd  \r\n");
                query.append(" WHERE A.COMPNO = " + compno + "  \r\n");
                query.append("   AND B.DEALTREAD = '\uc0ac\uc6a9\uc911'  \r\n");
                query.append(" ORDER BY A.SHOPCD, B.SHOPSEQ  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ShoppingmallDTO> selectSearchPreferencesShoppingmallInfos(int optionIdx, String searchText) {
        List<ShoppingmallDTO> result = new ArrayList<ShoppingmallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ShoppingmallDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                String optionQuery = "";
                optionQuery = optionIdx == 1 ? "AND B.SHOPNM LIKE ?" : "AND A.SHOPCD LIKE ?";
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.SHOPSEQ, '')      AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(A.SHOPCD, '')       AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPNM, '')       AS SHOPNM  \r\n");
                query.append("    , IFNULL(A.SHOPPINGID, '')   AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(A.PASSWORD, '')     AS PASSWORD  \r\n");
                query.append("    , IFNULL(A.NICKNM2, '')      AS NICKNM2  \r\n");
                query.append("    , IFNULL(A.NICKNM1, '')      AS NICKNM1  \r\n");
                query.append("    , IFNULL(A.AUTHKEY1, '')     AS AUTHKEY1  \r\n");
                query.append("    , IFNULL(A.AUTHKEY2, '')     AS AUTHKEY2  \r\n");
                query.append("    , IFNULL(A.APIKEY, '')       AS APIKEY  \r\n");
                query.append("    , IFNULL(A.SUPPSTDITEM, '0') AS SUPPSTDITEM  \r\n");
                query.append("    , IFNULL(A.SUPPSTDRATI, '')  AS SUPPSTDRATI  \r\n");
                query.append("    , IFNULL(A.SHOPCOMPAR, '')   AS SHOPCOMPAR  \r\n");
                query.append("    , IFNULL(A.EDITAUTHKEY1, '') AS EDITAUTHKEY1  \r\n");
                query.append("    , IFNULL(A.EDITAPIKEY, '')   AS EDITAPIKEY  \r\n");
                query.append("    , IFNULL(A.REGCNT, '')       AS REGCNT  \r\n");
                query.append("    , IFNULL(A.EXCESSYN, '')     AS EXCESSYN  \r\n");
                query.append("    , IFNULL(A.EXCESSCNT, '')    AS EXCESSCNT  \r\n");
                query.append("    , IFNULL(A.SHOPGRP, '')      AS SHOPGRP  \r\n");
                query.append("    , IFNULL(A.DEALTREAD, '')    AS DEALTREAD  \r\n");
                query.append("  FROM shopdtl AS A  \r\n");
                query.append("  JOIN shopinfo AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.COMPNO = ?  \r\n");
                query.append("   " + optionQuery + "  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), "%" + searchText + "%"};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ShoppingmallDTO selectShoppingmallInfo(String shopCode, String shopSeq) {
        ShoppingmallDTO result = new ShoppingmallDTO();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ShoppingmallDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.SHOPSEQ, '')      AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(A.SHOPCD, '')       AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPNM, '')       AS SHOPNM  \r\n");
                query.append("    , IFNULL(A.SHOPPINGID, '')   AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(A.PASSWORD, '')     AS PASSWORD  \r\n");
                query.append("    , IFNULL(A.NICKNM2, '')      AS NICKNM2  \r\n");
                query.append("    , IFNULL(A.NICKNM1, '')      AS NICKNM1  \r\n");
                query.append("    , IFNULL(A.AUTHKEY1, '')     AS AUTHKEY1  \r\n");
                query.append("    , IFNULL(A.AUTHKEY2, '')     AS AUTHKEY2  \r\n");
                query.append("    , IFNULL(A.APIKEY, '')       AS APIKEY  \r\n");
                query.append("    , IFNULL(A.SUPPSTDITEM, '0') AS SUPPSTDITEM  \r\n");
                query.append("    , IFNULL(A.SUPPSTDRATI, '')  AS SUPPSTDRATI  \r\n");
                query.append("    , IFNULL(A.SHOPCOMPAR, '')   AS SHOPCOMPAR  \r\n");
                query.append("    , IFNULL(A.EDITAUTHKEY1, '') AS EDITAUTHKEY1  \r\n");
                query.append("    , IFNULL(A.EDITAPIKEY, '')   AS EDITAPIKEY  \r\n");
                query.append("    , IFNULL(A.REGCNT, '')       AS REGCNT  \r\n");
                query.append("    , IFNULL(A.EXCESSYN, '')     AS EXCESSYN  \r\n");
                query.append("    , IFNULL(A.EXCESSCNT, '')    AS EXCESSCNT  \r\n");
                query.append("    , IFNULL(A.SHOPGRP, '')      AS SHOPGRP  \r\n");
                query.append("    , IFNULL(A.DEALTREAD, '')    AS DEALTREAD  \r\n");
                query.append("  FROM shopdtl AS A  \r\n");
                query.append("  JOIN shopinfo AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.COMPNO = ?  \r\n");
                query.append("   AND A.SHOPCD = ?  \r\n");
                query.append("   AND A.SHOPSEQ = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), shopCode, shopSeq};
                result = (ShoppingmallDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ShoppingmallDTO> selectShoppingmallInfos(String commandID, String shopCode, String shopSeq) {
        List<ShoppingmallDTO> result = new ArrayList<ShoppingmallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ShoppingmallDTO.class);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.SHOPSEQ, '')      AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(A.SHOPCD, '')       AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPNM, '')       AS SHOPNM  \r\n");
                query.append("    , IFNULL(A.SHOPPINGID, '')   AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(A.PASSWORD, '')     AS PASSWORD  \r\n");
                query.append("    , IFNULL(A.NICKNM2, '')      AS NICKNM2  \r\n");
                query.append("    , IFNULL(A.NICKNM1, '')      AS NICKNM1  \r\n");
                query.append("    , IFNULL(A.AUTHKEY1, '')     AS AUTHKEY1  \r\n");
                query.append("    , IFNULL(A.AUTHKEY2, '')     AS AUTHKEY2  \r\n");
                query.append("    , IFNULL(A.APIKEY, '')       AS APIKEY  \r\n");
                query.append("    , IFNULL(A.SUPPSTDITEM, '0') AS SUPPSTDITEM  \r\n");
                query.append("    , IFNULL(A.SUPPSTDRATI, '')  AS SUPPSTDRATI  \r\n");
                query.append("    , IFNULL(A.SHOPCOMPAR, '')   AS SHOPCOMPAR  \r\n");
                query.append("    , IFNULL(A.EDITAUTHKEY1, '') AS EDITAUTHKEY1  \r\n");
                query.append("    , IFNULL(A.EDITAPIKEY, '')   AS EDITAPIKEY  \r\n");
                query.append("    , IFNULL(A.REGCNT, '')       AS REGCNT  \r\n");
                query.append("    , IFNULL(A.EXCESSYN, '')     AS EXCESSYN  \r\n");
                query.append("    , IFNULL(A.EXCESSCNT, '')    AS EXCESSCNT  \r\n");
                query.append("    , IFNULL(A.SHOPGRP, '')      AS SHOPGRP  \r\n");
                query.append("    , IFNULL(A.DEALTREAD, '')    AS DEALTREAD  \r\n");
                query.append("  FROM shopdtl AS A  \r\n");
                query.append("  JOIN shopinfo AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.COMPNO = ?  \r\n");
                Object[] params = null;
                if (commandID.equals("A")) {
                    params = new Object[]{Integer.parseInt(compno)};
                } else if (commandID.equals("S")) {
                    query.append("   AND A.SHOPCD = ?  \r\n");
                    params = new Object[]{Integer.parseInt(compno), shopCode};
                } else if (commandID.equals("U")) {
                    query.append("   AND A.SHOPCD = ?  \r\n");
                    query.append("   AND A.SHOPSEQ = ?  \r\n");
                    params = new Object[]{Integer.parseInt(compno), shopCode, shopSeq};
                }
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ShoppingmallDTO> selectTradingShoppingMallQuickInfo() {
        List<ShoppingmallDTO> result = new ArrayList<ShoppingmallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ShoppingmallDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.COMPNO, '') AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPCD,'')  AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPNM,'')  AS SHOPNM  \r\n");
                query.append("    , IFNULL(B.SHOPURL,'') AS SHOPURL  \r\n");
                query.append("  FROM shopmst AS A  \r\n");
                query.append("  JOIN shopinfo AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.COMPNO = ?  \r\n");
                query.append("   AND A.DEALTRADE = '\uac70\ub798\uc911'  \r\n");
                query.append(" ORDER BY A.SHOPCD  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno)};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ShoppingmallDTO> selectTradingShoppingMallAllData() {
        List<ShoppingmallDTO> result = new ArrayList<ShoppingmallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ShoppingmallDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT DISTINCT  \r\n");
                query.append("      IFNULL(A.COMPNO, 0)        AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPCD, '')       AS SHOPCD  \r\n");
                query.append("    , IFNULL(A.SHOPSEQ, 0)       AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SHOPNM, '')       AS SHOPNM  \r\n");
                query.append("    , IFNULL(A.SHOPPINGID, '')   AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(A.PASSWORD, '')     AS PASSWORD  \r\n");
                query.append("    , IFNULL(A.NICKNM2, '')      AS NICKNM2  \r\n");
                query.append("    , IFNULL(A.NICKNM1, '')      AS NICKNM1  \r\n");
                query.append("    , IFNULL(A.AUTHKEY1, '')     AS AUTHKEY1  \r\n");
                query.append("    , IFNULL(A.AUTHKEY2, '')     AS AUTHKEY2  \r\n");
                query.append("    , IFNULL(A.ORDEREXCEL1, '')  AS ORDEREXCEL1  \r\n");
                query.append("    , IFNULL(A.ORDEREXCEL2, '')  AS ORDEREXCEL2  \r\n");
                query.append("    , IFNULL(A.ORDEREXCEL3, '')  AS ORDEREXCEL3  \r\n");
                query.append("    , IFNULL(A.APIKEY, '')       AS APIKEY  \r\n");
                query.append("    , IFNULL(A.SUPPSTDITEM, '')  AS SUPPSTDITEM  \r\n");
                query.append("    , IFNULL(A.SUPPSTDRATI, 0)   AS SUPPSTDRATI  \r\n");
                query.append("    , IFNULL(A.DEALTREAD, '')    AS DEALTREAD  \r\n");
                query.append("    , IFNULL(A.SHOPCOMPAR, 0)    AS SHOPCOMPAR  \r\n");
                query.append("    , IFNULL(A.EDITAUTHKEY1, '') AS EDITAUTHKEY1  \r\n");
                query.append("    , IFNULL(A.EDITAPIKEY, '')   AS EDITAPIKEY  \r\n");
                query.append("    , IFNULL(A.REGCNT, 0)   \t   AS REGCNT  \r\n");
                query.append("    , IFNULL(A.EXCESSYN, '')     AS EXCESSYN  \r\n");
                query.append("    , IFNULL(A.EXCESSCNT, 0)     AS EXCESSCNT  \r\n");
                query.append("    , IFNULL(A.SHOPGRP, 0)       AS SHOPGRP  \r\n");
                query.append("    , IFNULL(A.COOKIEKEY, '')    AS COOKIEKEY  \r\n");
                query.append("    , IFNULL(A.COOKIES, '')      AS COOKIES  \r\n");
                query.append("  FROM shopdtl AS A  \r\n");
                query.append("  JOIN shopinfo AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.DEALTREAD = '\uc0ac\uc6a9\uc911'  \r\n");
                query.append("   AND A.COMPNO = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno)};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ShoppingmallDTO> selectTradingShoppingMallInfo() {
        List<ShoppingmallDTO> result = new ArrayList<ShoppingmallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ShoppingmallDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT DISTINCT  \r\n");
                query.append("      IFNULL(A.SHOPCD, '')       AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPNM, '')       AS SHOPNM  \r\n");
                query.append("  FROM shopdtl AS A  \r\n");
                query.append("  JOIN shopinfo AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.DEALTREAD = '\uc0ac\uc6a9\uc911'  \r\n");
                query.append("   AND A.COMPNO = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno)};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateShoppingMallDealtreadYes(String shopCode, String shopSeq, String shoppingID) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE shopdtl  \r\n");
        query.append("   SET DEALTREAD = '\uc0ac\uc6a9\uc911'  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        query.append("   AND SHOPSEQ = ?  \r\n");
        query.append("   AND SHOPPINGID = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(compno), shopCode, shopSeq, shoppingID};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateShoppingMallDealtreadNo(String shopCode, String shopSeq, String shoppingID) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE shopdtl  \r\n");
        query.append("   SET DEALTREAD = ''  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        query.append("   AND SHOPSEQ = ?  \r\n");
        query.append("   AND SHOPPINGID = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(compno), shopCode, shopSeq, shoppingID};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int deleteShoppingMall(String shopCode, int shopSeq, String shoppingID) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM shopdtl  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        query.append("   AND SHOPSEQ = ?  \r\n");
        query.append("   AND SHOPPINGID = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(compno), shopCode, shopSeq, shoppingID};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ShoppingmallDTO selectShoppingMallMasterInfo(String shopCode) {
        ShoppingmallDTO result = new ShoppingmallDTO();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ShoppingmallDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.SHOPCD, '')       AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPNM, '')       AS SHOPNM  \r\n");
                query.append("    , IFNULL(B.CUSTNM, '')       AS CUSTNM  \r\n");
                query.append("    , IFNULL(B.PRODREGIS, '')    AS PRODREGIS  \r\n");
                query.append("    , IFNULL(B.PRODMODIFY, '')   AS PRODMODIFY  \r\n");
                query.append("    , IFNULL(B.PRODSOLDOUT, '')  AS PRODSOLDOUT  \r\n");
                query.append("    , IFNULL(B.STOCKSEND, '')    AS STOCKSEND  \r\n");
                query.append("    , IFNULL(B.ORDERCOLLECT, '') AS ORDERCOLLECT  \r\n");
                query.append("    , IFNULL(B.INVOICSEND, '')   AS INVOICSEND  \r\n");
                query.append("    , IFNULL(B.CLAIMCOLLECT, '') AS CLAIMCOLLECT  \r\n");
                query.append("    , IFNULL(B.QUESTION, '')     AS QUESTION  \r\n");
                query.append("    , IFNULL(B.MARKETCATEG, '')  AS MARKETCATEG  \r\n");
                query.append("    , IFNULL(A.IDNUM, '0')       AS IDNUM  \r\n");
                query.append("    , IFNULL(A.DEALTRADE, '')    AS DEALTRADE  \r\n");
                query.append("  FROM shopmst AS A  \r\n");
                query.append("  JOIN shopinfo AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.SHOPCD = ?  \r\n");
                query.append("   AND A.COMPNO = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{shopCode, Integer.parseInt(compno)};
                result = (ShoppingmallDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int selectShoppingMallMaxSeq(String shopCode) {
        QueryRunner runner = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(MAX(SHOPSEQ), 0)  \r\n");
                query.append("  FROM shopdtl  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), shopCode};
                Long result = (Long)runner.query(connection, query.toString(), (ResultSetHandler)handler, params);
                return result.intValue();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int updateShoppingMallMasterTradingInfo(String num, String shopCode) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE shopmst  \r\n");
        query.append("   SET IDNUM = ?  \r\n");
        query.append("     , DEALTRADE = '\uac70\ub798\uc911'  \r\n");
        query.append(" WHERE SHOPCD = ?  \r\n");
        query.append("   AND COMPNO = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{num, shopCode, Integer.parseInt(compno)};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExistsUserID(String shoppingID, String shopCode) {
        ShoppingmallDTO dto = new ShoppingmallDTO();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ShoppingmallDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(SHOPPINGID, '') AS SHOPPINGID  \r\n");
                query.append("  FROM shopdtl  \r\n");
                query.append(" WHERE SHOPPINGID = ?  \r\n");
                query.append("   AND COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{shoppingID, Integer.parseInt(compno), shopCode};
                dto = (ShoppingmallDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
                if (dto == null) {
                    return false;
                }
                if (dto.getSHOPPINGID().equals("")) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExistsUserID(String shoppingID, String shopCode, int shopSeq) {
        ShoppingmallDTO dto = new ShoppingmallDTO();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ShoppingmallDTO.class);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(SHOPPINGID, '') AS SHOPPINGID  \r\n");
                query.append("  FROM shopdtl  \r\n");
                query.append(" WHERE SHOPPINGID = ?  \r\n");
                query.append("   AND COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                query.append("   AND SHOPSEQ <> ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{shoppingID, Integer.parseInt(compno), shopCode, shopSeq};
                dto = (ShoppingmallDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
                if (dto == null) {
                    return false;
                }
                if (dto.getSHOPPINGID().equals("")) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public int insertShoppingMallDetailInfo(ShoppingmallDTO dto) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO shopdtl (  \r\n");
        query.append("      COMPNO  \r\n");
        query.append("    , SHOPCD  \r\n");
        query.append("    , SHOPSEQ  \r\n");
        query.append("    , SHOPPINGID  \r\n");
        query.append("    , PASSWORD  \r\n");
        query.append("    , NICKNM2  \r\n");
        query.append("    , NICKNM1  \r\n");
        query.append("    , AUTHKEY1  \r\n");
        query.append("    , AUTHKEY2  \r\n");
        query.append("    , APIKEY  \r\n");
        query.append("    , SUPPSTDITEM  \r\n");
        query.append("    , SUPPSTDRATI  \r\n");
        query.append("    , DEALTREAD  \r\n");
        query.append("    , SHOPCOMPAR  \r\n");
        query.append("    , EDITAUTHKEY1  \r\n");
        query.append("    , EDITAPIKEY  \r\n");
        query.append("    , REGCNT  \r\n");
        query.append("    , EXCESSYN  \r\n");
        query.append("    , EXCESSCNT  \r\n");
        query.append("    , SHOPGRP  \r\n");
        query.append(")  \r\n");
        query.append("VALUES (  \r\n");
        query.append("      ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , 0  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , '0'  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , 0  \r\n");
        query.append("    , 'N'  \r\n");
        query.append("    , 0  \r\n");
        query.append("    , ?  \r\n");
        query.append(")  \r\n");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getSHOPCD(), dto.getSHOPSEQ(), dto.getSHOPPINGID(), dto.getPASSWORD(), dto.getNICKNM2(), dto.getNICKNM1(), dto.getAUTHKEY1(), dto.getAUTHKEY2(), dto.getAPIKEY(), dto.getSUPPSTDITEM(), dto.getDEALTREAD(), dto.getEDITAUTHKEY1(), dto.getEDITAPIKEY(), dto.getSHOPGRP()};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateShoppingMallDetailInfo(ShoppingmallDTO dto) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE shopdtl  \r\n");
        query.append("   SET SHOPPINGID = ?  \r\n");
        query.append("     , PASSWORD = ?  \r\n");
        query.append("     , NICKNM2 = ?  \r\n");
        query.append("     , NICKNM1 = ?  \r\n");
        query.append("     , AUTHKEY1 = ?  \r\n");
        query.append("     , AUTHKEY2 = ?  \r\n");
        query.append("     , APIKEY = ?  \r\n");
        query.append("     , SUPPSTDITEM = ?  \r\n");
        query.append("     , SUPPSTDRATI = 0  \r\n");
        query.append("     , DEALTREAD = ?  \r\n");
        query.append("     , SHOPCOMPAR = '0'  \r\n");
        query.append("     , EDITAUTHKEY1 = ?  \r\n");
        query.append("     , EDITAPIKEY = ?  \r\n");
        query.append("     , REGCNT = 0  \r\n");
        query.append("     , EXCESSYN = 'N'  \r\n");
        query.append("     , EXCESSCNT = 0  \r\n");
        query.append("     , SHOPGRP = ?  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        query.append("   AND SHOPSEQ = ?  \r\n");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getSHOPPINGID(), dto.getPASSWORD(), dto.getNICKNM2(), dto.getNICKNM1(), dto.getAUTHKEY1(), dto.getAUTHKEY2(), dto.getAPIKEY(), dto.getSUPPSTDITEM(), dto.getDEALTREAD(), dto.getEDITAUTHKEY1(), dto.getEDITAPIKEY(), dto.getSHOPGRP(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getSHOPCD(), dto.getSHOPSEQ()};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int FindShopSeqByShopCDandShoppingID(String shopCD, String shoppingID) {
        QueryRunner runner = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(SHOPSEQ, 0)  \r\n");
                query.append("  FROM shopdtl  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                query.append("   AND SHOPPINGID = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), shopCD, shoppingID};
                Long result = (Long)runner.query(connection, query.toString(), (ResultSetHandler)handler, params);
                return result.intValue();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public List<AutoStopSearchSetDTO> searchAutoStop() {
        QueryRunner runner = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AutoStopSearchSetDTO.class);
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("select * \r\n");
                query.append("  from auto_stop_search_set \r\n");
                query.append(" order by seq");
                return (List)runner.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AutoStopSearchSetDTO searchAutoStopOne(String name) {
        QueryRunner runner = new QueryRunner();
        BeanHandler handler = new BeanHandler(AutoStopSearchSetDTO.class);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("select * \r\n");
                query.append("  from auto_stop_search_set \r\n");
                query.append(" where name = ? \r\n");
                query.append(" order by seq");
                Object[] param = new Object[]{name};
                return (AutoStopSearchSetDTO)runner.query(connection, query.toString(), (ResultSetHandler)handler, param);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int insertAutoStopSet(AutoStopSearchSetDTO dto) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO auto_stop_search_set (  \r\n");
        query.append("      name  \r\n");
        query.append("    , content  \r\n");
        query.append(")  \r\n");
        query.append("VALUES (  \r\n");
        query.append("      ?  \r\n");
        query.append("    , ?  \r\n");
        query.append(")  \r\n");
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getName(), dto.getContent()};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    public int updateAutoStopSet(AutoStopSearchSetDTO dto) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE auto_stop_search_set \r\n ");
        query.append("   SET content = ? \r\n");
        query.append(" WHERE name = ? ");
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getContent(), dto.getName()};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    public int deleteAutoStopSet(String name) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("DELETE \r\n");
        query.append("  FROM auto_stop_search_set \r\n");
        query.append(" WHERE name = ?");
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{name};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    public List<String> getAutoStopSearchSetName() {
        ArrayList<String> nameList = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        query.append("select name \r\n");
        query.append("  from auto_stop_search_set \r\n");
        query.append(" order by seq");
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                List result = (List)runner.query(connection, query.toString(), (ResultSetHandler)new ColumnListHandler("name"));
                for (Object value : result) {
                    nameList.add(String.valueOf(value));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
        return nameList;
    }

    public List<List<String>> getShopidAlllist() throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select ifnull(COMPNO,'0'), ifnull(SHOPCD,''), ifnull(SHOPSEQ,''), ifnull(SHOPPINGID,''), ifnull(PASSWORD,''), ifnull(NICKNM2,''), ifnull(NICKNM1,''), ifnull(AUTHKEY1,''), ";
                sql = String.valueOf(sql) + " ifnull(AUTHKEY2,''), ifnull(ORDEREXCEL1,''), ifnull(ORDEREXCEL2,''), ifnull(ORDEREXCEL3,''),  ifnull(APIKEY,''), ifnull(DEALTREAD,'' )";
                sql = String.valueOf(sql) + " FROM shopdtl ";
                sql = String.valueOf(sql) + " where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }
}

