/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dao.CategoryDAO;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.CategoryDTO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductAddProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductAddProcess;
import com.kdjsystem.mlink.yellim.helper.DateHelper;
import com.kdjsystem.mlink.yellim.helper.JsonHelper;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAddDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class AuctionGmarket2ProductAddService
implements IProductAddProcess {
    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto) throws Exception {
        boolean flag = true;
        int page = 0;
        int start = 0;
        int limit = 100;
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String site = shopInfo.getSHOPCD().equals("shop00671") ? "1" : "2";
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        try {
            while (flag) {
                String json = this.getJson(shopInfo, site, dto.getSTART_DATE(), dto.getEND_DATE());
                JsonParser parser = new JsonParser();
                Connection.Response response = Jsoup.connect((String)"https://www.esmplus.com/Sell/SingleGoodsMng/GetSingleGoodsList?_dc=").cookies(dto.getCOOKIES()).header("Host", "www.esmplus.com").header("Origin", "http://www.esmplus.com").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").data("paramsData", json).data("page", String.valueOf(page)).data("start", String.valueOf(start)).data("limit", String.valueOf(limit)).referrer("http://www.esmplus.com/Sell/SingleGoodsMng?menuCode=TDM396").method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).timeout(300000).execute();
                String body = response.body();
                JsonObject object = (JsonObject)parser.parse(body);
                JsonArray playListInformationArray = object.getAsJsonArray("data");
                if (playListInformationArray == null || playListInformationArray.size() == 0) {
                    this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                    this.setValue("--------------------------------------------------------------------------------------", 100);
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                JsonArray jsonArray = (JsonArray)object.get("data");
                if (jsonArray == null || jsonArray.size() == 0) {
                    this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                    this.setValue("--------------------------------------------------------------------------------------", 100);
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                ++page;
                if (jsonArray.size() < 100) {
                    flag = false;
                }
                ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                int i = 0;
                while (i < jsonArray.size()) {
                    CategoryDTO category;
                    String name;
                    String code;
                    if (ProductAddDialog.getIsCanceled()) {
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    JsonObject data2 = (JsonObject)jsonArray.get(i);
                    ProductDTO responseProduct = new ProductDTO();
                    responseProduct.setShopcd(shopInfo.getSHOPCD());
                    responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                    responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
                    responseProduct.setGoods_nm(JsonHelper.jsonNullStr(data2.get("GoodsName")));
                    responseProduct.setCompayny_goods_cd(JsonHelper.jsonNullStr(data2.get("SellerManageCode")));
                    responseProduct.setChar_1_nm("\ub2e8\ud488");
                    String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(responseProduct.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                    responseProduct.setGoods_keyword(codeDivision);
                    String end = JsonHelper.jsonNullStr(data2.get("DispEndDate"));
                    end = end.substring(end.indexOf("(") + 1, end.indexOf(")"));
                    responseProduct.setSaleenddt(YDMATimeUtil.getDate1(end));
                    String time = JsonHelper.jsonNullStr(data2.get("SiteRegDate"));
                    time = time.substring(time.indexOf("(") + 1, time.indexOf(")"));
                    responseProduct.setInsertdt(YDMATimeUtil.getLondtoDate(time.equals("") ? YDMATimeUtil.getCurrentTimeByYDFormat() : time));
                    responseProduct.setModifyid(responseProduct.getInsertdt());
                    responseProduct.setQty(JsonHelper.jsonNullStr(data2.get("StockQty")));
                    if (shopInfo.getSHOPCD().equals("shop00671")) {
                        code = JsonHelper.jsonNullStr(data2.get("CategoryCodeIAC"));
                        name = JsonHelper.jsonNullStr(data2.get("CategorySNameIAC"));
                        if (name.contains("/")) {
                            name = name.split("/")[1];
                        }
                        if ((category = CategoryDAO.get().selectShoppingMallCategory(code, name)) == null) {
                            category = CategoryDAO.get().selectCategory("350119000");
                            responseProduct.setClass_cd3(category.getCODE());
                            responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                            responseProduct.setGmcategnm(category.getFULL_NAME());
                        } else {
                            responseProduct.setClass_cd3(category.getCODE());
                            responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                            category = CategoryDAO.get().selectShoppingMallCategoryFullName(shopInfo.getSHOPCD(), code);
                            if (category == null) {
                                category = CategoryDAO.get().selectCategory("350119000");
                                responseProduct.setClass_cd3(category.getCODE());
                                responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                                responseProduct.setGmcategnm(category.getFULL_NAME());
                            } else {
                                responseProduct.setGmcategnm(category.getFULL_NAME());
                            }
                        }
                        responseProduct.setShopprodno(JsonHelper.jsonNullStr(data2.get("SiteGoodsNoIAC")));
                        responseProduct.setSaleStatusCd(JsonHelper.jsonNullStr(data2.get("StatusCodeIAC")));
                        responseProduct.setStatus(this.getStatus(JsonHelper.jsonNullStr(data2.get("StatusCodeIAC"))));
                        responseProduct.setSendstats(this.getSendStatus(JsonHelper.jsonNullStr(data2.get("StatusCodeIAC"))));
                        responseProduct.setMarket_price(JsonHelper.jsonNullStr(data2.get("SellPriceIAC")));
                        responseProduct.setGoods_price(JsonHelper.jsonNullStr(data2.get("SellPriceIAC")));
                        responseProduct.setGoods_consumer_price(JsonHelper.jsonNullStr(data2.get("SellPriceIAC")));
                    } else {
                        code = JsonHelper.jsonNullStr(data2.get("CategoryCodeGMKT"));
                        code = code.substring(code.length() - 9, code.length());
                        name = JsonHelper.jsonNullStr(data2.get("CategorySNameGMKT"));
                        if (name.contains("/")) {
                            name = name.split("/")[1];
                        }
                        if ((category = CategoryDAO.get().selectShoppingMallCategory(code, name)) == null) {
                            category = CategoryDAO.get().selectCategory("350119000");
                            responseProduct.setClass_cd3(category.getCODE());
                            responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                            responseProduct.setGmcategnm(category.getFULL_NAME());
                        } else {
                            responseProduct.setClass_cd3(category.getCODE());
                            responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                            category = CategoryDAO.get().selectShoppingMallCategoryFullName(shopInfo.getSHOPCD(), code);
                            if (category == null) {
                                category = CategoryDAO.get().selectCategory("350119000");
                                responseProduct.setClass_cd3(category.getCODE());
                                responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                                responseProduct.setGmcategnm(category.getFULL_NAME());
                            } else {
                                responseProduct.setGmcategnm(category.getFULL_NAME());
                            }
                        }
                        responseProduct.setShopprodno(JsonHelper.jsonNullStr(data2.get("SiteGoodsNoGMKT")));
                        responseProduct.setSaleStatusCd(JsonHelper.jsonNullStr(data2.get("StatusCodeGMKT")));
                        responseProduct.setStatus(this.getStatus(JsonHelper.jsonNullStr(data2.get("StatusCodeGMKT"))));
                        responseProduct.setSendstats(this.getSendStatus(JsonHelper.jsonNullStr(data2.get("StatusCodeGMKT"))));
                        responseProduct.setMarket_price(JsonHelper.jsonElementNullInt(data2.get("SellPriceGMKT")));
                        responseProduct.setGoods_price(JsonHelper.jsonElementNullInt(data2.get("SellPriceGMKT")));
                        responseProduct.setGoods_consumer_price(JsonHelper.jsonElementNullInt(data2.get("SellPriceGMKT")));
                    }
                    responseProducts.add(responseProduct);
                    this.setValue(String.format(" %s [%s] \ubd88\ub7ec\uc624\ub294 \uc911..", shopInfoLog, responseProduct.getCompayny_goods_cd()), 0);
                    ++i;
                }
                if (responseProducts.size() > 0) {
                    this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", page, responseProducts.size()), 0);
                    for (ProductDTO product2 : responseProducts) {
                        int ret;
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            ret = ProductDAO.get().insertProductInfo(product2);
                            if (ret == 1) {
                                infoRet += ret;
                                String comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", product2.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product2, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        } else {
                            copyProduct.setClass_cd3(product2.getClass_cd3());
                            copyProduct.setShop_cid_info(product2.getShop_cid_info());
                            ret = ProductDAO.get().updateProductInfo(copyProduct);
                            if (ret == 1) {
                                infoRet += ret;
                                String comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", product2.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product2, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product2.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret2 = ProductDAO.get().insertProductIn(product2);
                            if (ret2 == 1) {
                                inRet += ret2;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc5e0\ub9c1\ud06c\uc5d0 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        } else {
                            copyProductIn.setClass_cd3(product2.getClass_cd3());
                            copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                            copyProductIn.setGoods_nm(product2.getGoods_nm());
                            copyProductIn.setShopprodno(product2.getShopprodno());
                            copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product2.getSaleenddt());
                            copyProductIn.setMarket_price(product2.getMarket_price());
                            copyProductIn.setGoods_price(product2.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                            copyProductIn.setStatus(product2.getStatus());
                            copyProductIn.setSendstats(product2.getSendstats());
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                            if (ret3 == 1) {
                                inRet += ret3;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc5e0\ub9c1\ud06c\uc5d0\uc11c \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product2.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                        }
                    }
                }
                start += limit;
                Thread.sleep(30000L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String errorMessage = ex.getMessage() != null ? ex.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
            this.setValue("--------------------------------------------------------------------------------------", 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto, List<String> specificCodes) throws Exception {
        boolean flag = true;
        int page = 1;
        int start = 0;
        int limit = 100;
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String site = shopInfo.getSHOPCD().equals("shop00671") ? "1" : "2";
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        try {
            while (flag) {
                String json = this.getJson(shopInfo, site, dto.getSTART_DATE(), dto.getEND_DATE(), specificCodes, page, limit);
                JsonParser parser = new JsonParser();
                Connection.Response response = Jsoup.connect((String)"https://item.esmplus.com/api/ea/goods/search").cookies(dto.getCOOKIES()).header("Host", "item.esmplus.com").header("Origin", "https://item.esmplus.com").header("Content-Type", "application/json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://item.esmplus.com/goods/list").method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).timeout(300000).execute();
                String body = response.body();
                JsonObject object = (JsonObject)parser.parse(body);
                JsonArray playListInformationArray = object.getAsJsonObject("data").getAsJsonArray("items");
                if (playListInformationArray == null || playListInformationArray.size() == 0) {
                    this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                    this.setValue("--------------------------------------------------------------------------------------", 100);
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                ++page;
                if (playListInformationArray.size() < 100) {
                    flag = false;
                }
                ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                int i = 0;
                while (i < playListInformationArray.size()) {
                    String specificCode;
                    if (ProductAddDialog.getIsCanceled()) {
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    JsonObject data2 = playListInformationArray.get(i).getAsJsonObject();
                    if (specificCodes.size() <= 0 || !(specificCode = specificCodes.stream().filter(p -> p.equals(data2.get("managedCode").getAsString())).findFirst().orElse("")).equals("")) {
                        CategoryDTO category;
                        String name;
                        String code;
                        ProductDTO responseProduct = new ProductDTO();
                        responseProduct.setShopcd(shopInfo.getSHOPCD());
                        responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                        responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
                        responseProduct.setGoods_nm(JsonHelper.jsonNullStr(data2.get("goodsName")));
                        responseProduct.setCompayny_goods_cd(JsonHelper.jsonNullStr(data2.get("managedCode")));
                        responseProduct.setChar_1_nm("\ub2e8\ud488");
                        String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(responseProduct.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                        responseProduct.setGoods_keyword(codeDivision);
                        String end = JsonHelper.jsonNullStr(data2.get("dispEndDate"));
                        responseProduct.setSaleenddt(YDMATimeUtil.getDate2(end));
                        String time = JsonHelper.jsonNullStr(data2.get("createdDate"));
                        responseProduct.setInsertdt(YDMATimeUtil.getLondtoDate2(time.equals("") ? YDMATimeUtil.getCurrentTimeByYDFormat() : time));
                        responseProduct.setModifyid(responseProduct.getInsertdt());
                        if (shopInfo.getSHOPCD().equals("shop00671")) {
                            responseProduct.setQty(JsonHelper.jsonNullStr(data2.getAsJsonObject("stock").get("iac")));
                        } else {
                            responseProduct.setQty(JsonHelper.jsonNullStr(data2.getAsJsonObject("stock").get("gmkt")));
                        }
                        if (shopInfo.getSHOPCD().equals("shop00671")) {
                            code = JsonHelper.jsonNullStr(data2.getAsJsonObject("category").getAsJsonObject("site").getAsJsonObject("iac").get("catCode"));
                            name = JsonHelper.jsonNullStr(data2.getAsJsonObject("category").getAsJsonObject("site").getAsJsonObject("iac").get("catName"));
                            if (name.contains(">")) {
                                name = name.split(">")[0];
                            }
                            if ((category = CategoryDAO.get().selectShoppingMallCategory(code, name)) == null) {
                                category = CategoryDAO.get().selectCategory("350119000");
                                responseProduct.setClass_cd3(category.getCODE());
                                responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                                responseProduct.setGmcategnm(category.getFULL_NAME());
                            } else {
                                responseProduct.setClass_cd3(category.getCODE());
                                responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                                category = CategoryDAO.get().selectShoppingMallCategoryFullName(shopInfo.getSHOPCD(), code);
                                if (category == null) {
                                    category = CategoryDAO.get().selectCategory("350119000");
                                    responseProduct.setClass_cd3(category.getCODE());
                                    responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                                    responseProduct.setGmcategnm(category.getFULL_NAME());
                                } else {
                                    responseProduct.setGmcategnm(category.getFULL_NAME());
                                }
                            }
                            responseProduct.setShopprodno(JsonHelper.jsonNullStr(data2.getAsJsonObject("siteGoodsNo").get("iac")));
                            responseProduct.setSaleStatusCd(JsonHelper.jsonNullStr(data2.getAsJsonObject("sellStatus").get("iac")));
                            responseProduct.setStatus(this.getStatus(JsonHelper.jsonNullStr(data2.getAsJsonObject("sellStatus").get("iac"))));
                            responseProduct.setSendstats(this.getSendStatus(JsonHelper.jsonNullStr(data2.getAsJsonObject("sellStatus").get("iac"))));
                            responseProduct.setMarket_price(JsonHelper.jsonNullStr(data2.getAsJsonObject("price").get("iac")));
                            responseProduct.setGoods_price(JsonHelper.jsonNullStr(data2.getAsJsonObject("price").get("iac")));
                            responseProduct.setGoods_consumer_price(JsonHelper.jsonNullStr(data2.getAsJsonObject("price").get("iac")));
                        } else {
                            code = JsonHelper.jsonNullStr(data2.getAsJsonObject("category").getAsJsonObject("site").getAsJsonObject("gmkt").get("catCode"));
                            code = code.substring(code.length() - 9, code.length());
                            name = JsonHelper.jsonNullStr(data2.getAsJsonObject("category").getAsJsonObject("site").getAsJsonObject("gmkt").get("catName"));
                            if (name.contains(">")) {
                                name = name.split(">")[0];
                            }
                            if ((category = CategoryDAO.get().selectShoppingMallCategory(code, name)) == null) {
                                category = CategoryDAO.get().selectCategory("350119000");
                                responseProduct.setClass_cd3(category.getCODE());
                                responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                                responseProduct.setGmcategnm(category.getFULL_NAME());
                            } else {
                                responseProduct.setClass_cd3(category.getCODE());
                                responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                                category = CategoryDAO.get().selectShoppingMallCategoryFullName(shopInfo.getSHOPCD(), code);
                                if (category == null) {
                                    category = CategoryDAO.get().selectCategory("350119000");
                                    responseProduct.setClass_cd3(category.getCODE());
                                    responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                                    responseProduct.setGmcategnm(category.getFULL_NAME());
                                } else {
                                    responseProduct.setGmcategnm(category.getFULL_NAME());
                                }
                            }
                            responseProduct.setShopprodno(JsonHelper.jsonNullStr(data2.getAsJsonObject("siteGoodsNo").get("gmkt")));
                            responseProduct.setSaleStatusCd(JsonHelper.jsonNullStr(data2.getAsJsonObject("sellStatus").get("gmkt")));
                            responseProduct.setStatus(this.getStatus(JsonHelper.jsonNullStr(data2.getAsJsonObject("sellStatus").get("gmkt"))));
                            responseProduct.setSendstats(this.getSendStatus(JsonHelper.jsonNullStr(data2.getAsJsonObject("sellStatus").get("gmkt"))));
                            responseProduct.setMarket_price(JsonHelper.jsonElementNullInt(data2.getAsJsonObject("price").get("gmkt")));
                            responseProduct.setGoods_price(JsonHelper.jsonElementNullInt(data2.getAsJsonObject("price").get("gmkt")));
                            responseProduct.setGoods_consumer_price(JsonHelper.jsonElementNullInt(data2.getAsJsonObject("price").get("gmkt")));
                        }
                        responseProducts.add(responseProduct);
                        this.setValue(String.format(" %s [%s] \ubd88\ub7ec\uc624\ub294 \uc911..", shopInfoLog, responseProduct.getCompayny_goods_cd()), 0);
                    }
                    ++i;
                }
                if (responseProducts.size() > 0) {
                    this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", page, responseProducts.size()), 0);
                    for (ProductDTO product2 : responseProducts) {
                        int ret;
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            ret = ProductDAO.get().insertProductInfo(product2);
                            if (ret == 1) {
                                infoRet += ret;
                                String comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", product2.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product2, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        } else {
                            copyProduct.setClass_cd3(product2.getClass_cd3());
                            copyProduct.setShop_cid_info(product2.getShop_cid_info());
                            ret = 1;
                            if (ret == 1) {
                                infoRet += ret;
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product2.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret2 = ProductDAO.get().insertProductIn(product2);
                            if (ret2 == 1) {
                                inRet += ret2;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc5e0\ub9c1\ud06c\uc5d0 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        } else {
                            copyProductIn.setClass_cd3(product2.getClass_cd3());
                            copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                            copyProductIn.setGoods_nm(product2.getGoods_nm());
                            copyProductIn.setShopprodno(product2.getShopprodno());
                            copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product2.getSaleenddt());
                            copyProductIn.setMarket_price(product2.getMarket_price());
                            copyProductIn.setGoods_price(product2.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                            copyProductIn.setStatus(product2.getStatus());
                            copyProductIn.setSendstats(product2.getSendstats());
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret3 = 1;
                            if (ret3 == 1) {
                                inRet += ret3;
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product2.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                        }
                    }
                }
                start += limit;
                Thread.sleep(30000L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String errorMessage = ex.getMessage() != null ? ex.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
            this.setValue("--------------------------------------------------------------------------------------", 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    public String getJson(ShoppingmallDTO shopInfo, String siteID, String startDate, String endDate) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("\"Keyword\":\"\",");
        builder.append("\"SiteId\":\"" + siteID + "\",");
        builder.append("\"CategorySiteId\":-1,");
        builder.append("\"CategoryCode\":\"\",");
        builder.append("\"CategoryLevel\":\"\",");
        builder.append("\"TransPolicyNo\":0,");
        builder.append("\"StatusCode\":\"\",");
        builder.append("\"SearchDateType\":2,");
        builder.append("\"SearchStartDate\":\"" + startDate + "\",");
        builder.append("\"SearchEndDate\":\"" + endDate + "\",");
        builder.append("\"SellerId\":\"" + shopInfo.getSHOPPINGID() + "\",");
        builder.append("\"SellerSiteId\":\"" + siteID + "\",");
        builder.append("\"StockQty\":-1,");
        builder.append("\"SellPeriod\":0,");
        builder.append("\"DiscountUseIs\":-1,");
        builder.append("\"DeliveryFeeApplyType\":0,");
        builder.append("\"OptAddDeliveryType\":0,");
        builder.append("\"OptSelUseIs\":-1,");
        builder.append("\"PremiumEnd\":0,");
        builder.append("\"PremiumPlusEnd\":0,");
        builder.append("\"FocusEnd\":0,");
        builder.append("\"FocusPlusEnd\":0,");
        builder.append("\"GoodsIdType\":\"S\",");
        builder.append("\"GoodsIds\":\"\",");
        builder.append("\"ShopCateReg\":-1,");
        builder.append("\"IsTPLUse\":\"\",");
        builder.append("\"SellMinPrice\":0,");
        builder.append("\"SellMaxPrice\":0,");
        builder.append("\"OrderByType\":11,");
        builder.append("\"GroupOrderByType\":1,");
        builder.append("\"IsGroupUse\":\"\",");
        builder.append("\"IsApplyEpin\":\"\",");
        builder.append("\"IsConvertSingleGoods\":\"\"");
        builder.append("}");
        return builder.toString();
    }

    public String getJson(ShoppingmallDTO shopInfo, String siteID, String startDate, String endDate, List<String> specificCodes, int pageIndex, int pageSize) {
        JsonObject json = new JsonObject();
        JsonObject query = new JsonObject();
        query.addProperty("goodsIds", String.join((CharSequence)",", specificCodes));
        query.addProperty("keyword", "");
        JsonArray sellStatus = new JsonArray();
        sellStatus.add("11");
        sellStatus.add("01");
        query.add("sellStatus", (JsonElement)sellStatus);
        JsonArray siteSellerId = new JsonArray();
        JsonObject siteSeller = new JsonObject();
        siteSeller.addProperty("siteId", (Number)Integer.parseInt(siteID));
        siteSeller.addProperty("sellerId", shopInfo.getSHOPPINGID());
        siteSellerId.add((JsonElement)siteSeller);
        query.add("siteSellerId", (JsonElement)siteSellerId);
        query.add("category", (JsonElement)new JsonObject());
        query.add("registrationDate", (JsonElement)new JsonObject());
        query.add("shipping", (JsonElement)new JsonObject());
        query.add("additionalService", (JsonElement)new JsonArray());
        json.add("query", (JsonElement)query);
        json.addProperty("pageIndex", (Number)pageIndex);
        json.addProperty("pageSize", (Number)pageSize);
        json.addProperty("sortField", (Number)0);
        json.addProperty("sortOrder", (Number)1);
        return json.toString();
    }

    private String getStatus(String status2) {
        switch (status2) {
            case "01": 
            case "11": {
                return "0";
            }
            case "21": 
            case "22": {
                return "3";
            }
            case "31": {
                return "1";
            }
        }
        return "";
    }

    private String getSendStatus(String status2) {
        String value = "";
        switch (status2) {
            case "11": {
                value = String.valueOf(8000);
                break;
            }
            case "22": {
                value = String.valueOf(3000);
                break;
            }
            case "21": {
                value = String.valueOf(3000);
                break;
            }
            case "01": {
                value = String.valueOf(8000);
                break;
            }
            case "31": {
                value = String.valueOf(4000);
            }
        }
        return value;
    }

    @Override
    public ResultProcessDTO addProcess2(ProductAddProcessDTO proDto, List<String> specificCodes, IProgressMonitor monitor, ShoppingmallDTO dto) throws Exception {
        return null;
    }

    private void setValue(String message, int value) {
        CommonProgressDialog.get().setValue(message, value);
    }

    private void setValueProd(String title, int value, ProductDTO item, ShoppingmallDTO shopInfo, String jobType, String jobResult, String logMsg, boolean isProdIn) {
        CommonProgressDialog.get().setValueProd(title, value, item, shopInfo, jobType, jobResult, logMsg, isProdIn);
    }
}

