/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.data.cafe24.Cafe24AcessToken;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Cafe24ProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    private static final String content_type = "application/json";

    private static OkHttpClient getUnsafeOkHttpClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            return new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto, String jobType, String logMsg) throws Exception {
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        ProductDTO prodInfo = dto.getPRODUCT();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        boolean flag = false;
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 4100: {
                    flag = this.productSoldOut(shopInfo, prodInfo);
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\ud310\ub9e4\uc911\ub2e8", shopInfo, "\uc131\uacf5", "YEL_DIS_AUT", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\ub2e8 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    break;
                }
                case 4200: {
                    flag = this.productResumeSale(shopInfo, prodInfo);
                    break;
                }
                case 3000: 
                case 4000: {
                    Response response = this.productDelete(shopInfo, prodInfo);
                    if (!response.isSuccessful()) break;
                    dto.getPRODUCT().setShopprodno("");
                    this.logProductInDetail(shopInfoLog, dto.getPRODUCT(), "\uc0ad\uc81c", dto.getSHOPINFO(), "\uc131\uacf5", jobType, logMsg);
                }
            }
            dto.getPRODUCT().setResult_code("1");
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    private boolean productResumeSale(ShoppingmallDTO shopInfo, ProductDTO prodInfo) {
        return this.updateStatus(shopInfo, prodInfo, "F");
    }

    private boolean productSoldOut(ShoppingmallDTO shopInfo, ProductDTO prodInfo) {
        return this.updateStatus(shopInfo, prodInfo, "T");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateStatus(ShoppingmallDTO shopInfo, ProductDTO prodInfo, String stat) {
        JsonObject req = new JsonObject();
        req.addProperty("selling", stat);
        JsonObject obj = new JsonObject();
        obj.addProperty("shop_no", (Number)1);
        obj.add("request", (JsonElement)req);
        try {
            String token = Cafe24AcessToken.get().getAccessToken(shopInfo);
            String url = String.format("https://%s.cafe24api.com/api/v2/admin/products/%s", shopInfo.getSHOPPINGID(), prodInfo.getShopprodno());
            Request request2 = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + token).addHeader("Content-Type", content_type).put(RequestBody.create((MediaType)MediaType.parse((String)""), (String)obj.toString())).build();
            Throwable throwable = null;
            Object var10_12 = null;
            try (Response response = Cafe24ProductModifyService.getUnsafeOkHttpClient().newCall(request2).execute();){
                if (!response.isSuccessful()) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Response productDelete(ShoppingmallDTO shopInfo, ProductDTO prodInfo) throws Exception {
        Response response = this.useBearerToken(Cafe24AcessToken.get().getAccessToken(shopInfo), shopInfo, prodInfo);
        return response;
    }

    public Response useBearerToken(String bearerToken, ShoppingmallDTO shoppingMallDetailDto, ProductDTO shopProductDto) {
        Response response = null;
        try {
            String url = String.format("https://%s.cafe24api.com/api/v2/admin/products/%s", shoppingMallDetailDto.getSHOPPINGID(), shopProductDto.getShopprodno());
            Request request2 = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + bearerToken).addHeader("Content-Type", content_type).delete().build();
            response = Cafe24ProductModifyService.getUnsafeOkHttpClient().newCall(request2).execute();
            if (response.code() != 200) {
                shopProductDto.setResult_code("-1");
                throw new Exception("\uc0c1\ud488\uc0ad\uc81c\ub97c \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("Error : " + e.getMessage());
        }
        return response;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shopInfo, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        return true;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> loginCookie) throws Exception {
        return false;
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        return null;
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String jobType, String logMsg) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackProd(comment, 50, prodInfo, shoppingmallDTO, jobType, jobResult, logMsg, true);
    }
}

