/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.helper.LoginHelper;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class TossShoppingProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto, String jobType, String logMsg) throws Exception {
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        ProductDTO prodInfo = dto.getPRODUCT();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        boolean flag = true;
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 4100: {
                    flag = this.productSoldOut(prodInfo, shopInfo);
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\ud310\ub9e4\uc911\ub2e8", shopInfo, "\uc131\uacf5", "YEL_DIS_AUT", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\ub2e8 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    break;
                }
                case 4200: {
                    flag = this.productResumeSale(prodInfo, shopInfo);
                    if (flag) break;
                    return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                }
                case 3000: 
                case 4000: {
                    flag = this.DeleteProduct(shopInfo, prodInfo);
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\uc0ad\uc81c", shopInfo, "\uc131\uacf5", jobType, logMsg);
                }
            }
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    private boolean productSoldOut(ProductDTO shopProductDto, ShoppingmallDTO shoppingMallDetailDto) {
        return this.updateSellStatus(shopProductDto, shoppingMallDetailDto, true);
    }

    private boolean productResumeSale(ProductDTO shopProductDto, ShoppingmallDTO shoppingMallDetailDto) {
        return this.updateSellStatus(shopProductDto, shoppingMallDetailDto, false);
    }

    private boolean updateSellStatus(ProductDTO shopProductDto, ShoppingmallDTO shoppingMallDetailDto, boolean status2) {
        int merchantID;
        Map<String, String> cookies;
        block4: {
            try {
                cookies = LoginHelper.getTossCookies(shoppingMallDetailDto.getSHOPPINGID(), shoppingMallDetailDto.getPASSWORD());
                merchantID = 0;
                if (!shoppingMallDetailDto.getAPIKEY().isEmpty()) {
                    merchantID = Integer.parseInt(shoppingMallDetailDto.getAPIKEY());
                    break block4;
                }
                merchantID = LoginHelper.getTossMerchantID(cookies, shoppingMallDetailDto.getAUTHKEY1());
                if (merchantID != -99) break block4;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        JsonObject obj = new JsonObject();
        JsonArray productIds = new JsonArray();
        productIds.add(shopProductDto.getShopprodno());
        obj.add("productIds", (JsonElement)productIds);
        obj.addProperty("hide", Boolean.valueOf(status2));
        Connection.Response rs = Jsoup.connect((String)"https://api-public.toss.im/api-public/v2/shopping-internal/products/update-hide-status").header("Content-Type", "application/json").header("X-Merchant-Id", String.valueOf(merchantID)).cookies(cookies).requestBody(obj.toString()).method(Connection.Method.PUT).ignoreContentType(true).execute();
        JsonObject object = jsonParser.parse(rs.body()).getAsJsonObject();
        String resultType = object.get("resultType").getAsString();
        return resultType.equals("SUCCESS");
    }

    private boolean DeleteProduct(ShoppingmallDTO shoppingMallDetailDto, ProductDTO shopProductDto) {
        int merchantID;
        Map<String, String> cookies;
        block5: {
            cookies = LoginHelper.getTossCookies(shoppingMallDetailDto.getSHOPPINGID(), shoppingMallDetailDto.getPASSWORD());
            merchantID = 0;
            if (!shoppingMallDetailDto.getAPIKEY().isEmpty()) {
                merchantID = Integer.parseInt(shoppingMallDetailDto.getAPIKEY());
                break block5;
            }
            merchantID = LoginHelper.getTossMerchantID(cookies, shoppingMallDetailDto.getAUTHKEY1());
            if (merchantID != -99) break block5;
            return false;
        }
        try {
            DeleteJson deleteJson = new DeleteJson();
            deleteJson.productIds.add(Integer.parseInt(shopProductDto.getShopprodno()));
            String json = mapper.writeValueAsString((Object)deleteJson);
            Connection.Response rsPost = Jsoup.connect((String)"https://api-public.toss.im/api-public/v2/shopping-internal/products/delete/by-product-ids").header("Content-Type", "application/json").cookies(cookies).header("x-merchant-id", String.valueOf(merchantID)).method(Connection.Method.POST).timeout(15000).requestBody(json).ignoreContentType(true).execute();
            JsonObject object = jsonParser.parse(rsPost.body()).getAsJsonObject();
            if (object.get("resultType").getAsString().equals("SUCCESS")) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        return null;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingmallDTO, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        return false;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingmallDTO, Map<String, String> loginCookie) throws Exception {
        return false;
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String jobType, String logMsg) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackProd(comment, 50, prodInfo, shoppingmallDTO, jobType, jobResult, logMsg, true);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static final class DeleteJson {
        private List<Integer> productIds = new ArrayList<Integer>();

        private DeleteJson() {
        }
    }
}

