/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.ui;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.controls.ComboItem;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.yellim.shop.dao.ProductResultDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinProductGetDao;
import com.kdjsystem.mlink.yellim.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.YellimFreeInfomationDialog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DomeMallStatusUpdate {
    private Shell shell;
    static DomeMallStatusUpdate instance = new DomeMallStatusUpdate();
    DateTimeFormatter myFormatObj = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    static String LOGIN_HOST = "";

    public static DomeMallStatusUpdate get() {
        return instance;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void DomeMallProductInfoRecieve(ComboItem dto) throws Exception {
        LocalDateTime myDateObj = LocalDateTime.now();
        String formattedDate = myDateObj.format(this.myFormatObj);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date enduse = null;
        try {
            String yEnduseStr = YDMASessonUtil.getUserInfo().getY_enduse();
            String enduseStr = YDMASessonUtil.getUserInfo().getEnduse();
            if (yEnduseStr != null) {
                formatter.parse(yEnduseStr);
            }
            if (enduseStr != null) {
                enduse = formatter.parse(enduseStr);
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        Date today = new Date();
        YDMASessonUtil.getUserInfo().getY_pricetype();
        String pricetype = YDMASessonUtil.getUserInfo().getPricetype();
        if (enduse != null && pricetype != null && today.before(enduse) && this.isPriceType(pricetype)) {
            this.setValueBack("[" + dto.getDOMEINFO().getSHOPNM() + "] \uc0c1\ud488\uc815\ubcf4 \uc218\uc815\uc0ac\ud56d \uc218\uc9d1 \ucc98\ub9ac \uc2dc\uc791\ud569\ub2c8\ub2e4.", 0);
            if (MallCode.getTableName(dto.getCode()).equals("")) {
                return;
            }
            this.setValueBack("[" + dto.getDOMEINFO().getSHOPNM() + "] \uc218\uc815\uc0ac\ud56d \uc218\uc9d1 \uc911..", 0);
            Map<String, String> parameters = this.getProductQueryParameters(dto);
            String response = this.getFirstApiProduct(1, parameters);
            ProductResultDto productDome = MLinkCommon.get().getProductMapping(response, dto.getCode(), "0", "0");
            HashMap<String, ProductResultDto> resultProdList = new HashMap<String, ProductResultDto>();
            resultProdList.put("1", productDome);
            String title = String.format("[%s] \uc804\uccb4 %s \ud398\uc774\uc9c0, \ucd1d %s\uac74\uc744 \ub3c4\ub9e4\ubab0\uc5d0\uc11c \ubd88\ub7ec\uc624\ub294 \uc911\uc785\ub2c8\ub2e4.", dto.getDOMEINFO().getSHOPNM(), productDome.total_page, productDome.total_count);
            this.setValueBack(title, 0);
            this.setValueBack(String.format("[%s] (%s) \ud398\uc774\uc9c0 \uc218\uc2e0 \uc644\ub8cc ", dto.getDOMEINFO().getSHOPNM(), productDome.current_page), 0);
            this.finshDataUpdate(dto.getDOMEINFO().getSHOPNM(), resultProdList);
            if (!productDome.total_page.equals("1") && !productDome.total_page.equals("0")) {
                int totalpage = YDMAStringUtil.convertToInt(productDome.total_page);
                int k = 2;
                while (k <= totalpage) {
                    response = this.getApiProduct(k, parameters);
                    productDome = MLinkCommon.get().getProductMapping(response, dto.getCode(), "0", "0");
                    resultProdList.put(productDome.current_page, productDome);
                    this.setValueBack(String.format("[%s] (%s) \ud398\uc774\uc9c0 \uc218\uc2e0 \uc644\ub8cc ", dto.getDOMEINFO().getSHOPNM(), productDome.current_page), 0);
                    this.finshDataUpdate(dto.getDOMEINFO().getSHOPNM(), resultProdList);
                    ++k;
                }
            }
            this.setValueBack("[" + dto.getDOMEINFO().getSHOPNM() + "] 6\uc2dc\uac04 \ud6c4 \ub2e4\uc2dc \uc2e4\ud589\ud569\ub2c8\ub2e4. (" + formattedDate + ")", 0);
        } else {
            this.setValueBack("\uad6c\ub3c5 \uae30\uac04\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 0);
            this.showYellimFreeInformationDialog();
        }
    }

    private Map<String, String> getProductQueryParameters(ComboItem dome) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Date today = new Date();
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd", Locale.KOREA);
        Calendar cal = Calendar.getInstance();
        cal = Calendar.getInstance();
        cal.add(5, -1);
        dome.setSTART_DATE(format1.format(cal.getTime()));
        cal.setTime(today);
        dome.setEND_DATE(format1.format(cal.getTime()));
        parameters.put("V_DOME", MallCode.getTableName(dome.getCode()));
        parameters.put("V_SDATE", String.valueOf(dome.getSTART_DATE()) + " 00:00:00");
        parameters.put("V_EDATE", String.valueOf(dome.getEND_DATE()) + " 23:59:59");
        return parameters;
    }

    private String getFirstApiProduct(int page, Map<String, String> parameters) throws Exception {
        String path = "/api/v1/b2bmall/updatefind";
        PreferencesMallDTO dto1 = ShopCommonDao.get().getSystemConf();
        LOGIN_HOST = dto1.getURL_PRODRECV();
        parameters.put("V_PAGE", String.valueOf(page));
        String postForm = MLinkCommon.get().convertToJson(parameters);
        String result = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            URIBuilder uriBuilder = new URIBuilder().setPath(LOGIN_HOST.concat(path));
            StringEntity params = new StringEntity(postForm, "UTF-8");
            client = HttpClients.createDefault();
            HttpPost requestPatch = new HttpPost(uriBuilder.build().toString());
            requestPatch.addHeader("content-type", "application/json");
            requestPatch.setEntity((HttpEntity)params);
            response = client.execute((HttpUriRequest)requestPatch);
            int status2 = response.getStatusLine().getStatusCode();
            response.getStatusLine().getReasonPhrase();
            if (status2 == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                result = resObject.toString();
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return result;
    }

    private String getApiProduct(int page, Map<String, String> parameters) throws Exception {
        String path = "/api/v1/b2bmall/updatefind";
        PreferencesMallDTO dto1 = ShopCommonDao.get().getSystemConf();
        LOGIN_HOST = dto1.getURL_PRODRECV();
        parameters.put("V_PAGE", String.valueOf(page));
        String postForm = MLinkCommon.get().convertToJson(parameters);
        String result = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            URIBuilder uriBuilder = new URIBuilder().setPath(LOGIN_HOST.concat(path));
            StringEntity params = new StringEntity(postForm, "UTF-8");
            client = HttpClients.createDefault();
            HttpPost requestPatch = new HttpPost(uriBuilder.build().toString());
            requestPatch.addHeader("content-type", "application/json");
            requestPatch.setEntity((HttpEntity)params);
            response = client.execute((HttpUriRequest)requestPatch);
            int status2 = response.getStatusLine().getStatusCode();
            response.getStatusLine().getReasonPhrase();
            if (status2 == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                result = resObject.toString();
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return result;
    }

    private void finshDataUpdate(String domeName, Map<String, ProductResultDto> resultProdList) {
        for (String key : resultProdList.keySet()) {
            List<ProductItemDto> list;
            block8: {
                LocalDateTime myDateObj = LocalDateTime.now();
                myDateObj.format(this.myFormatObj);
                List<ProductItemDto> items = resultProdList.get((Object)key).items;
                if (items.size() == 0) {
                    this.setValueBack(String.format("[%s] (%s) \uc0c1\ud488\uc815\ubcf4 \uc218\uc815\uc0ac\ud56d\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.", domeName, key), 0);
                    continue;
                }
                this.setValueBack(String.format("[%s] (%s) \uc0c1\ud488\uc815\ubcf4 \ubc18\uc601 \uc911..", domeName, key), 0);
                String query = items.stream().map(p -> String.format("SELECT '%s' AS ICODE,'%s' AS MODIFYID  \r\n", p.getIcode(), p.getUp_datetime())).collect(Collectors.joining(" UNION ALL ", "WITH CTE_PRODLIST AS( ", ")"));
                list = DomesinProductGetDao.get().getModifyProduct(items, query, 0);
                if (list != null) break block8;
                this.setValueBack(String.format("[%s] (%s) \uc0c1\ud488\uc815\ubcf4\uac00 \uc5e0\ub9c1\ud06c\uc5d0 \uc774\ubbf8 \uc218\uc815\ub418\uc5c8\uac70\ub098 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", domeName, key), 0);
                resultProdList.remove(key);
                continue;
            }
            try {
                try {
                    for (ProductItemDto item : list) {
                        String text_modify = String.format(" [%s] [%s] %s\n \u2192 \uc0c1\ud488\uc815\ubcf4\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", domeName, item.getIcode(), item.getIname());
                        this.setValueBack(text_modify, 50);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    resultProdList.remove(key);
                    continue;
                }
            }
            catch (Throwable throwable) {
                resultProdList.remove(key);
                throw throwable;
            }
            resultProdList.remove(key);
        }
    }

    private boolean isPriceType(String priceType) {
        return priceType.equals("1") || priceType.equals("2") || priceType.equals("3") || priceType.equals("4") || priceType.equals("5") || priceType.equals("6");
    }

    public void showYellimFreeInformationDialog() {
        Display display = Display.getCurrent() != null ? Display.getCurrent() : new Display();
        Shell dialogShell = this.shell == null || this.shell.isDisposed() ? new Shell(display) : this.shell;
        YellimFreeInfomationDialog dialog = new YellimFreeInfomationDialog(dialogShell);
        dialog.open();
    }

    private void setValueBack(String message, int value) {
        CommonProgressDialog.get().setValueBack(message, value);
    }
}

