/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.ui;

import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.controls.ComboItem;
import com.kdjsystem.mlink.yellim.ui.DomeMallStatusUpdate;
import com.kdjsystem.mlink.yellim.ui.DomeWorkDataQueue;
import java.nio.channels.CompletionHandler;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class DomeWorkBackground
extends Thread {
    private static DomeWorkBackground instance = new DomeWorkBackground();
    public CompletionHandler<ComboItem, ComboItem> callback = new CompletionHandler<ComboItem, ComboItem>(){

        @Override
        public void completed(ComboItem result, ComboItem attachment) {
            try {
                DomeWorkDataQueue.get().notifyObservers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void failed(Throwable exc, ComboItem attachment) {
        }
    };

    private DomeWorkBackground() {
    }

    public static DomeWorkBackground get() {
        return instance;
    }

    public void startBackground() {
        Thread.State state = this.getState();
        if (state == Thread.State.NEW) {
            this.setDaemon(true);
            this.start();
            YDMAStringUtil.Print("\uc2a4\ub808\ub4dc \uc2dc\uc791");
        }
    }

    private Runnable getRunnableRegister(ComboItem dome) {
        Runnable run = () -> {
            try {
                DomeMallStatusUpdate.get().DomeMallProductInfoRecieve(dome);
                this.callback.completed(dome, dome);
            }
            catch (Exception exception) {}
        };
        return run;
    }

    @Override
    public void run() {
        while (true) {
            ExecutorService executorService = DomeWorkDataQueue.get().getExecutorService();
            try {
                Thread.sleep(3000L);
                List<ComboItem> dome = DomeWorkDataQueue.get().getWaitData();
                if (dome == null) continue;
                for (ComboItem dome2 : dome) {
                    executorService.submit(this.getRunnableRegister(dome2));
                }
                executorService.awaitTermination(360L, TimeUnit.MINUTES);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

